{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*                 MXD    Mathematical    function    Module                   *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_MATH;


 %include 'MXDSRC:mxd_env';                     { Load the mxd global environment }




[global]
var
  math_err:             integer :=           0; { Last MATH Error number }




function IIPOWER( x, n: integer ): integer;
var
  r: integer;

begin
  r := 1;
  n := ABS( n );
  while n > 0 do
    if ODD( n ) then
    begin
      n := n - 1; r := r * x
    end
    else
    begin
      n := n div 2; x := SQR( x )
    end;
  IIPOWER := r
end IIPOWER;



(*
[global]
procedure CREATE_FLT_ARRAY( fa: obj_ref; sz: integer );
var
  mr: mrd_ptr;
  rf: rfd_ptr;

begin
  { Build the coefficient table definition }
  NEW( mr );                       { Allocate a record descriptor }
  NEW( rf );                       { and a field descriptor }
  with rf^ do
  begin
    rfd_nxt := nil;                { No next field for an array }
    rfd_mrd := mr;                 { Reverse link to record the descriptor }
    rfd_atm := nil;                { No field descriptor for array }
    rfd_off := 0;                  { Offset is always 0 }
    rfd_dim := sz;                 { Set the numeric table size }
    rfd_typ.flg := flg_def;        { Set the LISP_FLOAT type (double) }
    rfd_typ.typ := flty;
    rfd_typ.flt := 0.0
  end;
  sz := sz*size_doub;              { Get the size in bytes }
  with fa.at^, mr^ do
  begin
    mrd_nxt      := mrd_alloc;     { Link with previously defined descr. }
    mrd_alloc    := mr;
    mrd_atm      := fa.at;         { Set the identifier link }
    mrd_rfdl     := rf;            { and the field descriptor link }
    mrd_size     := sz;            { Set the total size of record in byte }
    mrd_algn     := algn_doub;     { and the related alignement }
    fncref.flg.k := dre_funct;     { Set the atom as an array atom }
    fncref.typ   := mrdty;         { Set the descriptor record acc. fnc type }
    fncref.mrd   := mr;
    val.typ := mrecty;             { Set the allocation }
    { Set the array address in the descriptor }
    val.rec := NEW_RECORD_ALLOC( sz ) { Allocate the array }
  end
end CREATE_FLT_ARRAY;




[global]
procedure GET_REC_ARRAY( var lp: obj_ref;    rty: obj_type;
                         var bl: rec_ptr; var sz: integer   );
const
  mdnam = 'GRAR';
var
  rf: rfd_ptr;
  fa: obj_ref;

begin
  fa := GET_ATOM( NXT_PAR( lp ), true );  { Get the record array identifier }
  with fa.at^ do
  begin
    if (fncref.typ <> mrdty) or (val.typ <> mrecty) then
      EXEC_ERROR( mdnam, 999, e_severe );
    bl := val.rec;                        { Get the record pointer }
    rf := fncref.mrd^.mrd_rfdl
  end;
  with rf^ do
  begin
    if rfd_atm <> nil then EXEC_ERROR( mdnam, 999, e_severe );
    if rfd_typ.typ <> rty then EXEC_ERROR( mdnam, 999, e_severe );
    sz := rfd_dim
  end
end GET_REC_ARRAY;
*)


[global]
procedure MATH_BESSEL_JDER( var dbjn, bjn: mxd_flt; x: mxd_flt; n: integer );
{ Computing of bessel function and derivate for modulated position }
const
  fact = 0.79788456;
  pis2 = 1.57079633;
  pis4 = 0.78539816;

var
  r, rpn, i: integer;
  b1, cf, b, bp, pw0, pw1, ob: mxd_flt;

begin { FBJN }
  if x < 15.0 then
  begin
    x  := x/2.0;
    cf := 1.0;
    for i := 2 to n do cf := cf/i ;
    b := cf; cf := cf/(n + 1); bp := 0.0;
    r := 1; rpn := n + 1;
    repeat
      ob := b;
      cf := - cf*x; bp := bp + r*cf; cf := cf*x;
      b  := b + cf; rpn := rpn + 1;
      cf := cf/rpn;
      r  := r + 1; cf := cf/r
    until ob = b;
    if n = 0 then
    begin
      pw0 := 0.0; pw1 := 1.0;
    end else
    begin
      pw0 := x**(n-1); pw1 := pw0*x;
    end;
    bjn := pw1*b;
    dbjn := n*pw0*b*0.5 + pw1*bp
  end
  else
  begin
    b1 := x - pis4 - n*pis2; bp := fact/SQRT( x );
    ob := COS( b1 )*bp;
    bjn := ob;
    dbjn := - (ob/(2.0*x) + bp*SIN( b1 ))
  end
end MATH_BESSEL_JDER;



[global]
function  MATH_BESSEL_J( rn: integer; rv: mxd_flt ): mxd_flt;
{ Computing of bessel function and derivate for modulated position }
var
  re, dr: mxd_flt;

begin
  MATH_BESSEL_JDER( dr, re, rv, rn );
  MATH_BESSEL_J := re
end MATH_BESSEL_J;



[global]
function  MATH_BESSEL_JHDER( var dbjn, bjn: mxd_flt; x: mxd_flt; nm2: integer ): mxd_flt;
{ Computing of bessel (n half integer) function and derivate for modulated position }
begin
  MATH_BESSEL_JHDER := 0.0
end MATH_BESSEL_JHDER;



[global]
function  MATH_BESSEL_JH( rn, rv: mxd_flt ): mxd_flt;
var
  re: mxd_flt;

begin
  re := 0.0;

  MATH_BESSEL_JH := re
end MATH_BESSEL_JH;



function  MATH_GAMMALN( x: mxd_flt ): mxd_flt;
var
  i:           integer;
  x1, t, s:    mxd_flt;
  ct: [static] array[1..6] of mxd_flt := (
             76.18009172947146, -86.50532032941677,
             24.01409824083091, -1.231739572450155,
         0.1208650973866179E-2, -0.5395239384953E-5 );

begin
  x1 := x;
  t  := x1 + 5.5;
  t  := t - (x + 0.5)*LN( t );
  s  := 1.000000000190015E+00;
  for i := 1 to 6 do
  begin
    x1 := x1 + 1.0;
    s  := s  + ct[i]/x1
  end;
  MATH_GAMMALN := LN( 2.5066282746310005*s/x ) - t
end MATH_GAMMALN;




[global]
function  MATH_L_GAMMA( xx: mxd_flt ): mxd_flt;
begin
  MATH_L_GAMMA := EXP( MATH_GAMMALN( ABS( xx ) ) )
end MATH_L_GAMMA;



function  MATH_TABLE_LOCATE( in_var ftab: val_afl; xx: mxd_flt ): integer;
{ Locate the xx absciss in the tabme ftab (x is locate in the odd indicies and y in the even indicies.
  The table size (val_all) is always even.
}
var
  jl ,jm, ju:  integer;

begin
  with ftab do
  if val_all > 2 then
  begin
    jl := 1;
    ju := val_all div 2 + 1;
    while ju - jm > 1 do
    begin
      jm := (ju + jl) div 2;
      if xx > val_ftb[2*jm-1] then jl := jm
                              else ju := jm
    end
  end
  else jl := 1;
  MATH_TABLE_LOCATE := jl
end MATH_TABLE_LOCATE;


procedure MATH_GET_TAB_POINT( in_var ftab: val_afl; nc: integer; var xx, yy: mxd_flt );
var


begin
  with ftab do
  begin
    xx := val_ftb[nc*2-1]; yy := val_ftb[nc*2]
  end
end MATH_GET_TAB_POINT;



[global]
function  MATH_INTERPOL( in_var ftab: val_afl; xx: mxd_flt ): mxd_flt;
{ Perform an Interpolation of the A-list Table }
const
  mdnam = 'ITPO';

var
  c1, c2, c3, r1, r2, re,
  x1, x2, x3, x4, y1, y2, y3, y4: mxd_flt;
  ip, nn:  integer;

begin { MATH_INTERPOL }
  re := 0.0;
  math_err := 0;
  with ftab do
  begin
    nn  := val_all div 2;
    if nn > 1 then
    begin { Check for extrapolation }
      if (xx < val_ftb[1]) or (xx > val_ftb[val_all-1]) then
      begin { Check for large extrapolation }
        x1 := val_ftb[1]; x2 := val_ftb[val_all-1];
        if xx < x1 then x3 := ABS( (x1 - xx)/(x2 - x1) )
                   else x3 := ABS( (xx - x2)/(x2 - x1) );
        if x3 > 0.01 then
          if x3 > 0.1 then math_err := 2
                      else math_err := 1
      end
    end;

    if nn >= 4 then
    begin
      if ip > 4 then
      begin
        ip := MATH_TABLE_LOCATE( ftab, xx );
        if ip < 2 then ip := 2
                  else if ip > nn-2 then ip := nn-2
      end else ip := 2;
      MATH_GET_TAB_POINT( ftab, ip-1, x1, y1 );
      MATH_GET_TAB_POINT( ftab,   ip, x2, y2 );
      MATH_GET_TAB_POINT( ftab, ip+1, x3, y3 );
      MATH_GET_TAB_POINT( ftab, ip+2, x4, y4 );
      { Four points interpolation }
      r1 := (y1 - y2)/(x1 - x2);
      r2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
      c3 := (r2 - (r1 - (y1 - y4)/(x1 - x4))/(x2 - x4))/(x3 - x4);
      c2 := r2 - (x1 + x2 + x3)*c3;
      c1 := r1 - (x1 + x2)*c2 - (x1*x1 + x1*x2 + x2*x2)*c3;
      re := y1 - x1*(c1 + x1*(c2 + x1*c3)) + xx*(c1 + xx*(c2 + xx*c3))
    end
    else
    begin
      if nn > 0 then
      begin
        MATH_GET_TAB_POINT( ftab, 1, x1, y1 );
        if nn > 1 then
        begin
          MATH_GET_TAB_POINT( ftab, 2, x2, y2 );
          if nn > 2 then MATH_GET_TAB_POINT( ftab, 3, x3, y3 )
        end
      end;
      case nn of
        3: begin
             r1 := (y1 - y2)/(x1 - x2);
             c2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
             c1 := r1 - (x1 + x2)*c2;
             re := y1 - x1*(c1 + x1*c2) + xx*(c1 + xx*c2)
           end;
        2: re := y1 + (xx - x1)*(y1 - y2)/(x1 - x2);
        1: re := y1;
      otherwise
        re := 0.0
      end
    end
  end;
  MATH_INTERPOL := re
end MATH_INTERPOL;




procedure INTGR_GAUSS_LEGENDRE( n:           integer;
                                eps, va, vb: mxd_flt;
                                var bl:      val_afl );
var
  i, ip, j, jp: integer;
  e, c1, c2, c3, cder, xm, xl, x, w: mxd_flt;

begin
  xm := 0.5*(vb + va);
  xl := 0.5*(vb - va);
  ip := 1;
  jp := 2*n;
  for i := 1 to (n + 1) div 2 do
  begin
    x := COS( pi*(i - 0.25)/(n + 0.5) );
    repeat
      c1 := 1.0;
      c2 := 0.0;
      for j := 1 to n do
      begin
        c3 := c2; c2 := c1;    { Pn-1 -> pn-2, Pn -> Pn-1 }
        c1 := ((2.0*j - 1.0)*x*c2 - (j - 1.0)*c3)/j
      end;
      cder := n*(x*c1 - c2)/(SQR( x ) - 1.0);
      e := x;
      x := e - c1/cder
    until ABS( x - e ) <= eps;
    w := 2.0*xl/((1.0 - SQR( x ))*SQR( cder ));
    bl.val_ftb[ip] := w;
    bl.val_ftb[jp] := xm + xl*x;
    ip := ip + 1;
    jp := jp - 1;
    bl.val_ftb[ip] := xm - xl*x;
    bl.val_ftb[jp] := w;
    ip := ip + 1;
    jp := jp - 1
  end
end INTGR_GAUSS_LEGENDRE;




procedure INTGR_GAUSS_LAGUERRE( n:       integer;
                                al, eps: mxd_flt;
                                var bl:  val_afl );
const
  mdnam = 'INTL';
  maxit =    500;

var
  i, ip, it, j: integer;
  c0, c1, c2, c3, pder, x, x1: mxd_flt;

begin
  ip := 1;
  for i := 1 to n do
  begin
    case i of
      1: x := (1.0 + al)*(3.0 + 0.92*al)/(1.0 + 2.4*n + 1.8*al);
      2: x := x + (15.0 + 6.25*al)/(1.0 + 0.9*al + 2.5*n);
    otherwise
      c0 := i - 2;
      x  := x + ((1.0 + 2.55*c0)/(1.9*c0) + 1.26*c0*al/(1.0 + 3.5*c0))*
                (x - bl.val_ftb[ip - 2])/(1.0 + 0.3*al)
    end;
    it := 0;
    repeat
      c1 := 1.0;
      c2 := 0.0;
      for j := 1 to n do
      begin
        c3 := c2;
        c2 := c1;
        c1 := ((2*j - 1 + al - x)*c2 - (j - 1 + al)*c3)/j
      end;
      pder := (n*c1 - (n + al)*c2)/x;
      x1 := x;
      x  := x1 - c1/pder;
      it := it + 1
    until (it > maxit) or (ABS( x - x1 ) < eps);
    if it > maxit then math_err := 3;
    bl.val_ftb[ip] := -EXP( MATH_GAMMALN( al + n )
                            - MATH_GAMMALN( double( n ) ) )/(pder*n*c2);
    ip := ip + 1;
    bl.val_ftb[ip] := x;
    ip := ip + 1
  end
end INTGR_GAUSS_LAGUERRE;




procedure INTGR_GAUSS_HERMITE(  n:      integer;
                                ep:     mxd_flt;
                                var bl: val_afl );
const
  mdnam = 'INTH';
  maxit  = 500;
  uspir4 = 0.7511255444649425E+00;

var
  i, ip, it, j, jp: integer;
  c1, c2, c3, pder, x, x1: mxd_flt;

begin
  ip := 1;
  jp := 2*n;
  for i := 1 to (n + 1) div 2 do
  begin 
    case i of
      1: begin
           x1 := 2*n + 1;
           x  := SQRT( x1 ) - 1.85575*EXP( -1.6667*LN( x1 ) )
         end;

      2: begin
           x1 := n;
           x  := x - 1.14*EXP( 0.426*LN( x1 ) )/x
         end;

      3: x := 1.86*x - 0.86*bl.val_ftb[1];      { Compute 3-th root from the first one }

      4: x := 1.91*x - 0.91*bl.val_ftb[3];      { Compute 4-th root form the second one}

    otherwise
      x := 2.0*x - bl.val_ftb[ip - 2]           { Compute the i-th x from the i-2-th x }
    end;

    it := 0;
    repeat
      c1 := uspir4;
      c2 := 0.0;
      for j := 1 to n do
      begin
        c3 := c2;
        c2 := c1;
        c1 := j;
        c1 := x*SQRT( 2.0/c1 )*c2 - SQRT( (c1 - 1.0)/c1 )*c3
      end;
      pder := SQRT( 2.0*n )*c2;
      x1   := x;
      x    := x1 - c1/pder;
      it := it + 1
    until (ABS( x1 - x ) < ep) or (it > maxit);
    if it > maxit then math_err := 4;
    pder := 2.0/SQR( pder );
    bl.val_ftb[ip] := pder;
    bl.val_ftb[jp] := x;
    ip := ip + 1;
    jp := jp - 1;
    bl.val_ftb[ip] := -x;
    bl.val_ftb[jp] := pder;
    ip := ip + 1;
    jp := jp - 1
  end
end INTGR_GAUSS_HERMITE;




[global]
procedure MATH_GAUSS_INTEGR_BLDTAB( var ftab: val_afl; va, vb, ep: mxd_flt; ik: integer := 0 );
var
  nn: integer;

begin
  math_err := 0;
  with ftab do
  begin
    nn := val_all div 2;
    if nn < 5 then math_err := 5
    else
      case ik of
        1: { GAUSS LAGUERRE }
          begin
            if va = maxint then va := 1.0;    { Get the alpha laguerre coef }
            INTGR_GAUSS_LAGUERRE( nn, va, ep, ftab )
          end;

        2: { GAUSS HERMITE }
          INTGR_GAUSS_HERMITE( nn, ep, ftab );

      otherwise
        { Default to GAUSS LEGENDRE }
        if vb <= va then vb := va + 1.0;
        INTGR_GAUSS_LEGENDRE( nn, ep, va, vb, ftab )
      end
  end
end MATH_GAUSS_INTEGR_BLDTAB;



end MXD_MATH.
