/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 304 ) = {
  7,   7, 105, 105, 112, 111, 119, 101, 114,  51,  51,  47, 104, 111, 109, 101,
 47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  99, 112,
115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95, 115, 114,
 99,  47, 109, 120, 100,  95, 109,  97, 116, 104,  46, 112,  97, 115,  16,  16,
109,  97, 116, 104,  95,  98, 101, 115, 115, 101, 108,  95, 106, 100, 101, 114,
 13,  13, 109,  97, 116, 104,  95,  98, 101, 115, 115, 101, 108,  95, 106,  17,
 17, 109,  97, 116, 104,  95,  98, 101, 115, 115, 101, 108,  95, 106, 104, 100,
101, 114,  14,  14, 109,  97, 116, 104,  95,  98, 101, 115, 115, 101, 108,  95,
106, 104,  12,  12, 109,  97, 116, 104,  95, 103,  97, 109, 109,  97, 108, 110,
 12,  12, 109,  97, 116, 104,  95, 108,  95, 103,  97, 109, 109,  97,  17,  17,
109,  97, 116, 104,  95, 116,  97,  98, 108, 101,  95, 108, 111,  99,  97, 116,
101,  18,  18, 109,  97, 116, 104,  95, 103, 101, 116,  95, 116,  97,  98,  95,
112, 111, 105, 110, 116,  13,  13, 109,  97, 116, 104,  95, 105, 110, 116, 101,
114, 112, 111, 108,  20,  20, 105, 110, 116, 103, 114,  95, 103,  97, 117, 115,
115,  95, 108, 101, 103, 101, 110, 100, 114, 101,  20,  20, 105, 110, 116, 103,
114,  95, 103,  97, 117, 115, 115,  95, 108,  97, 103, 117, 101, 114, 114, 101,
 19,  19, 105, 110, 116, 103, 114,  95, 103,  97, 117, 115, 115,  95, 104, 101,
114, 109, 105, 116, 101,  24,  24, 109,  97, 116, 104,  95, 103,  97, 117, 115,
115,  95, 105, 110, 116, 101, 103, 114,  95,  98, 108, 100, 116,  97,  98,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 48 ) = {
  9,  23, 118, 159, 134,  11,  83,  64,  85,  54,  20,  43,  87, 160,  85, 192,
198,  76,  59, 241, 155,   3,  56,  64, 139, 204, 205, 141,  52, 181, 243, 191,
218,  18, 236,  25, 115, 205,  83,  63, 139, 152,  14,  28,  24, 161, 214, 190
};

/* Declaration of global variables. */
SL V_math_err = 0;



/* Procedure/Function : " iipower "  */
SL MXD_MATH_iipower(SL F_x, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rgi;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=115; /* line # 115 */
  Rv0=1;
  Ra.sl[3]=116; /* line # 116 */
  F_n=abs(F_n);
  Ra.sl[3]=117; /* line # 117 */
  while (F_n>0){
    Ra.sl[3]=118; /* line # 118 */
    if (F_n&1) {
      Ra.sl[3]=120; /* line # 120 */
      F_n=F_n-1;
      Rv0=Rv0*F_x;
    }
    else {
      Ra.sl[3]=124; /* line # 124 */
      F_n=F_n/2;
      F_x=F_x*F_x;
    }
  }
  Ra.sl[3]=126; /* line # 126 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_bessel_jder "  */
void P_math_bessel_jder(G *F_dbjn, G *F_bjn, G F_x, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;
  SL Rv4;
  SL Rv5;
  G Rv6;
  G Rv7;
  G Rv8;
  G Rv9;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+62;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=215; /* line # 215 */
  if (F_x<1.500000000000000E+001) {
    Ra.sl[3]=217; /* line # 217 */
    F_x=F_x/2.000000000000000E+000;
    Ra.sl[3]=218; /* line # 218 */
    Rv0=1.000000000000000E+000;
    Ra.sl[3]=219; /* line # 219 */
    Rv1=2;
    for( Rf0=F_n-1;Rf0>0;Rf0-- ) {
      Rv0=Rv0/(double)Rv1;
      Rv1++;
    }
    Ra.sl[3]=220; /* line # 220 */
    Rv2=Rv0;
    Rv0=Rv0/(double)(F_n+1);
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=221; /* line # 221 */
    Rv4=1;
    Rv5=F_n+1;
    while (1){
      Ra.sl[3]=223; /* line # 223 */
      Rv6=Rv2;
      Ra.sl[3]=224; /* line # 224 */
      Rv0=-Rv0*F_x;
      Rv3=Rv3+(double)Rv4*Rv0;
      Rv0=Rv0*F_x;
      Ra.sl[3]=225; /* line # 225 */
      Rv2=Rv2+Rv0;
      Rv5=Rv5+1;
      Ra.sl[3]=226; /* line # 226 */
      Rv0=Rv0/(double)Rv5;
      Ra.sl[3]=227; /* line # 227 */
      Rv4=Rv4+1;
      Rv0=Rv0/(double)Rv4;
      if (Rv6==Rv2)  break;
    }
    Ra.sl[3]=229; /* line # 229 */
    if (F_n==0) {
      Ra.sl[3]=231; /* line # 231 */
      Rv7=0.000000000000000E-001;
      Rv8=1.000000000000000E+000;
    }
    else {
      Ra.sl[3]=234; /* line # 234 */
      Rv7=PAS__IGPOWER(F_x,F_n-1);
      Rv8=Rv7*F_x;
    }
    Ra.sl[3]=236; /* line # 236 */
    (*F_bjn)=Rv8*Rv2;
    Ra.sl[3]=237; /* line # 237 */
    (*F_dbjn)=(((double)F_n*Rv7)*Rv2)*5.000000000000000E-001+Rv8*Rv3;
  }
  else {
    Ra.sl[3]=241; /* line # 241 */
    Rv9=(F_x-7.853981599999998E-001)-(double)F_n*1.570796330000000E+000;
    Rv3=7.978845599999998E-001/sqrt(F_x);
    Ra.sl[3]=242; /* line # 242 */
    Rv6=cos(Rv9)*Rv3;
    Ra.sl[3]=243; /* line # 243 */
    (*F_bjn)=Rv6;
    Ra.sl[3]=244; /* line # 244 */
    (*F_dbjn)=-(Rv6/(2.000000000000000E+000*F_x)+Rv3*sin(Rv9));
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " math_bessel_j "  */
G P_math_bessel_j(SL F_rn, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+80;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=257; /* line # 257 */
  P_math_bessel_jder(&Rv0, &Rv1, F_rv, F_rn);
  Ra.sl[3]=258; /* line # 258 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_bessel_jhder "  */
G P_math_bessel_jhder(G *F_dbjn, G *F_bjn, G F_x, SL F_nm2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=267; /* line # 267 */
  Ret=0.000000000000000E-001;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_bessel_jh "  */
G P_math_bessel_jh(G F_rn, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+114;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=278; /* line # 278 */
  Rv0=0.000000000000000E-001;
  Ra.sl[3]=280; /* line # 280 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_gammaln "  */
G MXD_MATH_math_gammaln(G F_x){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  G Rv2;
  SL Rv3;
  register int Rf0;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+130;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=295; /* line # 295 */
  Rv0=F_x;
  Ra.sl[3]=296; /* line # 296 */
  Rv1=Rv0+5.500000000000000E+000;
  Ra.sl[3]=297; /* line # 297 */
  Rv1=Rv1-(F_x+5.000000000000000E-001)*log(Rv1);
  Ra.sl[3]=298; /* line # 298 */
  Rv2=1.000000000190015E+000;
  Ra.sl[3]=299; /* line # 299 */
  Rv3=1;
  for( Rf0=6;Rf0>0;Rf0-- ) {
    Ra.sl[3]=301; /* line # 301 */
    Rv0=Rv0+1.000000000000000E+000;
    Ra.sl[3]=302; /* line # 302 */
    Rv2=Rv2+Ri.g[Rv3-1]/Rv0;
    Rv3++;
  }
  Ra.sl[3]=304; /* line # 304 */
  Ret=log((2.506628274631000E+000*Rv2)/F_x)-Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_l_gamma "  */
G P_math_l_gamma(G F_xx){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+144;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=313; /* line # 313 */
  Ret=exp(MXD_MATH_math_gammaln(fabs(F_xx)));
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_table_locate "  */
SL MXD_MATH_math_table_locate(V F_ftab, G F_xx){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+158;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=326; /* line # 326 */
  Ra.sl[3]=327; /* line # 327 */
  if (((SL *)F_ftab)[0]>2) {
    Ra.sl[3]=329; /* line # 329 */
    Rv0=1;
    Ra.sl[3]=330; /* line # 330 */
    Rv1=((SL *)F_ftab)[0]/2+1;
    Ra.sl[3]=331; /* line # 331 */
    while (Rv1-Rv2>1){
      Ra.sl[3]=333; /* line # 333 */
      Rv2=(Rv1+Rv0)/2;
      Ra.sl[3]=334; /* line # 334 */
      if (F_xx>((G *)F_ftab)[(2*Rv2-1)]) Rv0=Rv2;
      else {
        Ra.sl[3]=335; /* line # 335 */
        Rv1=Rv2;
      }
    }
  }
  else {
    Ra.sl[3]=338; /* line # 338 */
    Rv0=1;
  }
  Ra.sl[3]=339; /* line # 339 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " math_get_tab_point "  */
void MXD_MATH_math_get_tab_point(V F_ftab, SL F_nc, G *F_xx, G *F_yy){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+177;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=348; /* line # 348 */
  Ra.sl[3]=350; /* line # 350 */
  (*F_xx)=((G *)F_ftab)[(F_nc*2-1)];
  (*F_yy)=((G *)F_ftab)[(F_nc*2)];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " math_interpol "  */
G P_math_interpol(V F_ftab, G F_xx){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;
  G Rv4;
  SL Rv5;
  G Rv6;
  G Rv7;
  G Rv8;
  G Rv9;
  G Rv10;
  G Rv11;
  G Rv12;
  G Rv13;
  G Rv14;
  G Rv15;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+197;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=368; /* line # 368 */
  Rv0=0.000000000000000E-001;
  Ra.sl[3]=369; /* line # 369 */
  V_math_err=0;
  Ra.sl[3]=370; /* line # 370 */
  Ra.sl[3]=372; /* line # 372 */
  Rv1=((SL *)F_ftab)[0]/2;
  Ra.sl[3]=373; /* line # 373 */
  if (Rv1>1) {
    Ra.sl[3]=375; /* line # 375 */
    if (F_xx<((G *)F_ftab)[1]||F_xx>((G *)F_ftab)[(((SL *)F_ftab)[0]-1)]) {
      Ra.sl[3]=377; /* line # 377 */
      Rv2=((G *)F_ftab)[1];
      Rv3=((G *)F_ftab)[(((SL *)F_ftab)[0]-1)];
      Ra.sl[3]=378; /* line # 378 */
      if (F_xx<Rv2) Rv4=fabs((Rv2-F_xx)/(Rv3-Rv2));
      else {
        Ra.sl[3]=379; /* line # 379 */
        Rv4=fabs((F_xx-Rv3)/(Rv3-Rv2));
      }
      Ra.sl[3]=380; /* line # 380 */
      if (Rv4>1.000000000000000E-002) {
        Ra.sl[3]=381; /* line # 381 */
        if (Rv4>1.000000000000000E-001) V_math_err=2;
        else {
          Ra.sl[3]=382; /* line # 382 */
          V_math_err=1;
        }
      }
    }
  }
  Ra.sl[3]=386; /* line # 386 */
  if (Rv1>=4) {
    Ra.sl[3]=388; /* line # 388 */
    if (Rv5>4) {
      Ra.sl[3]=390; /* line # 390 */
      Rv5=MXD_MATH_math_table_locate(F_ftab,F_xx);
      Ra.sl[3]=391; /* line # 391 */
      if (Rv5<2) Rv5=2;
      else {
        Ra.sl[3]=392; /* line # 392 */
        if (Rv5>Rv1-2) Rv5=Rv1-2;
      }
    }
    else {
      Ra.sl[3]=393; /* line # 393 */
      Rv5=2;
    }
    Ra.sl[3]=394; /* line # 394 */
    MXD_MATH_math_get_tab_point(F_ftab,Rv5-1, &Rv2, &Rv6);
    Ra.sl[3]=395; /* line # 395 */
    MXD_MATH_math_get_tab_point(F_ftab,Rv5, &Rv3, &Rv7);
    Ra.sl[3]=396; /* line # 396 */
    MXD_MATH_math_get_tab_point(F_ftab,Rv5+1, &Rv4, &Rv8);
    Ra.sl[3]=397; /* line # 397 */
    MXD_MATH_math_get_tab_point(F_ftab,Rv5+2, &Rv9, &Rv10);
    Ra.sl[3]=399; /* line # 399 */
    Rv11=(Rv6-Rv7)/(Rv2-Rv3);
    Ra.sl[3]=400; /* line # 400 */
    Rv12=(Rv11-(Rv6-Rv8)/(Rv2-Rv4))/(Rv3-Rv4);
    Ra.sl[3]=401; /* line # 401 */
    Rv13=(Rv12-(Rv11-(Rv6-Rv10)/(Rv2-Rv9))/(Rv3-Rv9))/(Rv4-Rv9);
    Ra.sl[3]=402; /* line # 402 */
    Rv14=Rv12-((Rv2+Rv3)+Rv4)*Rv13;
    Ra.sl[3]=403; /* line # 403 */
    Rv15=(Rv11-(Rv2+Rv3)*Rv14)-((Rv2*Rv2+Rv2*Rv3)+Rv3*Rv3)*Rv13;
    Ra.sl[3]=404; /* line # 404 */
    Rv0=(Rv6-Rv2*(Rv15+Rv2*(Rv14+Rv2*Rv13)))+F_xx*(Rv15+F_xx*(Rv14+F_xx*Rv13));
  }
  else {
    Ra.sl[3]=408; /* line # 408 */
    if (Rv1>0) {
      Ra.sl[3]=410; /* line # 410 */
      MXD_MATH_math_get_tab_point(F_ftab,1, &Rv2, &Rv6);
      Ra.sl[3]=411; /* line # 411 */
      if (Rv1>1) {
        Ra.sl[3]=413; /* line # 413 */
        MXD_MATH_math_get_tab_point(F_ftab,2, &Rv3, &Rv7);
        Ra.sl[3]=414; /* line # 414 */
        if (Rv1>2) MXD_MATH_math_get_tab_point(F_ftab,3, &Rv4, &Rv8);
      }
    }
    Ra.sl[3]=417; /* line # 417 */
    switch (Rv1) {
      case 3:Ra.sl[3]=419; /* line # 419 */
      Rv11=(Rv6-Rv7)/(Rv2-Rv3);
      Ra.sl[3]=420; /* line # 420 */
      Rv14=(Rv11-(Rv6-Rv8)/(Rv2-Rv4))/(Rv3-Rv4);
      Ra.sl[3]=421; /* line # 421 */
      Rv15=Rv11-(Rv2+Rv3)*Rv14;
      Ra.sl[3]=422; /* line # 422 */
      Rv0=(Rv6-Rv2*(Rv15+Rv2*Rv14))+F_xx*(Rv15+F_xx*Rv14);
      break;
      case 2:Ra.sl[3]=424; /* line # 424 */
      Rv0=Rv6+((F_xx-Rv2)*(Rv6-Rv7))/(Rv2-Rv3);
      break;
      case 1:Ra.sl[3]=425; /* line # 425 */
      Rv0=Rv6;
      break;
      default:Ra.sl[3]=427; /* line # 427 */
      Rv0=0.000000000000000E-001;
      break;
    }
  }
  Ra.sl[3]=431; /* line # 431 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " intgr_gauss_legendre "  */
void MXD_MATH_intgr_gauss_legendre(SL F_n, G F_eps, G F_va, G F_vb, V F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  G Rv5;
  G Rv6;
  G Rv7;
  SL Rv8;
  G Rv9;
  G Rv10;
  G Rv11;
  G Rv12;
  register G Rgg;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+212;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=445; /* line # 445 */
  Rv0=5.000000000000000E-001*(F_vb+F_va);
  Ra.sl[3]=446; /* line # 446 */
  Rv1=5.000000000000000E-001*(F_vb-F_va);
  Ra.sl[3]=447; /* line # 447 */
  Rv2=1;
  Ra.sl[3]=448; /* line # 448 */
  Rv3=2*F_n;
  Ra.sl[3]=449; /* line # 449 */
  Rv4=1;
  for( Rf1=(F_n+1)/2;Rf1>0;Rf1-- ) {
    Ra.sl[3]=451; /* line # 451 */
    Rv5=(double)cos(((F)3.141593E+00*((float)Rv4-(F)2.500000E-01))/((float)F_n+(F)
5.000000E-01));
    while (1){
      Ra.sl[3]=453; /* line # 453 */
      Rv6=1.000000000000000E+000;
      Ra.sl[3]=454; /* line # 454 */
      Rv7=0.000000000000000E-001;
      Ra.sl[3]=455; /* line # 455 */
      Rv8=1;
      for( Rf0=F_n;Rf0>0;Rf0-- ) {
        Ra.sl[3]=457; /* line # 457 */
        Rv9=Rv7;
        Rv7=Rv6;
        Ra.sl[3]=458; /* line # 458 */
        Rv6=(((double)((F)2.000000E+00*(float)Rv8-(F)1.000000E+00)*Rv5)*Rv7-(double)
        ((float)Rv8-(F)1.000000E+00)*Rv9)/(double)Rv8;
        Rv8++;
      }
      Ra.sl[3]=460; /* line # 460 */
      Rv10=((double)F_n*(Rv5*Rv6-Rv7))/(Rv5*Rv5-1.000000000000000E+000);
      Ra.sl[3]=461; /* line # 461 */
      Rv11=Rv5;
      Ra.sl[3]=462; /* line # 462 */
      Rv5=Rv11-Rv6/Rv10;
      if (fabs(Rv5-Rv11)<=F_eps)  break;
    }
    Ra.sl[3]=464; /* line # 464 */
    Rv12=(2.000000000000000E+000*Rv1)/((1.000000000000000E+000-Rv5*Rv5)*(Rv10*Rv10)
    );
    Ra.sl[3]=465; /* line # 465 */
    ((G *)F_bl)[Rv2]=Rv12;
    Ra.sl[3]=466; /* line # 466 */
    ((G *)F_bl)[Rv3]=Rv0+Rv1*Rv5;
    Ra.sl[3]=467; /* line # 467 */
    Rv2=Rv2+1;
    Ra.sl[3]=468; /* line # 468 */
    Rv3=Rv3-1;
    Ra.sl[3]=469; /* line # 469 */
    ((G *)F_bl)[Rv2]=Rv0-Rv1*Rv5;
    Ra.sl[3]=470; /* line # 470 */
    ((G *)F_bl)[Rv3]=Rv12;
    Ra.sl[3]=471; /* line # 471 */
    Rv2=Rv2+1;
    Ra.sl[3]=472; /* line # 472 */
    Rv3=Rv3-1;
    Rv4++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " intgr_gauss_laguerre "  */
void MXD_MATH_intgr_gauss_laguerre(SL F_n, G F_al, G F_eps, V F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;
  SL Rv4;
  G Rv5;
  G Rv6;
  SL Rv7;
  G Rv8;
  G Rv9;
  G Rv10;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+234;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=491; /* line # 491 */
  Rv0=1;
  Ra.sl[3]=492; /* line # 492 */
  Rv1=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=494; /* line # 494 */
    switch (Rv1) {
      case 1:Ra.sl[3]=495; /* line # 495 */
      Rv3=((1.000000000000000E+000+F_al)*(3.000000000000000E+000+9.200000000000000E-001*
      F_al))/((double)((F)1.000000E+00+(F)2.400000E+00*(float)F_n)+1.800000000000000E+000*
      F_al);
      break;
      case 2:Ra.sl[3]=496; /* line # 496 */
      Rv3=Rv3+(1.500000000000000E+001+6.250000000000000E+000*F_al)/((1.000000000000000E+000+
9.000000000000000E-001*F_al)+(double)((F)2.500000E+00*(float)F_n));
      break;
      default:Ra.sl[3]=498; /* line # 498 */
      Rv2=(double)(Rv1-2);
      Ra.sl[3]=499; /* line # 499 */
      Rv3=Rv3+(((1.000000000000000E+000+2.550000000000000E+000*Rv2)/(1.900000000000000E+000*
      Rv2)+((1.260000000000000E+000*Rv2)*F_al)/(1.000000000000000E+000+3.500000000000000E+000*
      Rv2))*(Rv3-((G *)F_bl)[(Rv0-2)]))/(1.000000000000000E+000+3.000000000000000E-001*
      F_al);
      break;
    }
    Ra.sl[3]=502; /* line # 502 */
    Rv4=0;
    while (1){
      Ra.sl[3]=504; /* line # 504 */
      Rv5=1.000000000000000E+000;
      Ra.sl[3]=505; /* line # 505 */
      Rv6=0.000000000000000E-001;
      Ra.sl[3]=506; /* line # 506 */
      Rv7=1;
      for( Rf0=F_n;Rf0>0;Rf0-- ) {
        Ra.sl[3]=508; /* line # 508 */
        Rv8=Rv6;
        Ra.sl[3]=509; /* line # 509 */
        Rv6=Rv5;
        Ra.sl[3]=510; /* line # 510 */
        Rv5=((((double)(2*Rv7-1)+F_al)-Rv3)*Rv6-((double)(Rv7-1)+F_al)*Rv8)/(double)
        Rv7;
        Rv7++;
      }
      Ra.sl[3]=512; /* line # 512 */
      Rv9=((double)F_n*Rv5-((double)F_n+F_al)*Rv6)/Rv3;
      Ra.sl[3]=513; /* line # 513 */
      Rv10=Rv3;
      Ra.sl[3]=514; /* line # 514 */
      Rv3=Rv10-Rv5/Rv9;
      Ra.sl[3]=515; /* line # 515 */
      Rv4=Rv4+1;
      if (Rv4>500||fabs(Rv3-Rv10)<F_eps)  break;
    }
    Ra.sl[3]=517; /* line # 517 */
    if (Rv4>500) V_math_err=3;
    Ra.sl[3]=518; /* line # 518 */
    ((G *)F_bl)[Rv0]=-exp(MXD_MATH_math_gammaln(F_al+(double)F_n)-MXD_MATH_math_gammaln((double)
    F_n))/((Rv9*(double)F_n)*Rv6);
    Ra.sl[3]=520; /* line # 520 */
    Rv0=Rv0+1;
    Ra.sl[3]=521; /* line # 521 */
    ((G *)F_bl)[Rv0]=Rv3;
    Ra.sl[3]=522; /* line # 522 */
    Rv0=Rv0+1;
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " intgr_gauss_hermite "  */
void MXD_MATH_intgr_gauss_hermite(SL F_n, G F_ep, V F_bl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  G Rv3;
  G Rv4;
  SL Rv5;
  G Rv6;
  G Rv7;
  SL Rv8;
  G Rv9;
  G Rv10;
  register G Rgg;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+256;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=542; /* line # 542 */
  Rv0=1;
  Ra.sl[3]=543; /* line # 543 */
  Rv1=2*F_n;
  Ra.sl[3]=544; /* line # 544 */
  Rv2=1;
  for( Rf1=(F_n+1)/2;Rf1>0;Rf1-- ) {
    Ra.sl[3]=546; /* line # 546 */
    switch (Rv2) {
      case 1:Ra.sl[3]=548; /* line # 548 */
      Rv4=(double)(2*F_n+1);
      Ra.sl[3]=549; /* line # 549 */
      Rv3=sqrt(Rv4)-1.855750000000000E+000*exp(-1.666700000000000E+000*log(Rv4))
      ;
      break;
      case 2:Ra.sl[3]=553; /* line # 553 */
      Rv4=(double)F_n;
      Ra.sl[3]=554; /* line # 554 */
      Rv3=Rv3-(1.140000000000000E+000*exp(4.260000000000001E-001*log(Rv4)))/Rv3;
      break;
      case 3:Ra.sl[3]=557; /* line # 557 */
      Rv3=1.860000000000000E+000*Rv3-8.600000000000000E-001*((G *)F_bl)[1];
      break;
      case 4:Ra.sl[3]=559; /* line # 559 */
      Rv3=1.910000000000000E+000*Rv3-9.100000000000000E-001*((G *)F_bl)[3];
      break;
      default:Ra.sl[3]=562; /* line # 562 */
      Rv3=2.000000000000000E+000*Rv3-((G *)F_bl)[(Rv0-2)];
      break;
    }
    Ra.sl[3]=565; /* line # 565 */
    Rv5=0;
    while (1){
      Ra.sl[3]=567; /* line # 567 */
      Rv6=7.511255444649425E-001;
      Ra.sl[3]=568; /* line # 568 */
      Rv7=0.000000000000000E-001;
      Ra.sl[3]=569; /* line # 569 */
      Rv8=1;
      for( Rf0=F_n;Rf0>0;Rf0-- ) {
        Ra.sl[3]=571; /* line # 571 */
        Rv9=Rv7;
        Ra.sl[3]=572; /* line # 572 */
        Rv7=Rv6;
        Ra.sl[3]=573; /* line # 573 */
        Rv6=(double)Rv8;
        Ra.sl[3]=574; /* line # 574 */
        Rv6=(Rv3*sqrt(2.000000000000000E+000/Rv6))*Rv7-sqrt((Rv6-1.000000000000000E+000)
        /Rv6)*Rv9;
        Rv8++;
      }
      Ra.sl[3]=576; /* line # 576 */
      Rv10=(double)sqrt((F)2.000000E+00*(float)F_n)*Rv7;
      Ra.sl[3]=577; /* line # 577 */
      Rv4=Rv3;
      Ra.sl[3]=578; /* line # 578 */
      Rv3=Rv4-Rv6/Rv10;
      Ra.sl[3]=579; /* line # 579 */
      Rv5=Rv5+1;
      if (fabs(Rv4-Rv3)<F_ep||Rv5>500)  break;
    }
    Ra.sl[3]=581; /* line # 581 */
    if (Rv5>500) V_math_err=4;
    Ra.sl[3]=582; /* line # 582 */
    Rv10=2.000000000000000E+000/(Rv10*Rv10);
    Ra.sl[3]=583; /* line # 583 */
    ((G *)F_bl)[Rv0]=Rv10;
    Ra.sl[3]=584; /* line # 584 */
    ((G *)F_bl)[Rv1]=Rv3;
    Ra.sl[3]=585; /* line # 585 */
    Rv0=Rv0+1;
    Ra.sl[3]=586; /* line # 586 */
    Rv1=Rv1-1;
    Ra.sl[3]=587; /* line # 587 */
    ((G *)F_bl)[Rv0]=-Rv3;
    Ra.sl[3]=588; /* line # 588 */
    ((G *)F_bl)[Rv1]=Rv10;
    Ra.sl[3]=589; /* line # 589 */
    Rv0=Rv0+1;
    Ra.sl[3]=590; /* line # 590 */
    Rv1=Rv1-1;
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " math_gauss_integr_bldtab "  */
void P_math_gauss_integr_bldtab(V F_ftab, G F_va, G F_vb, G F_ep, SL F_ik){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+277;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=603; /* line # 603 */
  V_math_err=0;
  Ra.sl[3]=604; /* line # 604 */
  Ra.sl[3]=606; /* line # 606 */
  Rv0=((SL *)F_ftab)[0]/2;
  Ra.sl[3]=607; /* line # 607 */
  if (Rv0<5) V_math_err=5;
  else {
    Ra.sl[3]=609; /* line # 609 */
    switch (F_ik) {
      case 1:Ra.sl[3]=612; /* line # 612 */
      if (F_va==2.147483647000000E+009) F_va=1.000000000000000E+000;
      Ra.sl[3]=613; /* line # 613 */
      MXD_MATH_intgr_gauss_laguerre(Rv0, F_va, F_ep, F_ftab);
      break;
      case 2:Ra.sl[3]=617; /* line # 617 */
      MXD_MATH_intgr_gauss_hermite(Rv0, F_ep, F_ftab);
      break;
      default:Ra.sl[3]=621; /* line # 621 */
      if (F_vb<=F_va) F_vb=F_va+1.000000000000000E+000;
      Ra.sl[3]=622; /* line # 622 */
      MXD_MATH_intgr_gauss_legendre(Rv0, F_ep, F_va, F_vb, F_ftab);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}
