{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*     MXD   Expression  and  Crystallographic  Object  Tree   Environment     *
*                                                                             *
*                                                                             *
*******************************************************************************


}


{****************     CPAS  version    *****************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


program MXD_LSQ;


  %include        'MXDSRC:mxd_lsq_env'; { Load Least-Sqaure Environment }



const
  fdebug        =                false; { Flag for conditional debug output }



[global]
var
  elpstim,                              { Total elapsed time }
  topcpu:                      integer; { Total cpu time }


  { Specific MXD-LSQ Variables for Least-Squares options }

  nbsing_nmax,                          { Maximum number of singularities to continue the fit }
  lsq_savcycle,                         { Save cycle period in LSQ_CYCLE (0 = no save) }
  lsq_mxcateg,                          { Maximum of category number for an elligible reflection }
  lsq_ncycle:         integer :=     0; { Number of cycle to perform }


  sithsl_max,                           { Maximum for SIN(theta)/Lambda for an eligible reflection }
  sithsl_min,                           { Minimum for SIN(theta)/Lambda for an eligible reflection }
  correl_max,                           { Edge for correlation output }
  matdiag_max,                          { Low Limit of matrix pivot to signal a singularity }
  lhkl_reject,                          { Max. of <delta>/<sigma> for an eligible reflection }
  lhkl_list:          mxd_flt :=   0.0; { Minimum level for <delta>/<sigma> for reflection listing }


  bsigcor_out,                          { Flag for sigma and correlation output after the last cycle (on specific file) }
  bfour_out,                            { Flag for Fourier output after the last cycle (on specific file) }
  batom_out,                            { Flag for Atom list output after the last cycle (on specific file) }
  bistr_list,                           { Flag for listing of initial structure description }
  bfstr_list,                           { Flag for listing of final structure description }
  bcorrmat_list,                        { Flag for Full correlation matrix listing after the last cycle }
  bsymtry_list,                         { Flag for symmetry operator listing }
  bfmag_list,                           { Flag for Magnetic structure factor output }
  bpfmag_list,                          { Flag for Projected Magnetic structure factor output }
  bpsta_list,                           { Flag for particular Residu listing on the last LSQ cycle }
  bpsta_cylst,                          { Flag for particular Residu listing for each LSQ cycle }
  bparm_list,                           { Flag for listing LSQ_PARM on last cycle }
  bresult_list,                         { Flag for result (LSQ_VAR) listing on each cycle }
  bacconv_lsq,                          { Flag for convergence acceleration process management }
  bhkl_list,                            { Flag for HKL reflection listing at the last LSQ cycle }
  bhkl_cylst,                           { Flag for HKL reflection listing for each LSQ cycle }
  bshort_flst:  boolean :=       false; { Flag for short listing option }




procedure LSQ_INIT;
begin
  { *** Set the default listing options *** }
  bshort_flst   :=        true;         { Short listing is the default }
  bresult_list  :=        true;         { Result (LSQ_VAR) listing on each cycle }
  bparm_list    :=        true;         { Valid the final output of all visible LSQ_PARM }
  sithsl_max    :=      1.0e10;         { Set the default minimaxi for Sin(theta)/Lambda }
  sithsl_min    :=         0.0;
  lhkl_reject   :=      1.0e10;         { No dynamic rejection }

  INIT_TREE( task_name );

end LSQ_INIT;



[global]
procedure SET_OPTION( npa: integer );
{ Perform the otion setup from the pcdf file.
}
var
  opt:    lsqopt_codes;
  icd:         integer;
  rv:          mxd_flt;

begin
  READ( pcdf, icd, rv ); opt := lsqopt_codes( icd );

  if fdebug then WRITELN( ' ':8, 'Option ', opt, ' ', rv:8:3, ' ...' );

  case opt of
    opls_shortlst:  bshort_flst := (rv >= 0.5);

    opls_ncycle:    lsq_ncycle    := ABS( ROUND( rv ) );

    opls_listhkl:   begin
                      bhkl_list := (rv >= 0.5); bhkl_cylst := (rv >= 1.5);
                      if npa > 2 then
                      begin  READ( pcdf, rv ); lhkl_list := ABS( rv )  end
                    end;

    opls_mxsithsl:  begin  sithsl_max := ABS( rv ); if sithsl_min >= sithsl_max then sithsl_min := 0.0  end;

    opls_misithsl:  begin  sithsl_min := ABS( rv ); if sithsl_min >= sithsl_max then sithsl_min := 0.0  end;

    opls_reject:    lhkl_reject   := ABS( rv );

    opls_mindiag:   matdiag_max   := ABS( rv );

    opls_maxsing:   nbsing_nmax   := ABS( ROUND( rv ) );

    opls_maxcateg:  if rv > 0 then lsq_mxcateg := ABS( ROUND( rv ) )
                              else lsq_mxcateg := maxint;

    opls_acconv:    bacconv_lsq   := (rv >= 0.5);

    opls_reslist:   bresult_list  := (rv >= 0.5);

    opls_parmlist:  bparm_list    := (rv >= 0.5);

    opls_pstatres:  bpsta_cylst   := (rv >= 0.5);

    opls_cypstares: bpsta_list    := (rv >= 0.5);

    opls_fmagdisp:  bfmag_list    := (rv >= 0.5);

    opls_pfmagdisp: bpfmag_list   := (rv >= 0.5);

    opls_symlist:   bsymtry_list  := (rv >= 0.5);

    opls_cmatlist:  bcorrmat_list := (rv >= 0.5);

    opls_mxcorrel:  begin  correl_max := ABS( rv ); if rv > 1.0 then rv := 0.6666  end;

    opls_strend:    bfstr_list    := (rv >= 0.5);

    opls_strini:    bistr_list    := (rv >= 0.5);

    opls_savcycle:  lsq_savcycle  := ABS( ROUND( rv ) );

    opls_atom_out:  batom_out     := (rv >= 0.5);

    opls_four_out:  bfour_out     := (rv >= 0.5);

    opls_sigm_out:  bsigcor_out   := (rv >= 0.5);
  otherwise
  end;
  if fdebug then WRITELN
end SET_OPTION;




begin { MXD_LSQ (the main program) }
  LSQ_INIT;
  BUILDTREE( pcdf_mxd_name );                 { Create the MXD Relation Tree }
{ BUILDTREE( mxd_libdir||mxd_lsq_envf );      { Load the LSQ specific formulae }
  TREE_SET_DERIV;                             { Create the LSQ_PARM derivate list and build the LSQ_PARM Category list }
  PARM_EVAL( prmc_init );                     { Compute all constant LSQ_PARMs }
  PHASES_AND_DATA_INIT;                       { Perform the Phase and Data specific computing }
  LSQ_VECTMAT_ALLOC;                          { Make all free LSQ_VAR links and space allocation }

  INITIAL_TASKS;                              { Perform the inital tasks (User required output on initial state }
  EXECUTE_LSQ_FIT;                            { Perform the structure fit }
  FINAL_TASKS                                 { Perform the final tasks (User required output and computing on final state) }

end MXD_LSQ.
