/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 112 ) = {
  8,   8, 108, 115, 113,  95, 105, 110, 105, 116,  55,  55,  47, 104, 111, 109,
101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  99,
112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95, 115,
114,  99,  47, 109, 120, 100,  95, 108, 115, 113,  95, 109,  97, 105, 110,  46,
112,  97, 115,   7,   7,  77,  88,  68,  45,  76,  83,  81,  10,  10, 115, 101,
116,  95, 111, 112, 116, 105, 111, 110,   7,   7, 109, 120, 100,  95, 108, 115,
113,  12,  12, 109, 120, 100,  95, 100,  99, 112,  46, 112,  99, 100, 102,   0
};

/* Define the local static section. */
static Blk( Rs, 16 );

/* Declaration of external variables. */
extern V V_pcdf;

/* Declaration of global variables. */
SL V_elpstim;
SL V_topcpu;
SL V_nbsing_nmax = 0;
SL V_lsq_savcycle = 0;
SL V_lsq_mxcateg = 0;
SL V_lsq_ncycle = 0;
G V_sithsl_max = 0.000000000000000E-001;
G V_sithsl_min = 0.000000000000000E-001;
G V_correl_max = 0.000000000000000E-001;
G V_matdiag_max = 0.000000000000000E-001;
G V_lhkl_reject = 0.000000000000000E-001;
G V_lhkl_list = 0.000000000000000E-001;
UB V_bsigcor_out = 0;
UB V_bfour_out = 0;
UB V_batom_out = 0;
UB V_bistr_list = 0;
UB V_bfstr_list = 0;
UB V_bcorrmat_list = 0;
UB V_bsymtry_list = 0;
UB V_bfmag_list = 0;
UB V_bpfmag_list = 0;
UB V_bpsta_list = 0;
UB V_bpsta_cylst = 0;
UB V_bparm_list = 0;
UB V_bresult_list = 0;
UB V_bacconv_lsq = 0;
UB V_bhkl_list = 0;
UB V_bhkl_cylst = 0;
UB V_bshort_flst = 0;

/* Function/procedure prototypes. */
void P_init_tree(V F_mxdnam);
void P_buildtree(V F_pcdf_name);
void P_tree_set_deriv();
void P_phases_and_data_init();
void P_lsq_vectmat_alloc();
void P_parm_eval(UB F_ctg);
void P_initial_tasks();
void P_execute_lsq_fit();
void P_final_tasks();


/* Procedure/Function : " lsq_init "  */
void MXD_LSQ_lsq_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+10;
  Ra.sl[3]=156; /* line # 156 */
  V_bshort_flst=1;
  Ra.sl[3]=157; /* line # 157 */
  V_bresult_list=1;
  Ra.sl[3]=158; /* line # 158 */
  V_bparm_list=1;
  Ra.sl[3]=159; /* line # 159 */
  V_sithsl_max=1.000000000000000E+010;
  Ra.sl[3]=160; /* line # 160 */
  V_sithsl_min=0.000000000000000E-001;
  Ra.sl[3]=161; /* line # 161 */
  V_lhkl_reject=1.000000000000000E+010;
  Ra.sl[3]=163; /* line # 163 */
  P_init_tree(Rd.s+67);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_option "  */
void P_set_option(SL F_npa){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  UB Rv2;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+10;
  Ra.sl[3]=179; /* line # 179 */
  PAS__SELECT_INP(V_pcdf);
  PAS__READ_SL(&Rv0,0);
  PAS__READ_DBLE(&Rv1,0);
  Rv2=(UB)Rv0;
  Ra.sl[3]=183; /* line # 183 */
  switch (Rv2) {
    case 1:Ra.sl[3]=184; /* line # 184 */
    V_bshort_flst=Rv1>=5.000000000000000E-001;
    break;
    case 2:Ra.sl[3]=186; /* line # 186 */
    V_lsq_ncycle=abs((Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5)));
    break;
    case 3:Ra.sl[3]=189; /* line # 189 */
    V_bhkl_list=Rv1>=5.000000000000000E-001;
    V_bhkl_cylst=Rv1>=1.500000000000000E+000;
    Ra.sl[3]=190; /* line # 190 */
    if (F_npa>2) {
      Ra.sl[3]=191; /* line # 191 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_DBLE(&Rv1,0);
      V_lhkl_list=fabs(Rv1);
    }
    break;
    case 4:Ra.sl[3]=194; /* line # 194 */
    V_sithsl_max=fabs(Rv1);
    if (V_sithsl_min>=V_sithsl_max) V_sithsl_min=0.000000000000000E-001;
    break;
    case 5:Ra.sl[3]=196; /* line # 196 */
    V_sithsl_min=fabs(Rv1);
    if (V_sithsl_min>=V_sithsl_max) V_sithsl_min=0.000000000000000E-001;
    break;
    case 6:Ra.sl[3]=198; /* line # 198 */
    V_lhkl_reject=fabs(Rv1);
    break;
    case 7:Ra.sl[3]=200; /* line # 200 */
    V_matdiag_max=fabs(Rv1);
    break;
    case 8:Ra.sl[3]=202; /* line # 202 */
    V_nbsing_nmax=abs((Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5)));
    break;
    case 9:Ra.sl[3]=204; /* line # 204 */
    if (Rv1>0.000000000000000E-001) V_lsq_mxcateg=abs((Rv1>0.0?(SL)(Rv1+0.5):(SL)(
    Rv1-0.5)));
    else {
      Ra.sl[3]=205; /* line # 205 */
      V_lsq_mxcateg=2147483647;
    }
    break;
    case 10:Ra.sl[3]=207; /* line # 207 */
    V_bacconv_lsq=Rv1>=5.000000000000000E-001;
    break;
    case 11:Ra.sl[3]=209; /* line # 209 */
    V_bresult_list=Rv1>=5.000000000000000E-001;
    break;
    case 12:Ra.sl[3]=211; /* line # 211 */
    V_bparm_list=Rv1>=5.000000000000000E-001;
    break;
    case 13:Ra.sl[3]=213; /* line # 213 */
    V_bpsta_cylst=Rv1>=5.000000000000000E-001;
    break;
    case 14:Ra.sl[3]=215; /* line # 215 */
    V_bpsta_list=Rv1>=5.000000000000000E-001;
    break;
    case 15:Ra.sl[3]=217; /* line # 217 */
    V_bfmag_list=Rv1>=5.000000000000000E-001;
    break;
    case 16:Ra.sl[3]=219; /* line # 219 */
    V_bpfmag_list=Rv1>=5.000000000000000E-001;
    break;
    case 17:Ra.sl[3]=221; /* line # 221 */
    V_bsymtry_list=Rv1>=5.000000000000000E-001;
    break;
    case 18:Ra.sl[3]=223; /* line # 223 */
    V_bcorrmat_list=Rv1>=5.000000000000000E-001;
    break;
    case 19:Ra.sl[3]=225; /* line # 225 */
    V_correl_max=fabs(Rv1);
    if (Rv1>1.000000000000000E+000) Rv1=6.666000000000000E-001;
    break;
    case 20:Ra.sl[3]=227; /* line # 227 */
    V_bfstr_list=Rv1>=5.000000000000000E-001;
    break;
    case 21:Ra.sl[3]=229; /* line # 229 */
    V_bistr_list=Rv1>=5.000000000000000E-001;
    break;
    case 22:Ra.sl[3]=231; /* line # 231 */
    V_lsq_savcycle=abs((Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5)));
    break;
    case 23:Ra.sl[3]=233; /* line # 233 */
    V_batom_out=Rv1>=5.000000000000000E-001;
    break;
    case 24:Ra.sl[3]=235; /* line # 235 */
    V_bfour_out=Rv1>=5.000000000000000E-001;
    break;
    case 25:Ra.sl[3]=237; /* line # 237 */
    V_bsigcor_out=Rv1>=5.000000000000000E-001;
    break;
    default:break;
  }
  Ra.sl[3]=240; /* line # 240 */
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " mxd_lsq "  */
main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+88;
  Rs.v[2]=Rd.s+10;
  Rs.sl[3]=247; /* line # 247 */
  MXD_LSQ_lsq_init();
  Rs.sl[3]=248; /* line # 248 */
  P_buildtree(Rd.s+97);
  Rs.sl[3]=250; /* line # 250 */
  P_tree_set_deriv();
  Rs.sl[3]=251; /* line # 251 */
  P_parm_eval(2);
  Rs.sl[3]=252; /* line # 252 */
  P_phases_and_data_init();
  Rs.sl[3]=253; /* line # 253 */
  P_lsq_vectmat_alloc();
  Rs.sl[3]=255; /* line # 255 */
  P_initial_tasks();
  Rs.sl[3]=256; /* line # 256 */
  P_execute_lsq_fit();
  Rs.sl[3]=257; /* line # 257 */
  P_final_tasks();
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
