/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 376 ) = {
 10,  10, 111, 117, 116,  95, 109,  97, 116, 114, 105, 120,  54,  54,  47, 104,
111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,
 95, 115, 114,  99,  47, 109, 120, 100,  95, 108, 115, 113,  95, 102, 105, 116,
 46, 112,  97, 115,  13,  13,  32,  32,  42,  42,  42,  32,  77,  97, 116, 114,
105, 120,  40,  24,  24,  41,  32,  32,  97, 110, 100,  32, 114, 101, 108,  97,
116, 101, 100,  32,  32, 118, 101,  99, 116, 111, 114,  32,  58,   5,   5,  32,
 32,  42,  32,  32,   6,   6, 109,  97, 116, 105, 110, 118,  50,  50,  32,  42,
 42,  42,  32,  76,  83,  81,  36,  77,  97, 116, 105, 110, 118,  32,  70, 105,
110, 100,  32,  97,  32, 115, 105, 110, 103, 117, 108,  97, 114, 105, 116, 121,
 32, 102, 111, 114,  32, 118,  97, 114, 105,  97,  98, 108, 101,  32,  35,  32,
  5,   5, 115, 111, 108, 118, 101,  11,  11, 102, 114, 101, 101,  95, 112, 100,
101, 115,  99, 114,   8,   8, 108, 115, 113,  36, 105, 110, 105, 116,  13,  13,
108, 115, 113,  36, 110, 101, 119,  95, 118, 112,  97, 114, 109,  13,  13, 108,
115, 113,  36, 110, 101, 119,  95,  98, 108, 111,  99, 107,  15,  15, 108, 115,
113,  36, 115, 101, 116,  95, 100, 109, 112,  95, 109, 114, 113,  14,  14, 108,
115, 113,  36, 105, 110, 105, 116,  95,  99, 121,  99, 108, 101,  12,  12, 108,
115, 113,  36, 115, 101, 116,  95, 101, 108, 101, 109,  13,  13, 108, 115, 113,
 36, 105, 110, 105, 116,  95, 100, 101, 114, 118,  12,  12, 108, 115, 113,  36,
115, 101, 116,  95, 100, 101, 114, 118,  13,  13, 108, 115, 113,  36, 115, 101,
116,  95,  99, 111, 110, 116, 114,  11,  11, 108, 115, 113,  36, 112, 114, 111,
 99, 101, 115, 115,  16,  16, 108, 115, 113,  36, 114, 101, 115, 116, 111, 114,
101,  95, 112,  97, 114, 109,  10,  10, 108, 115, 113,  36,  99, 111, 114, 114,
101, 108,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 24 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 16 );

/* Declaration of external variables. */
extern V PAS__f_output;

/* Declaration of global variables. */
SL V_itopvect = 0;
SL V_idervec = 0;
SL V_icoltrm = 0;
SL V_ishfvec = 0;
SL V_ineumem = 0;
SL V_ivtfn = 0;
SL V_ivtfm = 0;
SL V_ivtnr = 0;
SL V_ivtni = 0;
SL V_ivrx = 0;
SL V_ivix = 0;
SL V_ivry = 0;
SL V_iviy = 0;
SL V_ivrz = 0;
SL V_iviz = 0;
V V_mdtab = NULL;
SL V_ndat;
SL V_np;
SL V_nsing;
G V_min_diag = 1.000000000000001E-006;
G V_chi2eps;
G V_chi2;
G V_lchi2;
G V_nchi2;



/* Procedure/Function : " out_matrix "  */
void MXD_LSQ_FIT_out_matrix(SL F_n, V F_mat, V F_bv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=199; /* line # 199 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[3]=200; /* line # 200 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+68,-1,-1,32);
  PAS__WRITE_INT(F_n,0,0);
  PAS__WRITE_CHAR(44);
  PAS__WRITE_INT(F_n,0,0);
  PAS__WRITE_STR(Rd.s+83,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=201; /* line # 201 */
  Rv0=1;
  Ra.sl[3]=202; /* line # 202 */
  Rv1=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=204; /* line # 204 */
    Rv2=1;
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=205; /* line # 205 */
      if (Rv2<Rv1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_FCHAR(32,12,-1,1,32);
      }
      else {
        Ra.sl[3]=206; /* line # 206 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_DBLE(((G *)F_mat)[Rv0],11,4,0);
        Rv0=Rv0+1;
      }
      Rv2++;
    }
    Ra.sl[3]=207; /* line # 207 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+109,-1,-1,32);
    PAS__WRITE_DBLE(((G *)F_bv)[Rv1],11,4,0);
    PAS__WRITE_EOLN();
    Rv1++;
  }
  Ra.sl[3]=209; /* line # 209 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " matinv "  */
void MXD_LSQ_FIT_matinv(SL F_n, V F_mat, V F_bvc, V F_vsg, SL *F_scn){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  G Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  G Rv9;
  G Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+116;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=231; /* line # 231 */
  (*F_scn)=0;
  Ra.sl[3]=233; /* line # 233 */
  Rv0=1;
  Ra.sl[3]=234; /* line # 234 */
  Rv1=1;
  while (1){
    Ra.sl[3]=236; /* line # 236 */
    Rv2=Rv1-1;
    Rv3=Rv1;
    while (1){
      Ra.sl[3]=238; /* line # 238 */
      Rv4=0.000000000000000E-001;
      Rv5=Rv3;
      Rv6=Rv1;
      Ra.sl[3]=239; /* line # 239 */
      if (Rv2>0) {
        Ra.sl[3]=240; /* line # 240 */
        Rv7=1;
        for( Rf2=Rv2;Rf2>0;Rf2-- ) {
          Ra.sl[3]=242; /* line # 242 */
          Rv4=Rv4+((G *)F_mat)[Rv5]*((G *)F_mat)[Rv6];
          Ra.sl[3]=243; /* line # 243 */
          Rv8=F_n-Rv7;
          Rv5=Rv5+Rv8;
          Rv6=Rv6+Rv8;
          Rv7++;
        }
      }
      Ra.sl[3]=245; /* line # 245 */
      Rv9=((G *)F_mat)[Rv0]-Rv4;
      Ra.sl[3]=246; /* line # 246 */
      if (Rv3<=Rv1) {
        Ra.sl[3]=248; /* line # 248 */
        if (Rv9>V_min_diag) {
          Ra.sl[3]=250; /* line # 250 */
          Rv10=sqrt(Rv9);
          Ra.sl[3]=251; /* line # 251 */
          ((G *)F_mat)[Rv0]=Rv10;
          Ra.sl[3]=252; /* line # 252 */
          ((G *)((V *)F_vsg)[Rv1])[0]=0.000000000000000E-001;
        }
        else {
          Ra.sl[3]=256; /* line # 256 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+124,-1,-1,32);
          PAS__WRITE_INT(Rv1,4,0);
          PAS__WRITE_EOLN();
          Ra.sl[3]=257; /* line # 257 */
          (*F_scn)=(*F_scn)+1;
          Ra.sl[3]=258; /* line # 258 */
          Rv10=1.000000000000000E+000;
          ((G *)F_mat)[Rv0]=Rv10;
          Ra.sl[3]=260; /* line # 260 */
          Rv11=Rv0+1;
          for( Rf2=(((Rv0+F_n)-Rv1)+1)-(Rv0+1);Rf2>0;Rf2-- ) {
            ((G *)F_mat)[Rv11]=0.000000000000000E-001;
            Rv11++;
          }
          Ra.sl[3]=261; /* line # 261 */
          Rv6=Rv1;
          Ra.sl[3]=262; /* line # 262 */
          Rv12=1;
          for( Rf2=Rv2;Rf2>0;Rf2-- ) {
            Ra.sl[3]=263; /* line # 263 */
            ((G *)F_mat)[Rv6]=0.000000000000000E-001;
            Rv6=(Rv6+F_n)-Rv12;
            Rv12++;
          }
          Ra.sl[3]=264; /* line # 264 */
          ((G *)F_bvc)[Rv1]=0.000000000000000E-001;
          Ra.sl[3]=265; /* line # 265 */
          ((G *)((V *)F_vsg)[Rv1])[0]=-1.000000000000000E+000;
        }
      }
      else {
        Ra.sl[3]=268; /* line # 268 */
        ((G *)F_mat)[Rv0]=Rv9/Rv10;
      }
      Ra.sl[3]=269; /* line # 269 */
      Rv0=Rv0+1;
      Ra.sl[3]=270; /* line # 270 */
      Rv3=Rv3+1;
      if (Rv3>F_n)  break;
    }
    Ra.sl[3]=272; /* line # 272 */
    Rv1=Rv1+1;
    if (Rv1>F_n)  break;
  }
  Ra.sl[3]=276; /* line # 276 */
  ((G *)F_mat)[1]=1.000000000000000E+000/((G *)F_mat)[1];
  Ra.sl[3]=277; /* line # 277 */
  Rv13=1;
  Ra.sl[3]=278; /* line # 278 */
  Rv14=2;
  for( Rf2=F_n-1;Rf2>0;Rf2-- ) {
    Ra.sl[3]=280; /* line # 280 */
    Rv13=((Rv13+F_n)-Rv14)+2;
    Ra.sl[3]=281; /* line # 281 */
    Rv9=1.000000000000000E+000/((G *)F_mat)[Rv13];
    Ra.sl[3]=282; /* line # 282 */
    ((G *)F_mat)[Rv13]=Rv9;
    Ra.sl[3]=283; /* line # 283 */
    Rv6=0;
    Rv5=Rv14;
    Rv2=Rv14-1;
    Ra.sl[3]=285; /* line # 285 */
    Rv15=1;
    for( Rf1=Rv2;Rf1>0;Rf1-- ) {
      Ra.sl[3]=287; /* line # 287 */
      Rv0=Rv5;
      Rv4=0.000000000000000E-001;
      Ra.sl[3]=288; /* line # 288 */
      Rv16=Rv15;
      for( Rf0=(Rv2+1)-Rv15;Rf0>0;Rf0-- ) {
        Ra.sl[3]=290; /* line # 290 */
        Rv17=Rv6+Rv16;
        Ra.sl[3]=291; /* line # 291 */
        Rv4=Rv4-((G *)F_mat)[Rv5]*((G *)F_mat)[Rv17];
        Ra.sl[3]=292; /* line # 292 */
        Rv5=(Rv5+F_n)-Rv16;
        Rv16++;
      }
      Ra.sl[3]=294; /* line # 294 */
      ((G *)F_mat)[Rv0]=Rv4*Rv9;
      Ra.sl[3]=295; /* line # 295 */
      Rv8=F_n-Rv15;
      Ra.sl[3]=296; /* line # 296 */
      Rv5=Rv0+Rv8;
      Ra.sl[3]=297; /* line # 297 */
      Rv6=Rv6+Rv8;
      Rv15++;
    }
    Rv14++;
  }
  Ra.sl[3]=301; /* line # 301 */
  Rv0=1;
  Ra.sl[3]=302; /* line # 302 */
  Rv18=1;
  for( Rf2=F_n;Rf2>0;Rf2-- ) {
    Ra.sl[3]=304; /* line # 304 */
    Rv5=Rv0;
    Ra.sl[3]=305; /* line # 305 */
    Rv19=Rv18;
    for( Rf1=(F_n+1)-Rv18;Rf1>0;Rf1-- ) {
      Ra.sl[3]=307; /* line # 307 */
      Rv6=Rv0;
      Rv2=(F_n-Rv19)+1;
      Rv4=0.000000000000000E-001;
      Ra.sl[3]=308; /* line # 308 */
      for( Rf0=Rv2;Rf0>0;Rf0-- ) {
        Ra.sl[3]=310; /* line # 310 */
        Rv4=Rv4+((G *)F_mat)[Rv5]*((G *)F_mat)[Rv6];
        Ra.sl[3]=311; /* line # 311 */
        Rv5=Rv5+1;
        Rv6=Rv6+1;
      }
      Ra.sl[3]=313; /* line # 313 */
      ((G *)F_mat)[Rv0]=Rv4;
      Ra.sl[3]=314; /* line # 314 */
      Rv0=Rv0+1;
      Rv19++;
    }
    Rv18++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " solve "  */
void MXD_LSQ_FIT_solve(SL F_n, V F_mat, V F_bvc, V F_bsh, V F_vsg, G F_chi2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+176;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=338; /* line # 338 */
  Rv0=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=340; /* line # 340 */
    Rv1=0.000000000000000E-001;
    Ra.sl[3]=341; /* line # 341 */
    Rv2=Rv0;
    Ra.sl[3]=342; /* line # 342 */
    Rv3=F_n-1;
    Ra.sl[3]=343; /* line # 343 */
    Rv4=1;
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=345; /* line # 345 */
      Rv1=Rv1+((G *)F_mat)[Rv2]*((G *)F_bvc)[Rv4];
      Ra.sl[3]=346; /* line # 346 */
      if (Rv4<Rv0) {
        Ra.sl[3]=348; /* line # 348 */
        Rv2=Rv2+Rv3;
        Rv3=Rv3-1;
      }
      else {
        Ra.sl[3]=353; /* line # 353 */
        if (Rv0==Rv4&&((G *)((V *)F_vsg)[Rv0])[0]>=0.000000000000000E-001) {
          Ra.sl[3]=354; /* line # 354 */
          ((G *)((V *)F_vsg)[Rv0])[0]=sqrt(((G *)F_mat)[Rv2]*F_chi2);
        }
        Ra.sl[3]=355; /* line # 355 */
        Rv2=Rv2+1;
      }
      Rv4++;
    }
    Ra.sl[3]=358; /* line # 358 */
    ((G *)F_bsh)[Rv0]=Rv1;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_pdescr "  */
void MXD_LSQ_FIT_free_pdescr(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+183;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=369; /* line # 369 */
  if (Ri.v[0]!=NULL) {
    Ra.sl[3]=371; /* line # 371 */
    Rv0=Ri.v[0];
    Ra.sl[3]=372; /* line # 372 */
    while (Rv0!=NULL){
      Ra.sl[3]=374; /* line # 374 */
      Rv1=Rv0;
      Ra.sl[3]=375; /* line # 375 */
      Rv0=((V *)Rv0)[0];
      Ra.sl[3]=376; /* line # 376 */
      PAS__DISPOSE(&Rv1);
    }
  }
  Ra.sl[3]=379; /* line # 379 */
  Ri.v[0]=NULL;
  Ra.sl[3]=380; /* line # 380 */
  Ri.v[1]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init "  */
void P_lsq_Init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+196;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=390; /* line # 390 */
  if (Ri.v[2]!=NULL) {
    Ra.sl[3]=392; /* line # 392 */
    Rv0=Ri.v[2];
    Ra.sl[3]=393; /* line # 393 */
    while (Rv0!=NULL){
      Ra.sl[3]=395; /* line # 395 */
      Rv1=Rv0;
      Ra.sl[3]=396; /* line # 396 */
      Rv2=Rv1;
      Ra.sl[3]=398; /* line # 398 */
      PAS__DISPOSE(((V *)Rv2)+17);
      Ra.sl[3]=399; /* line # 399 */
      PAS__DISPOSE(((V *)Rv2)+16);
      Ra.sl[3]=400; /* line # 400 */
      PAS__DISPOSE(((V *)Rv2)+15);
      Ra.sl[3]=401; /* line # 401 */
      PAS__DISPOSE(((V *)Rv2)+14);
      Ra.sl[3]=402; /* line # 402 */
      PAS__DISPOSE(((V *)Rv2)+13);
      Ra.sl[3]=403; /* line # 403 */
      PAS__DISPOSE(((V *)Rv2)+12);
      Ra.sl[3]=404; /* line # 404 */
      PAS__DISPOSE(((V *)Rv2)+11);
      Ra.sl[3]=405; /* line # 405 */
      PAS__DISPOSE(((V *)Rv2)+10);
      Ra.sl[3]=406; /* line # 406 */
      Rv0=((V *)Rv2)[0];
      Ra.sl[3]=408; /* line # 408 */
      PAS__DISPOSE(&Rv1);
    }
  }
  Ra.sl[3]=411; /* line # 411 */
  if (Ri.v[0]!=NULL) MXD_LSQ_FIT_free_pdescr();
  Ra.sl[3]=412; /* line # 412 */
  if (Ri.v[3]!=NULL) PAS__DISPOSE(Ri.v+3);
  Ra.sl[3]=413; /* line # 413 */
  Ri.v[3]=NULL;
  Ra.sl[3]=415; /* line # 415 */
  V_chi2=1.000000000000000E+010;
  Ra.sl[3]=416; /* line # 416 */
  V_lchi2=V_chi2;
  Ra.sl[3]=417; /* line # 417 */
  V_chi2eps=1.000000000000001E-004;
  Ra.sl[3]=418; /* line # 418 */
  Rs.ub[0]=0;
  Ra.sl[3]=420; /* line # 420 */
  Ri.v[2]=NULL;
  Ra.sl[3]=421; /* line # 421 */
  Ri.v[4]=NULL;
  Ra.sl[3]=422; /* line # 422 */
  Rs.sl[1]=0;
  Ra.sl[3]=423; /* line # 423 */
  V_np=0;
  Ra.sl[3]=424; /* line # 424 */
  Rs.sl[2]=0;
  Ra.sl[3]=425; /* line # 425 */
  V_nsing=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_New_vparm "  */
SL P_lsq_New_vparm(G *F_prm, G *F_sig, G F_min, G F_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+206;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=437; /* line # 437 */
  Rv0=PAS__NEW(32);
  Ra.sl[3]=438; /* line # 438 */
  Rv1=Rv0;
  Ra.sl[3]=440; /* line # 440 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[3]=441; /* line # 441 */
  if (F_min==1.000000000000000E+030&&F_max==1.000000000000000E+030) F_min=-F_min;
  Ra.sl[3]=442; /* line # 442 */
  ((G *)Rv1)[1]=F_min;
  ((G *)Rv1)[2]=F_max;
  Ra.sl[3]=443; /* line # 443 */
  ((V *)Rv1)[6]=((V) F_prm);
  Ra.sl[3]=444; /* line # 444 */
  ((V *)Rv1)[7]=((V) F_sig);
  Ra.sl[3]=446; /* line # 446 */
  if (Ri.v[0]==NULL) Ri.v[0]=Rv0;
  else {
    Ra.sl[3]=447; /* line # 447 */
    ((V *)Ri.v[1])[0]=Rv0;
  }
  Ra.sl[3]=448; /* line # 448 */
  Ri.v[1]=Rv0;
  Ra.sl[3]=449; /* line # 449 */
  V_np=V_np+1;
  Ra.sl[3]=450; /* line # 450 */
  Rs.sl[2]=Rs.sl[2]+1;
  Ra.sl[3]=451; /* line # 451 */
  Ret=V_np;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_New_block "  */
SL P_lsq_New_block(G F_dmp, G F_mrq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Rv2;
  register SL Rv3;
  register SL Rv4;
  register SL Rv5;
  register SL Rv6;
  register SL Rv7;
  register SL Rv8;
  register SL Rv9;
  register SL Rv10;
  register SL Rv11;
  register SL Rv12;
  register SL Rv13;
  register SL Rv14;
  register SL Rv15;
  register SL Rv16;
  register SL Rv17;
  V Rv18;
  SL Rv19;
  register V Rv20;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+221;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=465; /* line # 465 */
  if (Rs.sl[2]>0) {
    Ra.sl[3]=467; /* line # 467 */
    Rv0=PAS__NEW(72);
    Ra.sl[3]=468; /* line # 468 */
    Rs.sl[1]=Rs.sl[1]+1;
    Ra.sl[3]=469; /* line # 469 */
    Rv1=Rv0;
    Ra.sl[3]=471; /* line # 471 */
    ((V *)Rv1)[0]=NULL;
    Ra.sl[3]=472; /* line # 472 */
    ((SL *)Rv1)[1]=Rs.sl[1];
    Ra.sl[3]=473; /* line # 473 */
    ((SL *)Rv1)[2]=0;
    Ra.sl[3]=474; /* line # 474 */
    ((SL *)Rv1)[3]=V_np-Rs.sl[2];
    Ra.sl[3]=475; /* line # 475 */
    ((SL *)Rv1)[4]=Rs.sl[2];
    Ra.sl[3]=476; /* line # 476 */
    ((G *)Rv1)[3]=F_dmp;
    Ra.sl[3]=477; /* line # 477 */
    ((G *)Rv1)[4]=F_mrq;
    Ra.sl[3]=478; /* line # 478 */
    Rv2=Rs.sl[2];
    ((V *)Rv1)[10]=PAS__NEW(Rv2*8+8);
    ((SL *)((V *)Rv1)[10])[0]=Rv2;
    Rv3=0;
    for( Rf0=Rv2;Rf0>0;Rf0-- )
    Rv3++;
    Ra.sl[3]=479; /* line # 479 */
    Rv4=Rs.sl[2];
    ((V *)Rv1)[11]=PAS__NEW(Rv4*8+8);
    ((SL *)((V *)Rv1)[11])[0]=Rv4;
    Rv5=0;
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    Rv5++;
    Ra.sl[3]=480; /* line # 480 */
    Rv6=Rs.sl[2];
    ((V *)Rv1)[12]=PAS__NEW(Rv6*8+8);
    ((SL *)((V *)Rv1)[12])[0]=Rv6;
    Rv7=0;
    for( Rf0=Rv6;Rf0>0;Rf0-- )
    Rv7++;
    Ra.sl[3]=481; /* line # 481 */
    Rv8=Rs.sl[2];
    ((V *)Rv1)[13]=PAS__NEW(Rv8*8+8);
    ((SL *)((V *)Rv1)[13])[0]=Rv8;
    Rv9=0;
    for( Rf0=Rv8;Rf0>0;Rf0-- )
    Rv9++;
    Ra.sl[3]=482; /* line # 482 */
    Rv10=Rs.sl[2];
    ((V *)Rv1)[14]=PAS__NEW(Rv10*8+8);
    ((SL *)((V *)Rv1)[14])[0]=Rv10;
    Rv11=0;
    for( Rf0=Rv10;Rf0>0;Rf0-- )
    Rv11++;
    Ra.sl[3]=483; /* line # 483 */
    Rv12=(Rs.sl[2]*(Rs.sl[2]+1))/2;
    ((V *)Rv1)[15]=PAS__NEW(Rv12*8+8);
    ((SL *)((V *)Rv1)[15])[0]=Rv12;
    Rv13=0;
    for( Rf0=Rv12;Rf0>0;Rf0-- )
    Rv13++;
    Ra.sl[3]=484; /* line # 484 */
    Rv14=Rs.sl[2];
    ((V *)Rv1)[16]=PAS__NEW(Rv14*4+4);
    ((SL *)((V *)Rv1)[16])[0]=Rv14;
    Rv15=0;
    for( Rf0=Rv14;Rf0>0;Rf0-- )
    Rv15++;
    Ra.sl[3]=485; /* line # 485 */
    Rv16=Rs.sl[2];
    ((V *)Rv1)[17]=PAS__NEW(Rv16*4+4);
    ((SL *)((V *)Rv1)[17])[0]=Rv16;
    Rv17=0;
    for( Rf0=Rv16;Rf0>0;Rf0-- )
    Rv17++;
    Ra.sl[3]=486; /* line # 486 */
    Rv18=Ri.v[0];
    Ra.sl[3]=487; /* line # 487 */
    Rv19=1;
    for( Rf0=Rs.sl[2];Rf0>0;Rf0-- ) {
      Ra.sl[3]=488; /* line # 488 */
      Rv20=Rv18;
      Ra.sl[3]=490; /* line # 490 */
      ((V *)((V *)Rv1)[16])[Rv19]=((V *)Rv20)[6];
      Ra.sl[3]=491; /* line # 491 */
      ((V *)((V *)Rv1)[17])[Rv19]=((V *)Rv20)[7];
      Ra.sl[3]=492; /* line # 492 */
      ((G *)((V *)Rv1)[13])[Rv19]=((G *)Rv20)[1];
      Ra.sl[3]=493; /* line # 493 */
      ((G *)((V *)Rv1)[14])[Rv19]=((G *)Rv20)[2];
      Ra.sl[3]=494; /* line # 494 */
      Rv18=((V *)Rv20)[0];
      Rv19++;
    }
    Ra.sl[3]=497; /* line # 497 */
    if (Ri.v[2]==NULL) Ri.v[2]=Rv0;
    else {
      Ra.sl[3]=498; /* line # 498 */
      ((V *)Ri.v[4])[0]=Rv0;
    }
    Ra.sl[3]=499; /* line # 499 */
    Ri.v[4]=Rv0;
    Ra.sl[3]=500; /* line # 500 */
    MXD_LSQ_FIT_free_pdescr();
    Ra.sl[3]=501; /* line # 501 */
    Rs.sl[2]=0;
  }
  Ra.sl[3]=503; /* line # 503 */
  Ret=Rs.sl[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_Set_dmp_mrq "  */
void P_lsq_Set_dmp_mrq(SL F_id, G F_dmp, G F_mrq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+236;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=515; /* line # 515 */
  if (F_id<=0) F_id=1;
  Ra.sl[3]=516; /* line # 516 */
  if (F_dmp<=0.000000000000000E-001||F_dmp>1.000000000000000E+000) F_dmp=1.000000000000000E+000;
  Ra.sl[3]=517; /* line # 517 */
  if (F_mrq<0.000000000000000E-001||F_mrq>1.000000000000000E+000) F_mrq=1.000000000000000E+000;
  Ra.sl[3]=518; /* line # 518 */
  Rv0=Ri.v[2];
  Ra.sl[3]=519; /* line # 519 */
  while (Rv0!=NULL){
    Ra.sl[3]=520; /* line # 520 */
    Rv1=Rv0;
    Ra.sl[3]=522; /* line # 522 */
    if (F_id==((SL *)Rv1)[1])  break;
    Ra.sl[3]=523; /* line # 523 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=525; /* line # 525 */
  if (Rv0!=NULL) {
    Ra.sl[3]=526; /* line # 526 */
    Rv2=Rv0;
    Ra.sl[3]=528; /* line # 528 */
    ((G *)Rv2)[3]=F_dmp;
    Ra.sl[3]=529; /* line # 529 */
    ((G *)Rv2)[4]=F_mrq;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init_cycle "  */
void P_lsq_Init_cycle(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+253;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=544; /* line # 544 */
  V_ndat=0;
  Ra.sl[3]=545; /* line # 545 */
  V_nchi2=0.000000000000000E-001;
  Ra.sl[3]=546; /* line # 546 */
  Rv0=Ri.v[2];
  Ra.sl[3]=547; /* line # 547 */
  while (Rv0!=NULL){
    Ra.sl[3]=548; /* line # 548 */
    Rv1=Rv0;
    Ra.sl[3]=550; /* line # 550 */
    Rv2=((V *)Rv1)[10];
    Ra.sl[3]=551; /* line # 551 */
    Rv3=((V *)Rv1)[15];
    Ra.sl[3]=552; /* line # 552 */
    Rv4=((SL *)Rv1)[4];
    Ra.sl[3]=553; /* line # 553 */
    Rv5=1;
    for( Rf0=Rv4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=555; /* line # 555 */
      ((G *)Rv2)[Rv5]=0.000000000000000E-001;
      Rv5++;
    }
    Ra.sl[3]=557; /* line # 557 */
    Rv6=1;
    for( Rf0=(Rv4*(Rv4+1))/2;Rf0>0;Rf0-- ) {
      ((G *)Rv3)[Rv6]=0.000000000000000E-001;
      Rv6++;
    }
    Ra.sl[3]=558; /* line # 558 */
    Rv0=((V *)Rv1)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_elem "  */
void P_lsq_Set_elem(G F_delta, G F_weight, V F_drvtab, SL F_size){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  SL Rv5;
  SL Rv6;
  G Rv7;
  G Rv8;
  SL Rv9;
  register G Rgg;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+269;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=574; /* line # 574 */
  Rv0=F_delta*F_weight;
  Ra.sl[3]=575; /* line # 575 */
  Rv1=Ri.v[2];
  Ra.sl[3]=576; /* line # 576 */
  while (Rv1!=NULL){
    Ra.sl[3]=577; /* line # 577 */
    Rv2=Rv1;
    Ra.sl[3]=579; /* line # 579 */
    Rv3=((V *)Rv2)[10];
    Ra.sl[3]=580; /* line # 580 */
    Rv4=((V *)Rv2)[15];
    Ra.sl[3]=581; /* line # 581 */
    Rv5=0;
    Ra.sl[3]=582; /* line # 582 */
    Rv6=1;
    for( Rf1=((SL *)Rv2)[4];Rf1>0;Rf1-- ) {
      Ra.sl[3]=584; /* line # 584 */
      Rv7=((G *)F_drvtab)[Rv6-1]*F_weight;
      Ra.sl[3]=585; /* line # 585 */
      Rv8=(Rv7*F_weight)*((G *)Rv2)[4];
      Ra.sl[3]=586; /* line # 586 */
      ((G *)Rv3)[Rv6]=((G *)Rv3)[Rv6]+Rv0*Rv7;
      Ra.sl[3]=587; /* line # 587 */
      Rv5=Rv5+1;
      Ra.sl[3]=588; /* line # 588 */
      ((G *)Rv4)[Rv5]=((G *)Rv4)[Rv5]+Rv7*Rv7;
      Ra.sl[3]=589; /* line # 589 */
      Rv9=Rv6+1;
      for( Rf0=(((SL *)Rv2)[4]+1)-(Rv6+1);Rf0>0;Rf0-- ) {
        Ra.sl[3]=591; /* line # 591 */
        Rv5=Rv5+1;
        Ra.sl[3]=592; /* line # 592 */
        ((G *)Rv4)[Rv5]=((G *)Rv4)[Rv5]+Rv8*((G *)F_drvtab)[Rv9-1];
        Rv9++;
      }
      Rv6++;
    }
    Ra.sl[3]=595; /* line # 595 */
    Rv1=((V *)Rv2)[0];
  }
  Ra.sl[3]=597; /* line # 597 */
  V_ndat=V_ndat+1;
  Ra.sl[3]=598; /* line # 598 */
  V_nchi2=V_nchi2+Rv0*Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init_derv "  */
void P_lsq_Init_derv(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+283;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=606; /* line # 606 */
  if (Ri.v[3]==NULL) {
    Rv0=V_np;
    Ri.v[3]=PAS__NEW(Rv0*8+8);
    ((SL *)Ri.v[3])[0]=Rv0;
    Rv1=0;
    for( Rf0=Rv0;Rf0>0;Rf0-- )
    Rv1++;
  }
  Ra.sl[3]=607; /* line # 607 */
  Rv2=1;
  for( Rf0=V_np;Rf0>0;Rf0-- ) {
    ((G *)Ri.v[3])[Rv2]=0.000000000000000E-001;
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_derv "  */
void P_lsq_Set_derv(SL F_id, G F_drv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+298;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=615; /* line # 615 */
  if (Ri.v[3]==NULL) P_lsq_Init_derv();
  Ra.sl[3]=616; /* line # 616 */
  if (F_id>=1&&F_id<=((SL *)Ri.v[3])[0]) {
    Ra.sl[3]=617; /* line # 617 */
    ((G *)Ri.v[3])[F_id]=((G *)Ri.v[3])[F_id]+F_drv;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_contr "  */
void P_lsq_Set_contr(G F_delta, G F_weight){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+312;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=625; /* line # 625 */
  if (Ri.v[3]!=NULL) {
    Ra.sl[3]=626; /* line # 626 */
    P_lsq_Set_elem(F_delta, F_weight, Ri.v[3]+8,((SL *)Ri.v[3])[0]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Process "  */
UB P_lsq_Process(UB F_bend, UB F_bchg, UB F_bmrq, G F_ch_parm(SL F_i, G F_v_o, G
F_v_n, G F_v_c, G F_v_s, G F_min, G F_max)){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  G Rv8;
  register V Rv9;
  SL Rv10;
  G Rv11;
  G Rv12;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+327;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=641; /* line # 641 */
  V_nsing=0;
  Ra.sl[3]=642; /* line # 642 */
  V_lchi2=V_chi2;
  Ra.sl[3]=643; /* line # 643 */
  if (V_ndat>V_np) V_chi2=V_nchi2/(double)(V_ndat-V_np);
  else {
    Ra.sl[3]=644; /* line # 644 */
    V_chi2=V_nchi2;
  }
  Ra.sl[3]=645; /* line # 645 */
  Rv0=Ri.v[2];
  Ra.sl[3]=646; /* line # 646 */
  while (Rv0!=NULL){
    Ra.sl[3]=647; /* line # 647 */
    Rv1=Rv0;
    Ra.sl[3]=652; /* line # 652 */
    MXD_LSQ_FIT_matinv(((SL *)Rv1)[4],((V *)Rv1)[15],((V *)Rv1)[10],((V *)Rv1)[17]
    ,((SL *)Rv1)+2);
    Ra.sl[3]=653; /* line # 653 */
    MXD_LSQ_FIT_solve(((SL *)Rv1)[4],((V *)Rv1)[15],((V *)Rv1)[10],((V *)Rv1)[11]
    ,((V *)Rv1)[17],V_chi2);
    Ra.sl[3]=654; /* line # 654 */
    V_nsing=V_nsing+((SL *)Rv1)[2];
    Ra.sl[3]=659; /* line # 659 */
    if (F_bend) {
      Ra.sl[3]=661; /* line # 661 */
      Rv2=1;
      Ra.sl[3]=662; /* line # 662 */
      Rv3=2;
      Ra.sl[3]=663; /* line # 663 */
      Rv4=((SL *)Rv1)[4];
      Ra.sl[3]=664; /* line # 664 */
      Rv5=((V *)Rv1)[15];
      Ra.sl[3]=665; /* line # 665 */
      while (Rv4>1){
        Ra.sl[3]=667; /* line # 667 */
        Rv6=Rv2+Rv4;
        Ra.sl[3]=668; /* line # 668 */
        Rv7=Rv4-1;
        Ra.sl[3]=669; /* line # 669 */
        while (Rv7>0){
          Ra.sl[3]=671; /* line # 671 */
          Rv8=fabs(((G *)Rv5)[Rv2]*((G *)Rv5)[Rv6]);
          Ra.sl[3]=672; /* line # 672 */
          if (Rv8>=1.000000000000001E-004) ((G *)Rv5)[Rv3]=((G *)Rv5)[Rv3]/sqrt(
          Rv8);
          else {
            Ra.sl[3]=673; /* line # 673 */
            ((G *)Rv5)[Rv3]=0.000000000000000E-001;
          }
          Ra.sl[3]=674; /* line # 674 */
          Rv3=Rv3+1;
          Ra.sl[3]=675; /* line # 675 */
          Rv6=Rv6+Rv7;
          Ra.sl[3]=676; /* line # 676 */
          Rv7=Rv7-1;
        }
        Ra.sl[3]=678; /* line # 678 */
        Rv3=Rv3+1;
        Ra.sl[3]=679; /* line # 679 */
        Rv2=Rv2+Rv4;
        Ra.sl[3]=680; /* line # 680 */
        Rv4=Rv4-1;
      }
    }
    Ra.sl[3]=683; /* line # 683 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=687; /* line # 687 */
  if ((F_bchg&&F_bmrq)&&Rs.ub[0]) {
    Ra.sl[3]=688; /* line # 688 */
    if (V_chi2-V_lchi2>V_chi2eps) F_bchg=0;
  }
  Ra.sl[3]=690; /* line # 690 */
  if (F_bchg) {
    Ra.sl[3]=692; /* line # 692 */
    Rv0=Ri.v[2];
    Ra.sl[3]=693; /* line # 693 */
    while (Rv0!=NULL){
      Ra.sl[3]=694; /* line # 694 */
      Rv9=Rv0;
      Ra.sl[3]=696; /* line # 696 */
      Rv10=1;
      for( Rf0=((SL *)Rv9)[4];Rf0>0;Rf0-- ) {
        Ra.sl[3]=698; /* line # 698 */
        Rv8=((G *)((V *)((V *)Rv9)[16])[Rv10])[0];
        Ra.sl[3]=699; /* line # 699 */
        ((G *)((V *)Rv9)[12])[Rv10]=Rv8;
        Ra.sl[3]=700; /* line # 700 */
        Rv11=((G *)Rv9)[3]*((G *)((V *)Rv9)[11])[Rv10];
        Ra.sl[3]=701; /* line # 701 */
        Rv12=Rv8+Rv11;
        Ra.sl[3]=702; /* line # 702 */
        ((G *)((V *)((V *)Rv9)[16])[Rv10])[0]=(*F_ch_parm)(Rv10+((SL *)Rv9)[3],Rv8,
        Rv12, Rv11,((G *)((V *)((V *)Rv9)[17])[Rv10])[0],((G *)((V *)Rv9)[13])[Rv10]
        ,((G *)((V *)Rv9)[14])[Rv10]);
        Rv10++;
      }
      Ra.sl[3]=704; /* line # 704 */
      Rv0=((V *)Rv9)[0];
    }
    Ra.sl[3]=706; /* line # 706 */
    Rs.ub[0]=1;
  }
  Ra.sl[3]=708; /* line # 708 */
  Ret=F_bchg;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_Restore_parm "  */
void P_lsq_Restore_parm(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+340;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=719; /* line # 719 */
  Rv0=Ri.v[2];
  Ra.sl[3]=720; /* line # 720 */
  while (Rv0!=NULL){
    Ra.sl[3]=721; /* line # 721 */
    Rv1=Rv0;
    Ra.sl[3]=723; /* line # 723 */
    Rv2=1;
    for( Rf0=((SL *)Rv1)[4];Rf0>0;Rf0-- ) {
      Ra.sl[3]=724; /* line # 724 */
      ((G *)((V *)((V *)Rv1)[16])[Rv2])[0]=((G *)((V *)Rv1)[12])[Rv2];
      Rv2++;
    }
    Ra.sl[3]=725; /* line # 725 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=727; /* line # 727 */
  V_chi2=V_lchi2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Correl "  */
G P_lsq_Correl(SL F_ii, SL F_jj){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+358;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=740; /* line # 740 */
  if (F_ii==F_jj) Rv0=1.000000000000000E+000;
  else {
    Ra.sl[3]=744; /* line # 744 */
    Rv0=0.000000000000000E-001;
    Ra.sl[3]=745; /* line # 745 */
    Rv1=Ri.v[2];
    Ra.sl[3]=746; /* line # 746 */
    Rv2=F_ii;
    Ra.sl[3]=747; /* line # 747 */
    while (Rv1!=NULL){
      Ra.sl[3]=748; /* line # 748 */
      Rv3=Rv1;
      Ra.sl[3]=750; /* line # 750 */
      if (F_ii<=((SL *)Rv3)[4])  break;
      Ra.sl[3]=751; /* line # 751 */
      F_ii=F_ii-((SL *)Rv3)[4];
      Ra.sl[3]=752; /* line # 752 */
      F_jj=F_jj-((SL *)Rv3)[4];
      Ra.sl[3]=753; /* line # 753 */
      Rv1=((V *)Rv3)[0];
    }
    Ra.sl[3]=755; /* line # 755 */
    if (Rv1!=NULL) {
      Ra.sl[3]=756; /* line # 756 */
      Rv4=Rv1;
      Ra.sl[3]=757; /* line # 757 */
      if (F_jj>0&&F_jj<=((SL *)Rv4)[4]) {
        Ra.sl[3]=759; /* line # 759 */
        if (F_jj<F_ii) {
          Ra.sl[3]=760; /* line # 760 */
          Rv2=F_ii;
          F_ii=F_jj;
          F_jj=Rv2;
        }
        Ra.sl[3]=761; /* line # 761 */
        Rv2=(((SL *)Rv4)[4]*(F_ii-1)+F_jj)-(F_ii*(F_ii-1))/2;
        Ra.sl[3]=762; /* line # 762 */
        Rv0=((G *)((V *)Rv4)[15])[Rv2];
      }
    }
  }
  Ra.sl[3]=765; /* line # 765 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " alloc_lsq_matvect "  */
void P_alloc_lsq_matvect(){

  /* Code of procedure/function */
}


/* Procedure/Function : " execute_lsq_fit "  */
void P_execute_lsq_fit(){

  /* Code of procedure/function */
}
