%pragma trace 1;
{
		S Y S T E M E * M X D *

	   L E A S T   S Q U A R E   P R O G R A M



	   BY :
		P. WOLFERS
		C.N.R.S.
		LABORATOIRE DE CRISTALLOGRAPHIE
		B.P.  166 X   38042  GRENOBLE CEDEX
					FRANCE.

}
{  VERSION 3.9 - E	OF  M-X-D  SYSTEM  }

{
PW3_LSQ01-	External data and fourier support.

PW3_LSQ02-	Full correction support.

PW3_LSQ03-	Full mixed xray/n magnetic mode support.
		addition of $fn2 and $fm2 support.

PW3_LSQ04-	Contribution and dynamic Weight Support.

PW3_LSQ05-	Paramater display on LISTHKL output support.

PW3_LSQ06-	Support of modulo form of LIMITS statement for inf > sup.

PW3_LSQ07-	Support for selective listing LISTHKL output based
		on a minimal delta/sigma value.

PW3_LSQ08-	Support for reflexion rejection based on an minimal
		delta/sigma value.

PW3_LSQ09-	Change LISTHKL with magnetic moments default output
		to display nuclear f2, magnetic f2 and total f2.
		Add the option 19 (BLISTFMAG) to set old output mode.

PW3_LSQ10-	Support for the two parameter atan function (phasearg).


PW3_LSQ11-	Implement the new option nfsing to continue one singular
		matrix.

PW3_LSQ12-	Add the 3.2 implementation of summop :
			The standart function for summation,
		and the User Defined Function support.

PW3_LSQ13-	Add the 3.2 supprot of the functions :
		INTSEL(<sel>,<f1>,<f2>,...),
		ABS(<exp>), ROUND(<exp>), MODULO(<exp1>,<exp2>).

PW3_LSQ14-	Add the full support of the compoare operators :
		=, <>, <, <=, >=, and >.


PW3_LSQ15-	Add the groupe space generation support.


PW3_LSQ16-	Add the error message output support.

PW3_LSQ17-	Add support for the V3.4 none derivate symbols
		$FNR, $FNI, $FMXR, $FMYR, $FMZR, $FMXI, $FMYI, $FMZI.
		Add also the option 25 to output it in listing in place
		of normal magnetic structure factors.

PW3_LSQ18-	Add Fcalc text output file support for fourier program
		as MK_3 input file (option 26).

PW3_LSQ19-	Now MXDLSQ has the full support of the mixed pseudo variable
                dependant variable parameters (change in CPF2CORR).

PW3_LSQ20-      Add Standard Ascii output file of Atoms for ORTEP
                ( option 27 ).

PW3_LSQ21-      Add save variable file for each cycle,
		that can be deselected by option SAVEFILE.

PW3_LSQ22-      Add computer display option, for interactive.


PW3_LSQ24-      Set to portable pascal version.


PW3_LSQ25-      Add the Marquward/Landquark support.


PW3_LSQ26-      Add the support of long identifier (until 16 character).


PW3_LSQ27-      Add the support of listing options of version 3.9 .

PW3_LSQ28-      Add the numeric error trap managment.

PW3_LSQ29-      Add bessel_j function support.

}

{
      CPAS PASCAL ADAPTATION  FLAGGED BY  THE COMMENT

      OPERATING SYSTEM AND COMPUTER SENSIBLE POINTS :

		(** CPAS **)




{[inherit('MXDRTL', 'MXDLSRT')]}
program MXD_LSQ( input, output );
{
   BY P. WOLFERS C.N.R.S. GRENOBLE
     LAB. DE CRISTALLOGRAPHIE
}

%include 'mxdsrc:mxd_lsl_env';

label MXD_LSQ_STOP;

{****************************************************************}
{*******************  CONSTANT DECLARATIONS  ********************}
{****************************************************************}

const

  max_stkp  = 1024;      { Size of the fovalue/deriv parm stask for trap }
  maxdspltb = 4;	 { maximum number of displayable parameters }
  e2gmc2    = 0.26950;	 { e^2*gamma/(m*c^2) }
  depi      = 6.2831853; { 2*PI }
  e2gmc2s   = 0.07263;	 { SQR(e^2*gamma/(m*c^2)) }
  e2gmc2s2  = 0.036315;	 { SQR(e^2*gamma/(m*c^2))/2 }

  { if nv = maximum number of variables then maxmat = nv*(nv+1)/2 + 12*nv }
  { maxmat = 6250  for 100 variables }
  { maxmat = 126250  for 500 variables }
  { presently 500 var. max }
  maxmat     = {6050} 126250; { size of matrix work space }

  lstnam     = 'TT:';         { default listing file specification to terminal }

  errspcfile = 'MXDLIB:mxd_lsq.err'; { error file listing specification }

  { title must be 60 char long }
  title = ' M X D L S Q  - P.Wolfers Software: MXD V3.9-E of 01-NOV-97 ';



{**********************************************************}
{******************  TYPE DECLARATIONS  *******************}
{**********************************************************}

type

  polacod = packed array[1..4] of char;

  cache_el = record
    ch,    ck,    cl: integer; { reflexion index }
    cfnr,  cfni,               { nuclear structure factor }
    crfmx, crfmy, crfmz,       { magnetic structure factor }
    cifmx, cifmy, cifmz: real;
    ifnr,  ifni,                { related derivate vectors index }
    irfx,  irfy,  irfz,
    iifx,  iify,  iifz:  integer;
  end;


{**************************************************************}
{******************  VARIABLE DECLARATIONS  *******************}
{**************************************************************}

var

  { matrice and vector definitions }

  blkvsta,		     { begin of current lsqblk }
  topmat: integer;	     { top of matrixs in am }

  ialloc: integer;	     { top of vector allocation }

  am: array[1..maxmat] of real;	{ least square matrix and vectors }


  refcod: array[1..7] of polacod;


  fcomicpu,		     { partial origine of $cacl cpu time }
  fcomcpu,		     { computed cpu time }
  fbmaticpu,		     { partial orig. of matrix cpu time }
  fbmatcpu,		     { buidt matrix cpu time }
  finvmaticpu,		     { partial orig. of invers. cpu time }
  finvmatcpu: integer;	     { matrix inversion cpu time }

  dspltab: array[1..maxdspltb] of ptr; { pointer table of disp. param }
  idspltb: integer;	     { index/number of displayable param }

  mk3filespc,		     { mk3 file specification }
  ofilespc: stp;	     { output result file specification }

  minstsl,		     { minimal sin(theta)/lambda for select refl.}
  maxstsl,		     { maximal sin(theta)/lambda for select refl.}
  maxsing,		     { relative max. # of matrix singularity }
  mindiag,		     { minimal pivot value }
  mxcorrel,		     { maximal correlation coefficient output }
  minhkllst,		     { minimal value of delta/sigma to listhkl }
  minhklrej: real;	     { minimal value of delta/sigma to rejection }

  hmi, hma, kmi,
  kma, lmi, lma,             { minmaxi on h k l }
  nvarrot,		     { number of unlocked variable rotation list }
  cyclenb,		     { current cycle # }
  ncycle: integer;	     { total number of cycle }


  baccconv,		     { option to activate the conv. acceleration }
  bselinlst,		     { option to set nbsel in the hkl list }
  blisthkl,		     { option of hkl list on all cycles }
  blistref,		     { option of hkl list on last cycle }
  blistfmag,		     { option of proj. magn. structure fact. list }
  blistftmag,		     { option of not proj. mag. struc. fact. list }
  boutmk3,		     { option to create an mk_3 file }
  boutatom,                  { option to create a standard atom file }
  blistver,		     { option of list particular residus on last cycle }
  blistvnd,		     { option to list particular residus on eachcycle }
  blstres,		     { option of result list on each cycle }
  blstmat,		     { option of lsq-matrix output before exit }
  blstcorr,		     { validation of blstmat boolean }
  blstparam,		     { option to list the parameters at the end }
  bdupdate,		     { option of update the data file }
  bdmpsig,		     { dump output of sigma and correlation }
  boutdat,		     { bpupdate on presently }
  boutinst,		     { option of initiale output }
  boutenst,		     { option of finale structure output }
  boutsym,		     { option to output symetry operator }
  bdsppar,		     { flag displayable parameter exist }
  bnfsing,		     { flag for non fatal singular matrix }
  bsavcycle,                 { save cycle flag }

  bmini,		     { init magnetic structure factors }
  bfini: boolean;	     { init nuclear structure factor }

  parmstp: 0..max_stkp := 0; { stack pointer for fovalue/deriv trap }
  parmstk: array[1..max_stkp] of ptr; { stack for fovalue/deriv trap }

  ldisplayper,               { live display period }
  itopvect,		     { top of f2 vectors }
  ineumem,		     { origine of +/- neutron flipping memory tb. }
  imemory,		     { origine of the shift vector memory }
  ictetrm,		     { origine in am of lsq col. const. matrix }
  idervec,		     { origine in am of calc. derivate table }
  ivtfn,   ivtfm,	     { origine in am of the fn and fm derivates }
  ivtnr,   ivtni,	     { origines in am of fn derivate tables }
  ivrx, ivix, ivry,
  iviy, ivrz, iviz: integer; { and also for fmx,y,z }

  mk3x, mk3y, mk3z,    { normalized vector to project fm }

  gswobs2, gswobs, gsobs2, gsobs,
  gwres,   gwcres, guwres, guwcres: real; { global residus }

  lchi2,   cchi2,  lmaxf,  cmaxf:   real; { last and current chi2 & maxf }

  
  { particular output files }

  mk3out: text;              { mk3 magnetic output file }

  odat: bcf_file;            { fourier data output }


{**********************************************************************}
{******************     PROCEDURES OF MXDLSQ   ************************}
{**********************************************************************}



procedure SET_PAGEHEADING;
begin
  pageheadpt2^.l := CHR( 0 );
  if cyclenb > 0 then
  begin
    ST_PUT_PASTR( pageheadpt2^, 'cycle# ' );
    if cyclenb < ncycle then ST_PUT_INT( pageheadpt2^, cyclenb, 3 )
                        else ST_PUT_INT( pageheadpt2^, ncycle,  3 );
    ST_PUT_PASTR( pageheadpt2^, ', ' )
  end
  else ST_PUT_MCHAR( pageheadpt2^, ' ', 12 )
end SET_PAGEHEADING;




{//////////////////     PROCEDURES SET MXDUT1   \\\\\\\\\\\\\\\\\\\\\\\\}



{ listder is used to build and initialize the list of partial
  derivate for each defined parameter
  must be done with original variable sequence number
  - then - before any call of setrealvar and iniblk
}
procedure LISTDER;
var
  pl: ptder;
  p:  ptr;
  qt: array[0..6] of ptr;
  id: integer;

  procedure LOOKVAR( pt: ptr; bvok: boolean );
  var
    pa, pb:        ptr;
    p0, p1, p2:    ptder;
    id0, id1, id2: integer;
    bl:            boolean;

  begin
    with pt^ do
    case nodety of
      eqop,  neop,  ltop,  leop,  geop,
      gtop,  modop { no derivate binary op. }:
	begin
          LOOKVAR( bin1, false ); LOOKVAR( bin2, false )
        end;
      addop, subop, mulop, divop,
      powop, phaseop { binary op. with derivate }:
	begin
          LOOKVAR( bin1, bvok );  LOOKVAR( bin2, bvok )
        end;
      negop, sqrto, expop, logop, sinop,
      cosop, tanop, atano, asino, acoso,
      thop,  absop { unary op. }: LOOKVAR( una1, bvok );
      bess1op: begin
                 LOOKVAR( bess1_n, false ); LOOKVAR( bess1_x, bvok )
               end;
      intop { no derivate op. code }: LOOKVAR( una1, false );
      ipwop: LOOKVAR( rpw, bvok );
      varrf: { real or virtual variable node }
	if matind <> 0 then { unfixed variable only }
	begin
	  id0 := sq.sequ; { get original variable sequence number }
	  p0  := pl; bl := false; p1 := nil;
	  id1 := -100;    { must be lower than any real or virtual var. ref }
	  while (p0 <> nil) and not bl do
	  begin
	    id1 := p0^.idvar^.sq.sequ;
	    bl  := (id0 <= id1);
	    if not bl then
	    begin
	      p1 := p0;
	      p0 := p0^.next
	    end
	  end;
	  if (id1 <> id0) and bvok then
	  { must be inserted or appended }
	  begin
	    NEW( p2 ); p2^.next := p0;
	    if p1 = nil then pl := p2 else p1^.next := p2;
	    with p2^ do
	    begin  idvar := pt; derval := 0.0  end
	  end;
	  if id0 < 0 then { virtual variable reference }
	    if id0 = -1 then { $calc ref }
	    begin
	      if id < 6 then id := 6 { set $calc varbl class }
	    end
	    else
	    if id0 = -4 then { $f2pol ref }
	    begin
	      if id < 5 then id := 5 { set $f2pol varbl class }
	    end
	    else
	    begin { $fn2 or $fm2 dependent class }
	      if id < 4 then id := 4 { set virtual varbl class }
	    end
	end;
      contrf: { contribution reference }
	if id < 6 then id := 6; { set $calc class }
      sumhkl { no derivate op. code }: id := 3; { h k l dep. }
      parrf: LOOKVAR( definition, bvok );
      tabrf: if id < 2 then id := 2;
      intrf: case idx of
	  0,1,2,3,4,5,6,7,8,9,13,14,15,16,17,18,19:
	    if id < 2 then id := 2; { ref. dep. }
	  10,11,12: if id < 1 then id := 1; { q wave dep. }
	  20,21,22: if id < 3 then id := 3; { symtry h k l dep. }
	  27,28,29,30,31,32,33,34: if id < 4 then id := 4{ compt. cte par. };
	  23,24,25,26: { one cycle change parameters }
	end;
      selnd, islnd: begin if id < 0 then id := 0;
	  if nodety = islnd then
	  begin
	    LOOKVAR( seltb[0], false ); id2 := 1
	  end  else id2 := 0;
	  for id0 := id2 to selsize-1 do
	    if seltb[id0] <> nil then LOOKVAR( seltb[id0], bvok )
	end;
      summop { summation operator }:  LOOKVAR( loopexp, bvok );
      functcall, formalcall { user function call }:
	begin
	  pa := seltb[selsize]; { get function pointer }
	  if nodety = formalcall then pa := pa^.actuallink; { formal call }
	  pb := pa^.formallst; { get model call list }
	  id0 := 0; { start from first parameter }
	  while pb <> nil do
	  begin
	    if id0 < selsize then pb^.actuallink := seltb[id0]
	    else pb^.actuallink := nil;
	    id0 := id0 + 1; pb := pb^.nextfo
	  end;
	  LOOKVAR( pa^.exprvalue, bvok ) { scan the function }
	end;
      formalrf { formal scalar reference }: LOOKVAR( actuallink, bvok );
      indxrf, konst, otheritem:
    end
  end LOOKVAR;

begin { LISTDER }
  p := parhde;
  for id := 0 to 6 do qt[id] := nil;
  while p <> nil do { scan on all defined parameter in definition order }
  begin
    pl := nil; id := -1;
    with p^ do
    begin
      LOOKVAR( definition, true ); lstder := pl;
      if id > -1 then
      begin { addition to the end of list }
	if qt[id] = nil then pardhde[id] := p else qt[id]^.spclnk := p;
	qt[id] := p; spclnk := nil
      end
    end;
    p := p^.next
  end
end LISTDER;




{//////////////////     PROCEDURES OF MXDUT2   \\\\\\\\\\\\\\\\\\\\\\\\}


function USERCALL( pn, pv: ptr; bf: boolean ): real; forward;


function SUMLOOP( pn, pv: ptr ): real; forward;



function VALUE( p: ptr ): real;
{ result is the value of the given p^ parameter }
begin
  if p = nil then VALUE := 0.0 else VALUE := p^.actval
end VALUE;



function FOVALUE( p: ptr ): real;
{ to comput an expression value }
var
  r: real;

begin { FOVALUE }
  if parmstp < max_stkp then parmstp := SUCC( parmstp );
  parmstk[parmstp] := p;
  if p = nil then fovalue := 0.0 else
  with p^ do
  case nodety of
    addop: FOVALUE := FOVALUE( bin1 ) + FOVALUE( bin2 );
    subop: FOVALUE := FOVALUE( bin1 ) - FOVALUE( bin2 );
    mulop: begin
             valb1 := FOVALUE( bina1 ); valb2 := FOVALUE( bina2 );
             FOVALUE := valb1*valb2
           end;
    divop: begin   
             valb1 := FOVALUE( bina1 ); valb2 := FOVALUE( bina2 );
             FOVALUE := valb1/valb2
           end;
    powop: begin
             valb1 := FOVALUE( bina1 ); valb2 := FOVALUE( bina2 );
             FOVALUE := EXP( valb2*LN( valb1 ) )
           end;
    negop: FOVALUE := - FOVALUE( una1 );
    sqrto: begin valu := SQRT( FOVALUE( unaa1 ) ); FOVALUE := valu end;
    logop: begin valu := FOVALUE( unaa1 ); FOVALUE := LN( valu ) end;
    expop: begin valu := EXP( FOVALUE( unaa1 ) ); FOVALUE := valu end;
    sinop: begin valu := inrd*FOVALUE( unaa1 ); FOVALUE := SIN( valu ) end;
    cosop: begin valu := inrd*FOVALUE( unaa1 ); FOVALUE := COS( valu ) end;
    tanop: begin
             valu := inrd*FOVALUE( unaa1 );
		r := SIN( valu ); FOVALUE := r/SQRT( 1.0 - SQR( r ) )
	   end;
    asino: begin
             valu := FOVALUE( unaa1 ); FOVALUE := ARCSIN( valu )/inrd
           end;
    acoso: begin
             valu := FOVALUE( unaa1 ); FOVALUE := 90.0 - ARCSIN( valu )/inrd
           end;
    atano: begin valu := FOVALUE( unaa1 ); FOVALUE := ARCTAN( valu )/inrd end;
    thop:  begin valu := FOVALUE( unaa1 ); FOVALUE := TANH( valu ) end;
    ipwop: begin
             valwpa := FOVALUE( unaa1 ); FOVALUE := valwpa**ipw
           end;
    konst: FOVALUE := val;
    tabrf: FOVALUE := cdrec.tbdif[idx];
    intrf:
	  case idx of
	    0: FOVALUE := hr;
	    1: FOVALUE := kr;
	    2: FOVALUE := lr;
	    3: FOVALUE := hc;
	    4: FOVALUE := kc;
	    5: FOVALUE := lc;
	    6: FOVALUE := cdrec.stsl;
	    7,8,9: if cnpola = nil then FOVALUE := 0.0 else
		FOVALUE := value( cnpola^.field[idx-6]);
	   10: if cwave = nil then FOVALUE := 0.0 else FOVALUE := cwave^.qx;
	   11: if cwave = nil then FOVALUE := 0.0 else FOVALUE := cwave^.qy;
	   12: if cwave = nil then FOVALUE := 0.0 else FOVALUE := cwave^.qz;
	   13: FOVALUE := hh;
	   14: FOVALUE := kk;
	   15: FOVALUE := ll;
           20: FOVALUE := h2/depi;
           21: FOVALUE := k2/depi;
           22: FOVALUE := l2/depi;
	   16: FOVALUE := cdrec.dobs;
	   17: FOVALUE := cdrec.sig;
	   18: FOVALUE := cdrec.pds;
	   19: FOVALUE := refcatsv;
	   23: FOVALUE := lchi2;
	   24: FOVALUE := cchi2;
	   25: FOVALUE := lmaxf;
	   26: FOVALUE := cmaxf;
	   27: FOVALUE := fnr;
	   28: FOVALUE := fni;
	   29: FOVALUE := fmxr;
	   30: FOVALUE := fmyr;
	   31: FOVALUE := fmzr;
	   32: FOVALUE := fmxi;
	   33: FOVALUE := fmyi;
	   34: FOVALUE := fmzi
          end;
    islnd: begin
	    lstsel := round( FOVALUE( seltb[0])+1 );
	    if (lstsel < 1) or (lstsel >= selsize) then FOVALUE := 0.0 else
	    FOVALUE := FOVALUE( seltb[lstsel] )
	  end;
    selnd: if cselect >= selsize then FOVALUE := 0.0 else
	     if seltb[cselect] = nil then FOVALUE := 0.0 else
	       FOVALUE := FOVALUE( seltb[cselect] );
    phaseop: begin
               valb1 := FOVALUE( bina1 ); valb2 := FOVALUE( bina2 );
               FOVALUE := ARCTAN( valb1, valb2 )/inrd
             end;
    bess1op: begin
               FOVALUE  := FBJN( bess1_d, FOVALUE( bess1_x ),
                                          ROUND( FOVALUE( bess1_n ) ) )
             end;
    absop: begin
             valu := FOVALUE( unaa1 );
             FOVALUE := ABS( valu )
           end;
    intop: FOVALUE := ROUND( FOVALUE( una1 ) );
    modop: FOVALUE := ROUND( FOVALUE( bin1 ) ) mod ROUND( FOVALUE( bin2 ) );
    eqop, neop, ltop, leop, geop, gtop:
	begin r := FOVALUE( bin1 ) - FOVALUE( bin2 );
	  case nodety of
		eqop: FOVALUE := ORD( r  = 0.0 );
		neop: FOVALUE := ORD( r <> 0.0 );
		ltop: FOVALUE := ORD( r  < 0.0 );
		leop: FOVALUE := ORD( r <= 0.0 );
		geop: FOVALUE := ORD( r >= 0.0 );
		gtop: FOVALUE := ORD( r  > 0.0 )
	  end
	end;
    sumhkl:   FOVALUE := SUMHVAL;
    summop:   FOVALUE := SUMLOOP( p, nil );
    functcall, formalcall:
      FOVALUE := USERCALL( p, nil, nodety = formalcall );
    indxrf:   FOVALUE := indval;
    formalrf: FOVALUE := FOVALUE( actuallink);
    parrf:    FOVALUE := actval;
    varrf:    FOVALUE := curval;
    contrf:   FOVALUE := contrib
  end;
  if parmstp > 0 then parmstp := PRED( parmstp )
end FOVALUE;



function DER( p, q: ptr ): real;
{ get a derivate of a given p^ parameter(derivation by q^ variable }
var
  r: real;
  d: ptder;

begin
  if p = nil then der := 0.0 else
  begin
    r := 0.0; d := p^.lstder;
    while d <> nil do
      if d^.idvar = q then
      begin  r := d^.derval; d := nil  end
      else d := d^.next;
    der := r
  end
end DER;



function FODERIV( p: ptr; pr: ptr): real;
{ this function comput the derivate of an expression in relation
   with the designated variable }
{ p is the pointer of expression }
{ pr is the pointer of variable for derivation }
var r: real; d: ptder;
begin { FODERIV }
  cformula  := p;
  cvariable := pr;
  if p = nil then FODERIV := 0.0 else
  with p^ do
  case nodety of
    addop: FODERIV := FODERIV( bin1, pr ) + FODERIV( bin2, pr );
    subop: FODERIV := FODERIV( bin1, pr ) - FODERIV( bin2, pr );
    mulop: FODERIV := FODERIV( bina1, pr )*valb2 + valb1*FODERIV( bina2, pr );
    divop: FODERIV :=
		( FODERIV( bina1, pr )*valb2 - 
                  FODERIV( bina2, pr )*valb1 )/SQR( valb2 );
    powop: begin r := LN( valb1 );
	     FODERIV := EXP( r*valb2 )*(
                  FODERIV( bina2, pr )*r + valb2*FODERIV( bina1, pr )/valb1)
	   end;
    negop: FODERIV := -FODERIV( una1,  pr );
    sqrto: FODERIV :=  FODERIV( unaa1, pr )/(2.0*valu);
    logop: FODERIV :=  FODERIV( unaa1, pr )/valu;
    expop: FODERIV :=  FODERIV( unaa1, pr )*valu;
    sinop: FODERIV :=  FODERIV( unaa1, pr )*inrd*COS( valu );
    cosop: FODERIV := -FODERIV( unaa1, pr )*inrd*SIN( valu );
    tanop: FODERIV :=  FODERIV( unaa1, pr )*inrd/SQR( COS( valu ) );
    asino: FODERIV :=  FODERIV( unaa1, pr )/(SQRT( 1.0 - SQR( valu ) )*inrd);
    acoso: FODERIV := -FODERIV( unaa1, pr )/(SQRT( 1.0 - SQR( valu ) )*inrd);
    atano: FODERIV :=  FODERIV( unaa1, pr )/((1.0 + SQR( valu ))*inrd);
    thop:  FODERIV :=  FODERIV( unaa1, pr )*(1.0 - SQR( TANH( valu ) ));
    bess1op: FODERIV := FODERIV( bess1_x, pr )*bess1_d;
    ipwop: FODERIV :=  FODERIV( rpw, pr )*ipw*valwpa**(ipw - 1);
    konst, tabrf:
           FODERIV := 0.0;
    parrf: FODERIV := DER( p, pr );
    varrf: if pr = p then FODERIV := 1.0 else FODERIV := 0.0;
    islnd:
      begin
        if (lstsel < 1) or (lstsel >= selsize) then FODERIV := 0.0 else
          FODERIV := FODERIV( seltb[lstsel], pr )
      end;
    selnd: { select }
      if cselect >= selsize then FODERIV := 0.0 else
        if seltb[cselect] = nil then FODERIV := 0.0 else
          FODERIV := FODERIV( seltb[cselect], pr );
    phaseop: { phasearg }
      begin
        r := SQR( valb1 ) + SQR( valb2 );
	  if r <= 1.0e-6 then FODERIV := 0.0 else
            FODERIV := (FODERIV( bina1, pr )*valb2 -
                        valb1*FODERIV( bina2, pr ))/(inrd * r);
      end;
    absop:
      if valu = 0.0 then FODERIV := 0.0 else
	if valu > 0.0 then FODERIV := FODERIV( unaa1, pr ) else
	  FODERIV := - FODERIV( una1, pr );
    summop:
      FODERIV := SUMLOOP( p, pr );
    functcall, formalcall:
      FODERIV := usercall( p, pr, nodety = formalcall );
    formalrf:
      FODERIV := FODERIV( actuallink, pr );
    eqop,   neop,   ltop,  leop,   geop,  gtop,
    sumhkl, indxrf, intrf, contrf, intop, modop:
           FODERIV := 0.0
  end
end FODERIV;



function USERCALL{ ( pn, pv: ptr; bf: boolean ): real; was forward; };
var
  i: integer;
  p1,p2: ptr;
  svfotab: array[0..31] of ptr;

begin
  with pn^ do
  begin
    p1 := seltb[selsize]; { get function definition block address }
    if bf then p1 := p1^.actuallink; { case of formal function call }
    p2 := p1^.formallst; { get formal list pointer }
    i := 0; { start from first parameter }
    while p2 <> nil do { for all formal }
    begin
      { each parameter is assigned to the corresponding formal }
      svfotab[i] := p2^.actuallink;
      if i < selsize then p2^.actuallink := seltb[i]
                     else p2^.actuallink := nil; { assume nul formal }
      i := i + 1; p2 := p2^.nextfo { step to next formal }
    end;
    if pv = nil then
      USERCALL := FOVALUE( p1^.exprvalue ) { comput the function value }
    else
      USERCALL := FODERIV( p1^.exprvalue, pv ); { or its derivate }
    i := 0; p2 := p1^.formallst; { restore original formal list }
    while p2 <> nil do
    begin
      p2^.actuallink := svfotab[i]; i := i + 1; p2 := p2^.nextfo
    end
  end
end USERCALL;



function SUMLOOP{ ( pn,pv: ptr ): real; was forward; };
var
  indl, endl, stpl, inds, vl: real;

begin
  with pn^ do
  begin
    indl := FOVALUE( loopbe ); endl := FOVALUE( loopen );
    stpl := FOVALUE( loopst ); inds := loopidx^.indval;
    vl := 0.0;
    while ((stpl > 0) and (indl <= endl)) or
	  ((stpl < 0) and (indl >= endl)) do
    begin
      loopidx^.indval := indl;
      if pv = nil then  vl := vl + FOVALUE( loopexp )
	else vl := vl + FODERIV( loopexp,pv );
      indl := indl + stpl
    end;
    loopidx^.indval := inds { restore for future recursive mode }
  end;
  SUMLOOP := vl
end SUMLOOP;



{ to skip any virtual or locked variable derivate block in a parameter
   derivate block list }
procedure SKIPVIRTUAL( var p: ptder );
var
  bend: boolean;

begin
  bend := false;
  while not bend do
  begin
    bend := (p = nil);
    if not bend then
      if p^.idvar^.matind < 1 then p := p^.next else bend := true
  end
end SKIPVIRTUAL;



procedure OUTNAMEID( pid: nam_ptr; f: integer );
var
  sz: integer;

begin
  if pid <> nil then
  with pid^ do
  begin
    sz := ORD( l );
    if f >= 0 then
      if f <= sz then WRITE( lst, s:sz )
                 else WRITE( lst, s:sz, ' ':f-sz )
    else
    begin
      f := -f;
      if f <= sz then WRITE( intf, s:sz )
                 else WRITE( intf, s:sz, ' ':f-sz )
    end
  end
end OUTNAMEID;



function ERROR_HANDLER( nerr: cc__int ): cc__int;
{ Error Handler for numeric error }
var
  v1, v2: real;
  isucc: integer;
  so: string( 32 );
  bin: boolean;

begin
  case nerr of
    20, { Undifferencied Numeric Error }
    21, { Integer Overflow }
    22, { Integer Zero Divide }
    24, { Floatting Overflow }
    25: { Floatting Zero Divide }
      if cparam <> nil then
      begin
        if (parmstp > 0) and (parmstp <= max_stkp) then
          cformula := parmstk[parmstp];
        SKIPLINE( 2 );
        NEWLINELST;
        case nerr of
          20: WRITELN( lst, ' *** Undifferencied Numeric Error.' );
          21: WRITELN( lst, ' *** Integer Overflow Error.' );
          22: WRITELN( lst, ' *** Integer Zero Divide Error.' );
          24: WRITELN( lst, ' *** Floatting Overflow Error.' );
          25: WRITELN( lst, ' *** Floatting Zero Divide Error.' );
        end;
        SKIPLINE( 1 );
        NEWLINELST;
        if cvariable <> nil then
        begin
          WRITE( lst, ' In the derivation of the Parameter "' );
          OUTNAMEID( cparam^.name, 0 ); WRITE( lst, '" by "' );
          OUTNAMEID( cvariable^.name, 0 )
        end
        else
        begin
          WRITE( lst, ' In the evaluation of the Parameter "' );
          OUTNAMEID( cparam^.name, 0 )
        end;
        WRITELN( lst, '".' );
        if cformula <> nil then
        begin
          so := '';
          with cformula^ do
          case nodety of
            addop, subop:
              begin
                if nodety = addop then so := '+' else so := '-';
                bin := true;
                v1 := FOVALUE( bin1 ); v2 := FOVALUE( bin2 )
              end;
            mulop, divop:
              begin
                if nodety = mulop then so := '*' else so := '/';
                bin := true;
                v1 := valb1; v2 := valb2
              end;
            ipwop, powop:
              begin
                bin := true; so := '**';
                if nodety = powop then
                begin  v1 := valb1; v2 := valb2  end
                else
                begin  v1 := valwpa; v2 := ipw   end
              end;
            negop:
              begin
                so := '-'; v1 := FOVALUE( una1 )
              end;
            sqrto: begin  so := 'SQRT('; v1 := FOVALUE( unaa1 )  end;
            logop: begin  so := 'LOG(';  v1 := valu  end;
            expop: begin  so := 'EXP(';  v1 := valu  end;
            tanop: begin  so := 'TAN(';  v1 := valu/inrd  end;
            asino: begin  so := 'ASIN('; v1 := valu  end;
            acoso: begin  so := 'ACOS('; v1 := valu  end;
            atano: begin  so := 'ATAN('; v1 := valu  end;
            thop:  begin  so := 'TANH('; v1 := valu  end;
            phaseop:
              begin
                so := 'ATAN('; bin := true;
                v1 := valb1; v2 := valb2
              end;
            intop: begin  so := 'ROUND('; v1 := FOVALUE( una1 )  end;
            modop:
              begin
                so := 'mod'; bin := true;
                v1 := FOVALUE( bin1 ); v2 := FOVALUE( bin2 )
              end;
            sumhkl: begin  so := 'SUMHKL('; v1 := FOVALUE( exphdef )  end;
            summop:
              begin
                so := 'SUMM('; bin := true;
                v1 := loopidx^.indval; v2 := FOVALUE( loopexp )
              end;

          otherwise
          end;
          if so.length > 0 then
          begin
            NEWLINELST;
            WRITE( lst, ' Try to compute "' );
            if so[so.length] = '(' then
            begin
              WRITE( lst, so, v1 );
              if bin then WRITE( lst, ', ', v2 );
              WRITELN( lst, ' )".' )
            end
            else
            begin
              if bin then WRITE( lst, v1 );
              WRITE( lst, so );
              if bin then WRITE( lst, v2 )
                     else WRITE( lst, v1 );
              WRITELN( lst, '".' )
            end
          end
        end;
        goto MXD_LSQ_STOP;

        isucc := 1 { Success no error now }
      end
      else isucc := 0; { Continue the PASCAL error process }

  otherwise
    isucc := 0 { Continue the PASCAL error process }
  end;
  ERROR_HANDLER := isucc
end ERROR_HANDLER;



procedure PARMDERVAL( id: integer );
{ evaluate all parameters in a given category id, and all associated
   derivates, if id = -1 then the whole of parameter values is computed }
var
  pp: ptr;
  p0: ptder;

begin
  if id < 0 then pp := parhde else pp := pardhde[id];
  while pp <> nil do
  begin
    cparam    := pp;
    cvariable := nil;
    with pp^ do
    begin
      actval := FOVALUE( definition );
      p0 := lstder;
      while p0 <> nil do
      begin
	with p0^ do   derval := FODERIV( definition, idvar );
	p0 := p0^.next
      end
    end;
    if id < 0 then pp := pp^.next else pp := pp^.spclnk
  end;
  cparam := nil
end PARMDERVAL;




procedure CLRSUMHKL;
var
  pp: ptr;

begin
  pp := sumhhde;
  while pp <> nil do { clear all sumhkl nodes }
  begin  pp^.sumhval := 0.0; pp := pp^.sumhnxt  end
end CLRSUMHKL;




procedure MAKESUMHKL;
var
  pp: ptr;

begin
  pp := sumhhde;
  while pp <> nil do
  with pp^ do
  begin
    sumhval := sumhval + FOVALUE( exphdef ); pp := sumhnxt
  end
end MAKESUMHKL;




{//////////////////     PROCEDURES OF MXDUT3   \\\\\\\\\\\\\\\\\\\\\\\\}


{ sepatm group at the end of atom list all none symtry dep. atoms
  pointed by atmshde }
procedure SEPATM;
var
  p1,p2,p3,p4: ptr;

begin
  p1 := atomhde; p2 := nil; p3 := nil; atmshde := nil;
  while p1 <> nil do
  begin
    with p1^ do
    begin
      p4 := next;
      if (lstmom <> nil) or (lstdsp <> nil) then
      begin
	{ insert this atom in special list }
	if p3 = nil then atmshde := p1 else p3^.next := p1;
	p3 := p1; next := nil;
	{ and remove from normal list }
	if p2 = nil then atomhde := p4 else p2^.next := p4
      end
      else
        p2 := p1
    end;
    p1 := p4
  end;
  { attach the none symtry atom list at the end of normal atom list }
  if p2 <> nil then p2^.next := atmshde else atomhde := atmshde
end SEPATM;




{ setrealvar procedure to:
   -link the unlocked variable by use of sq.lnkpt pointer in place of
    sq.sequ, only used by buildtree for the variable reference.
   -set correct lsq-block sizes.
}
procedure SETREALVAR;
{ the virtual variables are not modified because there are not in
   the gvarhde list }
var i,j: integer; pb,plb,pv,plv,nxt: ptr;
begin
  pb := blkhde; plb := nil;
  pv := gvarhde; plv := nil; varhde := nil;
  i := 0; j := 0; varnb := 0; blkvsta := 1; topmat := 0;
  while pv <> nil do
  begin
    i := i + 1; { i is the current variable number }
    with pv^ do
    begin
      if matind > 0 then
      begin
	varnb := varnb + 1; matind := varnb; { set the variable index }
	{ built the free variable list }
	if plv = nil then varhde := pv else plv^.sq.lnkpt := pv;
	plv := pv; sq.lnkpt := varhde { the list is a circular list }
      end
    end;
    if pb <> nil then
      with pb^ do
      if lstvar = pv then { we have find a limit of lsq block }
      begin
	vardim := varnb - j; j := varnb; { we set the block size }
	topmat := topmat + (vardim * (vardim +1)) div 2;
	if topmat > maxmat then error(-10);
	blkvsta := blkvsta + vardim;
	nxt := next;
	if vardim = 0 then { supress the empty block }
	begin
	  if pb = blkhde then blkhde := next else plb^.next := next;
	  next := freeblk; freeblk := pb
	end else plb := pb;
	pb := nxt { skip to next block }
      end;
    pv := pv^.next
  end;
  { now we allocate a lsq-block if there some pending free variables }
  if varnb >= blkvsta then
  begin
    if freeblk = nil then NEW( nxt, otheritem, lsqblk ) else
    begin  nxt := freeblk; freeblk := nxt^.next  end;
    { link to lsq-block list }
    if plb = nil then blkhde := nxt else plb^.next := nxt;
    { init this lsq-block }
    with nxt^ do
    begin
      next    := nil;
      name    := BUILDSYMBOL( 'blk.main' ); sq.sequ := 0;
      dyndmp  := nil;
      dynmrq  := nil;
      vardim  := varnb - blkvsta + 1;
      topmat  := topmat + (vardim * (vardim + 1)) div 2
    end;
    if topmat > maxmat then ERROR( -10 )
  end
end SETREALVAR;





{//////////////////     PROCEDURES OF MXDLSQ   \\\\\\\\\\\\\\\\\\\\\\\\}



{ procedure to set the mxdlsq option }
[global]
procedure SETOPTION( i, id: integer );
var
  pitm,ppp: ptr;
  r: real;

begin
  if (id> 0) and (i <> 17) then READ( intf, r ) else r := 0.0;
  if (i >= 1 ) and (i <= 31) then
  case i of
    1: ncycle := ROUND( r );
    2: begin
	 blistref := (r >= 0.5); blisthkl := (r >= 1.5);
	 if id > 1 then
         begin  READ( intf, r ); minhkllst := ABS( r )  end
       end;
    3: blstres := (r >= 0.5);
    4: blstmat := (r >= 0.5);
    5: bdupdate := (r >= 0.5);
    6: boutinst := (r >= 0.5);
    7: boutenst := (r >= 0.5);
    8: boutsym := (r >= 0.5);
    9: begin  blistvnd := (r >= 0.5); blistver := (r >= 1.5) end;
   10: nvarrot := ROUND( r );
   11: bdmpsig := (r >= 0.5);
   12: mxcateg := ROUND( r );
   13: maxstsl := r;
   14: minstsl := r;
   15: mxcorrel := r;
   16: { h k l limits }
      begin
	hma := ROUND( r ); hmi := -hma; kma := hma;
	kmi := hmi; lma := hma; lmi := hmi;
	if id >= 2 then
        begin  READ( intf, r ); kma := ROUND( r )  end;
       	if id >= 3 then
        begin  READ( intf, r ); lma := ROUND( r )  end;
	if id >= 4 then
        begin  READ( intf, r ); hmi := ROUND( r )  end;
	if id >= 5 then
        begin  READ( intf, r ); kmi := ROUND( r )  end;
	if id >= 6 then
        begin  READ( intf, r ); lmi := ROUND( r )  end
      end;
   17: { display parameter option }
      if id <= 0 then
      begin
	idspltb := maxdspltb;
	while idspltb > 0 do
	begin
	  dspltab[idspltb] := nil; idspltb := idspltb - 1
	end;
	bdsppar := false
      end
      else
      while id > 0 do
      begin
	pitm := SCHITEM( parhde, true ); id := id - 1;
	if pitm <> nil then
	begin
	  idspltb := idspltb + 1;
	  if idspltb > maxdspltb then idspltb := 1;
	  bdsppar := true; dspltab[idspltb] := pitm
	end
      end;
   18: { minimal value to reject reflexion }
	minhklrej := ABS( r );
   19: { listing of magn. struct. factor }
	blistfmag := (r >= 0.5);
   20: { fatal/none fatal singular matrix }
	begin  maxsing := r; bnfsing := (maxsing > 0.0)  end;
   21: { set minimal value for diagonal element }
	mindiag := ABS( r );
   22: { set nbsel to be or in hkl list } bselinlst := (r > 0.5);
   23: { enable convergenge acceleration } baccconv := (r >= 0.5);
   24: { list parameter option }
	blstparam := (r > 0.5);
   25: { listing of not prejected structure factor on listing }
	begin
	  blistftmag := (r >= 0.5); if blistftmag then blistfmag := false
	end;
   26: { mk_3 output file asked }
	if r >= 0.5 then
	begin
	  boutmk3 := true; r := 0.0;
	  if id > 3 then begin
	    READ( intf, mk3x, mk3y, mk3z );
            r := SQRT( SQR( mk3x ) + SQR( mk3y ) + SQR( mk3z ) );
	    if r > 1e-4 then
	    begin  mk3x := mk3x/r; mk3y := mk3y/r; mk3z := mk3z/r  end
	    else r := 0.0
	  end;
	  if r = 0.0 then begin
	    mk3x := 0.0; mk3y := 0.0; mk3z := 1.0 { defaultly to 0,0,1 }
	  end
	end else boutmk3 := false;
   27: { standard ascii atom file }
       boutatom := (r >= 0.5);
   28: { save cycle option }  bsavcycle := (r >= 0.5);
   29: { live display option }  ldisplayper := ROUND( r );
   30,31:
  end
end SETOPTION;





{ initialize procedure to set at empty state all
  the tree structure and mxdlsq program option }
function INIT: boolean;
var
  bok: boolean;
  i:   integer;

begin
  program_name := 'MXDLSQ';
  bok := INIGE( lstnam ); { init all tree construction }
  if bok then
  begin
    ST_PUT_PASTR( pageheadpt1^, title ); { set the MXDLSQ title }
    fcomcpu := 0; fbmatcpu := 0; finvmatcpu := 0; { init cpu time }
    { init to nil the output file }
    ofilespc := nil; mk3filespc := nil;
    { set initial h k l limits }
    hmi        := -1000; kmi       := hmi;   lmi       := hmi;
    hma        :=  1000; kma       := hma;   lma       := hma;
    blstcorr   := false; bselinlst := true;
    boutsym    := false; bdmpsig   := false; bnfsing   := true;
    blisthkl   := false; blistref  := false; boutdat   := false;
    boutinst   := false; boutenst  := false; blistver  := false;
    blistvnd   := true;  blistfmag := false; blstparam := true;
    blistftmag := false; boutmk3 := false;
    boutatom   := false; { option to create a standard atom file }
    blstres    := true;  blstmat   := false; bdupdate  := false;
    bsavcycle  := true;
    ldisplayper:= 0;
    minhkllst  := 0.0;   minhklrej := 0.0; { no rejection based on delta/sigma }
    { set to correlation output }
    mxcorrel := 0.0;
    { set to no reject mode }
    maxstsl  := 1.0e+05;
    minstsl  := 0.0;
    maxsing  := 0.5;
    mindiag  := 0.0;
    { set to 0 the asked cycle number }
    cyclenb  := 0;
    { set no variable rotation }
    nvarrot  := 0;
    { init dspltab to empty }
    idspltb  := maxdspltb;
    while idspltb > 0 do
    begin  dspltab[idspltb] := nil; idspltb := idspltb - 1  end;
    bdsppar  := false;    baccconv := false;
    lmaxf    := -1.0e+10; cmaxf    := lmaxf;
    lchi2    := - lmaxf;  cchi2    := lchi2;
    ineumem  := 0 { no polarized neutron memory };
    refcod[1] := ' +  ';
    refcod[2] := ' -  ';
    refcod[3] := '+/- ';
    refcod[4] := ' ++ ';
    refcod[5] := ' -- ';
    refcod[6] := ' +- ';
    refcod[7] := ' -+ ';
    { set the error message file specification }
    errmsgspecif := errspcfile
  end;
  INIT := bok
end INIT;





{ the next procedures are used to set some prealable initiation of
  structure graph (set of list and tree) }



{ Allocate the matrix, vector space and a identity
   symtry element if any symtry element defined
   and open the first data file }
procedure INIBLK;
{ Can be recall for a change of lsq-block structure }
var
  p,q: ptr; i: integer;

begin
  { Allocate the identity symtry element if no symtry defined }
  if symhde = nil then
  begin
    NEW( symhde, otheritem, symtri );
    with symhde^ do
    begin
      next := nil; name := BUILDSYMBOL( '.E.' ); sq.sequ := -1;
      xx := 1; xy := 0; xz := 0; tx := 0;
      yx := 0; yy := 1; yz := 0; ty := 0;
      zx := 0; zy := 0; zz := 1; tz := 0;
      mpt := nil
    end
  end;
  { now allocate the vector space }
  { the allocation order must not be disturbe }
  ictetrm := topmat + 1; idervec := ictetrm + varnb;
  if (momhde <> nil) and (polhde <> nil) then
  begin
    ineumem := idervec + varnb; ivtnr := ineumem + varnb
  end else ivtnr := idervec + varnb;
  ivtni   := ivtnr   + varnb;
  ivtfn   := ivtni + varnb;
  if momhde <> nil then
  begin
    ivrx  := ivtfn + varnb; ivry  := ivrx  + varnb;
    ivrz  := ivry  + varnb; ivix  := ivrz  + varnb;
    iviy  := ivix  + varnb; iviz  := iviy  + varnb;
    ivtfm := iviz + varnb;
    ialloc := ivtfm + varnb - 1;
  end else ialloc := ivtfn + varnb -1;
  itopvect := ialloc;
  if baccconv then
  begin
    imemory := ialloc + 1; ialloc := ialloc + varnb
  end;
  { set a coherent a variable rotation value if bad }
  if nvarrot >= varnb then nvarrot := varnb div 2;
  if ialloc > maxmat then ERROR( -11 ) else
    if datahde = nil then ERROR( -12 ) else
      with datahde^ do
        if not OPENR_BDTFILE( idat, datfile ) then ERROR( -13 )
                                              else READ( idat, cdrec );

  { set cache location }

  { set the final index value of the virtual variables if used }
  for i := 1 to 4 do
  if virtvtab[i] <> nil then
    with virtvtab[i]^ do
      case i of
      1 {$calc}: matind := -idervec;
      2 {$fn2}:  matind := -ivtfn;
      3 {$fm2}:  matind := -ivtfm;
      4 {$f2pl}: matind := -ivtnr
      end;
  { update the display parameter count }
  if bdsppar then
  begin
    idspltb := maxdspltb;
    while (dspltab[idspltb] = nil) do idspltb := idspltb - 1
  end
end INIBLK;





{ the next procedure are particular to the mxdlsq program }
procedure ROTATVAR;
{ to rotate the variable list from nvarrot variable }
var
  p1,p2: ptr;
  i,j: integer;

begin
  i := nvarrot; { to find the new begining of the variable list }
  { the list is circular }
  while i > 0 do
  begin  i := i - 1; varhde := varhde^.sq.lnkpt  end;
  { now we must re-set the variable pointer of lsq-block item }
  j := 0; { and we set the new matrix index }
  p1 := blkhde; p2 := varhde;
  while p1 <> nil do
  begin
    with p1^ do
    begin
      lstvar := p2; i:= vardim;
      while i > 0 do
      begin
	j := j + 1; p2^.matind := j;
        i := i - 1; p2 := p2^.sq.lnkpt
      end
    end;
    p1 := p1^.next
  end  
end ROTATVAR;




procedure MATCHANGEDIAG( n, ior: integer; mrq: real );
{ Set the Levenberg-Marquardt Method }
var
  i, j, lrow: integer;

begin
  if (mrq > 1.0E-6) and (mrq < 1.0) then
  begin
    lrow := n;
    i    := ior;
    mrq  := 1.0/mrq;
    for j := 1 to n do
    begin
      am[i] := am[i]*mrq;
      i     := i + lrow;
      lrow  := lrow - 1
    end
  end
end MATCHANGEDIAG;


procedure MATINV( n, ior, vor: integer;
                  var nfail: integer; psing: ptr );
{ inversion of a symetric matrix in one dimensionalk compressed form }
var
  i, j, k, l, m, kli, kmi, i1, ii, kdm, imax: integer;
  suma, term, denom: real;
  berr: boolean;

begin
  berr := false ;
  { matrix triangularization }
  k := ior ;
  m := 1 ;
  { loop on m }
  repeat
    imax := m - 1 ;
    l := m ;
    { loop on l }
    repeat
      suma := 0.0 ;
      kli := l + ior - 1;
      kmi := m + ior - 1;
      if imax > 0 then
	{ sum over i = 1,m-1 a(l,i)*a(m,i) }
	for i := 1 to imax do
	begin
	  suma := suma + am[kli] * am[kmi] ;
	  j := n - i ;
	  kli := kli + j ;
	  kmi := kmi + j
	end;
      { term = c(l,m) - sum }
      term := am[k] - suma ;
      if l <= m then
      begin
	{ a(m,m) = sqrt(term) }
	if term > mindiag then
	begin
	  denom := SQRT( term ) ;
	  am[k] := denom
	end
	else
	begin
	  denom := 1.0; am[k] := denom; { set denom to 1.0 and set 0.0 for
					non diagonal corresponding terms }
	  for i := k+1 to k+n-m do  am[i] := 0.0;
	  kmi := m + ior - 1;
	  for i := 1 to imax do
	  begin
	    am[kmi] := 0.0; kmi := kmi + n - i
	  end;
	  am[vor + m - 1] := 0.0; { clear the constant vector }
	  { send a message to listing }
	  NEWLINELST;
	  WRITE( lst, ' *** SINGULAR MATRIX WITH VARIABLE NAMED "' );
          with psing^.name do
            WRITE( lst, s:ORD( l ), '"' );
	  if bnfsing then
	  begin
  	    WRITELN( lst, ' => VARIABLE IS LOCKED ***' );
            nfail := nfail + 1
	  end
	  else
	  begin
	    WRITELN( lst, ' => FATAL ERROR ***' );
            berr := true
	  end;
	  SKIPLINE( 1 )
	end
      end
      { a(l,m) = term/a(m,m) }
      else am[k] := term / denom;
      k := k + 1 ;
      l := l + 1
    until (l > n) or berr;
    { end of l loop }
    m := m + 1; psing := psing^.sq.lnkpt
  until (m > n) or berr;
  { end of m loop }
  if berr then nfail := m -1 else
  begin { matrix inversion }
    am[ior] := 1.0 / am[ior] ;
    kdm := ior ;
    { step l of b(l,m) }
    for l := 2 to n do
    begin
      kdm := kdm + n - l + 2 ;
      { reciprocal of diagonal term }
      term := 1.0 / am[kdm] ;
      am[kdm] := term ;
      kmi := ior - 1 ;
      kli := l + ior  - 1 ;
      imax := l - 1 ;
      { step m of b(l,m) }
      for m := 1 to imax do
      begin
	k := kli ;
	{ sum terms }
	suma := 0.0 ;
	for i := m to imax do
	begin
	  ii := kmi + i ;
	  suma := suma - am[kli]*am[ii] ;
	  kli := kli + n - i
	end ;
	{ mult sum * recip diagonal }
	am[k] := suma * term ;
	j := n - m ;
	kli := k + j ;
	kmi := kmi + j
      end
    end ;
    { premultiply lower triangle by transpose }
    k := ior ;
    for m := 1 to n do
    begin
      kli := k ;
      for l := m to n do
      begin
	kmi := k ;
	imax := n - l + 1 ;
	suma := 0.0 ;
	for i := 1 to imax do
	begin
	  suma := suma + am[kli] * am[kmi] ;
	  kli := kli + 1 ;
	  kmi := kmi + 1
	end ;
	am[k] := suma ;
	k := k + 1
      end
    end
  end
end MATINV;




procedure RESOLV( n, ior, vor, pdor, dior: integer );
{ resolution of system after matinv execution for
   symetric matrix in one dimensionalk compressed form }
var
  i, j, ijd, ij: integer;
  pdi: real;

begin
  for i := 1 to n do
  begin
    pdi := 0.0 ;
    ij := i + ior - 1 ;
    ijd := n - 1 ;
    for j := 1 to n do
    begin
      pdi := pdi + am[ij] * am[j+vor-1] ;
      if j < i then
      begin
	ij := ij + ijd ;
	ijd := ijd - 1
      end else
      begin
	if i = j then am[j+dior-1] := am[ij] ;
	ij := ij + 1
      end
    end ;
    am[i+pdor-1] := pdi
  end
end RESOLV;




procedure OUTMATRIX( morg, mdim: integer; pv: ptr );
{ output on listing all the correlation matrix if the option
   shortlst is off }
var
  i, j, k, l, m: integer;

begin
  if not bshortlst and (mdim > 1) then
  begin
    NEWPARAGRAPHE( 30 );
    NEWLINELST; WRITELN( lst, ' CORRELATION MATRIX ELEMENTS.' );
    UNDERLINE( 0, 28 );
    SKIPLINE( 2 );
    for i := 1 to mdim do
    begin
      NEWLINELST; WRITE( lst, ' *' );
      k := morg + i - 1; l := mdim - 1;
      for j := 1 to i do
      begin
        if i = j then
        with pv^.name^ do
        begin
          m := ORD( l );
          if m < 8 then WRITE( lst, ' ':(8-m) div 2 + 1, s:m )
                   else WRITE( lst, s:m )
        end
        else
          if ABS( am[k] ) < 10.0 then WRITE( lst, am[k]:8:5 )
                                 else WRITE( lst, am[k]:8 );
        if (j mod 16) = 0 then
        begin  WRITELN( lst ); NEWLINELST; WRITE( lst, ' ':2 ) end;
        k := k + l; l := l - 1
      end;
      WRITELN( lst );
      SKIPLINE( 1 );
      pv := pv^.sq.lnkpt
    end
  end;
  SKIPLINE( 4 )
end OUTMATRIX;




procedure OUTRESIDU( var f: text; flg: boolean; 
                     var wre, wcre, uwre, uwcre, chi2: real );
{ output the residu given as parameters }
const
  stovf = '**************';

begin
  if not bshortlst and flg then SKIPLINE( 2 );
  if flg then NEWLINELST;
  WRITE( f, ' Weighted LSQ R Factor           RWLSQ       = ' );
  if wre   < 0.0 then WRITELN( f, stovf )
               else WRITELN( f, wre:14:4 );
  if not bshortlst and flg then SKIPLINE( 1 );
  if flg then NEWLINELST;
  WRITE( f, ' Weighted ABS R Factor           RWABS       = ' );
  if wcre  < 0.0 then WRITELN( f, stovf )
                 else WRITELN( f, wcre:14:4 );
  if not bshortlst then SKIPLINE( 1 );
  if flg then NEWLINELST;
  WRITE( f, ' Unweighted LSQ R Factor         RLSQ        = ' );
  if uwre  < 0.0 then WRITELN( f, stovf )
                 else WRITELN( f, uwre:14:4 );
  if not bshortlst and flg then SKIPLINE( 1 );
  if flg then NEWLINELST;
  WRITE( f, ' Unweighted ABS R Factor         RABS        = ' );
  if uwcre < 0.0 then WRITELN( f, stovf )
                 else WRITELN( f, uwcre:14:4 );
  if not bshortlst and flg then SKIPLINE( 1 );
  if flg then NEWLINELST;
  if chi2 >= 0.0 then
    WRITELN( f, ' The reduced goodness of fit (Chi Squared) is  ', chi2:14:5 )
end OUTRESIDU;



procedure OUTPARAM;
{ output on listing all defined parameters with name value and sigma.
   use the correlation matrix, do not output the parameters with a
   name begining by the "#" or "." characters }
{ the shortlst option supress this output }
var
  p,  b:  ptr;
  p1, p2: ptder;
  sigm, sigi: real;
  i,   i0,  i1,  i2,  i3, j1, mtorg,
  idi, idj, fid, lid, ids: integer;

begin { OUTPARAM }
  p := parhde;
  i := 0;
  while p <> nil do
  begin
    with p^ do
      if (name^.s[1] <> '.') and (name^.s[1] <> '#') then
      begin
	if i = 0 then
	begin
	  if not bshortlst then NEWPARAGRAPHE( 10 )
                           else NEWPARAGRAPHE( 5 );
	  NEWLINELST; WRITELN( lst, ' Parameter Informations :' );
	  UNDERLINE( 0, 24 );
	  if not bshortlst then SKIPLINE( 2 );
          NEWLINELST;
	  if b132 then i3 := 3 else i3 := 2;
          sbttlpt^.l := CHR( 0 );
	  for i := 1 to i3 do
          begin
	    ST_PUT_PASTR( sbttlpt^, '   Name              Value     Sigma' );
            if i < i3 then ST_PUT_PASTR( sbttlpt^, '     ' )
          end;
	  with sbttlpt^ do WRITELN( lst, s:ORD( l ) );
	  SKIPLINE( 1 );
          i := 0
	end;
	if (i mod i3) = 1 then NEWLINELST;
        WRITE( lst, ' ' ); OUTNAMEID( name, 16 );
        WRITE( lst, ' ', actval:9:5 );
	p1 := lstder;
	{ skip virtual and locked variables derivate }
	SKIPVIRTUAL( p1 );
	sigm := 0.0;
	while p1 <> nil do
	begin
	  b := blkhde; mtorg := 1; fid := 1; ids := b^.vardim; lid := ids;
	  idi := p1^.idvar^.matind;
	  while idi > lid do
	  begin
	    mtorg := mtorg + (SQR( ids ) + ids) div 2;
	    fid := fid + ids; b := b^.next; ids := b^.vardim;
	    lid := fid + ids - 1
	  end;
	  with p1^ do
	    sigi := idvar^.cursig * derval;
	  sigm := sigm + SQR( sigi );
	  p2 := p1^.next;
	  while p2 <> nil do
	  begin
	    idj := p2^.idvar^.matind;
	    if (idj >= fid) and (idj <= lid) then
	    begin
	      i1 := idi - fid + 1; j1 := idj - fid + 1; i0 := mtorg;
	      if i1 > j1 then
	      begin
		i2 := i1; i1 := j1; j1 := i2
	      end;
	      i2 := ids;
	      while i1 > 1 do
	      begin
		i0 := i0 + i2; i2 := i2 - 1;
		i1 := i1 - 1; j1 := j1 - 1
	      end;
	      with p2^ do
		sigm := sigm + 2.0*am[i0+j1-1] * sigi * idvar^.cursig * derval
	    end;
	    p2 := p2^.next
          end;
	  p1 := p1^.next
	end;
	sigm := SQRT( ABS( sigm ) );
	WRITE( lst, ' ', sigm:9:5 );
        i := i + 1;
	if (i mod i3) = 0 then WRITELN( lst )
                          else WRITE( lst, ' ':4 )
      end;
    p := p^.next
  end;
  if (i mod 3) <> 0 then WRITELN( lst );
  sbttlpt^.l := CHR( 0 )
end OUTPARAM;



procedure OUTVNM( ic: char; p: ptr; st: threechar );
{ output on listing a particular item parameter with the form :
   <ic character> <parameter name> <actual value> <st-physical unit>
}
var
  i, sz: integer;

begin
  if p = nil then WRITE( lst, ic:15 )
  else
  with p^, name^ do
  begin
    WRITE( lst, ic );
    sz := ORD( l );
    if s[1] = '.' then
      for i := 2 to sz do WRITE( lst, s[i] )
    else WRITE( lst, s:sz );
    WRITE( lst, '=', actval:7:4, st:3 )
  end
end OUTVNM;




procedure OUTSTRUCTURE;
{ creates a structure description on listing }
var
  p0, p1: ptr;
  bcmp:   boolean;
  ic:     threechar;
  i:      integer;

begin
  p0 := atomhde;
  NEWPARAGRAPHE( 15 );
  NEWLINELST; WRITELN( lst, ' Structure Description :' );
  UNDERLINE( 0, 23 );
  SKIPLINE( 2 );
  bcmp := true;
  while p0 <> nil do
  begin
    if bcmp then
    begin
      NEWLINELST;
      WRITELN( lst, ' ATOME :' );
      bcmp := false
    end;
    with p0^ do
    begin
      NEWLINELST; WRITE( lst, ' ':2);
      OUTNAMEID( name, 16 ); WRITE( lst, ':' );
      if bcart then ic := 'a  ' else ic := '   ';
      OUTVNM( ' ', atmpar[3], '   ' );
      for i := 4 to 6 do OUTVNM( ',', atmpar[i], ic );
      if banis then
      begin
	WRITELN( lst ); NEWLINELST;
	OUTVNM( ' ', atmpar[7], 'A^2' );
	for i := 8 to 12 do OUTVNM( ',', atmpar[i], 'a^2' );
	WRITELN( lst );
      end
      else
      begin
	if atmpar[7] <> nil then
	if buiso then
          WRITE( lst, ', U   =', atmpar[7]^.actval:7:4, 'A^2' )
	else
          WRITE( lst, ', B   =', atmpar[7]^.actval:7:4 );
	WRITELN( lst )
      end;
      if lstmom <> nil then
      begin
        p1 := lstmom;
        NEWLINELST; WRITELN( lst, ' ':8, 'Magnetic Moments :' );
	bcmp := true;
        while p1 <> nil do
        begin
	  with p1^ do
	  begin
	    NEWLINELST;
	    WRITE( lst, ' ':2 ); OUTNAMEID( name, 16 ); WRITE( lst, ':' );
	    OUTVNM( ' ', mompar[2], 'bmu' );
	    for i := 3 to 7 do OUTVNM( ',', mompar[i], 'bmu' );
	    if mwave <> nil then
            begin
	      WRITE( lst, '   ,QN ="' ); OUTNAMEID( mwave^.name, 16 );
              WRITELN( lst, '"' )
            end
	    else WRITELN( lst )
	  end;
	  p1 := p1^.nxtmom
        end
      end;
      if lstdsp <> nil then
      begin
        p1 := lstdsp;
	bcmp := true;
        NEWLINELST; WRITELN( lst, ' ':8, 'Modulated Displacements :' );
        while p1 <> nil do
	begin
	  with p1^ do
	  begin
	    NEWLINELST;
	    WRITELN( lst, ' ':2 ); OUTNAMEID( name, 16 ); WRITELN( ':' );
	    OUTVNM( ' ', mdspar[1], '   ' );
            OUTVNM( ',', mdspar[2], '   ' );
	    WRITE( lst, ', QN ="' ); OUTNAMEID( dwave^.name, 16 );
            WRITELN( lst, '"' );
	    if (mdspar[3]<>nil) or (mdspar[4]<>nil) or (mdspar[6]<>nil) then
	    begin
	      NEWLINELST;
	      WRITE( lst, ' ':14 );
	      for i := 3 to 8 do OUTVNM( ',', mdspar[i], 'A  ' );
	      WRITELN( lst )
	    end
	  end;
	  p1 := p1^.nxtmom
        end
      end
    end;
    SKIPLINE( 2 );
    p0 := p0^.next
  end
end OUTSTRUCTURE;



procedure DATALST;
{ data information listing procedure }
var
  p: ptr;
  bn, bm, bw: boolean;

begin
  if datahde <> nil then
  begin
    NEWPARAGRAPHE( 10 );
    NEWLINELST; WRITELN( lst, ' List of Data Collections : ' );
    UNDERLINE( 0, 26 ); SKIPLINE( 1 );
    p := datahde;
    while p <> nil do
    begin
      with p^ do
      begin
	NEWLINELST;
	WRITE( lst, ' ' );
        OUTNAMEID( name, 16 ); WRITE( lst, ' with ', ncpv:7, '/', ncp:7 );
	case datcat of
          0: WRITE( lst, '  SF' );
          1: WRITE( lst, '  F2' );
          2: WRITE( lst, ' RAY' )
	end;
	WRITELN( lst, ' Observations and a SCALE of :', scale^.actval:12:4 );
	bn := (fn2corr <> nil);
        bm := (fm2corr <> nil);
	bw := (dywecoef <> nil);
	if bn or bm or bw then
	begin
	  NEWLINELST; WRITE( lst, ' ':8 );
	  if bn or bm then
	  begin
            WRITE( lst, 'the correction factor' );
	    if not (bn and bm) then WRITE( lst, ' is' )
                               else WRITE( lst, 's are' );
	    WRITE( lst, ' applied to ' );
	    if bn then
	    begin
              WRITE( lst, '$FN2 ' );
	      if bm then WRITE( lst, 'and ' )
	    end;
	    if bm then WRITE( lst, '$FM2 ' )
	  end;
	  if bw then
	  begin
	    if bn or bm then WRITE( lst, ', ' );
	    WRITE( lst, ' A dynamic weight is used' )
	  end;
	  WRITELN( lst, '.' )
	end
      end;
      p := p^.next
    end
  end;
  SKIPLINE( 2 )
end DATALST;



procedure FIRSTOUTPUT;
{ to output all informations message of least-square conditions }
var
  latticetab: packed array[1..7] of char;
  p: ptr;
  i: integer;

  procedure WAVELST;
  begin
    if wavhde <> nil then
    begin
      NEWPARAGRAPHE( 8 );
      NEWLINELST; WRITELN( lst, ' List of Wave Vectors :' );
      UNDERLINE( 0, 22 );
      SKIPLINE( 1 );
      p := wavhde;
      while p <> nil do
      begin
        with p^ do
	begin
      	  NEWLINELST;
	  WRITE( lst, ' ':4 ); OUTNAMEID( name, 16 );
          WRITE( lst, '=', qx:8:4, qy:8:4, qz:8:4 );
	  if relflg then WRITE( lst,' Rational' );
	  WRITELN( lst )
	end;
	p := p^.next
      end
    end;
  end WAVELST;


  procedure POLLST;
  begin
    if polhde <> nil then
    begin
      NEWPARAGRAPHE( 8 );
      NEWLINELST; WRITELN( lst, ' List of applied Magnetic Fields :' );
      UNDERLINE( 0, 33 );
      SKIPLINE( 1 );
      p := polhde;
      while p <> nil do
      begin
        with p^ do
	begin
	  NEWLINELST;
	  WRITE( lst, ' ':4 ); OUTNAMEID( name, 16 );
          WRITELN( lst, '=', VALUE( field[1] ):8:4,
			',', VALUE( field[2] ):8:4,
			',', VALUE( field[3] ):8:4, ';' )
	end;
	p := p^.next
      end
    end;
  end POLLST;



  procedure SYMTRYLST;
  var
    r: real;

  begin
    if boutsym then
    if symhde <> nil then
    begin
      NEWPARAGRAPHE( 12 );
      NEWLINELST; WRITELN( lst, ' List of Symetry operator matrixs :' );
      UNDERLINE( 0, 34 );
      SKIPLINE( 1 );
      p := symhde;
      while p <> nil do
      begin
        with p^ do
	begin
	  NEWLINELST;
	  r := tx/12.0;
	  WRITE( lst, ' ':4 ); OUTNAMEID( name, 16 );
          WRITELN( lst, xx:4, xy:4, xz:4, r:10:6 );
	  r := ty/12.0;
	  NEWLINELST; WRITELN( lst, ' ':20, yx:4, yy:4, yz:4, r:10:6 );
	  r := tz/12.0;
	  NEWLINELST; WRITELN( lst, ' ':20, zx:4, zy:4, zz:4, r:10:6 );
	  SKIPLINE( 1 )
	end;
	p := p^.next
      end
    end;
  end SYMTRYLST;


begin { FIRSTOUTPUT }
  latticetab := 'PABCIRF';
  NEWLINELST; WRITELN( lst, ' Raffinement Informations :' );
  UNDERLINE( 0, 26 );
  SKIPLINE( 2 );
  if varnb > 0 then
  begin
    NEWLINELST;
    WRITELN( lst, '  There are ', varnb:6, ' variables to refine.' );
    if nvarrot > 0 then
    begin
      NEWLINELST;
      WRITELN( lst, '  The variable rotation is enable with a step of ',
                    nvarrot:4, '.' )
    end;
    NEWLINELST; WRITELN( lst, ' We start for ', ncycle:3, ' cycles.' );
    if bcentric then
    begin
      NEWLINELST;
      WRITELN( lst, ' A center at (0,0,0) is specified.' )
    end;
    NEWLINELST;
    WRITELN( lst, ' The specified lattice is ', latticetab[latticenb], '.' );
    if psav <> nil then
    begin
      SKIPLINE( 1 ); NEWLINELST;
      WRITELN( lst,
               ' The variable will be Saved on end of this run on the file :'
             );
      NEWLINELST; WRITELN( lst, psav^.s:ORD( psav^.l ), '.' )
    end;
    if bdupdate then
    begin
      NEWLINELST;
      WRITELN( lst, ' A Fourier dat file will be written on the end of run.' )
    end;
    if bdmpsig then
    begin
      NEWLINELST;
      WRITELN( lst,
               ' A correlation dat file will be written on the end of run.' )
    end;
    if not bshortlst then
    begin
      SYMTRYLST;
      WAVELST;
      POLLST;
      DATALST;
      SKIPLINE( 2 );
      NEWLINELST; WRITELN( lst, ' List of Variables :' );
      UNDERLINE( 0, 19 );
      SKIPLINE( 1 );
      if nbfixed > 0 then
      begin
        NEWLINELST;
        WRITELN( lst, ' The variable with the flag "f" are fixed.')
      end;
      if bflimited then
      begin
        NEWLINELST;
        WRITELN( lst, ' The variable with the flag "l" are limited.' )
      end;
      NEWLINELST;
      p := gvarhde;
      i := 0;
      while p <> nil do
      begin
	if (i mod 4) = 0 then
	begin  WRITELN( lst ); NEWLINELST end;
	i := i + 1;
	with p^ do
	begin
          WRITE( lst, ' ':2 ); OUTNAMEID( name, 16 );
          WRITE( lst, '=', curval:8:4 );
	  if matind = 0 then WRITE( lst, ' f':4 )
                        else if limptr <> nil then WRITE( lst, ' l':4 )
                                              else WRITE( lst, ' ':4 )
	end;
	p := p^.next
      end;
      WRITELN( lst )
    end
  end;
  if boutinst and not bshortlst then OUTSTRUCTURE;
  if bshortlst then NEWPARAGRAPHE( 20 ) else NEWPARAGRAPHE( 30 );
  NEWLINELST; WRITELN( lst, ' Begin of Least Squares process.' );
  UNDERLINE( 0, 31 );
  SKIPLINE( 2 )
end FIRSTOUTPUT;



{ to get an internal parameter value (value of a item par. field) }
function GTVD( pt: ptr ): real;
begin
  if pt = nil then GTVD := 0.0 else GTVD := pt^.actval
end GTVD;




procedure OUTATOME;
{ Create a standard ascii file with all defined atoms coordinates }
var
  p0: ptr;
  i:  integer;
  r:  real;

begin
  OPEN_LISTING( intf, 'atoms.dat', 1 ); { Open the atom file }
  p0 := atomhde;
  while p0 <> nil do
  begin
    with p0^ do
    begin
      WRITE( intf, '  ' ); OUTNAMEID( name, 16 );
      for i := 4 to 6 do  WRITE( intf, ' ', GTVD( atmpar[i] ):9:6 );
      WRITELN( intf );
      r := GTVD( atmpar[7] );
      if not (banis or not buiso) then r := r * (8*SQR( 3.1415927 ));
      WRITE( intf, ' ', r:9:6 );
      for i := 8 to 12 do WRITE( intf, ' ', GTVD( atmpar[i] ):9:6 );
      WRITELN( intf )
    end;
    p0 := p0^.next
  end;
  CLOSE_TXTFILE( intf )
end OUTATOME;




{ ****  Computing procedure  **** }


{ To update the derivate of structure factor }
procedure MSETDER( iv, jv: integer; pp: ptr; rdv, idv: real );
var
  p: ptder;

begin
  if pp <> nil then
  begin
    p := pp^.lstder;
    while p <> nil do
    begin
      with p^ do
	with idvar^ do
	if matind > 0 then { for real variable only }
	begin
	  am[iv+matind-1] := am[iv+matind-1] + derval*rdv;
	  am[jv+matind-1] := am[jv+matind-1] + derval*idv
	end;
      p := p^.next
    end
  end
end MSETDER;




procedure CPF2CORR( var fcal: real; ncf2: real; pcorr: ptr;
	            id, jd: integer; add, deriv, bsqrt: boolean );
{ to comput all f2 correction and set the final derivate in idervec }
{ ncf2 is the not corrected f2, pcorr is the correction parameter,
   id: is the index in am of ncf2 derivate, and add is true if this is
       not the first element in fcal,
   deriv must be true to modify the associated derivate,
   bsqrt must be true to applied a sf correction in place of f2,
   jd: is the index of the result f2 derivate in am }

{ all defined virtual variables can be refered in the correction definition
   this variables can be $fn2 for fnucl2, $fm2 for fmag2
   and $calc for scale or $neupol for polarized neutron }

type
  rec_der = record
    kd: integer;
    dval: real
  end;

var
  plsdr: ptder;
  tab_der: array[1..4] of rec_der;
  de, drv, dcr, cval: real;
  i, j, idv: integer;
  bstp, bcont: boolean;

begin   { CPF2CORR }
  if pcorr = nil then { no correction }
  begin
    if add then fcal := fcal + ncf2 else fcal := ncf2;
    if (id <> jd) { or add / no call with id=jd and add } then
    if deriv then
    for i:= 1 to varnb do
    begin
      if add then am[jd] := am[jd] + am[id] else am[jd] := am[id];
      id := id + 1; jd := jd + 1
    end
  end else
  { with correction }
  with pcorr^ do
  begin
    if bsqrt then cval := SQRT( actval ) else cval := actval;
    if add then fcal := fcal + ncf2 * cval
    else fcal := ncf2 * cval;
    if deriv then
    begin
      plsdr := lstder; bcont := true; idv := 0;
      if plsdr <> nil then
        while (plsdr <> nil) and bcont do
          with plsdr^ do
            if idvar^.matind < 0 then { virtual variable - one only }
            begin
              idv := idv + 1;
              with tab_der[idv] do
              begin
                kd := - idvar^.matind { get vector value };
                if bsqrt then dval := derval/cval/2.0 else dval := derval
              end;
              plsdr := next
            end else bcont := false;
      { now we set derivate for real variables }
      for i:= 1 to varnb do
      begin
	if plsdr <> nil then
	  with plsdr^ do
	  if idvar^.matind = i then
	  begin
	    if bsqrt then drv := derval/cval/2.0 else drv := derval;
	    plsdr := next
	  end
	  else drv := 0.0
	else drv := 0.0;
        for j := 1 to idv do
          with tab_der[j] do
	    drv := drv + dval*am[kd];
	de := am[id] * cval + ncf2 * drv;
	if add then am[jd] := am[jd] + de else am[jd] := de;
	id := id + 1; jd := jd + 1
      end
    end
  end
end CPF2CORR;




{ to perform one cycle of refinement }
procedure CYCLE;
var
  lccrf, lccif, lccmag, sdelssg,           { local computed variable }
  sitl, msig, oldval, curchg, curdyndmp: real;
  i, ifc, ij, ii, jj, ip, jp, i1, i2, i3,
  imem, blkmor, blkvor, nerr: integer;
  p, q, q1, q2, q3: ptr;
  blimit, bmodulo, bfirst: boolean;



  { computing of sf, f2, ray and derivates }
  procedure STRFAC( isp, mltg: integer; ba, bmatrix: boolean );
  var
    i,   ifn, ifm,  i1,  i2,  i3,  i4,  i5,  i6,  i7, i8: integer;
    dvl, dfn, dfm,  v1,  v2,  v3,  v4, hhi, kki, lli, dphg: real;
    bcenter, bdbw: boolean;


    { symtry operator application procedure }
    procedure TRANSHKL;
    begin
      with csymtry^ do
      begin { in reciprocal lattice }
        h1 := depi * (hr * xx + kr * yx + lr * zx);
        k1 := depi * (hr * xy + kr * yy + lr * zy);
        l1 := depi * (hr * xz + kr * yz + lr * zz);
        { in reciprocal space }
        if mpt <> nil then { for cartesian in hexa. syst. }
        begin
          h2 := depi * (hc * mpt^[1,1] + kc * mpt^[2,1] + lc * mpt^[3,1]);
          k2 := depi * (hc * mpt^[1,2] + kc * mpt^[2,2] + lc * mpt^[3,2]);
          l2 := depi * (hc * mpt^[1,3] + kc * mpt^[2,3] + lc * mpt^[3,3])
        end else
        begin
          h2 := depi * (hc * xx + kc * yx + lc * zx);
          k2 := depi * (hc * xy + kc * yy + lc * zy);
          l2 := depi * (hc * xz + kc * yz + lc * zz)
        end;
        dphg := (tx * hr + ty * kr + tz * lr ) * depi / 12.0
      end
    end TRANSHKL;




    { computing of structure factor for one atom and related moments
      and/or displacements }
    procedure SETSGATM;
    const
      pis2 = 1.57079633;

    var
      i,   i1,  i2,  i3,  i4,   ne:   integer;
      p1,  p2,  p3,  p4,  md,   th,   drpm, dipm,
      rhr, rhi, ihr, ihi, srgf, sigf, sdrg, sdig, srhr, srhi, sihr, sihi,
      drppm, dippm, flrph, fliph,  c1, c2, c3, u1, u2, u3, u4,
      fr,  fi,  pp, ppdbf, drgsca, digsca, phg, pat, dbf, rdf, idf, rgd, igd,
      d1,  d2,  dx,  dy,  dz, phh, pkk, pll, phk, phl, pkl: real;
      bdspm, bstp: boolean;





      { computing of displacement effect one geometrical factor }
      procedure DSPFAC( n: integer; ppm,pph,flph: real );
      var
        n1: integer;
        ph, cph, sph, mdr, dmd, nmd, ncph, nsph, dcph, dsph, rp, ip, rg, ig: real;

      begin
        n1  := ABS( n );   ph := phg - n*th + n1*pis2 + pph;
        cph := COS( ph ); sph := SIN( ph );
        mdr := FBJN( dmd, 2.0*md, n1 ); dmd := 2.0*dmd;
        nmd := n*mdr;
        ncph := nmd * cph; nsph := nmd * sph;
        dcph := dmd * cph; dsph := dmd * sph;
        rp := mdr * cph; ip := mdr * sph; rg := rp * ppm; ig := ip * ppm;
        rhr := rhr + ppm *(dcph*p1 + nsph*p3);
        rhi := rhi + ppm *(dcph*p2 + nsph*p4);
        ihr := ihr + ppm *(dsph*p1 - ncph*p3);
        ihi := ihi + ppm *(dsph*p2 - ncph*p4);
        drpm := rp; dipm := ip; drgsca := drgsca - ig; digsca := digsca + rg;
        flrph := flrph - ig * flph; fliph := fliph + rg * flph;
        rgf := rgf + rg; igf := igf + ig;
      end DSPFAC;




      procedure STRDSP;
      { modify the nuclear structure factor for modulated structures }
      var
        ppm, pph, md2, rhu, ihu, flph: real;

      begin { STRDSP }
        cmdsdsp := catome^.lstdsp;
        bdspm := false;
        if iqwave <> 0 then
        begin { Many Wave vector are define => occupency factor mod. only }
          bstp := false;
          if ABS( ne ) = 1 then
          begin { Can give H+q or H-q satellite only }
            { look for the actual wave vector }
            while (cmdsdsp <> nil) and not bstp do
            begin { Look for displacement with the hkl specified wave vector }
              bstp := ( cmdsdsp^.dwave^.sq.sequ = cdrec.mlq);
              if not bstp then cmdsdsp := cmdsdsp^.nxtdsp
            end;
            if bstp then
            with cmdsdsp^ do
            begin
              if ne > 0 then
              begin
                pph := phg - GTVD( mdspar[2] )*inrd; flph := -1.0
              end
              else
              begin
                pph := phg + GTVD( mdspar[2] )*inrd; flph := 1.0
              end;
              ppm := GTVD( mdspar[1] )
            end
          end;
          if not bstp then  begin  ppm := 1.0; pph := phg; flph := 0.0  end;
          drppm := COS( pph ); dippm := SIN( pph );
          rgf := ppm * drppm; igf := ppm * dippm;
          drgsca := -igf; digsca := rgf;
          flrph := drgsca * flph; fliph := digsca * flph
        end
        else { bessel mode function }
        { For a unique wave vector number 0 }
        with cmdsdsp^ do
        begin { For a unique wave vector => and a unique displacement }
          bdspm := true; { To flag the unique wave vector mode }
          c1 := hh*depi; c2 := kk*depi; c3 := ll*depi;
          rhu := c1*GTVD( mdspar[3] ) +
                 c2*GTVD( mdspar[4] ) + c3*GTVD( mdspar[5] );
          ihu := c1*GTVD( mdspar[6] ) +
                 c2*GTVD( mdspar[7] ) + c3*GTVD( mdspar[8] );
          md2 := SQR( rhu ) + SQR( ihu );
          if md2 > 1.0e-16 then
          begin
            md := SQRT( md2 );
            if ABS( rhu ) < 1.0e-16 then th := pis2
                                    else th := ARCTAN( ihu/rhu );
            if rhu < 0.0 then th := th + pis2*2.0;
            p1 := rhu/md; p2 := ihu/md; p3 := -ihu/md2; p4 := rhu/md2;
          end else
          begin
            th := 0.0; md := 0.0; p1 := 1.0; p2 := 1.0; p3 := 0.0; p4 := 0.0
          end;
          rgf := 0.0; igf := 0.0; drgsca := 0.0; digsca := 0.0;
          rhr := 0.0; ihr := 0.0; rhi := 0.0; ihi := 0.0;
          flrph := 0.0; fliph := 0.0;
          DSPFAC( ne, 1.0, 0.0, 0.0 );
          if catome^.lstmom <> nil then
          begin
            srgf := rgf; sigf := igf; sdrg := drgsca; sdig := digsca;
            srhr := rhr; srhi := rhi; sihr := ihr; sihi := ihi
          end;
          if mdspar[1] <> nil then
          begin
            ppm := GTVD( mdspar[1] ); pph := GTVD( mdspar[2] )*inrd;
            DSPFAC( ne-1, ppm, -pph, -1.0 );
            drppm := drpm; dippm := dipm;
            DSPFAC( ne+1, ppm, pph, 1.0 );
            drppm := drppm + drpm; dippm := dippm + dipm
          end
          else
          begin  drppm := 0.0; dippm := 0.0  end
        end;
        flrph := flrph * inrd; fliph := fliph * inrd
      end STRDSP;




      procedure STRMOM;
      { Comput the magnetic structure factor (and derivates) for one atom }
      var
        mdf, dmr, dmi: real;
        bqv: boolean;

        procedure MOMFAC( ivr, ivi, i: integer; var fr, fi: real );
        { to comput a magnetic structure factor componante and related derivates }
        var
          d1, d2, flph, rm, im, md1, md2, fmr, fmi: real;

        begin
          with cmoment^ do
          begin
            rm := GTVD( mompar[i] );
            md1 := srgf * rm; md2 := sigf * rm;
            if bqv then
            begin
              if ne > 0 then flph := -1.0 else flph := 1.0;
              im := flph * GTVD( mompar[i+3] );
              md1 := md1 - im * sigf; md2 := md2 + im * srgf;
              { derivate by moment imaginary componantes }
              MSETDER( ivr, ivi, mompar[i+3], -dmi*flph, dmr*flph )
            end else im := 0.0;
            { derivate by moment real componantes }
            MSETDER( ivr, ivi, mompar[i], dmr, dmi );
            fmr := mdf * md1; fmi := mdf * md2;
            fr := fr + fmr; fi := fi + fmi;
            { derivate by form factor }
            MSETDER( ivr, ivi, mompar[1], md1, md2 );
            { derivate by x,y,z coordinate }
            md1 := mdf *(drgsca*rm - digsca*im);
            md2 := mdf *(digsca*rm + drgsca*im);
            with catome^ do
            begin
              MSETDER( ivr, ivi, atmpar[4], md1*v1, md2*v1 );
              MSETDER( ivr, ivi, atmpar[5], md1*v2, md2*v2 );
              MSETDER( ivr, ivi, atmpar[6], md1*v3, md2*v3 );
              if pcntr <> nil then
              with pcntr^ do
              case i-1 of
                1: begin cxr := cxr + fmr; cxi := cxi + fmi end;
                2: begin cyr := cyr + fmr; cyi := cyi + fmi end;
                3: begin czr := czr + fmr; czi := czi + fmi end
              end;
              { derivate by modulated displacement }
              if cmdsdsp <> nil  then
              with cmdsdsp^ do
              begin
                if bdspm then
                begin
                  { the magnetique & crist. modulated both is not supported }
                  d1 := mdf*(rm*srhr-im*sihr); d2 := mdf*(im*srhr+rm*sihr);
                  MSETDER( ivr, ivi, mdspar[3], c1*d1, c1*d2 );
                  MSETDER( ivr, ivi, mdspar[4], c2*d1, c2*d2 );
                  MSETDER( ivr, ivi, mdspar[5], c3*d1, c3*d2 );
                  d1 := mdf*(rm*srhi-im*sihi); d2 := mdf*(im*srhi+rm*sihi);
                  MSETDER( ivr, ivi, mdspar[6], c1*d1, c1*d2 );
                  MSETDER( ivr, ivi, mdspar[7], c2*d1, c2*d2 );
                  MSETDER( ivr, ivi, mdspar[8], c3*d1, c3*d2 )
                end
              end
            end
          end
        end MOMFAC;


      begin { STRMOM }
        cmoment := catome^.lstmom;
        while cmoment <> nil do
        begin
          with cmoment^ do
          begin
            with cdrec do
              if mwave = nil then
                if (mlq=-1) or (nq=0) then bqv := true else bqv := false
              else
                if (mlq=mwave^.sq.sequ) and (ABS( nq )=1) then bqv := true
                                                          else bqv := bdspm;
            if bqv then
            begin
              bqv := (mwave <> nil);
              if bqv then bqv := not mwave^.relflg;
              mdf := GTVD( mompar[1] );
              dmr := mdf * srgf; dmi := mdf * sigf;
              MOMFAC( ivrx, ivix, 2, fxr, fxi );
              MOMFAC( ivry, iviy, 3, fyr, fyi );
              MOMFAC( ivrz, iviz, 4, fzr, fzi )
            end
          end;
          cmoment := cmoment^.nxtmom
        end
      end STRMOM;



    begin { SETSGATM }
      ne := cdrec.nq; bdspm := false;
      with catome^ do
      begin
        { comput the geometrical factor }
        if bcart then
        begin
          v1 := h2; v2 := k2; v3 := l2
        end else
        begin
          v1 := h1; v2 := k1; v3 := l1
        end;
        phg := v1 * GTVD( atmpar[4] ) +
               v2 * GTVD( atmpar[5] ) +
               v3 * GTVD( atmpar[6] ) + dphg;
        { first step of displacement factor }
        if lstdsp <> nil then
          STRDSP { Compute corrected geometrical factor for atom with mod. }
        else
        begin
          cmdsdsp := nil;    { No displacement for this atom }
          rgf := COS( phg ); igf := SIN( phg );
          if bcenter then
          begin
            drgsca := - 2.0 * igf; rgf := 2.0 * rgf;
            digsca := 0.0; igf := 0.0
          end else
          begin
            drgsca := - igf; digsca := rgf;
            if lstmom <> nil then
            begin
              srgf := rgf; sigf := igf; sdrg := drgsca; sdig := digsca
            end
          end
        end;
        { comput the magnetique structure factor }
        if magsel[cselect] then STRMOM;

        { computed only if radiative atom }
        if (lstdsp <> nil) or (ne = 0) then
        { condition of nuclear(n)/charge(rx) part contribution exist }
        if ((atmpar[1] <> nil) or (atmpar[2] <> nil)) and (atmpar[3] <> nil) then
        begin
          { comput the thermal factor }
          if banis then
          begin  { anistropic case }
            phh := -0.5 * SQR( v1 );
            pkk := -0.5 * SQR( v2 );
            pll := -0.5 * SQR( v3 );
            phk := - v1 * v2;
            phl := - v1 * v3;
            pkl := - v2 * v3;
            if not bcart then
            begin
              phh := phh * SQR( ra );
              pkk := pkk * SQR( rb );
              pll := pll * SQR( rc );
              phk := phk * ra * rb;
              phl := phl * ra * rc;
              pkl := pkl * rb * rc
            end;
            pat := phh*GTVD( atmpar[7] ) +
                   pkk*GTVD( atmpar[8] ) +
                   pll*GTVD( atmpar[9] ) +
                   phk*GTVD( atmpar[10] ) +
                   phl*GTVD( atmpar[11] ) +
                   pkl*GTVD( atmpar[12] );
            bdbw := true
          end else
          if atmpar[6] <> nil then
          begin { isotropic case }
            phh := - 0.25 * SQR( sitl );
            if buiso then phh := phh * 78.956836;
            pat := phh * GTVD( atmpar[7] );
            bdbw := true
          end
          else bdbw := false;
          if bdbw then  dbf := EXP( pat )  else  dbf := 1.0;
          { compute the diffusion factor }
          rdf := GTVD( atmpar[1] ); idf := GTVD( atmpar[2] );
          { compute population factor }
          pp := GTVD( atmpar[3] );
          { compute fnr and fni }
          ppdbf := pp * dbf;
          rgd := rdf * rgf - idf * igf; igd := rdf * igf + idf * rgf;
          fr := ppdbf * rgd; fi := ppdbf * igd;
          { compute fnr and fni derivates }
          { for  pp  }
          MSETDER( ivtnr, ivtni, atmpar[3], dbf*rgd, dbf*igd );
          { for  rdif,idif }
          d1 := ppdbf * rgf; d2 := ppdbf * igf;
          MSETDER( ivtnr, ivtni, atmpar[1],  d1, d2 );
          MSETDER( ivtnr, ivtni, atmpar[2], -d2, d1 );
          { for x,y,z }
          d1 := ppdbf * (drgsca * rdf - digsca * idf);
          d2 := ppdbf * (digsca * rdf + drgsca * idf);
          MSETDER( ivtnr, ivtni, atmpar[4], d1*v1, d2*v1 );
          MSETDER( ivtnr, ivtni, atmpar[5], d1*v2, d2*v2 );
          MSETDER( ivtnr, ivtni, atmpar[6], d1*v3, d2*v3 );
          { for displacement variable }
          if cmdsdsp <> nil then
          with cmdsdsp^ do { cmdsdsp points to related mdsdsp }
          begin
            d1 := ppdbf * (flrph * rdf - fliph * idf);
            d2 := ppdbf * (fliph * rdf + flrph * idf);
            MSETDER( ivtnr, ivtni, mdspar[2], d1, d2 );
            d1 := ppdbf * (rdf*drppm - idf*dippm);
            d2 := ppdbf * (rdf*dippm + idf*drppm);
            MSETDER( ivtnr, ivtni, mdspar[1], d1, d2);
            if bdspm then
            begin
              d1 := ppdbf * (rdf*rhr - idf*ihr);
              d2 := ppdbf * (idf*rhr + rdf*ihr);
              MSETDER( ivtnr, ivtni, mdspar[3], c1*d1, c1*d2 );
              MSETDER( ivtnr, ivtni, mdspar[4], c2*d1, c2*d2 );
              MSETDER( ivtnr, ivtni, mdspar[5], c3*d1, c3*d2 );
              d1 := ppdbf * (rdf*rhi - idf*ihi);
              d2 := ppdbf * (idf*rhi + rdf*ihi);
              MSETDER( ivtnr, ivtni, mdspar[6], c1*d1, c1*d2 );
              MSETDER( ivtnr, ivtni, mdspar[7], c2*d1, c2*d2 );
              MSETDER( ivtnr, ivtni, mdspar[8], c3*d1, c3*d2 )
            end
          end;
          { for  b - isotrope  }
          MSETDER( ivtnr, ivtni, atmpar[7], phh*fr, phh*fi );
          if banis then
          begin { for bet/u ij }
            MSETDER( ivtnr, ivtni,  atmpar[8], pkk*fr, pkk*fi );
            MSETDER( ivtnr, ivtni,  atmpar[9], pll*fr, pll*fi );
            MSETDER( ivtnr, ivtni, atmpar[10], phk*fr, phk*fi );
            MSETDER( ivtnr, ivtni, atmpar[11], phl*fr, phl*fi );
            MSETDER( ivtnr, ivtni, atmpar[12], pkl*fr, pkl*fi )
          end;
          fnr := fnr + fr; fni := fni + fi;
          if pcntr <> nil then
          with pcntr^ do
          begin  cnr := cnr + fr; cni := cni + fi  end
        end { for radiative atom only };
      end
    end SETSGATM;



    { to project  the magnetic structure factor on the refl. plane }
    procedure PROJECT( var vx, vy, vz: real; ex, ey, ez: real );
    var
      sca: real;

    begin
      sca := vx * ex + vy * ey + vz * ez;
      vx := vx - sca * ex; vy := vy - sca * ey; vz := vz - sca * ez
    end PROJECT;



    procedure NEUPOLA( px, py, pz: real; ip: integer );
    { To comput $calc and derivate for polarized neutron case }
    { px,py,pz = mag.field componante in work space, ip = polarization index }
    var
      pp, pm: ptder;
      exuu,  exdd,     { memory of extinction for i++ and i-- }
      exud,  exdu,     { and for i+-, i-+ }
      r1,    r2,   efp,   efm,
      ru,    rv,   du,    dv,
      fpl,   fmi,      { f+ and f- for flipping ratio }
      far,   fai,      { parrallel mag. struc. factor }
      dfar,  dfai,     { and related derivates }
      fclp,  fclm,     { f2++,f2-- }
      fcud,  fcdu,     { f2+-,f2-+ }
      dfclp, dfclm,    { and related derivates }
      dfcud, dfcdu,    { ... }
      fe2,             { perpandicular mag. struc. factor }
      dfe2,            { and related derivates }
      vdf,             { 1/2*(f2+- - f2-+) }
      dvdf: real;      { and related derivates }
      i, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10: integer;

    begin
      far := SQRT( SQR( px ) + SQR( py ) + SQR( pz ) ); { get mag. field magnetude }
      if far > 0.0 then { if not nul }
      begin{ 1 }
        px := px/far; py := py/far; pz := pz/far; { normalize the mag.field }
        if cdata^.fn2corr <> nil then
        begin { 2 }
          CPF2CORR( fnr, fnr, cdata^.fn2corr, ivtnr, ivtnr, false, bmatrix, true );
          CPF2CORR( fni, fni, cdata^.fn2corr, ivtni, ivtni, false, bmatrix, true )
        end; { 2 }
        if cdata^.fm2corr <> nil then
        begin { 2 }
          CPF2CORR( fxr, fxr, cdata^.fm2corr, ivrx, ivrx, false, bmatrix, true );
          CPF2CORR( fyr, fyr, cdata^.fm2corr, ivry, ivry, false, bmatrix, true );
          CPF2CORR( fzr, fzr, cdata^.fm2corr, ivrz, ivrz, false, bmatrix, true );
          CPF2CORR( fxi, fxi, cdata^.fm2corr, ivix, ivix, false, bmatrix, true );
          CPF2CORR( fyi, fyi, cdata^.fm2corr, iviy, iviy, false, bmatrix, true );
          CPF2CORR( fzi, fzi, cdata^.fm2corr, iviz, iviz, false, bmatrix, true )
        end; { 2 }
        far := fxr*px + fyr*py + fzr*pz; fai := fxi*px + fyi*py + fzi*pz;
        fclp := (SQR( fnr + e2gmc2*far ) + SQR( fni + e2gmc2*fai ))/2.0;
        fclm := (SQR( fnr - e2gmc2*far ) + SQR( fni - e2gmc2*fai ))/2.0;
        if (ip < 4) or (ip >5) then
        begin { 2 }
          { fclp/fclm = (fn +/- fhz)^2, fe2 = fhxy }
          fe2 := e2gmc2s2*(SQR( fxr ) + SQR( fyr ) + SQR( fzr ) - SQR( far ) +
                           SQR( fxi ) + SQR( fyi ) + SQR( fzi ) - SQR( fai ));
          vdf := e2gmc2s *(px*fyr*fzi + py*fzr*fxi + pz*fxr*fyi -
                           px*fzr*fyi - py*fxr*fzi - pz*fyr*fxi);
          fcud := fe2 - vdf; fcdu := fe2 + vdf
        end; { 2 }
        { comput derivates }
        if bmatrix then begin { 2 }
          i1 := ivrx; i2 := ivry; i3 := ivrz;
          i4 := ivix; i5 := iviy; i6 := iviz;
          i7 := ivtnr; i8 := ivtni;
          for i := 1 to varnb do
          begin { 3 }
            dfar := am[i1]*px + am[i2]*py + am[i3]*pz;
            dfai := am[i4]*px + am[i5]*py + am[i6]*pz;
            dfclp := ((fnr + e2gmc2*far)*(am[i7] + e2gmc2*dfar) +
                      (fni + e2gmc2*fai)*(am[i8] + e2gmc2*dfai));
            dfclm := ((fnr - e2gmc2*far)*(am[i7] - e2gmc2*dfar) +
                      (fni - e2gmc2*fai)*(am[i8] - e2gmc2*dfai));
            if (ip < 4) or (ip >5) then
            begin { 4 }
              dfe2 := e2gmc2s*
                      (fxr*am[i1] + fyr*am[i2] + fzr*am[i3] - far*dfar +
                      fxi*am[i4] + fyi*am[i5] + fzi*am[i6] - fai*dfai);
              dvdf := e2gmc2s*
                      (px*(am[i2]*fzi + fyr*am[i6] - am[i3]*fyi - fzr*am[i5]) +
                       py*(am[i3]*fxi + fzr*am[i4] - am[i1]*fzi - fxr*am[i6]) +
                       pz*(am[i1]*fyi + fxr*am[i5] - am[i2]*fxi - fyr*am[i4]));
              am[i3] := dfe2 - dvdf; am[i6] := dfe2 + dvdf
            end; { 4 }
            am[i7] := dfclp; am[i8] := dfclm;
            i1 := i1 + 1; i2 := i2 + 1; i3 := i3 + 1;
            i4 := i4 + 1; i5 := i5 + 1; i6 := i6 + 1;
            i7 := i7 + 1; i8 := i8 + 1
          end { 3 }
        end { 2 };
        { here i++, i--, i+- and i-- are computed with related derivates }
        { now we comput polarized extinction correction }
        if cnpola^.field[6] <> nil then
        begin { 2 } { set refcat for computing extinc factor }
          refcatsv := 4; { ++ }
          if virtvtab[4] <> nil then virtvtab[4]^.curval := fclp;
          PARMDERVAL( 5 ); { comput extinc. coef. and derivates i++ }
          exuu := cnpola^.field[6]^.actval;
          CPF2CORR( fclp, fclp, cnpola^.field[6], ivtnr, ivtnr,
                    false, bmatrix, false );
          { set refcat for computing extinc factor }
          refcatsv := 5; { -- }
          if virtvtab[4] <> nil then virtvtab[4]^.curval := fclm;
          PARMDERVAL( 5 ); { comput extinc. coef. and derivates i-- }
          exdd := cnpola^.field[6]^.actval;
          CPF2CORR( fclm, fclm, cnpola^.field[6], ivtni, ivtni,
                    false, bmatrix, false );
          if (ip < 4) or (ip > 5) then
          begin { 3 } { set refcat for computing extinc factor }
            refcatsv := 6; { +- }
            if virtvtab[4] <> nil then virtvtab[4]^.curval := fcud;
            PARMDERVAL( 5 ); { comput extinc. coef. and derivates i+- }
            exud := cnpola^.field[6]^.actval;
            CPF2CORR( fcud, fcud, cnpola^.field[6], ivrz, ivrz,
                      false, bmatrix, false );
            { set refcat for computing extinc factor }
            refcatsv := 7; { -+ }
            if virtvtab[4] <> nil then virtvtab[4]^.curval := fcdu;
            PARMDERVAL( 5 ); { comput extinc. coef. and derivates i-+ }
            exdu := cnpola^.field[6]^.actval;
            CPF2CORR( fcdu, fcdu, cnpola^.field[6], iviz, iviz,
                      false, bmatrix, false );
            refcatsv := cdrec.refcat
          end { 3 }
        end else begin
          exuu := 1.0; exdd := 1.0; exud := 1.0; exdu := 1.0
        end { 2 };
        { now we must correct from polarization efficiencies }
        if ip < 4 then { for i+, i- and flipping ratio only }
        begin { 2 }
          with cnpola^ do
          begin { 3 }
            if field[4] = nil then
            begin pp := nil; efp := 1.0  end else
            with field[4]^ do
            begin
              efp := actval; pp := lstder
            end;
            if field[5] = nil then
            begin pm := nil; efm := 1.0  end else
            with field[5]^ do
            begin
              efm := actval; pm := lstder
            end
          end { 3 };
          fpl := fclp + fcud; fmi := fclm + fcdu;
          ru := fpl*efp + (1.0 - efp)*fmi;
          rv := fmi*efm + (1.0 - efm)*fpl;
          if isp = 0 then
          begin  fcalc2 := SQRT( ru ); fcalc2s := SQRT( rv )  end
          else
            if ba then
            begin
              fcalc2 := fcalc2 + mltg * ru;
              fcalc2s:= fcalc2s+ mltg * rv
            end else begin
              fcalc2 := mltg * ru; fcalc2s := mltg * rv
            end;
            { set final derivates and values }
            i1 := ivtnr; i2 := ivtni; i3 := ivrz; i4 := iviz;
            i7 := ivrx;  i8 := ivix;
            for i := 1 to varnb do
            begin
              r1 := am[i1] + am[i3]; r2 := am[i2] + am[i4];
              am[i7] := efp*(r1 - r2) + r2; am[i8] := efm*(r2 - r1) + r1;
              i1 := i1 + 1; i2 := i2 + 1; i3 := i3 + 1; i4 := i4 + 1;
              i7 := i7 + 1; i8 := i8 + 1
            end;
            while pp <> nil do
            begin
              with pp^ do begin
              i := idvar^.matind + ivrx - 1;
              am[i] := am[i] + derval*(fpl - fmi)
            end;
            pp := pp^.next
          end;
          while pp <> nil do
          begin
            with pm^ do begin
              i := idvar^.matind + ivix - 1;
              am[i] := am[i] + derval*(fmi - fpl)
            end;
            pm := pm^.next
          end;
          i1 := ivrx; i2 := ivix;
          i5 := idervec; i6 := ineumem;
          if ip = 2 { i- } then
          begin
            i6 := i5; i5 := ineumem;
            fcalc2 := fcalc2s
          end;
          for i := 1 to varnb do
          begin
            du := am[i1]; dv := am[i2];
            if isp = 0 then
            begin
              am[i5] := du/fcalc2/2.0;
              am[i6] := dv/fcalc2s/2.0
            end else
            if ba then
            begin
              am[i5] := am[i5] + mltg * du;
              am[i6] := am[i6] + mltg * dv
            end else begin
              am[i5] := mltg * du; am[i6] := mltg * dv
            end;
            i1 := i1 + 1; i2 := i2 + 1; i3 := i3 + 1; i4 := i4 + 1;
            i5 := i5 + 1; i6 := i6 + 1
          end;
          { if end of observation pack }
          if cdrec.is > 0 then
            if ip <> 3 then fstr := fcalc2 { for no flipping ratio }
            else begin { for flipping ratio computing }
              if fcalc2s < 1E-5 then fcalc2s := 1E-5;
              fstr := fcalc2/fcalc2s;
              i1 := idervec; i2 := ineumem;
              for i := 1 to varnb do
              begin
                am[i1] := (am[i1]*fcalc2s - fcalc2*am[i2])/sqr(fcalc2s);
                i1 := i1 + 1; i2 := i2 + 1
              end
            end
        end { 2 }
        else { if ip >= 4 }
        begin { 2 }
          case ip of
            0,1,2,3: ;
            4: { ++  } begin  i5 := ivtnr; fpl := fclp  end;
            5: { --  } begin  i5 := ivtni; fpl := fclm  end;
            6: { +-  } begin  i5 := ivrz;  fpl := fcud  end;
            7: { -+  } begin  i5 := iviz;  fpl := fcdu  end
          end;
          if isp = 0 then
            fcalc2 := SQRT( fpl )
          else
            if ba then
              fcalc2 := fcalc2 + mltg * fpl
            else
              fcalc2 := mltg * fpl;
          fstr := fcalc2 { set result for single i computing };
          i1 := idervec;
          for i := 1 to varnb do
          begin { 3 }
            if isp = 0 then
              am[i1] := am[i1]/(2.0*fcalc2)
            else
              if ba then
                am[i1] := am[i1] + mltg*am[i5]
              else
                am[i1] := mltg*am[i5];
            i1 := i1 + 1; i5 := i5 + 1
          end { 3 }
        end; { 2 }
        { update contribution }
        if contrhde <> nil then
        begin { 2 }
          ccontr := contrhde;
          while ccontr <> nil do
          begin { 3 }
            with ccontr^ do
            begin { 4 }
              if cdata^.fn2corr <> nil then
              begin { 5 }
                CPF2CORR( cnr, cnr, cdata^.fn2corr, ivtnr, ivtnr,
                          false, false, false );
                CPF2CORR( cni, cni, cdata^.fn2corr, ivtni, ivtni,
                          false, false, false )
              end { 5 };
              if cdata^.fm2corr <> nil then
              begin { 5 }
                CPF2CORR( cxr, cxr, cdata^.fm2corr, ivrx, ivrx,
                          false, false, false );
                CPF2CORR( cyr, cyr, cdata^.fm2corr, ivry, ivry,
                          false, false, false );
                CPF2CORR( czr, czr, cdata^.fm2corr, ivrz, ivrz,
                          false, false, false );
                CPF2CORR( cxi, cxi, cdata^.fm2corr, ivix, ivix,
                          false, false, false );
                CPF2CORR( cyi, cyi, cdata^.fm2corr, iviy, iviy,
                          false, false, false );
                CPF2CORR( czi, czi, cdata^.fm2corr, iviz, iviz,
                          false, false, false )
              end { 5 };
              far := cxr*px + cyr*py + czr*pz; fai := cxi*px + cyi*py + czi*pz;
              fclp := exuu*((SQR( cnr + e2gmc2*far ) +
                             SQR( cni + e2gmc2*fai )))/2.0;
              fclm := exdd*((SQR( cnr - e2gmc2*far ) +
                             SQR( cni - e2gmc2*fai )))/2.0;
              if (ip < 4) or (ip > 5) then
              begin { 5 }
                fe2 := e2gmc2s2*(SQR( cxr ) + SQR( cyr ) + SQR( czr ) +
                                 SQR( cxi ) + SQR( cyi ) + SQR( czi ) -
                                 SQR( far ) - SQR( fai ));
                vdf := e2gmc2s *(px*cyr*czi + py*czr*cxi + pz*cxr*cyi -
                                 px*czr*cyi - py*cxr*czi - pz*cyr*cxi);
                fcud := exud*(fe2 - vdf); fcdu := exdu*(fe2 + vdf)
              end; { 5 }
              case ip of { 5 }
                0: ;
                1: { +   } ru := efp*(fclp + fcud) + (1.0-efp)*(fclm + fcdu);
                2: { -   } ru := efm*(fclm + fcdu) + (1.0-efm)*(fclp + fcud);
                3: { +/- }
                  begin { 6 }
                    r1 := fclp + fcud;
                    r2 := fclm + fcdu;
                    ru := (efp*r1 + (1.0 - efp)*r2);
                    rv := (efm*r2 + (1.0 - efm)*r1);
                    if isp = 0 then begin { 7 }
                      contrib := SQRT( ru ); contrib1 := SQRT( rv )
                    end else { 7 }
                      if ba then begin { 7 }
                        contrib := contrib + mltg*ru;
                        contrib1:= contrib1+ mltg*rv
                      end else begin { 7 }
                        contrib := mltg*ru; contrib1 := mltg*rv
                      end { 7 }
                    end { 6 };
                4: { ++  } ru := fclp;
                5: { --  } ru := fclm;
                6: { +-  } ru := fcud;
                7: { -+  } ru := fcdu
              end; { 5 }
              if ip <> 3 then
                if isp = 0 then contrib := SQRT( ru ) else
                  if ba then contrib := contrib + mltg * ru else
                    contrib := mltg * ru
                  else begin { 5 }
                    if cdrec.is > 0 then begin { 6 }
                      if contrib1 < 1E-5 then contrib1 := 1E-5;
                      contrib := contrib/contrib1
                    end { 6 }
                  end { 5 }
            end { 4 };
            ccontr := ccontr^.next
          end { 3 }
        end { 2 }
      end { 1 }
    end NEUPOLA;




  begin { STRFAC }
    bfini := true; bmini := true;
    with cdrec do
      if (mlq <> -1) and (nq <> 0) then
        with cwave^ do
        begin
          hh := hc + nq*vx;
          kk := kc + nq*vy;
          ll := lc + nq*vz
        end else
        begin  hh := hc; kk := kc; ll := lc  end;

    PARMDERVAL( 2 );                    { Comput reflexion dep. params }

    { Initialize derivate table }
    { ivtnr must be the first f derivate table in am }
    for i := ivtnr to itopvect do  am[i] := 0.0;
    { initialize the structure factors }
    fnr := 0.0; fni := 0.0;
    if momhde <> nil then
    begin
      fxr := 0.0; fyr := 0.0; fzr := 0.0;
      fxi := 0.0; fyi := 0.0; fzi := 0.0
    end;
    { Initialize contribution blocks }
    if contrhde <> nil then
    begin
      ccontr := contrhde;
      while ccontr <> nil do
      begin
        with ccontr^ do
        begin
          cnr := 0.0; cni := 0.0;
          cxr := 0.0; cyr := 0.0; czr := 0.0;
          cxi := 0.0; cyi := 0.0; czi := 0.0
        end;
        ccontr := ccontr^.next
      end
    end;
    { Check for not primitive lattice }
    if latticenb <> 1 then
      with cdrec do
      case latticenb of
        1{ P never }:
                bdbw := true;
        2{ A }: bdbw := not odd(k + l);
        3{ B }: bdbw := not odd(l + h);
        4{ C }: bdbw := not odd(h + k);
        5{ I }: bdbw := not odd(h + k + l);
        6{ R }: bdbw := (((-h + k + l) mod 3) = 0);
        7{ F }: bdbw := (not odd(h + k)) and (not odd(k + l))
      end
    else bdbw := true;
    { loop on symtry item for normal atom list }
    if bdbw then
    begin { we comput only the allowed reflexions }
      if atomhde <> atmshde then
      begin
        csymtry := symhde; bcenter := bcentric;
        while csymtry <> nil do
        begin
          TRANSHKL; PARMDERVAL( 3 );
          catome := atomhde;
          while catome <> atmshde do
          begin
            SETSGATM;
            catome := catome^.next
          end;
          csymtry := csymtry^.next
        end
      end;
      if atmshde <> nil then { Loop on the non symtry correlated atoms }
      begin
        bcenter := false;
        dphg := 0.0;
        PARMDERVAL( 3 );
        if cwave <> nil then bdbw := cwave^.relflg else bdbw := false;
        if bdbw then
        with cwave^,cdrec do
        begin { Rational modulated case }
          h1 := depi*(hr + nq*qx); k1 := depi*(kr + nq*qy);
          l1 := depi*(lr + nq*qz); h2 := depi*hh; k2 := depi*kk; l2 := depi*ll
        end
        else
        begin { normal case }
          h1 := depi*hr; k1 := depi*kr; l1 := depi*lr;
          h2 := depi*hc; k2 := depi*kc; l2 := depi*lc
        end;
        catome := atmshde;
        while catome <> nil do
        begin
          SETSGATM;
          catome := catome^.next
        end
      end
    end;
    { Now we comput the real structure factors and related derivates }
    { for nuclear structure factor }
    fnucl2 := SQR( fnr ) + SQR( fni );
    if virtvtab[2] <> nil then virtvtab[2]^.curval := fnucl2;
    i1 := ivtnr; i2 := ivtni;
    ifn := ivtfn;
    if bmatrix then
    for i := 1 to varnb do
    begin
      am[ifn] := 2.0 * (fnr * am[i1] + fni * am[i2]);
      i1 := i1 + 1; i2 := i2 + 1; ifn := ifn + 1
    end;
    { For magnetic structure factor }
    if (momhde <> nil) and magsel[cselect] then
    with cdrec do
    begin { Projection of f magn }
      { Save no projected magn. structure factor }
      fmxr := fxr; fmyr := fyr; fmzr := fzr;
      fmxi := fxi; fmyi := fyi; fmzi := fzi;
      { Normalize the h scatering vector }
      hhi := hh/sitl; kki := kk/sitl; lli := ll/sitl;
      PROJECT( fxr, fyr, fzr, hhi, kki, lli );
      PROJECT( fxi, fyi, fzi, hhi, kki, lli );
      fmag2 := e2gmc2s*(SQR( fxr ) + SQR( fyr ) + SQR( fzr ) +
                        SQR( fxi ) + SQR( fyi ) + SQR( fzi ));
      if bmatrix then
      begin
        ifm := ivtfm;
        i1 := ivrx; i2 := ivry; i3 := ivrz;
        i4 := ivix; i5 := iviy; i6 := iviz;
        for i := 1 to varnb do
        begin
          PROJECT( am[i1], am[i2], am[i3], hhi, kki, lli );
          PROJECT( am[i4], am[i5], am[i6], hhi, kki, lli );
          am[ifm] := 2.0 * e2gmc2s *(fxr * am[i1] + fyr * am[i2] + fzr * am[i3] +
                                     fxi * am[i4] + fyi * am[i5] + fzi * am[i6]);
          i1 := i1 + 1; i2 := i2 + 1; i3 := i3 + 1;
          i4 := i4 + 1; i5 := i5 + 1; i6 := i6 + 1;
          ifm := ifm + 1
        end
      end;
      { Computing projection for contribution also }
      if contrhde <> nil then
      begin
        ccontr := contrhde;
        while ccontr <> nil do
        begin
          with ccontr^ do
          begin
            PROJECT( cxr, cyr, czr, hhi, kki, lli );
            PROJECT( cxi, cyi, czi, hhi, kki, lli )
          end;
          ccontr := ccontr^.next
        end
      end;
      if virtvtab[3] <> nil then virtvtab[3]^.curval := fmag2;
    end else
    begin
      fmag2 := 0.0;
      if virtvtab[3] <> nil then virtvtab[3]^.curval := 0.0;
    end;
    { Now we comput all $fn2 and $fm2 related parameters }
    PARMDERVAL( 4 );
    if (cdrec.refcat <= 0) or (cnpola = nil)
       or (momhde = nil) or not magsel[cselect] then
    begin { not polarized neutron case or not magnetic case }
      { Comput $fm2, $fn2 and derivates }
      if (momhde <> nil) and magsel[cselect] then
      begin { none polarized magnetic case }
        CPF2CORR( fcalc2, fmag2,  cdata^.fm2corr, ivtfm, ivtni,
                  false, bmatrix, false );
        CPF2CORR( fcalc2, fnucl2, cdata^.fn2corr, ivtfn, ivtni,
                  true , bmatrix, false);
        if contrhde <> nil then
        begin
          ccontr := contrhde;
          while ccontr <> nil do
          begin
            with ccontr^ do
            begin
              v1 := e2gmc2s * (SQR( cxr ) + SQR( cyr ) + SQR( czr ) +
                               SQR( cxi ) + SQR( cyi ) + SQR( czi ));
              v2 := SQR( cnr ) + SQR( cni );
              CPF2CORR( cnr, v1, cdata^.fm2corr, ivtfm, ivtni,
                        false, false, false );
              CPF2CORR( cnr, v2, cdata^.fn2corr, ivtfn, ivtni,
                        true , false, false );
              if isp = 0 then contrib := SQRT( cnr ) else
                if ba then contrib := contrib + mltg * cnr else
                  contrib := mltg * cnr
            end;
            ccontr := ccontr^.next
          end
        end
      end else { Not magnetic }
      begin
        CPF2CORR( fcalc2, fnucl2, cdata^.fn2corr, ivtfn, ivtni,
                  false, bmatrix, false );
        if contrhde <> nil then
        begin
          ccontr := contrhde;
          while ccontr <> nil do
          begin
            with ccontr^ do
            begin
              v1 := SQR( cnr ) + SQR( cni );
              CPF2CORR( cnr, v1, cdata^.fn2corr, ivtfn, ivtni,
                        false, false, false );
              if isp = 0 then contrib := SQRT( cnr ) else
                if ba then contrib := contrib + mltg * cnr else
                  contrib := mltg * cnr
            end;
            ccontr := ccontr^.next
          end
        end
      end;
      { Comput the sf/f2/ray }
      if isp = 0 then fstr := SQRT( fcalc2 ) else
        if ba then fstr := fstr + mltg * fcalc2 else fstr := mltg * fcalc2;
      i1 := ivtni;
      if bmatrix then
        if isp = 0 then
          if ABS( fcalc2 ) < 1.0E-5 then
            for i:= idervec to ivtnr-1 do  am[i] := 0.0
          else
            for i:= idervec to ivtnr-1 do
            begin  am[i] := am[i1] /(2.0 * fstr); i1 := i1 + 1  end
        else
          if ba then
            for i:= idervec to ivtnr-1 do
            begin  am[i] := am[i] + mltg * am[i1]; i1 := i1 + 1  end
          else
            for i:= idervec to ivtnr-1 do
            begin  am[i] := mltg * am[i1]; i1 := i1 + 1  end
    end  else
    with cnpola^ do
      { polarized neutron case }
      NEUPOLA( GTVD( field[1] ), GTVD( field[2] ), GTVD( field[3] ), refcatsv )
  end STRFAC;





  { to comput the global residus and the least square matrixs }
  procedure COLLECT( bmatrix: boolean );

  var
    ncolref, { partial reflexion counter }
    iskp, i, j, k1, l1, iv, ip, iq, irf, idpol, idwav, mltg, nexcl: integer;
    wres, wcres, uwres, uwcres, swobs2, swobs, sobs2, sobs, { partial summation }
    rpf, fvr, drv, dcr, sca, efwe, efwe2, prdp, crmaxf, pchi2: real;
    bpart, bexcl: boolean;
    psc: ptder;
    pdsp, pblk: ptr;

  begin { COLLECT }
    cdata := datahde; sdelssg := 0.0;
    { initialize all general summations }
    crmaxf  := 0.0;
    gswobs2 := 0.0; gsobs2 := 0.0; gswobs := 0.0; gsobs   := 0.0;
    gwres   := 0.0; gwcres := 0.0; guwres := 0.0; guwcres := 0.0;
    ncpobs := 0; { total used reflexion number }
    { the ictetrm vector must be below ivtnr in am }
    if bmatrix then for i := 1 to ivtnr - 1 do am[i] := 0.0;
    CLRSUMHKL; { clear all pending hkl summation }
    while cdata <> nil do
    begin { 1 }
      with cdata^ do
      begin { 2 }
        CLOSE_BDTFILE( idat );
        OPENR_BDTFILE( idat, datfile );
        READ( idat, cdrec );
        if boutdat then                         { We must create an fourier output file }
        begin { 3 }
          if ofilespc = nil then NEW( ofilespc )
                            else CLOSE_BCFFILE( odat );
          ofilespc^ := datfile^;                { Copies the filename of data collection }
          ofilespc^.s[ofilespcpos]   := 'c';    { ... and modifies it }
          ofilespc^.s[ofilespcpos+1] := 'f';
          OPEN_BCFFILE( odat, ofilespc );
        end { 3 - if boutdat then };
        if boutmk3 then                         { We must create a mk3 fourier output file }
        begin { 3 }
          if mk3filespc = nil then NEW( mk3filespc )
                              else CLOSE_TXTFILE( mk3out );
          mk3filespc^ := datfile^; { copies the filename of data collection }
          mk3filespc^.s[ofilespcpos-1] := 'm'; { and modifies it }
          mk3filespc^.s[ofilespcpos]   := 'k'; { and modifies it }
          mk3filespc^.s[ofilespcpos+1] := '3';
          OPENW_TXTFILE( mk3out, mk3filespc, 0 )
        end { 3 - if boutdat then };
        idpol := -1; idwav := -1;
        { Initialize all particular sommations }
        swobs2 := 0.0; swobs := 0.0; sobs2 := 0.0; sobs   := 0.0;
        wres   := 0.0; wcres := 0.0; uwres := 0.0; uwcres := 0.0;
        ncolref := 0; nexcl := 0;
        bpart := false;
        if blisthkl and bmatrix then
        begin { 3 }
          NEWPARAGRAPHE( 25 );
          NEWLINELST;
          WRITE( lst, ' Data Reflection Collection "' );
          OUTNAMEID( name, 16 ); WRITELN( lst, '".' );
          UNDERLINE( 0, 37 );
          SKIPLINE( 1 );
          NEWLINELST; WRITE( lst, 'Reflexion computing ' );
          if cyclenb > ncycle then WRITELN( lst, 'after last cycle.' )
                              else WRITELN( lst, 'for cycle #', cyclenb:4 );
          SKIPLINE( 1 );
          ST_PUT_PASTR( sbttlpt^, ' OBS#' );
          if bselinlst then ST_PUT_PASTR( sbttlpt^, '/SEL#' )
          else
            if polhde <> nil then ST_PUT_PASTR( sbttlpt^, '/NPOL' )
                             else ST_PUT_PASTR( sbttlpt^,  '/ ' );
          ST_PUT_PASTR( sbttlpt^, '   H   K   L  M  N   RFN    IFN' );
          if blistfmag then
	    ST_PUT_PASTR( sbttlpt^,  '   RFX   IFX   RFY   IFY   RFZ   IFZ   ' )
          else if blistftmag then
	    ST_PUT_PASTR( sbttlpt^,  '  RFMX  IFMX  RFMY  IFMY  RFMZ  IFMZ   ' )
          else
          begin { 4 }
            ST_PUT_PASTR( sbttlpt^,  '   1/2D   ' );
            if bdsppar then
              for i := 1 to idspltb do
                ST_PUT_IDENT( sbttlpt^, dspltab[i]^.name^, 9 )
            else
              if momhde = nil then ST_PUT_PASTR( sbttlpt^,  '    F2    ' )
                              else ST_PUT_PASTR( sbttlpt^,  '   F2NUCL   F2MAG    F2SUM ' )
          end; { 4 }
          ST_PUT_PASTR( sbttlpt^,  '  CALC     OBS    DELTA  SIGMA   WEIGHT  DEL/SIG' );
          NEWLINELST;
          with sbttlpt^ do  WRITELN( lst, s:ORD( l ) );
          SKIPLINE( 1 )
        end { 3 - if blisthkl and bmatrix then };
        iskp := 0;                              { Set skip count for this data collection }
        for irf := 1 to ncp do
        begin { 3 }                             { Scan reflexions }
          bexcl := false;
          rpf := 0.0;
          with cdrec do
          begin { 4 }
            { Get reflexion category and ray selector }
            i := abs(is) div 64; ccateg := abs(is) mod 64;
            lccrf := 0.0; lccif := 0.0;
            if (ccateg <= mxcateg) and
               (h <= hma) and (h >= hmi) and (k <= kma) and
               (k >= kmi) and (l <= lma) and (l >= lmi) and
               (stsl >= minstsl) and (stsl <= maxstsl) then
            begin { 5 }                         { Selected reflexion }
              if i <> cselect then              { Comput nature dep. params }
              begin { 6 }                       { Change of nbsel }
                cselect := i; PARMDERVAL( 0 );
                if blisthkl and not bselinlst then
                begin { 7 }
                  SKIPLINE( 1 ); NEWLINELST;
                  WRITE( lst, ' Actual SELNB index is ', cselect:2 );
                  if bfmagnetic and (momhde <> nil) then
                  begin { 8 }
                    WRITE( lst, ' with magnetic mode ' );
                    if magsel[cselect] then
                      WRITE( lst, 'enable' )
                    else
                      WRITE( lst, 'disable' )
                  end { 8 };
                  WRITELN( lst, ' .' )
                end { 7 - if blisthkl then }
              end { 6 - change of nbsel };
              hr :=  h; kr :=  k; lr :=  l;
              hc := he; kc := ke; lc := le;
              if datcat < 2 then mltg := 1 else mltg := m;
              if mlq <> idwav then
                if mlq = -1 then cwave := nil else
                begin { 6 change of wave vector }
                  cwave := wavhde;
                  while (cwave^.sq.sequ <> mlq) and (cwave^.next <> nil) do
                    cwave := cwave^.next;
                  if blisthkl then
                  begin { 7 }
                    SKIPLINE( 1 ); NEWLINELST;
                    WRITE( lst, ' Actual Wave Vector is "' );
                    OUTNAMEID( cwave^.name, 16 ); WRITELN( lst, '"' )
                  end { 7 };
                  PARMDERVAL( 1 );
                  idwav := mlq
                end { 6 - change of wave vector };
              if ipl <> idpol then
                if ipl = -1 then cnpola := nil else
                begin { 6  change of polarization }
                  cnpola := polhde;
                  while (cnpola^.sq.sequ <> ipl) and (cnpola^.next <> nil) do
                    cnpola := cnpola^.next;
                  if blisthkl then
                  begin { 7 }
                    SKIPLINE( 1 ); NEWLINELST;
                    WRITE( lst, ' Actual N Pola Dir. is "' );
                    OUTNAMEID( cnpola^.name, 16 ); WRITELN( lst, '"' )
                  end { 7 };
                  idpol := ipl
                end { 6 - change of polarization };
              if cnpola <> nil then refcatsv := refcat else refcatsv := 0;
              fcomicpu := CPU_CLOCK;
              sitl := stsl * 2.0;
              STRFAC( datcat, mltg, bpart, bmatrix );
              { Store the $calc computing cp time }
              fcomcpu := fcomcpu + CPU_CLOCK - fcomicpu;
              if (datcat = 2) and (is < 0 ) then bpart := true else
              begin { 6 } { it is a complet observation }
                fbmaticpu := CPU_CLOCK;
                bpart := false;
                { flipping ratio computing }
                if virtvtab[1] <> nil then virtvtab[1]^.curval := fstr;
                PARMDERVAL( 6 );                { Comput $calc dep. parameters }
                { perform correction }
                CPF2CORR( fvr, fstr, scale, idervec, idervec,
                          false, bmatrix, false );
                if dywecoef = nil then efwe := pds
                                  else efwe := pds * GTVD( dywecoef );
                efwe2 := SQR( efwe );
                if fvr > 1.0E-5 then            { Comput the max of likehoode factor }
                crmaxf := crmaxf + dobs*LN( fvr ) - ABS( fvr );
                delta := dobs - fvr; lccrf := fnr; lccif := fni;
                if ABS( sig ) < 1E-20 then begin
                                             rpf := 0.0; nexcl := nexcl + 1
                                           end
                                      else rpf := delta/sig;
                if (minhklrej = 0.0) or (minhklrej >= ABS( rpf )) then
                begin { 7 }                     { None rejected }
                  { Update least square matrix and constante vector }
                  pblk := blkhde;
                  ip := 1;
                  iq := ictetrm;
                  k1 := idervec;
                  if bmatrix then
                  while pblk <> nil do
                  begin { 8 }
                    iv := pblk^.vardim;
                    for i := 1 to iv do
                    begin { 9 }
                      l1 := k1;
                      prdp := efwe2 * am[k1];
                      for j := i  to iv do
                      begin { 10 }
                        am[ip] := am[ip] + prdp * am[l1];
                        ip := ip + 1; l1 := l1 + 1
                      end { 10 };
                      am[iq] := am[iq] + prdp * delta;
                      iq := iq + 1; k1 := k1 + 1
                    end { 9 };
                    pblk := pblk^.next
                  end { 8 - while pblk <> nil ... };
                  { update all particular summation }
                  wres   := wres   + SQR( efwe*delta );
                  wcres  := wcres  + efwe * ABS( delta );
                  uwres  := uwres  + SQR( delta );
                  uwcres := uwcres + ABS( delta );
                  swobs2 := swobs2 + SQR( efwe*dobs );
                  sobs2  := sobs2  + SQR( dobs );
                  swobs  := swobs  + efwe*ABS( dobs );
                  sobs   := sobs   + ABS( dobs );
                  ncolref:= ncolref+ 1;
                  if sig > 0.0 then sdelssg := sdelssg + SQR( rpf );
                  { store the matrix build cpu time }
                  fbmatcpu := fbmatcpu + CPU_CLOCK - fbmaticpu;
                  MAKESUMHKL { make sumhkl summation }
                end { 7 - if none rejected reflexion }
              end { 6 - complet reflexion };
              if blisthkl and bmatrix and ((minhkllst<= 0.0) or ((is > 0) and
                 (minhkllst < ABS( rpf )))) then
              begin { 6 }
                NEWLINELST;
                WRITE( lst, irf:5, '/' );
                if bselinlst then WRITE( lst, cselect:2, '  ' ) else
                  if (cnpola <> nil) and (refcat <> 0) then
                    WRITE( lst, refcod[refcat]:4 )
                  else
                    WRITE( lst, ' ' );
                WRITE( lst, h:4, k:4, l:4, m:3, nq:3, fnr:7:2, fni:7:2 );
                if blistfmag then
                  WRITE( lst, fxr:6:2, fxi:6:2, fyr:6:2,
                              fyi:6:2, fzr:6:2, fzi:6:2 )
                else if blistftmag then
                  WRITE( lst, fmxr:6:2, fmxi:6:2, fmyr:6:2,
                              fmyi:6:2, fmzr:6:2, fmzi:6:2 )
                else
                begin { 7 }
                  WRITE( lst, ' ', stsl:6:4 );
                  if bdsppar then
                    for ip := 1 to idspltb do
                      WRITE( lst, dspltab[ip]^.actval:9:4 )
                  else
                    if momhde = nil then WRITE( lst, fnucl2:10:2 )
                    else WRITE( lst, fnucl2:9:2, fmag2:9:2, fcalc2:9:2 )
                end { 7 };
                if is > 0 then
                begin { 7 }
                  WRITE( lst, fvr:9:2, dobs:9:2, delta:7:2, sig:7:2, ' ',
                              pds:9 );
                  if ABS( sig ) >  1E-20 then WRITE( lst, rpf:7:2 )
                                         else WRITE( lst, ' - - - ' );
                  if (minhklrej <> 0.0) and (minhklrej < ABS( rpf ))
                  then WRITE( lst, ' r' )
                end { 7 };
                WRITELN( lst )
              end { 6 - if blisthkl ... };
              if boutmk3 then
              begin
                fmzr := mk3x*fmxr + mk3y*fmyr + mk3z*fmzr;
                fmzi := mk3x*fmxi + mk3y*fmyi + mk3z*fmzi;
                WRITELN( mk3out, h:4, k:4, l:4,
                                 SQRT( SQR( fmzi ) + SQR( fmzr ) ):12:5,
                                 ARCTAN( fmzi, fmzr ):10:3,
                                 dobs:16:5, delta:12:5 )
              end;
              if boutdat then
              begin { 6 }
                with crrec do
                begin { 7 }
                  refskip := irf - iskp; iskp := irf;
                  csca := scale^.actval;
                  if fn2corr = nil then cfn2 := 1.0 else
                    cfn2 := fn2corr^.actval;
                  if fm2corr = nil then cfm2 := 1.0 else
                    cfm2 := fm2corr^.actval;
                  crf := lccrf; cif := lccif; cmag := fmag2; delssg := rpf
                end { 7 };
                WRITE( odat, crrec )
              end { 6 }
            end { 5 - if selected reflexion }
          end { 4 with cdrec do };
          { get next ref. but do not go to eof }
          if irf < ncp then READ( idat, cdrec )
        end; { 3 - for irf ... } { end of one collect }
        { update all general residu summations }
        gwres   := gwres   + wres  ; gwcres  := gwcres  + wcres ;
        guwres  := guwres  + uwres ; guwcres := guwcres + uwcres;
        gswobs2 := gswobs2 + swobs2; gswobs  := gswobs  + swobs ;
        gsobs2  := gsobs2  + sobs2 ; gsobs   := gsobs   + sobs  ;
        ncpobs := ncpobs + ncolref;
        { comput particular residus }
        if ncolref > varnb then
        begin { 3 }
          pchi2 := wres/( ncolref - varnb );
          if swobs2 > 1E-20 then  wres   := SQRT( wres / swobs2 )
                            else  wres   := -1.0;
          if swobs  > 1E-20 then  wcres  := wcres / swobs
                            else  wcres  := -1.0;
          if sobs2  > 1E-20 then  uwres  := SQRT( uwres / sobs2 )
                            else  uwres  := -1.0;
          if sobs   > 1E-20 then  uwcres := uwcres / sobs
                            else  uwcres := -1.0;

          if sbttlpt <> nil then
            sbttlpt^.l := chr( 0 ); { delete the sub-title }
          if nbcoll > 1 then
            if (blisthkl and bmatrix) or blistver then
            begin { 4 }
              NEWPARAGRAPHE( 16 );
              NEWLINELST;
              WRITE( lst,' Particular Agreement Factors for data collection "');
              OUTNAMEID( name, 16 ); WRITE( lst, '" with ', ncolref:6, ' ' );
              if b132 then WRITELN( lst, 'observations.' )
                      else WRITELN( lst, 'obs.' );
              if not bshortlst then UNDERLINE( 0, 86 );
              OUTRESIDU( lst, true, wres, wcres, uwres, uwcres, pchi2 );
              SKIPLINE( 1 )
            end { 4 }
        end
      end { 2 - with cdata^ do };
      cdata := cdata^.next
    end { 1 - while cdata <> nil do };

    { comput all general residus }
    if ncpobs > varnb then
    begin
      msig    := gwres  /( ncpobs - varnb );
      sdelssg := sdelssg/( ncpobs - varnb )
    end
    else
    begin
      msig := -1; sdelssg := -1
    end;

    if gswobs2 > 1E-20 then  gwres   := SQRT( gwres / gswobs2 )
                       else  gwres   := -1.0;
    if gswobs  > 1E-20 then  gwcres  := gwcres / gswobs
                       else  gwcres  := -1.0;
    if gsobs2  > 1E-20 then  guwres  := SQRT( guwres / gsobs2 )
                       else  guwres  := -1.0;
    if gsobs   > 1E-20 then  guwcres := guwcres / gsobs
                       else  guwcres := -1.0;

    if (baccconv and not bmatrix) or not baccconv then
    begin
      if bshortlst then NEWPARAGRAPHE( 16 ) else NEWPARAGRAPHE( 22 );
      NEWLINELST; WRITE( lst, ' General Agreement Factors ' );
      if cyclenb > ncycle then
      WRITE( lst, ' after cycle #', ncycle:4 ) else
      WRITE( lst, 'before cycle #', cyclenb:4 );
      WRITELN( lst, ' computed with ', ncpobs:6, ' observations.' );
      if not bshortlst then UNDERLINE( 0, 79 );

      if nexcl > 0 then
      begin
        NEWLINELST; WRITE( lst, ' There ' );
        if nexcl > 1 then WRITE( lst, 'are' ) else WRITE( lst, 'is' );
        WRITE( lst, ' diffraction line' );
        if nexcl > 1 then WRITE( lst, 's' ); WRITELN; NEWLINELST;
        WRITE( lst,' that cannot used to compute the squared goodness of fit.' )
      end;

      OUTRESIDU( lst, true, gwres, gwcres, guwres, guwcres, msig )
    end;
    lchi2 := cchi2;  cchi2 := msig; { update the last and current chi2 }
    lmaxf := cmaxf; cmaxf := crmaxf;{ and maxf factors }
    if sdelssg >= 0.0 then
      if ABS( (sdelssg - msig)/sdelssg ) > 1.0e-4 then
      begin { 1 }
        if not bshortlst then SKIPLINE( 2 );
        NEWLINELST;
        WRITELN( lst, ' and the Chi Squared from the initial sigma is ',
                      sdelssg:14:5 )
      end { 1 }
  end COLLECT;




  procedure SETVARIABLE( bresult: boolean; var imem: integer );

  { procedure to set the variable to there new values }
  { no output in bresult is false }
  var
    curdmp: real;

  begin
    with p^ do
    if dyndmp = nil then curdmp := 1.0
                    else curdmp := GTVD( dyndmp );
    if bresult then
    begin { 1 }
      if blstres or blstcorr then
      with p^ do
      begin { 2 }
        NEWPARAGRAPHE( 15 );
        NEWLINELST; WRITE( lst, ' Diagonal Block "' );
        OUTNAMEID( name, 1 );
        WRITE( lst, '" of ', vardim:4 ,' variables' );
        if dyndmp <> nil then
        begin
          WRITELN( lst );
          NEWLINELST;
          WRITE( lst, ' with a Damping Factor of ', curdmp:10 );
          if dynmrq = nil then WRITE( lst, ' .' )
        end;
        if dynmrq <> nil then
        begin
          WRITELN( lst );
          NEWLINELST;
          if dyndmp <> nil then WRITE( lst, ' and' );
          WRITE( lst, ' with an Marquward/Landquark factor of ');
          WRITE( lst, GTVD( dynmrq ):10 )
        end;
        WRITELN( lst, ' .' );
        SKIPLINE( 1 )
      end; { 2 }
      if blstres and not bshortlst then
      begin { 2 }
        NEWPARAGRAPHE( 8 );
        NEWLINELST; WRITELN( lst, ' ':8, 'Variable Informations :' );
        UNDERLINE( 7, 23 )
      end; { 2 }
      if blstres then
      begin { 2 }
        sbttlpt^.l := CHR( 0 );
        if cyclenb > ncycle then ifc := 3 else ifc := 2;
        if not b132 then ifc := ifc - 1;
        for i := 1 to ifc do
        begin { 3 }
          NEWPARAGRAPHE( 5 );
          ST_PUT_PASTR( sbttlpt^,  '  Name             New-Value     Sigma ' );
          if cyclenb <= ncycle then
          begin
            ST_PUT_PASTR( sbttlpt^,  '  Old-Value    Change ' );
            if i < ifc then ST_PUT_PASTR( sbttlpt^, '    ' )
          end
        end; { 3 }
        NEWLINELST;
        with sbttlpt^ do WRITELN( lst, s:ORD( l ) );
        SKIPLINE( 1 )
      end; { 2 }
    end { 1 };
    { comput the convergence acceleration factor }
    for i := 1 to p^.vardim do
    begin { 1 }
      with q^ do
      begin { 2 }
        oldval := curval; cursig := SQRT( ABS( msig*am[i+i2-1] ) );
        if cyclenb <= ncycle then
          curchg := curdmp * am[i+i1-1] else curchg := 0.0 ;
        { substrac the full change to the old value for conv. acc. }
        if bresult and baccconv then
        begin  oldval := curval - am[imem]; imem := imem + 1  end;
        curval := oldval + curchg;
        blimit := false; bmodulo := false;
        if baccconv and not bresult then
        { if convergence acceleration is enable }
        begin { 3 } { copy shift in memory }
          am[imem] := curchg; imem := imem + 1
        end { 3 }
        else
          if limptr <> nil then
          with limptr^ do
            if inflim < suplim then
            begin { 3 }
              if curval < inflim then
              begin  { 4 }
                curval := inflim; blimit := true
              end
              else if curval > suplim then
              begin { 4 }
                curval := suplim; blimit := true
              end { 4 }
            end { 3 }
            else { modulo case }
            begin { 3 }
              if curval < suplim then
              begin { 4 }
                bmodulo := true;
                curval := curval +
		          ABS( inflim ) *
                            (1 + TRUNC( (suplim-curval)/ABS( inflim ) ))
              end { 4 }
              else if curval > (suplim + ABS( inflim )) then
              begin { 4 }
                bmodulo := true;
                curval := curval -
                          ABS( inflim ) * TRUNC( (curval-suplim)/ABS( inflim ) )
              end { 4 }
            end; { 3 }
        if bresult and blstres then
        begin { 3 }
          if ((i mod ifc) = 1) or (ifc = 1) then NEWLINELST;
          WRITE( lst, ' ' ); OUTNAMEID( name, 16 );
          WRITE( lst, ' ', curval:10:5, ' ', cursig:10:5 );
          if cyclenb <= ncycle then
          begin { Reffinmement cycle }
            WRITE( lst, ' ', oldval:10:5, ' ', curchg:10:5 );
            if blimit  then WRITE( lst, '*Lr ' )   { never last cycle}
            else
              if bmodulo then WRITE( lst, '*Md ' ) { never last cycle}
              else
                if ((i mod ifc) <> 0) and (i < p^.vardim) then
                  WRITE( lst, ' ':4 )
          end;
          if ((i mod ifc) = 0) or (i >= p^.vardim) then
          begin
            WRITELN( lst );
            if not bshortlst and (varnb <= 10) then SKIPLINE( 1 )
          end
        end { 3 }
      end; { 2 }
      q := q^.sq.lnkpt
    end; { 1 }
    sbttlpt^.l := CHR( 0 ) { delete the sub-title line }
  end SETVARIABLE;



begin { CYCLE }
  PARMDERVAL( -1 ); { comput all parameters }
  SET_PAGEHEADING;
  COLLECT( true );
  if varnb > 0 then
  begin { 1 }
    if cyclenb > ncycle then
      if bdmpsig then { we output an sigma and correlation file }
        OPEN_LISTING( intf, 'MXDSCI.TMP', 0 );
    if blstres or blstcorr then
    begin { 2 }
      NEWPARAGRAPHE( 15 );
      NEWLINELST;
      if cyclenb > ncycle then WRITE( lst, ' Final Least Squares' );
      WRITE( lst, ' Structure Informations ' );
      if cyclenb <= ncycle then WRITE( lst, 'after cycle #', cyclenb:4, ' :' );
      WRITELN( lst ); UNDERLINE( 0, 42 );
      SKIPLINE( 2 );
    end; { 2 }
    finvmaticpu := CPU_CLOCK;
    p := blkhde;
    q := varhde;
    nerr := 0;
    blkmor := 1;
    blkvor := ictetrm;
    i1 := ivtnr; i2 := ivtni; i3 := imemory;
    while p <> nil do
    with p^ do
    begin { 2 }
      if dynmrq <> nil then MATCHANGEDIAG( vardim, blkmor, GTVD( dynmrq ) );
      MATINV( vardim, blkmor, blkvor, nerr, q );
      if not bnfsing and (nerr/varnb > maxsing) then ERROR( -100 )
      else
      begin { 3 }
       	RESOLV( vardim, blkmor, blkvor, i1, i2 ); { solve the system }
	SETVARIABLE( not baccconv, i3 ); { set the new variables values }
      end; { 3 }
      blkmor := blkmor + vardim*(vardim+1) div 2;
      blkvor := blkvor + vardim;
      i1 := i1 + vardim; i2 := i2 + vardim;
      p := p^.next
    end; { 2 }
    if not bstop then
    begin { 2 }
      if baccconv then COLLECT( true ); { comput the new r factors }
      p := blkhde; q := varhde;
      blkmor := 1; blkvor := ictetrm;
      i1 := ivtnr; i2 := ivtni; i3 := imemory;
      if (cyclenb > ncycle) or baccconv then
      while p <> nil do
      with p^ do
      begin { 3 }
	q2 := q; { set memory of the current block head }
	if baccconv then SETVARIABLE( true, i3 );
	if sbttlpt <> nil then sbttlpt^.l := CHR( 0 ); { delete the subttitle }
	if blstres then SKIPLINE( 2 );
	{ built the correlation matrix }
	if cyclenb > ncycle then
	begin { 4 }
	  bfirst := true;
	  ii := blkmor; ip := vardim; ij := ii + 1;
	  while ip > 1 do
	  begin { 5 }
	    jj := ii + ip; jp := ip - 1; q1 := q^.sq.lnkpt;
	    while jp > 0 do
	    begin { 6 }
	      am[ij] := am[ij]/SQRT( ABS( am[ii]*am[jj] ) );
	      if bdmpsig then
		WRITELN( intf, ' ', q^.varsequ:6,
		              ' ', q1^.varsequ:6, ' ', am[ij]:18 );
	      if not blstcorr and (mxcorrel > 0.0) then
	      if (ABS( am[ij] ) > mxcorrel) then
	      begin { 7 }
		if bfirst then
		begin { 8 }
		  NEWPARAGRAPHE( 16 ); NEWLINELST; bfirst := false;
		  WRITELN( lst, ' Matrix Correlation elements greater than ',
			        mxcorrel:8:4);
                  SKIPLINE( 2 )
		end; { 8 }
		NEWLINELST;
                WRITE( lst, ' '); OUTNAMEID( q^.name, 16 );
                WRITE( lst, ' With ' ); OUTNAMEID( q1^.name, 16 );
                WRITELN( lst, ' ':4, am[ij]:8:5 );
	      end; { 7 }
	      ij := ij + 1; jj := jj + jp; jp := jp - 1;
	      q1 := q1^.sq.lnkpt
	    end; { 6 }
	    if bdmpsig then
	    with q^ do
	      WRITELN( intf, ' ', varsequ:6, ' ', varsequ:6,
                             ' ', curval:18, ' ', SQR( cursig ):18 );
	    am[ii] := 1.0; q := q^.sq.lnkpt;
	    ij := ij + 1; ii := ii + ip; ip := ip - 1
	  end; { 5 }
	  if bdmpsig then
	  with q^ do
	    WRITELN( intf, ' ', varsequ:6, ' ', varsequ:6,
                           ' ', curval:18, ' ', SQR( cursig ):18 );
	  am[ii] := 1.0; q := q^.sq.lnkpt
	end; { 4 }
        if blstcorr then OUTMATRIX( blkmor, vardim, q2 );
        blkmor := blkmor + (vardim *(vardim + 1)) div 2;
        blkvor := blkvor + vardim;
        i1 := i1 + vardim; i2 := i2 + vardim;
	p := p^.next
      end { 3 } { with p^ do };
    end { 2 }{ while p <> nil do };
    if bnfsing and (nerr = varnb) then
    begin { 2 }
      NEWLINELST;
      WRITELN( lst, ' *** All Variables are Locked => Stop ***');
      ERROR( -101 )
    end; { 2 }
    if (cyclenb > ncycle) and bdmpsig then CLOSE_TXTFILE( intf );
    if (cyclenb <= ncycle) and (nvarrot > 0) then ROTATVAR;
    { comput the inversion/resolution cpu time }
    finvmatcpu := finvmatcpu + CPU_CLOCK - finvmaticpu
  end { 1 }
end CYCLE;





procedure SAVECYCLE( nc: integer );
var
  p: ptr;
  s: stp;

begin
  if (nc > 0) or ((nc = 0) and (psav = nil)) then
  begin
    s := ST_CREATE;
    ST_PUT_PASTR( s^, 'cycle_' );
    ST_PUT_INT( s^, nc, -4 );
    ST_PUT_PASTR( s^, '.mxd_save.1' );
    OPENW_TXTFILE( intf, s, 0 )
  end
  else OPENW_TXTFILE( intf, psav, 1 );
  WRITELN( intf, ' { ' );
  OUTRESIDU( intf, false, gwres, gwcres, guwres, guwcres, cchi2 );
  WRITELN( intf, ' }' );
  P := GVARHDE;
  while p <> nil do
  begin
    with p^ do
    begin
      WRITE( intf, ' ' ); OUTNAMEID( name, -16 );
      WRITELN( intf, ' = ', curval:15, ':', cursig:15, ';' )
    end;
    p := p^.next
  end;
  CLOSE_TXTFILE( intf )
end SAVECYCLE;





procedure COMPUT;
{ Make all wanted least square cycles }
begin
  cyclenb := 1;
  while (cyclenb <= ncycle+1) and not bstop do
  begin
    if cyclenb > ncycle then
    begin
      blstres  := true;
      blisthkl := blistref;
      blistver := blistvnd;
      blstcorr := blstmat;
      boutdat  := bdupdate;
      baccconv := false
    end;
    CYCLE;
    if ldisplayper > 0 then
     WRITELN( output, 'Finished Cycle ', cyclenb:1, '.');
    if bsavcycle and (cyclenb <= ncycle) then SAVECYCLE( cyclenb );
    cyclenb := cyclenb + 1
  end;
  PARMDERVAL( -1 )
end COMPUT;





procedure FINALOUTPUT;
{ Make final output of the save file }
{ Print the cpu time statistics }
var
  p: ptr;
  i: integer;

begin
  if (psav <> nil) or not bsavcycle then SAVECYCLE( 0 );
  if boutenst  then OUTSTRUCTURE;
  if blstparam then OUTPARAM;
  if boutatom  then OUTATOME; { option to create a standard atom file }
  NEWPARAGRAPHE( 14 );
  SKIPLINE( 2 );
  NEWLINELST; WRITELN( lst, ' ':12, 'Used CPU Time Statistics.' );
  UNDERLINE( 11, 24 );
  SKIPLINE( 1 ); NEWLINELST;
  WRITE( lst, ' Struc. Factor computing CPU time = ' ); WRITECPU( fcomcpu );
  NEWLINELST;
  WRITE( lst, ' Build matrix CPU time            = ' ); WRITECPU( fbmatcpu );
  NEWLINELST;
  WRITE( lst, ' Inversion/Resolution CPU time    = ' ); WRITECPU( finvmatcpu );
  NEWLINELST;
  WRITE( lst, ' Total used CPU time              = ' );
  WRITECPU( CPU_CLOCK - topcpu );
  SKIPLINE( 1 ); NEWLINELST
end FINALOUTPUT;





begin { MAIN MXDLSQ }
  if INIT then          { init process }
  begin
    BUILDTREE;          { build structure's trees }
    { cancels the no mag. str. factor list if no mag. moment defined }
    if momhde = nil then
    begin
      blistfmag  := false;
      blistftmag := false;
      boutmk3    := false
    end;
    if bshortlst then
    begin
      blistref   := false;
      blisthkl   := false;
      blstmat    := false;
      boutsym    := false;
      boutinst   := false;
      boutenst   := false
    end;
    if not bstop then
    begin
      SEPATM;           { separate the symtry-ed atoms and special atoms }
      LISTDER;          { create the parameter's derivate lists }
      SETREALVAR;	{ organize the lsq-block and variable structure }
      INIBLK	        { create block structure if not defined }
    end;
    if not bstop then
    begin
      ESTABLISH( ERROR_HANDLER );
      PARMDERVAL( -1 ); { to comput the first value of parameters }
      FIRSTOUTPUT;
      COMPUT;	        { comput as wanted }
      FINALOUTPUT	{ output the final argument as wanted }
    end
  end;
MXD_LSQ_STOP:
end MXD_LSQ.
