#
#       Makefile for MXD-DCP
#
#include $(PAS_DIR)/system.make
#

PAS	=	pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIBS	=	-lcpas -lm
LIB	=

C_FLAGS = -g -c

P_FLAGS = -t+

L_FLAGS = -g

SRCP =\
	$(Src)/mxd_lsq_main.pas \
	$(Src)/mxd_lsq_out.pas \
	$(Src)/mxd_lsq_fit.pas \
	$(Src)/mxd_appl_rtl.pas \
	$(Src)/mxd_cryst_rtl.pas \
	$(Src)/mxd_tree_bld.pas \
	$(Src)/mxd_tree_init.pas \
	$(Src)/mxd_tree_wrk.pas \
	$(Src)/mxd_bda.pas \
	$(Src)/mxd_math.pas \
	$(Src)/mxd_tree_dcp.pas

SPCS =\
	$(Src)/mxd_lsq_main.c \
	$(Src)/mxd_lsq_out.c \
	$(Src)/mxd_lsq_fit.c \
	$(Src)/mxd_appl_rtl.c \
	$(Src)/mxd_cryst_rtl.c \
	$(Src)/mxd_tree_bld.c \
	$(Src)/mxd_tree_init.c \
	$(Src)/mxd_tree_wrk.c \
	$(Src)/mxd_bda.c \
	$(Src)/mxd_math.c \
	$(Src)/mxd_tree_dcp.c

Obj =\
	$(oDir)/mxd_lsq_main.o \
	$(oDir)/mxd_lsq_out.o \
	$(oDir)/mxd_lsq_fit.o \
	$(oDir)/mxd_appl_rtl.o \
	$(oDir)/mxd_cryst_rtl.o \
	$(oDir)/mxd_tree_bld.o \
	$(oDir)/mxd_tree_init.o \
	$(oDir)/mxd_tree_wrk.o \
	$(oDir)/mxd_bda.o \
	$(oDir)/mxd_math.o

Objsp =\
        $(oDir)/mxd_tree_dcp.o

#

all:    $(Bin)/mxd_lsq $(Bin)/mxd_tree_dcp $(Src)/mxd_lsq.mxd_env

clean:
	rm -f $(SPCS) $(Obj) $(Bin)/mxd_lsq $(Bin)/mxd_tree_dcp $(Src)/mxd_lsq.mxd_env

$(Bin)/mxd_lsq: $(Obj)
	$(CC) $(L_FLAGS) $(Obj) $(LIB) $(LIBS) -o $@


$(oDir)/mxd_lsq_main.o: $(Src)/mxd_lsq_main.pas $(Src)/mxd_lsq_env.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_tree_codes.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_lsq_main
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_lsq_main.c -o $@

$(oDir)/mxd_lsq_out.o: $(Src)/mxd_lsq_out.pas $(Src)/mxd_lsq_env.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_tree_codes.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_lsq_out
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_lsq_out.c -o $@

$(oDir)/mxd_lsq_fit.o: $(Src)/mxd_lsq_fit.pas $(Src)/mxd_lsq_env.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_tree_codes.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_lsq_fit
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_lsq_fit.c -o $@

$(oDir)/mxd_appl_rtl.o: $(Src)/mxd_appl_rtl.pas  $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_appl_rtl
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_appl_rtl.c -o $@

$(oDir)/mxd_cryst_rtl.o: $(Src)/mxd_cryst_rtl.pas  $(Src)/mxd_tree_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_cryst_rtl
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_cryst_rtl.c -o $@

$(oDir)/mxd_tree_bld.o: $(Src)/mxd_tree_bld.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_tree_codes.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_tree_bld
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_tree_bld.c -o $@

$(oDir)/mxd_tree_init.o: $(Src)/mxd_tree_init.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_tree_codes.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_tree_init
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_tree_init.c -o $@

$(oDir)/mxd_tree_wrk.o: $(Src)/mxd_tree_wrk.pas $(Src)/mxd_tree_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_tree_wrk
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_tree_wrk.c -o $@

$(oDir)/mxd_bda.o: $(Src)/mxd_bda.pas  $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_bda
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_bda.c -o $@

$(oDir)/mxd_math.o: $(Src)/mxd_math.pas  $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_math
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_math.c -o $@

$(Bin)/mxd_tree_dcp: $(Objsp)
	$(CC) $(L_FLAGS) $(Objsp) $(LIB) $(LIBS) -o $@

$(oDir)/mxd_tree_dcp.o: $(Src)/mxd_tree_dcp.pas $(Src)/mxd_tree_codes.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_tree_dcp
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_tree_dcp.c -o $@

$(Src)/mxd_lsq.mxd_env: $(Bin)/mxd_tree_dcp
	./mxd_tree_dcp mxd_lsq.mxd_env

#
