%pragma trace 5;
{
                        S Y S T E M E * M X D *

        M X D   L E A S T - S Q U A R E S   E N V I R O N M E N T

                               F O R

        A P P L I C A T I O N   P R O G R A M   G E N E R A T I O N



           BY :
                P. WOLFERS
                C.N.R.S.
                LABORATOIRE DE CRISTALLOGRAPHIE
                B.P.  166 X   38042  GRENOBLE CEDEX
                                        FRANCE.

}

{***  VERSION 3.9 - E  OF  M-X-D  SYSTEM  ***}

{
       CPAS PASCAL ADAPTATION  FLAGGED BY  THE COMMENT
}
                   (** CPAS **)
{

        OPERATING SYSTEM AND COMPUTER SENSIBLE POINTS :


                     -- NOTHING --



}


{[inherit( 'MXDRTL' ), environment('MXDLSRT')]}
module MXDLSRT( input, output );

%include 'mxdsrc:mxd_rtl_env';

type

  threechar = packed array[1..3] of char;

  namcte    = packed array[1..8] of char;

  ptder = ^deriv;           { pointer of privat derivation result }

  ptr = ^node;

  {  definition of derivate block  }
  deriv = record
    next: ptder;            { link to next derivation }
    idvar: ptr;             { pointer of corresponding variable }
    derval: real            { value of the derivate }
  end;

  {  definition of node's types  }
  nodetype = (
    addop,  subop,  mulop,     divop,    powop,
    negop,  sqrto,  logop,     expop,    sinop,
    cosop,  tanop,  asino,     acoso,    atano,
    thop,   ipwop,  phaseop,   absop,    intop,      modop,
    bess1op,
    summop, indxrf, functcall, formalrf, formalcall,
    eqop,   neop,   ltop,      leop,     geop,       gtop,
    konst,  tabrf,  intrf,     selnd,    islnd,      sumhkl,
    parrf,  varrf,  contrf,    otheritem
  );

  {  equivalence between sequence number and additional pointer  }
  sqty = record case boolean of
        true: (sequ:  integer);
        false:(lnkpt: ptr)
  end;

  itemtype = (
    param,   varbl,   contrdf, indxdf, formaldf,
    usfunct, atome,   wave,    npola,  moment,
    mdsdsp,  datacol, lsqblk,  symtri
  );

  { limit block definition }

  limitblk = record
    inflim, suplim: real    { limit of variable excursion }
  end;

  { transformation matrix definition }

  matrix = array[1..3,1..3] of real;

  { additional cartesian transformation matrix definition }

  matrixpt = ^matrix;

  limblkptr = ^limitblk ;


  {  node and item definition  }


  seltyp = ( sz2, sz4, sz8, sz16, sz32 );


  nam_ptr = ^nameid;


  node = record
    case nodety: nodetype of
      eqop,  neop,  ltop,  leop,   geop,   gtop,
      addop, subop, modop:
        ( bin1,  bin2:  ptr);        { all bin. operators }
      mulop, divop, powop, phaseop:
        (       { spc. bin. ope. for derivation }
          bina1, bina2: ptr;         { the two operands }
          valb1, valb2: real         { the two last related value }
        );
      negop, intop: (una1: ptr);     { negate unary operators }
      sqrto, logop, expop, sinop, cosop, absop,
      tanop, asino, acoso, atano, thop:(  { all other unary operator }
          unaa1: ptr;                { the parameter }
          valu: real                 { the last related value }
        );
      bess1op:(                      { First Kind Bessel Function }
          bess1_n,                   { Bessel function Order }
          bess1_x: ptr;              { abcisse value expression }
          bess1_d: real              { Last abscisse value }
        );
      ipwop:(                        { integer power operator }
          rpw: ptr;                  { the parameter }
          valwpa: real;              { the last related value }
          ipw: integer               { the exponant value }
        );
      konst:( val: real);            { constante reference }
      summop:(                       { summation operator }
          loopbe, loopen, loopst,    { loop begin, end and step value }
          loopidx,                   { loop control index }
          loopexp: ptr               { loop expression object }
        );
      sumhkl:(                       { hkl sum operator }
          sumhval: real;             { sommation value }
          sumhnxt,                   { link to next sommation operator }
          exphdef: ptr               { expression definition }
        );
      tabrf, intrf:( idx: integer);  { table or internal ref. }
      selnd,islnd,formalcall,functcall:(
          { sel. of refer. table for various size }
          lstsel,                    { the last selected index }
          selsize: integer;          { used select size }
          case seltyp of
            sz2:    (seltb2:   array[0..1]   of ptr);
            sz4:    (seltb4:   array[0..3]   of ptr);
            sz8:    (seltb8:   array[0..7]   of ptr);
            sz16:   (seltb16:  array[0..15]  of ptr);
            sz32:   (seltb:    array[0..31]  of ptr)
        );
      varrf, parrf, contrf, indxrf, formalrf,
      otheritem:(    { all real item,parameters and variables }
        next: ptr;                   { link to next item in the same type }
        name: nam_ptr;               { item name }
        sq: sqty;                    { item sequence number }
        case itemtype of
          indxdf:(                   { index loop }
              indval: real           { index value }
            );
          formaldf:(                 { user function formal }
              nextfo,                { link to next formal }
              actuallink: ptr        { pointer to actual definition }
            );
          usfunct:(                  { user function }
              formallst,             { list of formal }
              exprvalue: ptr         { expression definition }
            );
          param:(                    { parameter item type }
             definition: ptr;        { parameter definition expression }
             lstder: ptder;          { list of derivate block }
             actval: real;           { actual value - computed by parmderval }
             spclnk: ptr             { link to next parm in the same cat. }
            );
          varbl:(                    { variable item type }
              varsequ:  integer;     { original variable sequence number }
              matind:   integer;     { index in lsq matrix }
              limptr:   limblkptr;   { limit block pointer (nil if no limits) }
              curval, cursig: real   { current value and sigma }
            );
          contrdf:(                  { partial $calc }
              contrib,
              contrib1,              { additional for flipping ratio }
              cnr, cni,              { partial nuclear structur factor }
              cxr, cyr, czr,         { partial magnetic structur factor }
              cxi, cyi, czi: real
            );
          atome:(
              lstmom, lstdsp,        { link to associated moments and/or disp.}
              pcntr: ptr;            { link to contribution }
              atmpar: array[1..12] of ptr;  { atom spec. }
              bcart, banis: boolean  { flags of cartesian coord. & b anis. }
            );
          wave:(
              qx, qy, qz,
              vx, vy, vz: real;      { wave vector components in cell, work }
              relflg: boolean        { rational flag }
            );
          npola:(
              { magnetic field components, efficiencies, pol.extinction }
              field:  array[1..6] of ptr
            );
          moment:(
              mwave,                 { associated wave vector if not nil }
              nxtmom: ptr;     { link to next moment with the same atome }
              mompar: array[1..7] of ptr;  { moment specif. }
            );
          mdsdsp:(
              dwave: ptr;            { associated  wave vector }
              nxtdsp: ptr;           { link to next dsp for the same atom }
              mdspar: array[1..8] of ptr
            );
          datacol:(
              datfile: stp;          { data file specification }
              dywecoef,              { dynamic weight coefficient }
              fn2corr, fm2corr,      { correction specification }
              scale: ptr;            { scale specification }
              datcat: integer;       { category of data sf/0,f2/1,ra/2 }
              ncp, ncpv: integer     { number of reflexion }
            );
          lsqblk:(
              vardim: integer;       { size of block }
              dyndmp,                { dynamic damping factor pointer }
              dynmrq,                { dynamic marquward factor pointer }
              lstvar: ptr            { pointer of the last variable of block }
            );
          symtri:(
              xx, xy, xz,  tx,
              yx, yy, yz,  ty,
              zx, zy, zz,  tz: integer; { natural sym. op.}
              mpt: matrixpt    { additional matrix for hexa. cart. atom }
            )
      )
  end;




var

  program_name: [global] packed array[1..6] of char;

  elpstim,                     { total elapsed time }
  topcpu:  [global] integer;   { total cpu time }

  pageheadpt1,                 { pointer to page head string part 1 }
  pageheadpt2,                 { pointer to page head string part 2 }
  sbttlpt: [global] stp;       { pointer of current sub-title }

  sumhhde,                     { list of all hkl sum op. }
  gvarhde,                     { list of all variables }
  varhde,                      { list of free variables }
  contrhde,                    { list of all contribution }
  parhde,                      { list of parameters }
  usfuncthde,                  { list of user function }
  formalhde,                   { list of formal }
  loopidxhde,                  { list of loop index }

  atomhde,                     { list of atoms }
  atmshde,                     { list of atoms without symtry }
  wavhde,                      { list of wave vectors }
  polhde,                      { list of polarisation direction }
  momhde,                      { list of magnetic moments }
  dsphde,                      { list of modulated displacments }
  freeblk,                     { list of unused lsq block }
  blkhde,                      { list of diagonal blocks }
  symhde,                      { list of symetri matrix }
  datahde: [global] ptr;       { list of data collection }

  pardhde: [global] array[0..6] of ptr; { lists of dep. param in six levels }

  hh, kk, ll,
  hc, kc, lc,
  hr, kr, lr,                  { current h,k,l,he,ke,le and vh + nq * vw }
  h1, k1, l1, h2,  k2,  l2,    { intermediate h k l }
  da, db, dc, dal, dbe, dga,
  ra, rb, rc, ral, rbe, rga,
  dvol, rvol: [global] real;   { unit cell }
  tmd, tmr:   [global] matrix; { cell matrix transformation }

  refcatsv,                    { neutron polarized index copy }
  nbfixed,                     { count of fixed variables }
  latticenb,                   { lattice identifier }
  nbcoll,                      { total number of collect }
  ncpobs: [global] integer;    { total number of data observations }

  bfmagnetic,                  { flag founded magnetic statement }
  bflimited,                   { flag existing variable limits }
  buiso,                       { indicator of u isotropic mode }
  bcentric: [global] boolean;  { indicator of centric mode }


  pttl,                        { title pointer }
  psav:     [global] stp;      { save variable filename pointer }


  rgf,  igf,                   { geometrical factor }
  fnr,  fni,                   { nuclear struc. factor }
  fxr,  fyr,  fzr,             { projected magnetic structure factor }
  fxi,  fyi,  fzi,
  rp1,  ip1,                   { modulated occupency factor }
  fmxr, fmyr, fmzr,            { no projected magn. structure factor save }
  fmxi, fmyi, fmzi,

  fnucl2,                      { squared nuclear structure factor }
  fmag2,                       { squared magnetic structure factor }
  fcalc2s,                     { total saved squared part for pol. neu. }
  fcalc2,                      { total squared structure factor }
  fstr,                        { computed none scaled data }
  delta,                       { difference with observation }
  curint: [global] real;       { current structur factor }

  cvariable,                   { Current variable for derivation }
  cformula,                    { Current formula node pointer }
  cparam,                      { Current variable parameter pointer }
  ccontr,                      { current contribution pointer }
  catome,                      { current atome pointer }
  csymtry,                     { current symtry matrix pointer }
  cmoment,                     { current moment pointer }
  cmdsdsp,                     { current mdsdsp pointer }
  cwave,                       { current wave vector pointer }
  cnpola,                      { current polarization dir. pointer }
  cdata:  [global] ptr;        { current data block pointer }

  cselect: [global] 0..maxsel; { current nature selector }

  iqwave,                      { last number of wave vector ident }
  mxcateg,                     { maximum reflexion family }
  ccateg:  [global] integer;   { current reflexion family }

  bstop,                       { indicate stop on error }

  b132,                        { option of listing form }
  bshortlst: [global] boolean; { option of short output list }


  varnb: [global] integer;     { total number of variable }


  magsel: [global] array[0..maxsel] of boolean; { selection of magnetic mode }

  namtab: [global] array[0..42] of nam_ptr;     { names of item field table }

  { extinction correction variable definitions }

  { virtual variable table for $CALC, $FN2, $FM2, $F2POL }
  virtvtab: [global] array[1..4] of ptr;


  cdrec: [global] datrec;      { current bdt record }
  crrec: [global] outblk;      { current binary computed F record }

  { input files }

  intf:   [global] text;       { reverse polish instructions input }
  idat:  [global] bdt_file;    { cristal data input }



{*************   General services routines  ***************}


{ initialize procedure to set at empty state all the tree structure }
[global]
function INIGE( var mxdnam: [readonly] string ): boolean;
var
  bok, bprt: boolean;
  i, ierr: integer;

begin
  topcpu       := CPU_CLOCK;           { get origine cpu time }
  pageheadpt1  := ST_CREATE;           { create the page head string #1 }
  pageheadpt2  := ST_CREATE;           { create the page head string #2 }
  ST_PUT_PASTR( pageheadpt2^, 'mxdint.tmp.1' ); { temporary use for open }
  { open the data file written by mxd program }
  OPEN_INPUT_TXTFILE( intf, pageheadpt2, bok, bprt, ierr );
  pageheadpt2^.l := CHR( 0 );          { release for the head page use }
  if bok then
  begin
    { open the listing file }
    OPEN_LISTING( lst, mxdnam, 1 );    { Default open at start }
    { SET ALL CONTROL TO INIT STATE }
    bstop      := false;
    psav       := nil;   pttl   := nil;
    sbttlpt    := nil;   iqwave := -1;
    nbcoll     := 0;
    nbfixed    := 0;     { no fixed variable }
    bflimited  := false; { no limits statement found }
    bfmagnetic := false; { no magnetic statement found on init time }
    for i := 1 to 4 do  virtvtab[i] := nil;
    { set all stucture list at empty state }
    sumhhde    := nil;
    wavhde     := nil;   polhde     := nil; contrhde  := nil;
    atomhde    := nil;   momhde     := nil; dsphde    := nil;
    parhde     := nil;   gvarhde    := nil; freeblk   := nil;
    usfuncthde := nil;   loopidxhde := nil; formalhde := nil;
    cselect    := 0;
    datahde    := nil;
    blkhde     := nil;
    symhde     := nil;
    { init listing parameters }
    pagenb     := 0;
    linewrt    := pagesize + 1;
    { set all default option }
    buiso      := true;
    latticenb  := 1      { for P lattice };
    bcentric   := false;
    bshortlst  := true;
    b132       := false; { terminal listing mode }
    { set magnetic mode any spectra }
    for i := 0 to maxsel do  magsel[i] := true;
    mxcateg    := 64;    { set to no reject mode }
    NEW( sbttlpt );
    sbttlpt^.l := CHR( 0 )
  end
  else
    WRITELN( ' *** FATAL ERROR == Cannot open the "mxdint.tmp.1" file.' );
  INIGE := bok
end { INIGE };



{ procedure newline with management of page size and page heading }
[global]
procedure NEWLINELST;
var
  i:            integer;
  timev, datev: timety;

begin
  linewrt := linewrt + 1;
  if linewrt >= pagesize then
  begin
    linewrt := 0;
    OUT_PAGE( lst );    { put a page eject }
    pagenb := pagenb + 1;
    GET_DATE( datev ); GET_TIME( timev );
    WRITE( lst, ' ', pageheadpt1^.s:60 );
    if not b132 then
    begin  WRITELN( lst ); linewrt := 1  end;
    WRITE( lst, ' run the ', datev, ' at ', timev, ' ':5 );
    with pageheadpt2^ do
      if ORD( l ) > 0 then WRITE( lst, s:ORD( l ) );
    WRITELN( lst, 'page ', pagenb:3 );
    if pttl <> nil then
      with pttl^ do
        if l <> CHR( 0 ) then WRITE( lst, s:ORD( l ) );
    WRITELN( lst );
    if sbttlpt <> nil then with sbttlpt^ do
      if l <> CHR( 0 ) then WRITE( lst, s:ORD( l ) );
    WRITELN( lst );
    WRITELN( lst)            { keep an empty line }
  end
end { NEWLINELST };



{ error send message procedure with setting of stop flag }
[global]
procedure ERROR( n: integer );
begin
  NEWLINELST;
  bstop := (n < 0);
  WRITE( lst, ' ', program_name, ' ');
  if n < 0 then WRITE( lst, 'FATAL ' )
           else WRITE( lst, 'WARNING/' );
  n := ABS( n );
  WRITELN( lst, 'ERROR #', n:4 );
  OUTERRMSGLINE( n )
end { ERROR };


[global]
procedure OPEN_ST_LISTING( var  f: text; ps: stp; mdflg: integer );
var
  i: integer;
  str: string( maxlinesz );

begin
  with ps^ do
  begin
    for i := 1 to ORD( l ) do  str[i] := s[i];
    str.length := ORD( l )
  end;
  OPEN_LISTING( lst, str, mdflg )
end { OPEN_ST_LISTING };


{ underline routine }
[global]
procedure UNDERLINE( i, n: integer );
begin
  NEWLINELST; WRITE( lst, ' ':i+1 );
  while n > 0 do
  begin WRITE( lst, '-' ); n := n - 1  end;
  WRITELN( lst )
end { UNDERLINE };



{ skipline is used to skip n lines on the listing }
[global]
procedure SKIPLINE( n: integer );
begin
  { skip n lines on the listing or skip to the next page at the next
    newlinelst call }
  if (n + linewrt) >= pagesize then
    linewrt := pagesize + 1
  else
  begin
    while n > 0 do
    begin
      NEWLINELST; WRITELN( lst ); n := n - 1
    end
  end
end { SKIPLINE };



{ procedure to optimize the page skip use }
[global]
procedure NEWPARAGRAPHE( n: integer );
{ n is the new paragraphe size in line }
begin
  if (linewrt + n) >= pagesize - 3 then linewrt := pagesize + 1
  else
    if bshortlst then SKIPLINE( 1 ) else SKIPLINE( 3 )
end { NEWPARAGRAPHE };



{ to write a cpu time in milli-seconde }
{ can be system dependante }
[global]
procedure WRITECPU( ti: integer );
const
  scom = ', ';

var
  r:       real;
  i,j,k,l: integer;

begin
  i := ti mod 1000; ti := ti div 1000; { get millisec. and ti in seconds. }
  j := ti mod 60;   ti := ti div 60;   { get seconds and ti in minuts. }
  k := ti mod 60;   ti := ti div 60;   { get minuts and ti in hours }
  l := ti mod 24;   ti := ti div 24;   { get hours and ti in days }
  r := j + i/1000.0;
  if ti > 0 then
  begin  WRITE( lst, ti:2, ' day' );
    if ti >= 2 then WRITE( lst, 's' ); WRITE( lst, scom )
  end;
  if l > 0 then
  begin
    WRITE( lst, l:2, ' hour' );
    if l >= 2 then write( lst, 's' );
    WRITE( lst, scom )
  end;
  if k > 0 then
  begin
    WRITE( lst, k:2, ' minute' );
    if k >= 2 then WRITE( lst, 's' );
    WRITE( lst, scom )
  end;
  WRITE( lst, r:7:3, ' second' );
  if r >= 2.0 then WRITE( lst, 's' ); WRITELN( lst, '.' )
end { WRITECPU };



{*************  Build Logical Tree routines  **************}



{ Call a main module procedure }
procedure SETOPTION( i, id: integer ); external; { defined in the appl. prg. }


[global]
function BUILDSYMBOL( var symb: [readonly] string ): nam_ptr;
var
  p:   nam_ptr;
  len: integer;

begin
  NEW( p );
  with p^ do
  begin
    len := symb.length;
    for i := 1 to len do s[i] := symb[i];
    l := CHR( len )
  end;
  BUILDSYMBOL := p
end { BUILDSYMBOL };


{ initab is used to creat a name table to internal created parameters }
[global]
procedure INITAB;
begin
  namtab[ 0] := BUILDSYMBOL( '.U23'   ); namtab[ 1] := BUILDSYMBOL( '.U13'   );
  namtab[ 2] := BUILDSYMBOL( '.U12'   ); namtab[ 3] := BUILDSYMBOL( '.U33'   );
  namtab[ 4] := BUILDSYMBOL( '.U22'   ); namtab[ 5] := BUILDSYMBOL( '.U11'   );
  namtab[ 6] := BUILDSYMBOL( '.Z'     ); namtab[ 7] := BUILDSYMBOL( '.Y'     );
  namtab[ 8] := BUILDSYMBOL( '.X'     ); namtab[ 9] := BUILDSYMBOL( '.PP'    );
  namtab[10] := BUILDSYMBOL( '.IDIF'  ); namtab[11] := BUILDSYMBOL( '.RDIF'  );
  namtab[12] := BUILDSYMBOL( '.IMZ'   ); namtab[13] := BUILDSYMBOL( '.IMY'   );
  namtab[14] := BUILDSYMBOL( '.IMX'   ); namtab[15] := BUILDSYMBOL( '.RMZ'   );
  namtab[16] := BUILDSYMBOL( '.RMY'   ); namtab[17] := BUILDSYMBOL( '.RMX'   );
  namtab[18] := BUILDSYMBOL( '.MDF'   ); namtab[19] := BUILDSYMBOL( '.IUZ'   );
  namtab[20] := BUILDSYMBOL( '.IUY'   ); namtab[21] := BUILDSYMBOL( '.IUX'   );
  namtab[22] := BUILDSYMBOL( '.RUZ'   ); namtab[23] := BUILDSYMBOL( '.RUY'   );
  namtab[24] := BUILDSYMBOL( '.RUX'   ); namtab[25] := BUILDSYMBOL( '.PPH'   );
  namtab[26] := BUILDSYMBOL( '.PPM'   ); namtab[27] := BUILDSYMBOL( '.SCALE' );
  namtab[28] := BUILDSYMBOL( '.EFFM'  ); namtab[29] := BUILDSYMBOL( '.EFFP'  );
  namtab[30] := BUILDSYMBOL( '.ZPOL'  ); namtab[31] := BUILDSYMBOL( '.YPOL'  );
  namtab[32] := BUILDSYMBOL( '.XPOL'  ); namtab[33] := BUILDSYMBOL( '.CFN2'  );
  namtab[34] := BUILDSYMBOL( '.CFM2'  ); namtab[35] := BUILDSYMBOL( '$CALC'  );
  namtab[36] := BUILDSYMBOL( '$FN2'   ); namtab[37] := BUILDSYMBOL( '$FM2'   );
  namtab[38] := BUILDSYMBOL( '$F2POL' ); namtab[39] := BUILDSYMBOL( '.DWC'   );
  namtab[40] := BUILDSYMBOL( '.DMP'   ); namtab[41] := BUILDSYMBOL( '.MRQ'   );
  namtab[42] := BUILDSYMBOL( '.CPOL'  )
end { INITAB };



{ schitem is used by buildtree, but can be used by setoption }
{ schitem search an item in specified list ( header pointer is h )
  and return the associated pointer to find item }
[global]
function SCHITEM( h: ptr; bl: boolean ): ptr;
var
  p1: ptr;
  b:  boolean;
  nb: integer;
  r:  real;

begin
  if not bl then { no option stat. } READ( intf, nb ) else
  { options statement read in real mode }
  begin  READ( intf, r ); nb := ROUND( r )  end;
  b  := false;
  p1 := h;
  while (p1 <> nil) and not b do
  begin
    b := (p1^.sq.sequ = nb);
    if not b then p1 := p1^.next
  end;
  SCHITEM := p1
end { SCHITEM };



{ buildtree built all logical list and trees of the structure to fit }
{ and also set the various users options as specified }
[global]
procedure BUILDTREE;
const
  maxsp = 63;

var
  sp: -1..maxsp;
  stk: array[0..maxsp] of ptr;
  tree: ptr;
  icd, i, j: integer;
  lvar, pitm, pl: ptr;
  virtualnode, bin, una: boolean;
  r: real;


  { to push in stack an expression element }
  procedure PUSH( p: ptr );
  begin
    if sp > maxsp then ERROR( -1 ) else sp := SUCC( sp );
    stk[sp] := p
  end { PUSH };



  { to pop an expression element from the stack }
  function POP: ptr;
  begin
    POP := stk[sp]; if sp < 0 then ERROR( -2 ) else sp := PRED( sp )
  end { POP };



  { to read (from instruction file "int") a name identifier }
  procedure READID( var pid: nam_ptr );
  var
    i: integer;
    ic: char;

  begin
    NEW( pid );
    with pid^ do
    begin
      READ( intf, ic );
      while (ic = ' ') and not EOF( intf ) do READ( intf, ic );
      i := 0;
      while not EOF( intf ) and not EOLN( intf ) and (ic > ' ') do
      begin
        if i < maxidsize then i := i + 1;
        s[i] := ic;
        READ( intf, ic )
      end;
      l := CHR( i )
    end
  end { READID };



  { to read from "int" file a character string }
  function READSTR: stp;
  var
    i, j: integer;
    p: stp;

  begin
    NEW( p ); { allocate a new string }
    with p^ do
    begin
      READLN( intf, i );
      if i >= maxlinesz then i := maxlinesz - 1; l := CHR( i );
      for j := 1 to i do  READ( intf, s[j] );
      s[i+1] := CHR( 0 );
    end;
    READSTR := p
  end { READSTR };



  { newitem create a new allocated item and link it in a list
    parameters : h   is the head pointer of the list,
                 p   is the pointer of new item (result),
                 itp is the type of item }
  procedure NEWITEM( var h, p: ptr; itp: itemtype );
  var
    p1: ptr;

  begin
    case itp of
      param:    NEW( p, parrf,     param );
      varbl:    NEW( p, varrf,     varbl );
      contrdf:  NEW( p, contrf,    contrdf );
      usfunct:  NEW( p, otheritem, usfunct );
      formaldf: NEW( p, formalrf,  formaldf );
      indxdf:   NEW( p, indxrf,    indxdf );
      atome:    NEW( p, otheritem, atome );
      wave:     NEW( p, otheritem, wave );
      npola:    NEW( p, otheritem, npola );
      moment:   NEW( p, otheritem, moment );
      mdsdsp:   NEW( p, otheritem, mdsdsp );
      lsqblk:   NEW( p, otheritem, lsqblk );
      symtri:   NEW( p, otheritem, symtri );
      datacol:  NEW( p, otheritem, datacol )
    end;
    if h = nil then h := p else
    begin
      p1 := h;
      while p1^.next <> nil do p1 := p1^.next;
      p1^.next := p
    end;
    with p^ do
    begin
      case itp of
        param:    nodety := parrf;
        varbl:    nodety := varrf;
        contrdf:  nodety := contrf;
        indxdf:   nodety := indxrf;
        formaldf: nodety := formalrf;
        usfunct, atome,   wave,    npola,
        moment,  mdsdsp,  lsqblk,  symtri,  datacol:
          nodety := otheritem
      end;
      next := nil
    end;
    READID( p^.name );
    READ( intf, p^.sq.sequ );
  end { NEWITEM };



  function GETVIRTVARBL( sqnb: integer ): ptr;
  { to get or creats a virtual variable for $calc, $fn2 and $fm2 managment }
  var
    p: ptr;

  begin
    if virtvtab[sqnb] = nil then
    begin { create a new virtual variable reference }
      NEW( p, varrf, varbl );
      with p^ do
      begin
        nodety  := varrf;
        next    := nil;
        name    := namtab[sqnb+34];
        sq.sequ := -sqnb;
        matind  := -sqnb;
        curval  := 0.0; cursig := 0.0; limptr := nil
      end;
      virtvtab[sqnb] := p
    end;
    { get the virtual variable reference }
    GETVIRTVARBL := virtvtab[sqnb]
  end { GETVIRTVARBL };



  { parpop take the appropriate pointer of expression trees in stack }
  { and generate the internal parameters for each used item field }
  function PARPOP( idv: integer; ph: ptr ): ptr;
  var
    p, pa, pb: ptr;

  begin
    p := POP;
    if p = nil then PARPOP := nil else
    if p^.nodety = parrf then PARPOP := p  { no duplicate parameter }
    else
    begin
      NEW( pa, parrf, param );
      if parhde = nil then parhde := pa else
      begin
        pb := parhde;
        while pb^.next <> nil do pb := pb^.next;
        pb^.next := pa
      end;
      with pa^ do
      begin
        nodety     := parrf;
        next       := nil;
        name       := namtab[idv];
        sq.lnkpt   := ph;
        lstder     := nil;
        definition := p; actval := 0.0
      end;
      PARPOP := pa
    end
  end { PARPOP };



  { buildstruc is use by builtree to build the whole set
    of described structure in term of list of item
    with expression trees take in stack }
  procedure BUILDSTRUC;
  var
    pst: stp;
    ppp: ptr;
    id:  integer;

  begin  { BUILDSTRUC }
    case icd of
      64 { cell } :
        begin
          READLN( intf, da, db, dc, dal, dbe, dga );
          READLN( intf, ra, rb, rc, ral, rbe, rga );
          READ( intf, dvol, rvol );
          for i := 1 to 3 do for j := 1 to 3 do
          begin
            READLN( intf );
            READ( intf, tmd[i,j], tmr[i,j] )
          end
        end;

      65,66 { catom,atom }:
        begin
          NEWITEM( atomhde, pitm, atome );
          with pitm^ do
          begin
            bcart  := (icd = 65) ; pcntr := nil;
            for id := 0 to 11 do atmpar[12-id] := PARPOP( id, pitm );
            lstmom := nil; lstdsp := nil;
            banis  := (atmpar[8] <> nil) and (atmpar[9] <> nil)
          end
        end;

      67 { moment }:
        begin
          NEWITEM( momhde, pitm, moment );
          with pitm^ do
          begin
            ppp := SCHITEM( atomhde, false );
            nxtmom := nil;
            with ppp^ do
              if lstmom = nil then lstmom := pitm else
              begin
                pl := lstmom;
                while pl^.nxtmom <> nil do pl := pl^.nxtmom;
                pl^.nxtmom := pitm
              end;
            mwave := SCHITEM( wavhde, false );
            for id := 0 to 6 do mompar[7-id] := PARPOP( id+12, pitm )
          end
        end;

      68 { mdsdsp }:
        begin
          NEWITEM( dsphde, pitm, mdsdsp );
          with pitm^ do
          begin
            ppp   := SCHITEM( atomhde, false );
            dwave := SCHITEM( wavhde,  false );
            nxtdsp := nil;
            with ppp^ do
              if lstdsp = nil then lstdsp := pitm else
              begin
                pl := lstdsp;
                while pl^.nxtdsp <> nil do pl := pl^.nxtdsp;
                pl^.nxtdsp := pitm
              end;
            for id := 0 to 7 do mdspar[8-id] := PARPOP( id+19, pitm )
          end
        end;

      69 { wave }:
        begin
          NEWITEM( wavhde, pitm, wave );
          iqwave := iqwave + 1;
          with pitm^ do
          begin
            READ( intf, vx, vy, vz, qx, qy, qz, id );
            relflg := (id > 0)
          end
        end;

      70 { npola }:
        begin
          NEWITEM( polhde, pitm, npola );
          with pitm^ do
          begin
            field[6] := PARPOP( 42, pitm ); { get ext. coef. }
            for id := 1 to 5 do  field[6-id] := PARPOP( 27+id, pitm )
          end
        end;

      71 { symtri }:
        begin
          NEWITEM( symhde, pitm, symtri );
          with pitm^ do
          begin
            READ( intf, xx, xy, xz, tx,
                       yx, yy, yz, ty,
                       zx, zy, zz, tz, id );
            if id <> 0 then { we have an additional matrix }
            begin
              NEW( mpt ); READLN( intf );
              for i := 1 to 3 do for j := 1 to 3 do  READ( intf, mpt^[i,j] )
            end else mpt := nil
          end
        end;

      72 { options }:
        begin
          READ( intf, i, id );
          if (i > 0) or (i < -100) then
            SETOPTION( i, id ) { set option with particular module }
          else
          begin { Management for all general options }
            r := 0.0;
            if id > 0 then READ( intf, r );
            if i = -1 then b132 := (r > 0.5)
            else
              if i = 0 then bshortlst := (r > 0.5)
          end
        end { options };

      73 { soptions }:
        begin
          READ( intf, i );
          { Management for all general options }
          pst := READSTR;
          case i of
            1: { save }    psav := pst;
            0: { title }   pttl := pst;
           -1: { listing } begin
                             CLOSE( lst );
                             OPEN_ST_LISTING( lst, pst, 1 ); { open new }
                             ST_FREE( pst )
                           end;
          otherwise
          end
        end;

      74 { null }: begin tree := nil; PUSH( tree ) end;
      75 { vardf }:
        begin
          NEWITEM( gvarhde, pitm, varbl );
          with pitm^ do
          begin  cursig := 0.0; limptr := nil;
            lvar := pitm; varsequ := sq.sequ; { preserv original seq. # }
            matind := 1; { assume free variable }
            READ( intf, curval, cursig )
          end
        end;

      76 { parmdf }:
        begin
          NEWITEM( parhde, pitm, param );
          with pitm^ do
          begin  definition := POP; actval := 0.0;
            spclnk := pitm; lstder := nil
          end
        end;

      77 { datacol }:
        begin
          NEWITEM( datahde, pitm, datacol ); nbcoll := nbcoll + 1;
          with pitm^ do
          begin
            dywecoef := PARPOP( 39, pitm );
            fm2corr  := PARPOP( 34, pitm );
            fn2corr  := PARPOP( 33, pitm );
            scale    := PARPOP( 27, pitm );
            datfile  := READSTR; { get the data file specification }
            READLN( intf ); READ( intf, datcat, ncp, ncpv );
            READLN( intf ); { skip h k l mini-maxi info }
            READLN( intf )  { skip collection summation }
          end
        end;

      79 { lsq block }:
        begin
          NEWITEM( blkhde, pitm, lsqblk );
          with pitm^ do
          begin
            dynmrq   := PARPOP( 41, pitm );
            dyndmp   := PARPOP( 40, pitm );
            lstvar   := lvar     { set last variable pointer }
          end
        end;

      80 { centered }:
        begin  READ( intf, i ); bcentric := (i > 0)  end;

      81 { assignvar }:
        begin
          pitm := SCHITEM( gvarhde, false );
          with pitm^ do  READ( intf, curval, cursig )
        end;

      82 { set b/u iso mode }:
        begin READ( intf, i ); buiso := (i > 0)  end;

      83 { set locked variable (or fixed) }:
        begin
          pitm := SCHITEM( gvarhde, false );
          if pitm^.matind <> 0 then nbfixed := nbfixed + 1;
          pitm^.matind :=  0
        end;

      84 { set free variable (or unfixed) }:
        begin
          pitm := SCHITEM( gvarhde, false );
          if pitm^.matind = 0 then nbfixed := nbfixed - 1;
          pitm^.matind :=  1
        end;

      85 { lattice extinction condition }:
        READ( intf, latticenb );

      86 { set of limit for a variable }:
        begin
          pitm := SCHITEM( gvarhde, false );
          with pitm^ do
          begin  NEW( limptr ); bflimited := true;
            with limptr^ do READ( intf, inflim, suplim )
          end
        end;

      87 { set magnetic and none magnetic magsel value }:
        begin bfmagnetic := true;
          for i := 0 to maxsel do
          begin
            READ( intf, j ); magsel[i] := (j > 0)
          end
        end;

      88 { define or complet a contribution }:
        begin
          READ( intf, id );
          if id > 0 then
          begin { new definition }
            NEWITEM( contrhde, pitm, contrdf );
            pitm^.contrib := 0.0
          end
          else pitm := SCHITEM( contrhde, false );
          ppp := SCHITEM( atomhde, false );
          ppp^.pcntr := pitm { set this atom to be attach to contribution }
        end;

      89 { define a formal }:
        begin
          NEWITEM( formalhde, pitm, formaldf );
          PUSH( pitm ) { push the formal in the stack }
        end;

      90 { define a user function }:
        begin
          NEWITEM( usfuncthde, pitm, usfunct );
          with pitm^ do
          begin
            exprvalue := POP; { get function expression }
            READ( intf, i );     { get parameter number }
            formallst := nil  { clear parameter list };
            while i <> 0 do
            begin
              ppp := POP; ppp^.nextfo := formallst; formallst := ppp;
              i := i - 1
            end
          end
        end;

      91 { define a loop index }:
        begin  NEWITEM( loopidxhde, pitm, indxdf ); PUSH( pitm )  end;

      78, 92, 93, 94, 95, 96, 97, 98, 99: { Undefined and reserved }

    otherwise
    end;
    READLN( intf )
  end { buildstruc };


begin { BUILDTREE }
  if parhde = nil then INITAB;
  sp := -1;
  lvar := nil;
  { the buildtree body build the expression trees }
  repeat
    READ( intf, icd ); virtualnode := false;
{WRITELN( ' RPN code = ', icd );}
    bin := false; una := false;
    if icd >= 0 then { legal node }
      if icd <= 63 then { relation node }
      begin
        case icd of
           0,2,3,4,5,6,7,63: virtualnode := true;

           1:                NEW( tree, tabrf );

          16:                NEW( tree, konst );
          17,18,48,
          50,51,52,53,54,55: NEW( tree, addop );

          19,20,22,34:       NEW( tree, mulop );

          21,49:             NEW( tree, negop );

          24,25,26,27,28,29,30,31,32,33,35:
                             NEW( tree, sqrto );

          23:                NEW( tree, ipwop );

          36:                NEW( tree, bess1op );

          43:
            begin { allocate sum node and build the list }
              NEW( tree, sumhkl );
              pl := sumhhde;
              if pl = nil then sumhhde := tree else
              begin
                while pl^.sumhnxt <> nil do  pl := pl^.sumhnxt;
                pl^.sumhnxt := tree
              end
            end;

          41,42,56,57:
            begin { for select, intsel, use call, indir user call }
              READ( intf, i ); { get select size }
              if icd > 42 then i := i + 1;
              case i of
                0,1,2: NEW( tree, selnd, sz2 );
                3,4:   NEW( tree, selnd, sz4 );
                5,6,7,8:
                       NEW( tree, selnd, sz8 );
                9,10,11,12,13,14,15,16:
                       NEW( tree, selnd, sz16 );
                17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32:
                       NEW( tree, selnd, sz32 )
              end;
              tree^.selsize := i;
            end;

          40: NEW( tree, summop );

        otherwise
        end { case icd of };
        if virtualnode then
          case icd of { we refer to an already existing node probably }
             0 { refer }:
              begin READ( intf, i ); { get the refer mode }
                if (i >= 19) and (i <= 22) then { $calc, $fn2, $fm2, $f2pol }
                  tree := GETVIRTVARBL( i - 18 )
                else
                begin  { true standard internal reference }
                  NEW( tree, intrf );
                  with tree^ do
                  begin
                    nodety := intrf; idx := i;
                    if i > 19 then idx := idx - 4
                  end
                end
              end;
             2 { parrf }:    tree := SCHITEM( parhde,     false );
             3 { varrf }:    tree := SCHITEM( gvarhde,    false );
             4 { contrrf }:  tree := SCHITEM( contrhde,   false );
             5 { indxrf }:   tree := SCHITEM( loopidxhde, false );
             6 { functrf }:  tree := SCHITEM( usfuncthde, false );
             7 { formalrf }: tree := SCHITEM( formalhde,  false );
            63 { connect in parrf }:
              begin
                READ( intf, i );
                case i of
                  0:  tree := SCHITEM( atomhde, false );
                  1:  tree := SCHITEM( momhde,  false );
                  2:  tree := SCHITEM( dsphde,  false );
                  3:  tree := SCHITEM( polhde,  false );
                  4:  tree := SCHITEM( datahde, false );
                  5:  tree := SCHITEM( blkhde,  false )
                end;
                READ( intf, j );
                if i < 4 then tree := tree^.atmpar[j]
                else
                  if j = 4 then { data collection }
                  case j of
                    1: tree := tree^.scale;
                    2: tree := tree^.fn2corr;
                    3: tree := tree^.fm2corr;
                    4: tree := tree^.dywecoef
                  end
                  else { lsq block }
                    if j = 1 then tree := tree^.dyndmp
                             else tree := tree^.dynmrq
              end
          end
        else
        with tree^ do
        begin
          case icd of
             1  { tabrf }: begin  nodety := tabrf; READ( intf, idx ) end;
             8,9,10,11,12,13,14,15 { undefined }: ;
            16 { konst }: begin  nodety := konst; READ( intf, val ) end;
            17 { addop }: begin  nodety := addop; bin := true  end;
            18 { subop }: begin  nodety := subop; bin := true  end;
            19 { mulop }: begin  nodety := mulop; bin := true  end;
            20 { divop }: begin  nodety := divop; bin := true  end;
            21 { negop }: begin  nodety := negop; una := true  end;
            22 { powop }: begin  nodety := powop; bin := true  end;
            23 { ipwop }:
              begin  nodety := ipwop; READ( intf, ipw ); rpw := POP  end;
            24 { sinop }: begin  nodety := sinop; una := true  end;
            25 { cosop }: begin  nodety := cosop; una := true  end;
            26 { tanop }: begin  nodety := tanop; una := true  end;
            27 { asino }: begin  nodety := asino; una := true  end;
            28 { acoso }: begin  nodety := acoso; una := true  end;
            29 { atano }: begin  nodety := atano; una := true  end;
            30 { expop }: begin  nodety := expop; una := true  end;
            31 { logop }: begin  nodety := logop; una := true  end;
            32 {  sqrt }: begin  nodety := sqrto; una := true  end;
            33 {  thop }: begin  nodety :=  thop; una := true  end;
            34 { phaseop }:begin nodety :=phaseop; bin := true end;
            35 { absop }: begin  nodety := absop; una := true  end;
            36 { bess1op }:
                 begin nodety := bess1op;
                   bess1_x     := POP; bess1_n := POP; bess1_d := 0.0
                 end;
            37,38,39: { undefined };
            40 { summop }:
              begin
                nodety := summop; loopexp := POP;
                loopst := POP; loopen := POP; loopbe := POP;
                loopidx := POP
              end;
            41 { selnd }: nodety := selnd;
            42 { islnd }: nodety := islnd;
            43 { sumhkl }:begin  nodety := sumhkl; exphdef := POP  end;
            44,45,46,47: { undefined };
            48 { modop }: begin  nodety := modop; bin := true  end;
            49 { intop }: begin  nodety := intop; una := true  end;
            50 { eqop }:  begin  nodety := eqop;  bin := true  end;
            51 { neop }:  begin  nodety := neop;  bin := true  end;
            52 { ltop }:  begin  nodety := ltop;  bin := true  end;
            53 { leop }:  begin  nodety := leop;  bin := true  end;
            54 { geop }:  begin  nodety := geop;  bin := true  end;
            55 { eqop }:  begin  nodety := gtop;  bin := true  end;
            56,57 { call user function }:
              begin
                selsize := selsize - 1;
                if icd = 56 then { link to user defined function }
                begin
                  nodety := formalcall;
                  seltb[selsize] := SCHITEM( formalhde, false )
                end else
                begin
                  nodety := functcall;
                  seltb[selsize] := SCHITEM( usfuncthde, false )
                end
              end;
          end { case icd of };
          READLN( intf );
          if bin then
          begin  bin2 := POP; bin1 := POP  end
          else
            if una then una1 := POP
            else
              if (nodety = selnd) or (nodety = islnd) or
                 (nodety = functcall) or (nodety = formalcall) then
                for i := selsize-1 downto 0 do seltb[i] := POP
        end { with tree^ do };
        PUSH( tree )
      end { icd <= 63 }
      else { structure specifications }
        BUILDSTRUC
    else { warning/ mxd error flag }
    begin
        if icd = -1 then ERROR( 90 ) else ERROR( -89 );
        READLN( intf )
    end
  until EOF( intf ) or bstop;
  if not bshortlst then b132 := true;
  CLOSE_TXTFILE( intf )
end { BUILDTREE };



{*************  Small mathematical routines  **************}



[global]
function PHASEARG( ip, rp: real ): real;
var
  md, dp: real;

begin
  md := SQRT( SQR( ip ) + SQR( rp ) );
  if md = 0.0 then PHASEARG := 0.0
  else
  begin
    md := ip/md;
    if rp < 0.0 then PHASEARG := 180.0 - ARCSIN( md )
                else PHASEARG := ARCSIN( md )
  end
end { PHASEARG };



[global 'MXD_TANH']
function TANH( v: real ): real;
{ hyperbolic tangent function }
var
  v1: real;

begin
  v1 := EXP( -2.0*ABS( v ) );
  v1 := (1.0-v1)/(1.0+v1);
  if v >= 0.0 then TANH := v1 else TANH := - v1
end { TANH };



end.
