{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*                     Global     Environment     File                         *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


const

  mxd_heading      =   'P.Wolfers Software: MXD V4.0-000 of 31-DEC-2010';       { Version Title specification for page heading }

  mxd_search_path  =            './,HOME:/.mxd/,MXDLIB:,/usr/local/etc/';       { Search path for MXD }

  dat_blabel       =         'MXDV4-DATA-BASE';         { Binary Data File label strings }
  dat_clabel       =         'MXDV4-DATA-LSQF';         { The label sizes must be same }

  mxd_deflst       =                        '';         { Default listing = Listing on console (std. output file) }

  pi               =         4.0*ARCTAN( 1.0 );         { Pi Number }
  in_rd            =                  pi/180.0;         { To convert Decimal degrees to radian }

  max_hdt          =                        15;         { Maximum number of dependant value in data file }

  str_maxsize      =                       255;         { Used size of a command string }
  ide_maxsize      =                        62;         { Used size of a identifier name }

  unsmax           =               2.0**32-1.0;         { 32 bits unsigned maximum value }
  intmin           =                  -2.0**31;         { 32 bits integer minimum value }
  intmax           =               2.0**31-1.0;         { 32 bits integer maximum value }
  max_dblpow       =                       307;         { Maximum for exponent for double precision }
  max_fltpow       =                        38;         { Maximum for exponent for single precision }
  max_single       =                         7;         { Maximum of figure for a single prec. number }

  max_dattab_size  =                       255;         { Maximum of undefined use value in a data record }
  max_adidtb_size  =                        32;         { Maximum number of additional identifier in a data collection }
  max_supptb_size  = max_dattab_size - max_adidtb_size; { Maximum size for supplementary values }

  max_arg_dir      =                         5;         { Maximum number of directive argument in Pcode }

  frmarg_max       =                        32;         { Maximum number of arguments for User function (in .pcdf files) }


type
{ str_ptr          =                   ^string;         { Define the pointer of string - Type already defined in cpas_b__src_env }

  mxd_flt          =                    double;         { Define the used type of real (Double Precision) }

  sbyte            =             short_integer;         { 8 bits signed integer }

  str_string       =     string( str_maxsize );         { Specific string type to store character string }
  ide_string       =     string( ide_maxsize );         { Specific string type to store identifier name }


  symtry_ope = array[1..3,1..4] of byte;{ Symetry Operator - translation in 1/24 unit }

  matrix_ope = array[1..3,1..4] of mxd_flt; { Symetry Operator for work space - translation in Angstoem unit }

  matrix  = array[1..3,1..3] of mxd_flt; { Standard Matrix 3x3 }

  node_code = (                                         { * Define the MXD node codes * }
    nd_jobname,    nd_title,  nd_savfnam,               {  0 - Assign Jobname, job title, save status file specification }
     nd_string,     nd_null,    nd_konst,               {  3 - To push a string, a null refernce in the stack, Enter a numeric constant }
      nd_refer,   nd_paname,    nd_coeff,               {  6 - General reference, set a parameter name to id., LSQ coefficient reference }
     nd_tabref,   nd_definv,   nd_assvar,               {  9 - LSQ Table reference, Local Index/int.Var definition, LSQ_VAR assign }
     nd_defvar,   nd_defpar,   nd_addatf,               { 12 - Define a LSQ variable, define a parameter, Define Additional data field }
       nd_item,   nd_itmref,  nd_itmfldr,               { 15 - Node for item definition, item reference and item field reference }
       nd_data,   nd_permut,nd_directive,               { 18 - Data item, Stack Permutation, application directive }

    { Operator and scalar constante node definitions }
        nd_not,      nd_neg,      nd_pow,      nd_ipw,  { 21 - "not", unary "-", **<int>, **<flt> }
        nd_mul,      nd_div,                            { 25 - "*", "/" }
        nd_idiv,     nd_mod,      nd_rem,               { 27 - "idiv", "mod", "rem" }
        nd_add,      nd_sub,                            { 30 - "+", binary "-" }
         nd_eq,       nd_ne,       nd_lt,               { 32 - "=", "<>", "<" }
         nd_le,       nd_ge,       nd_gt,               { 35 - "<=", ">=", ">" }
        nd_and,      nd_xor,       nd_or,               { 38 - "and", "xor", "or" }

        nd_abs,     nd_sqrt,                            { 41 - ABS, SQRT }
       nd_sinr,     nd_cosr,     nd_tanr,               { 43 - SIN, COS, TAN with radian arguments }
      nd_asinr,    nd_acosr,    nd_atanr,   nd_phaser,  { 46 - ASIN, ACOS, ATAN, ATAN(2-arg) with radian results }
       nd_sind,     nd_cosd,     nd_tand,               { 50 - SIN, COS, TAN with degrees arguments }
      nd_asind,    nd_acosd,    nd_atand,   nd_phased,  { 53 - ASIN, ACOS, ATAN, ATAN(2-arg) with degrees results }
        nd_exp,       nd_ln,     nd_tanh,    nd_bessj,  { 57 - EXP, LN, TANH, BESSJ }
     nd_bessjh, nd_interpol,   nd_integr,     nd_summ,  { 61 - BESSJH, INTERPOL, INTEGR, SUMM }
      nd_trunc,    nd_round,                            { 65 - Conversion float to integer: TRUNC and ROUND }

        nd_nop,   nd_select,    nd_ifsel,               { 67 - Noop node, select function, ifselect function }
       nd_call,   nd_return,                            { 70 - Call and return of a function }

    nd_modload,                                         { 72 - pcd-code Module Load call }

    { Last definitions }
        nd_end
  );


  val_afl( val_all: integer ) = record          { * Define an array of float * }
    val_ftb: array[1..val_all] of mxd_flt;
  end;

  ftb_ptr   =         ^val_afl;         { * define the pointer of a dynamic floting array * }

  bin_file  =     file of char;         { * Define the Pascal Binary File Type * }




(*
  lsqp_index = (                        { * define the Least-Square Parameter index type and values }
    lsqp_h, lsqp_k, lsqp_l,             { Current H, K and L integer indicies (reciprocal space) }
    lsqp_nq, lsqp_mul,                  { Satellite order and multiplicity }
    lsqp_obs,
    lsqp_nf2,
    lsqp_mf2,
    lsqp_calc
  );
*)


[external]
var
  math_err:                    integer; { Last MATH Error number }

  dat_out,                              { Data output file variable }
  dat_inp:                    bin_file; { Data input file variable }

  dat_byte_count:             unsigned; { Data Byte count }



{ *** Defile the binary file I/O routine *** }

procedure READ_DATF_ST( var st: string ); external;
procedure WRITE_DATF_ST( st: string ); external;


procedure READ_DATF_UB( var ub: short_unsigned ); external;
procedure WRITE_DATF_UB( ub: short_unsigned ); external;
procedure READ_DATF_SB( var sb: short_integer ); external;
procedure WRITE_DATF_SB( sb: short_integer ); external;

procedure READ_DATF_UW( var uw: word_unsigned ); external;
procedure WRITE_DATF_UW( uw: word_unsigned ); external;
procedure READ_DATF_SW( var sw: word_integer ); external;
procedure WRITE_DATF_SW( sw: word_integer ); external;


procedure READ_DATF_UL( var ul: unsigned ); external;
procedure WRITE_DATF_UL( ul: unsigned ); external;
procedure READ_DATF_SL( var sl: integer ); external;
procedure WRITE_DATF_SL( sl: integer ); external;

procedure READ_DATF_FL( var fl: single ); external;
procedure WRITE_DATF_FL( fl: single ); external;
procedure READ_DATF_DB( var db: double ); external;
procedure WRITE_DATF_DB( db: double ); external;



procedure MATH_BESSEL_JDER( var dbjn, bjn: mxd_flt; x: mxd_flt; n: integer );
external;
function  MATH_BESSEL_JHDER( var dbjn, bjn: mxd_flt; x: mxd_flt; nm2: integer ): mxd_flt;
external;
function  MATH_BESSEL_J( rn: integer; rv: mxd_flt ): mxd_flt;
external;
function  MATH_BESSEL_JH( rn, rv: mxd_flt ): mxd_flt;
external;

function  MATH_GAMMA( xx: mxd_flt ): mxd_flt;
external;
function  MATH_INTERPOL( in_var ftab: val_afl; xx: mxd_flt ): mxd_flt;
external;
procedure MATH_GAUSS_INTEGR_BLDTAB( var ftab: val_afl; va, vb, ep: mxd_flt; ik: integer := 0 );
external;



{ *** End of environment *** }

