{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*               MXD   Data   Compiler   run   time   library                  *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module MXD_DCP_RTL;


  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }




{**************************************************}
{*******          Type Declarations          ******}
{**************************************************}




{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }

var
  curr_idname:                 str_ptr;         { Current identifier name pointer to search (when not in sy_ident) }



{ ************************************************************************************* }
{ ***  Global Variables of MXD-Data ComPiler environment declared with init values  *** }
{ ************************************************************************************* }





{ *************************************************************************************
  *                                                                                   *
  *                                                                                   *
  *              Run-Time Library routines for the MXD-V4 Data Compiler               *
  *                                                                                   *
  *                                                                                   *
  *************************************************************************************
}



{ ***************************************************************************** }
{ ***********  Small Routines to manage listing and error messages  *********** }
{ ***************************************************************************** }


[global]
procedure LISTING_SET_TITLE;
{ Routine to Head line of listing page (title) from the source file specification.
  This routine use the PASCAL package cpas_b__lst.
}

var
  st: string( 255 );

begin
  WRITEV( st, ' The Current Command File is "', FILE_SPECIFICATION( src_control^.src_file ), '".' );
  LST_CHANGE_TITLE( st )
end LISTING_SET_TITLE;



[global]
procedure INSERT_MESSAGE( in_var msg: string );
begin
  LST_NEWLINE;
  LST_PUT_STRING( msg );
  LST_EOLN
end INSERT_MESSAGE;



[global]
procedure LISTING_SET_SBTTL( str: str_ptr );
{ Routine to set page user title (SubTitle of cpas_b__lst package).
  This routine use the PASCAL package cpas_b__lst.
}

begin 
  with lst_current^ do
  begin
    if lst_sbttl <> nil then DISPOSE( lst_sbttl );
    lst_sbttl := nil;
    if str <> nil then
      if str^.length > 0 then
      begin
        NEW( lst_sbttl, str^.length );
        lst_sbttl^ := str^
    end
  end
end LISTING_SET_SBTTL;




%pragma trace 0;
[global]
procedure TRACE( in_var s: string );
{ Routine to force the PASCAL trace output.
}

  procedure TRACING( var f: text ); external 'PAS__BACK_TRACING';

begin
  WRITELN;
  WRITELN( ' *** TRACING "', s, '" :' );
  TRACING( output )
end TRACE;
%pragma trace 1;




[global]
procedure SRC_ERROR_S( modulesy:   error_mdnam;
                       number:         integer;
                       severity:     error_sev;
                       var id1, id2: [optional] string );
{ Routine to output a source error message with one or two
  additional string to insert in the SRC_ERROR message.
  This routine use the PASCAL package cpas_b__err.
}

var
  smb: string( 32 );

begin
  if id1"address <> nil then
  with id1 do
  begin
    smb.length := length;
    for i := 1 to length do  smb[i] := body[i];
    ERR_PUT_SYMBOL( smb )
  end;
  if id2"address <> nil then
  with id2 do
  begin
    smb.length := length;
    for i := 1 to length do  smb[i] := body[i];
    ERR_PUT_SYMBOL( smb )
  end;
  SRC_ERROR( modulesy, number, severity )
end SRC_ERROR_S;



[global]
function CHECK_SYMB_ERR( mdnam: error_mdnam; exsy: symbol; nerr: integer; var id: [optional] string ): boolean;
begin
  if sy_sym.sy <> exsy then
  begin
    if id"address <> nil then SRC_ERROR_S( mdnam, nerr, e_severe, id )
                         else SRC_ERROR( mdnam, nerr, e_severe );
    SKIP_SYMBOL( semicolon );
    CHECK_SYMB_ERR := true
  end
  else CHECK_SYMB_ERR := false
end CHECK_SYMB_ERR;




[global]
procedure SEARCH_FILE( in_var  path,                                    { Path to use can be string or array of char }
                              fname:                       string;      { Name of file to search }
                                acc:                      integer;      { Access required }
                       var       re:                       string;      { Returned complete file specification if found (fnd = true) }
                       var      fnd:                      boolean );    { Returned flag (true when found, false otherwise) }
{ Routine to search a file from a short PATH list (Path in a string - not an array).
}

var
  ip, ie, nb:  integer;

begin
  fnd := FILE_ACCESS_CHECK( fname, acc );                       { Before search on the local directory }
  if fnd then re := fname
  else
  begin
    ip  :=     1; nb  :=     1;
    while (ip <= path.length) and not fnd do                    { Loop on all PATH entry }
    begin
      ie  := INDEX( path, ',', nb );
      if ie = 0 then ie := path.length + 1;
      re  := SUBSTR( path, ip, ie - ip )||fname;
      ip  := ie + 1; nb := nb + 1;
      fnd := FILE_ACCESS_CHECK( re, acc );
    end;
    if not fnd then re.length := 0
  end
end SEARCH_FILE;




[global]
function IDE_SEARCH_FROM_NAMEID( ip: ide_ptr ): ide_ptr;
{ Load a given identifier in sy_ident and re-search it }
{ Use to get internal access of user defined generic of standard procedure/function.
}

var
  i, sz: integer;
  ir:    ide_ptr;

begin { IDE_SEARCH_FROM_NAMEID }
  ir := nil;
  if ip <> nil then
  begin
    curr_ide := ip;
    ir := IDE_SEARCH( true );
    curr_ide := nil
  end;
  IDE_SEARCH_FROM_NAMEID := ir
end IDE_SEARCH_FROM_NAMEID;



[global]
procedure DISPLAY_NEW;
{ Create a new identifier display tree.
}

const
  mdnam = 'DISN';

begin
  if curr_disp >= disp_max then SRC_ERROR( mdnam, 4, e_severe )
  else
  begin
    curr_disp := SUCC( curr_disp );
    with disp_tab[curr_disp] do
    begin
      disp_lex  := curr_lex;
      disp_own  :=      nil;
      disp_ent  :=      nil;
      disp_lty  :=      nil;
      disp_lid  :=      nil;
      disp_idt  :=      nil
    end
  end
end DISPLAY_NEW;



procedure FREE_TYPE_RECORD( typ: typ_ptr; dspl: integer );
var
  ip: ide_ptr;
  it: itm_ptr;

begin
  if typ <> nil then
    if typ^.typ_lex = dspl then
    begin
      with typ^ do
        case typ_frm of
          tfrm_array:
            FREE_TYPE_RECORD( typ_ael, dspl );  { Free the element  }

          tfrm_itmty:
            begin { For an item type }
              if typ_lel <> nil then            { Does not free the parent filed when not child field was defined }
                while typ_fel <> nil do         { Free all defined field identifier of the item type }
                begin
                  ip := typ_fel;
                  typ_fel := ip^.ide_lnk;
                  DISPOSE( ip )
                end;

              while typ_fit <> nil do           { Free all defined item of this type }
              begin
                it := typ_fit;
                typ_fit := it^.itm_next;
                DISPOSE( it )
              end
            end;

        otherwise
        end;
      DISPOSE( typ )
  end
end FREE_TYPE_RECORD;



[global]
procedure FREE_VAL_ALLOCATION( var val: val_rec );
begin
  with val do
  begin
    case val_frm of
      vfrm_str: DISPOSE( str );
      vfrm_ast: begin
                  for ii := 1 to aas^.val_all do
                    if aas^.val_stb[ii] <> nil then
                      DISPOSE( aas^.val_stb[ii] );
                  DISPOSE( aas )
                end;
      vfrm_ain: DISPOSE( aai );
      vfrm_afl: begin
                  DISPOSE( aaf );
                  if asg <> nil then DISPOSE( asg )
                end;
    otherwise
      { Nothing to do for all other cases }
    end;
    val_frm := vfrm_null
  end
end FREE_VAL_ALLOCATION;



[global]
procedure DISPLAY_FREE( bfree: boolean := true );
{ Free all identifier from the current identifier display, and remove it.
}

const
  mdnam = 'DISF';

var
  ap, bp:      typ_ptr;
  ip:          ide_ptr;
  en:          ent_ptr;

begin
  if curr_disp < 0 then SRC_ERROR( mdnam, 5, e_severe )
  else
  begin
    if bfree then
    with disp_tab[curr_disp] do
    begin
      while disp_idt <> nil do                  { Loop to free all internal identifier }
      begin
        ip := disp_idt;
        with ip^ do
        begin
          disp_idt := ide_lnk;                  { Keep the next identifier record address }
          DISPOSE( ide_name );                  { Free the identifier name }
          FREE_TYPE_RECORD( ide_typ, ide_displ );
          if ide_class = cla_varbl then FREE_VAL_ALLOCATION( idev_val )
        end;
        DISPOSE( ip )
      end;
      { Free all current display specific entries }
      while disp_ent <> nil do                  { Loop on all entry of the same display level }
      begin
        en := disp_ent;                         { This entry list is a LIFO }
        disp_ent := en^.ent_lnk;
        if en^.ent_knd = entk_fnc then
        with en^ do
        begin
          { Update the generic list of entry }
          if ent_prv <> nil then                { When this generic/operator entry as a previous definition }
            if ent_prv^.ent_dsp < curr_disp then{ When this previous entry is defined in an other display }
              if ent_ope = no_op then
                ent_ide^.ideg_last := ent_prv   { Reset the last generic definition at the limit of the previous display }
              else
                mop_tab[ent_ope].mop_last := ent_prv;

          { To free all user function allocation }


          DISPOSE( en )
        end
      end
    end;
    curr_disp := PRED( curr_disp )
  end
end DISPLAY_FREE;



[global]
function  TYP_NEW( frm: typ_forms; ide: ide_ptr; pty: typ_ptr; ilvl: integer := 0 ): typ_ptr;
var
  ty: typ_ptr;

begin { TYP_NEW }
  if ilvl <= 0 then ilvl := curr_disp;
  case frm of
    tfrm_array: NEW( ty, tfrm_array );
    tfrm_itmty: NEW( ty, tfrm_itmty );
  otherwise
    NEW( ty, tfrm_wild )
  end;
  with disp_tab[ilvl], ty^ do
  begin
    typ_ide := ide;
    typ_lnk := disp_lty; disp_lty := ty;
    typ_par := pty;
    typ_act :=   0;
    typ_flg :=  [];
    typ_lex := curr_disp;
    typ_frm := frm;
    case frm of
      tfrm_array:
        begin
          typ_ael :=   nil;
          typ_stp :=     1;
          typ_siz :=     1;
          typ_min :=     1
        end;
      tfrm_itmty:
        begin
          typ_fel :=   nil;
          typ_lel :=   nil;
          typ_fit :=   nil;
          typ_lit :=   nil;
          typ_ito :=   nil;
          typ_pcd :=     0;
          typ_nid :=     0;
          typ_nfl :=     0;
          typ_adv :=     0;
          typ_nis :=     0;
          typ_ifl :=    []
        end;
    otherwise
    end
  end;
  TYP_NEW := ty
end TYP_NEW;



[global]
function  GET_VAL_FORMS( ty: typ_ptr ): val_forms;
var
  elf: val_forms;

begin
  if ty <> nil then
    case ty^.typ_frm of
      tfrm_str:   GET_VAL_FORMS := vfrm_str;
      tfrm_int:   GET_VAL_FORMS := vfrm_int;
      tfrm_flt:   GET_VAL_FORMS := vfrm_flt;
      tfrm_array: begin
                    elf := GET_VAL_FORMS( ty^.typ_ael );
                    case elf of
                      vfrm_str: GET_VAL_FORMS := vfrm_ast;
                      vfrm_int: GET_VAL_FORMS := vfrm_ain;
                      vfrm_flt: GET_VAL_FORMS := vfrm_afl;
                    otherwise
                      GET_VAL_FORMS := elf
                    end
                  end;
      tfrm_itmty,
      tfrm_itmrf: GET_VAL_FORMS := vfrm_itm
    otherwise
      GET_VAL_FORMS := vfrm_null
    end
  else GET_VAL_FORMS := vfrm_null
end  GET_VAL_FORMS;



[global]
function  IDE_NEW( cla: cla_kinds; typ: typ_ptr; ilvl: integer := 0 ): ide_ptr;
{ To create the identifier sy_ident with the specified class and form_type in
  the current or specified display level tree. If it is already present, then,
  no identifier creation was not done and an error message is edited.
}

const
  mdnam = 'NEWI';

var
  ip, p1, p2:          ide_ptr;
  i:                   integer;
  errps, lleft, twdcl: boolean;

begin { IDE_NEW }
  if ilvl <= 0 then ilvl := curr_disp;
  twdcl := false;
  { Look for place in the tree and for previous declaration }
  with disp_tab[ilvl] do
  begin
    p2  := disp_idt;
    p1  := nil;
    if p2 <> nil then
    repeat
      p1 := p2;
      with p2^ do
      begin
        i := STR_MATCH( ide_name^, sy_ident );
        if i = 0 then twdcl := true             { Identifier is already existing }
                 else if i < 0 then begin
                                      p2 := p2^.ide_right; lleft := false
                                    end
                               else begin
                                      p2 := p2^.ide_left;  lleft := true
                                    end
      end
    until (p2 = nil) or twdcl;

    { If twdcl then the specified identifier is existing ... }
    { else p1 is nil (tree is empty) or must be used to attach the new ident. }
    if twdcl then
    begin
      SRC_ERROR_S( mdnam, 101, e_error, sy_ident ); ip := p2
    end
    else
    begin { New identifier to create }
      case cla of
        cla_type:       NEW( ip, cla_type );
        cla_itmfld:     NEW( ip, cla_itmfld );
        cla_field:      NEW( ip, cla_field );
        cla_varbl:      NEW( ip, cla_varbl );
        cla_formal:     NEW( ip, cla_formal );
        cla_standard,
        cla_generic:    NEW( ip, cla_generic );
        cla_directive:  NEW( ip, cla_directive );
      otherwise
      end;
      with ip^ do
      begin
        ide_name := nil;
        NEW( ide_name, sy_ident.length ); ide_name^  := sy_ident;
        ide_lnk    := disp_lid; disp_lid := ip; { Link ident. to build the LIFO of identifier }
        ide_left   :=      nil;
        ide_right  :=      nil;
        ide_typ    :=      typ;
        if typ <> nil then ide_flg := typ^.typ_flg
                      else ide_flg :=           [];
        ide_displ  :=     ilvl;
        ide_class  :=      cla;
        { Now set the identifier pointers }
        { Now Initialize the identifier value }
        case ide_class of
          cla_itmfld:
            begin
              idee_option := false;
              idee_isent  := false;
              idee_offset :=     0;
              idee_sequnb :=     0
            end;
          cla_field:
            begin
              ider_option := false;
              ider_offset :=     0;
              ider_sequnb :=     0
            end;
          cla_varbl:
            begin
              if typ <> nil then idev_spcact := typ^.typ_act
                            else idev_spcact := 0;
              idev_sequnb  :=         0;
              if typ <> nil then idev_val.val_frm := GET_VAL_FORMS( typ )
                            else idev_val.val_frm := vfrm_null
            end;
          cla_formal:
            begin
              idef_efn     :=        -1;
              idef_def     :=     false;
              idef_ref     :=     false
            end;
          cla_standard,
          cla_generic:
            begin
              ideg_first    :=      nil;
              ideg_last     :=      nil
            end;
          cla_directive:
            begin
              ided_dito    :=      nil;
              ided_code    :=        0;
              for ii := 1 to max_arg_dir do
              begin  ided_ntyp[ii] := nil; ided_nref[ii] := false  end;
              ided_narg    :=        0;
              ided_optf    :=    false;
              ided_nrep    :=    false
            end;
        otherwise
        end
      end;
      { Now attach the new identifier to the identifier tree }
      if p1 = nil then disp_idt := ip
                  else if lleft then p1^.ide_left  := ip
                                else p1^.ide_right := ip
    end
  end;
  sy_idenew := ip;
  IDE_NEW := ip
end IDE_NEW;



[global]
function  LEVEL_SEARCH( fp: ide_ptr ): ide_ptr;
{ Search the sy_ident identifier in a specified identifier display tree.
}

var
  p:           ide_ptr;
  i:           integer;
  found:       boolean;

begin { LEVEL_SEARCH }
  p     :=    fp;
  found := false;
  while not found and (p <> nil) do
  with p^ do
  begin
    if curr_idname = nil then i := STR_MATCH( ide_name^, sy_ident )
                         else i := STR_MATCH( ide_name^, curr_idname^ );
    if i = 0 then found := true
             else if i > 0 then p := p^.ide_left
                           else p := p^.ide_right
  end;
  LEVEL_SEARCH := p
end LEVEL_SEARCH;



[global]
function  IDE_SEARCH( berr: boolean; cls: cla_setty := [] ): ide_ptr;
{ Search the sy_ident identifier in the current identifier scope.
  If it is founded in an another class then the result is nil.
  If the identifier is not existing then nil is returned.
  If berr and "not found" then an error message is generated.
}

const
  mdnam = 'IDSE';

var
  ilvl:        integer;
  p:           ide_ptr;

begin { IDE_SEARCH }
  curr_idisp := curr_disp;                      { Set to predefined identifier lex level }
  repeat
    p := LEVEL_SEARCH( disp_tab[curr_idisp].disp_idt );
    if p = nil then curr_idisp := PRED( curr_idisp )
  until (p <> nil) or (curr_idisp < 0);

  if berr and (p = nil) then
  begin
    SRC_ERROR_S( mdnam, 104, e_severe, sy_ident );
    p := udc_ident
  end;
  IDE_SEARCH := p
end IDE_SEARCH;



[global]
procedure VAL_ALLOCATE( var val: val_rec; typ: typ_ptr );
var
  asz: integer;

begin
  if typ <> nil then
  with val, typ^ do
  if not (objf_wild in typ_flg) then
  begin
    val_cte := false;
    val_frm := GET_VAL_FORMS( typ );
    case val_frm of
      vfrm_str: str := nil;
      vfrm_int: int :=   0;
      vfrm_flt: begin  flt := 0.0; sig := 0.0  end;
      vfrm_ast: begin
                  NEW( aas, typ_siz*typ_stp );
                  with aas^ do
                    for ii := 1 to val_all do val_stb[ii] := nil
                end;
      vfrm_ain: begin
                  NEW( aai, typ_siz*typ_stp );
                  with aai^ do
                    for ii := 1 to val_all do val_itb[ii] :=   0
                end;
      vfrm_afl: begin
                  NEW( aaf, typ_siz*typ_stp );
                  with aaf^ do
                    for ii := 1 to val_all do val_ftb[ii] := 0.0;
                  if objf_sigma in typ_flg then
                  begin
                    NEW( asg, typ_siz*typ_stp );
                    with asg^ do
                      for ii := 1 to val_all do val_ftb[ii] := 0.0
                  end else asg := nil
                end;
      vfrm_itm: itm := nil;

    otherwise
    end
  end
  else val_frm := vfrm_null
end VAL_ALLOCATE;



[global]
procedure VAR_ALLOCATE( ide: ide_ptr );
begin
  if ide <> nil then VAL_ALLOCATE( ide^.idev_val, ide^.ide_typ )
end VAR_ALLOCATE;



[global]
procedure COPY_STRING( var src: str_ptr; var trg: str_ptr );
begin
  if trg <> nil then DISPOSE( trg );
  trg := nil;
  if src <> nil then
    if src^.length > 0 then
    begin
      NEW( trg, src^.length );
      for ii := 1 to src^.length do trg^[ii] := src^[ii];
      trg^.length := src^.length
    end
end COPY_STRING;



[global]
procedure VALUE_COPY( var trg, src: val_rec; shf: integer := 0 );
var
  len: integer;

begin
  with trg do
  if val_frm = src.val_frm then
  begin
    case val_frm of
      vfrm_str: COPY_STRING( src.str, str );
      vfrm_int: int := src.int;
      vfrm_flt: begin  flt := src.flt; sig := src.sig  end;
      vfrm_ast: if (src.aas <> nil) and (aas <> nil) then
                begin
                  len := src.aas^.val_all - shf;
                  if len > aas^.val_all then len := aas^.val_all;
                  with src.aas^ do
                    for i := 1 to len do  COPY_STRING( val_stb[i+shf], aas^.val_stb[i] )
                end;
      vfrm_ain: if (src.aai <> nil) and (aai <> nil) then
                begin
                  len := src.aai^.val_all - shf;
                  if len > aai^.val_all then len := aai^.val_all;
                  with src.aai^ do
                    for i := 1 to len do aai^.val_itb[i] := val_itb[i+shf]
                end;
      vfrm_afl: if (src.aaf <> nil) and (aaf <> nil) then
                begin
                  len := src.aaf^.val_all - shf;
                  if len > aaf^.val_all then len := aaf^.val_all;
                  with src.aaf^ do
                    for i := 1 to len do aaf^.val_ftb[i] := val_ftb[i+shf];
                  if (asg <> nil) and (src.asg <> nil) then
                    with src.asg^ do
                      for i := 1 to len do asg^.val_ftb[i] := val_ftb[i+shf]
                end;
      vfrm_itm: itm := src.itm;
      vfrm_itf: ifo := src.ifo;
    otherwise
    end
  end
end VALUE_COPY;


[global]
function  VAR_NEW( typ: typ_ptr; ilvl: integer := 0 ): ide_ptr;
const
  mdnam = 'VARN';

var
  id:          ide_ptr;
  fm:        typ_forms;

begin
  id := IDE_NEW( cla_varbl, typ, ilvl );
  if id <> nil then
  begin                            { Illegal use of wild type }
    if objf_wild in id^.ide_flg then SRC_ERROR( mdnam, 132, e_error );
    if not (objf_vbnda in id^.ide_flg) then VAR_ALLOCATE( id )
  end;
  VAR_NEW := id
end VAR_NEW;



[global]
function  USR_ELTAB_SCINIT( typ: typ_ptr ): tbs_ptr;
var
  p: tbs_ptr;

begin
  p := nil;
  if typ <> nil then
  with typ^ do
    if typ_frm = tfrm_array then
    begin
      NEW( p );
      with p^ do
      begin
        tbs_lnk := USR_ELTAB_SCINIT( typ_ael );
        tbs_min := typ_min;
        tbs_max := typ_min + typ_siz - 1;
        tbs_ind := typ_min
      end
    end;
  USR_ELTAB_SCINIT := p
end USR_ELTAB_SCINIT;



[global]
procedure USR_ELTAB_SCAN( tbs: tbs_ptr; var sindex: string; var bend: boolean );

  function INDEX_SCAN( tbs: tbs_ptr ): boolean;
  begin
    if tbs <> nil then
    with tbs^ do
    begin
      WRITEV( sindex:false, ',', tbs_ind:0 );           { Write the current sub-indexation }
      if INDEX_SCAN( tbs_lnk ) then
      begin                                             { The scan is finished for all sub indexes }
        if tbs_ind >= tbs_max then                      { The current index maximum is reached => ... }
        begin                                           { ... Return the current index to minimum and signal the end of scan }
          tbs_ind := tbs_min; INDEX_SCAN := true
        end
        else                                            { The current index can be incremented => ... }
        begin                                           { ... Increment the index and signal the continuation of the scan }
          tbs_ind := tbs_ind + 1; INDEX_SCAN := false
        end
      end
    end
    else INDEX_SCAN := true
  end INDEX_SCAN;


begin { USR_ELTAB_SCAN }
  if tbs <> nil then
  with tbs^ do
  begin
    WRITEV( sindex:false, '[', tbs_ind:0 );             { Write the first indexation }
    if INDEX_SCAN( tbs_lnk ) then
    begin                                               { The scan is finished for all sub indexes }
      if tbs_ind >= tbs_max then                        { The current index maximum is reached => ... }
      begin  tbs_ind := tbs_min; bend := true  end      { ... Return the current index to minimum and signal the end of scan }
      else                                              { The current index can be incremented => ... }
      begin  tbs_ind := tbs_ind + 1; bend := false  end { ... Increment the index and signal the continuation of the scan }
    end
    else bend := false;                                 { Some sub index(es) can be incremented }
    WRITEV( sindex:false, ']' )                         { Finish the indexation string }
  end
end USR_ELTAB_SCAN;



[global]
procedure USR_ELTAB_SCEND( tbs: tbs_ptr );
begin
  if tbs <> nil then
  begin
    if tbs^.tbs_lnk <> nil then USR_ELTAB_SCEND( tbs^.tbs_lnk );
    DISPOSE( tbs )
  end
end USR_ELTAB_SCEND;



[global]
function USR_IDE_LOCATE( in_var id_name: string ): ide_ptr;
var
  p: usrf_ptr;

begin
  p := furf_hde;
  while p <> nil do
  with p^ do
  begin
  exit if STR_MATCH( usrf_iref^.ide_name^, id_name ) = 0;
    p := p^.usrf_nxt
  end;
  USR_IDE_LOCATE := p
end USR_IDE_LOCATE;



function  LOOK_FOR_USR( id: ide_ptr ): usrf_ptr;
var
  r: usrf_ptr;

begin
  r := furf_hde;
  while r <> nil do
  begin
  exit if r^.usrf_iref = id;
    r := r^.usrf_nxt
  end;
  LOOK_FOR_USR := r
end LOOK_FOR_USR;



[global]
procedure USR_IDE_APPEND( p: ide_ptr );
var
  r: usrf_ptr;

begin
  if p <> nil then
  begin
    if LOOK_FOR_USR( p ) = nil then             { it is not already in the list }
    begin
      NEW( r );
      r^.usrf_iref :=   p;
      r^.usrf_nxt  := nil;
      if furf_hde <> nil then
      begin
        furf_lst^.usrf_nxt :=        r;
        r^.usrf_prv        := furf_lst
      end
      else
      begin                                     { The first ion last has prlnk -> on itself to flag it }
        furf_hde    :=   r;
        r^.usrf_prv := nil
      end;
      furf_lst := r
    end
  end
end USR_IDE_APPEND;



[global]
procedure USR_IDE_REMOVE( p: ide_ptr );
var
  r: usrf_ptr;

begin
  if p <> nil then
  begin
    r := LOOK_FOR_USR( p );
    if r <> nil then
    with r^ do
    begin { It is really in the list }
      { Adjust the next pointer string }
      if usrf_prv = nil then furf_hde := usrf_nxt
                        else usrf_prv^.usrf_nxt := usrf_nxt;
      if usrf_nxt = nil then furf_lst := usrf_prv
                        else usrf_nxt^.usrf_prv := usrf_prv;
      DISPOSE( r )
    end
  end
end USR_IDE_REMOVE;



{ Special Definitions for PATH Variable Access (too long for normal string) }
{ Used to replace a longand dynamic string management }
[global]
function  USR_GETPATH( sp: char; in_var st: string; var tbrf: val_ast ): integer;
const
  mxseptb = 256;

type
  buffer_typ  = packed array[word_unsigned] of char;

  buf_ptr = ^buffer_typ;

var
  bf: buf_ptr;
  ie, ip, ist, isz, len: integer;
  ch: char;
  tp: array[1..mxseptb] of byte;
  sb: string( 255 );
  bsov: boolean;

  function  GET_ENV_ARRAY( var ptr: buf_ptr; in_var src: string ): integer;
  external 'PAS__GET_ENV_ARRAY';


begin { USR_GETPATH }
  isz := GET_ENV_ARRAY( bf, st );
  if isz > 0 then
  with tbrf do
  begin
    ist := 0;
    ip  := 0;
    len := 0;
    bsov := false;
    while (ip < isz) and (ist < tbrf.val_all) do
    begin
      ch := bf^[ip];
      len := len + 1;
      ip  := ip  + 1;
      sb[len] := ch;
      if (ch = sp) or (len = sb.capacity) or (ip = isz) then
      begin
        sb.length := len;
        ist := ist + 1;
        if val_stb[ist] <> nil then DISPOSE( val_stb[ist] );
        NEW( val_stb[ist], sb.length );
        val_stb[ist]^ := sb;
        sb.length := 0; len := 0;
        if (ch <> sp) and (ip <> isz) then bsov := true
      end
    end;
    if (ist = val_all) and (ip < isz) then ist := val_all + 1
    else
      for ii := ist + 1 to val_all do
        if val_stb[ii] <> nil then DISPOSE( val_stb[ii] )
  end
  else ist := -1;
  if bsov then ist := -ist;
  USR_GETPATH := ist
end USR_GETPATH;



[global]
function  USR_SETPATH( in_var st: string; ist: integer; var tbrf: val_ast ): integer;
const
  mxsz = 16384;

type
  chtb = array[1..mxsz] of char;

var
  bf:            ^chtb;
  ie, ip, isz: integer;

  function  SET_ENV_ARRAY( in_var log: string;
                              var val: array[dim: integer] of char; sz, ovr: integer ): integer;
  external 'PAS__SET_ENV_ARRAY';

begin
  NEW( bf );
  with tbrf do
  begin
    ip := 0;
    if (ist < 1) or (ist >= val_all) then ist := val_all;
    for ii := 1 to val_all do
    begin
      if val_stb[ii] <> nil then
        with val_stb[ii]^ do
          for jj := 1 to length do
            if ip < mxsz then
            begin  ip := ip + 1; bf^[ip] := body[jj]  end
    end;
    if ip < mxsz then
    begin
    { ip := ip + 1; bf^[ip] := CHR( 0 );        { Append a null character to the end of new path }
      ie := SET_ENV_ARRAY( st, bf^, ip, 1 )     { Always allow to supershed }
    end
    else ie := -99
  end;
  DISPOSE( bf );
  USR_SETPATH := ie;
end USR_SETPATH;



[global]
procedure USR_IDE_SUBSTITUTE( in_var src: string; var dst: string; ch: char );
var
  ip: ide_ptr;
  i, j, k, ls, ld: integer;
  c1, c2, cc: char;
  bf: boolean;
  sna: [static] string(255);

begin
  bf := false;
  ld := dst.capacity;
  ls := src.length;
  i  := 1;
  j  := 0;
  loop
  exit if i > ls;
    c1 := src[i]; i := i + 1;
    if not bf then
      if c1 = ch then
      begin { the flag character is found }
        if i > ls then c2 := ch
                  else c2 := src[i];
        if c2 <> ch then
        begin  { Active the substitution mode }
          k := 0;
          bf := true
        end
        else
        begin { ch is managed as a normal character }
          i := i + 1;
          if j < ld then begin j := j + 1; dst[j] := c1 end
        end
      end
      else
      begin { Normal character }
        if j < ld then begin j := j + 1; dst[j] := c1 end
      end
    else
    begin { Get identifier name mode }
      if c1 = ch then
      begin
        bf := false;
        sna.length := k;
        ip := USR_IDE_LOCATE( sna );
        if ip <> nil then
        with ip^, idev_val do
        begin
          case val_frm of
            vfrm_str: if str <> nil then sna := str^
                                    else sna.length := 0;
            vfrm_int: WRITEV( sna, int:0 );
            vfrm_flt: WRITEV( sna, flt );
          otherwise
          end;
          for k := 1 to sna.length do
            if j < ld then begin j := j + 1; dst[j] := sna[k] end
        end
      end
      else
        if k < sna.capacity then begin k := k + 1; sna[k] := c1 end
    end
  end;
  dst.length := j
end USR_IDE_SUBSTITUTE;


[global]
procedure USR_S_ELEMENT(    var dst:  string;   { The extracted element string }
                         in_var src:  string;   { The string }
                                iel: integer;   { The element number starting from 0 }
                                csp,            { The separator character }
                                cst: char;      { The string character (or space) }
                                bss: boolean := false );{ the string expanding flag }
var
  b_s, e_s, b_e, e_e, i, j, ls, ld: integer;
  cc, cf: char;
  bst, bel: boolean;

begin
  ls  := src.length;
  ld  := dst.capacity;
  bel := false;
  bst := false;
  i   := 1;
  b_e := 0; b_s := 0;
  e_e := 0; e_s := 0;
  if csp < ' ' then csp := ' ';
  if cst < ' ' then cst := ' ';
  if cst = csp then cst := ' ';

  while (i <= ls) and (iel >= 0) do
  begin
    cc := src[i]; if cc < ' ' then cc := ' ';
    if cst > ' ' then                           { The string separator is defined }
      if bst then
      begin                                     { We are in a string }
        if cc = cst then
        begin                                   { We have a string initiator character }
          if i <= ls then cf := src[i+1]
                     else cf := cst;
          if cc = cf then i := i + 1            { We skip the string initiator inside the string }
                     else begin  bst := false; e_s := i  end    { End of string }
        end
      end
      else                                      { We are not in a string but we can enter in a string now }
        if cc = cst then                        { We have find a string begining }
        begin
          if not bel then begin  bel := true; b_e := i  end;
          b_s := i; bst := true
        end;

    if not bst then                             { We are not in a string }
      if bel then
      begin                                     { We are in an element }
        if cc = csp then
        begin  bel := false; e_e := i - 1; iel := iel - 1  end
      end
      else
      begin                                     { We are not in an element but we can enter in now }
        if cc <> csp then                       { We have find the begin of an element }
        begin  bel := true; b_e := i  end
        else
        begin                                   { We have an empty element when the separator is not a space }
          if (csp <> ' ') and (cc = csp) then
          begin  b_e := i; e_e := i - 1; iel := iel - 1  end
        end
      end;
    i := i + 1;
  end;
  if bel then                                   { Unterminated element on end of string }
  begin  e_e := ls; bel := false; iel := iel - 1  end;

  j := 0;
  if iel < 0 then
  begin                                         { We have found the desired element }
    { Now we can load the element in the destination string }
    bst := false;
    if bss then
      for k := b_e to e_e do
      begin
        if j < ld then begin  j := j + 1; dst[j] := src[k]  end
      end
    else
    begin
      bel := false;
      for k := b_e to e_e do
      begin
        cc := src[k];
        if (cc = cst) and (cst <> ' ') then
          if bst then
          begin  bel := true; bst := false  end
          else
          begin
            if bel then
            begin
              bel := false;
              if j < ld then begin  j := j + 1; dst[j] := cc  end
            end;
            bst := true
          end
        else
        begin
          bel := false;
          if j < ld then begin  j := j + 1; dst[j] := cc  end
        end
      end
    end
  end;
  dst.length := j
end USR_S_ELEMENT;




[global]
procedure USR_SUPPRESS_COMMENT( in_var src: string; var dst: string; cc, cs: char );
var
  bst: boolean;
  ii, jj, sz: integer;
  ch: char;

begin
  if cc <= ' ' then cc := '!';
  if cs = cc then cs := '"';
  if cs <= ' ' then
  begin
    ii := INDEX( src, cc );
    if ii = 0 then dst := src
              else dst := SUBSTR( src, 1, ii - 1 )
  end
  else
  begin
    bst := false;
    sz  := dst.capacity;
    if sz > src.length then sz := src.length;
    ii  := 0; jj := 0;
    while (ii < sz) do
    begin
      ii := ii + 1;
      ch := src[ii];
      if ch = cs then bst := not bst;
    exit if (not bst) and (ch = cc);
      jj := jj + 1;
      dst[jj] := ch;
    end;
    dst.length := jj
  end
end USR_SUPPRESS_COMMENT;



[global]
function  USR_NUMERIC_STRING( in_var str: string ): boolean;
type
  mdtyp = ( mdspace, mdsign, mdent, mdfrac, mdsexp, mdexp );

var
  ip: integer;
  br: boolean;
  md:   mdtyp;
  ch:    char;

begin
  md := mdspace;
  ip := 1;
  while (md <= mdspace) and (ip <= str.length) do
  begin
    ch := str[ip];
    case ch of
      SOH..' ':
        exit if md > mdspace;                   { Stop on space }

      '+', '-':
        case md of
          mdspace: md := mdsign;
          mdsexp:  md := mdexp;
        otherwise
          exit
        end;

      '0'..'9':
        case md of
          mdspace, mdsign, mdent:
            if md < mdent then md := mdent;
          mdsexp, mdexp:
            if md < mdexp then md := mdexp;
        otherwise
        end;

      '.':
        if md < mdfrac then md := mdfrac
                       else exit;

      'e', 'E', 'd', 'D':
        if md < mdsexp then md := mdsexp
                       else exit;

    otherwise
      exit if md > mdspace;
    end;
    ip := ip + 1                                { Skip to next character }
  end { while };
  case md of
    mdent, mdfrac, mdexp:
      USR_NUMERIC_STRING := true;
  otherwise
    USR_NUMERIC_STRING := false
  end
end USR_NUMERIC_STRING;


end MXD_DCP_RTL.
