/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 680 ) = {
 17,  17, 108, 105, 115, 116, 105, 110, 103,  95, 115, 101, 116,  95, 116, 105,
116, 108, 101,  54,  54,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101,
114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116,
115,  47,  77,  88,  68,  86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95,
100,  99, 112,  95, 114, 116, 108,  46, 112,  97, 115,  30,  30,  32,  84, 104,
101,  32,  67, 117, 114, 114, 101, 110, 116,  32,  67, 111, 109, 109,  97, 110,
100,  32,  70, 105, 108, 101,  32, 105, 115,  32,  34,   2,   2,  34,  46,  14,
 14, 105, 110, 115, 101, 114, 116,  95, 109, 101, 115, 115,  97, 103, 101,  17,
 17, 108, 105, 115, 116, 105, 110, 103,  95, 115, 101, 116,  95, 115,  98, 116,
116, 108,  14,  14,  32,  42,  42,  42,  32,  84,  82,  65,  67,  73,  78,  71,
 32,  34,   3,   3,  34,  32,  58,  11,  11, 115, 114,  99,  95, 101, 114, 114,
111, 114,  95, 115,  14,  14,  99, 104, 101,  99, 107,  95, 115, 121, 109,  98,
 95, 101, 114, 114,  11,  11, 115, 101,  97, 114,  99, 104,  95, 102, 105, 108,
101,  22,  22, 105, 100, 101,  95, 115, 101,  97, 114,  99, 104,  95, 102, 114,
111, 109,  95, 110,  97, 109, 101, 105, 100,  11,  11, 100, 105, 115, 112, 108,
 97, 121,  95, 110, 101, 119,   4,   4,  68,  73,  83,  78,  16,  16, 102, 114,
101, 101,  95, 116, 121, 112, 101,  95, 114, 101,  99, 111, 114, 100,  19,  19,
102, 114, 101, 101,  95, 118,  97, 108,  95,  97, 108, 108, 111,  99,  97, 116,
105, 111, 110,  12,  12, 100, 105, 115, 112, 108,  97, 121,  95, 102, 114, 101,
101,   4,   4,  68,  73,  83,  70,   7,   7, 116, 121, 112,  95, 110, 101, 119,
 13,  13, 103, 101, 116,  95, 118,  97, 108,  95, 102, 111, 114, 109, 115,   7,
  7, 105, 100, 101,  95, 110, 101, 119,   4,   4,  78,  69,  87,  73,  12,  12,
108, 101, 118, 101, 108,  95, 115, 101,  97, 114,  99, 104,  10,  10, 105, 100,
101,  95, 115, 101,  97, 114,  99, 104,   4,   4,  73,  68,  83,  69,  12,  12,
118,  97, 108,  95,  97, 108, 108, 111,  99,  97, 116, 101,  12,  12, 118,  97,
114,  95,  97, 108, 108, 111,  99,  97, 116, 101,  11,  11,  99, 111, 112, 121,
 95, 115, 116, 114, 105, 110, 103,  10,  10, 118,  97, 108, 117, 101,  95,  99,
111, 112, 121,   7,   7, 118,  97, 114,  95, 110, 101, 119,   4,   4,  86,  65,
 82,  78,  16,  16, 117, 115, 114,  95, 101, 108, 116,  97,  98,  95, 115,  99,
105, 110, 105, 116,  10,  10, 105, 110, 100, 101, 120,  95, 115,  99,  97, 110,
 14,  14, 117, 115, 114,  95, 101, 108, 116,  97,  98,  95, 115,  99,  97, 110,
 15,  15, 117, 115, 114,  95, 101, 108, 116,  97,  98,  95, 115,  99, 101, 110,
100,  14,  14, 117, 115, 114,  95, 105, 100, 101,  95, 108, 111,  99,  97, 116,
101,  12,  12, 108, 111, 111, 107,  95, 102, 111, 114,  95, 117, 115, 114,  14,
 14, 117, 115, 114,  95, 105, 100, 101,  95,  97, 112, 112, 101, 110, 100,  14,
 14, 117, 115, 114,  95, 105, 100, 101,  95, 114, 101, 109, 111, 118, 101,  11,
 11, 117, 115, 114,  95, 103, 101, 116, 112,  97, 116, 104,  11,  11, 117, 115,
114,  95, 115, 101, 116, 112,  97, 116, 104,  18,  18, 117, 115, 114,  95, 105,
100, 101,  95, 115, 117,  98, 115, 116, 105, 116, 117, 116, 101,  13,  13, 117,
115, 114,  95, 115,  95, 101, 108, 101, 109, 101, 110, 116,  20,  20, 117, 115,
114,  95, 115, 117, 112, 112, 114, 101, 115, 115,  95,  99, 111, 109, 109, 101,
110, 116,  18,  18, 117, 115, 114,  95, 110, 117, 109, 101, 114, 105,  99,  95,
115, 116, 114, 105, 110, 103,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V V_src_control;
extern V V_lst_current;
extern V PAS__f_output;
extern Blk(V_sy_sym, 8 );
extern V V_curr_ide;
extern SL V_curr_disp;
extern Blk(V_disp_tab, 1560 );
extern SL V_curr_lex;
extern Blk(V_mop_tab, 176 );
extern Blk(V_sy_ident, 64 );
extern V V_sy_idenew;
extern SL V_curr_idisp;
extern V V_udc_ident;
extern V V_furf_hde;
extern V V_furf_lst;


/* Function/procedure prototypes. */
void P_lst_change_title(V F_str, UB F_bskp);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_put_symbol(V F_symb, SL F_len);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
V P_ide_search(UB F_berr, UB F_cls);
void P_skip_symbol(UB F_tosymbol);
void PAS__BACK_TRACING(V *F_f);
SL PAS__GET_ENV_ARRAY(V *F_ptr, V F_src);
SL PAS__SET_ENV_ARRAY(V F_log, V F_val, SL F_dim, SL F_sz, SL F_ovr);


/* Procedure/Function : " listing_set_title "  */
void P_listing_set_title(){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );


  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+19;
  Ra.sl[68]=155; /* line # 155 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_STR(Rd.s+75,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+276,((V *)V_src_control)[57]),-1,-1,32);
  PAS__WRITE_STR(Rd.s+107,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[68]=156; /* line # 156 */
  P_lst_change_title(Ra.s,1);
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " insert_message "  */
void P_insert_message(V F_msg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=164; /* line # 164 */
  P_lst_newline();
  Ra.sl[3]=165; /* line # 165 */
  P_lst_put_string(F_msg);
  Ra.sl[3]=166; /* line # 166 */
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " listing_set_sbttl "  */
void P_listing_set_sbttl(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+127;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=178; /* line # 178 */
  Rv0=V_lst_current;
  Ra.sl[3]=180; /* line # 180 */
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  Ra.sl[3]=181; /* line # 181 */
  ((V *)Rv0)[5]=NULL;
  Ra.sl[3]=182; /* line # 182 */
  if (F_str!=NULL) {
    Ra.sl[3]=183; /* line # 183 */
    if (((UB *)F_str)[1]>0) {
      Ra.sl[3]=185; /* line # 185 */
      Rv1=((UB *)F_str)[1];
      ((V *)Rv0)[5]=PAS__NEW((SL)Rv1+2);
      ((UB *)((V *)Rv0)[5])[0]=Rv1;
      Ra.sl[3]=186; /* line # 186 */
      PAS__STR_TO_STR(((V *)Rv0)[5],F_str);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " trace "  */
void P_trace(V F_s){

  /* Code of procedure/function */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+146,-1,-1,32);
  PAS__WRITE_STR(F_s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+162,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__BACK_TRACING(&PAS__f_output);
}


/* Procedure/Function : " src_error_s "  */
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+52,F_modulesy,4);
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+167;
  Ra.v[11]=Rd.s+19;
  Ra.sl[12]=226; /* line # 226 */
  if (F_id1!=NULL) {
    Ra.sl[12]=227; /* line # 227 */
    Ra.sl[12]=229; /* line # 229 */
    Ra.ub[1]=((UB *)F_id1)[1];
    Ra.sl[12]=230; /* line # 230 */
    Rv0=1;
    for( Rf0=((UB *)F_id1)[1];Rf0>0;Rf0-- ) {
      Ra.c[Rv0+1]=((C *)F_id1)[Rv0+1];
      Rv0++;
    }
    Ra.sl[12]=231; /* line # 231 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[12]=233; /* line # 233 */
  if (F_id2!=NULL) {
    Ra.sl[12]=234; /* line # 234 */
    Ra.sl[12]=236; /* line # 236 */
    Ra.ub[1]=((UB *)F_id2)[1];
    Ra.sl[12]=237; /* line # 237 */
    Rv1=1;
    for( Rf0=((UB *)F_id2)[1];Rf0>0;Rf0-- ) {
      Ra.c[Rv1+1]=((C *)F_id2)[Rv1+1];
      Rv1++;
    }
    Ra.sl[12]=238; /* line # 238 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[12]=240; /* line # 240 */
  P_src_error(Ra.s+52,F_number, F_severity);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " check_symb_err "  */
UB P_check_symb_err(V F_mdnam, UB F_exsy, SL F_nerr, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  register UB Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_mdnam,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+180;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=248; /* line # 248 */
  if (V_sy_sym.ub[0]!=F_exsy) {
    Ra.sl[3]=250; /* line # 250 */
    if (F_id!=NULL) P_src_error_s(Ra.s+16,F_nerr,3, F_id,NULL);
    else {
      Ra.sl[3]=251; /* line # 251 */
      P_src_error(Ra.s+16,F_nerr,3);
    }
    Ra.sl[3]=252; /* line # 252 */
    P_skip_symbol(18);
    Ra.sl[3]=253; /* line # 253 */
    Ret=1;
  }
  else {
    Ra.sl[3]=255; /* line # 255 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " search_file "  */
void P_search_file(V F_path, V F_fname, SL F_acc, V F_re, UB *F_fnd){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+196;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=274; /* line # 274 */
  (*F_fnd)=PAS__FILE_ACCESS(F_fname,F_acc,0);
  Ra.sl[3]=275; /* line # 275 */
  if ((*F_fnd)) PAS__STR_TO_STR(F_re,F_fname);
  else {
    Ra.sl[3]=278; /* line # 278 */
    Rv0=1;
    Rv1=1;
    Ra.sl[3]=279; /* line # 279 */
    while (Rv0<=((UB *)F_path)[1]&&!(*F_fnd)){
      Ra.sl[3]=281; /* line # 281 */
      Rv2=PAS__NINDEX_CHA(F_path+2,(SL)((UB *)F_path)[1],44, Rv1,-1,1);
      Ra.sl[3]=282; /* line # 282 */
      if (Rv2==0) Rv2=((UB *)F_path)[1]+1;
      Ra.sl[3]=283; /* line # 283 */
      PAS__STR_TO_STR(F_re,PAS__CON_STR_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+16,F_path,
      Rv0, Rv2-Rv0), F_fname));
      Ra.sl[3]=284; /* line # 284 */
      Rv0=Rv2+1;
      Rv1=Rv1+1;
      Ra.sl[3]=285; /* line # 285 */
      (*F_fnd)=PAS__FILE_ACCESS(F_re,F_acc,0);
    }
    Ra.sl[3]=287; /* line # 287 */
    if (!(*F_fnd)) ((UB *)F_re)[1]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search_from_nameid "  */
V P_ide_search_from_nameid(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+209;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=305; /* line # 305 */
  Rv0=NULL;
  Ra.sl[3]=306; /* line # 306 */
  if (F_ip!=NULL) {
    Ra.sl[3]=308; /* line # 308 */
    V_curr_ide=F_ip;
    Ra.sl[3]=309; /* line # 309 */
    Rv0=P_ide_search(1,0);
    Ra.sl[3]=310; /* line # 310 */
    V_curr_ide=NULL;
  }
  Ra.sl[3]=312; /* line # 312 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " display_new "  */
void P_display_new(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+233;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=326; /* line # 326 */
  if (V_curr_disp>=64) P_src_error(Rd.s+248,4,3);
  else {
    Ra.sl[3]=329; /* line # 329 */
    V_curr_disp=V_curr_disp+1;
    Ra.sl[3]=330; /* line # 330 */
    Rv0=(V_disp_tab.s+V_curr_disp*24);
    Ra.sl[3]=332; /* line # 332 */
    ((SL *)Rv0)[0]=V_curr_lex;
    Ra.sl[3]=333; /* line # 333 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[3]=334; /* line # 334 */
    ((V *)Rv0)[2]=NULL;
    Ra.sl[3]=335; /* line # 335 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[3]=336; /* line # 336 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[3]=337; /* line # 337 */
    ((V *)Rv0)[5]=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_type_record "  */
void MXD_DCP_RTL_free_type_record(V F_typ, SL F_dspl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+252;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=350; /* line # 350 */
  if (F_typ!=NULL) {
    Ra.sl[3]=351; /* line # 351 */
    if (((UB *)F_typ)[16]==F_dspl) {
      Ra.sl[3]=353; /* line # 353 */
      Rv0=F_typ;
      Ra.sl[3]=354; /* line # 354 */
      switch (((UB *)Rv0)[24]) {
        case 3:Ra.sl[3]=356; /* line # 356 */
        MXD_DCP_RTL_free_type_record(((V *)Rv0)[7],F_dspl);
        break;
        case 6:Ra.sl[3]=360; /* line # 360 */
        if (((V *)Rv0)[8]!=NULL) {
          Ra.sl[3]=361; /* line # 361 */
          while (((V *)Rv0)[7]!=NULL){
            Ra.sl[3]=363; /* line # 363 */
            Rv1=((V *)Rv0)[7];
            Ra.sl[3]=364; /* line # 364 */
            ((V *)Rv0)[7]=((V *)Rv1)[1];
            Ra.sl[3]=365; /* line # 365 */
            PAS__DISPOSE(&Rv1);
          }
        }
        Ra.sl[3]=368; /* line # 368 */
        while (((V *)Rv0)[9]!=NULL){
          Ra.sl[3]=370; /* line # 370 */
          Rv2=((V *)Rv0)[9];
          Ra.sl[3]=371; /* line # 371 */
          ((V *)Rv0)[9]=((V *)Rv2)[2];
          Ra.sl[3]=372; /* line # 372 */
          PAS__DISPOSE(&Rv2);
        }
        break;
        default:break;
      }
      Ra.sl[3]=378; /* line # 378 */
      PAS__DISPOSE(&F_typ);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_val_allocation "  */
void P_free_val_allocation(V F_val){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+270;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=387; /* line # 387 */
  Ra.sl[3]=389; /* line # 389 */
  switch (((UB *)F_val)[1]) {
    case 0:Ra.sl[3]=390; /* line # 390 */
    PAS__DISPOSE(((V *)F_val)+1);
    break;
    case 6:Ra.sl[3]=392; /* line # 392 */
    Rv0=1;
    for( Rf0=((SL *)((V *)F_val)[1])[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=393; /* line # 393 */
      if (((V *)((V *)F_val)[1])[Rv0]!=NULL) {
        Ra.sl[3]=394; /* line # 394 */
        PAS__DISPOSE((((V *)((V *)F_val)[1])+Rv0));
      }
      Rv0++;
    }
    Ra.sl[3]=395; /* line # 395 */
    PAS__DISPOSE(((V *)F_val)+1);
    break;
    case 7:Ra.sl[3]=397; /* line # 397 */
    PAS__DISPOSE(((V *)F_val)+1);
    break;
    case 8:Ra.sl[3]=399; /* line # 399 */
    PAS__DISPOSE(((V *)F_val)+1);
    Ra.sl[3]=400; /* line # 400 */
    if (((V *)F_val)[2]!=NULL) PAS__DISPOSE(((V *)F_val)+2);
    break;
    default:break;
  }
  Ra.sl[3]=405; /* line # 405 */
  ((UB *)F_val)[1]=11;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " display_free "  */
void P_display_free(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+291;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=425; /* line # 425 */
  if (V_curr_disp<0) P_src_error(Rd.s+307,5,3);
  else {
    Ra.sl[3]=428; /* line # 428 */
    if (F_bfree) {
      Ra.sl[3]=429; /* line # 429 */
      Rv0=(V_disp_tab.s+V_curr_disp*24);
      Ra.sl[3]=431; /* line # 431 */
      while (((V *)Rv0)[5]!=NULL){
        Ra.sl[3]=433; /* line # 433 */
        Rv1=((V *)Rv0)[5];
        Ra.sl[3]=434; /* line # 434 */
        Rv2=Rv1;
        Ra.sl[3]=436; /* line # 436 */
        ((V *)Rv0)[5]=((V *)Rv2)[1];
        Ra.sl[3]=437; /* line # 437 */
        PAS__DISPOSE(((V *)Rv2));
        Ra.sl[3]=438; /* line # 438 */
        MXD_DCP_RTL_free_type_record(((V *)Rv2)[4],((UB *)Rv2)[24]);
        Ra.sl[3]=439; /* line # 439 */
        if (((UB *)Rv2)[25]==1) P_free_val_allocation(Rv2+40);
        Ra.sl[3]=441; /* line # 441 */
        PAS__DISPOSE(&Rv1);
      }
      Ra.sl[3]=444; /* line # 444 */
      while (((V *)Rv0)[2]!=NULL){
        Ra.sl[3]=446; /* line # 446 */
        Rv3=((V *)Rv0)[2];
        Ra.sl[3]=447; /* line # 447 */
        ((V *)Rv0)[2]=((V *)Rv3)[0];
        Ra.sl[3]=448; /* line # 448 */
        if (((UB *)Rv3)[12]==1) {
          Ra.sl[3]=449; /* line # 449 */
          Rv4=Rv3;
          Ra.sl[3]=452; /* line # 452 */
          if (((V *)Rv4)[1]!=NULL) {
            Ra.sl[3]=453; /* line # 453 */
            if (((UB *)((V *)Rv4)[1])[14]<V_curr_disp) {
              Ra.sl[3]=454; /* line # 454 */
              if (((UB *)Rv4)[15]==21) {
                Ra.sl[3]=455; /* line # 455 */
                ((V *)((V *)Rv4)[6])[8]=((V *)Rv4)[1];
              }
              else {
                Ra.sl[3]=457; /* line # 457 */
                V_mop_tab.v[((UB *)Rv4)[15]*2+1]=((V *)Rv4)[1];
              }
            }
          }
          Ra.sl[3]=462; /* line # 462 */
          PAS__DISPOSE(&Rv3);
        }
      }
    }
    Ra.sl[3]=466; /* line # 466 */
    V_curr_disp=V_curr_disp -1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typ_new "  */
V P_typ_new(UB F_frm, V F_ide, V F_pty, SL F_ilvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+311;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=478; /* line # 478 */
  if (F_ilvl<=0) F_ilvl=V_curr_disp;
  Ra.sl[3]=479; /* line # 479 */
  switch (F_frm) {
    case 3:Ra.sl[3]=480; /* line # 480 */
    Rv0=PAS__NEW(44);
    break;
    case 6:Ra.sl[3]=481; /* line # 481 */
    Rv0=PAS__NEW(57);
    break;
    default:Ra.sl[3]=483; /* line # 483 */
    Rv0=PAS__NEW(25);
    break;
  }
  Ra.sl[3]=485; /* line # 485 */
  Rv1=(V_disp_tab.s+F_ilvl*24);
  Rv2=Rv0;
  Ra.sl[3]=487; /* line # 487 */
  ((V *)Rv2)[0]=F_ide;
  Ra.sl[3]=488; /* line # 488 */
  ((V *)Rv2)[1]=((V *)Rv1)[3];
  ((V *)Rv1)[3]=Rv0;
  Ra.sl[3]=489; /* line # 489 */
  ((V *)Rv2)[2]=F_pty;
  Ra.sl[3]=490; /* line # 490 */
  ((SL *)Rv2)[3]=0;
  Ra.sl[3]=491; /* line # 491 */
  ((UL *)Rv2)[5]=0;
  Ra.sl[3]=492; /* line # 492 */
  ((UB *)Rv2)[16]=V_curr_disp;
  Ra.sl[3]=493; /* line # 493 */
  ((UB *)Rv2)[24]=F_frm;
  Ra.sl[3]=494; /* line # 494 */
  switch (F_frm) {
    case 3:Ra.sl[3]=497; /* line # 497 */
    ((V *)Rv2)[7]=NULL;
    Ra.sl[3]=498; /* line # 498 */
    ((SL *)Rv2)[8]=1;
    Ra.sl[3]=499; /* line # 499 */
    ((SL *)Rv2)[9]=1;
    Ra.sl[3]=500; /* line # 500 */
    ((SL *)Rv2)[10]=1;
    break;
    case 6:Ra.sl[3]=504; /* line # 504 */
    ((V *)Rv2)[7]=NULL;
    Ra.sl[3]=505; /* line # 505 */
    ((V *)Rv2)[8]=NULL;
    Ra.sl[3]=506; /* line # 506 */
    ((V *)Rv2)[9]=NULL;
    Ra.sl[3]=507; /* line # 507 */
    ((V *)Rv2)[10]=NULL;
    Ra.sl[3]=508; /* line # 508 */
    ((V *)Rv2)[11]=NULL;
    Ra.sl[3]=509; /* line # 509 */
    ((SL *)Rv2)[12]=0;
    Ra.sl[3]=510; /* line # 510 */
    ((UB *)Rv2)[52]=0;
    Ra.sl[3]=511; /* line # 511 */
    ((UB *)Rv2)[53]=0;
    Ra.sl[3]=512; /* line # 512 */
    ((UB *)Rv2)[54]=0;
    Ra.sl[3]=513; /* line # 513 */
    ((UB *)Rv2)[55]=0;
    Ra.sl[3]=514; /* line # 514 */
    ((UB *)Rv2)[56]=0;
    break;
    default:break;
  }
  Ra.sl[3]=519; /* line # 519 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_val_forms "  */
UB P_get_val_forms(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+320;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=530; /* line # 530 */
  if (F_ty!=NULL) {
    Ra.sl[3]=531; /* line # 531 */
    switch (((UB *)F_ty)[24]) {
      case 0:Ra.sl[3]=532; /* line # 532 */
      Ret=0;
      break;
      case 1:Ra.sl[3]=533; /* line # 533 */
      Ret=1;
      break;
      case 2:Ra.sl[3]=534; /* line # 534 */
      Ret=2;
      break;
      case 3:Ra.sl[3]=536; /* line # 536 */
      Rv0=P_get_val_forms(((V *)F_ty)[7]);
      Ra.sl[3]=537; /* line # 537 */
      switch (Rv0) {
        case 0:Ra.sl[3]=538; /* line # 538 */
        Ret=6;
        break;
        case 1:Ra.sl[3]=539; /* line # 539 */
        Ret=7;
        break;
        case 2:Ra.sl[3]=540; /* line # 540 */
        Ret=8;
        break;
        default:Ra.sl[3]=542; /* line # 542 */
        Ret=Rv0;
        break;
      }
      break;
      case 5:
      case 6:Ra.sl[3]=546; /* line # 546 */
      Ret=9;
      break;
      default:Ra.sl[3]=548; /* line # 548 */
      Ret=11;
      break;
    }
  }
  else {
    Ra.sl[3]=550; /* line # 550 */
    Ret=11;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_new "  */
V P_ide_new(UB F_cla, V F_typ, SL F_ilvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register UB Rv9;
  SL Rv10;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+335;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=571; /* line # 571 */
  if (F_ilvl<=0) F_ilvl=V_curr_disp;
  Ra.sl[3]=572; /* line # 572 */
  Rv0=0;
  Ra.sl[3]=574; /* line # 574 */
  Rv1=(V_disp_tab.s+F_ilvl*24);
  Ra.sl[3]=576; /* line # 576 */
  Rv2=((V *)Rv1)[5];
  Ra.sl[3]=577; /* line # 577 */
  Rv3=NULL;
  Ra.sl[3]=578; /* line # 578 */
  if (Rv2!=NULL) while (1){
    Ra.sl[3]=580; /* line # 580 */
    Rv3=Rv2;
    Ra.sl[3]=581; /* line # 581 */
    Rv4=Rv2;
    Ra.sl[3]=583; /* line # 583 */
    Rv5=PAS__MATCH_STR(((V *)Rv4)[0],V_sy_ident.s);
    Ra.sl[3]=584; /* line # 584 */
    if (Rv5==0) Rv0=1;
    else {
      Ra.sl[3]=585; /* line # 585 */
      if (Rv5<0) {
        Ra.sl[3]=586; /* line # 586 */
        Rv2=((V *)Rv2)[3];
        Rv6=0;
      }
      else {
        Ra.sl[3]=589; /* line # 589 */
        Rv2=((V *)Rv2)[2];
        Rv6=1;
      }
    }
    if (Rv2==NULL||Rv0)  break;
  }
  Ra.sl[3]=596; /* line # 596 */
  if (Rv0) {
    Ra.sl[3]=598; /* line # 598 */
    P_src_error_s(Rd.s+346,101,2, V_sy_ident.s,NULL);
    Rv7=Rv2;
  }
  else {
    Ra.sl[3]=602; /* line # 602 */
    switch (F_cla) {
      case 0:Ra.sl[3]=603; /* line # 603 */
      Rv7=PAS__NEW(26);
      break;
      case 3:Ra.sl[3]=604; /* line # 604 */
      Rv7=PAS__NEW(36);
      break;
      case 2:Ra.sl[3]=605; /* line # 605 */
      Rv7=PAS__NEW(36);
      break;
      case 1:Ra.sl[3]=606; /* line # 606 */
      Rv7=PAS__NEW(64);
      break;
      case 4:Ra.sl[3]=607; /* line # 607 */
      Rv7=PAS__NEW(34);
      break;
      case 5:
      case 6:Ra.sl[3]=609; /* line # 609 */
      Rv7=PAS__NEW(36);
      break;
      case 7:Ra.sl[3]=610; /* line # 610 */
      Rv7=PAS__NEW(64);
      break;
      default:break;
    }
    Ra.sl[3]=613; /* line # 613 */
    Rv8=Rv7;
    Ra.sl[3]=615; /* line # 615 */
    ((V *)Rv8)[0]=NULL;
    Ra.sl[3]=616; /* line # 616 */
    Rv9=V_sy_ident.ub[1];
    ((V *)Rv8)[0]=PAS__NEW((SL)Rv9+2);
    ((UB *)((V *)Rv8)[0])[0]=Rv9;
    PAS__STR_TO_STR(((V *)Rv8)[0],V_sy_ident.s);
    Ra.sl[3]=617; /* line # 617 */
    ((V *)Rv8)[1]=((V *)Rv1)[4];
    ((V *)Rv1)[4]=Rv7;
    Ra.sl[3]=618; /* line # 618 */
    ((V *)Rv8)[2]=NULL;
    Ra.sl[3]=619; /* line # 619 */
    ((V *)Rv8)[3]=NULL;
    Ra.sl[3]=620; /* line # 620 */
    ((V *)Rv8)[4]=F_typ;
    Ra.sl[3]=621; /* line # 621 */
    if (F_typ!=NULL) ((UL *)Rv8)[5]=((UL *)F_typ)[5];
    else {
      Ra.sl[3]=622; /* line # 622 */
      ((UL *)Rv8)[5]=0;
    }
    Ra.sl[3]=623; /* line # 623 */
    ((UB *)Rv8)[24]=F_ilvl;
    Ra.sl[3]=624; /* line # 624 */
    ((UB *)Rv8)[25]=F_cla;
    Ra.sl[3]=627; /* line # 627 */
    switch (((UB *)Rv8)[25]) {
      case 3:Ra.sl[3]=630; /* line # 630 */
      ((UB *)Rv8)[26]=0;
      Ra.sl[3]=631; /* line # 631 */
      ((UB *)Rv8)[27]=0;
      Ra.sl[3]=632; /* line # 632 */
      ((SL *)Rv8)[7]=0;
      Ra.sl[3]=633; /* line # 633 */
      ((SL *)Rv8)[8]=0;
      break;
      case 2:Ra.sl[3]=637; /* line # 637 */
      ((UB *)Rv8)[26]=0;
      Ra.sl[3]=638; /* line # 638 */
      ((SL *)Rv8)[7]=0;
      Ra.sl[3]=639; /* line # 639 */
      ((SL *)Rv8)[8]=0;
      break;
      case 1:Ra.sl[3]=643; /* line # 643 */
      if (F_typ!=NULL) ((SL *)Rv8)[7]=((SL *)F_typ)[3];
      else {
        Ra.sl[3]=644; /* line # 644 */
        ((SL *)Rv8)[7]=0;
      }
      Ra.sl[3]=645; /* line # 645 */
      ((SL *)Rv8)[8]=0;
      Ra.sl[3]=646; /* line # 646 */
      if (F_typ!=NULL) ((UB *)Rv8)[41]=P_get_val_forms(F_typ);
      else {
        Ra.sl[3]=647; /* line # 647 */
        ((UB *)Rv8)[41]=11;
      }
      break;
      case 4:Ra.sl[3]=651; /* line # 651 */
      ((SL *)Rv8)[7]=-1;
      Ra.sl[3]=652; /* line # 652 */
      ((UB *)Rv8)[32]=0;
      Ra.sl[3]=653; /* line # 653 */
      ((UB *)Rv8)[33]=0;
      break;
      case 5:
      case 6:Ra.sl[3]=658; /* line # 658 */
      ((V *)Rv8)[7]=NULL;
      Ra.sl[3]=659; /* line # 659 */
      ((V *)Rv8)[8]=NULL;
      break;
      case 7:Ra.sl[3]=663; /* line # 663 */
      ((V *)Rv8)[7]=NULL;
      Ra.sl[3]=664; /* line # 664 */
      ((SL *)Rv8)[8]=0;
      Ra.sl[3]=665; /* line # 665 */
      Rv10=1;
      for( Rf0=5;Rf0>0;Rf0-- ) {
        Ra.sl[3]=666; /* line # 666 */
        ((V *)Rv8)[Rv10+8]=NULL;
        ((UB *)Rv8)[Rv10+55]=0;
        Rv10++;
      }
      Ra.sl[3]=667; /* line # 667 */
      ((UB *)Rv8)[61]=0;
      Ra.sl[3]=668; /* line # 668 */
      ((UB *)Rv8)[62]=0;
      Ra.sl[3]=669; /* line # 669 */
      ((UB *)Rv8)[63]=0;
      break;
      default:break;
    }
    Ra.sl[3]=675; /* line # 675 */
    if (Rv3==NULL) ((V *)Rv1)[5]=Rv7;
    else {
      Ra.sl[3]=676; /* line # 676 */
      if (Rv6) ((V *)Rv3)[2]=Rv7;
      else {
        Ra.sl[3]=677; /* line # 677 */
        ((V *)Rv3)[3]=Rv7;
      }
    }
  }
  Ra.sl[3]=680; /* line # 680 */
  V_sy_idenew=Rv7;
  Ra.sl[3]=681; /* line # 681 */
  Ret=Rv7;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " level_search "  */
V P_level_search(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+350;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=697; /* line # 697 */
  Rv0=F_fp;
  Ra.sl[3]=698; /* line # 698 */
  Rv1=0;
  Ra.sl[3]=699; /* line # 699 */
  while (!Rv1&&Rv0!=NULL){
    Ra.sl[3]=700; /* line # 700 */
    Rv2=Rv0;
    Ra.sl[3]=702; /* line # 702 */
    if (Rs.v[0]==NULL) Rv3=PAS__MATCH_STR(((V *)Rv2)[0],V_sy_ident.s);
    else {
      Ra.sl[3]=703; /* line # 703 */
      Rv3=PAS__MATCH_STR(((V *)Rv2)[0],Rs.v[0]);
    }
    Ra.sl[3]=704; /* line # 704 */
    if (Rv3==0) Rv1=1;
    else {
      Ra.sl[3]=705; /* line # 705 */
      if (Rv3>0) Rv0=((V *)Rv0)[2];
      else {
        Ra.sl[3]=706; /* line # 706 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  Ra.sl[3]=708; /* line # 708 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_search "  */
V P_ide_search(UB F_berr, UB F_cls){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+364;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=729; /* line # 729 */
  V_curr_idisp=V_curr_disp;
  while (1){
    Ra.sl[3]=731; /* line # 731 */
    Rv0=P_level_search(V_disp_tab.v[V_curr_idisp*6+5]);
    Ra.sl[3]=732; /* line # 732 */
    if (Rv0==NULL) V_curr_idisp=V_curr_idisp -1;
    if (Rv0!=NULL||V_curr_idisp<0)  break;
  }
  Ra.sl[3]=735; /* line # 735 */
  if (F_berr&&Rv0==NULL) {
    Ra.sl[3]=737; /* line # 737 */
    P_src_error_s(Rd.s+378,104,3, V_sy_ident.s,NULL);
    Ra.sl[3]=738; /* line # 738 */
    Rv0=V_udc_ident;
  }
  Ra.sl[3]=740; /* line # 740 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " val_allocate "  */
void P_val_allocate(V F_val, V F_typ){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register SL Rv1;
  register V Rv2;
  SL Rv3;
  register SL Rv4;
  register V Rv5;
  SL Rv6;
  register SL Rv7;
  register V Rv8;
  SL Rv9;
  register SL Rv10;
  register V Rv11;
  SL Rv12;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+382;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=751; /* line # 751 */
  if (F_typ!=NULL) {
    Ra.sl[3]=752; /* line # 752 */
    Rv0=F_typ;
    Ra.sl[3]=753; /* line # 753 */
    if (!(1024&((UL *)Rv0)[5])) {
      Ra.sl[3]=755; /* line # 755 */
      ((UB *)F_val)[0]=0;
      Ra.sl[3]=756; /* line # 756 */
      ((UB *)F_val)[1]=P_get_val_forms(F_typ);
      Ra.sl[3]=757; /* line # 757 */
      switch (((UB *)F_val)[1]) {
        case 0:Ra.sl[3]=758; /* line # 758 */
        ((V *)F_val)[1]=NULL;
        break;
        case 1:Ra.sl[3]=759; /* line # 759 */
        ((SL *)F_val)[1]=0;
        break;
        case 2:Ra.sl[3]=760; /* line # 760 */
        ((G *)F_val)[1]=0.000000000000000E-001;
        ((G *)F_val)[2]=0.000000000000000E-001;
        break;
        case 6:Ra.sl[3]=762; /* line # 762 */
        Rv1=((SL *)Rv0)[9]*((SL *)Rv0)[8];
        ((V *)F_val)[1]=PAS__NEW(Rv1*4+4);
        ((SL *)((V *)F_val)[1])[0]=Rv1;
        Ra.sl[3]=763; /* line # 763 */
        Rv2=((V *)F_val)[1];
        Ra.sl[3]=764; /* line # 764 */
        Rv3=1;
        for( Rf0=((SL *)Rv2)[0];Rf0>0;Rf0-- ) {
          ((V *)Rv2)[Rv3]=NULL;
          Rv3++;
        }
        break;
        case 7:Ra.sl[3]=767; /* line # 767 */
        Rv4=((SL *)Rv0)[9]*((SL *)Rv0)[8];
        ((V *)F_val)[1]=PAS__NEW(Rv4*4+4);
        ((SL *)((V *)F_val)[1])[0]=Rv4;
        Ra.sl[3]=768; /* line # 768 */
        Rv5=((V *)F_val)[1];
        Ra.sl[3]=769; /* line # 769 */
        Rv6=1;
        for( Rf0=((SL *)Rv5)[0];Rf0>0;Rf0-- ) {
          ((SL *)Rv5)[Rv6]=0;
          Rv6++;
        }
        break;
        case 8:Ra.sl[3]=772; /* line # 772 */
        Rv7=((SL *)Rv0)[9]*((SL *)Rv0)[8];
        ((V *)F_val)[1]=PAS__NEW(Rv7*8+8);
        ((SL *)((V *)F_val)[1])[0]=Rv7;
        Ra.sl[3]=773; /* line # 773 */
        Rv8=((V *)F_val)[1];
        Ra.sl[3]=774; /* line # 774 */
        Rv9=1;
        for( Rf0=((SL *)Rv8)[0];Rf0>0;Rf0-- ) {
          ((G *)Rv8)[Rv9]=0.000000000000000E-001;
          Rv9++;
        }
        Ra.sl[3]=775; /* line # 775 */
        if (16&((UL *)Rv0)[5]) {
          Ra.sl[3]=777; /* line # 777 */
          Rv10=((SL *)Rv0)[9]*((SL *)Rv0)[8];
          ((V *)F_val)[2]=PAS__NEW(Rv10*8+8);
          ((SL *)((V *)F_val)[2])[0]=Rv10;
          Ra.sl[3]=778; /* line # 778 */
          Rv11=((V *)F_val)[2];
          Ra.sl[3]=779; /* line # 779 */
          Rv12=1;
          for( Rf0=((SL *)Rv11)[0];Rf0>0;Rf0-- ) {
            ((G *)Rv11)[Rv12]=0.000000000000000E-001;
            Rv12++;
          }
        }
        else {
          Ra.sl[3]=780; /* line # 780 */
          ((V *)F_val)[2]=NULL;
        }
        break;
        case 9:Ra.sl[3]=782; /* line # 782 */
        ((V *)F_val)[1]=NULL;
        break;
        default:break;
      }
    }
    else {
      Ra.sl[3]=787; /* line # 787 */
      ((UB *)F_val)[1]=11;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " var_allocate "  */
void P_var_allocate(V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+396;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=795; /* line # 795 */
  if (F_ide!=NULL) P_val_allocate(F_ide+40,((V *)F_ide)[4]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " copy_string "  */
void P_copy_string(V *F_src, V *F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register UB Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+410;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=803; /* line # 803 */
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  Ra.sl[3]=804; /* line # 804 */
  (*F_trg)=NULL;
  Ra.sl[3]=805; /* line # 805 */
  if ((*F_src)!=NULL) {
    Ra.sl[3]=806; /* line # 806 */
    if (((UB *)(*F_src))[1]>0) {
      Ra.sl[3]=808; /* line # 808 */
      Rv0=((UB *)(*F_src))[1];
      (*F_trg)=PAS__NEW((SL)Rv0+2);
      ((UB *)(*F_trg))[0]=Rv0;
      Ra.sl[3]=809; /* line # 809 */
      Rv1=1;
      for( Rf0=((UB *)(*F_src))[1];Rf0>0;Rf0-- ) {
        ((C *)(*F_trg))[Rv1+1]=((C *)(*F_src))[Rv1+1];
        Rv1++;
      }
      Ra.sl[3]=810; /* line # 810 */
      ((UB *)(*F_trg))[1]=((UB *)(*F_src))[1];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " value_copy "  */
void P_value_copy(V F_trg, V F_src, SL F_shf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register V Rv7;
  SL Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+423;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=822; /* line # 822 */
  Ra.sl[3]=823; /* line # 823 */
  if (((UB *)F_trg)[1]==((UB *)F_src)[1]) {
    Ra.sl[3]=825; /* line # 825 */
    switch (((UB *)F_trg)[1]) {
      case 0:Ra.sl[3]=826; /* line # 826 */
      P_copy_string(((V *)F_src)+1,((V *)F_trg)+1);
      break;
      case 1:Ra.sl[3]=827; /* line # 827 */
      ((SL *)F_trg)[1]=((SL *)F_src)[1];
      break;
      case 2:Ra.sl[3]=828; /* line # 828 */
      ((G *)F_trg)[1]=((G *)F_src)[1];
      ((G *)F_trg)[2]=((G *)F_src)[2];
      break;
      case 6:Ra.sl[3]=829; /* line # 829 */
      if (((V *)F_src)[1]!=NULL&&((V *)F_trg)[1]!=NULL) {
        Ra.sl[3]=831; /* line # 831 */
        Rv0=((SL *)((V *)F_src)[1])[0]-F_shf;
        Ra.sl[3]=832; /* line # 832 */
        if (Rv0>((SL *)((V *)F_trg)[1])[0]) Rv0=((SL *)((V *)F_trg)[1])[0];
        Ra.sl[3]=833; /* line # 833 */
        Rv1=((V *)F_src)[1];
        Ra.sl[3]=834; /* line # 834 */
        Rv2=1;
        for( Rf0=Rv0;Rf0>0;Rf0-- ) {
          P_copy_string((((V *)Rv1)+(Rv2+F_shf)),(((V *)((V *)F_trg)[1])+Rv2));
          Rv2++;
        }
      }
      break;
      case 7:Ra.sl[3]=836; /* line # 836 */
      if (((V *)F_src)[1]!=NULL&&((V *)F_trg)[1]!=NULL) {
        Ra.sl[3]=838; /* line # 838 */
        Rv0=((SL *)((V *)F_src)[1])[0]-F_shf;
        Ra.sl[3]=839; /* line # 839 */
        if (Rv0>((SL *)((V *)F_trg)[1])[0]) Rv0=((SL *)((V *)F_trg)[1])[0];
        Ra.sl[3]=840; /* line # 840 */
        Rv3=((V *)F_src)[1];
        Ra.sl[3]=841; /* line # 841 */
        Rv4=1;
        for( Rf0=Rv0;Rf0>0;Rf0-- ) {
          ((SL *)((V *)F_trg)[1])[Rv4]=((SL *)Rv3)[(Rv4+F_shf)];
          Rv4++;
        }
      }
      break;
      case 8:Ra.sl[3]=843; /* line # 843 */
      if (((V *)F_src)[1]!=NULL&&((V *)F_trg)[1]!=NULL) {
        Ra.sl[3]=845; /* line # 845 */
        Rv0=((SL *)((V *)F_src)[1])[0]-F_shf;
        Ra.sl[3]=846; /* line # 846 */
        if (Rv0>((SL *)((V *)F_trg)[1])[0]) Rv0=((SL *)((V *)F_trg)[1])[0];
        Ra.sl[3]=847; /* line # 847 */
        Rv5=((V *)F_src)[1];
        Ra.sl[3]=848; /* line # 848 */
        Rv6=1;
        for( Rf0=Rv0;Rf0>0;Rf0-- ) {
          ((G *)((V *)F_trg)[1])[Rv6]=((G *)Rv5)[(Rv6+F_shf)];
          Rv6++;
        }
        Ra.sl[3]=849; /* line # 849 */
        if (((V *)F_trg)[2]!=NULL&&((V *)F_src)[2]!=NULL) {
          Ra.sl[3]=850; /* line # 850 */
          Rv7=((V *)F_src)[2];
          Ra.sl[3]=851; /* line # 851 */
          Rv8=1;
          for( Rf0=Rv0;Rf0>0;Rf0-- ) {
            ((G *)((V *)F_trg)[2])[Rv8]=((G *)Rv7)[(Rv8+F_shf)];
            Rv8++;
          }
        }
      }
      break;
      case 9:Ra.sl[3]=853; /* line # 853 */
      ((V *)F_trg)[1]=((V *)F_src)[1];
      break;
      case 10:Ra.sl[3]=854; /* line # 854 */
      ((SL *)F_trg)[1]=((SL *)F_src)[1];
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " var_new "  */
V P_var_new(V F_typ, SL F_ilvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+435;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=871; /* line # 871 */
  Rv0=P_ide_new(1, F_typ, F_ilvl);
  Ra.sl[3]=872; /* line # 872 */
  if (Rv0!=NULL) {
    Ra.sl[3]=874; /* line # 874 */
    if (1024&((UL *)Rv0)[5]) P_src_error(Rd.s+446,132,2);
    Ra.sl[3]=875; /* line # 875 */
    if (!(512&((UL *)Rv0)[5])) P_var_allocate(Rv0);
  }
  Ra.sl[3]=877; /* line # 877 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usr_eltab_scinit "  */
V P_usr_eltab_scinit(V F_typ){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+450;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=888; /* line # 888 */
  Rv0=NULL;
  Ra.sl[3]=889; /* line # 889 */
  if (F_typ!=NULL) {
    Ra.sl[3]=890; /* line # 890 */
    Rv1=F_typ;
    Ra.sl[3]=891; /* line # 891 */
    if (((UB *)Rv1)[24]==3) {
      Ra.sl[3]=893; /* line # 893 */
      Rv0=PAS__NEW(16);
      Ra.sl[3]=894; /* line # 894 */
      Rv2=Rv0;
      Ra.sl[3]=896; /* line # 896 */
      ((V *)Rv2)[0]=P_usr_eltab_scinit(((V *)Rv1)[7]);
      Ra.sl[3]=897; /* line # 897 */
      ((SL *)Rv2)[1]=((SL *)Rv1)[10];
      Ra.sl[3]=898; /* line # 898 */
      ((SL *)Rv2)[2]=(((SL *)Rv1)[10]+((SL *)Rv1)[9])-1;
      Ra.sl[3]=899; /* line # 899 */
      ((SL *)Rv2)[3]=((SL *)Rv1)[10];
    }
  }
  Ra.sl[3]=902; /* line # 902 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " index_scan "  */
UB MXD_DCP_RTL_PRC_00000000(V F_tbs){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+468;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=912; /* line # 912 */
  if (F_tbs!=NULL) {
    Ra.sl[3]=913; /* line # 913 */
    Rv0=F_tbs;
    Ra.sl[3]=915; /* line # 915 */
    PAS__VWRITE_INIT(Lx[0].p[4].s,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_INT(((SL *)Rv0)[3],0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=916; /* line # 916 */
    if (MXD_DCP_RTL_PRC_00000000(((V *)Rv0)[0])) {
      Ra.sl[3]=918; /* line # 918 */
      if (((SL *)Rv0)[3]>=((SL *)Rv0)[2]) {
        Ra.sl[3]=920; /* line # 920 */
        ((SL *)Rv0)[3]=((SL *)Rv0)[1];
        Ret=1;
      }
      else {
        Ra.sl[3]=924; /* line # 924 */
        ((SL *)Rv0)[3]=((SL *)Rv0)[3]+1;
        Ret=0;
      }
    }
  }
  else {
    Ra.sl[3]=928; /* line # 928 */
    Ret=1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usr_eltab_scan "  */
void P_usr_eltab_scan(V F_tbs, V F_sindex, UB *F_bend){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=F_sindex;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+480;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=933; /* line # 933 */
  if (F_tbs!=NULL) {
    Ra.sl[3]=934; /* line # 934 */
    Rv0=F_tbs;
    Ra.sl[3]=936; /* line # 936 */
    PAS__VWRITE_INIT(Ra.p[4].s,0);
    PAS__WRITE_CHAR(91);
    PAS__WRITE_INT(((SL *)Rv0)[3],0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=937; /* line # 937 */
    if (MXD_DCP_RTL_PRC_00000000(((V *)Rv0)[0])) {
      Ra.sl[3]=939; /* line # 939 */
      if (((SL *)Rv0)[3]>=((SL *)Rv0)[2]) {
        Ra.sl[3]=940; /* line # 940 */
        ((SL *)Rv0)[3]=((SL *)Rv0)[1];
        (*F_bend)=1;
      }
      else {
        Ra.sl[3]=942; /* line # 942 */
        ((SL *)Rv0)[3]=((SL *)Rv0)[3]+1;
        (*F_bend)=0;
      }
    }
    else {
      Ra.sl[3]=944; /* line # 944 */
      (*F_bend)=0;
    }
    Ra.sl[3]=945; /* line # 945 */
    PAS__VWRITE_INIT(Ra.p[4].s,0);
    PAS__WRITE_CHAR(93);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " usr_eltab_scend "  */
void P_usr_eltab_scend(V F_tbs){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=954; /* line # 954 */
  if (F_tbs!=NULL) {
    Ra.sl[3]=956; /* line # 956 */
    if (((V *)F_tbs)[0]!=NULL) P_usr_eltab_scend(((V *)F_tbs)[0]);
    Ra.sl[3]=957; /* line # 957 */
    PAS__DISPOSE(&F_tbs);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_ide_locate "  */
V P_usr_ide_locate(V F_id_name){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+513;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=969; /* line # 969 */
  Rv0=V_furf_hde;
  Ra.sl[3]=970; /* line # 970 */
  while (Rv0!=NULL){
    Ra.sl[3]=971; /* line # 971 */
    Rv1=Rv0;
    Ra.sl[3]=973; /* line # 973 */
    if (PAS__MATCH_STR(((V *)((V *)Rv1)[2])[0],F_id_name)==0)  break;
    Ra.sl[3]=974; /* line # 974 */
    Rv0=((V *)Rv0)[0];
  }
  Ra.sl[3]=976; /* line # 976 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " look_for_usr "  */
V MXD_DCP_RTL_look_for_usr(V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+529;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=986; /* line # 986 */
  Rv0=V_furf_hde;
  Ra.sl[3]=987; /* line # 987 */
  while (Rv0!=NULL){
    Ra.sl[3]=989; /* line # 989 */
    if (((V *)Rv0)[2]==F_id)  break;
    Ra.sl[3]=990; /* line # 990 */
    Rv0=((V *)Rv0)[0];
  }
  Ra.sl[3]=992; /* line # 992 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usr_ide_append "  */
void P_usr_ide_append(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+543;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1003; /* line # 1003 */
  if (F_p!=NULL) {
    Ra.sl[3]=1005; /* line # 1005 */
    if (MXD_DCP_RTL_look_for_usr(F_p)==NULL) {
      Ra.sl[3]=1007; /* line # 1007 */
      Rv0=PAS__NEW(12);
      Ra.sl[3]=1008; /* line # 1008 */
      ((V *)Rv0)[2]=F_p;
      Ra.sl[3]=1009; /* line # 1009 */
      ((V *)Rv0)[0]=NULL;
      Ra.sl[3]=1010; /* line # 1010 */
      if (V_furf_hde!=NULL) {
        Ra.sl[3]=1012; /* line # 1012 */
        ((V *)V_furf_lst)[0]=Rv0;
        Ra.sl[3]=1013; /* line # 1013 */
        ((V *)Rv0)[1]=V_furf_lst;
      }
      else {
        Ra.sl[3]=1017; /* line # 1017 */
        V_furf_hde=Rv0;
        Ra.sl[3]=1018; /* line # 1018 */
        ((V *)Rv0)[1]=NULL;
      }
      Ra.sl[3]=1020; /* line # 1020 */
      V_furf_lst=Rv0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_ide_remove "  */
void P_usr_ide_remove(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+559;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1033; /* line # 1033 */
  if (F_p!=NULL) {
    Ra.sl[3]=1035; /* line # 1035 */
    Rv0=MXD_DCP_RTL_look_for_usr(F_p);
    Ra.sl[3]=1036; /* line # 1036 */
    if (Rv0!=NULL) {
      Ra.sl[3]=1037; /* line # 1037 */
      Rv1=Rv0;
      Ra.sl[3]=1040; /* line # 1040 */
      if (((V *)Rv1)[1]==NULL) V_furf_hde=((V *)Rv1)[0];
      else {
        Ra.sl[3]=1041; /* line # 1041 */
        ((V *)((V *)Rv1)[1])[0]=((V *)Rv1)[0];
      }
      Ra.sl[3]=1042; /* line # 1042 */
      if (((V *)Rv1)[0]==NULL) V_furf_lst=((V *)Rv1)[1];
      else {
        Ra.sl[3]=1043; /* line # 1043 */
        ((V *)((V *)Rv1)[0])[1]=((V *)Rv1)[1];
      }
      Ra.sl[3]=1044; /* line # 1044 */
      PAS__DISPOSE(&Rv0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_getpath "  */
SL P_usr_getpath(C F_sp, V F_st, V F_tbrf){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  C Rv6;
  register UB Rv7;
  SL Rv8;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+575;
  Ra.v[67]=Rd.s+19;
  Ra.sl[68]=1076; /* line # 1076 */
  Rv0=PAS__GET_ENV_ARRAY(&Rv1, F_st);
  Ra.sl[68]=1077; /* line # 1077 */
  if (Rv0>0) {
    Ra.sl[68]=1078; /* line # 1078 */
    Ra.sl[68]=1080; /* line # 1080 */
    Rv2=0;
    Ra.sl[68]=1081; /* line # 1081 */
    Rv3=0;
    Ra.sl[68]=1082; /* line # 1082 */
    Rv4=0;
    Ra.sl[68]=1083; /* line # 1083 */
    Rv5=0;
    Ra.sl[68]=1084; /* line # 1084 */
    while (Rv3<Rv0&&Rv2<((SL *)F_tbrf)[0]){
      Ra.sl[68]=1086; /* line # 1086 */
      Rv6=((C *)Rv1)[Rv3];
      Ra.sl[68]=1087; /* line # 1087 */
      Rv4=Rv4+1;
      Ra.sl[68]=1088; /* line # 1088 */
      Rv3=Rv3+1;
      Ra.sl[68]=1089; /* line # 1089 */
      Ra.c[Rv4+1]=Rv6;
      Ra.sl[68]=1090; /* line # 1090 */
      if ((Rv6==F_sp||Rv4==Ra.ub[0])||Rv3==Rv0) {
        Ra.sl[68]=1092; /* line # 1092 */
        Ra.ub[1]=Rv4;
        Ra.sl[68]=1093; /* line # 1093 */
        Rv2=Rv2+1;
        Ra.sl[68]=1094; /* line # 1094 */
        if (((V *)F_tbrf)[Rv2]!=NULL) PAS__DISPOSE((((V *)F_tbrf)+Rv2));
        Ra.sl[68]=1095; /* line # 1095 */
        Rv7=Ra.ub[1];
        ((V *)F_tbrf)[Rv2]=PAS__NEW((SL)Rv7+2);
        ((UB *)((V *)F_tbrf)[Rv2])[0]=Rv7;
        Ra.sl[68]=1096; /* line # 1096 */
        PAS__STR_TO_STR(((V *)F_tbrf)[Rv2],Ra.s);
        Ra.sl[68]=1097; /* line # 1097 */
        Ra.ub[1]=0;
        Rv4=0;
        Ra.sl[68]=1098; /* line # 1098 */
        if (Rv6!=F_sp&&Rv3!=Rv0) Rv5=1;
      }
    }
    Ra.sl[68]=1101; /* line # 1101 */
    if (Rv2==((SL *)F_tbrf)[0]&&Rv3<Rv0) Rv2=((SL *)F_tbrf)[0]+1;
    else {
      Ra.sl[68]=1103; /* line # 1103 */
      Rv8=Rv2+1;
      for( Rf0=(((SL *)F_tbrf)[0]+1)-(Rv2+1);Rf0>0;Rf0-- ) {
        Ra.sl[68]=1104; /* line # 1104 */
        if (((V *)F_tbrf)[Rv8]!=NULL) PAS__DISPOSE((((V *)F_tbrf)+Rv8));
        Rv8++;
      }
    }
  }
  else {
    Ra.sl[68]=1106; /* line # 1106 */
    Rv2=-1;
  }
  Ra.sl[68]=1107; /* line # 1107 */
  if (Rv5) Rv2= -Rv2;
  Ra.sl[68]=1108; /* line # 1108 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " usr_setpath "  */
SL P_usr_setpath(V F_st, SL F_ist, V F_tbrf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf1, Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+588;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1130; /* line # 1130 */
  Rv0=PAS__NEW(16384);
  Ra.sl[3]=1131; /* line # 1131 */
  Ra.sl[3]=1133; /* line # 1133 */
  Rv1=0;
  Ra.sl[3]=1134; /* line # 1134 */
  if (F_ist<1||F_ist>=((SL *)F_tbrf)[0]) F_ist=((SL *)F_tbrf)[0];
  Ra.sl[3]=1135; /* line # 1135 */
  Rv2=1;
  for( Rf1=((SL *)F_tbrf)[0];Rf1>0;Rf1-- ) {
    Ra.sl[3]=1137; /* line # 1137 */
    if (((V *)F_tbrf)[Rv2]!=NULL) {
      Ra.sl[3]=1138; /* line # 1138 */
      Rv3=((V *)F_tbrf)[Rv2];
      Ra.sl[3]=1139; /* line # 1139 */
      Rv4=1;
      for( Rf0=((UB *)Rv3)[1];Rf0>0;Rf0-- ) {
        Ra.sl[3]=1140; /* line # 1140 */
        if (Rv1<16384) {
          Ra.sl[3]=1141; /* line # 1141 */
          Rv1=Rv1+1;
          ((C *)Rv0)[Rv1-1]=((C *)Rv3)[Rv4+1];
        }
        Rv4++;
      }
    }
    Rv2++;
  }
  Ra.sl[3]=1143; /* line # 1143 */
  if (Rv1<16384) {
    Ra.sl[3]=1146; /* line # 1146 */
    Rv5=PAS__SET_ENV_ARRAY(F_st,Rv0,16384, Rv1,1);
  }
  else {
    Ra.sl[3]=1148; /* line # 1148 */
    Rv5=-99;
  }
  Ra.sl[3]=1150; /* line # 1150 */
  PAS__DISPOSE(&Rv0);
  Ra.sl[3]=1151; /* line # 1151 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " usr_ide_substitute "  */
void P_usr_ide_substitute(V F_src, V F_dst, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  C Rv5;
  C Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  register V Rv10;
  SL Rv11;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+601;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1166; /* line # 1166 */
  Rv0=0;
  Ra.sl[3]=1167; /* line # 1167 */
  Rv1=((UB *)F_dst)[0];
  Ra.sl[3]=1168; /* line # 1168 */
  Rv2=((UB *)F_src)[1];
  Ra.sl[3]=1169; /* line # 1169 */
  Rv3=1;
  Ra.sl[3]=1170; /* line # 1170 */
  Rv4=0;
  while (1){
    Ra.sl[3]=1172; /* line # 1172 */
    if (Rv3>Rv2)  break;
    Ra.sl[3]=1173; /* line # 1173 */
    Rv5=((C *)F_src)[Rv3+1];
    Rv3=Rv3+1;
    Ra.sl[3]=1174; /* line # 1174 */
    if (!Rv0) {
      Ra.sl[3]=1175; /* line # 1175 */
      if (Rv5==F_ch) {
        Ra.sl[3]=1177; /* line # 1177 */
        if (Rv3>Rv2) Rv6=F_ch;
        else {
          Ra.sl[3]=1178; /* line # 1178 */
          Rv6=((C *)F_src)[Rv3+1];
        }
        Ra.sl[3]=1179; /* line # 1179 */
        if (Rv6!=F_ch) {
          Ra.sl[3]=1181; /* line # 1181 */
          Rv7=0;
          Ra.sl[3]=1182; /* line # 1182 */
          Rv0=1;
        }
        else {
          Ra.sl[3]=1186; /* line # 1186 */
          Rv3=Rv3+1;
          Ra.sl[3]=1187; /* line # 1187 */
          if (Rv4<Rv1) {
            Rv4=Rv4+1;
            ((C *)F_dst)[Rv4+1]=Rv5;
          }
        }
      }
      else {
        Ra.sl[3]=1192; /* line # 1192 */
        if (Rv4<Rv1) {
          Rv4=Rv4+1;
          ((C *)F_dst)[Rv4+1]=Rv5;
        }
      }
    }
    else {
      Ra.sl[3]=1196; /* line # 1196 */
      if (Rv5==F_ch) {
        Ra.sl[3]=1198; /* line # 1198 */
        Rv0=0;
        Ra.sl[3]=1199; /* line # 1199 */
        Ri.ub[1]=Rv7;
        Ra.sl[3]=1200; /* line # 1200 */
        Rv8=P_usr_ide_locate(Ri.s);
        Ra.sl[3]=1201; /* line # 1201 */
        if (Rv8!=NULL) {
          Ra.sl[3]=1202; /* line # 1202 */
          Rv9=Rv8;
          Rv10=Rv9+40;
          Ra.sl[3]=1204; /* line # 1204 */
          switch (((UB *)Rv10)[1]) {
            case 0:Ra.sl[3]=1205; /* line # 1205 */
            if (((V *)Rv10)[1]!=NULL) PAS__STR_TO_STR(Ri.s,((V *)Rv10)[1]);
            else {
              Ra.sl[3]=1206; /* line # 1206 */
              Ri.ub[1]=0;
            }
            break;
            case 1:Ra.sl[3]=1207; /* line # 1207 */
            PAS__VWRITE_INIT(Ri.s,1);
            PAS__WRITE_INT(((SL *)Rv10)[1],0,0);
            PAS__WRITE_EOLN();
            break;
            case 2:Ra.sl[3]=1208; /* line # 1208 */
            PAS__VWRITE_INIT(Ri.s,1);
            PAS__WRITE_DBLE(((G *)Rv10)[1],24,-15,0);
            PAS__WRITE_EOLN();
            break;
            default:break;
          }
          Ra.sl[3]=1211; /* line # 1211 */
          Rv11=1;
          for( Rf0=Ri.ub[1];Rf0>0;Rf0-- ) {
            Ra.sl[3]=1212; /* line # 1212 */
            if (Rv4<Rv1) {
              Rv4=Rv4+1;
              ((C *)F_dst)[Rv4+1]=Ri.c[Rv11+1];
            }
            Rv11++;
          }
        }
      }
      else {
        Ra.sl[3]=1216; /* line # 1216 */
        if (Rv7<Ri.ub[0]) {
          Rv7=Rv7+1;
          Ri.c[Rv7+1]=Rv5;
        }
      }
    }
  }
  Ra.sl[3]=1219; /* line # 1219 */
  ((UB *)F_dst)[1]=Rv4;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_s_element "  */
void P_usr_s_element(V F_dst, V F_src, SL F_iel, C F_csp, C F_cst, UB F_bss){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  C Rv9;
  C Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+621;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1236; /* line # 1236 */
  Rv0=((UB *)F_src)[1];
  Ra.sl[3]=1237; /* line # 1237 */
  Rv1=((UB *)F_dst)[0];
  Ra.sl[3]=1238; /* line # 1238 */
  Rv2=0;
  Ra.sl[3]=1239; /* line # 1239 */
  Rv3=0;
  Ra.sl[3]=1240; /* line # 1240 */
  Rv4=1;
  Ra.sl[3]=1241; /* line # 1241 */
  Rv5=0;
  Rv6=0;
  Ra.sl[3]=1242; /* line # 1242 */
  Rv7=0;
  Rv8=0;
  Ra.sl[3]=1243; /* line # 1243 */
  if (F_csp<32) F_csp=32;
  Ra.sl[3]=1244; /* line # 1244 */
  if (F_cst<32) F_cst=32;
  Ra.sl[3]=1245; /* line # 1245 */
  if (F_cst==F_csp) F_cst=32;
  Ra.sl[3]=1247; /* line # 1247 */
  while (Rv4<=Rv0&&F_iel>=0){
    Ra.sl[3]=1249; /* line # 1249 */
    Rv9=((C *)F_src)[Rv4+1];
    if (Rv9<32) Rv9=32;
    Ra.sl[3]=1250; /* line # 1250 */
    if (F_cst>32) {
      Ra.sl[3]=1251; /* line # 1251 */
      if (Rv3) {
        Ra.sl[3]=1253; /* line # 1253 */
        if (Rv9==F_cst) {
          Ra.sl[3]=1255; /* line # 1255 */
          if (Rv4<=Rv0) Rv10=((C *)F_src)[(Rv4+1)+1];
          else {
            Ra.sl[3]=1256; /* line # 1256 */
            Rv10=F_cst;
          }
          Ra.sl[3]=1257; /* line # 1257 */
          if (Rv9==Rv10) Rv4=Rv4+1;
          else {
            Ra.sl[3]=1258; /* line # 1258 */
            Rv3=0;
            Rv8=Rv4;
          }
        }
      }
      else {
        Ra.sl[3]=1262; /* line # 1262 */
        if (Rv9==F_cst) {
          Ra.sl[3]=1264; /* line # 1264 */
          if (!Rv2) {
            Rv2=1;
            Rv5=Rv4;
          }
          Ra.sl[3]=1265; /* line # 1265 */
          Rv6=Rv4;
          Rv3=1;
        }
      }
    }
    Ra.sl[3]=1268; /* line # 1268 */
    if (!Rv3) {
      Ra.sl[3]=1269; /* line # 1269 */
      if (Rv2) {
        Ra.sl[3]=1271; /* line # 1271 */
        if (Rv9==F_csp) {
          Ra.sl[3]=1272; /* line # 1272 */
          Rv2=0;
          Rv7=Rv4-1;
          F_iel=F_iel-1;
        }
      }
      else {
        Ra.sl[3]=1276; /* line # 1276 */
        if (Rv9!=F_csp) {
          Ra.sl[3]=1277; /* line # 1277 */
          Rv2=1;
          Rv5=Rv4;
        }
        else {
          Ra.sl[3]=1280; /* line # 1280 */
          if (F_csp!=32&&Rv9==F_csp) {
            Ra.sl[3]=1281; /* line # 1281 */
            Rv5=Rv4;
            Rv7=Rv4-1;
            F_iel=F_iel-1;
          }
        }
      }
    }
    Ra.sl[3]=1284; /* line # 1284 */
    Rv4=Rv4+1;
  }
  Ra.sl[3]=1286; /* line # 1286 */
  if (Rv2) {
    Ra.sl[3]=1287; /* line # 1287 */
    Rv7=Rv0;
    Rv2=0;
    F_iel=F_iel-1;
  }
  Ra.sl[3]=1289; /* line # 1289 */
  Rv11=0;
  Ra.sl[3]=1290; /* line # 1290 */
  if (F_iel<0) {
    Ra.sl[3]=1293; /* line # 1293 */
    Rv3=0;
    Ra.sl[3]=1294; /* line # 1294 */
    if (F_bss) {
      Ra.sl[3]=1295; /* line # 1295 */
      Rv12=Rv5;
      for( Rf0=(Rv7+1)-Rv5;Rf0>0;Rf0-- ) {
        Ra.sl[3]=1297; /* line # 1297 */
        if (Rv11<Rv1) {
          Rv11=Rv11+1;
          ((C *)F_dst)[Rv11+1]=((C *)F_src)[Rv12+1];
        }
        Rv12++;
      }
    }
    else {
      Ra.sl[3]=1301; /* line # 1301 */
      Rv2=0;
      Ra.sl[3]=1302; /* line # 1302 */
      Rv13=Rv5;
      for( Rf0=(Rv7+1)-Rv5;Rf0>0;Rf0-- ) {
        Ra.sl[3]=1304; /* line # 1304 */
        Rv9=((C *)F_src)[Rv13+1];
        Ra.sl[3]=1305; /* line # 1305 */
        if (Rv9==F_cst&&F_cst!=32) {
          Ra.sl[3]=1306; /* line # 1306 */
          if (Rv3) {
            Ra.sl[3]=1307; /* line # 1307 */
            Rv2=1;
            Rv3=0;
          }
          else {
            Ra.sl[3]=1310; /* line # 1310 */
            if (Rv2) {
              Ra.sl[3]=1312; /* line # 1312 */
              Rv2=0;
              Ra.sl[3]=1313; /* line # 1313 */
              if (Rv11<Rv1) {
                Rv11=Rv11+1;
                ((C *)F_dst)[Rv11+1]=Rv9;
              }
            }
            Ra.sl[3]=1315; /* line # 1315 */
            Rv3=1;
          }
        }
        else {
          Ra.sl[3]=1319; /* line # 1319 */
          Rv2=0;
          Ra.sl[3]=1320; /* line # 1320 */
          if (Rv11<Rv1) {
            Rv11=Rv11+1;
            ((C *)F_dst)[Rv11+1]=Rv9;
          }
        }
        Rv13++;
      }
    }
  }
  Ra.sl[3]=1325; /* line # 1325 */
  ((UB *)F_dst)[1]=Rv11;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_suppress_comment "  */
void P_usr_suppress_comment(V F_src, V F_dst, C F_cc, C F_cs){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  SL Rv2;
  SL Rv3;
  C Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+636;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1339; /* line # 1339 */
  if (F_cc<=32) F_cc=33;
  Ra.sl[3]=1340; /* line # 1340 */
  if (F_cs==F_cc) F_cs=34;
  Ra.sl[3]=1341; /* line # 1341 */
  if (F_cs<=32) {
    Ra.sl[3]=1343; /* line # 1343 */
    Rv0=PAS__INDEX_CHA(F_src+2,(SL)((UB *)F_src)[1],F_cc);
    Ra.sl[3]=1344; /* line # 1344 */
    if (Rv0==0) PAS__STR_TO_STR(F_dst,F_src);
    else {
      Ra.sl[3]=1345; /* line # 1345 */
      PAS__STR_TO_STR(F_dst,PAS__SUBSTR_STR(Ra.s+16,F_src,1, Rv0-1));
    }
  }
  else {
    Ra.sl[3]=1349; /* line # 1349 */
    Rv1=0;
    Ra.sl[3]=1350; /* line # 1350 */
    Rv2=((UB *)F_dst)[0];
    Ra.sl[3]=1351; /* line # 1351 */
    if (Rv2>((UB *)F_src)[1]) Rv2=((UB *)F_src)[1];
    Ra.sl[3]=1352; /* line # 1352 */
    Rv0=0;
    Rv3=0;
    Ra.sl[3]=1353; /* line # 1353 */
    while (Rv0<Rv2){
      Ra.sl[3]=1355; /* line # 1355 */
      Rv0=Rv0+1;
      Ra.sl[3]=1356; /* line # 1356 */
      Rv4=((C *)F_src)[Rv0+1];
      Ra.sl[3]=1357; /* line # 1357 */
      if (Rv4==F_cs) Rv1=!Rv1;
      Ra.sl[3]=1358; /* line # 1358 */
      if (!Rv1&&Rv4==F_cc)  break;
      Ra.sl[3]=1359; /* line # 1359 */
      Rv3=Rv3+1;
      Ra.sl[3]=1360; /* line # 1360 */
      ((C *)F_dst)[Rv3+1]=Rv4;
    }
    Ra.sl[3]=1362; /* line # 1362 */
    ((UB *)F_dst)[1]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " usr_numeric_string "  */
UB P_usr_numeric_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  C Rv2;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+658;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1380; /* line # 1380 */
  Rv0=0;
  Ra.sl[3]=1381; /* line # 1381 */
  Rv1=1;
  Ra.sl[3]=1382; /* line # 1382 */
  while (Rv0<=0&&Rv1<=((UB *)F_str)[1]){
    Ra.sl[3]=1384; /* line # 1384 */
    Rv2=((C *)F_str)[Rv1+1];
    Ra.sl[3]=1385; /* line # 1385 */
    switch (Rv2) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:Ra.sl[3]=1387; /* line # 1387 */
      if (Rv0>0) goto L_l_0;
      break;
      case 43:
      case 45:Ra.sl[3]=1390; /* line # 1390 */
      switch (Rv0) {
        case 0:Ra.sl[3]=1391; /* line # 1391 */
        Rv0=1;
        break;
        case 4:Ra.sl[3]=1392; /* line # 1392 */
        Rv0=5;
        break;
        default:Ra.sl[3]=1394; /* line # 1394 */
        goto L_l_0;
        break;
      }
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:Ra.sl[3]=1398; /* line # 1398 */
      switch (Rv0) {
        case 0:
        case 1:
        case 2:Ra.sl[3]=1400; /* line # 1400 */
        if (Rv0<2) Rv0=2;
        break;
        case 4:
        case 5:Ra.sl[3]=1402; /* line # 1402 */
        if (Rv0<5) Rv0=5;
        break;
        default:break;
      }
      break;
      case 46:Ra.sl[3]=1407; /* line # 1407 */
      if (Rv0<3) Rv0=3;
      else {
        Ra.sl[3]=1408; /* line # 1408 */
        goto L_l_0;
      }
      break;
      case 68:
      case 69:
      case 100:
      case 101:Ra.sl[3]=1411; /* line # 1411 */
      if (Rv0<4) Rv0=4;
      else {
        Ra.sl[3]=1412; /* line # 1412 */
        goto L_l_0;
      }
      break;
      default:Ra.sl[3]=1415; /* line # 1415 */
      if (Rv0>0) goto L_l_0;
      break;
    }
    Ra.sl[3]=1417; /* line # 1417 */
    Rv1=Rv1+1;
  }
L_l_0: ;
  Ra.sl[3]=1419; /* line # 1419 */
  switch (Rv0) {
    case 2:
    case 3:
    case 5:Ra.sl[3]=1421; /* line # 1421 */
    Ret=1;
    break;
    default:Ra.sl[3]=1423; /* line # 1423 */
    Ret=0;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
