{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*                           MXD   Data   Compiler                             *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

program MXD_DCP;


  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }




  {**************************************************}
  {*******          Type Declarations          ******}
  {**************************************************}
(*
type

  node_typ = ( { Reference node definitions }
               refer,      ctarray,    param,      varbl,       { 00..03 }
               contrrf,    indxrf,     functrf,    formalrf,    { 04..07 }
               arrayrf,    no09,       no10,       no11,        { 08..11 }
               no12,       no13,       no14,       no15,        { 12..15 }

               { Operator and scalar constante node definitions }
               konst,      addop,      subop,      mulop,       { 16..19 }
               divop,      negop,      powop,      ipwop,       { 20..23 }
               sinop,      cosop,      tanop,      asinop,      { 24..27 }
               acosop,     atanop,     expop,      logop,       { 28..31 }
               sqrto,      tanho,      phaseop,    absop,       { 32..35 }
               bess1op,    no37,       no38,       no39,        { 36..39 }
               summop,     selectop,   intselop,   sumhklop,    { 40..43 }
               no44,       no45,       no46,       no47,        { 44..47 }
               modop,      intop,      equop,      neqop,       { 48..51 }
               cltop,      cleop,      cgeop,      cgtop,       { 52..55 }

               { Special operators }
               formalcall, functcall,  no58,       no59,        { 56..59 }
               no60,       no61,       no62,       connectop,   { 60..63 }

               { All other p code statements are below }
               cellsy,     catomsy,    atomsy,     momentsy,    { 64..67 }
               mdsdspsy,   wavevsy,    npoladirsy, symtrysy,    { 68..71 }
               optionssy,  soptionsy,  nullsy,                  { 72..74 }
               varbldf,    parmdf,                              { 75..76 }
               datasy,     no78,       lsqblocksy, centeronsy,  { 77..80 }
               assignvarsy,bisomd,     fixedsy,    unfixedsy,   { 81..84 }
               latticesy,  limitssy,   magneticsy,              { 85..87 }
               uctrdefsy,  formaldf,   usfunctdf,  indxdf,      { 88..91 }
               no92,       arraydf,    no94,       no95,        { 92..95 }
               no96,       no97,       no98,       no99,        { 96..99 }

               { Pseudo instructions follow }
               includesy,  chainsy,    eofsym,     pragmasy,
               rcellsy,    ffassignsy, clrdatasy,  macrolibsy,
               mcallsy,    genspacesy, repeatsy,   ifsy,
               macrosy,    beginsy,    thensy,     untilsy,
               endifsy,    endmacsy,   endsy,      elsesy,
               purgesy,    illegalsy,  errorsy,    wrtmsgsy,
               displaysy,  replysy,    opensy,     closesy,
               writesy,    writelnsy,  readsy,

               { Run control statements }
               runapplsy,  listingsy,  spawnsy,

               { Constant operators }
               assignop,   andop,      iorop,      notop,
               concop,     interpop,   substrop,   lengthop,
               indexop,    nindexop,   stringop,   numberop,
               definedop,  paramrefop, getenvop,

               { Separator definitions }
               colonsy,    commasy,    lparsy,     rparsy,
               brasy,      ketsy,      smcolsy,

               { Parameter definitions }
               parh,       park,       parl,       parrh,
               parrk,      parrl,      parstsl,
               parhx,      parhy,      parhz,
               parqx,      parqy,      parqz,
               parhh,      parkk,      parll,
               parobs,     parsig,     parweig,    parcalc,
               parfn2,     parfm2,     paripola,   parpola,
               parsh,      parsk,      parsl,
               parlchi2,   parcchi2,   parlmaxf,   parcmaxf,
               parfnr,     parfni,
               parfxr,     parfyr,     parfzr,
               parfxi,     parfyi,     parfzi,

               { Last definition }
               ndtend
             );
*)





{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }




{ ************************************************************************************* }
{ ***  Global Variables of MXD-Data ComPiler environment declared with init values  *** }
{ ************************************************************************************* }


[global]
var

  sy_ival:                     integer;         { INSYMBOL: Last readden integer number }
  sy_rval:                     mxd_flt;         { INSYMBOL: Last readden floatting number }

  sy_noexec,                                    { INSYMBOL: To flag the no exec mode }
  sy_nomacrflg:                boolean;         { INSYMBOL: Flag to disable the mac. parm replace }
  sy_macro:                    idm_ptr;         { INSYMBOL: Last readen macro symbol pointer }

  sy_maclst,                                    { INSYMBOL: Macro Expension Source Line }
  sy_string:                str_string;         { INSYMBOL: Last readden string }
  sy_ident:                 ide_string;         { INSYMBOL: Last readden identifier }
  sy_cmin,                                      { INSYMBOL: Last readden character in major }
  sy_ch:                          char;         { INSYMBOL: Last readden character }
  sy_sym:                      sym_rec;         { INSYMBOL: Symbol found }
  sy_idenew:                   ide_ptr;         { IDE_NEW:  Pointer to the last created symbol }
  lastsymb:                     symbol;         { Last symbol in source }

  idm_space,                                    { Flag for space already out }
  idm_outmacro:       boolean := false;         { Flag to generate a macro stream }

  idm_newmac:         idm_apt :=   nil;         { Macro in build }
  idm_actstk,                                   { Stack pointer of active macro code }
  idm_tmphde,                                   { Stack pointer of temporary macro parm }
  idm_defstk:         idm_ptr :=   nil;         { Stack pointer of Defined Macro Identifiers }

  idm_liblifo:        stq_ptr :=   nil;         { Stack (LiFo) of macro library specifications }

  mop_tab:                   mope_tabt;         { Define the macro operator reference lists }


  keyword_tree:    keyword_ptr :=  nil;         { Keyword definition tree }

  symc_stk:           symc_ptr :=  nil;         { Symbol context pointer }

  list_dataflg,                                 { Flag to list of data during data build time }
  debug_macsrc,                                 { Debug Macro Source }
  debug_mac,                                    { Debug of macro }
  debug_sym,                                    { Debug on Input syntax unit flag }
  debug_exp,                                    { Debug on Expression element flag }
  debug_dat:          boolean := false;         { Debug on data (for external ressources) }

  sy_npcd_flg,                                  { To flag the not open pcd file status }
  sy_init_mod:        boolean :=  true;         { Program init flag mode }

  disp_tab:                 disp_tabty;         { The Display levels table }

  curr_disp,                                    { Current top of lex display }
  curr_idisp,                                   { Display level of founded identifier }
  curr_lex:                    integer;         { Current identifier lex }

  str_typ,                                      { Standard string type identifier pointer }
  int_typ,                                      { Standard integer type identifier pointer }
  flt_typ,                                      { Standard float type identifier pointer }
  fta_typ:                     typ_ptr;         { Standard table type identifier pointer }

  ret_ide,                                      { Mfunction return identifier pointer body }
  curr_ide,                                     { Current identifier to search (or nil) }
  udc_int,                                      { Undeclared Integer }
  udc_ident:            ide_ptr := nil;         { Undeclared Identifier }

  furf_hde,
  furf_lst:            usrf_ptr := nil;         { Final User Referencable Identifier list Header }

  job_name,                                     { MXD Job Name specification }
  job_save,                                     { MXD Save file specification }
  job_title:           ide_ptr :=  nil;         { Title of MXD job string }

  exp_null,                                     { Null expression record }
  exp_res,                                      { Current expressions to manage }
  exp_rs0,
  exp_rs1:                     exp_rec;

  adat_seq_count,                               { Additional Data Identifier Sequence top number }
  ret_seq_count,                                { Return Sequence count for LSQ mfuntion application }
  ret_seq_incr:         unsigned  := 0;         { Return sequence increment }
  ide_seq_count:        unsigned  := 1;         { Identifier Sequence count for LSQ application }

  numerr_cnt,                                   { Numeric error count }
  ierr:                 integer   := 0;         { General error code }

  exp_nva,                                      { Flag to No compile/(do not compute) a LSQ expression }
  data_mode,                                    { Macro mode flag for insymbol }
  numerr_nstp,                                  { Flag for no stop on numeric error }
  fatal_error:  boolean :=       false;         { General flag for fatal error }

  itm_cblk:             itm_ptr := nil;         { Current item block pointer }

  io_winfo,                                     { Wait process out information }
  io_libpath,                                   { Path to *env.std and *.err files }
  io_err,                                       { Open File Error variable }
  io_count,                                     { Array input count identifier pointer }
  io_eoln,                                      { EOLN flag identifier pointer }
  io_eof:                      ide_ptr;         { EOF flag identifer pointer }

  sym_iof:                   iocnt_tab;         { User text file descriptors }

  pcd:                            text;         { Statement MXD-P-Code file }



(*
label                     MXD_DCP_STOP;         { Label to Exit on fatal error }
*)



begin { MXD_DCP : Main of Data Compiler Code }
  {  *** Initialize the Source/Listing/Error Context ***  }
  DCP_INIT;                                     { Initialize the insymbol module }
  DCP_LSQ_INIT;                                 { Initialize the Least-Squares specific module }

  STATELIST( endsy );                           { Execute the statement flow }

  DCP_LSQ_SUMMARY;                              { Make summary MXD processing }

  if fatal_error then WRITELN( task_name, ' Stop after a fatal ERROR.' )
                 else WRITELN
end MXD_DCP.
