{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/03/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*        MXD   Data   Compiler   Least-Squares   Specific   Routines          *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module MXD_DCP_LSQ;


  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }




{**************************************************}
{*******          Type Declarations          ******}
{**************************************************}




{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }

var
  curr_idname:        str_ptr :=   nil; { Current identifier name pointer to search (when not in sy_ident) }

  module_status:      boolean := false; { Current module status flag }

  lsq_id_count:       integer :=     0; { Count for LSQ identifier sequence number }



  { Data Reduction Result files }

  ddi:                        ddi_file; { Data directory file }
  bdt:                        bdt_file; { Binary data file }



{ ************************************************************************************* }
{ ***  Global Variables of MXD-Data ComPiler environment declared with init values  *** }
{ ************************************************************************************* }





{ *************************************************************************************
  *                                                                                   *
  *                                                                                   *
  *        Least-Squares   Specific   Routines  for the MXD-V4 Data Compiler          *
  *                                                                                   *
  *                                                                                   *
  *************************************************************************************
}




[global]
procedure DCP_LSQ_INIT;
begin
  OPEN( pcd, mpcspcfile, [error_file,write_file] );
  if iostatus <> 0 then
  begin
    WRITELN( ' *** ', task_name, ' ERROR : Cannot Create the output MXD-PCODE file "', mpcspcfile, '".' );
    PASCAL_EXIT( 4 )                        { Stop on this fatal error }
  end
end DCP_LSQ_INIT;



[global]
procedure DCP_LSQ_MODULE;
begin
end DCP_LSQ_MODULE;



[global]
procedure DCP_LSQ_SUMMARY;
begin
  CLOSE( pcd )
end DCP_LSQ_SUMMARY;



procedure OUT_VARIABLE_DCLCH( ip: ide_ptr; bdcl: boolean );
var
  bnd:        boolean := false;
  stn:                  string;
  tbs:                 tbs_ptr;
  nd:                node_code;

begin
  if bdcl then nd := nd_varbl
          else nd := nd_refer;

  with sy_sym, ip^, ide_obj do
  begin
    if ide_obj.knd = idek_tabflt then
    begin { We have create or modify an array of LSQ Variables }
      NEW( ide_taberr, aaf^.ide_all );          { Allocate the related sigma table }
      tbs := USR_ELTAB_SCINIT( ide_asr );       { Initialize the index scan }
      for ii := 1 to aaf^.ide_all do
      begin
        if bdcl then
        begin
          WRITEV( stn, ide_name^ );
          USR_ELTAB_SCAN( tbs, stn, bnd )       { Create the index reference and skip for next (bnd = true when it is the last elem.) }
        end;
        WRITE( pcd, ORD( nd ):4, ' ', ide_sequnb + ii - 1:6,  ' ', aaf^.ide_ftb[ii]:16:8, ' ', ide_taberr^.ide_ftb[ii]:16:8 );
        if bdcl then WRITELN( pcd, ' ', stn.length:3, ' ', stn )
                else WRITELN( pcd )
      end;
      if bdcl then USR_ELTAB_SCEND( tbs )
    end
    else { We create a single of LSQ Variable }
    begin
      lsq_id_count := lsq_id_count + 1;
      WRITE( pcd, ORD( nd ):4, ' ', ide_sequnb:6, ' ', flt:16:8, ' ', ide_parerr::16:8 );
      if bdcl then WRITELN( pcd, ide_name^.length:3, ' ', ide_name^ )
              else WRITELN( pcd )
    end
  end
end OUT_VARIABLE_DCLCH;



[global]
procedure DCP_DEF_LSQ_VARBL( ip: ide_ptr );
{ Call tp complete a (LSQ) VARIABLE <name> [ := <initial value> [ : <initial_std_err> ]] declaration }
const
  mdnam = 'LSQV';

var
  bvl, btv, bnd:      boolean := false;
  val, sig:           mxd_flt :=   0.0;
  stn:                          string;
  tbs:                         tbs_ptr;

begin
  with sy_sym, ip^, ide_obj do
  begin { In the source we can find "=" or ":=" or "," or ";" }
    if (sy = becomes) or ((sy = relop) and (op = eq_op)) then bvl := true;
    ide_sequnb := lsq_id_count;
    if bvl then
    begin
      INSYMBOL;
      if sy = lparen then
      begin  btv := true; sy := comma  end
      else
      begin
        val := GET_FLTEXPR( 0.0 );
        if sy = colon then
        begin  INSYMBOL; sig := GET_FLTEXPR( 0.0 )  end
      end
    end;

    if ide_obj.knd = idek_tabflt then
    begin { We create an array of LSQ Variables }
      lsq_id_count := lsq_id_count + aaf^.ide_all;
      NEW( ide_taberr, aaf^.ide_all );          { Allocate the related sigma table }
      tbs := USR_ELTAB_SCINIT( ide_asr );       { Initialize the index scan }
      for ii := 1 to aaf^.ide_all do
      begin
        WRITEV( stn, ide_name^ );
        USR_ELTAB_SCAN( tbs, stn, bnd );        { Create the index reference and skip for next (bnd = true when it is the last elem.) }
        if btv then
        begin
          if sy = comma then INSYMBOL
                        else SRC_ERROR( mdnam, 29, e_error );
          val := GET_FLTEXPR( val );
          if sy = colon then begin  INSYMBOL; sig := GET_FLTEXPR( sig )  end
        end;
        aaf^.ide_ftb[ii] := val;
        ide_taberr^.ide_ftb[ii] := sig;
        WRITELN( pcd, ORD( nd_varbl ):4, ' ', ide_sequnb + ii - 1:6,  ' ', val:16:8, ' ', sig:16:8, ' ', stn.length:3, ' ', stn )
      end;
      USR_ELTAB_SCEND( tbs );
      if btv then
        if sy = rparen then INSYMBOL
                       else SRC_ERROR( mdnam, 23, e_error )
    end
    else { We create a single of LSQ Variable }
    begin
      lsq_id_count := lsq_id_count + 1;
      flt := val; ide_parerr := sig;
      WRITELN( pcd, ORD( nd_varbl ):4, ' ', ide_sequnb:6, ' ', val:16:8, ' ', sig:16:8, ide_name^.length:3, ' ', ide_name^ )
    end
  end
end DCP_DEF_LSQ_VARBL;



[global]
procedure DCP_ASS_LSQ_VARBL( ip: ide_ptr );
{ Call tp complete a (LSQ) VARIABLE <name> [ := <initial value> [ : <initial_std_err> ]] declaration }
const
  mdnam = 'LSQV';

var
  bvl, btv: boolean := false;
  val, sig: mxd_flt :=   0.0;
  stn:                string;

begin
  with sy_sym, ip^, ide_obj do
  begin { In the source we can find "=" or ":=" or "," or ";" }
    if (sy = becomes) or ((sy = relop) and (op = eq_op)) then bvl := true;
    if bvl then
    begin
      INSYMBOL;
      if sy = lparen then
      begin  btv := true; sy := comma  end
      else
      begin
        val := GET_FLTEXPR( 0.0 );
        if sy = colon then
        begin  INSYMBOL; sig := GET_FLTEXPR( 0.0 )  end
      end
    end;
    if ide_obj.knd = idek_tabflt then
    begin { We create an array of LSQ Variables }
      for ii := 1 to aaf^.ide_all do
      begin
        WRITEV( stn, ide_name^, '[', ii:0, ']' );
        if btv then
        begin
          if sy = comma then INSYMBOL
                        else SRC_ERROR( mdnam, 29, e_error );
          val := GET_FLTEXPR( val );
          if sy = colon then begin  INSYMBOL; sig := GET_FLTEXPR( sig )  end
        end;
        aaf^.ide_ftb[ii] := val;
        WRITELN( pcd, ORD( nd_varbldf ):4, ' ', stn.length:3, ' ', stn, ' ', val:16:8, ' ', sig:16:8 )
      end;
      if btv then
        if sy = rparen then INSYMBOL
                       else SRC_ERROR( mdnam, 23, e_error )
    end
    else { We create a single of LSQ Variable }
    begin
      flt := val;
      WRITELN( pcd, ORD( nd_varbldf ):4, ' ', ide_name^.length:3, ' ', ide_name^, ' ', val:16:8, ' ', sig:16:8 )
    end
  end
end DCP_ASS_LSQ_VARBL;







[global]
procedure DCP_DEF_LSQ_PARM( ip: ide_ptr );
{ Call tp complete a (LSQ) PARAM <name> = <expression> declaration }
var
  bvl, btv: boolean := false;
  val, sig: mxd_flt :=   0.0;
  stn:                string;

begin
end DCP_DEF_LSQ_PARM;





end MXD_DCP_LSQ.
