{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*        MXD   Data   Compiler   Least-Squares   Specific   Routines          *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module MXD_DCP_LSQ;


  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }



const
  null_file = 'NL:';


{**************************************************}
{*******          Type Declarations          ******}
{**************************************************}




{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }

var
  curr_idname:        str_ptr :=   nil; { Current identifier name pointer to search (when not in sy_ident) }

  module_status:      boolean := false; { Current module status flag }

  com_str:            string  :=    ''; { Common string for local function }





{ ************************************************************************************* }
{ ***  Global Variables of MXD-Data ComPiler environment declared with init values  *** }
{ ************************************************************************************* }



  ndcod_tab:  [static] array[ope_stm] of node_code := [
            nd_not,     nd_neg,     nd_neg,     nd_ipw, {     stm_not,     stm_neg,     stm_fng,     stm_iip }
            nd_ipw,     nd_pow,     nd_mul,     nd_mul, {     stm_fip,     stm_ffp,     stm_iml,     stm_fml }
           nd_idiv,     nd_mod,     nd_rem,     nd_div, {     stm_idv,     stm_mod,     stm_rem,     stm_fdv }
            nd_add,     nd_add,     nd_sub,     nd_sub, {     stm_iad,     stm_fad,     stm_isb,     stm_fsb }
            nd_nop,     nd_nop,      nd_eq,      nd_eq, {     stm_ssc,     stm_seq,     stm_ieq,     stm_feq }
            nd_nop,      nd_ne,      nd_ne,     nd_nop, {     stm_sne,     stm_ine,     stm_fne,     stm_slt }
             nd_lt,      nd_lt,     nd_nop,      nd_le, {     stm_ilt,     stm_flt,     stm_sle,     stm_ile }
             nd_le,     nd_nop,      nd_ge,      nd_ge, {     stm_fle,     stm_sge,     stm_ige,     stm_fge }
            nd_nop,      nd_gt,      nd_gt,     nd_and, {     stm_sgt,     stm_igt,     stm_fgt,     stm_and }
            nd_xor,      nd_or,     nd_abs,     nd_abs, {     stm_xor,      stm_or,    stm_iabs,    stm_fabs }
           nd_sqrt,    nd_sinr,    nd_cosr,    nd_tanr, {    stm_sqrt,    stm_sinr,    stm_cosr,    stm_tanr }
          nd_asinr,   nd_acosr,   nd_atanr,  nd_phaser, {   stm_asinr,   stm_acosr,   stm_atanr,  stm_phaser }
           nd_sind,    nd_cosd,    nd_tand,   nd_asind, {    stm_sind,    stm_cosd,    stm_tand,   stm_asind }
          nd_acosd,   nd_atand,  nd_phased,     nd_exp, {   stm_acosd,   stm_atand,  stm_phased,     stm_exp }
             nd_ln,    nd_tanh,   nd_bessj,  nd_bessjh, {      stm_ln,    stm_tanh,   stm_bessj,  stm_bessjh }
       nd_interpol,  nd_integr,    nd_summ,             { stm_interpol, stm_integr,    stm_summ              }
            nd_nop,     nd_nop,     nd_nop,     nd_nop, {     stm_csi,     stm_csf,     stm_cis,     stm_cif }
            nd_nop,   nd_trunc,   nd_round,     nd_nop  {     stm_cfs,     stm_cfi,     stm_rnd,     stm_nop }
        ];



{ *************************************************************************************
  *                                                                                   *
  *                                                                                   *
  *        Least-Squares   Specific   Routines  for the MXD-V4 Data Compiler          *
  *                                                                                   *
  *                                                                                   *
  *************************************************************************************
}


[global]
procedure DCP_LSQ_INIT;
begin
  OPEN( pcd, null_file, [error_file,write_file] );
  if iostatus <> 0 then
  begin
    WRITELN( ' *** ', task_name, ' ERROR : Cannot Create the output MXD-PCODE file "NL:".' );
    PASCAL_EXIT( 4 )                        { Stop on this fatal error }
  end
end DCP_LSQ_INIT;



procedure DCP_LSQ_MODULE( str: str_ptr );
const
  mdnam = 'LDMD';

begin
  if str <> nil then
    if str^.length = 0 then str := nil;
  CLOSE( pcd );
  if str = nil then OPEN( pcd, null_file, [error_file,write_file] )
               else OPEN( pcd, str^, [error_file,write_file] );
  if iostatus <> 0 then
  begin
    SRC_ERROR_S( mdnam, 851, e_fatal, str^ );
    PASCAL_EXIT( 4 )                        { Stop on this fatal error }
  end
end DCP_LSQ_MODULE;



[global]
procedure DCP_LSQ_SUMMARY;
begin
  CLOSE( pcd );                         { Close the current Pcode file }
  DATA_WRITE_INDEX;                     { Write the data index when required }
  if error_result >= e_warning then
  begin
    LST_SKIP_LINE( 3 );
    if error_cnt[error_result] > 0 then
    begin
      WRITEV( com_str, '  * * *   Some ' );
      case error_result of
        e_warning: WRITEV( com_str:false, 'Warning' );
        e_error:   WRITEV( com_str:false, 'Error' );
        e_severe:  WRITEV( com_str:false, 'Severe Error' );
        e_fatal:   WRITEV( com_str:false, 'Fatal Error' );
      otherwise
      end;
      WRITEV( com_str:false, ' was detected.   * * *' );
      LST_NEWLINE;
      LST_PUT_STRING( com_str )
    end;
    LST_EOLN; LST_EOLN
  end
end DCP_LSQ_SUMMARY;



[global]
function DCP_LSQ_INTIDE( nsz: integer := 1 ): integer;
var
  re: integer;

begin
  re := ide_seq_count;
  ide_seq_count := re + nsz;
  DCP_LSQ_INTIDE := re
end DCP_LSQ_INTIDE;



[global]
procedure OUT_ND_CODE( nd: node_code );
begin
  if nd <> nd_nop then WRITELN( pcd, ORD( nd ):4 )
end OUT_ND_CODE;



[global]
procedure OUT_STM_CODE( stm: ope_stm );
var
  nd: node_code;

begin
  nd := ndcod_tab[stm];
  if nd <> nd_nop then WRITELN( pcd, ORD( nd ):4 )
end OUT_STM_CODE;



procedure OUT_PCD_STRING( str: str_ptr );
begin
  if str <> nil then
    if str^.length > 0 then WRITE( pcd, ' ', str^.length:4, ' ', str^ )
                       else str := nil;
 if str = nil then WRITE( pcd, ' ', 0:4 )
end OUT_PCD_STRING;



[global]
procedure OUT_LSQ_VAR_PAR_DCLCH( ip: ide_ptr; bvar: boolean );
{ To define a new LSQ variable (scalar or array of), or
  a new LSQ parameter (scalar => normal definition, Array => Parameter name set).
}
var
  bnd:        boolean := false;
  tbs:                 tbs_ptr;
  nd:                node_code;

begin
  with sy_sym, ip^, idev_val do
  begin
    if val_frm = vfrm_afl then
    begin { We have create or modify an array of LSQ Variables }
      if bvar then nd := nd_defvar
              else nd := nd_paname;
      tbs := USR_ELTAB_SCINIT( ide_typ );       { Initialize the index scan }
      for ii := 1 to aaf^.val_all do
      begin
        WRITEV( com_str, ide_name^ );
        USR_ELTAB_SCAN( tbs, com_str, bnd );    { Create the index reference and skip for next (bnd = true when it is the last elem.) }
        WRITE( pcd, ORD( nd ):4, ' ', idev_sequnb + ii - 1:8 );
        if bvar then WRITE( pcd, ' ', aaf^.val_ftb[ii], ' ', asg^.val_ftb[ii] );
        WRITELN( pcd, com_str.length:4, ' ', com_str )
      end;
      USR_ELTAB_SCEND( tbs )
    end
    else { We create a single of LSQ Variable/Parameter }
    begin
      if bvar then nd := nd_defvar
              else nd := nd_defpar;
      WRITE( pcd, ORD( nd ):4, ' ', idev_sequnb:8 );
      if bvar then WRITE( pcd, ' ', flt, ' ', sig );
      WRITELN( pcd, ide_name^.length:4, ' ', ide_name^ )
    end
  end
end OUT_LSQ_VAR_PAR_DCLCH;



[global]
procedure OUT_RETPAR_DEF( var rec: exp_rec );
{ Routine to define no named LSQ_PARM in the pcd file for the return value of a mfunction.
  The nsq number is set and copied to the identifier for the first access.
}
begin
  with rec do
  begin
    if ret_seq_count = 0 then
      ret_seq_count := DCP_LSQ_INTIDE( ret_seq_incr );
    exp_nsq := ret_seq_count;
    WRITELN( pcd, ORD( nd_defpar ):4, ' ', ret_seq_count+exp_shf:8, ' ', 0:4 )
  end
end OUT_RETPAR_DEF;



[global]
procedure OUT_PCD_VREF( var exp: exp_rec; binv: boolean := false );
{ Routine to output any object (LSQ Var, LSQ Parm, Coeff, Int_Var/Index, Cte or Item and Item Field) reference.
}
var
  isq, idx: integer;

begin
  with exp, exp_val do
  if not (objf_lsqex in exp_flg) then
  begin
    case val_frm of
      vfrm_str: begin  WRITELN( pcd, ORD( nd_string ):4 ); OUT_PCD_STRING( str ); WRITELN( pcd )  end;

      vfrm_int: WRITELN( pcd, ORD( nd_konst ):4, ' ', int:0 );

      vfrm_ein:
        if aai <> nil then WRITELN( pcd, ORD( nd_konst ):4, ' ', aai^.val_itb[exp_shf+1]:0 );

      vfrm_efl,
      vfrm_flt:
        if exp_nsq > 0 then
          if exp_flg*[objf_lsqva,objf_lsqpa,objf_retva,objf_lsqiv,objf_lsqda] <> [] then
            WRITELN( pcd, ORD( nd_refer ):4, ' ', exp_nsq+exp_shf:8 )
          else
            WRITELN( pcd, ORD( nd_coeff ):4, ' ', exp_nsq+exp_shf:8 )
        else
          if val_frm = vfrm_efl then WRITELN( pcd, ORD( nd_konst ):4, ' ', aaf^.val_ftb[exp_shf+1] )
                                else WRITELN( pcd, ORD( nd_konst ):4, ' ', flt );

      vfrm_afl:
        if exp_nsq > 0 then
        begin
          isq := exp_nsq + exp_shf;
          for ii := 1 to exp_esz do
          begin
            if exp_flg*[objf_lsqva,objf_lsqpa,objf_lsqtb,objf_retva,objf_lsqiv,objf_lsqda] <> [] then
              WRITELN( pcd, ORD( nd_refer ):4, ' ', isq:8 )
            else
              WRITELN( pcd, ORD( nd_coeff ):4, ' ', isq:8 );
            isq := isq + 1
          end
        end
        else
        if objf_lsqtb in exp_flg then
        begin { Table to export (for interpolation or integration) }
          if exp_ref <> nil then
          with exp_ref^ do
            if idev_sequnb = 0 then 
            begin
              idev_sequnb := DCP_LSQ_INTIDE;
              if aaf <> nil then
              with aaf^ do
              begin
                WRITELN( pcd, ORD( nd_tabref ):4, ' ', idev_sequnb:8, ' ', exp_esz:8 );
                idx := exp_shf;
                for ii := 1 to exp_esz do
                begin
                  idx := idx + 1; WRITE( pcd, ' ', aaf^.val_ftb[idx] );
                  if ii mod 8 = 0 then WRITELN( pcd )
                end;
                if exp_esz mod 8 <> 0 then WRITELN( pcd )
              end
            end
            else WRITELN( pcd, ORD( nd_refer ):4, ' ', idev_sequnb:8 )
        end
          else
            for ii := 1 to exp_esz do
              WRITELN( pcd, ORD( nd_konst ):4, ' ', aaf^.val_ftb[exp_shf+ii] );

      vfrm_itm:
        if itm <> nil then
        with itm^ do
          if itm_typ <> nil then
            WRITELN( pcd, ORD( nd_itmref ):4, ' ', itm_typ^.typ_pcd:2, ' ', itm_sequ:8 );

      vfrm_itf:  WRITELN( pcd, ORD( nd_itmfldr ):4, ' ', ifo:6 );

      vfrm_null: repeat WRITELN( pcd, ORD( nd_null ):4 ); exp_esz := exp_esz - 1 until exp_esz <= 0;

    otherwise
    end;
    if binv then WRITELN( pcd, ORD( nd_permut ):4 );
    exp_flg := exp_flg + [objf_lsqex]
  end
end OUT_PCD_VREF;



[global]
procedure OUT_ITEM_FREF( var exp: exp_rec; itmrcd, itmiid, offset: integer );
var
  iid: integer;

begin
  with exp do
  begin
    exp_flg := exp_flg + [objf_lsqob,objf_lsqex];
    exp_nsq := ide_seq_count + exp_shf;
    if exp_esz > 1 then
    begin
      ide_seq_count := ide_seq_count + exp_esz;
      iid := exp_nsq;
      for ii := 1 to exp_esz do
      begin
        WRITELN( pcd, ORD( nd_itmfldr ):4, ' ', itmrcd:4, ' ', itmiid:8, ' ', iid:8, ' ', offset:6 );
        offset := offset + 1; iid := iid + 1
      end;
      { Set the flags to signal the stack as empty with a (simulated) returned value }
      exp_flg := exp_flg + [objf_retva] - [objf_lsqex]
    end
    else
    begin
      WRITELN( pcd, ORD( nd_itmfldr ):4, ' ', itmrcd:4, ' ', itmiid:8, ' ', 0:8, ' ', offset:6 );
      exp_flg := exp_flg + [objf_lsqex]         { Set to flag the result in the ope. stack }
    end
  end
end OUT_ITEM_FREF;



[global]
procedure DCP_DEF_LSQ_VARBL( ip: ide_ptr );
{ Call tp complete a (LSQ) VARIABLE <name> [ := <initial value> [ : <initial_std_err> ]] declaration }
begin
  with sy_sym, ip^, idev_val do
  begin
    idev_sequnb := ide_seq_count;                                               { Set the identifier sequence number }
    if val_frm = vfrm_afl then  idev_sequnb := DCP_LSQ_INTIDE( aaf^.val_all )   { We create an array of LSQ Variables }
                          else  idev_sequnb := DCP_LSQ_INTIDE;                  { We create a single of LSQ Variable }
    OUT_LSQ_VAR_PAR_DCLCH( ip, true )
  end
end DCP_DEF_LSQ_VARBL;



[global]
procedure DCP_ASS_LSQ_VARBL( var rec: exp_rec );
{ Call tp complete a  <LSQ_Varbl_Name> [ := <initial value> [ : <initial_std_err> ]] declaration }
const
  mdnam = 'LSQV';

var
  ii, jj, ns:  integer;

begin
  with rec, exp_val, exp_ref^ do
  begin
    ns := idev_sequnb;
    case val_frm of
      vfrm_flt:
        WRITELN( pcd, ORD( nd_assvar ):4, ' ', ns:8, ' ', idev_val.flt, ' ', idev_val.sig );

      vfrm_efl,
      vfrm_afl:
        begin
          ii := exp_shf+1;
          ns := ns + exp_shf;
          for jj := 0 to exp_esz-1 do
          begin
            WRITELN( pcd, ORD( nd_assvar ):4, ' ', ns:8, ' ', aaf^.val_ftb[ii], ' ', asg^.val_ftb[ii] );
            ns := ns + 1; ii := ii + 1
          end
        end;
    otherwise
    end
  end
end DCP_ASS_LSQ_VARBL;




[global]
procedure DCP_DEF_LSQ_PARM( ip: ide_ptr );
{ Call to perform a (LSQ) PARAM <name> = <expression> declaration }
const
  mdnam = 'DCPA';

var
  bvl, btv: boolean := false;
  val, sig: mxd_flt :=   0.0;
  stn:                string;
  rec:               exp_rec;

begin
  with sy_sym, ip^, exp_res do
  begin
    if exp_esz = 1 then idev_sequnb := DCP_LSQ_INTIDE
                   else idev_sequnb := exp_nsq; { For array of LSQ_PARM the expression is in a ret-nnn (already numbered) of MFUNCTION }
    OUT_LSQ_VAR_PAR_DCLCH( ip, false )
  end;
end DCP_DEF_LSQ_PARM;



procedure DCP_DEF_DATA_FIELD( ip: ide_ptr );
begin
  with ip^ do
  begin
    idev_sequnb := DCP_LSQ_INTIDE;              { Assign an integer identifier to the additional data field }
    WRITELN( pcd, ORD( nd_addatf ):4, ' ', idev_sequnb:8, ' ', ide_name^.length:4, ' ', ide_name^ )
  end
end DCP_DEF_DATA_FIELD;



[global]
procedure DEFINE_SPECIFIC( ip: ide_ptr );
begin
  if ip <> nil then
  case ip^.idev_spcact of
    LSQVAR_TYPE: DCP_DEF_LSQ_VARBL( ip );

    LSQEXP_TYPE: DCP_DEF_LSQ_PARM( ip );

    LSQPDQ_TYPE: DCP_DEF_DATA_FIELD( ip );

  otherwise
    { Nothing to do }
  end
end DEFINE_SPECIFIC;



[global]
procedure ASSIGN_SPECIFIC( var rec: exp_rec );
begin
  with rec, exp_val, exp_ref^ do
  case idev_spcact of

    LSQPCD_VARBL: if str <> nil then DCP_LSQ_MODULE( str );

    JBNAME_VALUE: if str <> nil then
                    WRITELN( pcd, ORD( nd_jobname ):4, ' ', str^.length:3, ' ', str^ )
                   else
                  begin
                    LST_CHANGE_TITLE( '' );
                    WRITELN( pcd, ORD( nd_jobname ):4, ' ', 0:3 )
                  end;

    JBTITL_VALUE: if str <> nil then
                  begin
                    LST_CHANGE_TITLE( str^ );   { Set or change the job subtitle }
                    WRITELN( pcd, ORD( nd_title ):4, ' ', str^.length:3, ' ', str^ )
                  end
                  else
                  begin
                    LST_CHANGE_TITLE( '' );
                    WRITELN( pcd, ORD( nd_title ):4, ' ', 0:3 )
                  end;

    JBSAVE_FNAME: if str <> nil then
                    WRITELN( pcd, ORD( nd_savfnam ):4, ' ', str^.length:3, ' ', str^ )
                  else
                    WRITELN( pcd, ORD( nd_savfnam ):4, ' ', 0:3 );

    LSQVAR_TYPE:  DCP_ASS_LSQ_VARBL( rec );

(*
  LSQEXP_TYPE   =           12;                 { Least-Squares Expression (MXD-V3 PARAM name = expr;) Specific Action Index }
  LSQITR_TYPE   =           13;                 { Least-Squares item field reference }
  LSQFTB_TYPE   =           14;                 { Least-Squares table Specific Action Index }
  LSQPQT_TYPE   =           15;                 { Least-Squares Predefined Quantity Specific Action Index }
  LSQPDQ_TYPE   =           16;                 { Least-Squares Data list Predefined Quantity Specific Action Index }
*)

  otherwise
    { Nothing to do }
  end
end ASSIGN_SPECIFIC;



[global]
procedure OUT_PCD_DIRECTIVE( cd, nsq, npa: integer; var extb: array[sz: integer] of exp_rec; brf: boolean );
var
  ict: integer;


  procedure OUT_ARG( var exp: exp_rec; brf: boolean );
  var
    idx, isq: integer;

  begin
    with exp, exp_val do
    begin
      if exp_ref = nil then brf := false;
      case val_frm of
        vfrm_str: OUT_PCD_STRING( str );

        vfrm_int: WRITE( pcd, ' ', int:0 );

        vfrm_flt: if brf then WRITE( pcd, ' ', exp_nsq:8 )
                         else WRITE( pcd, ' ', flt );

        vfrm_ein: if aai <> nil then WRITE( pcd, ' ', aai^.val_itb[exp_shf+1]:0 );

        vfrm_efl: if exp_nsq > 0 then WRITE( pcd, ' ', exp_nsq+exp_shf:8 )
                                 else if aaf <> nil then WRITE( pcd, ' ', aaf^.val_ftb[exp_shf + 1] );

        vfrm_ain: if aai <> nil then WRITE( pcd, ' ', aai^.val_itb[exp_shf + ict + 1] );

        vfrm_afl:
          begin
            idx := exp_shf + ict;
            if exp_nsq > 0 then isq := exp_nsq + idx
                           else isq := 0;
            if isq > 0 then WRITE( pcd, ' ', isq:8 )
                       else if aaf <> nil then WRITE( pcd, ' ', aaf^.val_ftb[idx+1] )
          end;

        vfrm_itm:
          if itm <> nil then
          with itm^ do
            if itm_typ <> nil then
              WRITELN( pcd, ' ', itm_typ^.typ_pcd:2, ' ', itm_sequ:8 );

      otherwise
      end
    end
  end OUT_ARG;


begin { OUT_PCD_DIRECTIVE }
  ict := 0;
  repeat
    WRITE( pcd, ORD( nd_directive ):4, ' ', cd:8, ' ', nsq:8, ' ', npa:4 );
    for ii := 1 to npa do OUT_ARG( extb[ii], brf );
    WRITELN( pcd );
    ict := ict + 1
  until ict >= extb[npa].exp_esz
end OUT_PCD_DIRECTIVE;



[global]
procedure OUT_PCD_LINDEX( id: ide_ptr );
begin
  if id <> nil then
  with id^ do
  begin
    idev_sequnb := DCP_LSQ_INTIDE; 
    WRITE( pcd, ORD( nd_definv ):4, ' ', idev_sequnb:8, ' ' );
    if ide_name <> nil then
      if ide_name^.length > 0 then WRITELN( pcd, ide_name^.length:3, ' ', ide_name^ )
                              else WRITELN( pcd, 0:3 )
    else WRITELN( pcd, 0:3 )
  end
end OUT_PCD_LINDEX;



[global]
procedure OUT_PCD_CONST( val: mxd_flt );
begin
  WRITELN( pcd, ORD( nd_konst ):4, ' ', val )
end OUT_PCD_CONST;



[global]
procedure OUT_PCD_INTSUMM_ND( intg: boolean );
var
  nd: node_code;

begin
  if intg then nd := nd_integr
          else nd := nd_summ;
  WRITELN( pcd, ORD( nd ):4 )
end OUT_PCD_INTSUMM_ND;



[global]
procedure OUT_PCD_SELECT( narg: integer );
begin
  WRITELN( pcd, ORD( nd_select ):4, ' ', narg:4 )
end OUT_PCD_SELECT;



[global]
procedure ITEM_EXPORT( itm: itm_ptr );
const
  mdnam = 'ITME';

var
  typ, tpa:    typ_ptr;
  ito, npa:    integer;
  eol:         boolean;

  procedure OUT_CONST_VALUES( var val: val_rec; pnam: str_ptr );
  begin
    with val do
      case val_frm of
        vfrm_str:
          begin
            eol := true;
            if str <> nil then
            begin
              WRITE( pcd, str^.length:4 ); if str^.length > 0 then WRITE( pcd, ' ', str^ )
            end
            else WRITE( pcd, 0:4 );
            WRITELN( pcd )
          end;

        vfrm_int: if abs( int ) < 100 then WRITE( pcd, ' ', int:5 )
                                      else WRITE( pcd, ' ', int:0 );

        vfrm_flt: WRITE( pcd, ' ', flt );

        vfrm_itm: if itm = nil then WRITE( pcd, ' ', 0:8 )
                               else WRITE( pcd, ' ', itm^.itm_sequ:8 );

        vfrm_null: WRITE( pcd, ' ', 0:8 );

      otherwise
        SRC_ERROR_S( mdnam, 290, e_error, pnam^ )
      end
  end OUT_CONST_VALUES;



begin
  if itm <> nil then typ := itm^.itm_typ;
  if typ <> nil then
  with itm^, typ^ do
  begin
    WRITEV( com_str, itm_name^, ';', itm_nver:0 );
    tpa := typ;
    while tpa^.typ_par <> nil do tpa := typ_par;
    if itm_ablk <> nil then ito := itm_ablk^.itm_sequ
                       else ito := 0;
    if itmf_fix in typ_ifl then npa := 0
                           else npa := tpa^.typ_nfl - tpa^.typ_nid;

    WRITELN( pcd, ORD( nd_item ):4, ' ', typ_pcd:2, ' ', npa:2, ' ', itm_sequ:8, ' ', ito:8, ' ', com_str.length:4, ' ', com_str );
    if typ_nid > 0 then
    begin
      eol := false;
      for ii := 1 to typ_nid do OUT_CONST_VALUES( itm_tab[ii], itm_name );
      if not eol then WRITELN( pcd )
    end;
    if itmf_fix in typ_ifl then
    begin
      eol := false;
      for ii := typ_nid+1 to typ_nfl do OUT_CONST_VALUES( itm_tab[ii], itm_name );
      if not eol then WRITELN( pcd )
    end
  end
end ITEM_EXPORT;



[global]
procedure DATA_ITEM_EXPORT( datp: dat_ptr );
var
  tpa:         typ_ptr;

begin
  with datp^, data_desc do
  if data_itmp <> nil then
  if data_itmp^.itm_typ <> nil then
  begin
    WRITEV( com_str, dat_name.body:dat_name.length, ';', dat_nver:0 );
    with data_itmp^, itm_typ^ do
    begin
      tpa := itm_typ;
      while tpa^.typ_par <> nil do tpa := typ_par;
      WRITELN( pcd, ORD( nd_data ):4, ' ', typ_pcd:2, ' ', tpa^.typ_nid:2, ' ', itm_sequ:8, ' ', com_str.length:4, ' ', com_str );
      WRITELN( pcd, ' ':4, dat_filnbr:4, ' ', dat_nrec:8 );
      WRITE( pcd, dat_adln:4 );
      for ii := 1 to dat_adln do WRITE( pcd, dat_adtb[ii]:5 );
      WRITELN( pcd )
    end
  end
end DATA_ITEM_EXPORT;


end MXD_DCP_LSQ.
