/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[2];

/* Define the local data section. */
static Blk( Rd, 664 ) = {
 12,  12, 100,  99, 112,  95, 108, 115, 113,  95, 105, 110, 105, 116,  54,  54,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,
 86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95, 100,  99, 112,  95, 108,
115, 113,  46, 112,  97, 115,   3,   3,  78,  76,  58,   5,   5,  32,  42,  42,
 42,  32,   7,   7,  77,  88,  68,  45,  68,  67,  80,  55,  55,  32,  69,  82,
 82,  79,  82,  32,  58,  32,  67,  97, 110, 110, 111, 116,  32,  67, 114, 101,
 97, 116, 101,  32, 116, 104, 101,  32, 111, 117, 116, 112, 117, 116,  32,  77,
 88,  68,  45,  80,  67,  79,  68,  69,  32, 102, 105, 108, 101,  32,  34,  78,
 76,  58,  34,  46,  14,  14, 100,  99, 112,  95, 108, 115, 113,  95, 109, 111,
100, 117, 108, 101,   4,   4,  76,  68,  77,  68,  15,  15, 100,  99, 112,  95,
108, 115, 113,  95, 115, 117, 109, 109,  97, 114, 121,  15,  15,  32,  32,  42,
 32,  42,  32,  42,  32,  32,  32,  83, 111, 109, 101,  32,   7,   7,  87,  97,
114, 110, 105, 110, 103,   5,   5,  69, 114, 114, 111, 114,  12,  12,  83, 101,
118, 101, 114, 101,  32,  69, 114, 114, 111, 114,  11,  11,  70,  97, 116,  97,
108,  32,  69, 114, 114, 111, 114,  22,  22,  32, 119,  97, 115,  32, 100, 101,
116, 101,  99, 116, 101, 100,  46,  32,  32,  32,  42,  32,  42,  32,  42,  14,
 14, 100,  99, 112,  95, 108, 115, 113,  95, 105, 110, 116, 105, 100, 101,  11,
 11, 111, 117, 116,  95, 110, 100,  95,  99, 111, 100, 101,  12,  12, 111, 117,
116,  95, 115, 116, 109,  95,  99, 111, 100, 101,  14,  14, 111, 117, 116,  95,
112,  99, 100,  95, 115, 116, 114, 105, 110, 103,  21,  21, 111, 117, 116,  95,
108, 115, 113,  95, 118,  97, 114,  95, 112,  97, 114,  95, 100,  99, 108,  99,
104,  14,  14, 111, 117, 116,  95, 114, 101, 116, 112,  97, 114,  95, 100, 101,
102,  12,  12, 111, 117, 116,  95, 112,  99, 100,  95, 118, 114, 101, 102,  13,
 13, 111, 117, 116,  95, 105, 116, 101, 109,  95, 102, 114, 101, 102,  17,  17,
100,  99, 112,  95, 100, 101, 102,  95, 108, 115, 113,  95, 118,  97, 114,  98,
108,  17,  17, 100,  99, 112,  95,  97, 115, 115,  95, 108, 115, 113,  95, 118,
 97, 114,  98, 108,  16,  16, 100,  99, 112,  95, 100, 101, 102,  95, 108, 115,
113,  95, 112,  97, 114, 109,  18,  18, 100,  99, 112,  95, 100, 101, 102,  95,
100,  97, 116,  97,  95, 102, 105, 101, 108, 100,  15,  15, 100, 101, 102, 105,
110, 101,  95, 115, 112, 101,  99, 105, 102, 105,  99,  15,  15,  97, 115, 115,
105, 103, 110,  95, 115, 112, 101,  99, 105, 102, 105,  99,   0,   0,   0,   0,
  7,   7, 111, 117, 116,  95,  97, 114, 103,  17,  17, 111, 117, 116,  95, 112,
 99, 100,  95, 100, 105, 114, 101,  99, 116, 105, 118, 101,  14,  14, 111, 117,
116,  95, 112,  99, 100,  95, 108, 105, 110, 100, 101, 120,  13,  13, 111, 117,
116,  95, 112,  99, 100,  95,  99, 111, 110, 115, 116,  18,  18, 111, 117, 116,
 95, 112,  99, 100,  95, 105, 110, 116, 115, 117, 109, 109,  95, 110, 100,  14,
 14, 111, 117, 116,  95, 112,  99, 100,  95, 115, 101, 108, 101,  99, 116,  16,
 16, 111, 117, 116,  95,  99, 111, 110, 115, 116,  95, 118,  97, 108, 117, 101,
115,   4,   4,  73,  84,  77,  69,  11,  11, 105, 116, 101, 109,  95, 101, 120,
112, 111, 114, 116,  16,  16, 100,  97, 116,  97,  95, 105, 116, 101, 109,  95,
101, 120, 112, 111, 114, 116,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 328 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,  21,  22,  22,  24,  24,  23,  25,  25,  27,  28,  29,  26,  30,  30,  31,
 31,  67,  67,  32,  32,  67,  33,  33,  67,  34,  34,  67,  35,  35,  67,  36,
 36,  67,  37,  37,  38,  39,  40,  41,  41,  42,  43,  44,  45,  46,  47,  48,
 49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,
 67,  67,  67,  67,  67,  65,  66,  67
};

/* Declaration of external variables. */
extern V V_pcd;
extern SL PAS__iostatus;
extern V PAS__f_output;
extern UB V_error_result;
extern Blk(V_error_cnt, 24 );
extern UL V_ide_seq_count;
extern UL V_ret_seq_count;
extern UL V_ret_seq_incr;
extern Blk(V_exp_res, 48 );


/* Function/procedure prototypes. */
void P_lst_change_title(V F_str, UB F_bskp);
void P_lst_newline();
void P_lst_eoln();
void P_lst_skip_line(SL F_nli);
void P_lst_put_string(V F_str);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
V P_usr_eltab_scinit(V F_typ);
void P_usr_eltab_scan(V F_tbs, V F_sindex, UB *F_bend);
void P_usr_eltab_scend(V F_tbs);
void P_data_write_index();


/* Procedure/Function : " dcp_lsq_init "  */
void P_dcp_lsq_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=172; /* line # 172 */
  PAS__OPEN(&V_pcd,0, Rd.s+70,4098,0,-1);
  Ra.sl[3]=173; /* line # 173 */
  if (PAS__iostatus!=0) {
    Ra.sl[3]=175; /* line # 175 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+75,-1,-1,32);
    PAS__WRITE_STR(Rd.s+82,-1,-1,32);
    PAS__WRITE_STR(Rd.s+91,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=176; /* line # 176 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_lsq_module "  */
void MXD_DCP_LSQ_dcp_lsq_module(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+148;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=187; /* line # 187 */
  if (F_str!=NULL) {
    Ra.sl[3]=188; /* line # 188 */
    if (((UB *)F_str)[1]==0) F_str=NULL;
  }
  Ra.sl[3]=189; /* line # 189 */
  PAS__CLOSE(&V_pcd,0);
  Ra.sl[3]=190; /* line # 190 */
  if (F_str==NULL) PAS__OPEN(&V_pcd,0, Rd.s+70,4098,0,-1);
  else {
    Ra.sl[3]=191; /* line # 191 */
    PAS__OPEN(&V_pcd,0, F_str,4098,0,-1);
  }
  Ra.sl[3]=192; /* line # 192 */
  if (PAS__iostatus!=0) {
    Ra.sl[3]=194; /* line # 194 */
    P_src_error_s(Rd.s+166,851,4, F_str,NULL);
    Ra.sl[3]=195; /* line # 195 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_lsq_summary "  */
void P_dcp_lsq_summary(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=204; /* line # 204 */
  PAS__CLOSE(&V_pcd,0);
  Ra.sl[3]=205; /* line # 205 */
  P_data_write_index();
  Ra.sl[3]=206; /* line # 206 */
  if (V_error_result>=1) {
    Ra.sl[3]=208; /* line # 208 */
    P_lst_skip_line(3);
    Ra.sl[3]=209; /* line # 209 */
    if (V_error_cnt.sl[V_error_result]>0) {
      Ra.sl[3]=211; /* line # 211 */
      PAS__VWRITE_INIT(Ri.s,1);
      PAS__WRITE_STR(Rd.s+187,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=212; /* line # 212 */
      switch (V_error_result) {
        case 1:Ra.sl[3]=213; /* line # 213 */
        PAS__VWRITE_INIT(Ri.s,0);
        PAS__WRITE_STR(Rd.s+204,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 2:Ra.sl[3]=214; /* line # 214 */
        PAS__VWRITE_INIT(Ri.s,0);
        PAS__WRITE_STR(Rd.s+213,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 3:Ra.sl[3]=215; /* line # 215 */
        PAS__VWRITE_INIT(Ri.s,0);
        PAS__WRITE_STR(Rd.s+220,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 4:Ra.sl[3]=216; /* line # 216 */
        PAS__VWRITE_INIT(Ri.s,0);
        PAS__WRITE_STR(Rd.s+234,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        default:break;
      }
      Ra.sl[3]=219; /* line # 219 */
      PAS__VWRITE_INIT(Ri.s,0);
      PAS__WRITE_STR(Rd.s+247,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=220; /* line # 220 */
      P_lst_newline();
      Ra.sl[3]=221; /* line # 221 */
      P_lst_put_string(Ri.s);
    }
    Ra.sl[3]=223; /* line # 223 */
    P_lst_eoln();
    P_lst_eoln();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_lsq_intide "  */
SL P_dcp_lsq_intide(SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+271;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=235; /* line # 235 */
  Rv0=V_ide_seq_count;
  Ra.sl[3]=236; /* line # 236 */
  V_ide_seq_count=Rv0+F_nsz;
  Ra.sl[3]=237; /* line # 237 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " out_nd_code "  */
void P_out_nd_code(UB F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+287;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=245; /* line # 245 */
  if (F_nd!=67) {
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT((SL)F_nd,4,0);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_stm_code "  */
void P_out_stm_code(UB F_stm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+300;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=256; /* line # 256 */
  Rv0=Ri.ub[F_stm+257];
  Ra.sl[3]=257; /* line # 257 */
  if (Rv0!=67) {
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT((SL)Rv0,4,0);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_string "  */
void MXD_DCP_LSQ_out_pcd_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+314;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=264; /* line # 264 */
  if (F_str!=NULL) {
    Ra.sl[3]=265; /* line # 265 */
    if (((UB *)F_str)[1]>0) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((UB *)F_str)[1],4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(F_str,-1,-1,32);
    }
    else {
      Ra.sl[3]=266; /* line # 266 */
      F_str=NULL;
    }
  }
  Ra.sl[3]=267; /* line # 267 */
  if (F_str==NULL) {
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(0,4,0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_lsq_var_par_dclch "  */
void P_out_lsq_var_par_dclch(V F_ip, UB F_bvar){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+330;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=283; /* line # 283 */
  Rv1=F_ip;
  Rv2=Rv1+40;
  Ra.sl[3]=285; /* line # 285 */
  if (((UB *)Rv2)[1]==8) {
    Ra.sl[3]=287; /* line # 287 */
    if (F_bvar) Rv3=12;
    else {
      Ra.sl[3]=288; /* line # 288 */
      Rv3=7;
    }
    Ra.sl[3]=289; /* line # 289 */
    Rv4=P_usr_eltab_scinit(((V *)Rv1)[4]);
    Ra.sl[3]=290; /* line # 290 */
    Rv5=1;
    for( Rf0=((SL *)((V *)Rv2)[1])[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=292; /* line # 292 */
      PAS__VWRITE_INIT(Ri.s,1);
      PAS__WRITE_STR(((V *)Rv1)[0],-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=293; /* line # 293 */
      P_usr_eltab_scan(Rv4, Ri.s,&Rv0);
      Ra.sl[3]=294; /* line # 294 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT((SL)Rv3,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT((((SL *)Rv1)[8]+Rv5)-1,8,0);
      Ra.sl[3]=295; /* line # 295 */
      if (F_bvar) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_DBLE(((G *)((V *)Rv2)[1])[Rv5],24,-15,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_DBLE(((G *)((V *)Rv2)[2])[Rv5],24,-15,0);
      }
      Ra.sl[3]=296; /* line # 296 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(Ri.ub[1],4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(Ri.s,-1,-1,32);
      PAS__WRITE_EOLN();
      Rv5++;
    }
    Ra.sl[3]=298; /* line # 298 */
    P_usr_eltab_scend(Rv4);
  }
  else {
    Ra.sl[3]=302; /* line # 302 */
    if (F_bvar) Rv3=12;
    else {
      Ra.sl[3]=303; /* line # 303 */
      Rv3=13;
    }
    Ra.sl[3]=304; /* line # 304 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT((SL)Rv3,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv1)[8],8,0);
    Ra.sl[3]=305; /* line # 305 */
    if (F_bvar) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)Rv2)[1],24,-15,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)Rv2)[2],24,-15,0);
    }
    Ra.sl[3]=306; /* line # 306 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(((UB *)((V *)Rv1)[0])[1],4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(((V *)Rv1)[0],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_retpar_def "  */
void P_out_retpar_def(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+353;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=319; /* line # 319 */
  Ra.sl[3]=321; /* line # 321 */
  if (V_ret_seq_count==0) {
    Ra.sl[3]=322; /* line # 322 */
    V_ret_seq_count=P_dcp_lsq_intide(V_ret_seq_incr);
  }
  Ra.sl[3]=323; /* line # 323 */
  ((SL *)F_rec)[2]=V_ret_seq_count;
  Ra.sl[3]=324; /* line # 324 */
  PAS__SELECT_OUT(V_pcd);
  PAS__WRITE_INT(13,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(V_ret_seq_count+((SL *)F_rec)[4],8,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(0,4,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_vref "  */
void P_out_pcd_vref(V F_exp, UB F_binv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register V Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+369;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=338; /* line # 338 */
  Rv0=F_exp+24;
  Ra.sl[3]=339; /* line # 339 */
  if (!(262144&((UL *)F_exp)[5])) {
    Ra.sl[3]=341; /* line # 341 */
    switch (((UB *)Rv0)[1]) {
      case 0:Ra.sl[3]=342; /* line # 342 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(3,4,0);
      PAS__WRITE_EOLN();
      MXD_DCP_LSQ_out_pcd_string(((V *)Rv0)[1]);
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_EOLN();
      break;
      case 1:Ra.sl[3]=344; /* line # 344 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(5,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv0)[1],0,0);
      PAS__WRITE_EOLN();
      break;
      case 4:Ra.sl[3]=347; /* line # 347 */
      if (((V *)Rv0)[1]!=NULL) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_INT(5,4,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)((V *)Rv0)[1])[(((SL *)F_exp)[4]+1)],0,0);
        PAS__WRITE_EOLN();
      }
      break;
      case 2:
      case 5:Ra.sl[3]=351; /* line # 351 */
      if (((SL *)F_exp)[2]>0) {
        Ra.sl[3]=352; /* line # 352 */
        if ((((UL *)F_exp)[5]&569600)!=0) {
          Ra.sl[3]=353; /* line # 353 */
          PAS__SELECT_OUT(V_pcd);
          PAS__WRITE_INT(6,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)F_exp)[2]+((SL *)F_exp)[4],8,0);
          PAS__WRITE_EOLN();
        }
        else {
          Ra.sl[3]=355; /* line # 355 */
          PAS__SELECT_OUT(V_pcd);
          PAS__WRITE_INT(8,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)F_exp)[2]+((SL *)F_exp)[4],8,0);
          PAS__WRITE_EOLN();
        }
      }
      else {
        Ra.sl[3]=357; /* line # 357 */
        if (((UB *)Rv0)[1]==5) {
          PAS__SELECT_OUT(V_pcd);
          PAS__WRITE_INT(5,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[(((SL *)F_exp)[4]+1)],24,-15,0);
          PAS__WRITE_EOLN();
        }
        else {
          Ra.sl[3]=358; /* line # 358 */
          PAS__SELECT_OUT(V_pcd);
          PAS__WRITE_INT(5,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_DBLE(((G *)Rv0)[1],24,-15,0);
          PAS__WRITE_EOLN();
        }
      }
      break;
      case 8:Ra.sl[3]=361; /* line # 361 */
      if (((SL *)F_exp)[2]>0) {
        Ra.sl[3]=363; /* line # 363 */
        Rv1=((SL *)F_exp)[2]+((SL *)F_exp)[4];
        Ra.sl[3]=364; /* line # 364 */
        for( Rf0=((SL *)F_exp)[3];Rf0>0;Rf0-- ) {
          Ra.sl[3]=366; /* line # 366 */
          if ((((UL *)F_exp)[5]&585984)!=0) {
            Ra.sl[3]=367; /* line # 367 */
            PAS__SELECT_OUT(V_pcd);
            PAS__WRITE_INT(6,4,0);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_INT(Rv1,8,0);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[3]=369; /* line # 369 */
            PAS__SELECT_OUT(V_pcd);
            PAS__WRITE_INT(8,4,0);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_INT(Rv1,8,0);
            PAS__WRITE_EOLN();
          }
          Ra.sl[3]=370; /* line # 370 */
          Rv1=Rv1+1;
        }
      }
      else {
        Ra.sl[3]=374; /* line # 374 */
        if (16384&((UL *)F_exp)[5]) {
          Ra.sl[3]=376; /* line # 376 */
          if (((V *)F_exp)[0]!=NULL) {
            Ra.sl[3]=377; /* line # 377 */
            Rv2=((V *)F_exp)[0];
            Ra.sl[3]=378; /* line # 378 */
            if (((SL *)Rv2)[8]==0) {
              Ra.sl[3]=380; /* line # 380 */
              ((SL *)Rv2)[8]=P_dcp_lsq_intide(1);
              Ra.sl[3]=381; /* line # 381 */
              if (((V *)Rv0)[1]!=NULL) {
                Ra.sl[3]=382; /* line # 382 */
                Ra.sl[3]=384; /* line # 384 */
                PAS__SELECT_OUT(V_pcd);
                PAS__WRITE_INT(9,4,0);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_INT(((SL *)Rv2)[8],8,0);
                PAS__WRITE_CHAR(32);
                PAS__WRITE_INT(((SL *)F_exp)[3],8,0);
                PAS__WRITE_EOLN();
                Ra.sl[3]=385; /* line # 385 */
                Rv3=((SL *)F_exp)[4];
                Ra.sl[3]=386; /* line # 386 */
                Rv4=1;
                for( Rf0=((SL *)F_exp)[3];Rf0>0;Rf0-- ) {
                  Ra.sl[3]=388; /* line # 388 */
                  Rv3=Rv3+1;
                  PAS__SELECT_OUT(V_pcd);
                  PAS__WRITE_CHAR(32);
                  PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[Rv3],24,-15,0);
                  Ra.sl[3]=389; /* line # 389 */
                  if ((Rv4&7)==0) {
                    PAS__SELECT_OUT(V_pcd);
                    PAS__WRITE_EOLN();
                  }
                  Rv4++;
                }
                Ra.sl[3]=391; /* line # 391 */
                if ((((SL *)F_exp)[3]&7)!=0) {
                  PAS__SELECT_OUT(V_pcd);
                  PAS__WRITE_EOLN();
                }
              }
            }
            else {
              Ra.sl[3]=394; /* line # 394 */
              PAS__SELECT_OUT(V_pcd);
              PAS__WRITE_INT(6,4,0);
              PAS__WRITE_CHAR(32);
              PAS__WRITE_INT(((SL *)Rv2)[8],8,0);
              PAS__WRITE_EOLN();
            }
          }
        }
        else {
          Ra.sl[3]=397; /* line # 397 */
          Rv5=1;
          for( Rf0=((SL *)F_exp)[3];Rf0>0;Rf0-- ) {
            Ra.sl[3]=398; /* line # 398 */
            PAS__SELECT_OUT(V_pcd);
            PAS__WRITE_INT(5,4,0);
            PAS__WRITE_CHAR(32);
            PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[(((SL *)F_exp)[4]+Rv5)],24,-15,0);
            PAS__WRITE_EOLN();
            Rv5++;
          }
        }
      }
      break;
      case 9:Ra.sl[3]=401; /* line # 401 */
      if (((V *)Rv0)[1]!=NULL) {
        Ra.sl[3]=402; /* line # 402 */
        Rv6=((V *)Rv0)[1];
        Ra.sl[3]=403; /* line # 403 */
        if (((V *)Rv6)[8]!=NULL) {
          Ra.sl[3]=404; /* line # 404 */
          PAS__SELECT_OUT(V_pcd);
          PAS__WRITE_INT(16,4,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)((V *)Rv6)[8])[12],2,0);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_INT(((SL *)Rv6)[11],8,0);
          PAS__WRITE_EOLN();
        }
      }
      break;
      case 10:Ra.sl[3]=406; /* line # 406 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(17,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv0)[1],6,0);
      PAS__WRITE_EOLN();
      break;
      case 11:while (1){
        Ra.sl[3]=408; /* line # 408 */
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_INT(4,4,0);
        PAS__WRITE_EOLN();
        ((SL *)F_exp)[3]=((SL *)F_exp)[3]-1;
        if (((SL *)F_exp)[3]<=0)  break;
      }
      break;
      default:break;
    }
    Ra.sl[3]=412; /* line # 412 */
    if (F_binv) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(19,4,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=413; /* line # 413 */
    ((UL *)F_exp)[5]=((UL *)F_exp)[5]|262144;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_item_fref "  */
void P_out_item_fref(V F_exp, SL F_itmrcd, SL F_itmiid, SL F_offset){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+383;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=425; /* line # 425 */
  Ra.sl[3]=427; /* line # 427 */
  ((UL *)F_exp)[5]=((UL *)F_exp)[5]|393216;
  Ra.sl[3]=428; /* line # 428 */
  ((SL *)F_exp)[2]=V_ide_seq_count+((SL *)F_exp)[4];
  Ra.sl[3]=429; /* line # 429 */
  if (((SL *)F_exp)[3]>1) {
    Ra.sl[3]=431; /* line # 431 */
    V_ide_seq_count=V_ide_seq_count+((SL *)F_exp)[3];
    Ra.sl[3]=432; /* line # 432 */
    Rv0=((SL *)F_exp)[2];
    Ra.sl[3]=433; /* line # 433 */
    for( Rf0=((SL *)F_exp)[3];Rf0>0;Rf0-- ) {
      Ra.sl[3]=435; /* line # 435 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(17,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_itmrcd,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_itmiid,8,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rv0,8,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_offset,6,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=436; /* line # 436 */
      F_offset=F_offset+1;
      Rv0=Rv0+1;
    }
    Ra.sl[3]=439; /* line # 439 */
    ((UL *)F_exp)[5]=(((UL *)F_exp)[5]|256)&~262144;
  }
  else {
    Ra.sl[3]=443; /* line # 443 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(17,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_itmrcd,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_itmiid,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(0,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_offset,6,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=444; /* line # 444 */
    ((UL *)F_exp)[5]=((UL *)F_exp)[5]|262144;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_def_lsq_varbl "  */
void P_dcp_def_lsq_varbl(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+398;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=455; /* line # 455 */
  Rv0=F_ip;
  Rv1=Rv0+40;
  Ra.sl[3]=457; /* line # 457 */
  ((SL *)Rv0)[8]=V_ide_seq_count;
  Ra.sl[3]=458; /* line # 458 */
  if (((UB *)Rv1)[1]==8) ((SL *)Rv0)[8]=P_dcp_lsq_intide(((SL *)((V *)Rv1)[1])[0]
  );
  else {
    Ra.sl[3]=459; /* line # 459 */
    ((SL *)Rv0)[8]=P_dcp_lsq_intide(1);
  }
  Ra.sl[3]=460; /* line # 460 */
  P_out_lsq_var_par_dclch(F_ip,1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_ass_lsq_varbl "  */
void P_dcp_ass_lsq_varbl(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+417;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=476; /* line # 476 */
  Rv0=F_rec+24;
  Rv1=((V *)F_rec)[0];
  Ra.sl[3]=478; /* line # 478 */
  Rv2=((SL *)Rv1)[8];
  Ra.sl[3]=479; /* line # 479 */
  switch (((UB *)Rv0)[1]) {
    case 2:Ra.sl[3]=481; /* line # 481 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(11,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv2,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[6],24,-15,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[7],24,-15,0);
    PAS__WRITE_EOLN();
    break;
    case 5:
    case 8:Ra.sl[3]=486; /* line # 486 */
    Rv3=((SL *)F_rec)[4]+1;
    Ra.sl[3]=487; /* line # 487 */
    Rv2=Rv2+((SL *)F_rec)[4];
    Ra.sl[3]=488; /* line # 488 */
    for( Rf0=(((SL *)F_rec)[3]-1)+1;Rf0>0;Rf0-- ) {
      Ra.sl[3]=490; /* line # 490 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(11,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rv2,8,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[Rv3],24,-15,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)((V *)Rv0)[2])[Rv3],24,-15,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=491; /* line # 491 */
      Rv2=Rv2+1;
      Rv3=Rv3+1;
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_def_lsq_parm "  */
void P_dcp_def_lsq_parm(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+436;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=515; /* line # 515 */
  Rv0=F_ip;
  Ra.sl[3]=517; /* line # 517 */
  if (V_exp_res.sl[3]==1) ((SL *)Rv0)[8]=P_dcp_lsq_intide(1);
  else {
    Ra.sl[3]=518; /* line # 518 */
    ((SL *)Rv0)[8]=V_exp_res.sl[2];
  }
  Ra.sl[3]=519; /* line # 519 */
  P_out_lsq_var_par_dclch(F_ip,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " dcp_def_data_field "  */
void MXD_DCP_LSQ_dcp_def_data_field(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+454;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=527; /* line # 527 */
  Rv0=F_ip;
  Ra.sl[3]=529; /* line # 529 */
  ((SL *)Rv0)[8]=P_dcp_lsq_intide(1);
  Ra.sl[3]=530; /* line # 530 */
  PAS__SELECT_OUT(V_pcd);
  PAS__WRITE_INT(14,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[8],8,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((UB *)((V *)Rv0)[0])[1],4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(((V *)Rv0)[0],-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " define_specific "  */
void P_define_specific(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+474;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=539; /* line # 539 */
  if (F_ip!=NULL) {
    Ra.sl[3]=540; /* line # 540 */
    switch (((SL *)F_ip)[7]) {
      case 11:Ra.sl[3]=541; /* line # 541 */
      P_dcp_def_lsq_varbl(F_ip);
      break;
      case 12:Ra.sl[3]=543; /* line # 543 */
      P_dcp_def_lsq_parm(F_ip);
      break;
      case 16:Ra.sl[3]=545; /* line # 545 */
      MXD_DCP_LSQ_dcp_def_data_field(F_ip);
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " assign_specific "  */
void P_assign_specific(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+491;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=557; /* line # 557 */
  Rv0=F_rec+24;
  Rv1=((V *)F_rec)[0];
  Ra.sl[3]=558; /* line # 558 */
  switch (((SL *)Rv1)[7]) {
    case 10:Ra.sl[3]=560; /* line # 560 */
    if (((V *)Rv0)[1]!=NULL) MXD_DCP_LSQ_dcp_lsq_module(((V *)Rv0)[1]);
    break;
    case 1:Ra.sl[3]=562; /* line # 562 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[3]=563; /* line # 563 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(0,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[1])[1],3,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=566; /* line # 566 */
      P_lst_change_title(Rd.s+508,1);
      Ra.sl[3]=567; /* line # 567 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(0,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(0,3,0);
      PAS__WRITE_EOLN();
    }
    break;
    case 2:Ra.sl[3]=570; /* line # 570 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[3]=572; /* line # 572 */
      P_lst_change_title(((V *)Rv0)[1],1);
      Ra.sl[3]=573; /* line # 573 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(1,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[1])[1],3,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=577; /* line # 577 */
      P_lst_change_title(Rd.s+510,1);
      Ra.sl[3]=578; /* line # 578 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(1,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(0,3,0);
      PAS__WRITE_EOLN();
    }
    break;
    case 3:Ra.sl[3]=581; /* line # 581 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[3]=582; /* line # 582 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(2,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[1])[1],3,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=584; /* line # 584 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(2,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(0,3,0);
      PAS__WRITE_EOLN();
    }
    break;
    case 11:Ra.sl[3]=586; /* line # 586 */
    P_dcp_ass_lsq_varbl(F_rec);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_arg "  */
void MXD_DCP_LSQ_PRC_00000000(V F_exp, UB F_brf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+512;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=614; /* line # 614 */
  Rv0=F_exp+24;
  Ra.sl[3]=616; /* line # 616 */
  if (((V *)F_exp)[0]==NULL) F_brf=0;
  Ra.sl[3]=617; /* line # 617 */
  switch (((UB *)Rv0)[1]) {
    case 0:Ra.sl[3]=618; /* line # 618 */
    MXD_DCP_LSQ_out_pcd_string(((V *)Rv0)[1]);
    break;
    case 1:Ra.sl[3]=620; /* line # 620 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[1],0,0);
    break;
    case 2:Ra.sl[3]=622; /* line # 622 */
    if (F_brf) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)F_exp)[2],8,0);
    }
    else {
      Ra.sl[3]=623; /* line # 623 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)Rv0)[1],24,-15,0);
    }
    break;
    case 4:Ra.sl[3]=625; /* line # 625 */
    if (((V *)Rv0)[1]!=NULL) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)((V *)Rv0)[1])[(((SL *)F_exp)[4]+1)],0,0);
    }
    break;
    case 5:Ra.sl[3]=627; /* line # 627 */
    if (((SL *)F_exp)[2]>0) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)F_exp)[2]+((SL *)F_exp)[4],8,0);
    }
    else {
      Ra.sl[3]=628; /* line # 628 */
      if (((V *)Rv0)[1]!=NULL) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[(((SL *)F_exp)[4]+1)],24,-15,0);
      }
    }
    break;
    case 7:Ra.sl[3]=630; /* line # 630 */
    if (((V *)Rv0)[1]!=NULL) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)((V *)Rv0)[1])[((((SL *)F_exp)[4]+Lx[0].sl[0])+1)],12,0);
    }
    break;
    case 8:Ra.sl[3]=634; /* line # 634 */
    Rv1=((SL *)F_exp)[4]+Lx[0].sl[0];
    Ra.sl[3]=635; /* line # 635 */
    if (((SL *)F_exp)[2]>0) Rv2=((SL *)F_exp)[2]+Rv1;
    else {
      Ra.sl[3]=636; /* line # 636 */
      Rv2=0;
    }
    Ra.sl[3]=637; /* line # 637 */
    if (Rv2>0) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rv2,8,0);
    }
    else {
      Ra.sl[3]=638; /* line # 638 */
      if (((V *)Rv0)[1]!=NULL) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_DBLE(((G *)((V *)Rv0)[1])[(Rv1+1)],24,-15,0);
      }
    }
    break;
    case 9:Ra.sl[3]=642; /* line # 642 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[3]=643; /* line # 643 */
      Rv3=((V *)Rv0)[1];
      Ra.sl[3]=644; /* line # 644 */
      if (((V *)Rv3)[8]!=NULL) {
        Ra.sl[3]=645; /* line # 645 */
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)((V *)Rv3)[8])[12],2,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_INT(((SL *)Rv3)[11],8,0);
        PAS__WRITE_EOLN();
      }
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_directive "  */
void P_out_pcd_directive(SL F_cd, SL F_nsq, SL F_npa, V F_extb, SL F_sz, UB F_brf)
{
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+521;
  Ra.v[3]=Rd.s+14;
  Ra.sl[4]=654; /* line # 654 */
  Ra.sl[0]=0;
  while (1){
    Ra.sl[4]=656; /* line # 656 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(20,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_cd,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_nsq,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(F_npa,4,0);
    Ra.sl[4]=657; /* line # 657 */
    Rv0=1;
    for( Rf0=F_npa;Rf0>0;Rf0-- ) {
      MXD_DCP_LSQ_PRC_00000000((((S *)F_extb)+Rv0*48-48),F_brf);
      Rv0++;
    }
    Ra.sl[4]=658; /* line # 658 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_EOLN();
    Ra.sl[4]=659; /* line # 659 */
    Ra.sl[0]=Ra.sl[0]+1;
    if (Ra.sl[0]>=((SL *)F_extb)[F_npa*12-9])  break;
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " out_pcd_lindex "  */
void P_out_pcd_lindex(V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+540;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=668; /* line # 668 */
  if (F_id!=NULL) {
    Ra.sl[3]=669; /* line # 669 */
    Rv0=F_id;
    Ra.sl[3]=671; /* line # 671 */
    ((SL *)Rv0)[8]=P_dcp_lsq_intide(1);
    Ra.sl[3]=672; /* line # 672 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(10,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[8],8,0);
    PAS__WRITE_CHAR(32);
    Ra.sl[3]=673; /* line # 673 */
    if (((V *)Rv0)[0]!=NULL) {
      Ra.sl[3]=674; /* line # 674 */
      if (((UB *)((V *)Rv0)[0])[1]>0) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_INT(((UB *)((V *)Rv0)[0])[1],3,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_STR(((V *)Rv0)[0],-1,-1,32);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[3]=675; /* line # 675 */
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_INT(0,3,0);
        PAS__WRITE_EOLN();
      }
    }
    else {
      Ra.sl[3]=676; /* line # 676 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(0,3,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_const "  */
void P_out_pcd_const(G F_val){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=685; /* line # 685 */
  PAS__SELECT_OUT(V_pcd);
  PAS__WRITE_INT(5,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_DBLE(F_val,24,-15,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_intsumm_nd "  */
void P_out_pcd_intsumm_nd(UB F_intg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+571;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=696; /* line # 696 */
  if (F_intg) Rv0=63;
  else {
    Ra.sl[3]=697; /* line # 697 */
    Rv0=64;
  }
  Ra.sl[3]=698; /* line # 698 */
  PAS__SELECT_OUT(V_pcd);
  PAS__WRITE_INT((SL)Rv0,4,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_pcd_select "  */
void P_out_pcd_select(SL F_narg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+591;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=706; /* line # 706 */
  PAS__SELECT_OUT(V_pcd);
  PAS__WRITE_INT(68,4,0);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(F_narg,4,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_const_values "  */
void MXD_DCP_LSQ_PRC_00000001(V F_val, V F_pnam){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+607;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=723; /* line # 723 */
  Ra.sl[3]=724; /* line # 724 */
  switch (((UB *)F_val)[1]) {
    case 0:Ra.sl[3]=727; /* line # 727 */
    Lx[1].ub[0]=1;
    Ra.sl[3]=728; /* line # 728 */
    if (((V *)F_val)[1]!=NULL) {
      Ra.sl[3]=730; /* line # 730 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(((UB *)((V *)F_val)[1])[1],4,0);
      if (((UB *)((V *)F_val)[1])[1]>0) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_STR(((V *)F_val)[1],-1,-1,32);
      }
    }
    else {
      Ra.sl[3]=732; /* line # 732 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(0,4,0);
    }
    Ra.sl[3]=733; /* line # 733 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=736; /* line # 736 */
    if (abs(((SL *)F_val)[1])<100) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)F_val)[1],5,0);
    }
    else {
      Ra.sl[3]=737; /* line # 737 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)F_val)[1],0,0);
    }
    break;
    case 2:Ra.sl[3]=739; /* line # 739 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)F_val)[1],24,-15,0);
    break;
    case 9:Ra.sl[3]=741; /* line # 741 */
    if (((V *)F_val)[1]==NULL) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(0,8,0);
    }
    else {
      Ra.sl[3]=742; /* line # 742 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)((V *)F_val)[1])[11],8,0);
    }
    break;
    case 11:Ra.sl[3]=744; /* line # 744 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(0,8,0);
    break;
    default:Ra.sl[3]=747; /* line # 747 */
    P_src_error_s(Rd.s+627,290,2, F_pnam,NULL);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " item_export "  */
void P_item_export(V F_itm){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+631;
  Ra.v[3]=Rd.s+14;
  Ra.sl[4]=754; /* line # 754 */
  if (F_itm!=NULL) Rv0=((V *)F_itm)[8];
  Ra.sl[4]=755; /* line # 755 */
  if (Rv0!=NULL) {
    Ra.sl[4]=756; /* line # 756 */
    Rv1=F_itm;
    Rv2=Rv0;
    Ra.sl[4]=758; /* line # 758 */
    PAS__VWRITE_INIT(Ri.s,1);
    PAS__WRITE_STR(((V *)Rv1)[1],-1,-1,32);
    PAS__WRITE_CHAR(59);
    PAS__WRITE_INT(((SL *)Rv1)[10],0,0);
    PAS__WRITE_EOLN();
    Ra.sl[4]=759; /* line # 759 */
    Rv3=Rv0;
    Ra.sl[4]=760; /* line # 760 */
    while (((V *)Rv3)[2]!=NULL)
    Rv3=((V *)Rv2)[2];
    Ra.sl[4]=761; /* line # 761 */
    if (((V *)Rv1)[6]!=NULL) Rv4=((SL *)((V *)Rv1)[6])[11];
    else {
      Ra.sl[4]=762; /* line # 762 */
      Rv4=0;
    }
    Ra.sl[4]=763; /* line # 763 */
    if (4&((UB *)Rv2)[56]) Rv5=0;
    else {
      Ra.sl[4]=764; /* line # 764 */
      Rv5=((UB *)Rv3)[53]-((UB *)Rv3)[52];
    }
    Ra.sl[4]=766; /* line # 766 */
    PAS__SELECT_OUT(V_pcd);
    PAS__WRITE_INT(15,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv2)[12],2,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv5,2,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv1)[11],8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Rv4,8,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(Ri.ub[1],4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Ri.s,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[4]=767; /* line # 767 */
    if (((UB *)Rv2)[52]>0) {
      Ra.sl[4]=769; /* line # 769 */
      Ra.ub[0]=0;
      Ra.sl[4]=770; /* line # 770 */
      Rv6=1;
      for( Rf0=((UB *)Rv2)[52];Rf0>0;Rf0-- ) {
        MXD_DCP_LSQ_PRC_00000001((((S *)Rv1)+Rv6*24+24),((V *)Rv1)[1]);
        Rv6++;
      }
      Ra.sl[4]=771; /* line # 771 */
      if (!Ra.ub[0]) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_EOLN();
      }
    }
    Ra.sl[4]=773; /* line # 773 */
    if (4&((UB *)Rv2)[56]) {
      Ra.sl[4]=775; /* line # 775 */
      Ra.ub[0]=0;
      Ra.sl[4]=776; /* line # 776 */
      Rv7=((UB *)Rv2)[52]+1;
      for( Rf0=(((UB *)Rv2)[53]+1)-(((UB *)Rv2)[52]+1);Rf0>0;Rf0-- ) {
        MXD_DCP_LSQ_PRC_00000001((((S *)Rv1)+Rv7*24+24),((V *)Rv1)[1]);
        Rv7++;
      }
      Ra.sl[4]=777; /* line # 777 */
      if (!Ra.ub[0]) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_EOLN();
      }
    }
  }
  PAS__curr_cntx=Ra.v[1];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " data_item_export "  */
void P_data_item_export(V F_datp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+644;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=790; /* line # 790 */
  Rv0=F_datp;
  Rv1=Rv0+12;
  Ra.sl[3]=791; /* line # 791 */
  if (((V *)Rv0)[1]!=NULL) {
    Ra.sl[3]=792; /* line # 792 */
    if (((V *)((V *)Rv0)[1])[8]!=NULL) {
      Ra.sl[3]=794; /* line # 794 */
      PAS__VWRITE_INIT(Ri.s,1);
      PAS__WRITE_CHT(Rv1+72,70,((UB *)Rv1)[71],-1,32);
      PAS__WRITE_CHAR(59);
      PAS__WRITE_INT(((SL *)Rv1)[36],0,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=795; /* line # 795 */
      Rv2=((V *)Rv0)[1];
      Rv3=((V *)Rv2)[8];
      Ra.sl[3]=797; /* line # 797 */
      Rv4=((V *)Rv2)[8];
      Ra.sl[3]=798; /* line # 798 */
      while (((V *)Rv4)[2]!=NULL)
      Rv4=((V *)Rv3)[2];
      Ra.sl[3]=799; /* line # 799 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(18,4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv3)[12],2,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((UB *)Rv4)[52],2,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv2)[11],8,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Ri.ub[1],4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(Ri.s,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=800; /* line # 800 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_FCHAR(32,4,-1,1,32);
      PAS__WRITE_INT(((SL *)Rv1)[37],4,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(((SL *)Rv1)[39],8,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=801; /* line # 801 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_INT(((SL *)Rv1)[40],4,0);
      Ra.sl[3]=802; /* line # 802 */
      Rv5=1;
      for( Rf0=((SL *)Rv1)[40];Rf0>0;Rf0-- ) {
        PAS__SELECT_OUT(V_pcd);
        PAS__WRITE_INT(((SL *)Rv1)[Rv5+40],5,0);
        Rv5++;
      }
      Ra.sl[3]=803; /* line # 803 */
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}
