{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*            MXD   Data   Compiler   item   management   module               *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module MXD_DCP_ITEM;


  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }




{**************************************************}
{*******          Type Declarations          ******}
{**************************************************}




{ ******************************************************************** }
{ ***********  Variables to get and parse a SHELL command  *********** }
{ ******************************************************************** }

var
  itm_cfl:                     ide_ptr;         { Local pointer of current item }

  itm_idx:                     integer;         { Current local item field index }

  arg_nva:                     boolean;         { To keep the current exp_nva status (interpretation/compilation) }



{ ************************************************************************************* }
{ ***  Global Variables of MXD-Data ComPiler environment declared with init values  *** }
{ ************************************************************************************* }




[global]
procedure ITEM_ADAPT_NAME( in_var snm: string; var nam: string; var nv: integer );
{ Item Name adaptation.
    When the name is null we force the default name "?Undefined?",
    Else
      we elliminate any not authorized character ( Control char., "?" or ";") that
      are replaced by spaces.
    When the string is too long we keep the six last characters and suppress the
    there previous one too fit with the maximum identifier name size.
}
var
  ii, jj, sz:  integer;
  ch:             char;
  sn:     string( 30 );

begin
  nv := 0;
  if snm.length = 0 then nam := '?Undefined?'
  else
  begin { Handle the version number when it is specified }
    sz := snm.length;                           { get the input string length }
    ii := INDEX( snm, ';', -1 );                { Look for the last semicolon in the name }
    if (ii > 1) and (snm.length-ii <= 6) then
    begin
      jj := ii + 1;
      while jj <= snm.length do                 { Loop to get a legal item version number }
      begin
        ch := snm[jj];
      exit if (ch < '0') or (ch > '9');         { Stop when ch is not a digit }
        nv := nv*10 + (ORD( ch ) - ORD( '0' )); { Compute the version number }
        jj := jj + 1
      end;
      if jj > snm.length then sz := ii - 1      { Change the string length to suppress the version number and its related ";" }
                         else nv := 0           { Illegal version number => we ignore it }
    end;
    ii := 0;
    if sz > ide_maxsize then jj := ide_maxsize - 7
                        else jj := sz;
    while ii < jj do
    begin { Loop to copy and replace illegal character }
      ii := ii + 1; ch := snm[ii];
      if (ch < ' ') or (ch = ';') or (ch = '?') or (ch > '}') then ch := ' ';
      nam[ii] := ch
    end;
    if ii < sz then                             { When some character(s) was not copied (too long string) }
      while ii < ide_maxsize do                 { Loop to copy (and replace ill. char.) the six last characters }
      begin { Complementary loop to copy for too long item name }
        jj := jj + 1; ch := snm[jj];
        if (ch < ' ') or (ch = ';') or (ch = '?') or (ch > '}') then ch := ' ';
        ii := ii + 1; nam[ii] := ch
      end;
    nam.length := ii                            { Set the final string length }
  end
end ITEM_ADAPT_NAME;



procedure ITEM_SET_NAME( itc: itm_ptr; in_var snm: string; var nam: string; var nv: integer; var itf: itm_ptr );
{ Create a new unique string and version number set in the item list <itl> from the string <snm>.
  The resulting item name is put in the procedure argument <nam> and the related version number
  is nv.
}
var
  ii, jj, np:  integer;
  ch:             char;

begin
  nv  :=   0;
  np  :=   0;
  itf := nil;
  ITEM_ADAPT_NAME( snm, nam, nv );

  { Loop to search any identical item name of the same type }
  while (itc <> nil) and (itf = nil) do
    with itc^ do
    begin
      if nam = itm_name^ then                   { When the name are same }
        { When a version is specified, and the versions are matching we increment the version number }
        if nv > 0 then begin  if itm_nver = nv then itf := itc  end
                  else if np < itm_nver then np := itm_nver; { Else, we keep the maximum version number }
      itc := itm_next
    end;

  if nv = 0 then nv := np + 1                   { When a version was not specified, we return the max. version number + 1 or 0 ... }
                                                { ... else we return the maximum version number + 1 }
end ITEM_SET_NAME;



[global]
function  ITEM_TYPE_SEARCH( berr: boolean := true ): typ_ptr;
const
  mdnam = 'ITTS';

var
  ide: ide_ptr;
  typ: typ_ptr;

begin
  with sy_sym do
  if sy = identsy then
  begin
    ide := IDE_SEARCH( true, [cla_type] );
    if ide <> nil then typ := ide^.ide_typ;
    if typ <> nil then
      if typ^.typ_frm <> tfrm_itmty then
      begin
        if berr then SRC_ERROR_S( mdnam, 265, e_error, ide^.ide_name^ );
        typ := nil
      end
  end else typ := nil;
  ITEM_TYPE_SEARCH := typ
end ITEM_TYPE_SEARCH;



[global]
function  ITEM_FIELD_SEARCH( bdat: boolean; berr: boolean := true ): ide_ptr;
const
  mdnam = 'ITFS';

var
  typ:         typ_ptr;
  ide, idt:    ide_ptr;

begin
  ide := nil;
  typ := ITEM_TYPE_SEARCH( berr );
  if typ <> nil then
  with sy_sym do
  begin
    idt := typ^.typ_ide;
    if bdat and not (itmf_dat in typ^.typ_ifl) then SRC_ERROR_S( mdnam, 266, e_error, idt^.ide_name^ );
    INSYMBOL;                                        { Gobble up the Item identifier }
    if sy = period then INSYMBOL
                   else SRC_ERROR( mdnam, 46, e_error );
    if sy = identsy then
    begin
      ide := LEVEL_SEARCH( typ^.typ_fel );
      if ide = nil then  SRC_ERROR_S( mdnam, 267, e_error, sy_ident, idt^.ide_name^ )
    end
  end;
  ITEM_FIELD_SEARCH := ide
end ITEM_FIELD_SEARCH;



[global]
function  ITEM_SEARCH( typ: typ_ptr; in_var sname: string; ball: boolean := false ): itm_ptr;
var
  tpa:                 typ_ptr;
  itc, itm, cblk:      itm_ptr;
  nv:                  integer;
  tmp:                  string;
  ch:                     char;

begin
  ITEM_ADAPT_NAME( sname, tmp, nv );            { Put the string name in form of item name and version number }
(*
WRITELN( ' Adapted name is "', tmp, '", version = ', nv:0 );
if itm_cblk <> nil then WRITELN( ' ':8, 'The current item block owner is the item "', itm_cblk^.itm_name^, '"' );
*)
  itm := nil;
  if typ <> nil then
  begin
    if typ^.typ_par <> nil then typ := typ^.typ_par;    { Always search item in the parent item list }

    itc := typ^.typ_fit;                        { Get the head of item list }
    while itc <> nil do                         { Loop to search the specified item }
      with itc^ do
      begin
        cblk := itm_cblk;                       { Get the top item block }
        while (cblk <> nil) and (cblk <> itm_ablk) do  cblk := cblk^.itm_ablk;
(*
WRITELN( ' ---> Find item "', itm_name^, '" with version = ',  itm_nver:0, ', same block = ', itm_ablk = cblk );
if itm_ablk <> nil then WRITELN( ' ':8, 'His item block owner is "', itm_ablk^.itm_name^, '"' );
*)
        if (itm_ablk = cblk) or ball then       { Search accept match only in the same group except when ball is specified }
        begin
          if tmp = itm_name^ then               { When the name match ... }
            if nv > 0 then                      { ... and a version was specified, ... }
            begin
              if nv = itm_nver then             { ... if the versions match then we stop the loop, ... }
              begin  itm := itc; exit  end
            end
            else itm := itc                     { ... else when no version was specified, we keep the reference and loop }
        end;
        itc := itm_next
      end

    { Here, itm^ is the selected item in the queue or nil (when not found) }
  end;
  ITEM_SEARCH := itm
end ITEM_SEARCH;



[global]
function  ITEM_NEW( itmty: ide_ptr; in_var sname: string ): itm_ptr;
const
  mdnam = 'CITM';

var
  itm, it2:    itm_ptr;
  typ, tpa:    typ_ptr;
  snm:          string;
  nver, idf:   integer;
  fid:         ide_ptr;
  bfnd:        boolean;

begin
  itm := nil;
  if itmty <> nil then                          { For previous error security }
  begin
    typ := itmty^.ide_typ;
    if typ <> nil then                          { For previous error security }
    with typ^ do
    begin
      if typ_par <> nil then tpa := typ_par     { Get parent item definition when it exist }
                        else tpa := typ;
      ITEM_SET_NAME( tpa^.typ_fit, sname, snm, nver, itm );  { Create an Unique String Item Name }
      if itm <> nil then
      begin { Already existing item error }
        SRC_ERROR_S( mdnam, 259, e_severe, itm^.itm_name^ ); SKIP_SYMBOL( semicolon )
      end
      else
      begin
        NEW( itm, typ_nfl + typ_nis );          { Create the item record }
        with itm^ do
        begin
          NEW( itm_name, snm.length );          { Create the item name string }
          itm_name^  :=      snm;
          itm_next   :=      nil;               { Init the item record }
          itm_sitm   :=      nil;
          itm_sblk   :=      nil;               { Assume no external item block }
          itm_ablk   :=      nil;
          itm_own    :=      nil;               { Assume no owner until shown otherwise }
          itm_typ    :=      typ;               { Set the item type link }
          itm_datp   :=      nil;               { Init the data record pointer }
          itm_nver   :=     nver;               { Set the version number }

          { Allocate an integer identifier number when required (for LSQ code items) }
          with tpa^ do
            if itmf_nsq in typ_ifl then itm_sequ := DCP_LSQ_INTIDE
                                   else itm_sequ := 0;


          { Init the argument table }
          for ii := 1 to itm_size do
          begin
            itm_tab[ii].val_frm := vfrm_null
          end;

(*
;WRITELN( ' Create the item ', itm_name^, ';', itm_nver:0, ' of type "', itm_typ^.ide_name^,
          '" with nid = ', typ_nid:0, ', nfl = ', typ_nfl:0, ', nsq = ', typ_nsq:0 );
*)
        end
      end;
      itm_cfl := typ_fel;                       { Init the currents field pointer and index }
      itm_idx := 1
    end
  end;
  ITEM_NEW := itm
end ITEM_NEW;



procedure ITEM_SET_FIELD( itp: itm_ptr; barg: boolean; idx: integer := 0 );
{ Put the next expression in the item field # <idx> of the item <itm^>.
  When barg is true an item argument is expected else (barg = false) the
  null expression is take.
}
const
  mdnam = 'ITSF';

var
  its:         itm_ptr;
  id2:         integer;
  rfm:       val_forms;
  ber, bnva:   boolean;

begin
  if itp <> nil then
  with itp^ do
  begin
    if itm_typ <> nil then
    with itm_typ^ do
    begin
      if idx > 0 then                           { When an field index is specified, do a search loop to find its releated type }
      begin
        itm_cfl := typ_fel; itm_idx := 1;
        while (id2 < idx) and (itm_cfl <> nil) do
        begin
          if itm_cfl^.ide_lnk <> nil then itm_cfl := itm_cfl^.ide_lnk;
          itm_idx := itm_idx + 1
        end
      end;

      if itm_cfl <> nil then                    { When the field type is known }
      with itm_cfl^, exp_res, exp_val do
      begin
        if ide_typ=nil then ide_typ := flt_typ; { To avoid some errors }

        if barg then
        begin
          if (itmf_fix in typ_ifl) or
             (itm_idx <= typ_nid) or
             (objf_nolsq in ide_typ^.typ_flg) then exp_nva := false
                                              else exp_nva := arg_nva;
          GET_EXPRESSION( exp_res );            { Get the expression }
        end
        else EXPRV_REMOVE( exp_res );           { When it is the end of list append a null expression }
        if val_frm = vfrm_null then             { For any empty parameters }
        begin
          exp_flg := [];                        { Clear any trailing flags }
          exp_typ := itm_cfl^.ide_typ;          { Set the field expression type }
          if exp_typ <> nil then
            with exp_typ^ do
              if typ_frm = tfrm_array then exp_esz := typ_siz*typ_stp
                                      else exp_esz := 1;
          if (not itm_cfl^.idee_option) then    { Signal error when the field was not optional }
            SRC_ERROR_S( mdnam, 254, e_error, itm_cfl^.ide_name^, itm_name^ )
        end
        else
        begin { A value expression is specified }
          rfm := GET_VAL_FORMS( ide_typ );      { Get the value form corresponding to the field type }
          if rfm = vfrm_itm then
          begin
            its := nil;
            if val_frm = vfrm_str then          { Item field is specified as a string name }
            begin
              its:=ITEM_SEARCH( ide_typ, str^ );{ Find the item pointer ... }
              val_frm := vfrm_itm; itm := its   { ... and change the expression to item reference }
            end
          end;
          ber := false;
          if rfm <> val_frm then                { Check for expression match }
            case rfm of
              vfrm_int: case val_frm of
                          vfrm_flt: begin val_frm := vfrm_int; int := ROUND( flt )  end;
                        otherwise
                          ber := true
                        end;
              vfrm_flt: case val_frm of
                          vfrm_int: begin val_frm := vfrm_flt; flt := int  end;
                        otherwise
                          ber := true
                        end;
            otherwise
              ber := true
            end;
            if ber then
            begin
              SRC_ERROR_S( mdnam, 255, e_error, itm_cfl^.ide_name^, itm_name^ );
              val_frm := vfrm_null
            end
            else
            begin
              if not (objf_lsqob in exp_flg) then val_cte := true;
              if (objf_nolsq in ide_typ^.typ_flg) and
                 (objf_lsqob in exp_flg) then SRC_ERROR_S( mdnam, 258, e_error, ide_name^ )
            end
        end;
        itm_tab[itm_idx] := exp_res.exp_val;
        if (itm_idx > typ_nid) or (itmf_dat in typ_ifl) then
          if not (itmf_fix in typ_ifl) and (itm_sequ > 0) then OUT_PCD_VREF( exp_res, false )
      end;

      if itm_idx < typ_nfl then                 { Set the default index to the next ITEM field when it is existing }
      begin  itm_idx := itm_idx + 1; itm_cfl := itm_cfl^.ide_lnk  end
    end
  end
end ITEM_SET_FIELD;



[global]
procedure DECLARE_ITEM_TYPE;
{ Item Type Declaration procedure ::
   The syntax is :

   ITEM [ <int_lvl> ] <item_type_ide> [ ( <item_type> <str_ide> [, <item_type> <str_ide> [*] [, ... ] ] ) ]
           [: <int_def_node_code> ] IS <field_item> [, ... ] : <type_ide> [ ; ... ]
   END

   To create a child ITEM child the syntax forms are :

   ITEM [ <int_lvl> ] <child_item_type_ide> [: <int_ref_node_code> ] = <parent_item_type>
           [ ( <item_type> <str_ide> [, <item_type> <str_ide> [*] [, ... ] ] ) ]
           IS <field_item> [, ... ] : <type_ide> [ ; ... ]
   END ]

   The short form

      ITEM [ <int_lvl> ] <child_item_type_ide> [: <int_ref_node_code> ] = <parent_item_type>

   can be used to change the only code.

   The star character flag the optionel identification string in the declaration of this item object.

   When LSQ code(s) are specified, the item definition generate always a LSQ node code to be handle by the application programs.

}
const
  mdnam = 'NITT';

var
  typ, tpa:            typ_ptr;
  idf, ide, idc:       ide_ptr;
  pow:                ittl_ptr;
  lvl, nid, nfl, nsq:  integer;
  fbk:                 boolean;

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the ITEM keyword }
    ide := nil;
    typ := nil;
    tpa := nil;
    { Set the item block declaration flag when begin is specified }
    if sy = itmgrpsy then begin  INSYMBOL; fbk := true  end
                     else fbk := false;
    if sy = intconst then                       { When a lex level display is specified }
    begin
      lvl := sy_ival;                           { When a target display level is specified, we get it }
      if lvl <= 0 then lvl := curr_disp - lvl;
      if lvl < 0 then lvl := 1                  { It is possible to create item type in the predefined lex level display }
                 else if lvl > curr_disp then lvl := curr_disp;
      INSYMBOL
    end else lvl := 1;                          { The predefined lex level display is defaulted for item types }

    { We try to create the item type identifier }
    if CHECK_SYMB_ERR( mdnam, identsy, 251 ) then goto ET_END
                                             else ide := IDE_NEW( cla_type, nil, lvl );
    INSYMBOL;                                   { Gobble up the item type identifier name }
    if ide <> nil then
    begin
      if (sy = relop) and (op = eq_op) then
      begin
        INSYMBOL;                               { Gobble up "=" }
        if sy = identsy then
        begin
          idc := IDE_SEARCH( false,[cla_type] );{ Look for an item type identifier is specified }
          INSYMBOL;                             { Gobble up the parent item type identifier name }
          if idc <> nil then
          begin
            tpa := idc^.ide_typ;
            if tpa <> nil then
              if tpa^.typ_frm <> tfrm_itmty then
              begin  SRC_ERROR( mdnam, 256, e_error ); tpa := nil  end
          end
        end
      end;
      typ := TYP_NEW( tfrm_itmty, ide, tpa, lvl );      { Create the item type record }
      if tpa <> nil then
      with typ^ do
      begin
        typ_fel := tpa^.typ_fel;                { Get the parent field list }
        typ_lel :=          nil;                { To flag the use of parent fields }

        typ_ito := tpa^.typ_ito;                { Set the parent group owner requirements }
        typ_pcd := tpa^.typ_pcd;                { Set the parent LSQ code }

        typ_nid := tpa^.typ_nid;                { Get the parent number of fields }
        typ_nfl := tpa^.typ_nfl;
        typ_adv := tpa^.typ_adv;                { Get the Additional Values array size }
        typ_nis := tpa^.typ_nis;                { Get the first sentinel position }
        typ_ifl := tpa^.typ_ifl                 { Set the item specific flags }
      end;
      ide^.ide_typ := typ
    end;

    if typ <> nil then                          { When the item type creation is a success }
    with typ^ do
    begin
      if fbk then typ_ifl := typ_ifl + [itmf_blk];      { When this item type is a block of other item }
      if typ_par = nil then                     { Field declaration only possible for a new item type (not a children) }
      begin
        nfl := 0;
        DISPLAY_NEW;                            { Create an Item display level }

        if sy = lparen then                     { When some complementary identification fields are required ... }
        begin
          repeat                                { ... perform the identification field definition loop }
            INSYMBOL;                           { Gobble up "(" or ";" }
            nfl := nfl + VARBL_DECL( cla_itmfld, true, true );

          until sy <> semicolon;
          if sy = rparen then INSYMBOL
                         else SRC_ERROR( mdnam, 23, e_error )
        end;
        nid := nfl                              { Keep the number of identification field(s) }
      end;

      if sy = colon then                        { When the colon is used, we get the LSQ node Codes }
      begin
        INSYMBOL;                               { Gobble up ":" }
        typ_pcd := GET_INTEXPR( typ_pcd );      { Set the Item Type LSQ node code }
        if sy = datasy then begin  INSYMBOL; typ_ifl := typ_ifl + [itmf_dat]  end;      { Set the data flag when required }
        if typ_pcd < 0 then
        begin  typ_pcd := - typ_pcd; typ_ifl := typ_ifl + [itmf_fix]  end;
        if typ_pcd > 0 then typ_ifl := typ_ifl + [itmf_nsq]     { Initialize the specific item count index (integer identifier) }
      end;

      if typ_par = nil then                     { Field declaration only possible for a new item type }
      begin
        if (sy = issy) or ((sy = relop) and (op = eq_op)) then
        repeat                                  { Perform the fields definition loop }
          INSYMBOL;                             { Gobble up "is", "=" or ";" }
          nfl := nfl + VARBL_DECL( cla_itmfld, true, itmf_dat in typ_ifl );     { Declare field(s) for each specified type }
        until sy <> semicolon;

        { Re-ordered the item field list in the declaration order }
        idf := nil;
        ide := disp_tab[curr_disp].disp_lid;
        if ide <> nil then                      { When some item fields was specified }
        begin
          while ide <> nil do                   { Loop to reverse the ordering }
          begin
            idc := ide;                         { Keep the address of current field identifier }
            with idc^ do                        { Warning: the with pointer is a copy of idc (not ide), then ... }
            begin
              ide := ide_lnk;                   { ... we can keep the next of the original LIFO }
              ide_lnk := idf;                   { Save the previous field address in the formal link }
              idf := idc                        { Set the current field address as the new first field  }
            end
          end;

          { Set the first and last item field pointer }
          typ_fel := disp_tab[curr_disp].disp_idt;
          typ_lel := disp_tab[curr_disp].disp_lid;

          nsq := 0;
          idc := typ_fel;
          for ii := 1 to nfl do                 { Loop to assign sequence numbers for each item field }
            with idc^ do
            begin
              idee_sequnb :=  ii;
              idee_offset := nsq;
              if idee_isent and (typ_nis = 0) then typ_nis := ii;
              if ide_typ <> nil then
                with ide_typ^ do
                  case typ_frm of               { For array field, each element must have a sequence number }
                    tfrm_array: begin  nsq := nsq + typ_siz*typ_stp; idee_isent := false  end;
                    tfrm_int:   nsq := nsq + 1;
                  otherwise
                    nsq := nsq + 1; idee_isent := false
                  end;
              idc := ide_lnk
            end;
          typ_nid := nid;                       { Keep the numbers of item fields }
          typ_nfl := nfl;
          if sy <> endsy then begin  SRC_ERROR( mdnam, 58, e_severe ); SKIP_SYMBOL( semicolon )  end
                         else INSYMBOL
        end;
        if (sy = addop) and (op = add_op) and (itmf_dat in typ_ifl) then        { Set the room for additional values when required }
        begin  INSYMBOL; typ_adv := GET_INTEXPR( 0 )  end;
        curr_disp := curr_disp - 1              { Go out of the Item display level }
      end;

      if sy = forsy then                        { When this item must be attached at an item group }
      begin
        typ_ito := nil;                         { We Cancel the owner requirements incoming from the parent }
        sy := comma;
        repeat
          INSYMBOL;                             { Gobble up the separator of the "for" introductor }
          if sy = identsy then
          begin
            idf := IDE_SEARCH( true, [cla_type] );
            if idf <> nil then
            begin
              if idf^.ide_typ <> nil then
                if (idf^.ide_typ^.typ_frm = tfrm_itmty) and
                   (itmf_blk in idf^.ide_typ^.typ_ifl) then
                begin
                  NEW( pow );
                  pow^.ittl_next := typ_ito;
                  typ_ito := pow;
                  pow^.ittl_owner := idf^.ide_typ
                end else idf := nil
              else idf := nil
            end;
            if idf = nil then SRC_ERROR_S( mdnam, 279, e_error, sy_ident )
          end
          else SRC_ERROR( mdnam, 278, e_error );
          INSYMBOL
        until sy <> comma
      end;

(*
WRITELN( ' NEW item type "', typ_ide^.ide_name^, '" with nid = ', typ_nid:0, ' nfl = ', typ_nfl:0 );
WRITELN( '    nsq = ', typ_nsq:0, ', pcd = ', typ_pcd:0 );
WRITELN( '    With fields : ' );
idc := typ_fel;
while idc <> nil do
with idc^ do
begin
  WRITELN( ' ':6, 'ide = ', ide_name^, ':', ide_typ^.typ_ide^.ide_name^, ' opt = ', idee_option, ', sqnb = ', idee_sequnb:0,
           ', offset = ', idee_offset:0 );
  idc := ide_lnk
end;
WRITELN;
*)
    end;
ET_END:
  end
end DECLARE_ITEM_TYPE;



[global]
procedure DECLARE_ITEM_OBJ( idt: ide_ptr );
{ Procedure to create an Item object.

  The syntax is :

    <item_type_ide> [ [<lex>] <attached_identifier> ] ( <item_ident_list> ) = <Item_field_list>

  The <item_ident_list> is the list of string identifiers used to define the Item Object.
  The first string is the identifier name of object also :

     item my_vector x, y, z: float end;

 can accept the following declarations :

     my_vector v1 = 3.2, 8.3, 7.5;        or         my_vector( 'v1' ) = 3.2, 8.3, 7.5;

 these two forms are equivalent.

  The <Item_field_list> can be incomplete :
     my_vector v1 = 3.2;        is equivalent with   my_vector v1 = 3.2, 0.0, 0.0;
  and
     my_vector v1 = ,,5.5;      is equivalent with   my_vector v1 = 0.0, 0.0, 5.5;

  To declare an access item variable you can use the following syntax :

     <item_type_ide>^ [ [<lex>] <attached_identifier> ]
  or
     <item_type_ide>** [ [<lex>] <attached_identifier> ]

  In this case the access identifier has a null value and cannot be used to access to items
  but well be set by a future builtin function.


}
const
  mdnam = 'NITM';

var
  typ, tpa:            typ_ptr;
  idr, idf:            ide_ptr;
  itm, itmo:           itm_ptr;
  pitt:               ittl_ptr;
  lvl, idx:            integer;
  barg, bacc:          boolean;
  sid0, sid1:           string;

begin
  typ := idt^.ide_typ;                          { Get the item type definition }
  if typ <> nil then
  with sy_sym, typ^ do
  begin
    arg_nva := (typ_pcd > 0);                   { Set the formulae/arguments managment mode for this item }

(*
WRITELN( ' Create NEW item "', typ_ide^.ide_name^, '" with nid = ', typ_nid:0, ' nfl = ', typ_nfl:0, ', nsq = ', typ_nsq:0 );
*)
    INSYMBOL;                                   { Gobble up the Item type identifier }
    idr := nil;                                 { Assume no reference identifier }
    if sy = powop then begin  bacc := true; INSYMBOL  end
                  else bacc := false;
    if (sy = identsy) or (sy = intconst) then
    begin                                       { A Reference Item identifier is specified }
      idx := idt^.ide_displ;                    { Get the lex display level of the Item Type }
      if sy = intconst then
      begin
        lvl := sy_ival;                         { When a target display level is specified, we get it }
        if lvl <= 0 then lvl := curr_disp - lvl;
        if lvl < idx then lvl := idx            { The minimum lex is the item Type lex }
                     else if lvl > curr_disp then lvl := curr_disp;
        INSYMBOL
      end else lvl := curr_disp;                { The default lex is the current lex }
      if sy <> identsy then SRC_ERROR_S( mdnam, 252, e_error, idt^.ide_name^ )
      else
      begin
        idr := IDE_NEW( cla_varbl, typ );       { Create the item reference identifier }
        INSYMBOL;
        if idr <> nil then
        with idr^, idev_val do
        begin                                   { On success, initialize it }
          val_frm := vfrm_itm; itm := nil;
          if bacc and (sy = colon) then
          begin
            INSYMBOL;
            idev_sequnb := ABS( GET_INTEXPR( 0 ) )      { Get the application integer identifier number (negative or null only) }
          end;
          if idev_sequnb > 0 then ide_flg := lsqex_flags
        end
      end
    end;

    if not bacc then
    begin
      if (typ_nid > 0) and (sy <> lparen) then SRC_ERROR_S( mdnam, 257, e_error, idt^.ide_name^ );

      if sy = lparen then
      begin { Declaration Form "<item_type> ( <item_ide> , ... ) = ... }
        INSYMBOL; GET_STREXPR( sid0 );          { Skip parenthesys and get the name of item to create }
        itm := ITEM_NEW( idt, sid0 );           { Create the item record }
        for ii := 1 to typ_nid do
        begin { When other symbol identification are specified, we get it }
          if sy = comma then begin  INSYMBOL; barg := true  end;
          ITEM_SET_FIELD( itm, barg )
        end;
        if idr <> nil then idr^.idev_val.itm := itm;    { Attach the reference identifier to item }
        if sy = rparen then INSYMBOL
                       else SRC_ERROR( mdnam, 23, e_error )
      end
      else
      if idr <> nil then                        { When an identifier was specified without identification arguments ... }
      with idr^ do
      begin
        itm := ITEM_NEW( idt, ide_name^ );      { ... we create the item record with the name of ref. identifier, ... }
        idev_val.itm := itm;                    { ... attach the reference identifier to item, ... }
        if typ_nid > 1 then                     { ... and when some identification fields was required ... }
          for ii := 1 to typ_nid do
          begin
            ITEM_SET_FIELD( itm, false );       { ... we set them as null arguments. }
            if sy = comma then INSYMBOL
          end
      end
      else
      begin { When no item name was specified}
        SRC_ERROR_S( mdnam, 253, e_severe, idt^.ide_name^ );
        SKIP_SYMBOL( semicolon ); goto ET_END
      end;


      if itmf_dat in typ_ifl then
        COMPLETE_DATA_ITEM( typ, itm )          { Complete by Data collection (reference or creation) for data item }
      else
      begin { Now we must get all fields of the ITEM. The separator ("is" or "=") is optional }

        if (sy = issy) or ((sy = relop) and (op = eq_op)) then INSYMBOL;

        barg := true;
        for ii := typ_nid + 1 to typ_nfl do
        begin
          ITEM_SET_FIELD( itm, barg );          { Put the expression in the item }
          if sy = comma then INSYMBOL
                        else barg := false
        end;

        if typ_par <> nil then tpa := typ_par   { Get the item parent pointer when it is existing }
                          else tpa := typ;
        with tpa^ do
        begin
          if typ_fit = nil then typ_fit := itm  { Put the new item in the type item queue }
                           else typ_lit^.itm_next := itm;
          typ_lit := itm
        end;

        if typ_ito <> nil then                  { When this item must be attached to an item owner }
        begin
          pitt := typ_ito;
          repeat                                { Loop on all possible item block types }
            itmo := itm_cblk;
            while itmo <> nil do                { Loop on all active item blocks }
              if pitt^.ittl_owner = itmo^.itm_typ then exit
                                                  else itmo := itmo^.itm_sblk;
          exit if itmo <> nil;                  { Stop when found the active block with an allowed type }
          exit if pitt^.ittl_next = nil;        { Exit when it was the last type check }
            pitt := pitt^.ittl_next
          until false;

          if itmo = nil then SRC_ERROR_S( mdnam, 280, e_error, typ_ide^.ide_name^, pitt^.ittl_owner^.typ_ide^.ide_name^ )
                        else itm^.itm_ablk := itmo
        end;
        if itmf_blk in typ_ifl then             { When this item is an item block introductor }
        begin  itm^.itm_sblk := itm_cblk; itm_cblk := itm  end;

        if arg_nva then ITEM_EXPORT( itm );
      end;
      exp_nva := false
    end
  end
  else SKIP_SYMBOL( semicolon );
ET_END:
end DECLARE_ITEM_OBJ;



[global]
procedure GEN_END_ITEM_BLOCK;
const
  mdnam = 'EITM';

begin
  if itm_cblk <> nil then itm_cblk := itm_cblk^.itm_sblk
                     else SRC_ERROR( mdnam, 281, e_error );
  INSYMBOL
end GEN_END_ITEM_BLOCK;



function  GEN_SPIDENT( typ: typ_ptr ): ide_ptr;
const
  mdnam = 'GSID';

var
  ide: ide_ptr;
  lvl: integer;

begin
  with sy_sym do
  begin
    if sy = intconst then
    begin                                       { When a target display level is specified, we use it ... }
      lvl := sy_ival;
      if lvl <= 0 then lvl := curr_disp - lvl;
      if lvl <= 0 then lvl := 1
                  else if lvl > curr_disp then lvl := curr_disp;
      INSYMBOL
    end else lvl := curr_disp;                  { ... else we use the current display level to create the identifier }
    if sy <> identsy then
    begin
      SRC_ERROR( mdnam, 56, e_severe );
      SKIP_SYMBOL( semicolon );
      ide := nil
    end
    else
      ide := IDE_NEW( cla_varbl, typ, lvl )     { Create the table identifier }
  end;
  GEN_SPIDENT := ide
end GEN_SPIDENT;



[global]
procedure TABLE_GENERATOR;
{ To generate a table of data that will be loaded in an array.
}
const
  mdnam = 'TBGE';

type
  buftyp = array[1..max_cte_size,1..2] of mxd_flt;

var
  ide:                 ide_ptr;
  nst, idx, jdx:       integer;
  org, stp, vxx, vyy:  mxd_flt;
  buf:                 ^buftyp;
  bfrs:                boolean;

begin
  NEW( buf );                                   { Allocate a table for a maximum size (typicaly 32768 x/Y pair) }
  bfrs := true;
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the keyword "build_table" }
    while (sy = identsy) or (sy = intconst) do  { Loop on all table variable to declare }
    begin
      ide := GEN_SPIDENT( nil );
      if ide <> nil then
      with ide^ do
      begin
        ide_flg := [objf_ronly,objf_lsqtb];
        INSYMBOL;                               { Gobble up the table identifier }
        if (sy = becomes) or (sy = issy)  then INSYMBOL
        else
        if ((sy = relop) and
            (op = eq_op)) then begin            { Read/Write mode when "=" is specified }
                                 ide_flg := []; INSYMBOL
                               end else SRC_ERROR( mdnam, 55, e_error );

        idx :=    0; vxx := 0.0;                { Set the starting default values }
        stp := 0.05; vyy := 1.0;
        if sy = lparen then INSYMBOL
                       else SRC_ERROR( mdnam, 22, e_error );
        repeat { Loop on all fix step section }
          org := vxx;
          stp := GET_FLTEXPR( stp );
          if sy = comma then
          begin  INSYMBOL; org := stp; stp := GET_FLTEXPR( stp )  end;
          if sy = colon then INSYMBOL
                        else SRC_ERROR( mdnam, 47, e_error );
          if bfrs then begin  nst := 0; bfrs := false  end
                  else nst := 1;
          repeat { Loop inside a fix step section }
            vyy := GET_FLTEXPR( vyy );          { Get the point value }
            vxx := org + nst*stp;               { Compute the point coordinate }
            nst := nst + 1;
            if idx >= max_cte_size then         { Control for temporary table overflow }
            begin
              SRC_ERROR_S( mdnam, 152, e_severe, ide_name^ );
              SKIP_SYMBOL( semicolon ); return
            end;
            idx := idx + 1;                     { OK for this point -> increment the point count  ... }
            buf^[idx,1] := vxx;                 { ... and put the point in the temporary buffer }
            buf^[idx,2] := vyy;
          exit if sy <> comma;                  { Stop on the end of section ... }
            INSYMBOL;                           { ... or gobble up the comma separator }
          until false;
        exit if sy <> semicolon;                { Stop on end of section list ... }
          INSYMBOL                              { ... or loop for the next section }
        until false;
        if sy = rparen then INSYMBOL
                       else SRC_ERROR( mdnam, 23, e_error );

        idev_val.val_frm := vfrm_afl;
        NEW( idev_val.aaf, 2*idx );             { Allocate the required space for the array }
        idev_val.asg :=      nil;
        jdx := 0;
        with idev_val.aaf^ do
          for ii := 1 to idx do
          begin
            jdx := jdx + 1; val_ftb[jdx] := buf^[ii,1];
            jdx := jdx + 1; val_ftb[jdx] := buf^[ii,2]
          end;
        { Now we create the specific array type ( with the "table-2d" type as parent }
        ide_typ := TYP_NEW( tfrm_array, nil, fta_typ, ide_displ );
        if ide_typ <> nil then
        with ide_typ^ do
        begin
          typ_ael := fta_typ^.typ_ael;
          typ_stp := fta_typ^.typ_stp;
          typ_siz := idx; typ_min := 1
        end
      end
    end
  end;
  DISPOSE( buf )
end TABLE_GENERATOR;



[global]
procedure INTEGR_TAB_GENERATOR;
const
  mdnam = 'INTB';

var
  nn, ik:              integer;
  eps, va, vb, al:     mxd_flt;
  ide:                 ide_ptr;

begin
  ik := 0; eps := 1.0e-12;
  al := 0.5; va := -1.0; vb := 1.0;
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the operator keyword "integr_tab" }
    while (sy = identsy) or (sy = intconst) do  { Loop on all table variable to declare }
    begin
      ide := GEN_SPIDENT( nil );
      INSYMBOL;
      if ide <> nil then
      with ide^ do
      begin
        ide_flg := [objf_ronly,objf_lsqtb];     { Set the readonly flag + table flag for definition }
        if (sy = becomes) or (sy = issy)  then INSYMBOL
        else
        if ((sy = relop) and
            (op = eq_op)) then begin            { Read/Write mode when "=" is specified }
                                 ide_flg := [objf_lsqtb]; INSYMBOL
                               end else SRC_ERROR( mdnam, 55, e_error );
        nn := GET_INTEXPR( 10 );                { Get the size of table }
        if nn < 5 then nn := 5;                 { Force a minimum size of 5 points }
        ide_typ := TYP_NEW( tfrm_array, nil, fta_typ, ide_displ );
        with ide_typ^ do                        { Create the attached type }
        begin
          typ_ael := fta_typ^.typ_ael;
          typ_stp := fta_typ^.typ_stp;
          typ_siz := nn; typ_min := 1
        end;
        VAL_ALLOCATE( idev_val, ide_typ );      { Allocate the memory }
        if sy = lparen then
        begin
          INSYMBOL; ik := GET_INTEXPR( 0 );     { Get the polynome kind (default to Legendre) }
          if sy = colon then
          begin  INSYMBOL; eps := GET_FLTEXPR( 1.0e-12 )  end;
          if sy = rparen then INSYMBOL
                         else SRC_ERROR( mdnam, 23, e_error )
        end;
        case ik of
          1:  begin { Laguerre Polynomes }
                if sy = colon then begin  INSYMBOL; al := GET_FLTEXPR( al )  end;
                MATH_GAUSS_INTEGR_BLDTAB( idev_val.aaf^, al, 0.0, eps, 1 )
              end;
          2: { Hermite Polynomes }
            MATH_GAUSS_INTEGR_BLDTAB( idev_val.aaf^, 0.0, 0.0, eps, 2 );

        otherwise { default: legendre Polynomes }
          if sy = colon then begin  INSYMBOL; va := GET_FLTEXPR( va )  end;
          if sy = colon then begin  INSYMBOL; vb := GET_FLTEXPR( vb )  end;
          MATH_GAUSS_INTEGR_BLDTAB( idev_val.aaf^, va, vb, eps, 0 )
        end
      end
      else SKIP_SYMBOL( semicolon );
    exit if sy <> comma;
      INSYMBOL
    end
  end;
  if math_err > 0  then SRC_ERROR( mdnam, 500+math_err, e_error )
end INTEGR_TAB_GENERATOR;



[global]
procedure FNC_INTEGR;
const
  mdnam = 'INTG';

var
  nn, ip:      integer;
  val, we:     mxd_flt;
  expt:        exp_rec;
  expm:        idm_ptr;
  iid:         ide_ptr;
  tbp:        ^val_afl;
  nvasv, blsq: boolean;

begin
  expt := exp_null;
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the function keyword name }
    if sy = lparen then INSYMBOL
                   else SRC_ERROR( mdnam, 22, e_error );
    { Get the integration table to use }
    nvasv := exp_nva;                           { Save the expression mode and force the interpretation mode }
    exp_nva := false;
    EXPRESSION_TYPE( fta_typ, true );           { Get the integration table reference }
    POP_EXPRESSION( expt );
    with expt, exp_val do
      if (val_frm = vfrm_afl) and (aaf <> nil) then begin  tbp := aaf; nn := exp_esz  end
                                               else begin  tbp := nil; nn := 0  end;
    if nn < 10 then begin  SRC_ERROR_S( mdnam, 506, e_severe, sy_ident ); SKIP_SYMBOL( semicolon ); return  end;
    iid := nil;
    { Get the integration variable to create in a specific display level }
    DISPLAY_NEW;
    if sy = comma then INSYMBOL
                  else SRC_ERROR( mdnam, 29, e_error );
    iid := GEN_SPIDENT( flt_typ );              { Create the integration variable identifier as a float number }
    INSYMBOL;                                   { Gobble up the integration variable identifier }
    if sy <> comma then SRC_ERROR( mdnam, 29, e_error );
    if iid <> nil then
    with iid^, tbp^ do                          { When the integration variable is OK }
    begin
      idev_val.val_frm := vfrm_flt;
      idev_val.flt := tbp^.val_ftb[2];          { Set the integration variable at the first value of integration table }
      expm := NEW_MACRO_EXPR;                   { Get the expression to integrate as a macro expression }
      if sy <> rparen then SRC_ERROR( mdnam, 23, e_error );     { Check now because the sy value after GET_FLT_MEXPR is not significant }
      GET_FLT_MEXPR( expm, flt_typ, blsq );     { Evaluate the expression for compilation test (result in exp_res) }

      if blsq and nvasv then
      begin
        ide_flg := [objf_lsqiv,objf_lsqob];     { Set the Integration_Variable/Index flags }
        exp_nva := true;                        { Set the expression compilation mode }
        OUT_PCD_VREF( expt );                   { Output the integration table reference }
        OUT_PCD_LINDEX( iid );                  { Output the integration variable definition }
        GET_FLT_MEXPR( expm, nil, blsq );       { Compile the expression to integrate, the result expression ref. is in exp_res }
        OUT_PCD_INTSUMM_ND( true );             { Output the integration node }
        exp_res.exp_flg := [objf_lsqob,objf_lsqex];     { Set the LSQ compiled expression status flags }
        PUSH_EXPRESSION( exp_res )
      end
      else
      begin { We skip the first point (in the table) that is already evaluated }
        val := val_ftb[1]*exp_res.exp_val.flt;  { Multiply the formulae result by the weight }
        ip := 2;
        while ip < val_all do
        begin
          ip := ip + 1;
          we := val_ftb[ip];
          ip := ip + 1;
          idev_val.flt := val_ftb[ip];
          val := val + we*GET_FLT_VALUE( expm )
        end;
        EXP_PUTFLT( val )
      end;
      PURGE_MACRO_EXPR( expm )
    end else SKIP_SYMBOL( rparen );
    exp_nva := nvasv;                           { Restore the original expression management mode }
    DISPLAY_FREE
  end;
  EXPRV_REMOVE( expt )
end FNC_INTEGR;



[global]
procedure FNC_SUMMATION;
const
  mdnam = 'SUMM';

var
  bv, ev, sv, val:     mxd_flt;
  expm:                idm_ptr;
  iid:                 ide_ptr;
  nit, iit:            integer;
  nvasv, blsq:         boolean;

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the function keyword name }
    if sy = lparen then INSYMBOL
                   else SRC_ERROR( mdnam, 22, e_error );
    { Get the integration table to use }
    nvasv := exp_nva;                           { Save the expression mode and force the interpretation mode }
    exp_nva := false;

    iid := nil;
    { Get the integration variable to create in a specific display level }
    DISPLAY_NEW;
    iid := GEN_SPIDENT( flt_typ );              { Create the integration variable identifier as a float number }
    INSYMBOL;                                   { Gobble up the index variable identifier }
    if sy = comma then INSYMBOL
                  else SRC_ERROR( mdnam, 29, e_error );
    bv := GET_FLTEXPR( 0.0 );                   { Get the start index value }
    if sy = comma then INSYMBOL
                  else SRC_ERROR( mdnam, 29, e_error );
    ev := GET_FLTEXPR( 10.0 );                  { Get the end index value }
    if sy = comma then INSYMBOL
                  else SRC_ERROR( mdnam, 29, e_error );
    sv := GET_FLTEXPR( 1.0 );                   { Get the step index value }
    if sy <> comma then SRC_ERROR( mdnam, 29, e_error );
    if ((sv > 0) and (bv > ev)) or
       ((sv < 0) and (bv < ev)) or
       (ABS( 1.0e4*sv ) <= ABS( ev - bv )) or
       (ABS( ev - bv ) < 1e-4) then
    begin  SRC_ERROR( mdnam, 507, e_error ); sv := (ev - bv)/10.0  end;

    if iid <> nil then
    with iid^ do                                { When the index variable is OK }
    begin
      idev_val.val_frm := vfrm_flt;
      idev_val.flt := bv;                       { Set the index variable at the start value }
      expm := NEW_MACRO_EXPR;                   { Get the expression to integrate as a macro expression }
      if sy <> rparen then SRC_ERROR( mdnam, 23, e_error );     { Check now because the sy value after GET_FLT_MEXPR is not significant }
      GET_FLT_MEXPR( expm, flt_typ, blsq );     { Evaluate the expression for compilation test (result in exp_res) }

      if blsq and nvasv then
      begin
        ide_flg := [objf_lsqiv,objf_lsqob];     { Set the Index Variable flags }
        exp_nva := true;                        { Set th expression compilation mode }
        OUT_PCD_LINDEX( iid );                  { Output the Index variable definition }
        OUT_PCD_CONST( bv );                    { Output the begin, end and step values }
        OUT_PCD_CONST( ev );
        OUT_PCD_CONST( sv );
        GET_FLT_MEXPR( expm, nil, blsq );       { Output the expression to summ, the result expression ref. is in exp_res }
        OUT_PCD_INTSUMM_ND( false );            { Output the summation node }
        exp_res.exp_flg := [objf_lsqob,objf_lsqex];     { Set the LSQ compiled expression status flags }
        PUSH_EXPRESSION( exp_res )
      end
      else
      begin { We skip the first point (in the table) that is already evaluated }
        nit :=  ROUND( (ev - bv)/sv );
        iit :=   1;
        val := exp_res.exp_val.flt;             { Get the formulae result for the begin value }
        while iit <= nit do
        begin
          idev_val.flt := bv + sv*iit;          { Set the index value }
          val := val + GET_FLT_VALUE( expm );   { Add the new series term }
          iit := iit + 1
        end;
        EXP_PUTFLT( val )                       { Put the total in the operational stack }
      end;
      PURGE_MACRO_EXPR( expm )
    end else SKIP_SYMBOL( rparen );
    exp_nva := nvasv;                           { Restore the original expression management mode }
    DISPLAY_FREE
  end
end FNC_SUMMATION;



[global]
procedure FNC_SUMMDATA;
const
  mdnam = 'SUMD';

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the function name "summ_data" }
    if sy = lparen then INSYMBOL
                   else SRC_ERROR( mdnam, 22, e_error );


    if sy = rparen then INSYMBOL
                   else SRC_ERROR( mdnam, 23, e_error )
  end
end FNC_SUMMDATA;



[global]
procedure FNC_SELECT;
const
  mdnam = 'FSEL';
  maxnp =     64;

var
  npa, nsl:    integer;
  exp:         exp_rec;

begin
  exp := exp_null;
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the function name "Select" }
    if sy = lparen then INSYMBOL
                   else SRC_ERROR( mdnam, 22, e_error );
    GET_TYPE_EXPRESSION( exp, int_typ, false );
    if not (objf_lsqex in exp.exp_flg) then
    begin
      if sy = comma then INSYMBOL
                    else SRC_ERROR( mdnam, 29, e_error );
      nsl := exp.exp_val.int;
      while nsl > 0 do begin  SKIP_SYMBOL( comma ); INSYMBOL; nsl := nsl - 1  end;
      EXPRESSION;
      SKIP_SYMBOL( rparen )
    end
    else
    begin
      npa := 0;
      while (npa < maxnp) and (sy = comma) do
      begin
        INSYMBOL;
        GET_EXPRESSION( exp );
        OUT_PCD_VREF( exp );
        npa := npa + 1
      end;
      if sy <> rparen then
      begin  SRC_ERROR( mdnam, 508, e_severe ); SKIP_SYMBOL( rparen )  end;
      OUT_PCD_SELECT( npa );
      PUSH_EXPRESSION( exp )
    end;

    if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
  end;
  EXPRV_REMOVE( exp )
end FNC_SELECT;


end MXD_DCP_ITEM.
