{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*                MXD   Data   Compiler  Insymbol   Module                     *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module DCP_INSYMB;

  %include       'MXDSRC:mxd_dcp_env';          { Load the MXD data Compiler Environment }


const

  { File specification and its length }

  defcmd        = 'MXDLIB:mxd_env.std';         { Initial command file }
  defmlib       =  'MXDLIB:mxdlib.mxl';         { Default macro library }
  errspcfile    = 'MXDLIB:mxd_cmp.err';         { Error message spc. file }

  prompt        =              ' MXD>';         { Terminal Input Prompt }

  TMdName       =      'M X D - D C P';         { Title Module Name part for page heading }

  { Constant parameters }

  maxstksymbsize       =            32;         { Maximum size of symbol stack }
  maxerrcnt            =            32;         { Maximum allowed error count }

  diftabln             =            50;         { Maximum length of a Interpolable table }




  { ******************************************************************** }
  { *******    Types to get and parse a MXD command/Directive    ******* }
  { ******************************************************************** }





  { ******************************************************************** }
  { ***********  Variables to get and parse a SHELL command  *********** }
  { ******************************************************************** }

var

  initlib_path:         str_ptr := nil;         { Current path }

  exp_stkp:               integer := 0;         { Current stack pointer level }
{ exp_stk:    array[1..max_stk] of exp_rec;     { Expression stack }
{ exp_res:     [global] exp_rec;                { Current expression }

{ sym_iof:  array[1..max_lun] of iocnt_rec;     { User text file }

  stmp:                         string;         { Temporary string }






{ **************************************************************************** }
{ ***********  Small Routines to manage the identifier/macro tree  *********** }
{ **************************************************************************** }


[global]
procedure SAVE_SYM_CNTX( svall: boolean := false );
var
  p: symc_ptr;
{ Save the INSYMBOL context.
  When <svall> is true, the current symbol context is also saved
  else only the source input context is saved.
}

begin
  NEW( p );
  with p^ do
  begin
    symc_prv   := symc_stk;
    symc_ch    := sy_ch;
    symc_cmin  := sy_cmin;
    symc_svall := svall;
    if svall then
    begin
      symc_sym  := sy_sym;
      symc_ival := sy_ival;
      symc_rval := sy_rval;
      case sy_sym.sy of
        identsy:  begin
                    NEW( symc_string, sy_ident.length );
                    symc_string^ := sy_ident
                  end;
        stringconst: begin
                    NEW( symc_string, sy_string.length );
                    symc_string^ := sy_string
                  end
      otherwise
      end
    end
  end;
  symc_stk  := p
end SAVE_SYM_CNTX;




[global]
procedure RESTORE_SYM_CNTX;
{ Restore the previously saved INSYMBOL context.
}

var
  p: symc_ptr;

begin
  p := symc_stk;
  with p^ do
  begin
    symc_stk := symc_prv;
    sy_ch    := symc_ch;
    sy_cmin  := symc_cmin;
    if symc_svall then
    begin
      sy_sym   := symc_sym;
      sy_ival  := symc_ival;
      sy_rval  := symc_rval;
      case sy_sym.sy of
        identsy:  begin
                    sy_ident := symc_string^;
                    DISPOSE( symc_string )
                  end;
        stringconst: begin
                    sy_string := symc_string^;
                    DISPOSE( symc_string )
                  end;
      otherwise
      end
    end
  end;
  DISPOSE( p )
end RESTORE_SYM_CNTX;



[global]
procedure GEN_MACRO_CODE;
{ Generate the macro text in the <idm_newmac^> record.
  If <idm_newmac> is nil, a new <idm_newmac^> record is generated,
  else the <idm_newmac^> record can be extended.
}

var
  p: idm_apt;

begin
  if (sy_ch <> ' ') or not idm_space then
  begin { A character must be put in the macro code }
    if sy_ch <= ' ' then idm_space := true
                    else idm_space := false;
    if idm_newmac = nil then
    begin
      NEW( idm_newmac, idm_mac_all );
      with idm_newmac^ do
      begin
        idm_use  :=   1;
        idm_ctb[1] := sy_ch
      end
    end
    else
      if idm_newmac^.idm_use >= idm_newmac^.idm_size then
      begin { Too large macro we must extend the macro code array }
        p := idm_newmac;
        NEW( idm_newmac, p^.idm_size + idm_mac_all );
        with idm_newmac^ do
        begin { We must extend the macro record }
          idm_use  := p^.idm_use + 1;
          for i := 1 to p^.idm_use do idm_ctb[i] := p^.idm_ctb[i];
          idm_ctb[idm_use] := sy_ch
        end;
        DISPOSE( p )
      end
      else
      with idm_newmac^ do
      begin
        idm_use := idm_use + 1;
        idm_ctb[idm_use] := sy_ch
      end
  end
end GEN_MACRO_CODE;



[global]
function SEARCH_MACRO( knd: idm_kinds ): idm_ptr;
{ Search the specified macro symbol in macro symbol list
  and return its address (or nil when it was not found.
}

var
  p: idm_ptr;

begin
  p := idm_defstk;
  while p <> nil do
  with p^ do
  begin
    if (knd = idm_undef) or (knd = idm_kind) then
      if (idm_name <> nil) and not idm_run then
        if STR_MATCH( sy_ident, idm_name^ ) = 0 then exit;
    p := idm_prv
  end;
  SEARCH_MACRO := p
end SEARCH_MACRO;




[global]
procedure ACTIVE_MACRO_CODE( p: idm_ptr; svall: boolean := false );
{ Active (for interpretation) the specified <p^> macro reference.
}

begin
  if p <> nil then
  with p^ do
  begin
    idm_nch    := 1;                    { Set the macro index to begin of code }
    SAVE_SYM_CNTX( svall );             { Save the current INSYMBOL context }
    idm_run    := true;                 { Set the run flag }
    idm_cntx   := idm_actstk;           { Push it in the active stack }
    idm_actstk := p;
    sy_ch      := ' '                   { Set sy_ch for next INSYMBOL call }
  end
end ACTIVE_MACRO_CODE;




procedure OUT_MACRO_LINE;
{ Output the macro expanssion line (on the current listing file).
}

  procedure OUT_MACRO_LINE_TEXT( var f: text; bterm: boolean );
  var
    mxl: integer;

  begin
    with sy_maclst, lst_current^ do
    begin
      if not bterm then LST_NEWLINE;
      WRITE( f, ' ':7, 'ME':13 );
      mxl := lst_lnsize - 20;
      if mxl >= length then
        WRITELN( f, sy_maclst )
      else
      begin
        WRITELN( f, sy_maclst:mxl );
        if not bterm then LST_NEWLINE;
        sy_maclst := SUBSTR( sy_maclst, mxl + 1 );
        WRITELN( f, ' ':7, 'ME_next':13, sy_maclst )
      end
    end
  end OUT_MACRO_LINE_TEXT;

begin { OUT_MACRO_LINE }
  with src_control^, lst_current^ do
  begin
    OUT_MACRO_LINE_TEXT( lst_file, false );
    if src_errnb > 0 then SRC_OUT_MAC_ERROR( OUT_MACRO_LINE_TEXT );
    sy_maclst.length := 0
  end
end OUT_MACRO_LINE;




[global]
procedure RET_OF_MACRO_CODE( p: idm_ptr );
{ Return to previous source context after a
  macro interpretation.
}

begin
  if p = idm_actstk then
  with p^ do
  begin
    if debug_mac then                   { When required ... }
      OUT_MACRO_LINE;                   { ... output the macro code }
    RESTORE_SYM_CNTX;                   { Restore the INSYMBOL context }
    idm_run    := false;                { Clear the run flag }
    idm_actstk := idm_cntx              { Set the old context }
  end
end RET_OF_MACRO_CODE;




procedure FREE_TEMP_MAC;
{ Free the temporary macro source.
  It is used for the loops (WHILE <cond> DO, REPEAT and FOR ... ) interpretation.
}
var
  p: idm_ptr;

begin
  p := idm_actstk;
  if p <> nil then
  begin
    with p^ do
    begin
      if debug_sym and (idm_tab <> nil) then
        with idm_tab^, lst_current^ do
          WRITELN( lst_file, ' Free the Temporary_Mac_Temp ', ' "', idm_ctb:idm_use, '".' );
      idm_actstk := idm_cntx;
      idm_tmphde := idm_parl;
      if idm_tab <> nil then DISPOSE( idm_tab )
    end;
    DISPOSE( p )
  end
end FREE_TEMP_MAC;







[global]
procedure INSYMBOL;
{ Read a syntax element from the current source and return the
  it in the sy_* identifiers (the INSYMBOL context).
  The source can be an source input file or a macro soyurce record.
  When a macro identifier is found, automaticaly, INSYMBOL start
  the formal parameter interpretation of an active macro.
}

const
  mdnam = 'INSY';

  ten   =   10.0;
  one   =    1.0;

  max_dblpow = 307;
  max_fltpow =  38;

  in_min = ORD( 'a' ) - ORD( 'A' );

type
  chartype = (ctl, oth, dig, let, quo,
              db0, db1, db2, db3,
              eos, eol, eom, idi,
              s00, s01, s02, s03, s04, s05, s06, s07,
              s08, s09, s10, s11, s12, s13, s14, s15, s16);

  chartabtype = array[CHR( 0 )..CHR( 127 )] of chartype;

  chartoktab = array[s00..s16] of sym_rec;

var
  chartab: [static] chartabtype := (
  { octal   0    1    2    3    4    5    6    7        ASCII design name or replesentation     }
  { 000 } eos, eol, eom, ctl, ctl, ctl, ctl, ctl, { NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL = ^@, ^A, ^B, ^C, ^D, ^E, ^F, ^G }
  { 010 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl, {  BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI = ^H, ^I, ^J, ^K, ^L, ^M, ^N, ^O }
  { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl, { DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB = ^P,XON, ^R,XOFF,^T, ^U, ^V, ^W }
  { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl, { CAN,  EM, SUB, ESC,  FS,  GS,  RS,  US = ^X, ^Y, ^Z, ^[, ^\, ^], ^^, ^- }
  { 040 } oth, s00, s01, let, let, let, s02, quo, { ' ', '!', '"', '#', '$', '%', '&', "'" }
  { 050 } s03, s04, s05, s06, s07, s08, db3, s09, { '(', ')', '*', '+', ',', '-', '.', '/' }
  { 060 } dig, dig, dig, dig, dig, dig, dig, dig, { '0', '1', '2', '3', '4', '5', '6', '7' }
  { 070 } dig, dig, db0, s10, db1, s11, db2, s16, { '8', '9', ':', ';', '<', '=', '>', '?' }
  { 100 } let, let, let, let, let, let, let, let, { '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G' }
  { 110 } let, let, let, let, let, let, let, let, { 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O' }
  { 120 } let, let, let, let, let, let, let, let, { 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W' }
  { 130 } let, let, let, s12, s13, s14, s15, let, { 'X', 'Y', 'Z', '[', '\', ']', '^', '_' }
  { 140 } oth, let, let, let, let, let, let, let, { '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g' }
  { 150 } let, let, let, let, let, let, let, let, { 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o' }
  { 160 } let, let, let, let, let, let, let, let, { 'p', 'q', 'r', 's', 't', 'u', 'v', 'w' }
  { 170 } let, let, let, oth, s00, oth, oth, ctl);(*'x', 'y', 'z', '{', '|', '}', '~', DEL*)

  chartok: [static] chartoktab := (
    (lgorop,    or_op   ), {s00: '!' = '|'}
    (attrsign,  no_op   ), {s01: '"'}
    (lgandop,   and_op  ), {s02: '&'}
    (lparen,    no_op   ), {s03: '('}
    (rparen,    no_op   ), {s04: ')'}
    (mulop,     mul_op  ), {s05: '*'}
    (addop,     add_op  ), {s06: '+'}
    (comma,     no_op   ), {s07: ','}
    (addop,     sub_op  ), {s08: '-'}
    (mulop,     div_op  ), {s09: '/'}
    (semicolon, stp_op  ), {s10: ';'}
    (relop,     eq_op   ), {s11: '='}
    (lbrack,    no_op   ), {s12: '['}
    (notop,     not_op  ), {s13: '\'}
    (rbrack,    no_op   ), {s14: ']'}
    (powop,     pow_op  ), {s15: '^'}
    (questsign, no_op   )  {s16: '?'}
    );
var
  ivl, i, iprec, j, k, n, scale, radix: integer;
  rdig, rexp, rfac, rval:               mxd_flt;
  pch: char;
  getnuchar, maxstr, found, sign,
  bint, bline_enabled:                  boolean;
  pkw:                              keyword_ptr;
  idp:                                  ide_ptr;


  procedure NEXTCH;
  { Sub-Routine to get a new character from the current source.
    Performs an automatic return from any active formal of an active
    macro.
  }
  var
    beoln: boolean;

  begin { NEXTCH }
    if idm_actstk <> nil then
    with idm_actstk^, idm_tab^ do
    begin
      if idm_nch > idm_use then         { Use of macro code }
        case idm_kind of
          idm_parm, idm_temp:
            begin                       { Call return of macro param code }
              idm_run    := false;
              RESTORE_SYM_CNTX;
              if idm_kind = idm_temp then FREE_TEMP_MAC
                                     else idm_actstk := idm_cntx
            end;
        otherwise
          sy_ch := CHAR( 2 )
        end
      else
      begin
        sy_ch := idm_ctb[idm_nch];
        idm_nch := idm_nch + 1
      end;
      if debug_mac and (idm_actstk <> nil) then
      with sy_maclst do
      begin                             { Build the macro expanssion list line }
        if length >= capacity then OUT_MACRO_LINE;
        if sy_ch >= ' ' then
        length := length + 1;
        if sy_ch >= ' ' then body[length] := sy_ch
                        else body[length] := ' '
      end
    end
    else sy_ch := SRC_INCHAR;
    if idm_outmacro then GEN_MACRO_CODE;
    sy_cmin := sy_ch;
    if (sy_ch >= 'A') and (sy_ch <= 'Z') then
      sy_cmin := CHR( ORD( sy_ch ) + in_min )
  end NEXTCH;


  function CHAR_NEXT: char;
  { Sub-Routine to get the following source character without
    change the read source pointer position.
  }
  begin { CHAR_NEXT }
    if idm_actstk <> nil then
    with idm_actstk^, idm_tab^ do
      if idm_nch > idm_use then CHAR_NEXT := CHR( 2 )
                           else CHAR_NEXT := idm_ctb[idm_nch]
    else CHAR_NEXT := SRC_NEXT_CHAR;
  end CHAR_NEXT;


  procedure PUT_CHAR;
  { Sub-Routine to put the current character in the
    <sy_string> string (used to store any constant string).
  }
  begin { PUT_CHAR }
    if not maxstr then
    if k < str_maxsize then
    begin
      sy_string.body[k] := sy_ch; k := SUCC(k)
    end
    else
    begin
      SRC_ERROR( mdnam, 12, e_error );
      maxstr := true
    end;
  end PUT_CHAR;



begin {INSYMBOL}

ET_READ: { Label for continue analyse by INSYMBOL after an indirection }

  while sy_ch = ' ' do NEXTCH;
  getnuchar := true;
  with src_control^ do
    { Validate the position error pointer on interpretation position }
    if (idm_actstk <> nil) and debug_mac then src_wchpt := sy_maclst.length 
                                         else src_wchpt := src_chidx;

  with sy_sym do
  case chartab[sy_ch] of
    dig, db3: { Number can be begin by digit or period }
      begin
        sy    :=    period;                     { Assume '.' until shown otherwise }
        op    :=     no_op;
        iprec :=         0;
        rval  :=       0.0;
        rexp  :=       ten;
        rfac  :=       one;
        while chartab[sy_ch] = dig do
        begin
          sy := intconst;                       { It is a number }
          rdig := ORD( sy_ch ) - ORD( '0' );
          NEXTCH;
          rval := rval*ten + rdig;
          iprec := iprec + 1
        end;
        if sy_ch = '.' then
        begin
          if CHAR_NEXT = '.' then               { ".." is following }
            if sy = period then
            begin { our syntax unit }
              NEXTCH;
              sy := twodot
            end
            else getnuchar := false             { For the next syntax unit }
          else
          begin                                 { Decimal period }
            NEXTCH;
            if chartab[sy_ch] <> dig then
              getnuchar := false
            else
            begin
              sy := doubleconst;
              while chartab[sy_ch] = dig do
              begin
                rdig := ORD( sy_ch ) - ORD( '0' );
                NEXTCH;
                rfac := rfac / ten;
                rval := rval + rfac*rdig;
                iprec := iprec + 1
              end
            end
          end
        end;

        if (sy <> period) and (sy <> twodot) then
        begin
          if sy_cmin = 'e' then
          begin
            sy := doubleconst;
            NEXTCH;
            if (sy_ch = '+') or (sy_ch = '-') then
            begin
              if sy_ch = '-' then rexp := one/rexp;
              NEXTCH
            end;
            ivl := 0;
            while chartab[sy_ch] = dig do
            begin
              ivl := ivl*10 + (ORD( sy_ch ) - ORD( '0' ));
              NEXTCH
            end;
            if ivl > max_dblpow then
            begin
              SRC_ERROR( mdnam, 11, e_error );
              ivl := max_dblpow; rval := one
            end
            else { For two large exponante we force the double precision }
              if ivl > max_fltpow then iprec := max_single + 1;
            rfac := one;
            while ivl <> 0 do
            begin
              if ODD( ivl ) then
              begin
                ivl := ivl - 1;
                rfac := rfac*rexp
              end
              else
              begin
                ivl := ivl div 2;
                rexp := SQR( rexp )
              end
            end;
            rval := rval*rfac
          end;
          if sy = intconst then
            if (rval <= unsmax) and (rval >= intmin) then
            begin { Set unsigned value in integer equivalent }
              if rval > intmax then sy_ival := TRUNC( unsmax - rval ) + 1
                               else sy_ival := TRUNC( rval );
              sy_rval := sy_ival;
            end
            else
            begin
              sy_ival := 0;
              if iprec > max_single then sy := doubleconst
                                    else sy := singleconst
            end
          else
           if iprec <= max_single then sy := singleconst;

          sy_rval := rval;
          getnuchar := false
        end
      end;

    s01: { Macro replacing character '"' }
      begin
        NEXTCH; INSYMBOL;                       { Skip the replacing character and get the next symbol }
        if idm_outmacro or sy_noexec then
        begin { Put it in macro text only }
          if sy = lparen then
          begin
            k := 0;
            repeat
              INSYMBOL;
              if sy = lparen then k := k + 1
                             else if sy = rparen then k := k - 1
            until (k = 0) or (sy = peofsy) or (sy = eomcsy);
            if sy <> rparen then SRC_ERROR( mdnam, 23, e_severe )
          end
          else
            if (sy <> identsy) and (sy <> stringconst) then SRC_ERROR( mdnam, 375, e_severe )
        end
        else
        begin { Simule a macro parameter with a string }
          if sy = lparen then
          begin
            INSYMBOL;
            GET_STREXPR( sy_string );           { Get the Macro text String }
            if sy <> rparen then SRC_ERROR( mdnam, 23, e_severe )
          end
          else if sy <> stringconst then
          begin
            sy_string.length := 0;
            if sy = identsy then
            begin
              idp := IDE_SEARCH( true );
              if idp <> nil then
                with idp^, idev_val do
                  if val_frm = vfrm_str then
                    if str <> nil then sy_string := str^
            end
          end;
          if sy_string.length > 0 then
          begin
            NEW( sy_macro );                    { Build a Temporary Unnamed Macro Parameter }
            with sy_macro^ do
            begin
              idm_name   := nil; idm_parl   := idm_tmphde;
              idm_cntx   := nil;    idm_nxt    := nil;
              idm_prv    := nil;  idm_run    := false;
              idm_kind   := idm_temp;
              NEW( idm_tab, sy_string.length );
              with idm_tab^ do
              begin
                idm_use := sy_string.length;
                for ii := 1 to sy_string.length do idm_ctb[ii] := sy_string[ii];
                ACTIVE_MACRO_CODE( sy_macro );
                if debug_sym then
                  WRITELN( lst_current^.lst_file, ' Temporary_Mac_Temp read at ', idm_nch:3,
                           ' "', idm_ctb:idm_use, '".' )
              end
            end;
            idm_tmphde := sy_macro;             { Push it in the temporary stack }
            goto ET_READ
          end
          else
          begin
            if debug_sym then WRITELN( lst_current^.lst_file, ' Temporary_Mac_Temp = nil.');
            SRC_ERROR( mdnam, 376, e_error )
          end;
          getnuchar := false { Do'nt get the next character - it's already done }
        end
      end;

    let: { Keyword or Identifier }
      with sy_ident do
      begin
        k := sy_maclst.length - 1;
        if idm_outmacro and (idm_newmac <> nil) then n := idm_newmac^.idm_use - 1;
        length := 0;
        repeat
          if length < ide_maxsize then
          begin
            { Map to lower case in keywords and identifiers }
            length := SUCC( length );
            body[length] := sy_cmin
          end;
          NEXTCH
        until (chartab[sy_ch] <> let) and (chartab[sy_ch] <> dig);
        { How search for known keyword }
        pkw := keyword_tree;

        repeat
          with pkw^ do
          begin
            i := STR_MATCH( sy_ident, name^ );
            if i <> 0 then
              if i > 0 then pkw := rightp else pkw := leftp
          end
        until (i = 0) or (pkw = nil);
        if pkw = nil then                       { It is an identifier or a macro identifier }
        begin
          sy_macro := SEARCH_MACRO( idm_undef );
          sy := identsy; op := no_op;
          if (sy_macro <> nil) and not sy_nomacrflg then
          begin
            { a Macro symbol is found }
            if sy_macro^.idm_kind = idm_parm then
            with sy_macro^, lst_current^ do
            begin { It is a macro formal parameter }
              { We supress the parameter name from the Macro expanssion Listing }
              if k >= 0 then sy_maclst.length := k 
                        else sy_maclst.length := 0;
              if idm_outmacro then
                { We suppress it also from the macro code to build }
                if n >= 0 then idm_newmac^.idm_use := n
                          else idm_newmac^.idm_use := 0;
              if debug_sym then
                if idm_tab <> nil then
                with idm_tab^ do
                  WRITELN( lst_file, ' Mac_Parm read at ', idm_nch:3,
                           ' "', idm_ctb:idm_use, '".' )
                else
                  WRITELN( lst_file, ' Mac_Parm = nil.');

              if idm_tab <> nil then ACTIVE_MACRO_CODE( sy_macro );
              INSYMBOL
            end
          end
        end
        else  sy_sym   := pkw^.symb; { It is a known keyword }
        getnuchar := false
      end;

    quo: { Quote }
      begin
        op := no_op;
        { Set line mode to ignore any end of line or comment mark }
        with src_control^ do
        begin
          bline_enabled := (src_linemode in src_flags);
          src_commentty := src_nocomment;
          src_flags := src_flags + [src_linemode]
        end;
        sy := stringconst;
        k := 1; maxstr := false;
        bint := true;
        while bint do
        begin
          NEXTCH;
          while chartab[sy_ch] = eol do NEXTCH; { Skip the end of line }
          if chartab[sy_ch] = eos then bint := false;
          if sy_ch = '''' then
          begin
            src_control^.src_commentty := src_pascomment;
            NEXTCH;
            if sy_ch = '''' then
            begin
              src_control^.src_commentty := src_nocomment;
              PUT_CHAR
            end
            else bint := false
          end
          else PUT_CHAR
        end;
        sy_string.length := PRED(k);
        getnuchar := false;
        with src_control^ do
          if not bline_enabled then
          begin
            src_flags := src_flags - [src_linemode];
            if chartab[sy_ch] = eol then sy_ch := ' '
          end
      end;

    db0: { ':' or ':=' }
      begin
        NEXTCH;
        op := no_op;
        if sy_ch = '=' then sy := becomes
        else
        begin
          sy        := colon;
          getnuchar := false
        end
      end;

    db1: { '<' or '<=' or '<>' }
      begin
        NEXTCH;
        sy := relop;
        if sy_ch = '=' then op := le_op
        else
        if sy_ch = '>' then op := ne_op
        else
        begin
          op        := lt_op;
          getnuchar := false
        end
      end;

    db2: { '>' or '>=' }
      begin
        NEXTCH;
        sy := relop;
        if sy_ch = '=' then op := ge_op
        else
        begin
          op        := gt_op;
          getnuchar := false
        end
      end;

    s00: { '!', '|' = "logical or" or '!!','||' = "concatenation" }
      begin
        pch := sy_ch;
        NEXTCH;
        if sy_ch = pch then
        begin
          sy := addop;
          op := concat_op
        end
        else
        begin
          sy := lgorop;
          op :=  or_op;
          getnuchar := false
        end
      end;

    s02, s03, s04, s06, s07,
    s08, s09, s10, s12, s13, s14, s15, s16:
      sy_sym := chartok[chartab[sy_ch]];

    s05: { '*' look at power '**' }
      begin
        NEXTCH;
        if sy_ch = '*' then
        begin
          sy :=  powop;
          op := pow_op
        end
        else
        begin
          sy_sym    := chartok[s05];
          getnuchar := false
        end
      end;

    s11: { '=>' = "implicate" }
      begin
        NEXTCH;
        if sy_ch = '>' then
        begin
          sy := implic;
          op :=  no_op
        end
        else
        begin
          sy_sym    := chartok[s11];
          getnuchar := false
        end
      end;

    eos: { end_of_file }
      begin
        sy := peofsy;
        op := stp_op
      end;

    eom: { end of macro }
      begin
        sy := eomcsy;
        op := stp_op;
        getnuchar := false;
        sy_ch := ' '
      end;

    eol: { end_of_line }
      begin
        sy := eolnsy;
        op :=  no_op;
        getnuchar := not data_mode;
        sy_ch := ' '
      end;

  otherwise
    sy := nothing;
    op :=   no_op;
    getnuchar := false;
    if sy_ch <> ' ' then SRC_ERROR( mdnam, 13, e_error );
    sy_ch := ' '
  end { case chartab };

  if debug_mac and (idm_actstk <> nil) then { We are in macro execution mode }
    if (sy_maclst.length >= 80) or (sy_sym.sy = semicolon) then OUT_MACRO_LINE;

  if debug_sym then
  with sy_sym, lst_current^ do
  begin
    WRITE( lst_file, ' D_symbol: ', sy );
    case sy of
      identsy:     WRITELN( lst_file, ' "', sy_ident, '".' );
      singleconst,
      doubleconst: WRITELN( lst_file, ' ', sy_rval );
      intconst:    WRITELN( lst_file, ' ', sy_ival );
      stringconst: WRITELN( lst_file, ' "', sy_string, '".' );
      unaop, powop, mulop, addop,
      relop, notop, lgandop, lgorop:
                   WRITELN( lst_file, ' ', op );
    otherwise
      WRITELN( lst_file )
    end
  end;
  if getnuchar then NEXTCH
end INSYMBOL;




[global]
procedure SKIP_SYMBOL( tosymbol: symbol );
{ To skip any group of syntax unit to
  continue after an error, or ignore
  a sequence (example: if condition not satisfied).
}

const
  mdnam = 'SKPS';

var
  bif, sve:    boolean;
  lsy:          symbol;

begin { SKIP_SYMBOL }
  sve := sy_noexec;
  sy_noexec := true;
  bif := (tosymbol = elsesy);
  with sy_sym, src_control^ do 
  while (sy <> tosymbol) and (sy <> eofsy) and
        (sy <> peofsy) and (sy <> endsy) and
        (sy <> eomcsy) do
  begin
    INSYMBOL;
    case sy of
      ifsy:
        begin
          src_insnb := src_insnb + 1;
          SKIP_SYMBOL( elsesy );
          if sy = elsesy then SKIP_SYMBOL( endsy );
          if sy <> endsy then SRC_ERROR( mdnam, 108, e_severe );
          src_insnb := src_insnb - 1;
          sy := nothing
        end;

      beginsy, loopsy, dosy, casesy:
        begin
          src_insnb := src_insnb + 1;
          SKIP_SYMBOL( endsy );
          src_insnb := src_insnb - 1;
          if sy <> endsy then SRC_ERROR( mdnam, 108, e_severe )
                         else sy := nothing
        end;

      macrosy:
        begin
          src_insnb := src_insnb + 1;
          SKIP_SYMBOL( endmacrosy );
          src_insnb := src_insnb - 1;
          if sy <> endmacrosy then SRC_ERROR( mdnam, 108, e_severe )
                              else sy := nothing
        end;

      lparen:
        begin
          SKIP_SYMBOL( rparen );
          if sy <> rparen then SRC_ERROR( mdnam, 23, e_severe )
                          else sy := nothing
        end;

      rparen:
        if tosymbol = comma then tosymbol := rparen;

      lbrack:
        begin
          SKIP_SYMBOL( rbrack );
          if sy <> rbrack then SRC_ERROR( mdnam, 26, e_severe )
                          else sy := nothing
        end;

      repeatsy:
        begin
          src_insnb := src_insnb + 1;
          SKIP_SYMBOL( untilsy );
          src_insnb := src_insnb - 1;
          if sy <> untilsy then SRC_ERROR( mdnam, 123, e_severe )
                           else sy := nothing
        end;

      elsesy:
        if not bif then SRC_ERROR( mdnam, 124, e_severe );

      semicolon:
        if tosymbol = comma then tosymbol := semicolon;

    otherwise
    end
  end;
  sy_noexec := sve
end SKIP_SYMBOL;



[global]
function  INPUT_LETTER: char;
{ To get a letter symbol for pragma, lattice ... }
var
  ch: char;

begin
  with sy_sym do
    if sy = identsy then ch := sy_ident[1]
    else
      if sy = stringconst then
        if sy_string.length > 0 then ch := sy_string[1]
                                else ch := ' ';
  { Always set letter in minor case }
  if (ch >= 'A') and (ch <= 'Z') then ch := CHR( ORD( ch ) + 32 );
  INPUT_LETTER := ch
end INPUT_LETTER;



[global]
procedure PRAGMA_STATE( p_src: src_ptr );
const
  mdnam = 'PRAG';

type
  optionsty = ( opt_liston,   opt_listoff,
                opt_echoon,   opt_echooff,
                opt_listlvl,  opt_format,
                opt_sh_sym,   opt_sh_exp,
                opt_sh_mac,   opt_macsrc,
                opt_sh_dat,
                opt_C, opt_D, opt_E, opt_F, opt_L, opt_M, opt_P
              );

var
  { warning this table must be modified when the identifier size is changed }
  opttab: [static] array[optionsty] of string( 15 ) := (
  'list_on',            { List on }
  'list_off',           { List off }
  'echo_on',            { Echo on }
  'echo_off',           { No echo }
  'listlvl',            { Listing source level }
  'format',             { Listing source format }
  'show_syntax',        { Listing of readen syntax unit by INSYMBOL }
  'show_expr',          { Listing of readen syntax unit by INSYMBOL }
  'show_macro',         { Listing of macro expension }
  'show_macrosrc',      { Listing of macro source at macro creation }
  'show_data',          { Listing of macro expension }
  'c', 'd', 'e', 'f', 'l', 'm', 'p' { Old supported MXD-V3 options }
  );

  i, ipa, iln, ierr:           integer;
  plist:                lst_ptr := nil;
  save_status:               src_flagw;
  bok, bpar, bsg, bsp:         boolean;
  ch:                             char;
  option:                    optionsty;
  sopt, fspc:               str_string;


  procedure PRAGMA_OPT_FLAG( var bflg: boolean );
  begin
    with sy_sym, p_src^ do
      if sy = colon then
      begin  INSYMBOL; bflg := (GET_INTEXPR( 1 ) > 0)  end
      else bflg := not bflg;
  end PRAGMA_OPT_FLAG;



begin { PRAGMA_STATE }
  with sy_sym, p_src^ do
  begin
    bpar := (sy = lparen);                                      { Set the variable_driving(=VDM)/traditional mode }
    sy := comma;                                                { Simule a comma }
    save_status := src_flags;
    while sy = comma do                                         { Loop on all pragma specifications }
    begin
      bok := true;                                              { Assume option correct until shown otherwise }
      INSYMBOL;
      if bpar then
        GET_STREXPR( sopt )                                     { For VDM, get the option name string }
      else
      begin
        if (sy = stringconst) and (sy_string.length >= 1) then
          sopt := sy_string                                     { Option name is in a string }
        else if sy = identsy then
          sopt := sy_ident                                      { Option name is an identifier }
        else
        begin
          SRC_ERROR( mdnam, 201, e_severe );                    { Illegal pragma option form error }
          SKIP_SYMBOL( comma );                                 { Skip to next option or ";" }
          bok := false
        end
      end;

      if bok then                                               { When an option name can be search }
      begin
        bok := false;
        for popt := optionsty"first to optionsty"last do        { Option name search loop }
        begin
          option := popt;
          bok := (STR_MATCH( sopt, opttab[popt] ) = 0);         { Equal strings ? }
        exit if bok                                             { Stop loop when found }
        end
      end;

      if bok then                                               { When the option name is found }
      begin
        INSYMBOL;                                               { Goggle up the option name }
        if option >= opt_d then                                 { When an old MXD-V3 option is used }
        begin
          if bpar then                                          { For the VDLM mode, ... }
          begin
            if sy = colon then                                  { ... when a flag value is specified, ... }
            begin
              INSYMBOL; i := GET_INTEXPR( -1 );                 { ... we get this flag value and ... }
              bsp := (i >= 0); bsg := (i > 0)                   { ... set the related flags. }
            end
          end
          else if sy = addop then                               { For the traditional MXD-V3 options ... }
          begin
            if (op = add_op) or (op = sub_op) then              { Manage the '+'/'-' specifications }
            begin  bsp := true; bsg := (op = add_op)  end;
            INSYMBOL
          end
        end;

        case option of
          opt_liston: { * List_on * }
            begin
              if sy = colon then
              with lst_current^ do
              begin
                INSYMBOL;
                GET_STREXPR( fspc );
                ipa := -1; iln := -1;
                if sy = colon then
                begin
                  INSYMBOL;
                  ipa := GET_INTEXPR( ipa );
                  if sy = colon then
                  begin
                    INSYMBOL;
                    iln := GET_INTEXPR( iln )
                  end
                end;
                { Flush output if some output line is begining }
                if lst_currline^.length > 0 then LST_EOLN;
                LST_OPEN( lst_current, fspc, lst_heading^,
                          lst_title^, lst_sbttl^,
                          iln,                                  { 80/132 for tty/file in char./line }
                          ipa,                                  { TTY/NO => dis./ena. page managment }
                          false,                                { New version mode }
                          false,                                { No print on close time }
                          false,                                { No append }
                          ierr );

                if ierr <> 0 then
                  if not sy_init_mod then                       { If error lst -> terminal }
                    SRC_ERROR_S( mdnam, 211, e_error, fspc )
                  else
                    save_status := save_status - [src_blist]
                else
                begin
                  if src_lstmxlev < src_level then src_lstmxlev := src_level;
                  save_status := save_status + [src_blist]
                end
              end
              else
              begin
                if src_lstmxlev < src_level then src_lstmxlev := src_level;
                save_status := save_status + [src_blist]
              end
            end;

          opt_listoff: save_status := save_status - [src_blist];        { * List_off * }
          opt_echoon:  save_status := save_status + [src_becho];        { * Echo_on * }
          opt_echooff: save_status := save_status - [src_becho];        { * Echo_off * }

          opt_listlvl: { * Listlvl * }
            if sy = colon then
            begin
              INSYMBOL;
              src_lstmxlev := GET_INTEXPR( 1 )
            end else src_lstmxlev := 1;

          opt_format, opt_F: { * Format * }
            if sy = colon then
            begin
              INSYMBOL; src_frspos := GET_INTEXPR( 1 );
              if sy = colon then
              begin  INSYMBOL; src_lstpos := GET_INTEXPR( str_maxsize )  end
            end
            else begin  src_frspos := 1; src_lstpos := 255  end;

          opt_sh_sym: PRAGMA_OPT_FLAG( debug_sym );             { * INSYMBOL Debug * }
          opt_sh_exp: PRAGMA_OPT_FLAG( debug_exp );             { * EXPRESSION Debug * }
          opt_sh_mac: PRAGMA_OPT_FLAG( debug_mac );             { * Macro Debug * }
          opt_sh_dat: PRAGMA_OPT_FLAG( debug_dat );             { * Macro Data Debug * }
          opt_macsrc: PRAGMA_OPT_FLAG( debug_macsrc );          { * Macro source debug * }

          opt_C:        debug_macsrc := bsg;                    { * To enable/disable Macro source output * }
          opt_D:        list_dataflg := bsg;                    { * To enable/disable Data Listing * }
          opt_E: if bsg then save_status := save_status + [src_becho]   { * Echo_on * }
                        else save_status := save_status - [src_becho];  { * Echo_off * }

          opt_L: { * MXD-V3 like 'L' option * }
            begin
              i := -1;
              if sy = colon then
              begin  INSYMBOL; i := GET_INTEXPR( i )  end;
                if bsp then                                     { When an ON/OFF specification is given }
                  if bsg then begin                             { By default we set the max. level to the current one }
                                if src_lstmxlev < src_level then src_lstmxlev := src_level;
                                save_status := save_status + [src_blist]
                              end
                         else save_status := save_status - [src_blist];
                if i >= 0 then src_lstmxlev := i                { When a maximum level is specified, we set it }
              end;

          opt_M:        debug_mac := bsg;                       { * To enable/disable macro expanssion list * }
          opt_P:        debug_dat := bsg;                       { * To enable/disable Macro Data output * }

        otherwise { no legal option }
        end { * end of case * };
        if bpar then
          if sy = rparen then INSYMBOL
                         else SRC_ERROR( mdnam, 23, e_error )
      end { * if bok then * }
      else
        SRC_ERROR_S( mdnam, 202, e_warning, sopt)               { Unknown option ignored }
    end;
    src_flags := save_status
  end
end PRAGMA_STATE;



procedure NOTIFY_SRC_CHANGE( p: src_ptr );
var
  str: string;

begin
  if src_blist in p^.src_flags then
  begin
                 {1234567890123456789012345678901234567890 ... }
    WRITEV( str, '    * * * * The MXD source file is now "', FILE_SPECIFICATION( p^.src_file ), '".' );
    INSERT_MESSAGE( str )
  end
end NOTIFY_SRC_CHANGE;



[global]
procedure INCLUDE_STATE( bincl: boolean );
const
  mdnam = 'INCL';

var
  src_p:               src_ptr;
  fname, fext:      str_string;
  i, ierr:             integer;
  fspc:             str_string;

begin { INCLUDE_STATE }
  INSYMBOL;
  with sy_sym do
  begin
    GET_STREXPR( fspc );
    { By default of file type we set the ".mxd" file type }
    if fspc.length > 0 then                     { We append the mxd extention only for real file }
    begin
      i := INDEX( fspc, '.', -1 );
      if i = 0 then fspc := fspc || '.mxd'
    end;                                        { The null file is equivalent to console }

    src_p := nil;                               { To force allocation by SRC_OPEN ... }
    SRC_OPEN( src_p, fspc, false, ierr);        { ... during the open of file to include }
    io_err^.idev_val.int := ierr;
    if ierr = 0 { no open error } then
    begin
      with src_p^ do
      begin
        src_previous := src_control;            { Link the file to the previous src. }
        src_level := src_control^.src_level;
        if bincl then src_level := src_level + 1;
        src_lstmxlev := src_control^.src_lstmxlev;
        src_insnb := src_control^.src_insnb;
        src_frspos := src_control^.src_frspos;
        src_lstpos := src_control^.src_lstpos;
        src_flags := src_flags +
          src_control^.src_flags * [src_blist,src_bmacroex,src_bphys,
                                    src_becho,src_echerr]
      end;
      if sy = comma then PRAGMA_STATE( src_p ); { Look for %PRAGMA options }

      if bincl then SAVE_SYM_CNTX( true )
               else SRC_END_OF_LINE;

      NOTIFY_SRC_CHANGE( src_p );               { Generate the change source notification }

      src_control := src_p;                     { Switch to new source file }
      sy_ch := ' ';                             { Init the read character }
      sy    := semicolon;                       { Force to unsignificant value }
      if not bincl then                         { Chaine STATEMENT }
      begin
        with src_control^ do
        begin
          src_p := src_previous;
          src_previous := src_p^.src_previous   { Get the true previous src}
        end;
        SRC_CLOSE( src_p, true )                { Elliminate the old source file context }
      end
    end else
    begin
      if not sy_init_mod then
        SRC_ERROR( mdnam, 212, e_severe );      { Cannot open the file }
      SKIP_SYMBOL( semicolon )
    end
  end
end INCLUDE_STATE;



[global]
procedure ENDFILE_STATE;
var
  src_p: src_ptr;

begin { ENDFILE_STATE }
  with src_control^ do
  begin
    if src_previous <> nil then
    begin { Return to a previous source file }
      src_p := src_control;
      src_control := src_p^.src_previous;
      SRC_CLOSE( src_p, true );                 { Close end elliminate old src context }
      NOTIFY_SRC_CHANGE( src_control );         { Generate the change source notification }
      RESTORE_SYM_CNTX                          { Restore the context with symbol in saved varbl. }
    end
    else
      sy_sym.sy := eofsy                        { It is the external end of file }
  end;
end ENDFILE_STATE;



[global]
procedure IN_DATA_VALUE( var val: val_rec; var bs: boolean );
const
  mdnam = 'INDA';

var
  bneg, bread, bsng, bloop: boolean;
  ii, iv:                   integer;
  rv:                       mxd_flt;
  st:                  string( 46 );

  function ERR_HANDLER( ierr: cc__int ): cc__int;
  begin
    if ierr = 51 then
    begin
      SRC_ERROR_S( mdnam, 49, e_error, sy_string );
      ERR_HANDLER := 1
    end else ERR_HANDLER := -1
  end ERR_HANDLER;

begin
  bsng  := false;
  bneg  := false;
  bread := false;
  ESTABLISH( ERR_HANDLER );
  with sy_sym do
  begin
    src_control^.src_flags := src_control^.src_flags + [src_linemode];
    if sy = addop then
      if (op <> add_op) and (op <> sub_op) then
        SRC_ERROR( mdnam, 15, e_error )
      else
      begin
        bread := true; bsng := true;
        bneg  := (op = sub_op);
        INSYMBOL
      end;

    case sy of
      addop:
        begin { "++", "+-", "-+" and "--" as polarization state }
          bread := true;
          if (val.val_frm <> vfrm_int) or ((op <> add_op) and (op <> sub_op)) then
            SRC_ERROR( mdnam, 15, e_error )
          else
            if bsng then val.int := ORD( bneg ) + 2*ORD( op = sub_op ) + 4
        end;

      intconst:
        begin
          bread := true;
          case val.val_frm of
            vfrm_str: begin
                        if bneg then sy_ival := - sy_ival; bsng := false;
                        WRITEV( st, sy_ival ); if val.str <> nil then DISPOSE( val.str );
                        NEW( val.str, st.length ); val.str^ := st
                      end;
            vfrm_int: begin  val.int := sy_ival; if bneg then val.int := -val.int; bsng := false  end;
            vfrm_flt: begin  val.flt := sy_ival; if bneg then val.flt := -val.flt; bsng := false  end;
          otherwise
          end
        end;

      singleconst,
      doubleconst:
        begin
          bread := true;
          case val.val_frm of
            vfrm_str: begin
                        if bneg then sy_rval := - sy_rval; bsng := false;
                        WRITEV( st, sy_rval ); if val.str <> nil then DISPOSE( val.str );
                        NEW( val.str, st.length ); val.str^ := st
                      end;
            vfrm_int: begin  val.int := ROUND( sy_rval ); if bneg then val.int := -val.int; bsng := false  end;
            vfrm_flt: begin  val.flt := sy_rval; if bneg then val.flt := -val.flt; bsng := false  end;
          otherwise
          end
        end;

      stringconst:
        begin
          bread := true;
          case val.val_frm of
            vfrm_str: begin
                        if val.str <> nil then DISPOSE( val.str );
                        if sy_string.length > 0 then
                        begin  NEW( val.str, sy_string.length ); val.str^ := sy_string  end
                        else val.str := nil;
                        bsng := false
                      end;
            vfrm_int: begin  if bneg then  val.int := -val.int; READV( sy_string, val.int ); bsng := false  end;
            vfrm_flt: begin  if bneg then  val.flt := -val.flt; READV( sy_string, val.flt ); bsng := false  end;
          otherwise
          end
        end;

      comma,
      semicolon:
        if bsng and (val.val_frm = vfrm_int) then val.int := ORD( bneg ) + 1; { "+" or "-" as polarization state }

      identsy,
      eolnsy, eofsy, peofsy: ;

    otherwise
      SRC_ERROR( mdnam, 15, e_error )
    end;
    if bread then INSYMBOL;
    if sy = comma then INSYMBOL;
    src_control^.src_flags := src_control^.src_flags - [src_linemode]
  end;
  REVERT;
  bs := bsng
end IN_DATA_VALUE;



[global]
procedure GENERATE_MACRO_PARM( pa: idm_ptr; bpar: boolean; fch: char );
const
  mdnam = 'GMPA';

var
  ll:  integer;
  chs: char;


  procedure MAC_EXPR( blist: boolean );
  var
    icnt: integer;
    bpa:  boolean;

  begin
    bpa  := false;
    icnt :=     0;
    with sy_sym do
    loop
      case sy of
        comma, colon, twodot:
          if (not blist) and (icnt = 0) then exit;
        identsy, intconst, singleconst, doubleconst, stringconst:
          if icnt = 0 then
            if bpa then exit
                   else bpa := true;
        unaop, notop:
          if (icnt = 0) and bpa then exit;
        powop, mulop, addop, relop, lgandop, lgorop:
          if icnt = 0 then bpa := false;
        lbrack, lparen:
          icnt := icnt + 1;
        rbrack, rparen:
          begin
            icnt := icnt - 1;
            if icnt < 0 then exit
          end
      otherwise
        exit
      end;
      if idm_newmac <> nil then ll := idm_newmac^.idm_use - 1;
      INSYMBOL
    end
  end MAC_EXPR;


begin { GENERATE_MACRO_PARM }
  idm_space    := true;
  idm_outmacro := true;
  ll := 0;
  if pa <> nil then
  with sy_sym, pa^, lst_current^ do
  begin
    if idm_newmac <> nil then
      idm_newmac^.idm_use := 0;
    if bpar then
    begin
      chs := sy_ch;   sy_ch := '(';
      GEN_MACRO_CODE; sy_ch := chs
    end;
    GEN_MACRO_CODE; { Put the first character }
    if sy <> semicolon then INSYMBOL; { Get the first syntax unit }
    if (sy <> comma) and (sy <> colon) and (sy <> semicolon) and
       (sy <> rparen) and (sy <> eofsy) then
    begin
      MAC_EXPR( false );

      if debug_macsrc then
        if idm_name = nil then
          if idm_newmac <> nil then
          with idm_newmac^ do
            WRITELN( lst_file, ' Internal Parameter (', ll:-3, ') = "', idm_ctb:idm_use, '"' )
          else
            WRITELN( lst_file, ' Internal Empty Parameter.' )
        else
          if idm_newmac <> nil then
          with idm_newmac^ do
            WRITELN( lst_file, ' Parameter "', pa^.idm_name^, '" (', ll:-3,
                     ') = "', idm_ctb:idm_use, '"' )
          else
            WRITELN( lst_file, ' Empty Parameter "', pa^.idm_name^, '"' );

      if idm_newmac <> nil then idm_newmac^.idm_use := ll;
      chs := sy_ch;
      if bpar then
      begin
        sy_ch := ')'; GEN_MACRO_CODE
      end;
      idm_space := false; sy_ch := ' '; GEN_MACRO_CODE;
      if fch <> ' ' then
      begin
        sy_ch := fch; GEN_MACRO_CODE
      end;
      sy_ch := chs;
      if idm_newmac <> nil then
      begin { Now we adjust the parameter location }
        if idm_tab <> nil then DISPOSE( idm_tab );
        if ll > 0 then
        begin
          ll := idm_newmac^.idm_use;
          NEW( idm_tab, ll );
          with idm_tab^ do
          begin
            idm_use := ll;
            for i := 1 to ll do idm_ctb[i] := idm_newmac^.idm_ctb[i];
            if debug_sym then
            begin
              WRITELN( lst_file, ' M_Parm code loaded :' );
              WRITELN( lst_file, ' "', idm_ctb: ll, '".' )
            end
          end;
          idm_nch := 1
        end;
        idm_newmac^.idm_use := 0
      end
    end
  end;
  idm_outmacro := false
end GENERATE_MACRO_PARM;



[global]
function NEW_MACRO_EXPR: idm_ptr;
{ Create a unnamed macro parameter }
{ The created macro parameter is not put in the defined stack }
var
  p: idm_ptr;

begin
  NEW( p );
  with p^ do
  begin
    idm_name := nil;
    idm_parl := nil;
    idm_cntx := nil;
    idm_nxt  := nil;
    idm_prv  := nil;
    idm_tab  := nil;
    idm_run  := false;
    idm_kind := idm_parm;
    GENERATE_MACRO_PARM( p, false, ';' )
  end;
  NEW_MACRO_EXPR := p
end NEW_MACRO_EXPR;



[global]
procedure PURGE_MACRO_EXPR( var p: idm_ptr );
begin
  if p <> nil then
  begin
    with p^ do
    begin
      if idm_prv <> nil then idm_prv^.idm_nxt := idm_nxt;
      if idm_nxt <> nil then idm_nxt^.idm_prv := idm_prv;
      if idm_tab <> nil then DISPOSE( idm_tab )
    end;
    DISPOSE( p );
    p := nil
  end
end PURGE_MACRO_EXPR;




{ **************    End of DCP_INSYMB    **************** }

end DCP_INSYMB.
