{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*               MXD   Data   Compiler  Expression   Module                    *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_DCP_EXPR;

  %include        'MXDSRC:mxd_dcp_env';         { Load the MXD data Compiler Environment }


const

  max_stk       =                 4096;         { Maximum of expression stack }


[static] var

  stkp_base:            integer :=   -1;        { Current stack base for mfunction return value }
  exp_stkp:             integer :=    0;        { Current stack pointer 151level }

  exp_stk: array[1..max_stk] of exp_rec;        { Expression stack }

  last_ide:             ide_ptr  := nil;        { Pointer to the last already find identifier }




{ ********************************************************************************* }
{ ***********  Expression Management routines of the MXD Data Compiler  *********** }
{ ********************************************************************************* }



[global 'Write_Flg_Rec']
procedure WRITE$OBJECT( flg: obj_flagsty );
var
  bf: boolean;

begin
  WRITE$OBJECT( '[' );
  bf := true;
  for fl := obj_flelm"first to obj_flelm"last do
    if fl in flg then
    begin
      if bf then bf := false
            else WRITE$OBJECT( ',' );
      WRITE$OBJECT( fl )
    end;
  WRITE$OBJECT( ']' );
end WRITE$OBJECT;


[global 'Write_Exp_Rec']
procedure WRITE$OBJECT( var exp: exp_rec );
var
  bf: boolean;

begin
  with exp, exp_val do
  begin
    WRITE$OBJECT( ' (exp_rec) ' ); WRITE$OBJECT( val_frm ); WRITE$OBJECT( ' --> ' );
    if exp_ref <> nil then
    begin  WRITE$OBJECT( 'Ref. "' ); if exp_ref^.ide_name <> nil then WRITE$OBJECT( exp_ref^.ide_name^ ); WRITE$OBJECT( '" ' )  end;
    if exp_typ <> nil then with exp_typ^ do
      if typ_ide <> nil then begin WRITE$OBJECT( '  with type = ' ); WRITE$OBJECT( typ_ide^.ide_name^ )  end;
    WRITE$OBJECT( ' and flg = ' );
    WRITE$OBJECT( exp_flg );
    WRITE$OBJECT( ' : ' );
    case val_frm of
      vfrm_str: if str <> nil then begin  WRITE$OBJECT( '"' ); WRITE$OBJECT( str^ ); WRITE$OBJECT( '"' )  end
                              else WRITE$OBJECT( '"" (nil string)' );
      vfrm_int: WRITE$OBJECT( int, 0 );
      vfrm_flt: WRITE$OBJECT( flt, 12, 6 );
    otherwise
    end
  end
end WRITE$OBJECT;



[global]
procedure TYPE_DISPLAY( p: typ_ptr; lvl: integer := 1 );
var
  fb: boolean;
  fd: ide_ptr;

begin
  if p <> nil then
  with p^ do
  begin
    WRITE( ' ':lvl*2, ' Display the type ' );
    if typ_ide <> nil then WRITE( ' Name = "', typ_ide^.ide_name^, '"' );
    WRITELN( '  Spc-Act# = ', typ_act:0 );
    WRITE( ' ':lvl*2, ' Flags = [' ); fb := false;
    for fl := obj_flelm"first to obj_flelm"last do
      if fl in typ_flg then
      begin
        if fb then WRITE( ',' ) else fb := true;
        WRITE( fl )
      end;
    WRITELN( '],  code = ', typ_frm );

    case typ_frm of
      tfrm_array: begin
                    WRITELN( ' ':lvl*2, '    array[', typ_min:0, '..', typ_siz-typ_min+1:0, '] (stp = ', typ_stp:0, ') of' );
                    TYPE_DISPLAY( typ_ael, lvl+1 )
                  end;
      tfrm_itmty: begin
                    WRITELN( ' ':lvl*2, '    item (siz = ', typ_nfl:0, ') :' );
                    fd := typ_fel;
                    while fd <> nil do
                      with fd^ do
                      begin
                        WRITELN( ' ':lvl*2, ' Field "', ide_name^, '" sq = ', idee_sequnb:0 );
                        TYPE_DISPLAY( ide_typ, lvl+2 );
                        fd := ide_lnk
                      end
                  end;
    otherwise
    end;
  end
end TYPE_DISPLAY;



[global]
procedure EXPRV_REMOVE( var rec: exp_rec );
begin
  with rec, exp_val do
  begin
    if exp_ref = nil then
    case val_frm of
      vfrm_str: if str <> nil then begin  DISPOSE( str ); str := nil  end;       { String }
      vfrm_ast: if aas <> nil then
                begin                  { Array of strings }
                  for ii := 1 to aas^.val_all do  DISPOSE( aas^.val_stb[ii] );
                  DISPOSE( aas );
                  aas := nil;
                end;
      vfrm_ain: if aai <> nil then begin  DISPOSE( aai ); aai := nil  end;       { Array of integers }
      vfrm_afl: if aaf <> nil then
                begin                  { Array of floats }
                  DISPOSE( aaf ); aaf := nil;
                  if asg <> nil then begin  DISPOSE( asg ); asg := nil  end
                end;
    otherwise
    end;
    val_cte :=     false;
    val_frm := vfrm_null
  end
end EXPRV_REMOVE;



[global]
procedure POP_EXPRESSION( var rec: exp_rec );
{ Routine to pop an expression in the stack and put it in the record exp_res }
const
  mdnam = 'PEXP';

begin
  if exp_stkp > 0 then
  begin { *** Get the expression result *** }
    EXPRV_REMOVE( rec );                        { Free any old allocation in exp_res before to use it }
    rec  := exp_stk[exp_stkp];
{   exp_stk[exp_stkp].exp_val.val_frm := vfrm_null; }
    exp_stkp := exp_stkp - 1
  end
  else
  begin
    SRC_ERROR( mdnam, 7, e_severe );
    rec.exp_val.val_cte :=     false;
    rec.exp_val.val_frm := vfrm_null
  end;
end POP_EXPRESSION;



[global]
procedure PUSH_EXPRESSION( var exp: exp_rec );
const
  mdnam = 'PUEX';

begin
  if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )
                        else SRC_ERROR( mdnam, 6, e_severe );
  exp_stk[exp_stkp] := exp;
  exp := exp_null
end PUSH_EXPRESSION;



procedure EXP_PUT_REFER( ip: ide_ptr );
{ Push the expression reference of identifier ip^ in the stack }
const
  mdnam = 'PURF';


  procedure EXP_PUT_VALUE( var val: val_rec; ip: ide_ptr );
  const
    mdnam = 'PUTV';

  begin
    with ip^, val, exp_stk[exp_stkp] do
    begin
      exp_ref :=      ip;
      exp_typ := ide_typ;
      exp_flg := ide_flg;
      exp_nsq :=       0;
      exp_shf :=       0;
      exp_esz :=       1;
      if exp_typ <> nil then
        with exp_typ^ do
          if typ_frm = tfrm_array then exp_esz := typ_stp*typ_siz;
      exp_val.val_cte :=   false;
      exp_val.val_frm := val_frm;
      case val_frm of
        vfrm_str:  exp_val.str := str;
        vfrm_int:  exp_val.int := int;
        vfrm_flt:  begin
                     exp_val.flt := flt;
                     if objf_sigma in exp_flg then exp_val.sig := sig
                                              else exp_val.sig := 0.0;
                     if objf_lsqob in exp_flg then
                     begin
                       exp_nsq := idev_sequnb;
                       if exp_nva then OUT_PCD_VREF( exp_stk[exp_stkp] )
                     end
                   end;
        vfrm_ast:  begin
                     if aas = nil then SRC_ERROR( mdnam, 801, e_severe );
                     exp_val.aas := aas
                   end;
        vfrm_ain:  begin
                     if aai = nil then SRC_ERROR( mdnam, 802, e_severe );
                     exp_val.aai := aai
                   end;
        vfrm_afl:  begin
                     if aaf = nil then SRC_ERROR( mdnam, 803, e_severe );
                     exp_val.aaf := aaf;
                     if objf_sigma in exp_flg then exp_val.asg := asg
                                              else exp_val.asg := nil;
                     if [objf_lsqob,objf_lsqex]*exp_flg <> [] then exp_nsq := idev_sequnb;
                   end;
        vfrm_itm:  begin { Item reference: Directly output by ITEM_SET_FIELD or used by EXP_FIELD for field reference }
                     exp_val.itm := itm;
                     exp_flg := exp_flg + [objf_lsqit];
                     if itm <> nil then exp_nsq := itm^.itm_sequ        { To refer a field of an existing item }
                     else
                     if (objf_lsqob in exp_flg) and
                        (idev_sequnb > 0) then exp_nsq := - idev_sequnb { To refer a field of an externaly defined item (nsq < 0) }
                     else
                     begin
                       SRC_ERROR_S( mdnam, 277, e_error, ide_name^ );
                       exp_val.val_frm := vfrm_int; exp_val.int := 0
                     end
                   end;
        vfrm_null: begin exp_val.val_frm := vfrm_int; exp_val.int := 0  end
      otherwise
      end
    end
  end EXP_PUT_VALUE;


begin { EXP_PUT_REFER }
  if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )
                        else SRC_ERROR( mdnam, 6, e_severe );
  exp_stk[exp_stkp] := exp_null;

  if ip <> nil then
  with ip^ do
  begin
    case ide_class of
      cla_itmfld: EXP_PUT_VALUE( disp_tab[curr_idisp].disp_own^.idev_val.itm^.itm_tab[idee_sequnb], ip );
      cla_field:  EXP_PUT_VALUE( disp_tab[curr_idisp].disp_own^.idev_val, ip ); { /// temporary - not managed /// }
      cla_varbl:  EXP_PUT_VALUE( idev_val, ip );
    otherwise
    end
  end
end EXP_PUT_REFER;



[global]
procedure EXP_STK_COPY( lvl: integer := 0 );
{ To put a copy of formal reference in the stack }
const
  mdnam = 'STKC';

begin
  if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )
                        else SRC_ERROR( mdnam, 6, e_severe );
  exp_stk[exp_stkp] := exp_stk[stkp_base - lvl]
end EXP_STK_COPY;



[global]
procedure EXP_GET_COPY( var rec: exp_rec; lvl: integer := 0 );
begin
  rec := exp_stk[stkp_base - lvl]
end EXP_GET_COPY;



procedure EXP_PUT_FORMAL( ip: ide_ptr );
const
  mdnam = 'PUTC';

begin
  EXP_STK_COPY( ip^.idef_efn );
  exp_stk[exp_stkp].exp_ref := ip
end  EXP_PUT_FORMAL;



procedure EXP_PUTVALUE(       typ:     typ_ptr;
                               iv:     integer;
                               rv, sg: mxd_flt;
                               st:     str_ptr );
{ Push a value in the stack }
const
  mdnam = 'EXPP';

begin
  if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )
                        else SRC_ERROR( mdnam, 6, e_severe );
  with sy_sym, exp_stk[exp_stkp], exp_val do
  begin
    exp_ref   := nil;
    exp_typ   := typ;
    exp_nsq   :=   0;
    exp_esz   :=   1;
    exp_shf   :=   0;
    val_frm   := GET_VAL_FORMS( typ );
    exp_flg   :=  [];
    val_cte := false;
    case val_frm of
      vfrm_str: begin
                  if st <> nil then
                    if st^.length > 0 then
                    begin  NEW( str, st^.length ); str^ := st^  end
                    else str := nil
                  else str := nil;
                  exp_typ := str_typ
                end;
      vfrm_int: begin  int := iv; exp_typ := int_typ  end;
      vfrm_flt: begin  flt := rv; sig := sg; exp_typ := flt_typ  end;
    otherwise
    end;
    if debug_exp then WRITELN( lst_current^.lst_file, ' Deb PUSH ', exp_stk[exp_stkp] )
  end
end EXP_PUTVALUE;



[global]
procedure EXP_PUTSTR( in_var st: string );
{ Push a string value in the stack }
begin
  EXP_PUTVALUE( str_typ, 0, 0.0, 0.0, st"address )
end EXP_PUTSTR;



[global]
procedure EXP_PUTINT( iv: integer );
{ Push an integer value in the stack }
begin
  EXP_PUTVALUE( int_typ, iv, 0.0, 0.0, nil )
end EXP_PUTINT;



[global]
procedure EXP_PUTFLT( rv, sg: mxd_flt := 0.0 );
{ Push a float value (with sigma) in the stack }
begin
  EXP_PUTVALUE( flt_typ, 0, rv, sg, nil )
end EXP_PUTFLT;




procedure STACK_REMOVE( np: integer );
{ Remove np element from the stack (and free temporary location) }
begin
  while np > 0 do
  begin
    EXPRV_REMOVE( exp_stk[exp_stkp] );
    exp_stkp := exp_stkp - 1;
    np := np - 1
  end
end STACK_REMOVE;



function  COMP_TYPE_STK( np: integer; fty: typ_ptr; brf, bdf: boolean := false ): boolean;
{ Compare object type: result True when the object are compatibles }
type
  ftst = (bad, ver, good);

var
  bok:         boolean;
  ety, cty:    typ_ptr;

  typ_ctb: [static] array[tfrm_str..tfrm_itmrf,tfrm_str..tfrm_wild] of ftst := [
    {   str,    int,    flt,  array, record, itemrf, itemty, number, warray,   wild  (<- formal type) }
    [  good,    bad,    bad,    bad,    bad,    bad,    bad,    bad,    bad,   good ], {    str as effective type }
    [   bad,   good,    bad,    bad,    bad,    bad,    bad,   good,    bad,   good ], {    int }
    [   bad,    bad,   good,    bad,    bad,    bad,    bad,   good,    bad,   good ], {    flt }
    [   bad,    bad,    bad,    ver,    bad,    bad,    bad,    bad,   good,   good ], {  array }
    [   bad,    bad,    bad,    bad,    ver,    bad,    bad,    bad,   good,   good ], { record }
    [   bad,    bad,    bad,    bad,    bad,    ver,    bad,    bad,    bad,   good ]  { itemrf }
  ];


begin { COMP_TYPE_STK }
  if fty <> nil then
  begin
    ety := exp_stk[exp_stkp - np].exp_typ;
    if ety <> nil then
    begin
      cty :=     ety;                   { Loop to find when the formal type is a parent of the effective one }
      while (cty <> fty) and (cty <> nil) do cty := cty^.typ_par;
      if not brf then
        { If cty = nil then the formal type does not match with the effective type (or a parent of) }
        if cty = nil then   { Conversion(s) are not possible for formal by reference }
          case typ_ctb[ety^.typ_frm, fty^.typ_frm] of
            bad: bok := false;
           good: bok :=  true;
          otherwise
            case fty^.typ_frm of
              tfrm_array:
                with fty^ do
                if (objf_wild in typ_flg) and (ety^.typ_ael = typ_ael) then
                  if typ_min = maxint then bok := true
                                      else bok := (ety^.typ_min = typ_min)
                else bok := false;
            otherwise
              bok := false
            end
          end
        else bok := true
      else bok := (cty = fty)
    end
    else bok := bdf                     { OK when the parameter is optional }
  end
  else  bok := true;                    { OK when the type of formal is the effective one or a parent }
  COMP_TYPE_STK := bok
end COMP_TYPE_STK;



function  GENERIC_SEARCH( ent: ent_ptr; npa: integer ): ent_ptr;
{ Search a generic definition that match with the effective argument list }
const
  mdnam = 'GENS';

var
  fnd:         boolean;
  idf:         ide_ptr;
  nef:         integer;

begin
(*
WRITELN( ' Generic Search !!!' );
*)
  fnd := false;
  if ent <> nil then
  repeat
    with ent^ do
    begin
      case ent_knd of
        entk_stm: { Intrinsec statement }
          if npa <= 2 then
(*
begin
if npa = 1 then
WRITELN( ' Search stm ', ent_stm, ' for ( "', ent_pt1^.typ_ide^.ide_name^, '" )' );
if npa = 2 then
WRITELN( ' Search stm ', ent_stm, ' for ', ent_stm, ' ( "', ent_pt1^.typ_ide^.ide_name^, '", "', ent_pt2^.typ_ide^.ide_name^, '" )' );
*)
          case npa of
            0: fnd := (ent_pt1 = nil) and (ent_pt2 = nil);
            1: fnd := COMP_TYPE_STK( 0, ent_pt1 ) and (ent_pt2 = nil);
            2: fnd := COMP_TYPE_STK( 1, ent_pt1 ) and
                      COMP_TYPE_STK( 0, ent_pt2 );
          end;
(*
;WRITELN( ' ==> ', fnd )
end;
*)

        entk_fnc: { User defined function }
          begin
(*
WRITE( ' MFNC with ', ent_npa:0, ' arguments : (' );
idf := ent_frl;
if idf <> nil then
begin
  for ii := 1 to ent_npa do
  with idf^ do begin
    if idf <> ent_frl then WRITE( ',' );
    WRITE( ' ', ide_typ^.typ_ide^.ide_name );
    idf := ide_lnk
  end;
  WRITE( ' )' );
  if ent_typ <> nil then WRITE( ': ', ent_typ^.typ_ide^.ide_name^, ' for op = ', ent_ope );
end;
WRITELN;
*)
            if npa = ent_npa then
            begin
              idf := ent_frl;
              nef := npa - 1;
              fnd := true;
              while fnd and (idf <> nil) and (nef >= 0) do
              with idf^ do
              begin
                fnd := COMP_TYPE_STK( nef, ide_typ, idef_ref, idef_def );
                nef := nef - 1;
                idf := ide_lnk
              end
            end
            else fnd := false;
(*
;WRITELN( ' ==> ', fnd, ', eff_npa = ', npa:0, ', formal_npa = ', ent_npa:0 );
*)
          end;

        entk_std: fnd := true { Builtin function (not a generic ///) } ;

      end;
      if not fnd then ent := ent_prv
    end
  until fnd or (ent = nil);
  GENERIC_SEARCH := ent
end GENERIC_SEARCH;



function  STRING_TO_NUMBER( var st: str_ptr; bfree: boolean ): mxd_flt;
{ Convert string in number }
label
  LECT_ERR;

var
  re: mxd_flt;

  function RD_ERR_TRAP( ierr: cc__int ): cc__int;
  begin
    if ierr = 51 then
                 begin
                    re := 0.0;
                    goto LECT_ERR
                 end
                 else RD_ERR_TRAP := 0 { 0 to continue the handler scan, -1 => standard RTL error message and stop }
  end RD_ERR_TRAP;

begin
  ESTABLISH( RD_ERR_TRAP );
  READV( st^, re );
LECT_ERR:
  REVERT;
  if bfree then
  begin  DISPOSE( st ); st := nil  end;
  STRING_TO_NUMBER := re
end STRING_TO_NUMBER;



function NUMBER_TO_STRING( rv: mxd_flt; fl, dc: integer := 0 ): str_ptr;
{ Convert number in string }
var
  st: string( 32 );
  sv: str_ptr;

begin
  WRITEV( st, rv:fl:dc );
  if st.length > 0 then
  begin
    NEW( sv, st.length );
    sv^ := st
  end else sv := nil;
  NUMBER_TO_STRING := sv
end NUMBER_TO_STRING;



procedure STRING_CONCATE( var st1, st2: str_ptr; bf1, bf2: boolean );
{ Concate two strings }
var
  str: string;

begin
  if (st1 <> nil) and (st2 <> nil) then
  begin
    str := st1^||st2^;
    if bf1 then DISPOSE( st1 );
    if bf2 then begin  DISPOSE( st2 ); st2 := nil  end;
    NEW( st1, str.length ); st1^ := str
  end
  else
    if st1 = nil then
      if bf2 then
      begin  st1 := st2; st2 := nil  end
      else
      begin  NEW( st1, st2^.length ); st1^ := st2^  end
end STRING_CONCATE;



function  STRING_COMPARE( var st1, st2: str_ptr; bf1, bf2: boolean ): integer;
{ Compare two strings }
var
  re: integer;

begin
  if (st1 <> nil) and (st2 <> nil) then
  begin
    re := STR_MATCH( st1^, st2^ );
    if bf1 then DISPOSE( st1 ); st1 := nil;
    if bf2 then DISPOSE( st2 ); st2 := nil
  end
  else
    if (st1 = nil) and (st2 = nil) then re := 0
    else
      if st1 = nil then
      begin
        if st2^.length = 0 then re := 0
                           else re := -1;
        if bf2 then DISPOSE( st2 ); st2 := nil
      end
      else
      begin
        if st1^.length = 0 then re := 0
                           else re := 1;
        if bf1 then DISPOSE( st1 ); st1 := nil
      end;
  STRING_COMPARE := re
end STRING_COMPARE;



function  ARGUMENTS_SETTING( npa: integer; arg: ide_ptr := nil ): obj_flagsty;
{ Get the value of all arguments to call a user macro function }
var
  nvl, idx:    integer;
  bref:        boolean;
  vl:          mxd_flt;
  flg:     obj_flagsty;

begin
  flg := [];
  nvl := exp_stkp - npa + 1;
  while nvl <= exp_stkp do
  with exp_stk[nvl], exp_val do
  begin
(*
WRITELN( ' arg lvl ', nvl:0, ' : ', exp_stk[nvl] );
*)
    flg := flg + exp_flg*[objf_lsqob,objf_lsqex];
    idx := exp_shf + 1;
    if arg <> nil then begin  bref := arg^.idef_ref; arg := arg^.ide_lnk  end
                  else bref := false;

    if not bref then
      case val_frm of
        vfrm_est:
          begin
            if aas <> nil then str := aas^.val_stb[idx]
                          else str := nil;
            val_frm := vfrm_str
          end;

        vfrm_ein:
          begin
            if aai <> nil then int := aai^.val_itb[idx]
                          else int :=   0;
            val_frm := vfrm_int
          end;

        vfrm_efl:
          begin
            if aaf <> nil then
            begin
              vl := aaf^.val_ftb[idx];  { Pass by vl local variable because the assign to flt can be change the asg pointer (equivalence }
              if asg <> nil then sig := asg^.val_ftb[idx]
                            else sig := 0.0;
              flt := vl
            end
            else
            begin  flt := 0.0; sig := 0.0  end;
            val_frm := vfrm_flt
          end;

      otherwise
      end;
    nvl := nvl + 1
  end;
  ARGUMENTS_SETTING := flg
end ARGUMENTS_SETTING;



[global]
procedure NUMERR_MANAGER( ierr: integer; ent: ent_ptr );
const
  mdnam = 'NERR';

var
  stm: [static] string( 14 );

begin
  with ent^, exp_stk[exp_stkp], exp_val do
  begin
    if not numerr_nstp then
    begin
      WRITEV( stm, ent_stm );
      SRC_ERROR_S( mdnam, 48, e_error, stm )
    end
    else numerr_cnt := numerr_cnt + 1;

    val_frm := GET_VAL_FORMS( ent_typ );
    case val_frm of
      vfrm_int: int :=   1;
      vfrm_flt: flt := 1.0;
      vfrm_str: str := nil;
    otherwise
      val_frm := vfrm_null
    end
  end
end NUMERR_MANAGER;



procedure EXE_VAL_UNA( ent: ent_ptr; bprv: boolean := false  );
const
  mdnam = 'EUNA';

var
  flg:     obj_flagsty;
  err_cod:     integer;

label
  ET_ERR;


  function ERR_HANDLER( ierr: cc__int ): cc__int;
  begin
    if (ierr >= 20) and (ierr <= 29) then begin  err_cod := ierr; goto ET_ERR  end
                                     else ERR_HANDLER := 0
  end ERR_HANDLER;


begin
  flg := ARGUMENTS_SETTING( 1 );
  ESTABLISH( ERR_HANDLER );
  with ent^, exp_stk[exp_stkp], exp_val do
  begin
    if ent_cv1 <> nil then EXE_VAL_UNA( ent_cv1 );
    if objf_lsqex in exp_flg then
      { The statement cannot be execute here => output Pcode }
    begin
      if bprv then WRITELN( pcd, ' ', ORD( nd_permut ):4 );
      OUT_STM_CODE( ent_stm );
      if bprv then WRITELN( pcd, ' ', ORD( nd_permut ):4 )
    end
    else
    begin
(*
WRITE( ' Una Op ', ent_stm, ' ( ', exp_stk[exp_stkp], ' )' );
*)
      { Execute the unary operator }
      case ent_stm of
        { For conversion }
        stm_csi: begin  int := ROUND( STRING_TO_NUMBER( str, exp_ref = nil ) )  end;
        stm_csf: begin  flt := ROUND( STRING_TO_NUMBER( str, exp_ref = nil ) ); sig := 0.0  end;
        stm_cis: str := NUMBER_TO_STRING( MXD_FLT( int ) );
        stm_cif: flt := int;
        stm_cfs: str := NUMBER_TO_STRING( flt );
        stm_cfi: int := TRUNC( flt );
        stm_rnd: int := ROUND( flt );

        stm_not: if int <> 0 then int := 0
                             else int := 1;
        stm_neg: int := - int;
        stm_fng: flt := - flt;

        stm_iabs:   int :=  ABS( int );
        stm_fabs:   flt :=  ABS( flt );
        stm_sqrt:   flt := SQRT( flt );

        stm_sinr:   flt :=  SIN( flt );
        stm_cosr:   flt :=  COS( flt );
        stm_tanr:   flt :=  TAN( flt );

        stm_asinr:  flt :=  ARCSIN( flt );
        stm_acosr:  flt :=  ARCCOS( flt );
        stm_atanr:  flt :=  ARCTAN( flt );

        stm_sind:   flt :=  SIN( in_rd*flt );
        stm_cosd:   flt :=  COS( in_rd*flt );
        stm_tand:   flt :=  TAN( in_rd*flt );

        stm_asind:  flt :=  ARCSIN( flt )/in_rd;
        stm_acosd:  flt :=  ARCCOS( flt )/in_rd;
        stm_atand:  flt :=  ARCTAN( flt )/in_rd;

        stm_exp:    flt :=  EXP( flt );
        stm_ln:     flt :=  LN( flt );
        stm_tanh:   flt :=  TANH( flt );

      otherwise
      end
    end;

    { Force the resulting type }
    exp_flg := exp_flg + flg;
    exp_typ := ent_typ;
    val_frm := GET_VAL_FORMS( ent_typ )
(*
;WRITELN( ' -> ', exp_stk[exp_stkp] );
*)
  end;
  goto ET_END;

ET_ERR:
   NUMERR_MANAGER( err_cod, ent );

ET_END:
  REVERT
end EXE_VAL_UNA;



procedure EXE_VAL_BIN( ent: ent_ptr  );
const
  mdnam = 'EBIN';

var
  r:           mxd_flt;
  flg:     obj_flagsty;
  bpr:         boolean;
  err_cod:     integer;

label
  ET_ERR;

  function ERR_HANDLER( ierr: cc__int ): cc__int;
  begin
    if (ierr >= 20) and (ierr <= 29) then begin  err_cod := ierr; goto ET_ERR  end
                                     else ERR_HANDLER := 0
  end ERR_HANDLER;


begin { EXE_VAL_BIN }
  flg := ARGUMENTS_SETTING( 2 );
  ESTABLISH( ERR_HANDLER );
  with ent^ do
  begin
    if ent_cv2 <> nil then EXE_VAL_UNA( ent_cv2 );
    POP_EXPRESSION( exp_res );
    if ent_cv1 <> nil then EXE_VAL_UNA( ent_cv1, true );
    with exp_stk[exp_stkp], exp_val do
    begin
      if (objf_lsqex in exp_res.exp_flg) or (objf_lsqex in exp_flg) then
      begin
        { When the top of stack is output but not previous one => output the first parm as 2th and permut }
        if not (objf_lsqex in exp_flg) then OUT_PCD_VREF( exp_stk[exp_stkp], objf_lsqex in exp_res.exp_flg );
        { When the top of stack was not output, this will be done now }
        if not (objf_lsqex in exp_res.exp_flg) then OUT_PCD_VREF( exp_res );
        { Output the operator }
        OUT_STM_CODE( ent_stm )
      end
      else
      begin
(*
WRITE( ' Bin Op ', ent_stm, ' ( ', exp_stk[exp_stkp], ', ', exp_res, ' )' );
*)
       case ent_stm of
          stm_iip: int := int**exp_res.exp_val.int;
          stm_fip: flt := flt**exp_res.exp_val.int;
          stm_ffp: flt := flt**exp_res.exp_val.flt;
          stm_iml: int := int*exp_res.exp_val.int;
          stm_fml: flt := flt*exp_res.exp_val.flt;
          stm_idv: int := int div exp_res.exp_val.int;
          stm_mod: int := int mod exp_res.exp_val.int;
          stm_rem: int := int rem exp_res.exp_val.int;
          stm_fdv: flt := flt/exp_res.exp_val.flt;
          stm_iad: int := int+exp_res.exp_val.int;
          stm_fad: flt := flt+exp_res.exp_val.flt;
          stm_isb: int := int-exp_res.exp_val.int;
          stm_fsb: flt := flt-exp_res.exp_val.flt;
          stm_ssc: STRING_CONCATE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil );
          stm_seq: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil )  = 0 then int := 1 else int := 0;
          stm_sne: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil ) <> 0 then int := 1 else int := 0;
          stm_slt: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil )  < 0 then int := 1 else int := 0;
          stm_sle: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil ) <= 0 then int := 1 else int := 0;
          stm_sge: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil ) >= 0 then int := 1 else int := 0;
          stm_sgt: if STRING_COMPARE( str, exp_res.exp_val.str, exp_ref = nil, exp_res.exp_ref = nil )  > 0 then int := 1 else int := 0;
          stm_ieq: if int  = exp_res.exp_val.int then int := 1 else int := 0;
          stm_ine: if int <> exp_res.exp_val.int then int := 1 else int := 0;
          stm_ilt: if int  < exp_res.exp_val.int then int := 1 else int := 0;
          stm_ile: if int <= exp_res.exp_val.int then int := 1 else int := 0;
          stm_ige: if int >= exp_res.exp_val.int then int := 1 else int := 0;
          stm_igt: if int  > exp_res.exp_val.int then int := 1 else int := 0;
          stm_feq: if flt  = exp_res.exp_val.flt then int := 1 else int := 0;
          stm_fne: if flt <> exp_res.exp_val.flt then int := 1 else int := 0;
          stm_flt: if flt  < exp_res.exp_val.flt then int := 1 else int := 0;
          stm_fle: if flt <= exp_res.exp_val.flt then int := 1 else int := 0;
          stm_fge: if flt >= exp_res.exp_val.flt then int := 1 else int := 0;
          stm_fgt: if flt  > exp_res.exp_val.flt then int := 1 else int := 0;
          stm_and: if (int <> 0) and (exp_res.exp_val.int <> 0) then int := 1 else int := 0;
          stm_xor: if (int <> 0) xor (exp_res.exp_val.int <> 0) then int := 1 else int := 0;
          stm_or:  if (int <> 0) or  (exp_res.exp_val.int <> 0) then int := 1 else int := 0;

          stm_phaser:   flt := ARCTAN( flt, exp_res.exp_val.flt );
          stm_phased:   flt := ARCTAN( flt, exp_res.exp_val.flt )/in_rd;
          stm_bessj:    flt := MATH_BESSEL_J( int, exp_res.exp_val.flt );
          stm_bessjh:   flt := MATH_BESSEL_JH( flt, exp_res.exp_val.flt );

          stm_interpol: begin
                          flt := MATH_INTERPOL( aaf^, exp_res.exp_val.flt );
                          if math_err > 0 then
                            if math_err = 1 then SRC_ERROR( 'INPL', 501, e_warning )
                                            else SRC_ERROR( 'INPL', 502, e_error )
                         end;
          stm_integr: ;

        otherwise
        end
      end;
      { Force the resulting type }
      exp_flg := exp_flg + flg;
      exp_typ := ent_typ;
      exp_esz := 1;
      val_frm := GET_VAL_FORMS( ent_typ )
    end
(*
;WRITELN( ' -> ', exp_stk[exp_stkp] );
*)
  end;
  goto ET_END;

ET_ERR:
   NUMERR_MANAGER( err_cod, ent );

ET_END:
  REVERT
end EXE_VAL_BIN;



procedure SET_TARGET_VALUE( var trg: exp_rec; bfrm: boolean );
{ Deposite the current stack expression in the specified target variable.
}
const
  mdnam = 'STRG';

var
  st:   string;
  cfm: boolean;
  ind: integer;

begin
  with sy_sym, trg, exp_val do
  begin
    ind := exp_shf + 1;
    case val_frm of
      vfrm_str:
        begin
          EXTRACT_STR( exp_res, st );
          if str <> nil then DISPOSE( str );
          if st.length > 0 then begin  NEW( str, st.length ); str^ := st  end
                           else str := nil;
          if not bfrm then exp_ref^.idev_val.str := str
        end;
      vfrm_int:
        begin
          int := EXTRACT_INT( exp_res, int );
          if not bfrm then exp_ref^.idev_val.int := int
        end;
      vfrm_flt:
        begin
          flt := EXTRACT_FLT( exp_res, flt );
          if objf_sigma in exp_flg then
            if sy = colon then begin  INSYMBOL; sig := GET_FLTEXPR( 0.0 )  end
                          else sig := 0.0
          else sig := 0.0;
          if not bfrm then
          begin
            exp_ref^.idev_val.flt := flt;
            exp_ref^.idev_val.sig := sig
          end
        end;
      vfrm_est:
        if aas <> nil then
          with aas^ do
          begin
            EXTRACT_STR( exp_res, st );
            if val_stb[ind] <> nil then DISPOSE( val_stb[ind] );
            if st.length > 0 then  begin NEW( val_stb[ind], st.length ); val_stb[ind]^ := st  end
                             else val_stb[ind] := nil
          end;
      vfrm_ein:
        if aai <> nil then aai^.val_itb[ind] := EXTRACT_INT( exp_res, 0 );
      vfrm_efl:
        begin
          if aaf <> nil then aaf^.val_ftb[ind] := EXTRACT_FLT( exp_res, 0.0 );
            if asg <> nil then
              if (objf_sigma in exp_flg) and (asg <> nil) then
                if sy = colon then begin  INSYMBOL; asg^.val_ftb[ind] := GET_FLTEXPR( 0.0 )  end
                              else asg^.val_ftb[ind] := 0.0
              else asg^.val_ftb[ind] := 0.0
        end;
      vfrm_ast:
        case exp_res.exp_val.val_frm of
          vfrm_str: ARRSCA_SS_ASSIGN( exp_res, trg );
          vfrm_ast: ARRAY_SS_ASSIGN( exp_res, trg );
        otherwise
          SRC_ERROR( mdnam, 118, e_severe )
        end;
      vfrm_ain:
        case exp_res.exp_val.val_frm of
          vfrm_int: ARRSCA_II_ASSIGN( exp_res.exp_val.int, trg );
          vfrm_flt: ARRSCA_II_ASSIGN( ROUND( exp_res.exp_val.flt ), trg );
          vfrm_ain: ARRAY_II_ASSIGN( exp_res, trg );
          vfrm_afl: ARRAY_FI_ASSIGN( exp_res, trg );
        otherwise
          SRC_ERROR( mdnam, 116, e_severe )
        end;
      vfrm_afl:
        case exp_res.exp_val.val_frm of
          vfrm_int: ARRSCA_FF_ASSIGN( mxd_flt( exp_res.exp_val.int ), 0.0, trg );
          vfrm_flt: ARRSCA_FF_ASSIGN( exp_res.exp_val.flt, 0.0, trg );
          vfrm_ain: ARRAY_IF_ASSIGN( exp_res, trg );
          vfrm_afl: ARRAY_FF_ASSIGN( exp_res, trg );
        otherwise
          SRC_ERROR( mdnam, 117, e_severe )
        end;

    otherwise
      SRC_ERROR_S( mdnam, 105, e_severe, sy_ident )
    end
  end
end SET_TARGET_VALUE;



[global]
procedure ASSIGNEMENT( trg: ide_ptr );
{ Perform an assignement, <trg> is the target identifier.
}
const
  mdnam = 'ASSI';

var
  st:       str_string;
  rec:         exp_rec;

begin
  with sy_sym do
  begin
    rec.exp_val.val_frm := vfrm_null;           { Init the temporary (for recursivity) expression record }
    GET_EXP_REFER( rec, trg );                  { Put the target reference in the <rec> expression }
(*
WRITELN( ' Ass Target : ', rec, ' with esz = ', rec.exp_esz:0 );
*)
    with rec, exp_val do
    if exp_ref <> nil then
    begin { * When a variable reference was specified * }
      if sy = becomes then INSYMBOL
                      else SRC_ERROR( mdnam, 32, e_error );
      if (exp_ref <> nil) and (val_frm <> vfrm_null) then
        if objf_ronly in exp_flg then
          SRC_ERROR_S( mdnam, 131, e_error, exp_ref^.ide_name^ )
        else
        begin
          GET_EXPRESSION( exp_res );            { Get the source expression }

(*
WRITELN( ' Ass Source : ', exp_res, ' with esz = ', exp_res.exp_esz:0 );
*)
          if (objf_lsqob in exp_res.exp_flg) and                        { When we have a LSQ expression source }
             (objf_retva in rec.exp_flg) then
          begin
            if ret_seq_incr > 1 then
(*
begin
WRITELN( ' EXPR ASS source : rt_cnt = ', ret_seq_count:0, ', # ', exp_res.exp_nsq:0,
         ',  exp_res : ', exp_res, ' sz:', exp_res.exp_esz:0, ',', exp_res.exp_shf:0 );
WRITELN( ' EXPR ASS target : # ', exp_nsq:0, ', : ', rec, ', sz:', exp_esz:0, ',', exp_shf:0 );
*)

              if (objf_retva in exp_res.exp_flg) and
                 (exp_res.exp_esz > 1) then
                ret_seq_count := exp_res.exp_nsq                        { Transmit the result sequence number to the return value }
              else
                OUT_RETPAR_DEF( rec )                                   { The target is a return value : We create a new LSQ_PARM }
(*
end
*)
          end
          else
          if (objf_retva in exp_ref^.ide_flg) and (val_frm <= vfrm_flt) then
(*
begin
WRITELN( ' Ass Retva = ', objf_retva in exp_flg, ', Esz = ', exp_esz:0, ' on base ', stkp_base:0 );
*)
            SET_TARGET_VALUE( exp_stk[stkp_base], true )

(*
;WRITELN( ' Ass Value : ', exp_stk[stkp_base], '   ASSIGNED.' )
end
*)
          else
          begin { For the interpretor mode, the target is a true variable }
            SET_TARGET_VALUE( rec, false );
            if objf_spass in exp_ref^.ide_flg then ASSIGN_SPECIFIC( rec ) { Execute specific action when required }
          end
        end;
      EXPRV_REMOVE( rec )
    end else SKIP_SYMBOL( semicolon )
  end
end ASSIGNEMENT;



procedure GEN_GENERIC_CALL( ent: ent_ptr; npa: integer; bfnc: boolean );
const
  mdnam = 'CAGE';

var
  fp:                          ide_ptr;
  sv_rsq, sv_inc, sv_stk, sz:  integer;
  pr:                          idm_rec;
  c1, c2:                         char;
  flg:                     obj_flagsty;

begin
  with ent^, pr do
  begin
(*
WRITELN( ' Generic Call with ', npa:0, ' args at stk = ', exp_stkp:0, ' :' );
*)
    flg := ARGUMENTS_SETTING( npa, ent_frl );
(*
WRITELN( ' Arg set OK with : bfnc = ', bfnc, ' typ def = ', ent_typ <> nil );
*)

    sv_rsq  :=   ret_seq_count;                 { Save the current top of LSQ return sequence number }
    sv_inc  :=    ret_seq_incr;                 { Save the current sequence number increment }
    ret_seq_incr        :=   0;                 { Set as no return or scalar value }
    ret_seq_count       :=   0;                 { To force return parameter sequence number setting }
    if ent_typ <> nil then
    begin
      if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )         { The function return a result but it can be not used }
                            else SRC_ERROR( mdnam, 6, e_severe );

      with exp_stk[exp_stkp], ent_typ^ do       { Fill the return value expression record }
      begin
        exp_ref := ret_ide;                     { Set the value reference and type link }
        exp_typ := ent_typ;
        exp_nsq :=       0;
        exp_shf :=       0;
        if typ_frm = tfrm_array then exp_esz := typ_stp*typ_siz
                                else exp_esz := 1;
        ret_seq_incr    :=   exp_esz;
        exp_flg :=      [objf_retva];
        exp_val.val_cte := false;
        exp_val.val_frm := vfrm_null;
        VAL_ALLOCATE( exp_val, ent_typ )        { Allocate the space for the return value }
(*
; WRITELN( ' Return value size = ', exp_esz:0, ' on base ', exp_stkp:0 );
;WRITELN( ' Mfunction Return expr : ', exp_stk[exp_stkp], ' with esz = ', exp_stk[exp_stkp].exp_esz:0 )
*)
      end
    end;
    sv_stk := stkp_base; stkp_base := exp_stkp; { Save the current stack base and install the new one }

    { Create the formal display level }
    DISPLAY_NEW;
    with disp_tab[curr_disp] do
    begin  disp_idt := ent_frl; disp_lid := ent_frl  end;

    DISPLAY_NEW;                                { Create the function body display }
    SAVE_SYM_CNTX( true );
    idm_name    :=        nil;
    idm_parl    :=        nil;
    idm_nxt     :=        nil;
    idm_prv     :=        nil;
    idm_kind    :=   idm_list;
    idm_run     :=       true;
    idm_tab     :=    ent_cod;
    idm_cntx    := idm_actstk;
    idm_actstk  := pr"address;
    idm_nch     :=          1;          { Exec from the begining }
    sy_sym.sy   :=    nothing;          { To force to ignore the present repeat }
    c1 := sy_ch; c2 := sy_cmin; sy_ch := ' ';
(*
WRITE( ' -- Call mfunction "' );
if ent_ope <> no_op then WRITE( ent_str^ )
                    else WRITE( ent_ide^.ide_name^ );
WRITELN( '" with r_s_incr = ', ret_seq_incr:0, ', call stkp = ', exp_stkp:0 );
*)
(*
WRITELN( ' Execute code : ' );
WRITELN( ' ', idm_tab^.idm_ctb:idm_tab^.idm_use );
*)
    STATELIST( endsy );
(*
WRITELN( ' Function Result 000 is : ', exp_stk[exp_stkp] );
*)
    idm_actstk := idm_cntx;
    RESTORE_SYM_CNTX;

    DISPLAY_FREE;                               { Suppress the display level of the code }
    curr_disp := curr_disp - 1;                 { Take off the formal display level }

    exp_stkp := stkp_base;                      { Force the stack to be at original level }
(*
WRITELN( ' Function Result is : ', exp_stk[exp_stkp] );
*)
    if ent_typ <> nil then exp_stkp := exp_stkp - 1;    { Save the function result }
    if npa > 0 then STACK_REMOVE( npa );                { Remove the effective arguments }

    if ent_typ <> nil then
    begin
      exp_stkp := exp_stkp + 1;                 { Get the room for the function result }
      exp_stk[exp_stkp] := exp_stk[stkp_base];  { Put the function result in the top of stack }
      with exp_stk[exp_stkp] do
      begin
        if ret_seq_count > 0 then
        begin
          exp_nsq := ret_seq_count;             { Save the current return sequence number in the result value record }
          exp_flg := exp_flg + [objf_lsqob]     { When a sequence number is set, then set the LSQ expression flag }
        end;
        exp_flg := exp_flg + flg;               { Set the LSQ result flags from the arguments flags }
        exp_ref := nil                          { The result is a temporary location }
      end
    end;
    ret_seq_incr        :=      sv_inc;         { Restore the initial return sequence increment }
    ret_seq_count       :=      sv_rsq;         { Restore the initial return sequence number }
    stkp_base           :=      sv_stk          { Restore the previous stack base }
(*
;WRITELN( ' MFUNCTION RETURN exp_stk[', exp_stkp:0, '].exp_nsq = ', exp_stk[exp_stkp].exp_nsq:0 )
*)
(*
; WRITELN( ' FNC Result lvl ', exp_stkp:0, ' : ', exp_stk[exp_stkp] )
*)
  end
end GEN_GENERIC_CALL;



procedure DISPLAY_SEARCH_RES( ent: ent_ptr );
var
  ip: ide_ptr;

begin
  if ent <> nil then
  with ent^ do
  begin
    case ent_knd of
      entk_stm:
        begin
          WRITE( ' Found ', ent_stm, '( ', ent_pt1^.typ_ide^.ide_name^ );
          if ent_npa > 1 then WRITE( ', ', ent_pt2^.typ_ide^.ide_name^ )
        end;
      entk_fnc:
        begin
          if ent_ope = no_op then
            if ent_ide^.ide_name <> nil then WRITE( ' Found Generic "', ent_ide^.ide_name^, '"' )
                                        else WRITE( ' Nil IDENT' )
          else WRITE( ' Found for ope = "', ent_str, '"' );
          WRITELN( ' with ', ent_npa:0, ' arguments :' );
          ip := ent_frl;
          while ip <> nil do
          with ip^ do
          begin
            WRITELN( ' ':8, ide_name^, ': ', ide_typ^.typ_ide^.ide_name^ );
            ip := ide_lnk
          end
        end;
    otherwise
    end;
    WRITELN( ' ) -> ', ent_typ^.typ_ide^.ide_name )
  end
  else WRITELN( ' Not found stm/mfunction' );
end DISPLAY_SEARCH_RES;



procedure GEN_GENOPER( op: dcp_oper; npa: integer );
const
  mdnam = 'COPE';

var
  ent: ent_ptr;

  nam_ope: [static] array[dcp_oper] of string( 4 ) :=
    [ 'not',  '**',   '*',   '/', 'div', 'mod', 'rem',   '+',
        '-',  '||',   '<',  '<=',  '>=',   '>',  '<>',   '=',
      'and',  'or', 'xor',  ':=',   ';',   ' ' ];

begin
(*
WRITELN( ' Look for operator ', op );
*)
  ent := GENERIC_SEARCH( mop_tab[op].mop_last, npa );
(*
DISPLAY_SEARCH_RES( ent );
*)
  if ent <> nil then
  begin
    case ent^.ent_knd of
      entk_stm: { Intrinsec statement }
        if npa = 1 then EXE_VAL_UNA( ent )      { Unary operator }
                   else EXE_VAL_BIN( ent );     { Binary operator }

      entk_fnc: { User defined operation }
        GEN_GENERIC_CALL( ent, npa, true );    { User defined operator }

    otherwise
    end
  end
  else SRC_ERROR_S( mdnam, 128, e_error, nam_ope[op] )
end GEN_GENOPER;





[global]
procedure EXP_GENERIC_CALL( idp: ide_ptr; bexpr: boolean );
const
  mdnam = 'EGCA';

var
  npa: integer;
  ent: ent_ptr;

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the function/procedure identifier }
    { Push each argument in the stack }
    npa := 0;
    if sy = lparen then
    begin
      sy := comma;
      while sy = comma do                       { Loop on the argument list }
      begin
        INSYMBOL;                               { Gobble up "(" or "," }
        if (sy <> comma) and (sy <> rparen) then
        begin
          EXPRESSION; npa := SUCC( npa )        { Get each argument }
        end
      end;
      if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
                      else INSYMBOL
    end;

    { Search the entry that match with the parameter list }
    ent := GENERIC_SEARCH( idp^.ideg_last, npa );
(*
DISPLAY_SEARCH_RES( ent );
*)
    if ent <> nil then
    begin
      case ent^.ent_knd of
        entk_stm: { Intrinsec statement }
          if npa = 1 then EXE_VAL_UNA( ent )    { Exec the Unary Intrinsec function }
                     else EXE_VAL_BIN( ent );   { exec the Binary Intrinsec function }

        entk_fnc: { User defined operation }
          GEN_GENERIC_CALL( ent, npa, true );   { Exec the user function }

        entk_std: { Builtin procedure and function }
          EXEC_BUILTIN( ent^.ent_std, npa );    { Exec the Builtin function }

      otherwise
      end
    end
    else SRC_ERROR_S( mdnam, 128, e_error, idp^.ide_name^ )
  end
end EXP_GENERIC_CALL;



[global]
procedure GET_EXPRESSION( var rec: exp_rec );
{ Routine to get an expression, the result is located in the record exp_res }
const
  mdnam = 'GEXP';

var
  sp: integer;

begin
  sp := exp_stkp;            { Save the stack pointer }
  EXPRESSION;                { Manage the current expression }
  POP_EXPRESSION( rec );     { Pop the resulting expression from the stack }
  if sp <> exp_stkp then
  begin
    SRC_ERROR( mdnam, 9, e_error );
    exp_stkp := sp           { Restore the stack pointer }
  end
end GET_EXPRESSION;



[global]
procedure BLD_FARR_TYPE( ty: typ_ptr; var rty: typ_ptr; var esz: integer; lvl: integer := 0 );
{ Build the descriptor tree of a variable from a wild array type definition }
begin
  if ty <> nil then
  begin
    case ty^.typ_frm of
    tfrm_array: { We have an array descriptor record }
      if objf_vbnda in ty^.typ_flg then
      begin { It is a wild array descriptor record }
        rty := TYP_NEW( tfrm_array, nil, ty, lvl );     { We create a child array descriptor (not wild) }
        with rty^ do
        begin
          BLD_FARR_TYPE( ty^.typ_ael, typ_ael, typ_stp, lvl );  { We perform this recursively }
          typ_flg := ty^.typ_flg - [objf_wild,objf_vbnda];      { Set the type as not a wild type }
          { We compute the array step by using the array element size when it is fixed }
          if typ_ael <> nil then typ_stp := typ_ael^.typ_siz*typ_ael^.typ_stp
                            else typ_stp := 0;          { For correct array, the root element of wild array is always defined }
          typ_siz := 0;
          typ_min := ty^.typ_min;                       { The start value of index is always known }
          esz := 0                                      { The total array size is unknown }
        end
      end
      else
      begin
        rty := ty; esz := ty^.typ_siz*ty^.typ_stp       { For not wild array we can compute the array size }
      end;
    otherwise
      rty := ty; esz :=  1                              { When it is a scalar type the size is always 1 and the descriptor does not change }
    end
  end
  else begin  rty := nil; esz := 0  end                 { Return O type for undefined initial type }
end BLD_FARR_TYPE;



[global]
procedure GET_INIT_VAL( var val: val_rec; mty: typ_ptr; var typ: typ_ptr; lvl: integer := 0; pname: ^string; blrp: boolean := true );
{ Procedure to set initial value in a variable (and allocate it for a wild size array).

  val    The Value Record to put the data,
  mty    The type descriptor pointer of the variable,
  typ    Is the resulting type descriptor pointer of the variable (child of mty for wild size array and = mty otherwise),
  lvl    Is the display level (for child type allocation links),
  pname  The Identifier name pointer for error message,
  blrp   Boolean: Gobble up the final right parenthesys when true.
}
const
  mdnam = 'INIV';

var
  tmp:                 val_rec;
  esz, idx, isz, inl:  integer;
  idn:                 ^string;
  cst:                  string;
  bsg:                 boolean;


  procedure CTE_ARRAY( typ: typ_ptr; var val: val_rec; blrp: boolean );
{ Procedure to fill an array :
  typ    The array type descriptor pointer,
  val    The value record (exp_rec) to put the array data,
  blrp   Boolean: Gobble up the final right parenthesys when true.
}
  var

    ael:       typ_ptr;
    aid, asz:  integer;
    ber:       boolean;



    procedure CTE_SCALAR( var vrec: val_rec );
    { Read and put a scalar value in an array location }
    var
      st: [static] string;

    begin
      with sy_sym, vrec do
        begin                                   { No error, get a new element }
          case val_frm of
            vfrm_ast: with aas^ do
                      begin
                        if val_stb[idx] <> nil then DISPOSE( val_stb[idx] );
                        GET_STREXPR( st ); NEW( val_stb[idx], st.length ); val_stb[idx]^ := st
                      end;
            vfrm_ain: aai^.val_itb[idx] := GET_INTEXPR( 0 );
            vfrm_afl: begin
                        aaf^.val_ftb[idx] := GET_FLTEXPR( 0.0 );
                        if bsg then
                          if sy = colon then begin  INSYMBOL; asg^.val_ftb[idx] := GET_FLTEXPR( 0.0 )  end
                                        else asg^.val_ftb[idx] := 0.0
                      end;
        otherwise
        end
      end
    end CTE_SCALAR;


  begin { CTE_ARRAY }
    with sy_sym, typ^, val do
    begin
      if sy = lparen then INSYMBOL              { Skip open parenthesys }
                     else SRC_ERROR( mdnam, 22, e_error );

      ael := typ_ael;                           { Get the array element type }
      aid :=       0;                           { Init the local array element count }
      if typ_siz > 0 then asz := typ_siz        { Init the local array size (in element) ... }
                     else asz := maxint;        { ... or set at a very large limit }
      if ael <> nil then                        { Does not crash on compilation error }
      begin
        repeat                                  { Loop to get all local array element(s) }
          if (idx >= isz) or (aid >= asz) then  { Check for memory array overflow }
          begin
            SRC_ERROR( mdnam, 151, e_severe );
            SKIP_SYMBOL( rparen )
          end
          else
          begin
            aid := aid + 1;
            case ael^.typ_frm of                { Get one array element - dispatching following the element type }
              tfrm_str,                         { For all element of scalar types, the returned type is the initial type }
              tfrm_int,
              tfrm_flt: begin
                          idx := idx + 1;
                          CTE_SCALAR( val )
                        end;
              tfrm_array: CTE_ARRAY( ael, val, true );
            otherwise
            end
          end;
        exit if sy <> comma;                    { Stop the loop at the end of local array }
          INSYMBOL                              { Else skip "," and continue to loop }
        until false;

        if typ_siz = 0 then                     { When we had wild array size }
        begin
          if ael^.typ_frm = tfrm_array then typ_stp := ael^.typ_siz*ael^.typ_stp
                                       else typ_stp := 1;
          typ_siz := aid                        { Set the definitive array element number }
        end
        else                                    { Defined size array }
        begin
          while aid < typ_siz do                { Complete any incomplet list of value by 0 or '' }
          begin
            aid := aid + 1;
            for ii := 1 to typ_stp do
            begin
              idx := idx + 1;
              case val_frm of
                vfrm_ast: aas^.val_stb[idx] := nil;
                vfrm_ain: aai^.val_itb[idx] :=   0;
                vfrm_afl: begin
                            aaf^.val_ftb[idx] := 0.0;
                            if bsg then asg^.val_ftb[idx] := 0.0
                          end;
              otherwise
              end
            end
          end
        end
      end;
      if blrp then
        if sy = rparen then INSYMBOL
                       else SRC_ERROR( mdnam, 23, e_error )
    end
  end CTE_ARRAY;



begin { GET_INIT_VAL }
  if mty <> nil then
  with sy_sym, mty^, val do
  begin
    if typ_ide <> nil then idn := typ_ide^.ide_name
                      else idn := nil;
    bsg := objf_sigma in typ_flg;
    typ := mty;
    val_cte := false;
    val_frm := GET_VAL_FORMS( mty );
    case typ_frm of
      tfrm_str: begin  GET_STREXPR( cst ); NEW( str, cst.length ); str^ := cst  end;
      tfrm_int: int := GET_INTEXPR( 0 );
      tfrm_flt: begin
                  flt := GET_FLTEXPR( 0.0 ); sig := 0.0;
                  if bsg and (sy = colon) then begin  INSYMBOL; sig := GET_FLTEXPR( 0.0 )  end
                end;

      tfrm_array:
        begin
          idx := 0;
          if objf_vbnda in typ_flg then          { For any unsized (wild) array }
          begin
            isz := max_cte_size;                { Set the maximum element allowed }
            tmp.val_frm := val_frm;
            case val_frm of                     { Allocate the temporary space }
              vfrm_ast: NEW( tmp.aas, max_cte_size );
              vfrm_ain: NEW( tmp.aai, max_cte_size );
              vfrm_afl: begin
                          NEW( tmp.aaf, max_cte_size );
                          if objf_sigma in typ_flg then
                          begin  bsg := true; NEW( tmp.asg, max_cte_size )  end
                          else tmp.asg := nil;
                        end;
            otherwise
            end;
            isz := max_cte_size;
            BLD_FARR_TYPE( mty, typ, inl );     { Build the children derived (not wild) type }
            CTE_ARRAY( typ, tmp, blrp );        { Get the specified value for the array }
            case val_frm of                     { Allocate the variable space, copy all value and free temporary room }
              vfrm_ast: begin
                          NEW( aas, idx );
                          for ii := 1 to idx do aas^.val_stb[ii] := tmp.aas^.val_stb[ii];
                          DISPOSE( tmp.aas )
                        end;
              vfrm_ain: begin
                          NEW( aai, idx );
                          for ii := 1 to idx do aai^.val_itb[ii] := tmp.aai^.val_itb[ii];
                          DISPOSE( tmp.aai )
                        end;
              vfrm_afl: begin
                          NEW( aaf, idx );
                          for ii := 1 to idx do aaf^.val_ftb[ii] := tmp.aaf^.val_ftb[ii];
                          DISPOSE( tmp.aaf );
                          if bsg then
                          begin
                            NEW( asg, idx );
                            for ii := 1 to idx do asg^.val_ftb[ii] := tmp.asg^.val_ftb[ii];
                            DISPOSE( tmp.asg )
                          end
                        end;
            otherwise
            end
          end
          else
          begin
            isz := typ_siz*typ_stp;             { Compute and ... }
            esz := isz;                         { ... set the total allocated space size ... }
            if sy = lparen then
              CTE_ARRAY( typ, val, blrp )       { ... and fill the array }
            else { A sized array receive a unique value }
            begin
              blrp := true;                     { We does not gobble up the parenthesys }
              case val_frm of
                vfrm_ast: begin
                            cst.length := 0; GET_STREXPR( cst );
                            with aas^ do
                              for ii := 1 to val_all do
                                if cst.length > 0 then
                                begin  NEW( val_stb[ii], cst.length ); val_stb[ii]^ := cst  end
                                else val_stb[ii] := nil
                          end;
                vfrm_ain: begin
                            tmp.int := GET_INTEXPR( 0 );
                            with aai^ do
                              for ii := 1 to val_all do val_itb[ii] := tmp.int
                          end;
                vfrm_afl: begin
                            tmp.flt := GET_FLTEXPR( 0.0 );
                            with aaf^ do
                              for ii := 1 to val_all do val_ftb[ii] := tmp.flt;
                            if bsg then
                            begin
                              if sy = colon then begin  INSYMBOL; tmp.sig := GET_FLTEXPR( 0.0 )  end
                                            else tmp.sig := 0.0;
                              with asg^ do
                                for ii := 1 to val_all do val_ftb[ii] := tmp.sig
                            end
                          end;
              otherwise
              end
            end
          end
        end;

    otherwise
      SRC_ERROR_S( mdnam, 91, e_severe, pname^, idn^ );
      SKIP_SYMBOL( semicolon )
    end
  end
  else val.val_frm := vfrm_null
end GET_INIT_VAL;



[global]
function EXP_GETKINDS( ish: integer ): val_forms;
const
  mdnam = 'EXGK';

var
  frm: val_forms;

begin
  frm := vfrm_null;
  ish := exp_stkp - ish;
  if ish > 0 then frm := exp_stk[ish].exp_val.val_frm
             else SRC_ERROR( mdnam, 8, e_severe );
  EXP_GETKINDS := frm
end EXP_GETKINDS;


{ ***  Routines to get an expression value of a predefined type *** }

[global]
procedure CHECK_LVALUE_REF( var rec: exp_rec );
begin
  if debug_exp then
  with lst_current^, rec do
  begin
    WRITE( lst_file, ' Lvalue POP : ' );
    if exp_ref = nil then WRITE( lst_file, '<Not a Identifier Ref.>' )
    else
      with exp_ref^ do
        if ide_name <> nil then WRITE( lst_file, '"',ide_name, '"' )
                           else WRITE( lst_file, '<Identifier Without Name>' );
    WRITELN( lst_file )
  end;
  if rec.exp_ref = nil then SRC_ERROR( 'EXRF', 111, e_severe )
end CHECK_LVALUE_REF;



[global]
procedure GET_EXP_REFER( var rec: exp_rec; ide: ide_ptr := nil );
{ Get an expression reference and put it in the expression record exp_res }
begin
  last_ide := ide;
  GET_EXPRESSION( rec );
  CHECK_LVALUE_REF( rec )
end GET_EXP_REFER;



[global]
procedure EXTRACT_VALUE( var rec:    exp_rec;
                         var frm:  val_forms;
                         var iv:     integer;
                         var rv, sg: mxd_flt;
                         var st:      string  );
{ To Extract a number value from exp_res }
const
  mdnam = 'EXVL';

begin
  if debug_exp then WRITELN( lst_current^.lst_file, ' Deb EXTRACT POP  ', rec );
  with rec, exp_val do
  begin
    case val_frm of
      vfrm_est,
      vfrm_str: begin
                  if val_frm = vfrm_est then { Array is always a reference }
                    if aas <> nil then str := aas^.val_stb[exp_shf+1]
                                  else str := nil;
                  frm := vfrm_str;
                  if str <> nil then
                  begin
                    st := str^;
                    if exp_ref = nil then
                    begin  DISPOSE( str ); str := nil  end { Free any temporary string }
                  end else st.length := 0
                end;

      vfrm_ein,
      vfrm_int: begin
                  if val_frm = vfrm_ein then
                    if aai <> nil then int := aai^.val_itb[exp_shf+1]
                                  else int := 0;
                  frm := vfrm_int; iv  := int
                end;

      vfrm_efl,
      vfrm_flt: begin
                  if val_frm = vfrm_efl then
                  begin
                    if aaf <> nil then flt := aaf^.val_ftb[exp_shf+1]
                                  else flt := 0.0;
                    if asg <> nil then sig := asg^.val_ftb[exp_shf+1]
                                  else sig := 0.0
                  end;
                  frm := vfrm_flt;
                  rv  := flt
                end;
    otherwise
      { Illegal array or item use or null expression }
      if val_frm <> vfrm_null then SRC_ERROR( mdnam, 112, e_severe );
      frm := vfrm_null
    end;
    val_frm := vfrm_null
  end
end EXTRACT_VALUE;



[global]
procedure EXTRACT_STR( var rec: exp_rec; var st: string );
{ To get a string value }
var
  fm:        val_forms;
  iv:          integer;
  rv, sg:      mxd_flt;

begin
  EXTRACT_VALUE( rec, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: ;
    vfrm_flt: WRITEV( st, rv );
    vfrm_int: WRITEV( st, iv );
  otherwise
  end
end EXTRACT_STR;



[global]
function EXTRACT_INT( var rec: exp_rec; iv: integer ): integer;
{ To get an integer value }
var
  fm:        val_forms;
  st:       str_string;
  rv, sg:      mxd_flt;

begin
  EXTRACT_VALUE( rec, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, iv )
                               else iv := 0;
    vfrm_flt: iv := ROUND( rv );
    vfrm_int: ;
  otherwise
  end;
  EXTRACT_INT := iv
end EXTRACT_INT;



[global]
function EXTRACT_FLT( var rec: exp_rec; rv: mxd_flt ): mxd_flt;
{ To get a floatting value }
var
  fm:        val_forms;
  st:       str_string;
  iv:          integer;
  sg:          mxd_flt;

begin
  EXTRACT_VALUE( rec, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, rv )
                               else rv := 0.0;
    vfrm_flt: ;
    vfrm_int: rv := iv;
  otherwise
  end;
  EXTRACT_FLT := rv
end EXTRACT_FLT;



[global]
procedure GET_EXP_VALUE( var frm: val_forms; var iv:     integer;
                                             var rv, sg: mxd_flt;
                                             var st:      string );
{ To get a value }
const
  mdnam = 'GEVL';

var
  sp: integer;

begin
  sp := exp_stkp;               { Save the stack pointer }
  GET_EXPRESSION( exp_rs0 );    { Manage the current expression }
  EXTRACT_VALUE( exp_rs0, frm, iv, rv, sg, st );
  if sp <> exp_stkp then
  begin
    SRC_ERROR( mdnam, 9, e_error );
    exp_stkp := sp              { Restore the stack pointer }
  end
end GET_EXP_VALUE;



[global]
procedure GET_STREXPR( var st: string );
{ To get a string value }
var
  fm:        val_forms;
  iv:          integer;
  rv, sg:      mxd_flt;

begin
  GET_EXP_VALUE( fm, iv, rv, sg, st );
  case fm of
    vfrm_str: ;
    vfrm_flt: WRITEV( st, rv );
    vfrm_int: WRITEV( st, iv );
  otherwise
  end
end GET_STREXPR;



[global]
function GET_INTEXPR( iv: integer ): integer;
{ To get an integer value }
var
  fm:        val_forms;
  st:       str_string;
  rv, sg:      mxd_flt;

begin
  GET_EXP_VALUE( fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, iv )
                               else iv := 0;
    vfrm_flt: iv := ROUND( rv );
    vfrm_int: ;
  otherwise
  end;
  GET_INTEXPR := iv
end GET_INTEXPR;



[global]
function GET_FLTEXPR( rv: mxd_flt ): mxd_flt;
{ To get a floatting value }
var
  fm:        val_forms;
  st:       str_string;
  iv:          integer;
  sg:          mxd_flt;

begin
  GET_EXP_VALUE( fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, rv )
                               else rv := 0.0;
    vfrm_flt: ;
    vfrm_int: rv := iv;
  otherwise
  end;
  GET_FLTEXPR := rv
end GET_FLTEXPR;



[global]
procedure GET_NUMEXPR( var   bf:       boolean;
                       var   iv:       integer;
                       var   rv, sg:   mxd_flt );
{ To get a number value }
var
  fm:        val_forms;
  st:       str_string;

begin
  GET_EXP_VALUE( fm, iv, rv, sg, st );
  case fm of
    vfrm_str: begin
                bf := false;
                if st.length > 0 then READV( st, iv )
                                 else iv := 0
              end;
    vfrm_int: bf := false;
    vfrm_flt: bf :=  true;
  otherwise
  end
end GET_NUMEXPR;



procedure CALL_IF_FUNCTION;
const
  mdnam = 'IFNC';

begin
  with sy_sym, exp_res, exp_val do
  begin
    INSYMBOL;
    if sy <> lparen then SRC_ERROR( mdnam, 22, e_error )
                    else INSYMBOL;
    GET_EXPRESSION( exp_res );
    if sy <> comma then SRC_ERROR( mdnam, 29, e_error )
                   else INSYMBOL;
    if objf_lsqex in exp_flg then
    begin { We must emit the LSQ node operator nd_ifsel }
      if (sy = comma) or (sy = rparen) then EXP_PUTFLT( 0.0 )
                                       else EXPRESSION;
      if not (objf_lsqex in exp_flg) then OUT_PCD_VREF( exp_stk[exp_stkp] );
      STACK_REMOVE( 1 );
      if sy <> comma then SRC_ERROR( mdnam, 29, e_error )
                     else INSYMBOL;
      if sy = rparen then EXP_PUTFLT( 0.0 )
                     else EXPRESSION;
      if not (objf_lsqex in exp_flg) then OUT_PCD_VREF( exp_stk[exp_stkp] );
      OUT_ND_CODE( nd_ifsel )
    end
    else { We proceed to the IF choice here }
      if EXTRACT_INT( exp_res, 0 ) > 0 then
      begin
        if (sy = comma) or (sy = rparen) then EXP_PUTINT( 0 )
                                         else EXPRESSION;
        SKIP_SYMBOL( rparen )
      end
      else
      begin
        if sy <> comma then SKIP_SYMBOL( comma );
        if sy = comma then begin  INSYMBOL; EXPRESSION   end
                      else EXP_PUTINT( 0 );
      end;
    if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
  end
end CALL_IF_FUNCTION;



[global]
procedure ARRSCA_SS_ASSIGN( var src, dst: exp_rec );
var
  idst: integer;

begin
  with dst, exp_val do
  begin
    idst := exp_shf+1;
    if exp_typ <> nil then
    with aas^ do
      for ii := 1 to dst.exp_esz do
      begin
        if val_stb[idst] <> nil then DISPOSE( val_stb[idst] );
        if src.exp_val.str <> nil then
          if src.exp_ref = nil then
            { Temporary string begin permanent }
            val_stb[idst] := src.exp_val.str
          else
          begin { Create a string copy }
            NEW( val_stb[idst], src.exp_val.str^.length );
            val_stb[idst]^ := src.exp_val.str^
          end
          else val_stb[idst] := nil;
          idst := idst + 1
      end
  end
end ARRSCA_SS_ASSIGN;



[global]
procedure ARRSCA_II_ASSIGN( vsrc: integer; var dst: exp_rec );
var
  idst: integer;

begin
  with dst, exp_val do
  begin
    idst := exp_shf+1;
    if aai <> nil then
    with aai^ do
      for ii := 1 to exp_esz do
      begin
        val_itb[idst] := vsrc; idst := idst + 1
      end;
  end
end ARRSCA_II_ASSIGN;



[global]
procedure ARRSCA_FF_ASSIGN( vval, vsig: mxd_flt; var dst: exp_rec );
var
  idst: integer;

begin
  with dst, exp_val do
  begin
    idst := exp_shf+1;
    if aaf <> nil then
    with aaf^ do
      for ii := 1 to exp_esz do
      begin
        val_ftb[idst] := vval;
        if asg <> nil then asg^.val_ftb[idst] := vsig;
        idst := idst + 1
      end
  end
end ARRSCA_FF_ASSIGN;



procedure ARRAY_DEF_MATCH( src, dst: exp_rec;
                           var siz: integer; var flg: boolean );
const
  mdnam = 'ARMA';

var
  p1, p2:      typ_ptr;
  ok:          boolean;

begin
  ok := true;
  p1 := src.exp_typ;
  p2 := dst.exp_typ;
  if src.exp_esz = dst.exp_esz then
    while (p1^.typ_frm = tfrm_array) and (p2^.typ_frm = tfrm_array) and
          (p1 <> nil) and (p2 <> nil) and ok do
    begin
      ok := (p1^.typ_stp = p2^.typ_stp) and
            (p1^.typ_siz = p2^.typ_siz);
      p1 := p1^.typ_ael;
      p2 := p2^.typ_ael
    end
  else ok := false;
  flg := ok and (p1 = p2);
  if not flg then SRC_ERROR( mdnam, 78, e_severe );
  siz := dst.exp_esz
end ARRAY_DEF_MATCH;



[global]
procedure ARRAY_SS_ASSIGN( var src, dst: exp_rec );
{ Copy a string array to an other one }
var
  size, isrc, idst:    integer;
  psrc, pdst:         ^val_ast;
  bok:                 boolean;

begin
  ARRAY_DEF_MATCH( src, dst, size, bok );
  if bok and (src.exp_typ <> nil) and (dst.exp_typ <> nil) then
  begin
    psrc := src.exp_val.aas;
    isrc := src.exp_shf;
    pdst := dst.exp_val.aas;
    idst := dst.exp_shf;
    for ii := 1 to size do
    begin
      idst := idst + 1; isrc := isrc + 1;
      if pdst^.val_stb[isrc] <> nil then DISPOSE( pdst^.val_stb[idst] );
      if psrc^.val_stb[isrc] <> nil then
      begin
        NEW( pdst^.val_stb[idst], psrc^.val_stb[isrc]^.length );
        pdst^.val_stb[idst]^ := psrc^.val_stb[isrc]^
      end
      else pdst^.val_stb[idst] := nil
    end;
  end
end ARRAY_SS_ASSIGN;



[global]
procedure ARRAY_II_ASSIGN( var src, dst: exp_rec );
{ Copy an integer array to another one }
var
  size, isrc, idst: integer;
  psrc, pdst:      ^val_ain;
  bok:              boolean;

begin
  ARRAY_DEF_MATCH( src, dst, size, bok );
  if bok and (src.exp_val.aai <> nil) and (dst.exp_val.aai <> nil) then
  begin
    psrc := src.exp_val.aai;
    isrc := src.exp_shf;
    pdst := dst.exp_val.aai;
    idst := dst.exp_shf;
    for ii := 1 to size do
    begin
      idst := idst + 1; isrc := isrc + 1;
      pdst^.val_itb[idst] := psrc^.val_itb[isrc]
    end;
  end
end ARRAY_II_ASSIGN;



[global]
procedure ARRAY_FI_ASSIGN( var src, dst: exp_rec );
{ Copy a float array to an integer array }
var
  size, isrc, idst: integer;
  psrc:            ^val_afl;
  pdst:            ^val_ain;
  bok:              boolean;

begin
  ARRAY_DEF_MATCH( src, dst, size, bok );
  if bok and (src.exp_val.aaf <> nil) and (dst.exp_val.aai <> nil) then
  begin
    psrc := src.exp_val.aaf;
    isrc := src.exp_shf;
    pdst := dst.exp_val.aai;
    idst := dst.exp_shf;
    idst := dst.exp_shf;
    for ii := 1 to size do
    begin
      idst := idst + 1; isrc := isrc + 1;
      pdst^.val_itb[idst] := ROUND( psrc^.val_ftb[isrc] )
    end;
  end
end ARRAY_FI_ASSIGN;



[global]
procedure ARRAY_IF_ASSIGN( var src, dst: exp_rec );
{ Copy an integer array to a float array }
var
  size, isrc, idst: integer;
  psrc:            ^val_ain;
  pdva, pdsg:      ^val_afl;
  bok:              boolean;

begin
  ARRAY_DEF_MATCH( src, dst, size, bok );
  if bok and (src.exp_val.aai <> nil) and (dst.exp_val.aaf <> nil) then
  begin
    psrc := src.exp_val.aai;
    isrc := src.exp_shf;
    pdva := dst.exp_val.aaf;
    pdsg := dst.exp_val.asg;
    idst := dst.exp_shf;
    for ii := 1 to size do
    begin
      idst := idst + 1; isrc := isrc + 1;
      pdva^.val_ftb[idst] := psrc^.val_itb[isrc];
      if pdsg <> nil then pdsg^.val_ftb[idst] := 0.0
    end;
  end
end ARRAY_IF_ASSIGN;



[global]
procedure ARRAY_FF_ASSIGN( var src, dst: exp_rec );
{ Copy a float array to another one }
var
  size, isrc, idst:            integer;
  psva, pssg, pdva, pdsg:     ^val_afl;
  bok:                         boolean;

begin
  ARRAY_DEF_MATCH( src, dst, size, bok );
  if bok and (src.exp_val.aaf <> nil) and (dst.exp_val.aaf <> nil) then
  begin
    psva := src.exp_val.aaf; pssg := src.exp_val.asg; isrc := src.exp_shf;
    pdva := dst.exp_val.aaf; pdsg := dst.exp_val.asg; idst := dst.exp_shf;
    for ii := 1 to size do
    begin
      idst := idst + 1; isrc := isrc + 1;
      pdva^.val_ftb[idst] := psva^.val_ftb[isrc];
      if pdsg  <> nil then
        if pssg <> nil then pdsg^.val_ftb[idst] := pssg^.val_ftb[isrc]
                       else pdsg^.val_ftb[idst] := 0.0
    end
  end
end ARRAY_FF_ASSIGN;



[global]
function IN_FILEMODE( iv: integer ): flags_file;
var
  imd: flags_file;

begin
  if ODD( iv ) then imd := [case_dis_file]
               else imd := [];
  if ODD( iv div 2 ) then imd := imd + [nolog_file];
  IN_FILEMODE := imd
end IN_FILEMODE;



procedure  EXP_PUT_BLTVAL( ip: ide_ptr );
const
  mdnam = 'BLVL';

var
  ty: typ_ptr;

begin
  if exp_stkp < max_stk then exp_stkp := SUCC( exp_stkp )       { A result is given by the function but it is not used }
                        else SRC_ERROR( mdnam, 6, e_severe );
  INSYMBOL;                                     { Gobble up the type identifier }
  if ip <> nil then ty := ip^.ide_typ;
  if ty <> nil then
  with sy_sym, ty^, exp_stk[exp_stkp] do
  begin
    exp_ref :=     nil;
    exp_typ :=      ty;
    exp_nsq :=       0;
    exp_shf :=       0;
    exp_esz :=       1;
    exp_flg := typ_flg;
    VAL_ALLOCATE( exp_val, ty );                { Allocate the memory }
    case typ_frm of
      tfrm_array:
                begin
                  exp_esz := typ_stp*typ_siz;
                  GET_INIT_VAL( exp_val, ty, exp_typ, 0, ip^.ide_name, false );
(*
                  GET_INIT_VALUE( exp_val, ty, ip^.ide_name, false );
*)
                end;
      tfrm_str,
      tfrm_int,
      tfrm_flt: begin { For any scalar type }
                  if sy <> lparen then SRC_ERROR( mdnam, 22, e_error );
                  GET_INIT_VAL( exp_val, ty, exp_typ, 0, ip^.ide_name );
(*
                  GET_INIT_VALUE( exp_val, ty, ip^.ide_name );
*)
                  if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
                end;
    otherwise
      SRC_ERROR_S( mdnam, 92, e_severe, ip^.ide_name^ );
      exp_stkp := exp_stkp - 1; EXP_PUTINT( 1 );
      SKIP_SYMBOL( lparen )
    end
  end
end EXP_PUT_BLTVAL;



procedure EXP_ENTRY;
const
  mdnam = 'EXPE';

var
  ip:       ide_ptr;
  binsymb:  boolean;
  npa, idw: integer;

begin
  binsymb := true;
  with sy_sym, exp_stk[exp_stkp], exp_val do
  case sy of
    definedsy,
    mdefinedsy:                                 { Special macro related function }
      begin
        sy_nomacrflg := (sy = mdefinedsy);
        INSYMBOL;                               { Gobble up the function identifier }
        EXP_PUTINT( 0 (* , false *) );
        if sy = lparen then INSYMBOL
                       else SRC_ERROR( mdnam, 22, e_error );
        if sy = identsy then
        begin
          if sy_nomacrflg and (sy_macro <> nil) then
            case sy_macro^.idm_kind of
              idm_macro: int := 20;
              idm_parm:  int := 21;
              idm_list:  int := 22;
              idm_temp:  int := 23;
            otherwise
              int := -2
            end
          else
          begin
           ip := IDE_SEARCH( false );      { Search the identifier }
           if ip <> nil then
             case ip^.idev_val.val_frm of
               vfrm_str: int := 1;
               vfrm_int: int := 2;
               vfrm_flt: if objf_lsqob in ip^.ide_flg then int := 4
                                                      else int := 3;
               vfrm_ast: int := 11;
               vfrm_ain: int := 12;
               vfrm_afl: if objf_lsqob in ip^.ide_flg then int := 14
                                                      else int := 13;
             otherwise
               int := -1
             end
          end
        end
        else int := -99;
        sy_nomacrflg := false;
        INSYMBOL;
        if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
                        else INSYMBOL
      end;

    returnvsy: EXP_STK_COPY( 0 );       { Reference to the current function result }

    ifsy:  CALL_IF_FUNCTION;

    identsy:
      begin
        if last_ide = nil then ip := IDE_SEARCH( true ) { Search the identifier }
                          else begin  ip := last_ide; last_ide := nil  end;
        if ip = nil then EXP_PUTINT( 0 )        { When undeclared identifier push integer cte 0 }
        else
        with ip^ do
          case ide_class of
            cla_standard,
            cla_generic: begin
                           EXP_GENERIC_CALL( ip, true ); { Call function an expression }
                           binsymb := false
                         end;

            cla_field,
            cla_itmfld,
            cla_varbl:   EXP_PUT_REFER( ip );

            cla_formal:  EXP_PUT_FORMAL( ip );  { Formal argument of a user macro function }

            cla_type:    EXP_PUT_BLTVAL( ip );  { Put the specified value from the type definition }

          otherwise
          end
      end;

    selectsy:    FNC_SELECT;
    integropsy:  FNC_INTEGR;
    summopsy:    FNC_SUMMATION;
    summdatasy:  FNC_SUMMDATA;

    intconst:    EXP_PUTINT(   sy_ival );
    singleconst,
    doubleconst: EXP_PUTFLT(   sy_rval );
    stringconst: EXP_PUTSTR( sy_string );

    endsy, comma, semicolon,
    rparen, rbrack:
      begin { Put a null value }
        EXP_PUT_REFER( nil );
        binsymb := false
      end;

  otherwise
    SRC_ERROR( mdnam, 42, e_error )
  end;

  if debug_exp then WRITELN( lst_current^.lst_file, ' Deb Entry Push  ', exp_stk[exp_stkp] );

  if binsymb then INSYMBOL
end EXP_ENTRY;



procedure EXP_INDEX( itmf: boolean := false );
{ To manipulate the array reference in the stack }
const
  mdnam = 'ARRF';

var
  err:         boolean;
  idx, jdx:    integer;

begin
  err := false;
  with sy_sym, exp_stk[exp_stkp], exp_val do
  if exp_typ <> nil then                        { For correct array definition }
  with exp_typ^ do
    if typ_frm <> tfrm_array then               { When the object is not an array ... }
    begin
      SRC_ERROR( mdnam, 113, e_severe );        { Emit an error and skip }
      err := true
    end
    else
    begin
      idx := GET_INTEXPR( typ_min-1 ) - typ_min;{ Get the specified index }
      if (idx < 0) or (idx >= typ_siz) then
      begin                                     { If the index is out of range }
        SRC_ERROR( mdnam, 71, e_error );        { Error ! force first array element to continue }
        idx := 0
      end;
      exp_shf := exp_shf + idx*typ_stp;         { Set the shift of object in the array }
      if sy = twodot then                       { For the array part reference }
      begin { Part of array reference }
        INSYMBOL;                               { Gobble up ".." }
        jdx := GET_INTEXPR( idx ) - typ_min;    { Get the upper index bound }
        if (jdx < idx) or (jdx >= typ_siz) then
        begin { Upper bound < lower bound or upper bound greater than max. }
          SRC_ERROR( mdnam, 80, e_error );      { Upper index limit out of range error ! }
          jdx := typ_siz - idx + 1              { Set the maximum value }
        end;
        exp_esz := typ_stp*(jdx - idx + 1)      { Set the number of element in the array part. }
      end
      else
      begin { An element is referenced }
        exp_esz := typ_stp;
        exp_typ := typ_ael;                     { Get the array element type }
        if exp_typ <> nil then
        case exp_typ^.typ_frm of
          tfrm_str: val_frm := vfrm_est;
          tfrm_int: val_frm := vfrm_ein;
          tfrm_flt: val_frm := vfrm_efl;
        otherwise
        end;
        if exp_nva and not itmf then
          if val_frm = vfrm_efl then
            if objf_lsqob in exp_flg then
             OUT_PCD_VREF( exp_stk[exp_stkp] )
      end
    end;
  if err then SKIP_SYMBOL( rbrack )
end EXP_INDEX;



procedure EXP_FIELD;
const
  mdnam = 'FIEL';

var
  err:         boolean;
  ide:         ide_ptr;
  itm:         itm_ptr;
  typ:         typ_ptr;
  itn:         integer;

begin
(*
WRITELN( ' EXP_FIELD Item Obj : ', exp_stk[exp_stkp] );
*)
  with sy_sym, exp_stk[exp_stkp] do
  if (exp_ref <> nil) and (exp_typ <> nil) then
  begin
    if (exp_typ^.typ_frm = tfrm_flt) and (sy_ident = 's') then
    with exp_val do
    begin
      INSYMBOL;
      if val_frm = vfrm_efl then
        if asg = nil then begin  val_frm := vfrm_flt; flt := 0.0; sig := 0.0  end
                     else begin  aaf := asg; asg := nil  end
      else begin  flt := sig; sig := 0.0  end
    end
    else
    if exp_typ^.typ_frm = tfrm_itmty then
    begin
      itn := exp_nsq;
      typ := exp_typ;
      ide := LEVEL_SEARCH( typ^.typ_fel );
      INSYMBOL;
      if ide = nil then
      begin
        SRC_ERROR_S( mdnam, 63, e_error, sy_ident, exp_ref^.ide_name^ );
        exp_typ := int_typ; exp_val.val_frm := vfrm_int; exp_val.int := 0
      end
      else
      begin
        exp_typ := ide^.ide_typ;
        itm := exp_val.itm;
        if itm <> nil then
        begin
          exp_val := itm^.itm_tab[ide^.idee_sequnb];
          itn := itm^.itm_sequ
        end
        else
        with exp_val do
        begin
          val_cte := false;
          val_frm := GET_VAL_FORMS( typ );
          case val_frm of
            vfrm_ast: aas := nil;
            vfrm_ain: aai := nil;
            vfrm_afl: begin  aaf := nil; asg := nil  end;
          otherwise
          end
        end;

        with exp_typ^ do
          if typ_frm = tfrm_array then
          begin
            exp_esz := typ_stp*typ_siz;
            if sy = lbrack then
            begin
              sy := comma;
              while sy = comma do
              begin  INSYMBOL; EXP_INDEX( true )  end;
              if sy = rbrack then INSYMBOL
                             else SRC_ERROR( mdnam, 26, e_error )
            end
            else exp_flg := exp_flg + [objf_retva]
          end
          else exp_esz := 1;

        if exp_nva and (itn <> 0) and (not exp_val.val_cte) then
        begin
          OUT_ITEM_FREF( exp_stk[exp_stkp], typ^.typ_pcd, itn, ide^.idee_offset );
          exp_flg := exp_flg + [objf_lsqex]
        end;

(*
          itm := exp_val.itm;
          if itm <> nil then
          if itm^.itm_typ <> nil then
          with itm^ do
          begin
            exp_typ := ide^.ide_typ;
            exp_val := itm_tab[ide^.idee_sequnb];
            if exp_typ <> nil then
            with exp_typ^ do
              if typ_frm = tfrm_array then exp_esz := typ_stp*typ_siz
                                      else exp_esz := 1;
            if sy = lbrack then
            begin
              sy := comma;
              while sy = comma do
              begin  INSYMBOL; EXP_INDEX( true )  end;
              if sy = rbrack then INSYMBOL
                             else SRC_ERROR( mdnam, 26, e_error )
            end
            else exp_flg := exp_flg + [objf_retva];
            if exp_nva and (itm_sequ > 0) then OUT_ITEM_FREF( exp_stk[exp_stkp], itm_typ^.typ_pcd, itm_sequ, ide^.idee_offset );
          end;
*)
        if exp_val.val_frm = vfrm_null then
        begin  exp_typ := int_typ; exp_val.val_cte := false; exp_val.val_frm := vfrm_int; exp_val.int := 0  end
      end
    end
    else
    begin
      SRC_ERROR( mdnam, 62, e_severe );
      SKIP_SYMBOL( semicolon )
    end
  end
end EXP_FIELD;



[global]
procedure EXPRESSION;
const
  mdnam = 'EXPR';

var
  bi, bj:     boolean;
  ops:        dcp_oper;

  procedure EXP_AND;
  var
    ops: dcp_oper;

    procedure EXP_NOT;
    var
      ops: dcp_oper;

      procedure EXP_REL;
      var
        ops: dcp_oper;

        procedure EXP_ADD;
        var
          ops: dcp_oper;

          procedure EXP_MUL;
          var
            ops: dcp_oper;

            procedure EXP_POW; 
            var
              ops: dcp_oper;

              procedure EXP_UNA;
              const
                mdnam = 'EXUN';

              var
                ops:  dcp_oper;
                bf:    boolean;

              begin { EXP_UNA }
                with sy_sym do
                begin
                  bf := false;
                  ops := sub_op;
                  while (sy = addop) and ((op = sub_op) or (op = add_op)) do
                  begin  if op = sub_op then bf := not bf; INSYMBOL   end;
                  if bf then
                  begin
                    EXP_UNA;                    { Get the parameter }
                    GEN_GENOPER( ops, 1 )       { Manage the unary operator }
                  end
                  else
                  if sy = lparen then           { For exprssion between parenthesys }
                  begin
                    INSYMBOL;
                    EXPRESSION;
                    if sy = rparen then INSYMBOL
                                   else SRC_ERROR( mdnam, 23, e_severe )
                  end
                  else EXP_ENTRY;               { Get the object }
                  bf := true;
                  while bf do
                    case sy of
                      lbrack: begin
                                sy := comma;
                                while sy = comma do
                                begin  INSYMBOL; EXP_INDEX  end;
                                if sy = rbrack then INSYMBOL
                                               else SRC_ERROR( mdnam, 26, e_error )
                              end;
                      period: begin
                                INSYMBOL; EXP_FIELD
                              end;
                    otherwise
                      bf := false
                    end
                end
              end EXP_UNA;

            begin { EXP_POW }
              EXP_UNA;
              with sy_sym do
                if sy = powop then      { For any power class operator }
                begin
                  ops := op;            { Save the operator }
                  INSYMBOL;             { Gobble up it }
                  EXP_UNA;              { Get the second operand }
                  GEN_GENOPER( ops, 2 ) { Manage the power class operator }
                end
            end EXP_POW;

          begin { EXP_MUL }
            EXP_POW;
            with sy_sym do
            while sy = mulop do         { For any power class operator }
            begin
              ops := op;                { Save the operator }
              INSYMBOL;                 { Gobble up it }
              EXP_POW;                  { Get the second operand }
              GEN_GENOPER( ops, 2 )     { Manage the multiply class operator }
            end
          end EXP_MUL;

        begin { EXP_ADD }
          EXP_MUL;
          with sy_sym do
          while sy = addop do          { For any power class operator }
          begin
            ops := op;                 { Save the operator }
            INSYMBOL;                  { Gobble up it }
            EXP_MUL;                   { Get the second operand }
            GEN_GENOPER( ops, 2 )      { Manage the addition class operator }
          end
        end EXP_ADD;

      begin { EXP_REL }
        EXP_ADD;
        with sy_sym do
        while sy = relop do
        begin
          ops := op;            { Get the definition list head }
          INSYMBOL;
          EXP_ADD;
          GEN_GENOPER( ops, 2 ) { Manage the comparaizon class operator }
        end
      end EXP_REL;

    begin { EXP_NOT }
      with sy_sym do
        if sy = notop then
        begin
          ops := op;
          INSYMBOL;
          EXP_NOT;
          GEN_GENOPER( ops, 1 ) { Manage the logical not class operator }
        end
        else EXP_REL;
    end EXP_NOT;

  begin { EXP_AND }
    EXP_NOT;
    with sy_sym do
    while sy = lgandop do
    begin
      ops := op;
      INSYMBOL;
      EXP_NOT;
      GEN_GENOPER( ops, 2 )     { Manage the and class operator }
    end
  end EXP_AND;

begin { EXPRESSION }
  EXP_AND;
  with sy_sym do
  while sy = lgorop do
  begin
    ops := op;
    INSYMBOL;
    EXP_AND;
    GEN_GENOPER( ops, 2 )       { Manage the or class operator }
  end;

  if debug_exp then
  begin
    WRITELN( lst_current^.lst_file, ' Deb Expression ', exp_stk[exp_stkp] );
    (* TRACE( ' Deb Expression' ) *)
  end
end EXPRESSION;



[global]
procedure EXPRESSION_TYPE( typ: typ_ptr; bref: boolean );
const
  mdnam = 'GETY';

begin
  EXPRESSION;
  if not COMP_TYPE_STK( 0, typ, bref ) then SRC_ERROR( mdnam, 141, e_error )
end EXPRESSION_TYPE;



[global]
procedure GET_TYPE_EXPRESSION( var rec: exp_rec; typ: typ_ptr; bref: boolean );
const
  mdnam = 'GTYE';

var
  frm:       val_forms;
  flg:     obj_flagsty;
  st:           string;
  iv:          integer;
  fv:          mxd_flt;

begin
  EXPRESSION;
  if bref then
  begin
    if not COMP_TYPE_STK( 0, typ, bref ) then SRC_ERROR( mdnam, 142, e_error );
    POP_EXPRESSION( rec )
  end
  else
  begin
    frm := GET_VAL_FORMS( typ );
    POP_EXPRESSION( rec );
    with rec, exp_val do
      if (val_frm <> vfrm_null) and (frm <> val_frm) then
        case frm of
          vfrm_est,
          vfrm_str: begin
                      EXTRACT_STR( rec, st ); EXPRV_REMOVE( exp_res );
                      val_frm := vfrm_str; NEW( str, st.length ); str^ := st
                    end;
          vfrm_ein,
          vfrm_int: begin
                      iv := EXTRACT_INT( rec, 0 ); EXPRV_REMOVE( exp_res );
                      val_frm := vfrm_int; int := iv
                    end;
          vfrm_efl,
          vfrm_flt: begin
                      fv := EXTRACT_FLT( rec, 0.0 ); EXPRV_REMOVE( exp_res );
                      val_frm := vfrm_flt; flt := fv; sig := 0.0
                    end;
          vfrm_null: ;

        otherwise
          SRC_ERROR( mdnam, 143, e_error )
        end
  end
end GET_TYPE_EXPRESSION;



[global]
procedure GET_DIR_LARG( var exp: exp_rec; typ: typ_ptr; brf: boolean );
const
  mdnam = 'GDIA';

var
  frm:       val_forms;
  flg:     obj_flagsty;
  berr:        boolean;
begin
  if typ <> nil then
  with typ^, exp, exp_val do
  begin
    GET_EXPRESSION( exp );
    frm := GET_VAL_FORMS( typ );
    case val_frm of
      vfrm_est,
      vfrm_str: berr := (frm <> vfrm_str);

      vfrm_ein,
      vfrm_int: berr := (frm <> vfrm_int);

      vfrm_efl,
      vfrm_flt: berr := (frm <> vfrm_flt);

      vfrm_ain: berr := (frm <> vfrm_int) and (frm <> vfrm_ain);

      vfrm_afl: berr := (frm <> vfrm_flt) and (frm <> vfrm_afl);

      vfrm_itm: berr := (frm = vfrm_itm);

    otherwise
      berr := true
    end;
    if berr then SRC_ERROR( mdnam, 144, e_error )
  end
end GET_DIR_LARG;



[global]
procedure GET_FLT_MEXPR( pa: idm_ptr; typ: typ_ptr; var lsqob: boolean );
const
  mdnam = 'MFVL';

begin
  with pa^ do
  if idm_kind <> idm_parm then SRC_ERROR( mdnam, 352, e_severe )
  else
  begin
    ACTIVE_MACRO_CODE( pa );
    INSYMBOL;
    if typ = nil then EXPRESSION
                 else EXPRESSION_TYPE( typ, false );
    POP_EXPRESSION( exp_res );
    RET_OF_MACRO_CODE( pa );
    lsqob := (objf_lsqob in exp_res.exp_flg)
  end;
end GET_FLT_MEXPR;



[global]
function  GET_FLT_MVALUE( pa: idm_ptr ): mxd_flt;
const
  mdnam = 'MFVA';

begin
  with pa^ do
  if idm_kind <> idm_parm then
  begin
    SRC_ERROR( mdnam, 352, e_severe );
    GET_FLT_MVALUE := 0.0
  end
  else
  begin
    ACTIVE_MACRO_CODE( pa );
    INSYMBOL;
    GET_FLT_MVALUE := GET_FLTEXPR( 0.0 );
    RET_OF_MACRO_CODE( pa )
  end
end GET_FLT_MVALUE;


end.
