/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[4];

/* Define the local data section. */
static Blk( Rd, 3392 ) = {
 12,  12, 119, 114, 105, 116, 101,  36, 111,  98, 106, 101,  99, 116,  55,  55,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,
 86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95, 100,  99, 112,  95, 101,
120, 112, 114,  46, 112,  97, 115,   0,  23,   0,   0,   0,  11,  10, 111,  98,
106, 102,  95, 114, 111, 110, 108, 121,   0,  10, 111,  98, 106, 102,  95, 115,
112, 100, 101, 102,   0,  10, 111,  98, 106, 102,  95, 114, 101, 102, 101, 114,
  0,  10, 111,  98, 106, 102,  95, 115, 112,  97, 115, 115,   0,  10, 111,  98,
106, 102,  95, 115, 105, 103, 109,  97,   0,  10, 111,  98, 106, 102,  95, 108,
111,  99, 107, 100,   0,  10, 111,  98, 106, 102,  95, 110, 111,  97, 115, 115,
  0,  10, 111,  98, 106, 102,  95, 118,  97, 114,  98, 108,   0,  10, 111,  98,
106, 102,  95, 114, 101, 116, 118,  97,   0,  10, 111,  98, 106, 102,  95, 118,
 98, 110, 100,  97,   0,   9, 111,  98, 106, 102,  95, 119, 105, 108, 100,   0,
  0,  10, 111,  98, 106, 102,  95, 110, 111, 108, 115, 113,   0,  10, 111,  98,
106, 102,  95, 108, 115, 113, 118,  97,   0,  10, 111,  98, 106, 102,  95, 108,
115, 113, 112,  97,   0,  10, 111,  98, 106, 102,  95, 108, 115, 113, 116,  98,
  0,  10, 111,  98, 106, 102,  95, 108, 115, 113, 105, 118,   0,  10, 111,  98,
106, 102,  95, 108, 115, 113, 105, 116,   0,  10, 111,  98, 106, 102,  95, 108,
115, 113, 111,  98,   0,  10, 111,  98, 106, 102,  95, 108, 115, 113, 101, 120,
  0,  10, 111,  98, 106, 102,  95, 108, 115, 113, 100,  97,   0,  11, 111,  98,
106, 102,  95,  49,  54,  98, 105, 116, 115,  10, 111,  98, 106, 102,  95,  56,
 98, 105, 116, 115,   0,  11, 111,  98, 106, 102,  95, 108, 120,  98,  97, 115,
101,   9, 111,  98, 106, 102,  95, 110, 117, 108, 108,   0,   0,  12,  12, 119,
114, 105, 116, 101,  36, 111,  98, 106, 101,  99, 116,  11,  11,  32,  40, 101,
120, 112,  95, 114, 101,  99,  41,  32,  11,   0,   0,   0,   9,   8, 118, 102,
114, 109,  95, 115, 116, 114,   0,   8, 118, 102, 114, 109,  95, 105, 110, 116,
  0,   8, 118, 102, 114, 109,  95, 102, 108, 116,   0,   8, 118, 102, 114, 109,
 95, 101, 115, 116,   0,   8, 118, 102, 114, 109,  95, 101, 105, 110,   0,   8,
118, 102, 114, 109,  95, 101, 102, 108,   0,   8, 118, 102, 114, 109,  95,  97,
115, 116,   0,   8, 118, 102, 114, 109,  95,  97, 105, 110,   0,   8, 118, 102,
114, 109,  95,  97, 102, 108,   0,   8, 118, 102, 114, 109,  95, 105, 116, 109,
  0,   8, 118, 102, 114, 109,  95, 105, 116, 102,   0,   9, 118, 102, 114, 109,
 95, 110, 117, 108, 108,   5,   5,  32,  45,  45,  62,  32,   6,   6,  82, 101,
102,  46,  32,  34,   2,   2,  34,  32,  14,  14,  32,  32, 119, 105, 116, 104,
 32, 116, 121, 112, 101,  32,  61,  32,  11,  11,  32,  97, 110, 100,  32, 102,
108, 103,  32,  61,  32,   3,   3,  32,  58,  32,  15,  15,  34,  34,  32,  40,
110, 105, 108,  32, 115, 116, 114, 105, 110, 103,  41,  12,  12, 116, 121, 112,
101,  95, 100, 105, 115, 112, 108,  97, 121,  18,  18,  32,  68, 105, 115, 112,
108,  97, 121,  32, 116, 104, 101,  32, 116, 121, 112, 101,  32,   9,   9,  32,
 78,  97, 109, 101,  32,  61,  32,  34,  13,  13,  32,  32,  83, 112,  99,  45,
 65,  99, 116,  35,  32,  61,  32,  10,  10,  32,  70, 108,  97, 103, 115,  32,
 61,  32,  91,  11,  11,  93,  44,  32,  32,  99, 111, 100, 101,  32,  61,  32,
 10,   0,   0,   0,  11,   8, 116, 102, 114, 109,  95, 115, 116, 114,   0,   0,
  0,   8, 116, 102, 114, 109,  95, 105, 110, 116,   0,   0,   0,   8, 116, 102,
114, 109,  95, 102, 108, 116,   0,   0,   0,  10, 116, 102, 114, 109,  95,  97,
114, 114,  97, 121,   0,  11, 116, 102, 114, 109,  95, 114, 101,  99, 111, 114,
100,  10, 116, 102, 114, 109,  95, 105, 116, 109, 114, 102,   0,  10, 116, 102,
114, 109,  95, 105, 116, 109, 116, 121,   0,  11, 116, 102, 114, 109,  95, 110,
117, 109,  98, 101, 114,  11, 116, 102, 114, 109,  95, 119,  97, 114, 114,  97,
121,   9, 116, 102, 114, 109,  95, 119, 105, 108, 100,   0,   0,   9, 116, 102,
114, 109,  95, 110, 117, 108, 108,   0,   0,  10,  10,  32,  32,  32,  32,  97,
114, 114,  97, 121,  91,   2,   2,  46,  46,   9,   9,  93,  32,  40, 115, 116,
112,  32,  61,  32,   4,   4,  41,  32, 111, 102,  16,  16,  32,  32,  32,  32,
105, 116, 101, 109,  32,  40, 115, 105, 122,  32,  61,  32,   3,   3,  41,  32,
 58,   8,   8,  32,  70, 105, 101, 108, 100,  32,  34,   7,   7,  34,  32, 115,
113,  32,  61,  32,  12,  12, 101, 120, 112, 114, 118,  95, 114, 101, 109, 111,
118, 101,  14,  14, 112, 111, 112,  95, 101, 120, 112, 114, 101, 115, 115, 105,
111, 110,   4,   4,  80,  69,  88,  80,  15,  15, 112, 117, 115, 104,  95, 101,
120, 112, 114, 101, 115, 115, 105, 111, 110,   4,   4,  80,  85,  69,  88,  13,
 13, 101, 120, 112,  95, 112, 117, 116,  95, 118,  97, 108, 117, 101,   4,   4,
 80,  85,  84,  86,  13,  13, 101, 120, 112,  95, 112, 117, 116,  95, 114, 101,
102, 101, 114,   4,   4,  80,  85,  82,  70,  12,  12, 101, 120, 112,  95, 115,
116, 107,  95,  99, 111, 112, 121,   4,   4,  83,  84,  75,  67,  12,  12, 101,
120, 112,  95, 103, 101, 116,  95,  99, 111, 112, 121,  14,  14, 101, 120, 112,
 95, 112, 117, 116,  95, 102, 111, 114, 109,  97, 108,  12,  12, 101, 120, 112,
 95, 112, 117, 116, 118,  97, 108, 117, 101,   4,   4,  69,  88,  80,  80,  10,
 10,  32,  68, 101,  98,  32,  80,  85,  83,  72,  32,  10,  10, 101, 120, 112,
 95, 112, 117, 116, 115, 116, 114,  10,  10, 101, 120, 112,  95, 112, 117, 116,
105, 110, 116,  10,  10, 101, 120, 112,  95, 112, 117, 116, 102, 108, 116,  12,
 12, 115, 116,  97,  99, 107,  95, 114, 101, 109, 111, 118, 101,  13,  13,  99,
111, 109, 112,  95, 116, 121, 112, 101,  95, 115, 116, 107,  14,  14, 103, 101,
110, 101, 114, 105,  99,  95, 115, 101,  97, 114,  99, 104,  11,  11, 114, 100,
 95, 101, 114, 114,  95, 116, 114,  97, 112,  16,  16, 115, 116, 114, 105, 110,
103,  95, 116, 111,  95, 110, 117, 109,  98, 101, 114,  16,  16, 110, 117, 109,
 98, 101, 114,  95, 116, 111,  95, 115, 116, 114, 105, 110, 103,  14,  14, 115,
116, 114, 105, 110, 103,  95,  99, 111, 110,  99,  97, 116, 101,  14,  14, 115,
116, 114, 105, 110, 103,  95,  99, 111, 109, 112,  97, 114, 101,  17,  17,  97,
114, 103, 117, 109, 101, 110, 116, 115,  95, 115, 101, 116, 116, 105, 110, 103,
 14,  14, 110, 117, 109, 101, 114, 114,  95, 109,  97, 110,  97, 103, 101, 114,
 70,   0,   0,   0,  12,   7, 115, 116, 109,  95, 110, 111, 116,   0,   0,   0,
  0,   0,   7, 115, 116, 109,  95, 110, 101, 103,   0,   0,   0,   0,   0,   7,
115, 116, 109,  95, 102, 110, 103,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95, 105, 105, 112,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 102, 105,
112,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 102, 102, 112,   0,   0,
  0,   0,   0,   7, 115, 116, 109,  95, 105, 109, 108,   0,   0,   0,   0,   0,
  7, 115, 116, 109,  95, 102, 109, 108,   0,   0,   0,   0,   0,   7, 115, 116,
109,  95, 105, 100, 118,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 109,
111, 100,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 114, 101, 109,   0,
  0,   0,   0,   0,   7, 115, 116, 109,  95, 102, 100, 118,   0,   0,   0,   0,
  0,   7, 115, 116, 109,  95, 105,  97, 100,   0,   0,   0,   0,   0,   7, 115,
116, 109,  95, 102,  97, 100,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95,
105, 115,  98,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 102, 115,  98,
  0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 115, 115,  99,   0,   0,   0,
  0,   0,   7, 115, 116, 109,  95, 115, 101, 113,   0,   0,   0,   0,   0,   7,
115, 116, 109,  95, 105, 101, 113,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95, 102, 101, 113,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 115, 110,
101,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 105, 110, 101,   0,   0,
  0,   0,   0,   7, 115, 116, 109,  95, 102, 110, 101,   0,   0,   0,   0,   0,
  7, 115, 116, 109,  95, 115, 108, 116,   0,   0,   0,   0,   0,   7, 115, 116,
109,  95, 105, 108, 116,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 102,
108, 116,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 115, 108, 101,   0,
  0,   0,   0,   0,   7, 115, 116, 109,  95, 105, 108, 101,   0,   0,   0,   0,
  0,   7, 115, 116, 109,  95, 102, 108, 101,   0,   0,   0,   0,   0,   7, 115,
116, 109,  95, 115, 103, 101,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95,
105, 103, 101,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 102, 103, 101,
  0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 115, 103, 116,   0,   0,   0,
  0,   0,   7, 115, 116, 109,  95, 105, 103, 116,   0,   0,   0,   0,   0,   7,
115, 116, 109,  95, 102, 103, 116,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95,  97, 110, 100,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 120, 111,
114,   0,   0,   0,   0,   0,   6, 115, 116, 109,  95, 111, 114,   0,   0,   0,
  0,   0,   0,   8, 115, 116, 109,  95, 105,  97,  98, 115,   0,   0,   0,   0,
  8, 115, 116, 109,  95, 102,  97,  98, 115,   0,   0,   0,   0,   8, 115, 116,
109,  95, 115, 113, 114, 116,   0,   0,   0,   0,   8, 115, 116, 109,  95, 115,
105, 110, 114,   0,   0,   0,   0,   8, 115, 116, 109,  95,  99, 111, 115, 114,
  0,   0,   0,   0,   8, 115, 116, 109,  95, 116,  97, 110, 114,   0,   0,   0,
  0,   9, 115, 116, 109,  95,  97, 115, 105, 110, 114,   0,   0,   0,   9, 115,
116, 109,  95,  97,  99, 111, 115, 114,   0,   0,   0,   9, 115, 116, 109,  95,
 97, 116,  97, 110, 114,   0,   0,   0,  10, 115, 116, 109,  95, 112, 104,  97,
115, 101, 114,   0,   0,   8, 115, 116, 109,  95, 115, 105, 110, 100,   0,   0,
  0,   0,   8, 115, 116, 109,  95,  99, 111, 115, 100,   0,   0,   0,   0,   8,
115, 116, 109,  95, 116,  97, 110, 100,   0,   0,   0,   0,   9, 115, 116, 109,
 95,  97, 115, 105, 110, 100,   0,   0,   0,   9, 115, 116, 109,  95,  97,  99,
111, 115, 100,   0,   0,   0,   9, 115, 116, 109,  95,  97, 116,  97, 110, 100,
  0,   0,   0,  10, 115, 116, 109,  95, 112, 104,  97, 115, 101, 100,   0,   0,
  7, 115, 116, 109,  95, 101, 120, 112,   0,   0,   0,   0,   0,   6, 115, 116,
109,  95, 108, 110,   0,   0,   0,   0,   0,   0,   8, 115, 116, 109,  95, 116,
 97, 110, 104,   0,   0,   0,   0,   9, 115, 116, 109,  95,  98, 101, 115, 115,
106,   0,   0,   0,  10, 115, 116, 109,  95,  98, 101, 115, 115, 106, 104,   0,
  0,  12, 115, 116, 109,  95, 105, 110, 116, 101, 114, 112, 111, 108,  10, 115,
116, 109,  95, 105, 110, 116, 101, 103, 114,   0,   0,   8, 115, 116, 109,  95,
115, 117, 109, 109,   0,   0,   0,   0,   7, 115, 116, 109,  95,  99, 115, 105,
  0,   0,   0,   0,   0,   7, 115, 116, 109,  95,  99, 115, 102,   0,   0,   0,
  0,   0,   7, 115, 116, 109,  95,  99, 105, 115,   0,   0,   0,   0,   0,   7,
115, 116, 109,  95,  99, 105, 102,   0,   0,   0,   0,   0,   7, 115, 116, 109,
 95,  99, 102, 115,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95,  99, 102,
105,   0,   0,   0,   0,   0,   7, 115, 116, 109,  95, 114, 110, 100,   0,   0,
  0,   0,   0,   7, 115, 116, 109,  95, 110, 111, 112,   0,   0,   0,   0,   0,
  4,   4,  78,  69,  82,  82,  11,  11, 101, 114, 114,  95, 104,  97, 110, 100,
108, 101, 114,  11,  11, 101, 120, 101,  95, 118,  97, 108,  95, 117, 110,  97,
 11,  11, 101, 114, 114,  95, 104,  97, 110, 100, 108, 101, 114,  11,  11, 101,
120, 101,  95, 118,  97, 108,  95,  98, 105, 110,   4,   4,  73,  78,  80,  76,
  4,   4,  73,  78,  80,  76,  16,  16, 115, 101, 116,  95, 116,  97, 114, 103,
101, 116,  95, 118,  97, 108, 117, 101,   4,   4,  83,  84,  82,  71,  11,  11,
 97, 115, 115, 105, 103, 110, 101, 109, 101, 110, 116,   4,   4,  65,  83,  83,
 73,  16,  16, 103, 101, 110,  95, 103, 101, 110, 101, 114, 105,  99,  95,  99,
 97, 108, 108,   4,   4,  67,  65,  71,  69,  18,  18, 100, 105, 115, 112, 108,
 97, 121,  95, 115, 101,  97, 114,  99, 104,  95, 114, 101, 115,   7,   7,  32,
 70, 111, 117, 110, 100,  32,   2,   2,  40,  32,   2,   2,  44,  32,  16,  16,
 32,  70, 111, 117, 110, 100,  32,  71, 101, 110, 101, 114, 105,  99,  32,  34,
 10,  10,  32,  78, 105, 108,  32,  73,  68,  69,  78,  84,  18,  18,  32,  70,
111, 117, 110, 100,  32, 102, 111, 114,  32, 111, 112, 101,  32,  61,  32,  34,
  6,   6,  32, 119, 105, 116, 104,  32,  12,  12,  32,  97, 114, 103, 117, 109,
101, 110, 116, 115,  32,  58,   2,   2,  58,  32,   6,   6,  32,  41,  32,  45,
 62,  32,  24,  24,  32,  78, 111, 116,  32, 102, 111, 117, 110, 100,  32, 115,
116, 109,  47, 109, 102, 117, 110,  99, 116, 105, 111, 110,  11,  11, 103, 101,
110,  95, 103, 101, 110, 111, 112, 101, 114,   4,   4,  67,  79,  80,  69,  16,
 16, 101, 120, 112,  95, 103, 101, 110, 101, 114, 105,  99,  95,  99,  97, 108,
108,   4,   4,  69,  71,  67,  65,  14,  14, 103, 101, 116,  95, 101, 120, 112,
114, 101, 115, 115, 105, 111, 110,   4,   4,  71,  69,  88,  80,  13,  13,  98,
108, 100,  95, 102,  97, 114, 114,  95, 116, 121, 112, 101,  10,  10,  99, 116,
101,  95, 115,  99,  97, 108,  97, 114,   9,   9,  99, 116, 101,  95,  97, 114,
114,  97, 121,   4,   4,  73,  78,  73,  86,  12,  12, 103, 101, 116,  95, 105,
110, 105, 116,  95, 118,  97, 108,  12,  12, 101, 120, 112,  95, 103, 101, 116,
107, 105, 110, 100, 115,   4,   4,  69,  88,  71,  75,  16,  16,  99, 104, 101,
 99, 107,  95, 108, 118,  97, 108, 117, 101,  95, 114, 101, 102,  14,  14,  32,
 76, 118,  97, 108, 117, 101,  32,  80,  79,  80,  32,  58,  32,  23,  23,  60,
 78, 111, 116,  32,  97,  32,  73, 100, 101, 110, 116, 105, 102, 105, 101, 114,
 32,  82, 101, 102,  46,  62,  25,  25,  60,  73, 100, 101, 110, 116, 105, 102,
105, 101, 114,  32,  87, 105, 116, 104, 111, 117, 116,  32,  78,  97, 109, 101,
 62,   4,   4,  69,  88,  82,  70,  13,  13, 103, 101, 116,  95, 101, 120, 112,
 95, 114, 101, 102, 101, 114,  13,  13, 101, 120, 116, 114,  97,  99, 116,  95,
118,  97, 108, 117, 101,  18,  18,  32,  68, 101,  98,  32,  69,  88,  84,  82,
 65,  67,  84,  32,  80,  79,  80,  32,  32,   4,   4,  69,  88,  86,  76,  11,
 11, 101, 120, 116, 114,  97,  99, 116,  95, 115, 116, 114,  11,  11, 101, 120,
116, 114,  97,  99, 116,  95, 105, 110, 116,  11,  11, 101, 120, 116, 114,  97,
 99, 116,  95, 102, 108, 116,  13,  13, 103, 101, 116,  95, 101, 120, 112,  95,
118,  97, 108, 117, 101,   4,   4,  71,  69,  86,  76,  11,  11, 103, 101, 116,
 95, 115, 116, 114, 101, 120, 112, 114,  11,  11, 103, 101, 116,  95, 105, 110,
116, 101, 120, 112, 114,  11,  11, 103, 101, 116,  95, 102, 108, 116, 101, 120,
112, 114,  11,  11, 103, 101, 116,  95, 110, 117, 109, 101, 120, 112, 114,  16,
 16,  99,  97, 108, 108,  95, 105, 102,  95, 102, 117, 110,  99, 116, 105, 111,
110,   4,   4,  73,  70,  78,  67,  16,  16,  97, 114, 114, 115,  99,  97,  95,
115, 115,  95,  97, 115, 115, 105, 103, 110,  16,  16,  97, 114, 114, 115,  99,
 97,  95, 105, 105,  95,  97, 115, 115, 105, 103, 110,  16,  16,  97, 114, 114,
115,  99,  97,  95, 102, 102,  95,  97, 115, 115, 105, 103, 110,  15,  15,  97,
114, 114,  97, 121,  95, 100, 101, 102,  95, 109,  97, 116,  99, 104,   4,   4,
 65,  82,  77,  65,  15,  15,  97, 114, 114,  97, 121,  95, 115, 115,  95,  97,
115, 115, 105, 103, 110,  15,  15,  97, 114, 114,  97, 121,  95, 105, 105,  95,
 97, 115, 115, 105, 103, 110,  15,  15,  97, 114, 114,  97, 121,  95, 102, 105,
 95,  97, 115, 115, 105, 103, 110,  15,  15,  97, 114, 114,  97, 121,  95, 105,
102,  95,  97, 115, 115, 105, 103, 110,  15,  15,  97, 114, 114,  97, 121,  95,
102, 102,  95,  97, 115, 115, 105, 103, 110,  11,  11, 105, 110,  95, 102, 105,
108, 101, 109, 111, 100, 101,  14,  14, 101, 120, 112,  95, 112, 117, 116,  95,
 98, 108, 116, 118,  97, 108,   4,   4,  66,  76,  86,  76,   9,   9, 101, 120,
112,  95, 101, 110, 116, 114, 121,   4,   4,  69,  88,  80,  69,  17,  17,  32,
 68, 101,  98,  32,  69, 110, 116, 114, 121,  32,  80, 117, 115, 104,  32,  32,
  9,   9, 101, 120, 112,  95, 105, 110, 100, 101, 120,   4,   4,  65,  82,  82,
 70,   9,   9, 101, 120, 112,  95, 102, 105, 101, 108, 100,   1,   1, 115,   4,
  4,  70,  73,  69,  76,   7,   7, 101, 120, 112,  95, 117, 110,  97,   4,   4,
 69,  88,  85,  78,   7,   7, 101, 120, 112,  95, 112, 111, 119,   7,   7, 101,
120, 112,  95, 109, 117, 108,   7,   7, 101, 120, 112,  95,  97, 100, 100,   7,
  7, 101, 120, 112,  95, 114, 101, 108,   7,   7, 101, 120, 112,  95, 110, 111,
116,   7,   7, 101, 120, 112,  95,  97, 110, 100,  10,  10, 101, 120, 112, 114,
101, 115, 115, 105, 111, 110,  16,  16,  32,  68, 101,  98,  32,  69, 120, 112,
114, 101, 115, 115, 105, 111, 110,  32,  15,  15, 101, 120, 112, 114, 101, 115,
115, 105, 111, 110,  95, 116, 121, 112, 101,   4,   4,  71,  69,  84,  89,  19,
 19, 103, 101, 116,  95, 116, 121, 112, 101,  95, 101, 120, 112, 114, 101, 115,
115, 105, 111, 110,   4,   4,  71,  84,  89,  69,  12,  12, 103, 101, 116,  95,
100, 105, 114,  95, 108,  97, 114, 103,   4,   4,  71,  68,  73,  65,  13,  13,
103, 101, 116,  95, 102, 108, 116,  95, 109, 101, 120, 112, 114,   4,   4,  77,
 70,  86,  76,  14,  14, 103, 101, 116,  95, 102, 108, 116,  95, 109, 118,  97,
108, 117, 101,   4,   4,  77,  70,  86,  65,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 480 ) = {
  0,   0,   0,   0, 255, 255, 255, 255,   2,   0,   0,   0,   0,   0,   0,   0,
  0,   2,   0,   2,   0,   0,   0,   0,   0,   2,   0,   2,   0,   0,   2,   0,
  0,   0,   0,   2,   0,   2,   0,   0,   0,   1,   0,   0,   0,   0,   2,   2,
  0,   0,   0,   0,   1,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   1,
  0,   0,   0,   2,  14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   4,   3, 110, 111, 116,   0,   4,   2,  42,  42,   0,   0,
  4,   1,  42,   0,   0,   0,   4,   1,  47,   0,   0,   0,   4,   3, 100, 105,
118,   0,   4,   3, 109, 111, 100,   0,   4,   3, 114, 101, 109,   0,   4,   1,
 43,   0,   0,   0,   4,   1,  45,   0,   0,   0,   4,   2, 124, 124,   0,   0,
  4,   1,  60,   0,   0,   0,   4,   2,  60,  61,   0,   0,   4,   2,  62,  61,
  0,   0,   4,   1,  62,   0,   0,   0,   4,   2,  60,  62,   0,   0,   4,   1,
 61,   0,   0,   0,   4,   3,  97, 110, 100,   0,   4,   2, 111, 114,   0,   0,
  4,   3, 120, 111, 114,   0,   4,   2,  58,  61,   0,   0,   4,   1,  59,   0,
  0,   0,   4,   1,  32,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 196608 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern Blk(V_exp_null, 48 );
extern UB V_exp_nva;
extern Blk(V_disp_tab, 1560 );
extern SL V_curr_idisp;
extern V V_str_typ;
extern V V_int_typ;
extern V V_flt_typ;
extern UB V_debug_exp;
extern V V_lst_current;
extern UB V_numerr_nstp;
extern SL V_numerr_cnt;
extern V V_pcd;
extern Blk(V_exp_res, 48 );
extern SL V_math_err;
extern Blk(V_sy_ident, 64 );
extern Blk(V_sy_sym, 8 );
extern UL V_ret_seq_incr;
extern UL V_ret_seq_count;
extern V V_ret_ide;
extern SL V_curr_disp;
extern V V_idm_actstk;
extern C V_sy_ch;
extern C V_sy_cmin;
extern Blk(V_mop_tab, 176 );
extern Blk(V_exp_rs0, 48 );
extern UB V_sy_nomacrflg;
extern V V_sy_macro;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
G P_math_bessel_j(SL F_rn, G F_rv);
G P_math_bessel_jh(G F_rn, G F_rv);
G P_math_interpol(V F_ftab, G F_xx);
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_display_new();
void P_display_free();
V P_typ_new(UB F_frm, V F_ide, V F_pty, SL F_ilvl);
V P_level_search(V F_fp);
V P_ide_search(UB F_berr, UB F_cls);
UB P_get_val_forms(V F_ty);
void P_val_allocate(V F_val, V F_typ);
void P_save_sym_cntx(UB F_svall);
void P_restore_sym_cntx();
void P_active_macro_code(V F_p, UB F_svall);
void P_ret_of_macro_code(V F_p);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol);
void P_exec_builtin(UB F_fnc, SL F_npa);
void P_extract_str(V F_rec, V F_st);
SL P_extract_int(V F_rec, SL F_iv);
G P_extract_flt(V F_rec, G F_rv);
void P_get_strexpr(V F_st);
SL P_get_intexpr(SL F_iv);
G P_get_fltexpr(G F_rv);
void P_get_exp_refer(V F_rec, V F_ide);
void P_get_expression(V F_rec);
void P_arrsca_ss_assign(V F_src, V F_dst);
void P_arrsca_ii_assign(SL F_vsrc, V F_dst);
void P_arrsca_ff_assign(G F_vval, G F_vsig, V F_dst);
void P_array_ss_assign(V F_src, V F_dst);
void P_array_ii_assign(V F_src, V F_dst);
void P_array_if_assign(V F_src, V F_dst);
void P_array_fi_assign(V F_src, V F_dst);
void P_array_ff_assign(V F_src, V F_dst);
void P_expression();
void P_fnc_select();
void P_fnc_integr();
void P_fnc_summation();
void P_fnc_summdata();
void P_statelist(UB F_stopper);
void P_out_retpar_def(V F_rec);
void P_out_pcd_vref(V F_exp, UB F_binv);
void P_out_item_fref(V F_exp, SL F_itmrcd, SL F_itmiid, SL F_offset);
void P_out_nd_code(UB F_nd);
void P_out_stm_code(UB F_stm);
void P_assign_specific(V F_rec);


/* Procedure/Function : " write_Object "  */
void Write_Flg_Rec(UL F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=132; /* line # 132 */
  PAS__WRITE_CHAR(91);
  Ra.sl[3]=133; /* line # 133 */
  Rv0=1;
  Ra.sl[3]=134; /* line # 134 */
  Rv1=0;
  for( Rf0=24;Rf0>0;Rf0-- ) {
    Ra.sl[3]=135; /* line # 135 */
    if (1<<Rv1&F_flg) {
      Ra.sl[3]=137; /* line # 137 */
      if (Rv0) Rv0=0;
      else {
        Ra.sl[3]=138; /* line # 138 */
        PAS__WRITE_CHAR(44);
      }
      Ra.sl[3]=139; /* line # 139 */
      PAS__WRITE_ENM(Rv1, Rd.s+72,0,-1,32);
    }
    Rv1++;
  }
  Ra.sl[3]=141; /* line # 141 */
  PAS__WRITE_CHAR(93);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_Object "  */
void Write_Exp_Rec(V F_exp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+365;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=151; /* line # 151 */
  Rv0=F_exp+24;
  Ra.sl[3]=153; /* line # 153 */
  PAS__WRITE_STR(Rd.s+379,-1,-1,32);
  PAS__WRITE_ENM(((UB *)Rv0)[1],Rd.s+392,0,-1,32);
  PAS__WRITE_STR(Rd.s+517,-1,-1,32);
  Ra.sl[3]=154; /* line # 154 */
  if (((V *)F_exp)[0]!=NULL) {
    Ra.sl[3]=155; /* line # 155 */
    PAS__WRITE_STR(Rd.s+524,-1,-1,32);
    if (((V *)((V *)F_exp)[0])[0]!=NULL) PAS__WRITE_STR(((V *)((V *)F_exp)[0])[0]
    ,-1,-1,32);
    PAS__WRITE_STR(Rd.s+532,-1,-1,32);
  }
  Ra.sl[3]=156; /* line # 156 */
  if (((V *)F_exp)[1]!=NULL) {
    Rv1=((V *)F_exp)[1];
    Ra.sl[3]=157; /* line # 157 */
    if (((V *)Rv1)[0]!=NULL) {
      PAS__WRITE_STR(Rd.s+536,-1,-1,32);
      PAS__WRITE_STR(((V *)((V *)Rv1)[0])[0],-1,-1,32);
    }
  }
  Ra.sl[3]=158; /* line # 158 */
  PAS__WRITE_STR(Rd.s+552,-1,-1,32);
  Ra.sl[3]=159; /* line # 159 */
  Write_Flg_Rec(((UL *)F_exp)[5]);
  Ra.sl[3]=160; /* line # 160 */
  PAS__WRITE_STR(Rd.s+565,-1,-1,32);
  Ra.sl[3]=161; /* line # 161 */
  switch (((UB *)Rv0)[1]) {
    case 0:Ra.sl[3]=162; /* line # 162 */
    if (((V *)Rv0)[1]!=NULL) {
      PAS__WRITE_CHAR(34);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      PAS__WRITE_CHAR(34);
    }
    else {
      Ra.sl[3]=163; /* line # 163 */
      PAS__WRITE_STR(Rd.s+570,-1,-1,32);
    }
    break;
    case 1:Ra.sl[3]=164; /* line # 164 */
    PAS__WRITE_INT(((SL *)Rv0)[1],0,0);
    break;
    case 2:Ra.sl[3]=165; /* line # 165 */
    PAS__WRITE_DBLE(((G *)Rv0)[1],12,6,0);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_display "  */
void P_type_display(V F_p, SL F_lvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  UB Rv2;
  V Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+587;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=180; /* line # 180 */
  if (F_p!=NULL) {
    Ra.sl[3]=181; /* line # 181 */
    Rv0=F_p;
    Ra.sl[3]=183; /* line # 183 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32, F_lvl*2,-1,1,32);
    PAS__WRITE_STR(Rd.s+601,-1,-1,32);
    Ra.sl[3]=184; /* line # 184 */
    if (((V *)Rv0)[0]!=NULL) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+621,-1,-1,32);
      PAS__WRITE_STR(((V *)((V *)Rv0)[0])[0],-1,-1,32);
      PAS__WRITE_CHAR(34);
    }
    Ra.sl[3]=185; /* line # 185 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+632,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv0)[3],0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=186; /* line # 186 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32, F_lvl*2,-1,1,32);
    PAS__WRITE_STR(Rd.s+647,-1,-1,32);
    Rv1=0;
    Ra.sl[3]=187; /* line # 187 */
    Rv2=0;
    for( Rf0=24;Rf0>0;Rf0-- ) {
      Ra.sl[3]=188; /* line # 188 */
      if (1<<Rv2&((UL *)Rv0)[5]) {
        Ra.sl[3]=190; /* line # 190 */
        if (Rv1) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHAR(44);
        }
        else Rv1=1;
        Ra.sl[3]=191; /* line # 191 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_ENM(Rv2, Rd.s+72,0,-1,32);
      }
      Rv2++;
    }
    Ra.sl[3]=193; /* line # 193 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+659,-1,-1,32);
    PAS__WRITE_ENM(((UB *)Rv0)[24],Rd.s+672,0,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=195; /* line # 195 */
    switch (((UB *)Rv0)[24]) {
      case 3:Ra.sl[3]=197; /* line # 197 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_FCHAR(32, F_lvl*2,-1,1,32);
      PAS__WRITE_STR(Rd.s+809,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[10],0,0);
      PAS__WRITE_STR(Rd.s+821,-1,-1,32);
      PAS__WRITE_INT((((SL *)Rv0)[9]-((SL *)Rv0)[10])+1,0,0);
      PAS__WRITE_STR(Rd.s+825,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[8],0,0);
      PAS__WRITE_STR(Rd.s+836,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=198; /* line # 198 */
      P_type_display(((V *)Rv0)[7],F_lvl+1);
      break;
      case 6:Ra.sl[3]=201; /* line # 201 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_FCHAR(32, F_lvl*2,-1,1,32);
      PAS__WRITE_STR(Rd.s+842,-1,-1,32);
      PAS__WRITE_INT(((UB *)Rv0)[53],0,0);
      PAS__WRITE_STR(Rd.s+860,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=202; /* line # 202 */
      Rv3=((V *)Rv0)[7];
      Ra.sl[3]=203; /* line # 203 */
      while (Rv3!=NULL){
        Ra.sl[3]=204; /* line # 204 */
        Rv4=Rv3;
        Ra.sl[3]=206; /* line # 206 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_FCHAR(32, F_lvl*2,-1,1,32);
        PAS__WRITE_STR(Rd.s+865,-1,-1,32);
        PAS__WRITE_STR(((V *)Rv4)[0],-1,-1,32);
        PAS__WRITE_STR(Rd.s+875,-1,-1,32);
        PAS__WRITE_INT(((SL *)Rv4)[8],0,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=207; /* line # 207 */
        P_type_display(((V *)Rv4)[4],F_lvl+2);
        Ra.sl[3]=208; /* line # 208 */
        Rv3=((V *)Rv4)[1];
      }
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exprv_remove "  */
void P_exprv_remove(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+884;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=221; /* line # 221 */
  Rv0=F_rec+24;
  Ra.sl[3]=223; /* line # 223 */
  if (((V *)F_rec)[0]==NULL) {
    Ra.sl[3]=224; /* line # 224 */
    switch (((UB *)Rv0)[1]) {
      case 0:Ra.sl[3]=225; /* line # 225 */
      if (((V *)Rv0)[1]!=NULL) {
        PAS__DISPOSE(((V *)Rv0)+1);
        ((V *)Rv0)[1]=NULL;
      }
      break;
      case 6:Ra.sl[3]=226; /* line # 226 */
      if (((V *)Rv0)[1]!=NULL) {
        Ra.sl[3]=228; /* line # 228 */
        Rv1=1;
        for( Rf0=((SL *)((V *)Rv0)[1])[0];Rf0>0;Rf0-- ) {
          PAS__DISPOSE((((V *)((V *)Rv0)[1])+Rv1));
          Rv1++;
        }
        Ra.sl[3]=229; /* line # 229 */
        PAS__DISPOSE(((V *)Rv0)+1);
        Ra.sl[3]=230; /* line # 230 */
        ((V *)Rv0)[1]=NULL;
      }
      break;
      case 7:Ra.sl[3]=232; /* line # 232 */
      if (((V *)Rv0)[1]!=NULL) {
        PAS__DISPOSE(((V *)Rv0)+1);
        ((V *)Rv0)[1]=NULL;
      }
      break;
      case 8:Ra.sl[3]=233; /* line # 233 */
      if (((V *)Rv0)[1]!=NULL) {
        Ra.sl[3]=235; /* line # 235 */
        PAS__DISPOSE(((V *)Rv0)+1);
        ((V *)Rv0)[1]=NULL;
        Ra.sl[3]=236; /* line # 236 */
        if (((V *)Rv0)[2]!=NULL) {
          PAS__DISPOSE(((V *)Rv0)+2);
          ((V *)Rv0)[2]=NULL;
        }
      }
      break;
      default:break;
    }
  }
  Ra.sl[3]=240; /* line # 240 */
  ((UB *)Rv0)[0]=0;
  Ra.sl[3]=241; /* line # 241 */
  ((UB *)Rv0)[1]=11;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop_expression "  */
void P_pop_expression(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+898;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=254; /* line # 254 */
  if (Ri.sl[0]>0) {
    Ra.sl[3]=256; /* line # 256 */
    P_exprv_remove(F_rec);
    Ra.sl[3]=257; /* line # 257 */
    memcpy(F_rec,(Rs.s+Ri.sl[0]*48-48),48);
    Ra.sl[3]=259; /* line # 259 */
    Ri.sl[0]=Ri.sl[0]-1;
  }
  else {
    Ra.sl[3]=263; /* line # 263 */
    P_src_error(Rd.s+916,7,3);
    Ra.sl[3]=264; /* line # 264 */
    ((UB *)F_rec)[24]=0;
    Ra.sl[3]=265; /* line # 265 */
    ((UB *)F_rec)[25]=11;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " push_expression "  */
void P_push_expression(V F_exp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+920;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=277; /* line # 277 */
  if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
  else {
    Ra.sl[3]=278; /* line # 278 */
    P_src_error(Rd.s+939,6,3);
  }
  Ra.sl[3]=279; /* line # 279 */
  memcpy((Rs.s+Ri.sl[0]*48-48),F_exp,48);
  Ra.sl[3]=280; /* line # 280 */
  memcpy(F_exp,V_exp_null.s,48);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_put_value "  */
void MXD_DCPEXPR_PRC_00000000(V F_val, V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=296; /* line # 296 */
  Rv0=F_ip;
  Rv1=(Rs.s+Ri.sl[0]*48-48);
  Ra.sl[3]=298; /* line # 298 */
  ((V *)Rv1)[0]=F_ip;
  Ra.sl[3]=299; /* line # 299 */
  ((V *)Rv1)[1]=((V *)Rv0)[4];
  Ra.sl[3]=300; /* line # 300 */
  ((UL *)Rv1)[5]=((UL *)Rv0)[5];
  Ra.sl[3]=301; /* line # 301 */
  ((SL *)Rv1)[2]=0;
  Ra.sl[3]=302; /* line # 302 */
  ((SL *)Rv1)[4]=0;
  Ra.sl[3]=303; /* line # 303 */
  ((SL *)Rv1)[3]=1;
  Ra.sl[3]=304; /* line # 304 */
  if (((V *)Rv1)[1]!=NULL) {
    Ra.sl[3]=305; /* line # 305 */
    Rv2=((V *)Rv1)[1];
    Ra.sl[3]=306; /* line # 306 */
    if (((UB *)Rv2)[24]==3) ((SL *)Rv1)[3]=((SL *)Rv2)[8]*((SL *)Rv2)[9];
  }
  Ra.sl[3]=307; /* line # 307 */
  ((UB *)Rv1)[24]=0;
  Ra.sl[3]=308; /* line # 308 */
  ((UB *)Rv1)[25]=((UB *)F_val)[1];
  Ra.sl[3]=309; /* line # 309 */
  switch (((UB *)F_val)[1]) {
    case 0:Ra.sl[3]=310; /* line # 310 */
    ((V *)Rv1)[7]=((V *)F_val)[1];
    break;
    case 1:Ra.sl[3]=311; /* line # 311 */
    ((SL *)Rv1)[7]=((SL *)F_val)[1];
    break;
    case 2:Ra.sl[3]=313; /* line # 313 */
    ((G *)Rv1)[4]=((G *)F_val)[1];
    Ra.sl[3]=314; /* line # 314 */
    if (16&((UL *)Rv1)[5]) ((G *)Rv1)[5]=((G *)F_val)[2];
    else {
      Ra.sl[3]=315; /* line # 315 */
      ((G *)Rv1)[5]=0.000000000000000E-001;
    }
    Ra.sl[3]=316; /* line # 316 */
    if (131072&((UL *)Rv1)[5]) {
      Ra.sl[3]=318; /* line # 318 */
      ((SL *)Rv1)[2]=((SL *)Rv0)[8];
      Ra.sl[3]=319; /* line # 319 */
      if (V_exp_nva) P_out_pcd_vref((Rs.s+Ri.sl[0]*48-48),0);
    }
    break;
    case 6:Ra.sl[3]=323; /* line # 323 */
    if (((V *)F_val)[1]==NULL) P_src_error(Rd.s+960,801,3);
    Ra.sl[3]=324; /* line # 324 */
    ((V *)Rv1)[7]=((V *)F_val)[1];
    break;
    case 7:Ra.sl[3]=327; /* line # 327 */
    if (((V *)F_val)[1]==NULL) P_src_error(Rd.s+960,802,3);
    Ra.sl[3]=328; /* line # 328 */
    ((V *)Rv1)[7]=((V *)F_val)[1];
    break;
    case 8:Ra.sl[3]=331; /* line # 331 */
    if (((V *)F_val)[1]==NULL) P_src_error(Rd.s+960,803,3);
    Ra.sl[3]=332; /* line # 332 */
    ((V *)Rv1)[7]=((V *)F_val)[1];
    Ra.sl[3]=333; /* line # 333 */
    if (16&((UL *)Rv1)[5]) ((V *)Rv1)[8]=((V *)F_val)[2];
    else {
      Ra.sl[3]=334; /* line # 334 */
      ((V *)Rv1)[8]=NULL;
    }
    Ra.sl[3]=335; /* line # 335 */
    if ((393216&((UL *)Rv1)[5])!=0) ((SL *)Rv1)[2]=((SL *)Rv0)[8];
    break;
    case 9:Ra.sl[3]=338; /* line # 338 */
    ((V *)Rv1)[7]=((V *)F_val)[1];
    Ra.sl[3]=339; /* line # 339 */
    ((UL *)Rv1)[5]=((UL *)Rv1)[5]|65536;
    Ra.sl[3]=340; /* line # 340 */
    if (((V *)F_val)[1]!=NULL) ((SL *)Rv1)[2]=((SL *)((V *)F_val)[1])[11];
    else {
      Ra.sl[3]=342; /* line # 342 */
      if (131072&((UL *)Rv1)[5]&&((SL *)Rv0)[8]>0) {
        Ra.sl[3]=343; /* line # 343 */
        ((SL *)Rv1)[2]= -((SL *)Rv0)[8];
      }
      else {
        Ra.sl[3]=346; /* line # 346 */
        P_src_error_s(Rd.s+960,277,2,((V *)Rv0)[0],NULL);
        Ra.sl[3]=347; /* line # 347 */
        ((UB *)Rv1)[25]=1;
        ((SL *)Rv1)[7]=0;
      }
    }
    break;
    case 11:Ra.sl[3]=350; /* line # 350 */
    ((UB *)Rv1)[25]=1;
    ((SL *)Rv1)[7]=0;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_put_refer "  */
void MXD_DCPEXPR_exp_put_refer(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+964;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=358; /* line # 358 */
  if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
  else {
    Ra.sl[3]=359; /* line # 359 */
    P_src_error(Rd.s+981,6,3);
  }
  Ra.sl[3]=360; /* line # 360 */
  memcpy((Rs.s+Ri.sl[0]*48-48),V_exp_null.s,48);
  Ra.sl[3]=362; /* line # 362 */
  if (F_ip!=NULL) {
    Ra.sl[3]=363; /* line # 363 */
    Rv0=F_ip;
    Ra.sl[3]=365; /* line # 365 */
    switch (((UB *)Rv0)[25]) {
      case 3:Ra.sl[3]=366; /* line # 366 */
      MXD_DCPEXPR_PRC_00000000((((S *)((V *)V_disp_tab.v[V_curr_idisp*6+1])[11])
      +((SL *)Rv0)[8]*24+24),F_ip);
      break;
      case 2:Ra.sl[3]=367; /* line # 367 */
      MXD_DCPEXPR_PRC_00000000(V_disp_tab.v[V_curr_idisp*6+1]+40,F_ip);
      break;
      case 1:Ra.sl[3]=368; /* line # 368 */
      MXD_DCPEXPR_PRC_00000000(Rv0+40,F_ip);
      break;
      default:break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_stk_copy "  */
void P_exp_stk_copy(SL F_lvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+985;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=383; /* line # 383 */
  if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
  else {
    Ra.sl[3]=384; /* line # 384 */
    P_src_error(Rd.s+1001,6,3);
  }
  Ra.sl[3]=385; /* line # 385 */
  memcpy((Rs.s+Ri.sl[0]*48-48),(Rs.s+(Ri.sl[1]-F_lvl)*48-48),48);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_get_copy "  */
void P_exp_get_copy(V F_rec, SL F_lvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1005;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=393; /* line # 393 */
  memcpy(F_rec,(Rs.s+(Ri.sl[1]-F_lvl)*48-48),48);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_put_formal "  */
void MXD_DCPEXPR_exp_put_formal(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1019;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=403; /* line # 403 */
  P_exp_stk_copy(((SL *)F_ip)[7]);
  Ra.sl[3]=404; /* line # 404 */
  Rs.v[Ri.sl[0]*12-12]=F_ip;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_putvalue "  */
void MXD_DCPEXPR_exp_putvalue(V F_typ, SL F_iv, G F_rv, G F_sg, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register UB Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1035;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=418; /* line # 418 */
  if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
  else {
    Ra.sl[3]=419; /* line # 419 */
    P_src_error(Rd.s+1051,6,3);
  }
  Ra.sl[3]=420; /* line # 420 */
  Rv0=(Rs.s+Ri.sl[0]*48-48);
  Rv1=Rv0+24;
  Ra.sl[3]=422; /* line # 422 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[3]=423; /* line # 423 */
  ((V *)Rv0)[1]=F_typ;
  Ra.sl[3]=424; /* line # 424 */
  ((SL *)Rv0)[2]=0;
  Ra.sl[3]=425; /* line # 425 */
  ((SL *)Rv0)[3]=1;
  Ra.sl[3]=426; /* line # 426 */
  ((SL *)Rv0)[4]=0;
  Ra.sl[3]=427; /* line # 427 */
  ((UB *)Rv1)[1]=P_get_val_forms(F_typ);
  Ra.sl[3]=428; /* line # 428 */
  ((UL *)Rv0)[5]=0;
  Ra.sl[3]=429; /* line # 429 */
  ((UB *)Rv1)[0]=0;
  Ra.sl[3]=430; /* line # 430 */
  switch (((UB *)Rv1)[1]) {
    case 0:Ra.sl[3]=432; /* line # 432 */
    if (F_st!=NULL) {
      Ra.sl[3]=433; /* line # 433 */
      if (((UB *)F_st)[1]>0) {
        Ra.sl[3]=434; /* line # 434 */
        Rv2=((UB *)F_st)[1];
        ((V *)Rv1)[1]=PAS__NEW((SL)Rv2+2);
        ((UB *)((V *)Rv1)[1])[0]=Rv2;
        PAS__STR_TO_STR(((V *)Rv1)[1],F_st);
      }
      else {
        Ra.sl[3]=435; /* line # 435 */
        ((V *)Rv1)[1]=NULL;
      }
    }
    else {
      Ra.sl[3]=436; /* line # 436 */
      ((V *)Rv1)[1]=NULL;
    }
    Ra.sl[3]=437; /* line # 437 */
    ((V *)Rv0)[1]=V_str_typ;
    break;
    case 1:Ra.sl[3]=439; /* line # 439 */
    ((SL *)Rv1)[1]=F_iv;
    ((V *)Rv0)[1]=V_int_typ;
    break;
    case 2:Ra.sl[3]=440; /* line # 440 */
    ((G *)Rv1)[1]=F_rv;
    ((G *)Rv1)[2]=F_sg;
    ((V *)Rv0)[1]=V_flt_typ;
    break;
    default:break;
  }
  Ra.sl[3]=443; /* line # 443 */
  if (V_debug_exp) {
    PAS__SELECT_OUT(((V *)V_lst_current)[13]);
    PAS__WRITE_STR(Rd.s+1055,-1,-1,32);
    Write_Exp_Rec((Rs.s+Ri.sl[0]*48-48));
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_putstr "  */
void P_exp_putstr(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1067;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=453; /* line # 453 */
  MXD_DCPEXPR_exp_putvalue(V_str_typ,0,0.000000E-01,0.000000E-01, F_st);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_putint "  */
void P_exp_putint(SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1079;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=462; /* line # 462 */
  MXD_DCPEXPR_exp_putvalue(V_int_typ, F_iv,0.000000E-01,0.000000E-01,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_putflt "  */
void P_exp_putflt(G F_rv, G F_sg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1091;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=471; /* line # 471 */
  MXD_DCPEXPR_exp_putvalue(V_flt_typ,0, F_rv, F_sg,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " stack_remove "  */
void MXD_DCPEXPR_stack_remove(SL F_np){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1103;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=480; /* line # 480 */
  while (F_np>0){
    Ra.sl[3]=482; /* line # 482 */
    P_exprv_remove((Rs.s+Ri.sl[0]*48-48));
    Ra.sl[3]=483; /* line # 483 */
    Ri.sl[0]=Ri.sl[0]-1;
    Ra.sl[3]=484; /* line # 484 */
    F_np=F_np-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " comp_type_stk "  */
UB MXD_DCPEXPR_comp_type_stk(SL F_np, V F_fty, UB F_brf, UB F_bdf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  register V Rv3;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1117;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=511; /* line # 511 */
  if (F_fty!=NULL) {
    Ra.sl[3]=513; /* line # 513 */
    Rv0=Rs.v[(Ri.sl[0]-F_np)*12-11];
    Ra.sl[3]=514; /* line # 514 */
    if (Rv0!=NULL) {
      Ra.sl[3]=516; /* line # 516 */
      Rv1=Rv0;
      Ra.sl[3]=517; /* line # 517 */
      while (Rv1!=F_fty&&Rv1!=NULL)
      Rv1=((V *)Rv1)[2];
      Ra.sl[3]=518; /* line # 518 */
      if (!F_brf) {
        Ra.sl[3]=520; /* line # 520 */
        if (Rv1==NULL) {
          Ra.sl[3]=521; /* line # 521 */
          switch (Ri.ub[((UB *)Rv0)[24]*10+((UB *)F_fty)[24]+8]) {
            case 0:Ra.sl[3]=522; /* line # 522 */
            Rv2=0;
            break;
            case 2:Ra.sl[3]=523; /* line # 523 */
            Rv2=1;
            break;
            default:Ra.sl[3]=525; /* line # 525 */
            switch (((UB *)F_fty)[24]) {
              case 3:Ra.sl[3]=527; /* line # 527 */
              Rv3=F_fty;
              Ra.sl[3]=528; /* line # 528 */
              if (1024&((UL *)Rv3)[5]&&((V *)Rv0)[7]==((V *)Rv3)[7]) {
                Ra.sl[3]=529; /* line # 529 */
                if (((SL *)Rv3)[10]==2147483647) Rv2=1;
                else {
                  Ra.sl[3]=530; /* line # 530 */
                  Rv2=((SL *)Rv0)[10]==((SL *)Rv3)[10];
                }
              }
              else {
                Ra.sl[3]=531; /* line # 531 */
                Rv2=0;
              }
              break;
              default:Ra.sl[3]=533; /* line # 533 */
              Rv2=0;
              break;
            }
            break;
          }
        }
        else {
          Ra.sl[3]=536; /* line # 536 */
          Rv2=1;
        }
      }
      else {
        Ra.sl[3]=537; /* line # 537 */
        Rv2=Rv1==F_fty;
      }
    }
    else {
      Ra.sl[3]=539; /* line # 539 */
      Rv2=F_bdf;
    }
  }
  else {
    Ra.sl[3]=541; /* line # 541 */
    Rv2=1;
  }
  Ra.sl[3]=542; /* line # 542 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " generic_search "  */
V MXD_DCPEXPR_generic_search(V F_ent, SL F_npa){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1132;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=561; /* line # 561 */
  Rv0=0;
  Ra.sl[3]=562; /* line # 562 */
  if (F_ent!=NULL) while (1){
    Ra.sl[3]=564; /* line # 564 */
    Rv1=F_ent;
    Ra.sl[3]=566; /* line # 566 */
    switch (((UB *)Rv1)[12]) {
      case 0:Ra.sl[3]=568; /* line # 568 */
      if (F_npa<=2) {
        Ra.sl[3]=576; /* line # 576 */
        switch (F_npa) {
          case 0:Ra.sl[3]=577; /* line # 577 */
          Rv0=((V *)Rv1)[4]==NULL&&((V *)Rv1)[5]==NULL;
          break;
          case 1:Ra.sl[3]=578; /* line # 578 */
          Rv0=MXD_DCPEXPR_comp_type_stk(0,((V *)Rv1)[4],0,0)&&((V *)Rv1)[5]==NULL;
          break;
          case 2:Ra.sl[3]=579; /* line # 579 */
          Rv0=MXD_DCPEXPR_comp_type_stk(1,((V *)Rv1)[4],0,0)&&MXD_DCPEXPR_comp_type_stk(0,(
          (V *)Rv1)[5],0,0);
          break;
        }
      }
      break;
      case 1:Ra.sl[3]=605; /* line # 605 */
      if (F_npa==((UB *)Rv1)[13]) {
        Ra.sl[3]=607; /* line # 607 */
        Rv2=((V *)Rv1)[4];
        Ra.sl[3]=608; /* line # 608 */
        Rv3=F_npa-1;
        Ra.sl[3]=609; /* line # 609 */
        Rv0=1;
        Ra.sl[3]=610; /* line # 610 */
        while ((Rv0&&Rv2!=NULL)&&Rv3>=0){
          Ra.sl[3]=611; /* line # 611 */
          Rv4=Rv2;
          Ra.sl[3]=613; /* line # 613 */
          Rv0=MXD_DCPEXPR_comp_type_stk(Rv3,((V *)Rv4)[4],((UB *)Rv4)[33],((UB *)
          Rv4)[32]);
          Ra.sl[3]=614; /* line # 614 */
          Rv3=Rv3-1;
          Ra.sl[3]=615; /* line # 615 */
          Rv2=((V *)Rv4)[1];
        }
      }
      else {
        Ra.sl[3]=618; /* line # 618 */
        Rv0=0;
      }
      break;
      case 2:Ra.sl[3]=624; /* line # 624 */
      Rv0=1;
      break;
    }
    Ra.sl[3]=627; /* line # 627 */
    if (!Rv0) F_ent=((V *)Rv1)[1];
    if (Rv0||F_ent==NULL)  break;
  }
  Ra.sl[3]=630; /* line # 630 */
  Ret=F_ent;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rd_err_trap "  */
SL MXD_DCPEXPR_PRC_00000001(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1148;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=645; /* line # 645 */
  if (F_ierr==51) {
    Ra.sl[3]=647; /* line # 647 */
    Lx[0].g[0]=0.000000000000000E-001;
    Ra.sl[3]=648; /* line # 648 */
    siglongjmp((void *)Lx[0].v[6],1);
  }
  else {
    Ra.sl[3]=650; /* line # 650 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " string_to_number "  */
G MXD_DCPEXPR_string_to_number(V *F_st, UB F_bfree){
  sigjmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 28 );

  register G Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[6]=(V)L_lb_env;
  if (sigsetjmp(L_lb_env, 1 )) goto L_l_0;

  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[3]=Rd.s+1161;
  Ra.v[4]=Rd.s+14;
  Ra.sl[5]=654; /* line # 654 */
  PAS__ESTABLISH(MXD_DCPEXPR_PRC_00000001);
  Ra.sl[5]=655; /* line # 655 */
  PAS__VREAD_INIT((*F_st)+2,(SL)((UB *)(*F_st))[1],NULL);
  PAS__READ_DBLE(Ra.g,0);
  PAS__READ_EOLN();
  PAS__curr_cntx=Ra.s+8;
L_l_0:
  Ra.sl[5]=657; /* line # 657 */
  PAS__REVERT();
  Ra.sl[5]=658; /* line # 658 */
  if (F_bfree) {
    Ra.sl[5]=659; /* line # 659 */
    PAS__DISPOSE(F_st);
    (*F_st)=NULL;
  }
  Ra.sl[5]=660; /* line # 660 */
  Ret=Ra.g[0];
  PAS__curr_cntx=Ra.v[2];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " number_to_string "  */
V MXD_DCPEXPR_number_to_string(G F_rv, SL F_fl, SL F_dc){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register UB Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+1179;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=672; /* line # 672 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_rv, F_fl, F_dc,0);
  PAS__WRITE_EOLN();
  Ra.sl[12]=673; /* line # 673 */
  if (Ra.ub[1]>0) {
    Ra.sl[12]=675; /* line # 675 */
    Rv0=Ra.ub[1];
    Rv1=PAS__NEW((SL)Rv0+2);
    ((UB *)Rv1)[0]=Rv0;
    Ra.sl[12]=676; /* line # 676 */
    PAS__STR_TO_STR(Rv1,Ra.s);
  }
  else {
    Ra.sl[12]=677; /* line # 677 */
    Rv1=NULL;
  }
  Ra.sl[12]=678; /* line # 678 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[9];
  return(Ret);
}


/* Procedure/Function : " string_concate "  */
void MXD_DCPEXPR_string_concate(V *F_st1, V *F_st2, UB F_bf1, UB F_bf2){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  register UB Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+1197;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=689; /* line # 689 */
  if ((*F_st1)!=NULL&&(*F_st2)!=NULL) {
    Ra.sl[68]=691; /* line # 691 */
    PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,(*F_st1),(*F_st2)));
    Ra.sl[68]=692; /* line # 692 */
    if (F_bf1) PAS__DISPOSE(F_st1);
    Ra.sl[68]=693; /* line # 693 */
    if (F_bf2) {
      PAS__DISPOSE(F_st2);
      (*F_st2)=NULL;
    }
    Ra.sl[68]=694; /* line # 694 */
    Rv0=Ra.ub[1];
    (*F_st1)=PAS__NEW((SL)Rv0+2);
    ((UB *)(*F_st1))[0]=Rv0;
    PAS__STR_TO_STR((*F_st1),Ra.s);
  }
  else {
    Ra.sl[68]=697; /* line # 697 */
    if ((*F_st1)==NULL) {
      Ra.sl[68]=698; /* line # 698 */
      if (F_bf2) {
        Ra.sl[68]=699; /* line # 699 */
        (*F_st1)=(*F_st2);
        (*F_st2)=NULL;
      }
      else {
        Ra.sl[68]=701; /* line # 701 */
        Rv1=((UB *)(*F_st2))[1];
        (*F_st1)=PAS__NEW((SL)Rv1+2);
        ((UB *)(*F_st1))[0]=Rv1;
        PAS__STR_TO_STR((*F_st1),(*F_st2));
      }
    }
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " string_compare "  */
SL MXD_DCPEXPR_string_compare(V *F_st1, V *F_st2, UB F_bf1, UB F_bf2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1213;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=712; /* line # 712 */
  if ((*F_st1)!=NULL&&(*F_st2)!=NULL) {
    Ra.sl[3]=714; /* line # 714 */
    Rv0=PAS__MATCH_STR((*F_st1),(*F_st2));
    Ra.sl[3]=715; /* line # 715 */
    if (F_bf1) PAS__DISPOSE(F_st1);
    (*F_st1)=NULL;
    Ra.sl[3]=716; /* line # 716 */
    if (F_bf2) PAS__DISPOSE(F_st2);
    (*F_st2)=NULL;
  }
  else {
    Ra.sl[3]=719; /* line # 719 */
    if ((*F_st1)==NULL&&(*F_st2)==NULL) Rv0=0;
    else {
      Ra.sl[3]=721; /* line # 721 */
      if ((*F_st1)==NULL) {
        Ra.sl[3]=723; /* line # 723 */
        if (((UB *)(*F_st2))[1]==0) Rv0=0;
        else {
          Ra.sl[3]=724; /* line # 724 */
          Rv0=-1;
        }
        Ra.sl[3]=725; /* line # 725 */
        if (F_bf2) PAS__DISPOSE(F_st2);
        (*F_st2)=NULL;
      }
      else {
        Ra.sl[3]=729; /* line # 729 */
        if (((UB *)(*F_st1))[1]==0) Rv0=0;
        else {
          Ra.sl[3]=730; /* line # 730 */
          Rv0=1;
        }
        Ra.sl[3]=731; /* line # 731 */
        if (F_bf1) PAS__DISPOSE(F_st1);
        (*F_st1)=NULL;
      }
    }
  }
  Ra.sl[3]=733; /* line # 733 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " arguments_setting "  */
UL MXD_DCPEXPR_arguments_setting(SL F_npa, V F_arg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UL Rv0;
  SL Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  UB Rv5;
  G Rv6;
  register UL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1229;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=747; /* line # 747 */
  Rv0=0;
  Ra.sl[3]=748; /* line # 748 */
  Rv1=(Ri.sl[0]-F_npa)+1;
  Ra.sl[3]=749; /* line # 749 */
  while (Rv1<=Ri.sl[0]){
    Ra.sl[3]=750; /* line # 750 */
    Rv2=(Rs.s+Rv1*48-48);
    Rv3=Rv2+24;
    Ra.sl[3]=755; /* line # 755 */
    Rv0=Rv0|((UL *)Rv2)[5]&393216;
    Ra.sl[3]=756; /* line # 756 */
    Rv4=((SL *)Rv2)[4]+1;
    Ra.sl[3]=757; /* line # 757 */
    if (F_arg!=NULL) {
      Rv5=((UB *)F_arg)[33];
      F_arg=((V *)F_arg)[1];
    }
    else {
      Ra.sl[3]=758; /* line # 758 */
      Rv5=0;
    }
    Ra.sl[3]=760; /* line # 760 */
    if (!Rv5) {
      Ra.sl[3]=761; /* line # 761 */
      switch (((UB *)Rv3)[1]) {
        case 3:Ra.sl[3]=764; /* line # 764 */
        if (((V *)Rv3)[1]!=NULL) ((V *)Rv3)[1]=((V *)((V *)Rv3)[1])[Rv4];
        else {
          Ra.sl[3]=765; /* line # 765 */
          ((V *)Rv3)[1]=NULL;
        }
        Ra.sl[3]=766; /* line # 766 */
        ((UB *)Rv3)[1]=0;
        break;
        case 4:Ra.sl[3]=771; /* line # 771 */
        if (((V *)Rv3)[1]!=NULL) ((SL *)Rv3)[1]=((SL *)((V *)Rv3)[1])[Rv4];
        else {
          Ra.sl[3]=772; /* line # 772 */
          ((SL *)Rv3)[1]=0;
        }
        Ra.sl[3]=773; /* line # 773 */
        ((UB *)Rv3)[1]=1;
        break;
        case 5:Ra.sl[3]=778; /* line # 778 */
        if (((V *)Rv3)[1]!=NULL) {
          Ra.sl[3]=780; /* line # 780 */
          Rv6=((G *)((V *)Rv3)[1])[Rv4];
          Ra.sl[3]=781; /* line # 781 */
          if (((V *)Rv3)[2]!=NULL) ((G *)Rv3)[2]=((G *)((V *)Rv3)[2])[Rv4];
          else {
            Ra.sl[3]=782; /* line # 782 */
            ((G *)Rv3)[2]=0.000000000000000E-001;
          }
          Ra.sl[3]=783; /* line # 783 */
          ((G *)Rv3)[1]=Rv6;
        }
        else {
          Ra.sl[3]=786; /* line # 786 */
          ((G *)Rv3)[1]=0.000000000000000E-001;
          ((G *)Rv3)[2]=0.000000000000000E-001;
        }
        Ra.sl[3]=787; /* line # 787 */
        ((UB *)Rv3)[1]=2;
        break;
        default:break;
      }
    }
    Ra.sl[3]=792; /* line # 792 */
    Rv1=Rv1+1;
  }
  Ra.sl[3]=794; /* line # 794 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " numerr_manager "  */
void P_numerr_manager(SL F_ierr, V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1248;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=808; /* line # 808 */
  Rv0=F_ent;
  Rv1=(Rs.s+Ri.sl[0]*48-48);
  Rv2=Rv1+24;
  Ra.sl[3]=810; /* line # 810 */
  if (!V_numerr_nstp) {
    Ra.sl[3]=812; /* line # 812 */
    PAS__VWRITE_INIT(Ri.s+68,1);
    PAS__WRITE_ENM(((UB *)Rv0)[32],Rd.s+1264,0,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=813; /* line # 813 */
    P_src_error_s(Rd.s+2194,48,2, Ri.s+68,NULL);
  }
  else {
    Ra.sl[3]=815; /* line # 815 */
    V_numerr_cnt=V_numerr_cnt+1;
  }
  Ra.sl[3]=817; /* line # 817 */
  ((UB *)Rv2)[1]=P_get_val_forms(((V *)Rv0)[2]);
  Ra.sl[3]=818; /* line # 818 */
  switch (((UB *)Rv2)[1]) {
    case 1:Ra.sl[3]=819; /* line # 819 */
    ((SL *)Rv2)[1]=1;
    break;
    case 2:Ra.sl[3]=820; /* line # 820 */
    ((G *)Rv2)[1]=1.000000000000000E+000;
    break;
    case 0:Ra.sl[3]=821; /* line # 821 */
    ((V *)Rv2)[1]=NULL;
    break;
    default:Ra.sl[3]=823; /* line # 823 */
    ((UB *)Rv2)[1]=11;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " err_handler "  */
SL MXD_DCPEXPR_PRC_00000002(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2198;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=844; /* line # 844 */
  if (F_ierr>=20&&F_ierr<=29) {
    Lx[1].sl[0]=F_ierr;
    siglongjmp((void *)Lx[1].v[6],1);
  }
  else {
    Ra.sl[3]=845; /* line # 845 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exe_val_una "  */
void MXD_DCPEXPR_exe_val_una(V F_ent, UB F_bprv){
  sigjmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 28 );

  /* Local variable stored in C variable */
  UL Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register G Rgg;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[6]=(V)L_lb_env;
  if (sigsetjmp(L_lb_env, 1 )) goto L_l_0;

  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+2211;
  Ra.v[3]=Rd.s+14;
  Ra.sl[4]=850; /* line # 850 */
  Rv0=MXD_DCPEXPR_arguments_setting(1,NULL);
  Ra.sl[4]=851; /* line # 851 */
  PAS__ESTABLISH(MXD_DCPEXPR_PRC_00000002);
  Ra.sl[4]=852; /* line # 852 */
  Rv1=F_ent;
  Rv2=(Rs.s+Ri.sl[0]*48-48);
  Rv3=Rv2+24;
  Ra.sl[4]=854; /* line # 854 */
  if (((V *)Rv1)[6]!=NULL) MXD_DCPEXPR_exe_val_una(((V *)Rv1)[6],0);
  Ra.sl[4]=855; /* line # 855 */
  if (262144&((UL *)Rv2)[5]) {
    Ra.sl[4]=858; /* line # 858 */
    if (F_bprv) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(19,4,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[4]=859; /* line # 859 */
    P_out_stm_code(((UB *)Rv1)[32]);
    Ra.sl[4]=860; /* line # 860 */
    if (F_bprv) {
      PAS__SELECT_OUT(V_pcd);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(19,4,0);
      PAS__WRITE_EOLN();
    }
  }
  else {
    Ra.sl[4]=868; /* line # 868 */
    switch (((UB *)Rv1)[32]) {
      case 63:Ra.sl[4]=870; /* line # 870 */
      ((SL *)Rv3)[1]=PAS__G_ROUND(MXD_DCPEXPR_string_to_number(((V *)Rv3)+1,((V *)
      Rv2)[0]==NULL));
      break;
      case 64:Ra.sl[4]=871; /* line # 871 */
      ((G *)Rv3)[1]=(double)PAS__G_ROUND(MXD_DCPEXPR_string_to_number(((V *)Rv3)
      +1,((V *)Rv2)[0]==NULL));
      ((G *)Rv3)[2]=0.000000000000000E-001;
      break;
      case 65:Ra.sl[4]=872; /* line # 872 */
      ((V *)Rv3)[1]=MXD_DCPEXPR_number_to_string((double)((SL *)Rv3)[1],0,0);
      break;
      case 66:Ra.sl[4]=873; /* line # 873 */
      ((G *)Rv3)[1]=(double)((SL *)Rv3)[1];
      break;
      case 67:Ra.sl[4]=874; /* line # 874 */
      ((V *)Rv3)[1]=MXD_DCPEXPR_number_to_string(((G *)Rv3)[1],0,0);
      break;
      case 68:Ra.sl[4]=875; /* line # 875 */
      ((SL *)Rv3)[1]=(int)(((G *)Rv3)[1]);
      break;
      case 69:Ra.sl[4]=876; /* line # 876 */
      ((SL *)Rv3)[1]=PAS__G_ROUND(((G *)Rv3)[1]);
      break;
      case 0:Ra.sl[4]=878; /* line # 878 */
      if (((SL *)Rv3)[1]!=0) ((SL *)Rv3)[1]=0;
      else {
        Ra.sl[4]=879; /* line # 879 */
        ((SL *)Rv3)[1]=1;
      }
      break;
      case 1:Ra.sl[4]=880; /* line # 880 */
      ((SL *)Rv3)[1]= -((SL *)Rv3)[1];
      break;
      case 2:Ra.sl[4]=881; /* line # 881 */
      ((G *)Rv3)[1]=-((G *)Rv3)[1];
      break;
      case 38:Ra.sl[4]=883; /* line # 883 */
      ((SL *)Rv3)[1]=abs(((SL *)Rv3)[1]);
      break;
      case 39:Ra.sl[4]=884; /* line # 884 */
      ((G *)Rv3)[1]=fabs(((G *)Rv3)[1]);
      break;
      case 40:Ra.sl[4]=885; /* line # 885 */
      ((G *)Rv3)[1]=sqrt(((G *)Rv3)[1]);
      break;
      case 41:Ra.sl[4]=887; /* line # 887 */
      ((G *)Rv3)[1]=sin(((G *)Rv3)[1]);
      break;
      case 42:Ra.sl[4]=888; /* line # 888 */
      ((G *)Rv3)[1]=cos(((G *)Rv3)[1]);
      break;
      case 43:Ra.sl[4]=889; /* line # 889 */
      ((G *)Rv3)[1]=tan(((G *)Rv3)[1]);
      break;
      case 44:Ra.sl[4]=891; /* line # 891 */
      ((G *)Rv3)[1]=asin(((G *)Rv3)[1]);
      break;
      case 45:Ra.sl[4]=892; /* line # 892 */
      ((G *)Rv3)[1]=acos(((G *)Rv3)[1]);
      break;
      case 46:Ra.sl[4]=893; /* line # 893 */
      ((G *)Rv3)[1]=atan(((G *)Rv3)[1]);
      break;
      case 48:Ra.sl[4]=895; /* line # 895 */
      ((G *)Rv3)[1]=sin(1.745329251994329E-002*((G *)Rv3)[1]);
      break;
      case 49:Ra.sl[4]=896; /* line # 896 */
      ((G *)Rv3)[1]=cos(1.745329251994329E-002*((G *)Rv3)[1]);
      break;
      case 50:Ra.sl[4]=897; /* line # 897 */
      ((G *)Rv3)[1]=tan(1.745329251994329E-002*((G *)Rv3)[1]);
      break;
      case 51:Ra.sl[4]=899; /* line # 899 */
      ((G *)Rv3)[1]=asin(((G *)Rv3)[1])/1.745329251994329E-002;
      break;
      case 52:Ra.sl[4]=900; /* line # 900 */
      ((G *)Rv3)[1]=acos(((G *)Rv3)[1])/1.745329251994329E-002;
      break;
      case 53:Ra.sl[4]=901; /* line # 901 */
      ((G *)Rv3)[1]=atan(((G *)Rv3)[1])/1.745329251994329E-002;
      break;
      case 55:Ra.sl[4]=903; /* line # 903 */
      ((G *)Rv3)[1]=exp(((G *)Rv3)[1]);
      break;
      case 56:Ra.sl[4]=904; /* line # 904 */
      ((G *)Rv3)[1]=log(((G *)Rv3)[1]);
      break;
      case 57:Ra.sl[4]=905; /* line # 905 */
      ((G *)Rv3)[1]=PAS__THG(((G *)Rv3)[1]);
      break;
      default:break;
    }
  }
  Ra.sl[4]=912; /* line # 912 */
  ((UL *)Rv2)[5]=((UL *)Rv2)[5]|Rv0;
  Ra.sl[4]=913; /* line # 913 */
  ((V *)Rv2)[1]=((V *)Rv1)[2];
  Ra.sl[4]=914; /* line # 914 */
  ((UB *)Rv3)[1]=P_get_val_forms(((V *)Rv1)[2]);
  Ra.sl[4]=919; /* line # 919 */
  goto L_l_1;
  PAS__curr_cntx=Ra.s+4;
L_l_0:
  Ra.sl[4]=922; /* line # 922 */
  P_numerr_manager(Ra.sl[0],F_ent);
L_l_1:
  Ra.sl[4]=925; /* line # 925 */
  PAS__REVERT();
  PAS__curr_cntx=Ra.v[1];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " err_handler "  */
SL MXD_DCPEXPR_PRC_00000003(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2224;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=945; /* line # 945 */
  if (F_ierr>=20&&F_ierr<=29) {
    Lx[2].sl[0]=F_ierr;
    siglongjmp((void *)Lx[2].v[6],1);
  }
  else {
    Ra.sl[3]=946; /* line # 946 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exe_val_bin "  */
void MXD_DCPEXPR_exe_val_bin(V F_ent){
  sigjmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 28 );

  /* Local variable stored in C variable */
  UL Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register int Rgi;
  register int Rgj;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[6]=(V)L_lb_env;
  if (sigsetjmp(L_lb_env, 1 )) goto L_l_0;

  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+4;
  Ra.v[2]=Rd.s+2237;
  Ra.v[3]=Rd.s+14;
  Ra.sl[4]=951; /* line # 951 */
  Rv0=MXD_DCPEXPR_arguments_setting(2,NULL);
  Ra.sl[4]=952; /* line # 952 */
  PAS__ESTABLISH(MXD_DCPEXPR_PRC_00000003);
  Ra.sl[4]=953; /* line # 953 */
  Rv1=F_ent;
  Ra.sl[4]=955; /* line # 955 */
  if (((V *)Rv1)[7]!=NULL) MXD_DCPEXPR_exe_val_una(((V *)Rv1)[7],0);
  Ra.sl[4]=956; /* line # 956 */
  P_pop_expression(V_exp_res.s);
  Ra.sl[4]=957; /* line # 957 */
  if (((V *)Rv1)[6]!=NULL) MXD_DCPEXPR_exe_val_una(((V *)Rv1)[6],1);
  Ra.sl[4]=958; /* line # 958 */
  Rv2=(Rs.s+Ri.sl[0]*48-48);
  Rv3=Rv2+24;
  Ra.sl[4]=960; /* line # 960 */
  if (262144&V_exp_res.ul[5]||262144&((UL *)Rv2)[5]) {
    Ra.sl[4]=963; /* line # 963 */
    if (!(262144&((UL *)Rv2)[5])) P_out_pcd_vref((Rs.s+Ri.sl[0]*48-48),(262144&V_exp_res
    .ul[5])!=0);
    Ra.sl[4]=965; /* line # 965 */
    if (!(262144&V_exp_res.ul[5])) P_out_pcd_vref(V_exp_res.s,0);
    Ra.sl[4]=967; /* line # 967 */
    P_out_stm_code(((UB *)Rv1)[32]);
  }
  else {
    Ra.sl[4]=974; /* line # 974 */
    switch (((UB *)Rv1)[32]) {
      case 3:Ra.sl[4]=975; /* line # 975 */
      ((SL *)Rv3)[1]=PAS__IIPOWER(((SL *)Rv3)[1],V_exp_res.sl[7]);
      break;
      case 4:Ra.sl[4]=976; /* line # 976 */
      ((G *)Rv3)[1]=PAS__IGPOWER(((G *)Rv3)[1],V_exp_res.sl[7]);
      break;
      case 5:Ra.sl[4]=977; /* line # 977 */
      ((G *)Rv3)[1]=pow  (((G *)Rv3)[1],V_exp_res.g[4]);
      break;
      case 6:Ra.sl[4]=978; /* line # 978 */
      ((SL *)Rv3)[1]=((SL *)Rv3)[1]*V_exp_res.sl[7];
      break;
      case 7:Ra.sl[4]=979; /* line # 979 */
      ((G *)Rv3)[1]=((G *)Rv3)[1]*V_exp_res.g[4];
      break;
      case 8:Ra.sl[4]=980; /* line # 980 */
      ((SL *)Rv3)[1]=((SL *)Rv3)[1]/V_exp_res.sl[7];
      break;
      case 9:Ra.sl[4]=981; /* line # 981 */
      ((SL *)Rv3)[1]=PAS__I_MOD(((SL *)Rv3)[1],V_exp_res.sl[7]);
      break;
      case 10:Ra.sl[4]=982; /* line # 982 */
      ((SL *)Rv3)[1]=((SL *)Rv3)[1]%V_exp_res.sl[7];
      break;
      case 11:Ra.sl[4]=983; /* line # 983 */
      ((G *)Rv3)[1]=((G *)Rv3)[1]/V_exp_res.g[4];
      break;
      case 12:Ra.sl[4]=984; /* line # 984 */
      ((SL *)Rv3)[1]=((SL *)Rv3)[1]+V_exp_res.sl[7];
      break;
      case 13:Ra.sl[4]=985; /* line # 985 */
      ((G *)Rv3)[1]=((G *)Rv3)[1]+V_exp_res.g[4];
      break;
      case 14:Ra.sl[4]=986; /* line # 986 */
      ((SL *)Rv3)[1]=((SL *)Rv3)[1]-V_exp_res.sl[7];
      break;
      case 15:Ra.sl[4]=987; /* line # 987 */
      ((G *)Rv3)[1]=((G *)Rv3)[1]-V_exp_res.g[4];
      break;
      case 16:Ra.sl[4]=988; /* line # 988 */
      MXD_DCPEXPR_string_concate(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL);
      break;
      case 17:Ra.sl[4]=989; /* line # 989 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)==0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 20:Ra.sl[4]=990; /* line # 990 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)!=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 23:Ra.sl[4]=991; /* line # 991 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)<0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 26:Ra.sl[4]=992; /* line # 992 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)<=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 29:Ra.sl[4]=993; /* line # 993 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)>=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 32:Ra.sl[4]=994; /* line # 994 */
      if (MXD_DCPEXPR_string_compare(((V *)Rv3)+1,V_exp_res.v+7,((V *)Rv2)[0]==NULL,
      V_exp_res.v[0]==NULL)>0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 18:Ra.sl[4]=995; /* line # 995 */
      if (((SL *)Rv3)[1]==V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 21:Ra.sl[4]=996; /* line # 996 */
      if (((SL *)Rv3)[1]!=V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 24:Ra.sl[4]=997; /* line # 997 */
      if (((SL *)Rv3)[1]<V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 27:Ra.sl[4]=998; /* line # 998 */
      if (((SL *)Rv3)[1]<=V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 30:Ra.sl[4]=999; /* line # 999 */
      if (((SL *)Rv3)[1]>=V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 33:Ra.sl[4]=1000; /* line # 1000 */
      if (((SL *)Rv3)[1]>V_exp_res.sl[7]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 19:Ra.sl[4]=1001; /* line # 1001 */
      if (((G *)Rv3)[1]==V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 22:Ra.sl[4]=1002; /* line # 1002 */
      if (((G *)Rv3)[1]!=V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 25:Ra.sl[4]=1003; /* line # 1003 */
      if (((G *)Rv3)[1]<V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 28:Ra.sl[4]=1004; /* line # 1004 */
      if (((G *)Rv3)[1]<=V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 31:Ra.sl[4]=1005; /* line # 1005 */
      if (((G *)Rv3)[1]>=V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 34:Ra.sl[4]=1006; /* line # 1006 */
      if (((G *)Rv3)[1]>V_exp_res.g[4]) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 35:Ra.sl[4]=1007; /* line # 1007 */
      if (((SL *)Rv3)[1]!=0&&V_exp_res.sl[7]!=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 36:Ra.sl[4]=1008; /* line # 1008 */
      if (((SL *)Rv3)[1]!=0^V_exp_res.sl[7]!=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 37:Ra.sl[4]=1009; /* line # 1009 */
      if (((SL *)Rv3)[1]!=0||V_exp_res.sl[7]!=0) ((SL *)Rv3)[1]=1;
      else((SL *)Rv3)[1]=0;
      break;
      case 47:Ra.sl[4]=1011; /* line # 1011 */
      ((G *)Rv3)[1]=atan2(((G *)Rv3)[1],V_exp_res.g[4]);
      break;
      case 54:Ra.sl[4]=1012; /* line # 1012 */
      ((G *)Rv3)[1]=atan2(((G *)Rv3)[1],V_exp_res.g[4])/1.745329251994329E-002;
      break;
      case 58:Ra.sl[4]=1013; /* line # 1013 */
      ((G *)Rv3)[1]=P_math_bessel_j(((SL *)Rv3)[1],V_exp_res.g[4]);
      break;
      case 59:Ra.sl[4]=1014; /* line # 1014 */
      ((G *)Rv3)[1]=P_math_bessel_jh(((G *)Rv3)[1],V_exp_res.g[4]);
      break;
      case 60:Ra.sl[4]=1017; /* line # 1017 */
      ((G *)Rv3)[1]=P_math_interpol(((V *)Rv3)[1],V_exp_res.g[4]);
      Ra.sl[4]=1018; /* line # 1018 */
      if (V_math_err>0) {
        Ra.sl[4]=1019; /* line # 1019 */
        if (V_math_err==1) P_src_error(Rd.s+2252,501,1);
        else {
          Ra.sl[4]=1020; /* line # 1020 */
          P_src_error(Rd.s+2258,502,2);
        }
      }
      break;
      case 61:break;
      default:break;
    }
  }
  Ra.sl[4]=1028; /* line # 1028 */
  ((UL *)Rv2)[5]=((UL *)Rv2)[5]|Rv0;
  Ra.sl[4]=1029; /* line # 1029 */
  ((V *)Rv2)[1]=((V *)Rv1)[2];
  Ra.sl[4]=1030; /* line # 1030 */
  ((SL *)Rv2)[3]=1;
  Ra.sl[4]=1031; /* line # 1031 */
  ((UB *)Rv3)[1]=P_get_val_forms(((V *)Rv1)[2]);
  Ra.sl[4]=1037; /* line # 1037 */
  goto L_l_1;
  PAS__curr_cntx=Ra.s+4;
L_l_0:
  Ra.sl[4]=1040; /* line # 1040 */
  P_numerr_manager(Ra.sl[0],F_ent);
L_l_1:
  Ra.sl[4]=1043; /* line # 1043 */
  PAS__REVERT();
  PAS__curr_cntx=Ra.v[1];
  Lx[2]=Lx_Sv;
}


/* Procedure/Function : " set_target_value "  */
void MXD_DCPEXPR_set_target_value(V F_trg, UB F_bfrm){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register UB Rv2;
  register V Rv3;
  register UB Rv4;
  register G Rgg;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2262;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=1060; /* line # 1060 */
  Rv0=F_trg+24;
  Ra.sl[68]=1062; /* line # 1062 */
  Rv1=((SL *)F_trg)[4]+1;
  Ra.sl[68]=1063; /* line # 1063 */
  switch (((UB *)Rv0)[1]) {
    case 0:Ra.sl[68]=1066; /* line # 1066 */
    P_extract_str(V_exp_res.s,Ra.s);
    Ra.sl[68]=1067; /* line # 1067 */
    if (((V *)Rv0)[1]!=NULL) PAS__DISPOSE(((V *)Rv0)+1);
    Ra.sl[68]=1068; /* line # 1068 */
    if (Ra.ub[1]>0) {
      Rv2=Ra.ub[1];
      ((V *)Rv0)[1]=PAS__NEW((SL)Rv2+2);
      ((UB *)((V *)Rv0)[1])[0]=Rv2;
      PAS__STR_TO_STR(((V *)Rv0)[1],Ra.s);
    }
    else {
      Ra.sl[68]=1069; /* line # 1069 */
      ((V *)Rv0)[1]=NULL;
    }
    Ra.sl[68]=1070; /* line # 1070 */
    if (!F_bfrm) ((V *)((V *)F_trg)[0])[11]=((V *)Rv0)[1];
    break;
    case 1:Ra.sl[68]=1074; /* line # 1074 */
    ((SL *)Rv0)[1]=P_extract_int(V_exp_res.s,((SL *)Rv0)[1]);
    Ra.sl[68]=1075; /* line # 1075 */
    if (!F_bfrm) ((SL *)((V *)F_trg)[0])[11]=((SL *)Rv0)[1];
    break;
    case 2:Ra.sl[68]=1079; /* line # 1079 */
    ((G *)Rv0)[1]=P_extract_flt(V_exp_res.s,((G *)Rv0)[1]);
    Ra.sl[68]=1080; /* line # 1080 */
    if (16&((UL *)F_trg)[5]) {
      Ra.sl[68]=1081; /* line # 1081 */
      if (V_sy_sym.ub[0]==21) {
        P_insymbol();
        ((G *)Rv0)[2]=P_get_fltexpr(0.000000E-01);
      }
      else {
        Ra.sl[68]=1082; /* line # 1082 */
        ((G *)Rv0)[2]=0.000000000000000E-001;
      }
    }
    else {
      Ra.sl[68]=1083; /* line # 1083 */
      ((G *)Rv0)[2]=0.000000000000000E-001;
    }
    Ra.sl[68]=1084; /* line # 1084 */
    if (!F_bfrm) {
      Ra.sl[68]=1086; /* line # 1086 */
      ((G *)((V *)F_trg)[0])[6]=((G *)Rv0)[1];
      Ra.sl[68]=1087; /* line # 1087 */
      ((G *)((V *)F_trg)[0])[7]=((G *)Rv0)[2];
    }
    break;
    case 3:Ra.sl[68]=1091; /* line # 1091 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[68]=1092; /* line # 1092 */
      Rv3=((V *)Rv0)[1];
      Ra.sl[68]=1094; /* line # 1094 */
      P_extract_str(V_exp_res.s,Ra.s);
      Ra.sl[68]=1095; /* line # 1095 */
      if (((V *)Rv3)[Rv1]!=NULL) PAS__DISPOSE((((V *)Rv3)+Rv1));
      Ra.sl[68]=1096; /* line # 1096 */
      if (Ra.ub[1]>0) {
        Rv4=Ra.ub[1];
        ((V *)Rv3)[Rv1]=PAS__NEW((SL)Rv4+2);
        ((UB *)((V *)Rv3)[Rv1])[0]=Rv4;
        PAS__STR_TO_STR(((V *)Rv3)[Rv1],Ra.s);
      }
      else {
        Ra.sl[68]=1097; /* line # 1097 */
        ((V *)Rv3)[Rv1]=NULL;
      }
    }
    break;
    case 4:Ra.sl[68]=1100; /* line # 1100 */
    if (((V *)Rv0)[1]!=NULL) ((SL *)((V *)Rv0)[1])[Rv1]=P_extract_int(V_exp_res.
    s,0);
    break;
    case 5:Ra.sl[68]=1103; /* line # 1103 */
    if (((V *)Rv0)[1]!=NULL) ((G *)((V *)Rv0)[1])[Rv1]=P_extract_flt(V_exp_res.s,
0.000000E-01);
    Ra.sl[68]=1104; /* line # 1104 */
    if (((V *)Rv0)[2]!=NULL) {
      Ra.sl[68]=1105; /* line # 1105 */
      if (16&((UL *)F_trg)[5]&&((V *)Rv0)[2]!=NULL) {
        Ra.sl[68]=1106; /* line # 1106 */
        if (V_sy_sym.ub[0]==21) {
          P_insymbol();
          ((G *)((V *)Rv0)[2])[Rv1]=P_get_fltexpr(0.000000E-01);
        }
        else {
          Ra.sl[68]=1107; /* line # 1107 */
          ((G *)((V *)Rv0)[2])[Rv1]=0.000000000000000E-001;
        }
      }
      else {
        Ra.sl[68]=1108; /* line # 1108 */
        ((G *)((V *)Rv0)[2])[Rv1]=0.000000000000000E-001;
      }
    }
    break;
    case 6:Ra.sl[68]=1111; /* line # 1111 */
    switch (V_exp_res.ub[25]) {
      case 0:Ra.sl[68]=1112; /* line # 1112 */
      P_arrsca_ss_assign(V_exp_res.s,F_trg);
      break;
      case 6:Ra.sl[68]=1113; /* line # 1113 */
      P_array_ss_assign(V_exp_res.s,F_trg);
      break;
      default:Ra.sl[68]=1115; /* line # 1115 */
      P_src_error(Rd.s+2282,118,3);
      break;
    }
    break;
    case 7:Ra.sl[68]=1118; /* line # 1118 */
    switch (V_exp_res.ub[25]) {
      case 1:Ra.sl[68]=1119; /* line # 1119 */
      P_arrsca_ii_assign(V_exp_res.sl[7],F_trg);
      break;
      case 2:Ra.sl[68]=1120; /* line # 1120 */
      P_arrsca_ii_assign((V_exp_res.g[4]>0.0?(SL)(V_exp_res.g[4]+0.5):(SL)(V_exp_res
      .g[4]-0.5)),F_trg);
      break;
      case 7:Ra.sl[68]=1121; /* line # 1121 */
      P_array_ii_assign(V_exp_res.s,F_trg);
      break;
      case 8:Ra.sl[68]=1122; /* line # 1122 */
      P_array_fi_assign(V_exp_res.s,F_trg);
      break;
      default:Ra.sl[68]=1124; /* line # 1124 */
      P_src_error(Rd.s+2282,116,3);
      break;
    }
    break;
    case 8:Ra.sl[68]=1127; /* line # 1127 */
    switch (V_exp_res.ub[25]) {
      case 1:Ra.sl[68]=1128; /* line # 1128 */
      P_arrsca_ff_assign((double)V_exp_res.sl[7],0.000000E-01, F_trg);
      break;
      case 2:Ra.sl[68]=1129; /* line # 1129 */
      P_arrsca_ff_assign(V_exp_res.g[4],0.000000E-01, F_trg);
      break;
      case 7:Ra.sl[68]=1130; /* line # 1130 */
      P_array_if_assign(V_exp_res.s,F_trg);
      break;
      case 8:Ra.sl[68]=1131; /* line # 1131 */
      P_array_ff_assign(V_exp_res.s,F_trg);
      break;
      default:Ra.sl[68]=1133; /* line # 1133 */
      P_src_error(Rd.s+2282,117,3);
      break;
    }
    break;
    default:Ra.sl[68]=1137; /* line # 1137 */
    P_src_error_s(Rd.s+2282,105,3, V_sy_ident.s,NULL);
    break;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " assignement "  */
void P_assignement(V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2286;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1156; /* line # 1156 */
  Ra.sl[3]=1158; /* line # 1158 */
  Ra.ub[41]=11;
  Ra.sl[3]=1159; /* line # 1159 */
  P_get_exp_refer(Ra.s+16,F_trg);
  Ra.sl[3]=1163; /* line # 1163 */
  Rv0=Ra.s+40;
  Ra.sl[3]=1164; /* line # 1164 */
  if (Ra.v[4]!=NULL) {
    Ra.sl[3]=1166; /* line # 1166 */
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else {
      Ra.sl[3]=1167; /* line # 1167 */
      P_src_error(Rd.s+2301,32,2);
    }
    Ra.sl[3]=1168; /* line # 1168 */
    if (Ra.v[4]!=NULL&&((UB *)Rv0)[1]!=11) {
      Ra.sl[3]=1169; /* line # 1169 */
      if (1&Ra.ul[9]) {
        Ra.sl[3]=1170; /* line # 1170 */
        P_src_error_s(Rd.s+2301,131,2,((V *)Ra.v[4])[0],NULL);
      }
      else {
        Ra.sl[3]=1173; /* line # 1173 */
        P_get_expression(V_exp_res.s);
        Ra.sl[3]=1178; /* line # 1178 */
        if (131072&V_exp_res.ul[5]&&256&Ra.ul[9]) {
          Ra.sl[3]=1181; /* line # 1181 */
          if (V_ret_seq_incr>1) {
            Ra.sl[3]=1189; /* line # 1189 */
            if (256&V_exp_res.ul[5]&&V_exp_res.sl[3]>1) {
              Ra.sl[3]=1191; /* line # 1191 */
              V_ret_seq_count=V_exp_res.sl[2];
            }
            else {
              Ra.sl[3]=1193; /* line # 1193 */
              P_out_retpar_def(Ra.s+16);
            }
          }
        }
        else {
          Ra.sl[3]=1199; /* line # 1199 */
          if (256&((UL *)Ra.v[4])[5]&&((UB *)Rv0)[1]<=2) {
            Ra.sl[3]=1204; /* line # 1204 */
            MXD_DCPEXPR_set_target_value((Rs.s+Ri.sl[1]*48-48),1);
          }
          else {
            Ra.sl[3]=1212; /* line # 1212 */
            MXD_DCPEXPR_set_target_value(Ra.s+16,0);
            Ra.sl[3]=1213; /* line # 1213 */
            if (8&((UL *)Ra.v[4])[5]) P_assign_specific(Ra.s+16);
          }
        }
      }
    }
    Ra.sl[3]=1216; /* line # 1216 */
    P_exprv_remove(Ra.s+16);
  }
  else {
    Ra.sl[3]=1217; /* line # 1217 */
    P_skip_symbol(18);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_generic_call "  */
void MXD_DCPEXPR_gen_generic_call(V F_ent, SL F_npa, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;
  SL Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;
  SL Rv6;
  register V Rv7;
  C Rv8;
  C Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2305;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1235; /* line # 1235 */
  Rv0=F_ent;
  Ra.sl[3]=1240; /* line # 1240 */
  Rv1=MXD_DCPEXPR_arguments_setting(F_npa,((V *)Rv0)[4]);
  Ra.sl[3]=1245; /* line # 1245 */
  Rv2=V_ret_seq_count;
  Ra.sl[3]=1246; /* line # 1246 */
  Rv3=V_ret_seq_incr;
  Ra.sl[3]=1247; /* line # 1247 */
  V_ret_seq_incr=0;
  Ra.sl[3]=1248; /* line # 1248 */
  V_ret_seq_count=0;
  Ra.sl[3]=1249; /* line # 1249 */
  if (((V *)Rv0)[2]!=NULL) {
    Ra.sl[3]=1251; /* line # 1251 */
    if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
    else {
      Ra.sl[3]=1252; /* line # 1252 */
      P_src_error(Rd.s+2325,6,3);
    }
    Ra.sl[3]=1254; /* line # 1254 */
    Rv4=(Rs.s+Ri.sl[0]*48-48);
    Rv5=((V *)Rv0)[2];
    Ra.sl[3]=1256; /* line # 1256 */
    ((V *)Rv4)[0]=V_ret_ide;
    Ra.sl[3]=1257; /* line # 1257 */
    ((V *)Rv4)[1]=((V *)Rv0)[2];
    Ra.sl[3]=1258; /* line # 1258 */
    ((SL *)Rv4)[2]=0;
    Ra.sl[3]=1259; /* line # 1259 */
    ((SL *)Rv4)[4]=0;
    Ra.sl[3]=1260; /* line # 1260 */
    if (((UB *)Rv5)[24]==3) ((SL *)Rv4)[3]=((SL *)Rv5)[8]*((SL *)Rv5)[9];
    else {
      Ra.sl[3]=1261; /* line # 1261 */
      ((SL *)Rv4)[3]=1;
    }
    Ra.sl[3]=1262; /* line # 1262 */
    V_ret_seq_incr=((SL *)Rv4)[3];
    Ra.sl[3]=1263; /* line # 1263 */
    ((UL *)Rv4)[5]=256;
    Ra.sl[3]=1264; /* line # 1264 */
    ((UB *)Rv4)[24]=0;
    Ra.sl[3]=1265; /* line # 1265 */
    ((UB *)Rv4)[25]=11;
    Ra.sl[3]=1266; /* line # 1266 */
    P_val_allocate(Rv4+24,((V *)Rv0)[2]);
  }
  Ra.sl[3]=1273; /* line # 1273 */
  Rv6=Ri.sl[1];
  Ri.sl[1]=Ri.sl[0];
  Ra.sl[3]=1276; /* line # 1276 */
  P_display_new();
  Ra.sl[3]=1277; /* line # 1277 */
  Rv7=(V_disp_tab.s+V_curr_disp*24);
  Ra.sl[3]=1278; /* line # 1278 */
  ((V *)Rv7)[5]=((V *)Rv0)[4];
  ((V *)Rv7)[4]=((V *)Rv0)[4];
  Ra.sl[3]=1280; /* line # 1280 */
  P_display_new();
  Ra.sl[3]=1281; /* line # 1281 */
  P_save_sym_cntx(1);
  Ra.sl[3]=1282; /* line # 1282 */
  Ra.v[4]=NULL;
  Ra.sl[3]=1283; /* line # 1283 */
  Ra.v[6]=NULL;
  Ra.sl[3]=1284; /* line # 1284 */
  Ra.v[8]=NULL;
  Ra.sl[3]=1285; /* line # 1285 */
  Ra.v[9]=NULL;
  Ra.sl[3]=1286; /* line # 1286 */
  Ra.ub[40]=0;
  Ra.sl[3]=1287; /* line # 1287 */
  Ra.ub[56]=1;
  Ra.sl[3]=1288; /* line # 1288 */
  Ra.v[13]=((V *)Rv0)[5];
  Ra.sl[3]=1289; /* line # 1289 */
  Ra.v[7]=V_idm_actstk;
  Ra.sl[3]=1290; /* line # 1290 */
  V_idm_actstk=Ra.s+16;
  Ra.sl[3]=1291; /* line # 1291 */
  Ra.sl[12]=1;
  Ra.sl[3]=1292; /* line # 1292 */
  V_sy_sym.ub[0]=87;
  Ra.sl[3]=1293; /* line # 1293 */
  Rv8=V_sy_ch;
  Rv9=V_sy_cmin;
  V_sy_ch=32;
  Ra.sl[3]=1304; /* line # 1304 */
  P_statelist(28);
  Ra.sl[3]=1308; /* line # 1308 */
  V_idm_actstk=Ra.v[7];
  Ra.sl[3]=1309; /* line # 1309 */
  P_restore_sym_cntx();
  Ra.sl[3]=1311; /* line # 1311 */
  P_display_free();
  Ra.sl[3]=1312; /* line # 1312 */
  V_curr_disp=V_curr_disp-1;
  Ra.sl[3]=1314; /* line # 1314 */
  Ri.sl[0]=Ri.sl[1];
  Ra.sl[3]=1318; /* line # 1318 */
  if (((V *)Rv0)[2]!=NULL) Ri.sl[0]=Ri.sl[0]-1;
  Ra.sl[3]=1319; /* line # 1319 */
  if (F_npa>0) MXD_DCPEXPR_stack_remove(F_npa);
  Ra.sl[3]=1321; /* line # 1321 */
  if (((V *)Rv0)[2]!=NULL) {
    Ra.sl[3]=1323; /* line # 1323 */
    Ri.sl[0]=Ri.sl[0]+1;
    Ra.sl[3]=1324; /* line # 1324 */
    memcpy((Rs.s+Ri.sl[0]*48-48),(Rs.s+Ri.sl[1]*48-48),48);
    Ra.sl[3]=1325; /* line # 1325 */
    Rv10=(Rs.s+Ri.sl[0]*48-48);
    Ra.sl[3]=1327; /* line # 1327 */
    if (V_ret_seq_count>0) {
      Ra.sl[3]=1329; /* line # 1329 */
      ((SL *)Rv10)[2]=V_ret_seq_count;
      Ra.sl[3]=1330; /* line # 1330 */
      ((UL *)Rv10)[5]=((UL *)Rv10)[5]|131072;
    }
    Ra.sl[3]=1332; /* line # 1332 */
    ((UL *)Rv10)[5]=((UL *)Rv10)[5]|Rv1;
    Ra.sl[3]=1333; /* line # 1333 */
    ((V *)Rv10)[0]=NULL;
  }
  Ra.sl[3]=1336; /* line # 1336 */
  V_ret_seq_incr=Rv3;
  Ra.sl[3]=1337; /* line # 1337 */
  V_ret_seq_count=Rv2;
  Ra.sl[3]=1338; /* line # 1338 */
  Ri.sl[1]=Rv6;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " display_search_res "  */
void MXD_DCPEXPR_display_search_res(V F_ent){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2329;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1355; /* line # 1355 */
  if (F_ent!=NULL) {
    Ra.sl[3]=1356; /* line # 1356 */
    Rv0=F_ent;
    Ra.sl[3]=1358; /* line # 1358 */
    switch (((UB *)Rv0)[12]) {
      case 0:Ra.sl[3]=1361; /* line # 1361 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2349,-1,-1,32);
      PAS__WRITE_ENM(((UB *)Rv0)[32],Rd.s+1264,0,-1,32);
      PAS__WRITE_STR(Rd.s+2358,-1,-1,32);
      PAS__WRITE_STR(((V *)((V *)((V *)Rv0)[4])[0])[0],-1,-1,32);
      Ra.sl[3]=1362; /* line # 1362 */
      if (((UB *)Rv0)[13]>1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+2362,-1,-1,32);
        PAS__WRITE_STR(((V *)((V *)((V *)Rv0)[5])[0])[0],-1,-1,32);
      }
      break;
      case 1:Ra.sl[3]=1366; /* line # 1366 */
      if (((UB *)Rv0)[15]==21) {
        Ra.sl[3]=1367; /* line # 1367 */
        if (((V *)((V *)Rv0)[6])[0]!=NULL) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+2366,-1,-1,32);
          PAS__WRITE_STR(((V *)((V *)Rv0)[6])[0],-1,-1,32);
          PAS__WRITE_CHAR(34);
        }
        else {
          Ra.sl[3]=1368; /* line # 1368 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+2384,-1,-1,32);
        }
      }
      else {
        Ra.sl[3]=1369; /* line # 1369 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+2396,-1,-1,32);
        PAS__WRITE_STR(((V *)Rv0)[6],-1,-1,32);
        PAS__WRITE_CHAR(34);
      }
      Ra.sl[3]=1370; /* line # 1370 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+2416,-1,-1,32);
      PAS__WRITE_INT(((UB *)Rv0)[13],0,0);
      PAS__WRITE_STR(Rd.s+2424,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1371; /* line # 1371 */
      Rv1=((V *)Rv0)[4];
      Ra.sl[3]=1372; /* line # 1372 */
      while (Rv1!=NULL){
        Ra.sl[3]=1373; /* line # 1373 */
        Rv2=Rv1;
        Ra.sl[3]=1375; /* line # 1375 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_FCHAR(32,8,-1,1,32);
        PAS__WRITE_STR(((V *)Rv2)[0],-1,-1,32);
        PAS__WRITE_STR(Rd.s+2438,-1,-1,32);
        PAS__WRITE_STR(((V *)((V *)((V *)Rv2)[4])[0])[0],-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[3]=1376; /* line # 1376 */
        Rv1=((V *)Rv2)[1];
      }
      break;
      default:break;
    }
    Ra.sl[3]=1381; /* line # 1381 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2442,-1,-1,32);
    PAS__WRITE_STR(((V *)((V *)((V *)Rv0)[2])[0])[0],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=1383; /* line # 1383 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+2450,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_genoper "  */
void MXD_DCPEXPR_gen_genoper(UB F_op, SL F_npa){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2476;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1404; /* line # 1404 */
  Rv0=MXD_DCPEXPR_generic_search(V_mop_tab.v[F_op*2+1],F_npa);
  Ra.sl[3]=1408; /* line # 1408 */
  if (Rv0!=NULL) {
    Ra.sl[3]=1410; /* line # 1410 */
    switch (((UB *)Rv0)[12]) {
      case 0:Ra.sl[3]=1412; /* line # 1412 */
      if (F_npa==1) MXD_DCPEXPR_exe_val_una(Rv0,0);
      else {
        Ra.sl[3]=1413; /* line # 1413 */
        MXD_DCPEXPR_exe_val_bin(Rv0);
      }
      break;
      case 1:Ra.sl[3]=1416; /* line # 1416 */
      MXD_DCPEXPR_gen_generic_call(Rv0, F_npa,1);
      break;
      default:break;
    }
  }
  else {
    Ra.sl[3]=1421; /* line # 1421 */
    P_src_error_s(Rd.s+2491,128,2,(Ri.s+F_op*6+84),NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_generic_call "  */
void P_exp_generic_call(V F_idp, UB F_bexpr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2495;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1438; /* line # 1438 */
  Ra.sl[3]=1440; /* line # 1440 */
  P_insymbol();
  Ra.sl[3]=1442; /* line # 1442 */
  Rv0=0;
  Ra.sl[3]=1443; /* line # 1443 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[3]=1445; /* line # 1445 */
    V_sy_sym.ub[0]=17;
    Ra.sl[3]=1446; /* line # 1446 */
    while (V_sy_sym.ub[0]==17){
      Ra.sl[3]=1448; /* line # 1448 */
      P_insymbol();
      Ra.sl[3]=1449; /* line # 1449 */
      if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
        Ra.sl[3]=1451; /* line # 1451 */
        P_expression();
        Rv0=Rv0+1;
      }
    }
    Ra.sl[3]=1454; /* line # 1454 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+2515,23,2);
    else {
      Ra.sl[3]=1455; /* line # 1455 */
      P_insymbol();
    }
  }
  Ra.sl[3]=1459; /* line # 1459 */
  Rv1=MXD_DCPEXPR_generic_search(((V *)F_idp)[8],Rv0);
  Ra.sl[3]=1463; /* line # 1463 */
  if (Rv1!=NULL) {
    Ra.sl[3]=1465; /* line # 1465 */
    switch (((UB *)Rv1)[12]) {
      case 0:Ra.sl[3]=1467; /* line # 1467 */
      if (Rv0==1) MXD_DCPEXPR_exe_val_una(Rv1,0);
      else {
        Ra.sl[3]=1468; /* line # 1468 */
        MXD_DCPEXPR_exe_val_bin(Rv1);
      }
      break;
      case 1:Ra.sl[3]=1471; /* line # 1471 */
      MXD_DCPEXPR_gen_generic_call(Rv1, Rv0,1);
      break;
      case 2:Ra.sl[3]=1474; /* line # 1474 */
      P_exec_builtin(((UB *)Rv1)[20],Rv0);
      break;
      default:break;
    }
  }
  else {
    Ra.sl[3]=1479; /* line # 1479 */
    P_src_error_s(Rd.s+2515,128,2,((V *)F_idp)[0],NULL);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_expression "  */
void P_get_expression(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2519;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1495; /* line # 1495 */
  Rv0=Ri.sl[0];
  Ra.sl[3]=1496; /* line # 1496 */
  P_expression();
  Ra.sl[3]=1497; /* line # 1497 */
  P_pop_expression(F_rec);
  Ra.sl[3]=1498; /* line # 1498 */
  if (Rv0!=Ri.sl[0]) {
    Ra.sl[3]=1500; /* line # 1500 */
    P_src_error(Rd.s+2537,9,2);
    Ra.sl[3]=1501; /* line # 1501 */
    Ri.sl[0]=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " bld_farr_type "  */
void P_bld_farr_type(V F_ty, V *F_rty, SL *F_esz, SL F_lvl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2541;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1511; /* line # 1511 */
  if (F_ty!=NULL) {
    Ra.sl[3]=1513; /* line # 1513 */
    switch (((UB *)F_ty)[24]) {
      case 3:Ra.sl[3]=1515; /* line # 1515 */
      if (512&((UL *)F_ty)[5]) {
        Ra.sl[3]=1517; /* line # 1517 */
        (*F_rty)=P_typ_new(3,NULL,F_ty, F_lvl);
        Ra.sl[3]=1518; /* line # 1518 */
        Rv0=(*F_rty);
        Ra.sl[3]=1520; /* line # 1520 */
        P_bld_farr_type(((V *)F_ty)[7],((V *)Rv0)+7,((SL *)Rv0)+8,F_lvl);
        Ra.sl[3]=1521; /* line # 1521 */
        ((UL *)Rv0)[5]=((UL *)F_ty)[5]&~1536;
        Ra.sl[3]=1523; /* line # 1523 */
        if (((V *)Rv0)[7]!=NULL) ((SL *)Rv0)[8]=((SL *)((V *)Rv0)[7])[9]*((SL *)(
        (V *)Rv0)[7])[8];
        else {
          Ra.sl[3]=1524; /* line # 1524 */
          ((SL *)Rv0)[8]=0;
        }
        Ra.sl[3]=1525; /* line # 1525 */
        ((SL *)Rv0)[9]=0;
        Ra.sl[3]=1526; /* line # 1526 */
        ((SL *)Rv0)[10]=((SL *)F_ty)[10];
        Ra.sl[3]=1527; /* line # 1527 */
        (*F_esz)=0;
      }
      else {
        Ra.sl[3]=1532; /* line # 1532 */
        (*F_rty)=F_ty;
        (*F_esz)=((SL *)F_ty)[9]*((SL *)F_ty)[8];
      }
      break;
      default:Ra.sl[3]=1535; /* line # 1535 */
      (*F_rty)=F_ty;
      (*F_esz)=1;
      break;
    }
  }
  else {
    Ra.sl[3]=1538; /* line # 1538 */
    (*F_rty)=NULL;
    (*F_esz)=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cte_scalar "  */
void MXD_DCPEXPR_PRC_00000005(V F_vrec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2556;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1585; /* line # 1585 */
  Ra.sl[3]=1587; /* line # 1587 */
  switch (((UB *)F_vrec)[1]) {
    case 6:Ra.sl[3]=1588; /* line # 1588 */
    Rv0=((V *)F_vrec)[1];
    Ra.sl[3]=1590; /* line # 1590 */
    if (((V *)Rv0)[Lx[3].sl[0]]!=NULL) PAS__DISPOSE((((V *)Rv0)+Lx[3].sl[0]));
    Ra.sl[3]=1591; /* line # 1591 */
    P_get_strexpr(Ri.s+216);
    Rv1=Ri.ub[217];
    ((V *)Rv0)[Lx[3].sl[0]]=PAS__NEW((SL)Rv1+2);
    ((UB *)((V *)Rv0)[Lx[3].sl[0]])[0]=Rv1;
    PAS__STR_TO_STR(((V *)Rv0)[Lx[3].sl[0]],Ri.s+216);
    break;
    case 7:Ra.sl[3]=1593; /* line # 1593 */
    ((SL *)((V *)F_vrec)[1])[Lx[3].sl[0]]=P_get_intexpr(0);
    break;
    case 8:Ra.sl[3]=1595; /* line # 1595 */
    ((G *)((V *)F_vrec)[1])[Lx[3].sl[0]]=P_get_fltexpr(0.000000E-01);
    Ra.sl[3]=1596; /* line # 1596 */
    if (Lx[3].ub[4]) {
      Ra.sl[3]=1597; /* line # 1597 */
      if (V_sy_sym.ub[0]==21) {
        P_insymbol();
        ((G *)((V *)F_vrec)[2])[Lx[3].sl[0]]=P_get_fltexpr(0.000000E-01);
      }
      else {
        Ra.sl[3]=1598; /* line # 1598 */
        ((G *)((V *)F_vrec)[2])[Lx[3].sl[0]]=0.000000000000000E-001;
      }
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cte_array "  */
void MXD_DCPEXPR_PRC_00000004(V F_typ, V F_val, UB F_blrp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2568;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1607; /* line # 1607 */
  Rv0=F_typ;
  Ra.sl[3]=1609; /* line # 1609 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[3]=1610; /* line # 1610 */
    P_src_error(Rd.s+2581,22,2);
  }
  Ra.sl[3]=1612; /* line # 1612 */
  Rv1=((V *)Rv0)[7];
  Ra.sl[3]=1613; /* line # 1613 */
  Rv2=0;
  Ra.sl[3]=1614; /* line # 1614 */
  if (((SL *)Rv0)[9]>0) Rv3=((SL *)Rv0)[9];
  else {
    Ra.sl[3]=1615; /* line # 1615 */
    Rv3=2147483647;
  }
  Ra.sl[3]=1616; /* line # 1616 */
  if (Rv1!=NULL) {
    while (1){
      Ra.sl[3]=1619; /* line # 1619 */
      if (Lx[3].sl[0]>=Lx[3].sl[2]||Rv2>=Rv3) {
        Ra.sl[3]=1621; /* line # 1621 */
        P_src_error(Rd.s+2581,151,3);
        Ra.sl[3]=1622; /* line # 1622 */
        P_skip_symbol(14);
      }
      else {
        Ra.sl[3]=1626; /* line # 1626 */
        Rv2=Rv2+1;
        Ra.sl[3]=1627; /* line # 1627 */
        switch (((UB *)Rv1)[24]) {
          case 0:
          case 1:
          case 2:Ra.sl[3]=1631; /* line # 1631 */
          Lx[3].sl[0]=Lx[3].sl[0]+1;
          Ra.sl[3]=1632; /* line # 1632 */
          MXD_DCPEXPR_PRC_00000005(F_val);
          break;
          case 3:Ra.sl[3]=1634; /* line # 1634 */
          MXD_DCPEXPR_PRC_00000004(Rv1, F_val,1);
          break;
          default:break;
        }
      }
      Ra.sl[3]=1638; /* line # 1638 */
      if (V_sy_sym.ub[0]!=17)  break;
      Ra.sl[3]=1639; /* line # 1639 */
      P_insymbol();
      if (0)  break;
    }
    Ra.sl[3]=1642; /* line # 1642 */
    if (((SL *)Rv0)[9]==0) {
      Ra.sl[3]=1644; /* line # 1644 */
      if (((UB *)Rv1)[24]==3) ((SL *)Rv0)[8]=((SL *)Rv1)[9]*((SL *)Rv1)[8];
      else {
        Ra.sl[3]=1645; /* line # 1645 */
        ((SL *)Rv0)[8]=1;
      }
      Ra.sl[3]=1646; /* line # 1646 */
      ((SL *)Rv0)[9]=Rv2;
    }
    else {
      Ra.sl[3]=1650; /* line # 1650 */
      while (Rv2<((SL *)Rv0)[9]){
        Ra.sl[3]=1652; /* line # 1652 */
        Rv2=Rv2+1;
        Ra.sl[3]=1653; /* line # 1653 */
        for( Rf0=((SL *)Rv0)[8];Rf0>0;Rf0-- ) {
          Ra.sl[3]=1655; /* line # 1655 */
          Lx[3].sl[0]=Lx[3].sl[0]+1;
          Ra.sl[3]=1656; /* line # 1656 */
          switch (((UB *)F_val)[1]) {
            case 6:Ra.sl[3]=1657; /* line # 1657 */
            ((V *)((V *)F_val)[1])[Lx[3].sl[0]]=NULL;
            break;
            case 7:Ra.sl[3]=1658; /* line # 1658 */
            ((SL *)((V *)F_val)[1])[Lx[3].sl[0]]=0;
            break;
            case 8:Ra.sl[3]=1660; /* line # 1660 */
            ((G *)((V *)F_val)[1])[Lx[3].sl[0]]=0.000000000000000E-001;
            Ra.sl[3]=1661; /* line # 1661 */
            if (Lx[3].ub[4]) ((G *)((V *)F_val)[2])[Lx[3].sl[0]]=0.000000000000000E-001;
            break;
            default:break;
          }
        }
      }
    }
  }
  Ra.sl[3]=1669; /* line # 1669 */
  if (F_blrp) {
    Ra.sl[3]=1670; /* line # 1670 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[3]=1671; /* line # 1671 */
      P_src_error(Rd.s+2581,23,2);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_init_val "  */
void P_get_init_val(V F_val, V F_mty, V *F_typ, SL F_lvl, V F_pname, UB F_blrp){
  /* Define the automatic variable space. */
  Blk( Ra, 312 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register UB Rv2;
  SL Rv3;
  register SL Rv4;
  SL Rv5;
  register SL Rv6;
  SL Rv7;
  register SL Rv8;
  SL Rv9;
  register SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  SL Rv14;
  register UB Rv15;
  register V Rv16;
  SL Rv17;
  register V Rv18;
  SL Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[12]=255;
  Ra.v[68]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+272;
  Ra.v[69]=Rd.s+2585;
  Ra.v[70]=Rd.s+14;
  Ra.sl[71]=1678; /* line # 1678 */
  if (F_mty!=NULL) {
    Ra.sl[71]=1679; /* line # 1679 */
    Rv0=F_mty;
    Ra.sl[71]=1681; /* line # 1681 */
    if (((V *)Rv0)[0]!=NULL) Rv1=((V *)((V *)Rv0)[0])[0];
    else {
      Ra.sl[71]=1682; /* line # 1682 */
      Rv1=NULL;
    }
    Ra.sl[71]=1683; /* line # 1683 */
    Ra.ub[4]=(16&((UL *)Rv0)[5])!=0;
    Ra.sl[71]=1684; /* line # 1684 */
    (*F_typ)=F_mty;
    Ra.sl[71]=1685; /* line # 1685 */
    ((UB *)F_val)[0]=0;
    Ra.sl[71]=1686; /* line # 1686 */
    ((UB *)F_val)[1]=P_get_val_forms(F_mty);
    Ra.sl[71]=1687; /* line # 1687 */
    switch (((UB *)Rv0)[24]) {
      case 0:Ra.sl[71]=1688; /* line # 1688 */
      P_get_strexpr(Ra.s+12);
      Rv2=Ra.ub[13];
      ((V *)F_val)[1]=PAS__NEW((SL)Rv2+2);
      ((UB *)((V *)F_val)[1])[0]=Rv2;
      PAS__STR_TO_STR(((V *)F_val)[1],Ra.s+12);
      break;
      case 1:Ra.sl[71]=1689; /* line # 1689 */
      ((SL *)F_val)[1]=P_get_intexpr(0);
      break;
      case 2:Ra.sl[71]=1691; /* line # 1691 */
      ((G *)F_val)[1]=P_get_fltexpr(0.000000E-01);
      ((G *)F_val)[2]=0.000000000000000E-001;
      Ra.sl[71]=1692; /* line # 1692 */
      if (Ra.ub[4]&&V_sy_sym.ub[0]==21) {
        P_insymbol();
        ((G *)F_val)[2]=P_get_fltexpr(0.000000E-01);
      }
      break;
      case 3:Ra.sl[71]=1697; /* line # 1697 */
      Ra.sl[0]=0;
      Ra.sl[71]=1698; /* line # 1698 */
      if (512&((UL *)Rv0)[5]) {
        Ra.sl[71]=1700; /* line # 1700 */
        Ra.sl[2]=32768;
        Ra.sl[71]=1701; /* line # 1701 */
        Ra.ub[289]=((UB *)F_val)[1];
        Ra.sl[71]=1702; /* line # 1702 */
        switch (((UB *)F_val)[1]) {
          case 6:Ra.sl[71]=1703; /* line # 1703 */
          Ra.v[73]=PAS__NEW(131076);
          ((SL *)Ra.v[73])[0]=32768;
          break;
          case 7:Ra.sl[71]=1704; /* line # 1704 */
          Ra.v[73]=PAS__NEW(131076);
          ((SL *)Ra.v[73])[0]=32768;
          break;
          case 8:Ra.sl[71]=1706; /* line # 1706 */
          Ra.v[73]=PAS__NEW(262152);
          ((SL *)Ra.v[73])[0]=32768;
          Ra.sl[71]=1707; /* line # 1707 */
          if (16&((UL *)Rv0)[5]) {
            Ra.sl[71]=1708; /* line # 1708 */
            Ra.ub[4]=1;
            Ra.v[74]=PAS__NEW(262152);
            ((SL *)Ra.v[74])[0]=32768;
          }
          else {
            Ra.sl[71]=1709; /* line # 1709 */
            Ra.v[74]=NULL;
          }
          break;
          default:break;
        }
        Ra.sl[71]=1713; /* line # 1713 */
        Ra.sl[2]=32768;
        Ra.sl[71]=1714; /* line # 1714 */
        P_bld_farr_type(F_mty, F_typ,&Rv3,0);
        Ra.sl[71]=1715; /* line # 1715 */
        MXD_DCPEXPR_PRC_00000004((*F_typ),Ra.s+288,F_blrp);
        Ra.sl[71]=1716; /* line # 1716 */
        switch (((UB *)F_val)[1]) {
          case 6:Ra.sl[71]=1718; /* line # 1718 */
          Rv4=Ra.sl[0];
          ((V *)F_val)[1]=PAS__NEW(Rv4*4+4);
          ((SL *)((V *)F_val)[1])[0]=Rv4;
          Ra.sl[71]=1719; /* line # 1719 */
          Rv5=1;
          for( Rf0=Ra.sl[0];Rf0>0;Rf0-- ) {
            ((V *)((V *)F_val)[1])[Rv5]=((V *)Ra.v[73])[Rv5];
            Rv5++;
          }
          Ra.sl[71]=1720; /* line # 1720 */
          PAS__DISPOSE(Ra.v+73);
          break;
          case 7:Ra.sl[71]=1723; /* line # 1723 */
          Rv6=Ra.sl[0];
          ((V *)F_val)[1]=PAS__NEW(Rv6*4+4);
          ((SL *)((V *)F_val)[1])[0]=Rv6;
          Ra.sl[71]=1724; /* line # 1724 */
          Rv7=1;
          for( Rf0=Ra.sl[0];Rf0>0;Rf0-- ) {
            ((SL *)((V *)F_val)[1])[Rv7]=((SL *)Ra.v[73])[Rv7];
            Rv7++;
          }
          Ra.sl[71]=1725; /* line # 1725 */
          PAS__DISPOSE(Ra.v+73);
          break;
          case 8:Ra.sl[71]=1728; /* line # 1728 */
          Rv8=Ra.sl[0];
          ((V *)F_val)[1]=PAS__NEW(Rv8*8+8);
          ((SL *)((V *)F_val)[1])[0]=Rv8;
          Ra.sl[71]=1729; /* line # 1729 */
          Rv9=1;
          for( Rf0=Ra.sl[0];Rf0>0;Rf0-- ) {
            ((G *)((V *)F_val)[1])[Rv9]=((G *)Ra.v[73])[Rv9];
            Rv9++;
          }
          Ra.sl[71]=1730; /* line # 1730 */
          PAS__DISPOSE(Ra.v+73);
          Ra.sl[71]=1731; /* line # 1731 */
          if (Ra.ub[4]) {
            Ra.sl[71]=1733; /* line # 1733 */
            Rv10=Ra.sl[0];
            ((V *)F_val)[2]=PAS__NEW(Rv10*8+8);
            ((SL *)((V *)F_val)[2])[0]=Rv10;
            Ra.sl[71]=1734; /* line # 1734 */
            Rv11=1;
            for( Rf0=Ra.sl[0];Rf0>0;Rf0-- ) {
              ((G *)((V *)F_val)[2])[Rv11]=((G *)Ra.v[74])[Rv11];
              Rv11++;
            }
            Ra.sl[71]=1735; /* line # 1735 */
            PAS__DISPOSE(Ra.v+74);
          }
          break;
          default:break;
        }
      }
      else {
        Ra.sl[71]=1743; /* line # 1743 */
        Ra.sl[2]=((SL *)Rv0)[9]*((SL *)Rv0)[8];
        Ra.sl[71]=1744; /* line # 1744 */
        Rv12=Ra.sl[2];
        Ra.sl[71]=1745; /* line # 1745 */
        if (V_sy_sym.ub[0]==13) {
          Ra.sl[71]=1746; /* line # 1746 */
          MXD_DCPEXPR_PRC_00000004((*F_typ),F_val,F_blrp);
        }
        else {
          Ra.sl[71]=1749; /* line # 1749 */
          F_blrp=1;
          Ra.sl[71]=1750; /* line # 1750 */
          switch (((UB *)F_val)[1]) {
            case 6:Ra.sl[71]=1752; /* line # 1752 */
            Ra.ub[13]=0;
            P_get_strexpr(Ra.s+12);
            Ra.sl[71]=1753; /* line # 1753 */
            Rv13=((V *)F_val)[1];
            Ra.sl[71]=1754; /* line # 1754 */
            Rv14=1;
            for( Rf0=((SL *)Rv13)[0];Rf0>0;Rf0-- ) {
              Ra.sl[71]=1755; /* line # 1755 */
              if (Ra.ub[13]>0) {
                Ra.sl[71]=1756; /* line # 1756 */
                Rv15=Ra.ub[13];
                ((V *)Rv13)[Rv14]=PAS__NEW((SL)Rv15+2);
                ((UB *)((V *)Rv13)[Rv14])[0]=Rv15;
                PAS__STR_TO_STR(((V *)Rv13)[Rv14],Ra.s+12);
              }
              else {
                Ra.sl[71]=1757; /* line # 1757 */
                ((V *)Rv13)[Rv14]=NULL;
              }
              Rv14++;
            }
            break;
            case 7:Ra.sl[71]=1760; /* line # 1760 */
            Ra.sl[73]=P_get_intexpr(0);
            Ra.sl[71]=1761; /* line # 1761 */
            Rv16=((V *)F_val)[1];
            Ra.sl[71]=1762; /* line # 1762 */
            Rv17=1;
            for( Rf0=((SL *)Rv16)[0];Rf0>0;Rf0-- ) {
              ((SL *)Rv16)[Rv17]=Ra.sl[73];
              Rv17++;
            }
            break;
            case 8:Ra.sl[71]=1765; /* line # 1765 */
            Ra.g[37]=P_get_fltexpr(0.000000E-01);
            Ra.sl[71]=1766; /* line # 1766 */
            Rv18=((V *)F_val)[1];
            Ra.sl[71]=1767; /* line # 1767 */
            Rv19=1;
            for( Rf0=((SL *)Rv18)[0];Rf0>0;Rf0-- ) {
              ((G *)Rv18)[Rv19]=Ra.g[37];
              Rv19++;
            }
            Ra.sl[71]=1768; /* line # 1768 */
            if (Ra.ub[4]) {
              Ra.sl[71]=1770; /* line # 1770 */
              if (V_sy_sym.ub[0]==21) {
                P_insymbol();
                Ra.g[38]=P_get_fltexpr(0.000000E-01);
              }
              else {
                Ra.sl[71]=1771; /* line # 1771 */
                Ra.g[38]=0.000000000000000E-001;
              }
              Ra.sl[71]=1772; /* line # 1772 */
              Rv20=((V *)F_val)[2];
              Ra.sl[71]=1773; /* line # 1773 */
              Rv21=1;
              for( Rf0=((SL *)Rv20)[0];Rf0>0;Rf0-- ) {
                ((G *)Rv20)[Rv21]=Ra.g[38];
                Rv21++;
              }
            }
            break;
            default:break;
          }
        }
      }
      break;
      default:Ra.sl[71]=1783; /* line # 1783 */
      P_src_error_s(Rd.s+2581,91,3, F_pname,Rv1);
      Ra.sl[71]=1784; /* line # 1784 */
      P_skip_symbol(18);
      break;
    }
  }
  else {
    Ra.sl[71]=1787; /* line # 1787 */
    ((UB *)F_val)[1]=11;
  }
  PAS__curr_cntx=Ra.v[68];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " exp_getkinds "  */
UB P_exp_getkinds(SL F_ish){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2599;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1801; /* line # 1801 */
  Rv0=11;
  Ra.sl[3]=1802; /* line # 1802 */
  F_ish=Ri.sl[0]-F_ish;
  Ra.sl[3]=1803; /* line # 1803 */
  if (F_ish>0) Rv0=Rs.ub[F_ish*48-23];
  else {
    Ra.sl[3]=1804; /* line # 1804 */
    P_src_error(Rd.s+2615,8,3);
  }
  Ra.sl[3]=1805; /* line # 1805 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " check_lvalue_ref "  */
void P_check_lvalue_ref(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2619;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1814; /* line # 1814 */
  if (V_debug_exp) {
    Ra.sl[3]=1815; /* line # 1815 */
    Rv0=V_lst_current;
    Ra.sl[3]=1817; /* line # 1817 */
    PAS__SELECT_OUT(((V *)Rv0)[13]);
    PAS__WRITE_STR(Rd.s+2637,-1,-1,32);
    Ra.sl[3]=1818; /* line # 1818 */
    if (((V *)F_rec)[0]==NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+2653,-1,-1,32);
    }
    else {
      Ra.sl[3]=1820; /* line # 1820 */
      Rv1=((V *)F_rec)[0];
      Ra.sl[3]=1821; /* line # 1821 */
      if (((V *)Rv1)[0]!=NULL) {
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_CHAR(34);
        PAS__WRITE_STR(((V *)Rv1)[0],-1,-1,32);
        PAS__WRITE_CHAR(34);
      }
      else {
        Ra.sl[3]=1822; /* line # 1822 */
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_STR(Rd.s+2678,-1,-1,32);
      }
    }
    Ra.sl[3]=1823; /* line # 1823 */
    PAS__SELECT_OUT(((V *)Rv0)[13]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1825; /* line # 1825 */
  if (((V *)F_rec)[0]==NULL) P_src_error(Rd.s+2707,111,3);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_exp_refer "  */
void P_get_exp_refer(V F_rec, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2711;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1834; /* line # 1834 */
  Ri.v[119]=F_ide;
  Ra.sl[3]=1835; /* line # 1835 */
  P_get_expression(F_rec);
  Ra.sl[3]=1836; /* line # 1836 */
  P_check_lvalue_ref(F_rec);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " extract_value "  */
void P_extract_value(V F_rec, UB *F_frm, SL *F_iv, G *F_rv, G *F_sg, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2726;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1852; /* line # 1852 */
  if (V_debug_exp) {
    PAS__SELECT_OUT(((V *)V_lst_current)[13]);
    PAS__WRITE_STR(Rd.s+2741,-1,-1,32);
    Write_Exp_Rec(F_rec);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=1853; /* line # 1853 */
  Rv0=F_rec+24;
  Ra.sl[3]=1855; /* line # 1855 */
  switch (((UB *)Rv0)[1]) {
    case 0:
    case 3:Ra.sl[3]=1858; /* line # 1858 */
    if (((UB *)Rv0)[1]==3) {
      Ra.sl[3]=1859; /* line # 1859 */
      if (((V *)Rv0)[1]!=NULL) ((V *)Rv0)[1]=((V *)((V *)Rv0)[1])[(((SL *)F_rec)
      [4]+1)];
      else {
        Ra.sl[3]=1860; /* line # 1860 */
        ((V *)Rv0)[1]=NULL;
      }
    }
    Ra.sl[3]=1861; /* line # 1861 */
    (*F_frm)=0;
    Ra.sl[3]=1862; /* line # 1862 */
    if (((V *)Rv0)[1]!=NULL) {
      Ra.sl[3]=1864; /* line # 1864 */
      PAS__STR_TO_STR(F_st,((V *)Rv0)[1]);
      Ra.sl[3]=1865; /* line # 1865 */
      if (((V *)F_rec)[0]==NULL) {
        Ra.sl[3]=1866; /* line # 1866 */
        PAS__DISPOSE(((V *)Rv0)+1);
        ((V *)Rv0)[1]=NULL;
      }
    }
    else {
      Ra.sl[3]=1867; /* line # 1867 */
      ((UB *)F_st)[1]=0;
    }
    break;
    case 1:
    case 4:Ra.sl[3]=1872; /* line # 1872 */
    if (((UB *)Rv0)[1]==4) {
      Ra.sl[3]=1873; /* line # 1873 */
      if (((V *)Rv0)[1]!=NULL) ((SL *)Rv0)[1]=((SL *)((V *)Rv0)[1])[(((SL *)F_rec)
      [4]+1)];
      else {
        Ra.sl[3]=1874; /* line # 1874 */
        ((SL *)Rv0)[1]=0;
      }
    }
    Ra.sl[3]=1875; /* line # 1875 */
    (*F_frm)=1;
    (*F_iv)=((SL *)Rv0)[1];
    break;
    case 2:
    case 5:Ra.sl[3]=1880; /* line # 1880 */
    if (((UB *)Rv0)[1]==5) {
      Ra.sl[3]=1882; /* line # 1882 */
      if (((V *)Rv0)[1]!=NULL) ((G *)Rv0)[1]=((G *)((V *)Rv0)[1])[(((SL *)F_rec)
      [4]+1)];
      else {
        Ra.sl[3]=1883; /* line # 1883 */
        ((G *)Rv0)[1]=0.000000000000000E-001;
      }
      Ra.sl[3]=1884; /* line # 1884 */
      if (((V *)Rv0)[2]!=NULL) ((G *)Rv0)[2]=((G *)((V *)Rv0)[2])[(((SL *)F_rec)
      [4]+1)];
      else {
        Ra.sl[3]=1885; /* line # 1885 */
        ((G *)Rv0)[2]=0.000000000000000E-001;
      }
    }
    Ra.sl[3]=1887; /* line # 1887 */
    (*F_frm)=2;
    Ra.sl[3]=1888; /* line # 1888 */
    (*F_rv)=((G *)Rv0)[1];
    break;
    default:Ra.sl[3]=1892; /* line # 1892 */
    if (((UB *)Rv0)[1]!=11) P_src_error(Rd.s+2763,112,3);
    Ra.sl[3]=1893; /* line # 1893 */
    (*F_frm)=11;
    break;
  }
  Ra.sl[3]=1895; /* line # 1895 */
  ((UB *)Rv0)[1]=11;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " extract_str "  */
void P_extract_str(V F_rec, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2767;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1910; /* line # 1910 */
  P_extract_value(F_rec,&Rv0, &Rv1, &Rv2, &Rv3, F_st);
  Ra.sl[3]=1911; /* line # 1911 */
  switch (Rv0) {
    case 0:break;
    case 2:Ra.sl[3]=1913; /* line # 1913 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_DBLE(Rv2,24,-15,0);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=1914; /* line # 1914 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_INT(Rv1,12,0);
    PAS__WRITE_EOLN();
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " extract_int "  */
SL P_extract_int(V F_rec, SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  G Rv1;
  G Rv2;
  register G Rgg;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2780;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=1930; /* line # 1930 */
  P_extract_value(F_rec,&Rv0, &F_iv, &Rv1, &Rv2, Ra.s);
  Ra.sl[68]=1931; /* line # 1931 */
  switch (Rv0) {
    case 0:Ra.sl[68]=1932; /* line # 1932 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_SL(&F_iv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=1933; /* line # 1933 */
      F_iv=0;
    }
    break;
    case 2:Ra.sl[68]=1934; /* line # 1934 */
    F_iv=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
    break;
    case 1:break;
    default:break;
  }
  Ra.sl[68]=1938; /* line # 1938 */
  Ret=F_iv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " extract_flt "  */
G P_extract_flt(V F_rec, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  register G Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2793;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=1953; /* line # 1953 */
  P_extract_value(F_rec,&Rv0, &Rv1, &F_rv, &Rv2, Ra.s);
  Ra.sl[68]=1954; /* line # 1954 */
  switch (Rv0) {
    case 0:Ra.sl[68]=1955; /* line # 1955 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_DBLE(&F_rv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=1956; /* line # 1956 */
      F_rv=0.000000000000000E-001;
    }
    break;
    case 2:break;
    case 1:Ra.sl[68]=1958; /* line # 1958 */
    F_rv=(double)Rv1;
    break;
    default:break;
  }
  Ra.sl[68]=1961; /* line # 1961 */
  Ret=F_rv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " get_exp_value "  */
void P_get_exp_value(UB *F_frm, SL *F_iv, G *F_rv, G *F_sg, V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2806;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1978; /* line # 1978 */
  Rv0=Ri.sl[0];
  Ra.sl[3]=1979; /* line # 1979 */
  P_get_expression(V_exp_rs0.s);
  Ra.sl[3]=1980; /* line # 1980 */
  P_extract_value(V_exp_rs0.s,F_frm,F_iv,F_rv,F_sg,F_st);
  Ra.sl[3]=1981; /* line # 1981 */
  if (Rv0!=Ri.sl[0]) {
    Ra.sl[3]=1983; /* line # 1983 */
    P_src_error(Rd.s+2823,9,2);
    Ra.sl[3]=1984; /* line # 1984 */
    Ri.sl[0]=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_strexpr "  */
void P_get_strexpr(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2827;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1999; /* line # 1999 */
  P_get_exp_value(&Rv0, &Rv1, &Rv2, &Rv3, F_st);
  Ra.sl[3]=2000; /* line # 2000 */
  switch (Rv0) {
    case 0:break;
    case 2:Ra.sl[3]=2002; /* line # 2002 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_DBLE(Rv2,24,-15,0);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=2003; /* line # 2003 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_INT(Rv1,12,0);
    PAS__WRITE_EOLN();
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_intexpr "  */
SL P_get_intexpr(SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  G Rv1;
  G Rv2;
  register G Rgg;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2840;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=2019; /* line # 2019 */
  P_get_exp_value(&Rv0, &F_iv, &Rv1, &Rv2, Ra.s);
  Ra.sl[68]=2020; /* line # 2020 */
  switch (Rv0) {
    case 0:Ra.sl[68]=2021; /* line # 2021 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_SL(&F_iv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=2022; /* line # 2022 */
      F_iv=0;
    }
    break;
    case 2:Ra.sl[68]=2023; /* line # 2023 */
    F_iv=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
    break;
    case 1:break;
    default:break;
  }
  Ra.sl[68]=2027; /* line # 2027 */
  Ret=F_iv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " get_fltexpr "  */
G P_get_fltexpr(G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  register G Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2853;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=2042; /* line # 2042 */
  P_get_exp_value(&Rv0, &Rv1, &F_rv, &Rv2, Ra.s);
  Ra.sl[68]=2043; /* line # 2043 */
  switch (Rv0) {
    case 0:Ra.sl[68]=2044; /* line # 2044 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_DBLE(&F_rv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=2045; /* line # 2045 */
      F_rv=0.000000000000000E-001;
    }
    break;
    case 2:break;
    case 1:Ra.sl[68]=2047; /* line # 2047 */
    F_rv=(double)Rv1;
    break;
    default:break;
  }
  Ra.sl[68]=2050; /* line # 2050 */
  Ret=F_rv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " get_numexpr "  */
void P_get_numexpr(UB *F_bf, SL *F_iv, G *F_rv, G *F_sg){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+2866;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=2065; /* line # 2065 */
  P_get_exp_value(&Rv0, F_iv,F_rv,F_sg,Ra.s);
  Ra.sl[68]=2066; /* line # 2066 */
  switch (Rv0) {
    case 0:Ra.sl[68]=2068; /* line # 2068 */
    (*F_bf)=0;
    Ra.sl[68]=2069; /* line # 2069 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_SL(F_iv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=2070; /* line # 2070 */
      (*F_iv)=0;
    }
    break;
    case 1:Ra.sl[68]=2072; /* line # 2072 */
    (*F_bf)=0;
    break;
    case 2:Ra.sl[68]=2073; /* line # 2073 */
    (*F_bf)=1;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " call_if_function "  */
void MXD_DCPEXPR_call_if_function(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2879;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2085; /* line # 2085 */
  Ra.sl[3]=2087; /* line # 2087 */
  P_insymbol();
  Ra.sl[3]=2088; /* line # 2088 */
  if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+2899,22,2);
  else {
    Ra.sl[3]=2089; /* line # 2089 */
    P_insymbol();
  }
  Ra.sl[3]=2090; /* line # 2090 */
  P_get_expression(V_exp_res.s);
  Ra.sl[3]=2091; /* line # 2091 */
  if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+2899,29,2);
  else {
    Ra.sl[3]=2092; /* line # 2092 */
    P_insymbol();
  }
  Ra.sl[3]=2093; /* line # 2093 */
  if (262144&V_exp_res.ul[5]) {
    Ra.sl[3]=2095; /* line # 2095 */
    if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) P_exp_putflt(0.000000E-01,0.000000000000000E-001);
    else {
      Ra.sl[3]=2096; /* line # 2096 */
      P_expression();
    }
    Ra.sl[3]=2097; /* line # 2097 */
    if (!(262144&V_exp_res.ul[5])) P_out_pcd_vref((Rs.s+Ri.sl[0]*48-48),0);
    Ra.sl[3]=2098; /* line # 2098 */
    MXD_DCPEXPR_stack_remove(1);
    Ra.sl[3]=2099; /* line # 2099 */
    if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+2899,29,2);
    else {
      Ra.sl[3]=2100; /* line # 2100 */
      P_insymbol();
    }
    Ra.sl[3]=2101; /* line # 2101 */
    if (V_sy_sym.ub[0]==14) P_exp_putflt(0.000000E-01,0.000000000000000E-001);
    else {
      Ra.sl[3]=2102; /* line # 2102 */
      P_expression();
    }
    Ra.sl[3]=2103; /* line # 2103 */
    if (!(262144&V_exp_res.ul[5])) P_out_pcd_vref((Rs.s+Ri.sl[0]*48-48),0);
    Ra.sl[3]=2104; /* line # 2104 */
    P_out_nd_code(69);
  }
  else {
    Ra.sl[3]=2107; /* line # 2107 */
    if (P_extract_int(V_exp_res.s,0)>0) {
      Ra.sl[3]=2109; /* line # 2109 */
      if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) P_exp_putint(0);
      else {
        Ra.sl[3]=2110; /* line # 2110 */
        P_expression();
      }
      Ra.sl[3]=2111; /* line # 2111 */
      P_skip_symbol(14);
    }
    else {
      Ra.sl[3]=2115; /* line # 2115 */
      if (V_sy_sym.ub[0]!=17) P_skip_symbol(17);
      Ra.sl[3]=2116; /* line # 2116 */
      if (V_sy_sym.ub[0]==17) {
        P_insymbol();
        P_expression();
      }
      else {
        Ra.sl[3]=2117; /* line # 2117 */
        P_exp_putint(0);
      }
    }
  }
  Ra.sl[3]=2119; /* line # 2119 */
  if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+2899,23,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " arrsca_ss_assign "  */
void P_arrsca_ss_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register UB Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2903;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2131; /* line # 2131 */
  Rv0=F_dst+24;
  Ra.sl[3]=2133; /* line # 2133 */
  Rv1=((SL *)F_dst)[4]+1;
  Ra.sl[3]=2134; /* line # 2134 */
  if (((V *)F_dst)[1]!=NULL) {
    Ra.sl[3]=2135; /* line # 2135 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[3]=2136; /* line # 2136 */
    for( Rf0=((SL *)F_dst)[3];Rf0>0;Rf0-- ) {
      Ra.sl[3]=2138; /* line # 2138 */
      if (((V *)Rv2)[Rv1]!=NULL) PAS__DISPOSE((((V *)Rv2)+Rv1));
      Ra.sl[3]=2139; /* line # 2139 */
      if (((V *)F_src)[7]!=NULL) {
        Ra.sl[3]=2140; /* line # 2140 */
        if (((V *)F_src)[0]==NULL) {
          Ra.sl[3]=2142; /* line # 2142 */
          ((V *)Rv2)[Rv1]=((V *)F_src)[7];
        }
        else {
          Ra.sl[3]=2145; /* line # 2145 */
          Rv3=((UB *)((V *)F_src)[7])[1];
          ((V *)Rv2)[Rv1]=PAS__NEW((SL)Rv3+2);
          ((UB *)((V *)Rv2)[Rv1])[0]=Rv3;
          Ra.sl[3]=2146; /* line # 2146 */
          PAS__STR_TO_STR(((V *)Rv2)[Rv1],((V *)F_src)[7]);
        }
      }
      else {
        Ra.sl[3]=2148; /* line # 2148 */
        ((V *)Rv2)[Rv1]=NULL;
      }
      Ra.sl[3]=2149; /* line # 2149 */
      Rv1=Rv1+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " arrsca_ii_assign "  */
void P_arrsca_ii_assign(SL F_vsrc, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2921;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2162; /* line # 2162 */
  Rv0=F_dst+24;
  Ra.sl[3]=2164; /* line # 2164 */
  Rv1=((SL *)F_dst)[4]+1;
  Ra.sl[3]=2165; /* line # 2165 */
  if (((V *)Rv0)[1]!=NULL) {
    Ra.sl[3]=2166; /* line # 2166 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[3]=2167; /* line # 2167 */
    for( Rf0=((SL *)F_dst)[3];Rf0>0;Rf0-- ) {
      Ra.sl[3]=2169; /* line # 2169 */
      ((SL *)Rv2)[Rv1]=F_vsrc;
      Rv1=Rv1+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " arrsca_ff_assign "  */
void P_arrsca_ff_assign(G F_vval, G F_vsig, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2939;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2182; /* line # 2182 */
  Rv0=F_dst+24;
  Ra.sl[3]=2184; /* line # 2184 */
  Rv1=((SL *)F_dst)[4]+1;
  Ra.sl[3]=2185; /* line # 2185 */
  if (((V *)Rv0)[1]!=NULL) {
    Ra.sl[3]=2186; /* line # 2186 */
    Rv2=((V *)Rv0)[1];
    Ra.sl[3]=2187; /* line # 2187 */
    for( Rf0=((SL *)F_dst)[3];Rf0>0;Rf0-- ) {
      Ra.sl[3]=2189; /* line # 2189 */
      ((G *)Rv2)[Rv1]=F_vval;
      Ra.sl[3]=2190; /* line # 2190 */
      if (((V *)Rv0)[2]!=NULL) ((G *)((V *)Rv0)[2])[Rv1]=F_vsig;
      Ra.sl[3]=2191; /* line # 2191 */
      Rv1=Rv1+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def_match "  */
void MXD_DCPEXPR_array_def_match(V F_src, V F_dst, SL *F_siz, UB *F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 112 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_src,48);
  memcpy( Ra.s+64,F_dst,48);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2957;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2208; /* line # 2208 */
  Rv0=1;
  Ra.sl[3]=2209; /* line # 2209 */
  Rv1=Ra.v[5];
  Ra.sl[3]=2210; /* line # 2210 */
  Rv2=Ra.v[17];
  Ra.sl[3]=2211; /* line # 2211 */
  if (Ra.sl[7]==Ra.sl[19]) {
    Ra.sl[3]=2212; /* line # 2212 */
    while ((((((UB *)Rv1)[24]==3&&((UB *)Rv2)[24]==3)&&Rv1!=NULL)&&Rv2!=NULL)&&Rv0)
    {
      Ra.sl[3]=2215; /* line # 2215 */
      Rv0=((SL *)Rv1)[8]==((SL *)Rv2)[8]&&((SL *)Rv1)[9]==((SL *)Rv2)[9];
      Ra.sl[3]=2217; /* line # 2217 */
      Rv1=((V *)Rv1)[7];
      Ra.sl[3]=2218; /* line # 2218 */
      Rv2=((V *)Rv2)[7];
    }
  }
  else {
    Ra.sl[3]=2220; /* line # 2220 */
    Rv0=0;
  }
  Ra.sl[3]=2221; /* line # 2221 */
  (*F_flg)=Rv0&&Rv1==Rv2;
  Ra.sl[3]=2222; /* line # 2222 */
  if (!(*F_flg)) P_src_error(Rd.s+2976,78,3);
  Ra.sl[3]=2223; /* line # 2223 */
  (*F_siz)=Ra.sl[19];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_ss_assign "  */
void P_array_ss_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  SL Rv5;
  register UB Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2980;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2237; /* line # 2237 */
  MXD_DCPEXPR_array_def_match(F_src,F_dst,&Rv0, &Rv1);
  Ra.sl[3]=2238; /* line # 2238 */
  if ((Rv1&&((V *)F_src)[1]!=NULL)&&((V *)F_dst)[1]!=NULL) {
    Ra.sl[3]=2240; /* line # 2240 */
    Rv2=((V *)F_src)[7];
    Ra.sl[3]=2241; /* line # 2241 */
    Rv3=((SL *)F_src)[4];
    Ra.sl[3]=2242; /* line # 2242 */
    Rv4=((V *)F_dst)[7];
    Ra.sl[3]=2243; /* line # 2243 */
    Rv5=((SL *)F_dst)[4];
    Ra.sl[3]=2244; /* line # 2244 */
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=2246; /* line # 2246 */
      Rv5=Rv5+1;
      Rv3=Rv3+1;
      Ra.sl[3]=2247; /* line # 2247 */
      if (((V *)Rv4)[Rv3]!=NULL) PAS__DISPOSE((((V *)Rv4)+Rv5));
      Ra.sl[3]=2248; /* line # 2248 */
      if (((V *)Rv2)[Rv3]!=NULL) {
        Ra.sl[3]=2250; /* line # 2250 */
        Rv6=((UB *)((V *)Rv2)[Rv3])[1];
        ((V *)Rv4)[Rv5]=PAS__NEW((SL)Rv6+2);
        ((UB *)((V *)Rv4)[Rv5])[0]=Rv6;
        Ra.sl[3]=2251; /* line # 2251 */
        PAS__STR_TO_STR(((V *)Rv4)[Rv5],((V *)Rv2)[Rv3]);
      }
      else {
        Ra.sl[3]=2253; /* line # 2253 */
        ((V *)Rv4)[Rv5]=NULL;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_ii_assign "  */
void P_array_ii_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2997;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2269; /* line # 2269 */
  MXD_DCPEXPR_array_def_match(F_src,F_dst,&Rv0, &Rv1);
  Ra.sl[3]=2270; /* line # 2270 */
  if ((Rv1&&((V *)F_src)[7]!=NULL)&&((V *)F_dst)[7]!=NULL) {
    Ra.sl[3]=2272; /* line # 2272 */
    Rv2=((V *)F_src)[7];
    Ra.sl[3]=2273; /* line # 2273 */
    Rv3=((SL *)F_src)[4];
    Ra.sl[3]=2274; /* line # 2274 */
    Rv4=((V *)F_dst)[7];
    Ra.sl[3]=2275; /* line # 2275 */
    Rv5=((SL *)F_dst)[4];
    Ra.sl[3]=2276; /* line # 2276 */
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=2278; /* line # 2278 */
      Rv5=Rv5+1;
      Rv3=Rv3+1;
      Ra.sl[3]=2279; /* line # 2279 */
      ((SL *)Rv4)[Rv5]=((SL *)Rv2)[Rv3];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_fi_assign "  */
void P_array_fi_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  SL Rv5;
  register G Rgg;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3014;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2296; /* line # 2296 */
  MXD_DCPEXPR_array_def_match(F_src,F_dst,&Rv0, &Rv1);
  Ra.sl[3]=2297; /* line # 2297 */
  if ((Rv1&&((V *)F_src)[7]!=NULL)&&((V *)F_dst)[7]!=NULL) {
    Ra.sl[3]=2299; /* line # 2299 */
    Rv2=((V *)F_src)[7];
    Ra.sl[3]=2300; /* line # 2300 */
    Rv3=((SL *)F_src)[4];
    Ra.sl[3]=2301; /* line # 2301 */
    Rv4=((V *)F_dst)[7];
    Ra.sl[3]=2302; /* line # 2302 */
    Rv5=((SL *)F_dst)[4];
    Ra.sl[3]=2303; /* line # 2303 */
    Rv5=((SL *)F_dst)[4];
    Ra.sl[3]=2304; /* line # 2304 */
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=2306; /* line # 2306 */
      Rv5=Rv5+1;
      Rv3=Rv3+1;
      Ra.sl[3]=2307; /* line # 2307 */
      ((SL *)Rv4)[Rv5]=PAS__G_ROUND(((G *)Rv2)[Rv3]);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_if_assign "  */
void P_array_if_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3031;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2324; /* line # 2324 */
  MXD_DCPEXPR_array_def_match(F_src,F_dst,&Rv0, &Rv1);
  Ra.sl[3]=2325; /* line # 2325 */
  if ((Rv1&&((V *)F_src)[7]!=NULL)&&((V *)F_dst)[7]!=NULL) {
    Ra.sl[3]=2327; /* line # 2327 */
    Rv2=((V *)F_src)[7];
    Ra.sl[3]=2328; /* line # 2328 */
    Rv3=((SL *)F_src)[4];
    Ra.sl[3]=2329; /* line # 2329 */
    Rv4=((V *)F_dst)[7];
    Ra.sl[3]=2330; /* line # 2330 */
    Rv5=((V *)F_dst)[8];
    Ra.sl[3]=2331; /* line # 2331 */
    Rv6=((SL *)F_dst)[4];
    Ra.sl[3]=2332; /* line # 2332 */
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=2334; /* line # 2334 */
      Rv6=Rv6+1;
      Rv3=Rv3+1;
      Ra.sl[3]=2335; /* line # 2335 */
      ((G *)Rv4)[Rv6]=(double)((SL *)Rv2)[Rv3];
      Ra.sl[3]=2336; /* line # 2336 */
      if (Rv5!=NULL) ((G *)Rv5)[Rv6]=0.000000000000000E-001;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_ff_assign "  */
void P_array_ff_assign(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  V Rv6;
  SL Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3048;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2352; /* line # 2352 */
  MXD_DCPEXPR_array_def_match(F_src,F_dst,&Rv0, &Rv1);
  Ra.sl[3]=2353; /* line # 2353 */
  if ((Rv1&&((V *)F_src)[7]!=NULL)&&((V *)F_dst)[7]!=NULL) {
    Ra.sl[3]=2355; /* line # 2355 */
    Rv2=((V *)F_src)[7];
    Rv3=((V *)F_src)[8];
    Rv4=((SL *)F_src)[4];
    Ra.sl[3]=2356; /* line # 2356 */
    Rv5=((V *)F_dst)[7];
    Rv6=((V *)F_dst)[8];
    Rv7=((SL *)F_dst)[4];
    Ra.sl[3]=2357; /* line # 2357 */
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=2359; /* line # 2359 */
      Rv7=Rv7+1;
      Rv4=Rv4+1;
      Ra.sl[3]=2360; /* line # 2360 */
      ((G *)Rv5)[Rv7]=((G *)Rv2)[Rv4];
      Ra.sl[3]=2361; /* line # 2361 */
      if (Rv6!=NULL) {
        Ra.sl[3]=2362; /* line # 2362 */
        if (Rv3!=NULL) ((G *)Rv6)[Rv7]=((G *)Rv3)[Rv4];
        else {
          Ra.sl[3]=2363; /* line # 2363 */
          ((G *)Rv6)[Rv7]=0.000000000000000E-001;
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " in_filemode "  */
UL P_in_filemode(SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UL Rv0;
  register UL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3065;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2376; /* line # 2376 */
  if (F_iv&1) Rv0=65536;
  else {
    Ra.sl[3]=2377; /* line # 2377 */
    Rv0=0;
  }
  Ra.sl[3]=2378; /* line # 2378 */
  if (F_iv/2&1) Rv0=Rv0|32768;
  Ra.sl[3]=2379; /* line # 2379 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_put_bltval "  */
void MXD_DCPEXPR_exp_put_bltval(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3078;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2392; /* line # 2392 */
  if (Ri.sl[0]<4096) Ri.sl[0]=Ri.sl[0]+1;
  else {
    Ra.sl[3]=2393; /* line # 2393 */
    P_src_error(Rd.s+3096,6,3);
  }
  Ra.sl[3]=2394; /* line # 2394 */
  P_insymbol();
  Ra.sl[3]=2395; /* line # 2395 */
  if (F_ip!=NULL) Rv0=((V *)F_ip)[4];
  Ra.sl[3]=2396; /* line # 2396 */
  if (Rv0!=NULL) {
    Ra.sl[3]=2397; /* line # 2397 */
    Rv1=Rv0;
    Rv2=(Rs.s+Ri.sl[0]*48-48);
    Ra.sl[3]=2399; /* line # 2399 */
    ((V *)Rv2)[0]=NULL;
    Ra.sl[3]=2400; /* line # 2400 */
    ((V *)Rv2)[1]=Rv0;
    Ra.sl[3]=2401; /* line # 2401 */
    ((SL *)Rv2)[2]=0;
    Ra.sl[3]=2402; /* line # 2402 */
    ((SL *)Rv2)[4]=0;
    Ra.sl[3]=2403; /* line # 2403 */
    ((SL *)Rv2)[3]=1;
    Ra.sl[3]=2404; /* line # 2404 */
    ((UL *)Rv2)[5]=((UL *)Rv1)[5];
    Ra.sl[3]=2405; /* line # 2405 */
    P_val_allocate(Rv2+24,Rv0);
    Ra.sl[3]=2406; /* line # 2406 */
    switch (((UB *)Rv1)[24]) {
      case 3:Ra.sl[3]=2409; /* line # 2409 */
      ((SL *)Rv2)[3]=((SL *)Rv1)[8]*((SL *)Rv1)[9];
      Ra.sl[3]=2410; /* line # 2410 */
      P_get_init_val(Rv2+24,Rv0,((V *)Rv2)+1,0,((V *)F_ip)[0],0);
      break;
      case 0:
      case 1:
      case 2:Ra.sl[3]=2418; /* line # 2418 */
      if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+3096,22,2);
      Ra.sl[3]=2419; /* line # 2419 */
      P_get_init_val(Rv2+24,Rv0,((V *)Rv2)+1,0,((V *)F_ip)[0],1);
      Ra.sl[3]=2423; /* line # 2423 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+3096,23,2);
      break;
      default:Ra.sl[3]=2426; /* line # 2426 */
      P_src_error_s(Rd.s+3096,92,3,((V *)F_ip)[0],NULL);
      Ra.sl[3]=2427; /* line # 2427 */
      Ri.sl[0]=Ri.sl[0]-1;
      P_exp_putint(1);
      Ra.sl[3]=2428; /* line # 2428 */
      P_skip_symbol(13);
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_entry "  */
void MXD_DCPEXPR_exp_entry(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3100;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2445; /* line # 2445 */
  Rv0=1;
  Ra.sl[3]=2446; /* line # 2446 */
  Rv1=(Rs.s+Ri.sl[0]*48-48);
  Rv2=Rv1+24;
  Ra.sl[3]=2447; /* line # 2447 */
  switch (V_sy_sym.ub[0]) {
    case 78:
    case 79:Ra.sl[3]=2451; /* line # 2451 */
    V_sy_nomacrflg=V_sy_sym.ub[0]==79;
    Ra.sl[3]=2452; /* line # 2452 */
    P_insymbol();
    Ra.sl[3]=2453; /* line # 2453 */
    P_exp_putint(0);
    Ra.sl[3]=2454; /* line # 2454 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[3]=2455; /* line # 2455 */
      P_src_error(Rd.s+3113,22,2);
    }
    Ra.sl[3]=2456; /* line # 2456 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[3]=2458; /* line # 2458 */
      if (V_sy_nomacrflg&&V_sy_macro!=NULL) {
        Ra.sl[3]=2459; /* line # 2459 */
        switch (((UB *)V_sy_macro)[24]) {
          case 3:Ra.sl[3]=2460; /* line # 2460 */
          ((SL *)Rv2)[1]=20;
          break;
          case 1:Ra.sl[3]=2461; /* line # 2461 */
          ((SL *)Rv2)[1]=21;
          break;
          case 0:Ra.sl[3]=2462; /* line # 2462 */
          ((SL *)Rv2)[1]=22;
          break;
          case 2:Ra.sl[3]=2463; /* line # 2463 */
          ((SL *)Rv2)[1]=23;
          break;
          default:Ra.sl[3]=2465; /* line # 2465 */
          ((SL *)Rv2)[1]=-2;
          break;
        }
      }
      else {
        Ra.sl[3]=2469; /* line # 2469 */
        Rv3=P_ide_search(0,0);
        Ra.sl[3]=2470; /* line # 2470 */
        if (Rv3!=NULL) {
          Ra.sl[3]=2471; /* line # 2471 */
          switch (((UB *)Rv3)[41]) {
            case 0:Ra.sl[3]=2472; /* line # 2472 */
            ((SL *)Rv2)[1]=1;
            break;
            case 1:Ra.sl[3]=2473; /* line # 2473 */
            ((SL *)Rv2)[1]=2;
            break;
            case 2:Ra.sl[3]=2474; /* line # 2474 */
            if (131072&((UL *)Rv3)[5]) ((SL *)Rv2)[1]=4;
            else {
              Ra.sl[3]=2475; /* line # 2475 */
              ((SL *)Rv2)[1]=3;
            }
            break;
            case 6:Ra.sl[3]=2476; /* line # 2476 */
            ((SL *)Rv2)[1]=11;
            break;
            case 7:Ra.sl[3]=2477; /* line # 2477 */
            ((SL *)Rv2)[1]=12;
            break;
            case 8:Ra.sl[3]=2478; /* line # 2478 */
            if (131072&((UL *)Rv3)[5]) ((SL *)Rv2)[1]=14;
            else {
              Ra.sl[3]=2479; /* line # 2479 */
              ((SL *)Rv2)[1]=13;
            }
            break;
            default:Ra.sl[3]=2481; /* line # 2481 */
            ((SL *)Rv2)[1]=-1;
            break;
          }
        }
      }
    }
    else {
      Ra.sl[3]=2485; /* line # 2485 */
      ((SL *)Rv2)[1]=-99;
    }
    Ra.sl[3]=2486; /* line # 2486 */
    V_sy_nomacrflg=0;
    Ra.sl[3]=2487; /* line # 2487 */
    P_insymbol();
    Ra.sl[3]=2488; /* line # 2488 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+3113,23,2);
    else {
      Ra.sl[3]=2489; /* line # 2489 */
      P_insymbol();
    }
    break;
    case 61:Ra.sl[3]=2492; /* line # 2492 */
    P_exp_stk_copy(0);
    break;
    case 29:Ra.sl[3]=2494; /* line # 2494 */
    MXD_DCPEXPR_call_if_function();
    break;
    case 0:Ra.sl[3]=2498; /* line # 2498 */
    if (Ri.v[119]==NULL) Rv3=P_ide_search(1,0);
    else {
      Ra.sl[3]=2499; /* line # 2499 */
      Rv3=Ri.v[119];
      Ri.v[119]=NULL;
    }
    Ra.sl[3]=2500; /* line # 2500 */
    if (Rv3==NULL) P_exp_putint(0);
    else {
      Ra.sl[3]=2502; /* line # 2502 */
      Rv4=Rv3;
      Ra.sl[3]=2503; /* line # 2503 */
      switch (((UB *)Rv4)[25]) {
        case 5:
        case 6:Ra.sl[3]=2506; /* line # 2506 */
        P_exp_generic_call(Rv3,1);
        Ra.sl[3]=2507; /* line # 2507 */
        Rv0=0;
        break;
        case 1:
        case 2:
        case 3:Ra.sl[3]=2512; /* line # 2512 */
        MXD_DCPEXPR_exp_put_refer(Rv3);
        break;
        case 4:Ra.sl[3]=2514; /* line # 2514 */
        MXD_DCPEXPR_exp_put_formal(Rv3);
        break;
        case 0:Ra.sl[3]=2516; /* line # 2516 */
        MXD_DCPEXPR_exp_put_bltval(Rv3);
        break;
        default:break;
      }
    }
    break;
    case 64:Ra.sl[3]=2522; /* line # 2522 */
    P_fnc_select();
    break;
    case 65:Ra.sl[3]=2523; /* line # 2523 */
    P_fnc_integr();
    break;
    case 66:Ra.sl[3]=2524; /* line # 2524 */
    P_fnc_summation();
    break;
    case 67:Ra.sl[3]=2525; /* line # 2525 */
    P_fnc_summdata();
    break;
    case 1:Ra.sl[3]=2527; /* line # 2527 */
    P_exp_putint(V_sy_ival);
    break;
    case 2:
    case 3:Ra.sl[3]=2529; /* line # 2529 */
    P_exp_putflt(V_sy_rval,0.000000000000000E-001);
    break;
    case 4:Ra.sl[3]=2530; /* line # 2530 */
    P_exp_putstr(V_sy_string.s);
    break;
    case 14:
    case 16:
    case 17:
    case 18:
    case 28:Ra.sl[3]=2535; /* line # 2535 */
    MXD_DCPEXPR_exp_put_refer(NULL);
    Ra.sl[3]=2536; /* line # 2536 */
    Rv0=0;
    break;
    default:Ra.sl[3]=2540; /* line # 2540 */
    P_src_error(Rd.s+3113,42,2);
    break;
  }
  Ra.sl[3]=2543; /* line # 2543 */
  if (V_debug_exp) {
    PAS__SELECT_OUT(((V *)V_lst_current)[13]);
    PAS__WRITE_STR(Rd.s+3117,-1,-1,32);
    Write_Exp_Rec((Rs.s+Ri.sl[0]*48-48));
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=2545; /* line # 2545 */
  if (Rv0) P_insymbol();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_index "  */
void MXD_DCPEXPR_exp_index(UB F_itmf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  SL Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3136;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2560; /* line # 2560 */
  Rv0=0;
  Ra.sl[3]=2561; /* line # 2561 */
  Rv1=(Rs.s+Ri.sl[0]*48-48);
  Rv2=Rv1+24;
  Ra.sl[3]=2562; /* line # 2562 */
  if (((V *)Rv1)[1]!=NULL) {
    Ra.sl[3]=2563; /* line # 2563 */
    Rv3=((V *)Rv1)[1];
    Ra.sl[3]=2564; /* line # 2564 */
    if (((UB *)Rv3)[24]!=3) {
      Ra.sl[3]=2566; /* line # 2566 */
      P_src_error(Rd.s+3149,113,3);
      Ra.sl[3]=2567; /* line # 2567 */
      Rv0=1;
    }
    else {
      Ra.sl[3]=2571; /* line # 2571 */
      Rv4=P_get_intexpr(((SL *)Rv3)[10]-1)-((SL *)Rv3)[10];
      Ra.sl[3]=2572; /* line # 2572 */
      if (Rv4<0||Rv4>=((SL *)Rv3)[9]) {
        Ra.sl[3]=2574; /* line # 2574 */
        P_src_error(Rd.s+3149,71,2);
        Ra.sl[3]=2575; /* line # 2575 */
        Rv4=0;
      }
      Ra.sl[3]=2577; /* line # 2577 */
      ((SL *)Rv1)[4]=((SL *)Rv1)[4]+Rv4*((SL *)Rv3)[8];
      Ra.sl[3]=2578; /* line # 2578 */
      if (V_sy_sym.ub[0]==20) {
        Ra.sl[3]=2580; /* line # 2580 */
        P_insymbol();
        Ra.sl[3]=2581; /* line # 2581 */
        Rv5=P_get_intexpr(Rv4)-((SL *)Rv3)[10];
        Ra.sl[3]=2582; /* line # 2582 */
        if (Rv5<Rv4||Rv5>=((SL *)Rv3)[9]) {
          Ra.sl[3]=2584; /* line # 2584 */
          P_src_error(Rd.s+3149,80,2);
          Ra.sl[3]=2585; /* line # 2585 */
          Rv5=(((SL *)Rv3)[9]-Rv4)+1;
        }
        Ra.sl[3]=2587; /* line # 2587 */
        ((SL *)Rv1)[3]=((SL *)Rv3)[8]*((Rv5-Rv4)+1);
      }
      else {
        Ra.sl[3]=2591; /* line # 2591 */
        ((SL *)Rv1)[3]=((SL *)Rv3)[8];
        Ra.sl[3]=2592; /* line # 2592 */
        ((V *)Rv1)[1]=((V *)Rv3)[7];
        Ra.sl[3]=2593; /* line # 2593 */
        if (((V *)Rv1)[1]!=NULL) {
          Ra.sl[3]=2594; /* line # 2594 */
          switch (((UB *)((V *)Rv1)[1])[24]) {
            case 0:Ra.sl[3]=2595; /* line # 2595 */
            ((UB *)Rv2)[1]=3;
            break;
            case 1:Ra.sl[3]=2596; /* line # 2596 */
            ((UB *)Rv2)[1]=4;
            break;
            case 2:Ra.sl[3]=2597; /* line # 2597 */
            ((UB *)Rv2)[1]=5;
            break;
            default:break;
          }
        }
        Ra.sl[3]=2600; /* line # 2600 */
        if (V_exp_nva&&!F_itmf) {
          Ra.sl[3]=2601; /* line # 2601 */
          if (((UB *)Rv2)[1]==5) {
            Ra.sl[3]=2602; /* line # 2602 */
            if (131072&((UL *)Rv1)[5]) {
              Ra.sl[3]=2603; /* line # 2603 */
              P_out_pcd_vref((Rs.s+Ri.sl[0]*48-48),0);
            }
          }
        }
      }
    }
  }
  Ra.sl[3]=2606; /* line # 2606 */
  if (Rv0) P_skip_symbol(16);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_field "  */
void MXD_DCPEXPR_exp_field(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3153;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2626; /* line # 2626 */
  Rv0=(Rs.s+Ri.sl[0]*48-48);
  Ra.sl[3]=2627; /* line # 2627 */
  if (((V *)Rv0)[0]!=NULL&&((V *)Rv0)[1]!=NULL) {
    Ra.sl[3]=2629; /* line # 2629 */
    if (((UB *)((V *)Rv0)[1])[24]==2&&PAS__EQ_STR(V_sy_ident.s,Rd.s+3164)) {
      Ra.sl[3]=2630; /* line # 2630 */
      Rv1=Rv0+24;
      Ra.sl[3]=2632; /* line # 2632 */
      P_insymbol();
      Ra.sl[3]=2633; /* line # 2633 */
      if (((UB *)Rv1)[1]==5) {
        Ra.sl[3]=2634; /* line # 2634 */
        if (((V *)Rv1)[2]==NULL) {
          ((UB *)Rv1)[1]=2;
          ((G *)Rv1)[1]=0.000000000000000E-001;
          ((G *)Rv1)[2]=0.000000000000000E-001;
        }
        else {
          Ra.sl[3]=2635; /* line # 2635 */
          ((V *)Rv1)[1]=((V *)Rv1)[2];
          ((V *)Rv1)[2]=NULL;
        }
      }
      else {
        Ra.sl[3]=2636; /* line # 2636 */
        ((G *)Rv1)[1]=((G *)Rv1)[2];
        ((G *)Rv1)[2]=0.000000000000000E-001;
      }
    }
    else {
      Ra.sl[3]=2639; /* line # 2639 */
      if (((UB *)((V *)Rv0)[1])[24]==6) {
        Ra.sl[3]=2641; /* line # 2641 */
        Rv2=((SL *)Rv0)[2];
        Ra.sl[3]=2642; /* line # 2642 */
        Rv3=((V *)Rv0)[1];
        Ra.sl[3]=2643; /* line # 2643 */
        Rv4=P_level_search(((V *)Rv3)[7]);
        Ra.sl[3]=2644; /* line # 2644 */
        P_insymbol();
        Ra.sl[3]=2645; /* line # 2645 */
        if (Rv4==NULL) {
          Ra.sl[3]=2647; /* line # 2647 */
          P_src_error_s(Rd.s+3169,63,2, V_sy_ident.s,((V *)((V *)Rv0)[0])[0]);
          Ra.sl[3]=2648; /* line # 2648 */
          ((V *)Rv0)[1]=V_int_typ;
          ((UB *)Rv0)[25]=1;
          ((SL *)Rv0)[7]=0;
        }
        else {
          Ra.sl[3]=2652; /* line # 2652 */
          ((V *)Rv0)[1]=((V *)Rv4)[4];
          Ra.sl[3]=2653; /* line # 2653 */
          Rv5=((V *)Rv0)[7];
          Ra.sl[3]=2654; /* line # 2654 */
          if (Rv5!=NULL) {
            Ra.sl[3]=2656; /* line # 2656 */
            memcpy(Rv0+24,(((S *)Rv5)+((SL *)Rv4)[8]*24+24),24);
            Ra.sl[3]=2657; /* line # 2657 */
            Rv2=((SL *)Rv5)[11];
          }
          else {
            Ra.sl[3]=2660; /* line # 2660 */
            Rv6=Rv0+24;
            Ra.sl[3]=2662; /* line # 2662 */
            ((UB *)Rv6)[0]=0;
            Ra.sl[3]=2663; /* line # 2663 */
            ((UB *)Rv6)[1]=P_get_val_forms(Rv3);
            Ra.sl[3]=2664; /* line # 2664 */
            switch (((UB *)Rv6)[1]) {
              case 6:Ra.sl[3]=2665; /* line # 2665 */
              ((V *)Rv6)[1]=NULL;
              break;
              case 7:Ra.sl[3]=2666; /* line # 2666 */
              ((V *)Rv6)[1]=NULL;
              break;
              case 8:Ra.sl[3]=2667; /* line # 2667 */
              ((V *)Rv6)[1]=NULL;
              ((V *)Rv6)[2]=NULL;
              break;
              default:break;
            }
          }
          Ra.sl[3]=2672; /* line # 2672 */
          Rv7=((V *)Rv0)[1];
          Ra.sl[3]=2673; /* line # 2673 */
          if (((UB *)Rv7)[24]==3) {
            Ra.sl[3]=2675; /* line # 2675 */
            ((SL *)Rv0)[3]=((SL *)Rv7)[8]*((SL *)Rv7)[9];
            Ra.sl[3]=2676; /* line # 2676 */
            if (V_sy_sym.ub[0]==15) {
              Ra.sl[3]=2678; /* line # 2678 */
              V_sy_sym.ub[0]=17;
              Ra.sl[3]=2679; /* line # 2679 */
              while (V_sy_sym.ub[0]==17){
                Ra.sl[3]=2680; /* line # 2680 */
                P_insymbol();
                MXD_DCPEXPR_exp_index(1);
              }
              Ra.sl[3]=2681; /* line # 2681 */
              if (V_sy_sym.ub[0]==16) P_insymbol();
              else {
                Ra.sl[3]=2682; /* line # 2682 */
                P_src_error(Rd.s+3169,26,2);
              }
            }
            else {
              Ra.sl[3]=2684; /* line # 2684 */
              ((UL *)Rv0)[5]=((UL *)Rv0)[5]|256;
            }
          }
          else {
            Ra.sl[3]=2686; /* line # 2686 */
            ((SL *)Rv0)[3]=1;
          }
          Ra.sl[3]=2688; /* line # 2688 */
          if ((V_exp_nva&&Rv2!=0)&&!((UB *)Rv0)[24]) {
            Ra.sl[3]=2690; /* line # 2690 */
            P_out_item_fref((Rs.s+Ri.sl[0]*48-48),((SL *)Rv3)[12],Rv2,((SL *)Rv4)
            [7]);
            Ra.sl[3]=2691; /* line # 2691 */
            ((UL *)Rv0)[5]=((UL *)Rv0)[5]|262144;
          }
          Ra.sl[3]=2718; /* line # 2718 */
          if (((UB *)Rv0)[25]==11) {
            Ra.sl[3]=2719; /* line # 2719 */
            ((V *)Rv0)[1]=V_int_typ;
            ((UB *)Rv0)[24]=0;
            ((UB *)Rv0)[25]=1;
            ((SL *)Rv0)[7]=0;
          }
        }
      }
      else {
        Ra.sl[3]=2724; /* line # 2724 */
        P_src_error(Rd.s+3169,62,3);
        Ra.sl[3]=2725; /* line # 2725 */
        P_skip_symbol(18);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_una "  */
void MXD_DCPEXPR_PRC_00000012(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3173;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2774; /* line # 2774 */
  Ra.sl[3]=2776; /* line # 2776 */
  Rv0=0;
  Ra.sl[3]=2777; /* line # 2777 */
  Rv1=8;
  Ra.sl[3]=2778; /* line # 2778 */
  while (V_sy_sym.ub[0]==8&&(V_sy_sym.ub[1]==8||V_sy_sym.ub[1]==7)){
    Ra.sl[3]=2779; /* line # 2779 */
    if (V_sy_sym.ub[1]==8) Rv0=!Rv0;
    P_insymbol();
  }
  Ra.sl[3]=2780; /* line # 2780 */
  if (Rv0) {
    Ra.sl[3]=2782; /* line # 2782 */
    MXD_DCPEXPR_PRC_00000012();
    Ra.sl[3]=2783; /* line # 2783 */
    MXD_DCPEXPR_gen_genoper(Rv1,1);
  }
  else {
    Ra.sl[3]=2786; /* line # 2786 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[3]=2788; /* line # 2788 */
      P_insymbol();
      Ra.sl[3]=2789; /* line # 2789 */
      P_expression();
      Ra.sl[3]=2790; /* line # 2790 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[3]=2791; /* line # 2791 */
        P_src_error(Rd.s+3184,23,3);
      }
    }
    else {
      Ra.sl[3]=2793; /* line # 2793 */
      MXD_DCPEXPR_exp_entry();
    }
  }
  Ra.sl[3]=2794; /* line # 2794 */
  Rv0=1;
  Ra.sl[3]=2795; /* line # 2795 */
  while (Rv0){
    Ra.sl[3]=2796; /* line # 2796 */
    switch (V_sy_sym.ub[0]) {
      case 15:Ra.sl[3]=2798; /* line # 2798 */
      V_sy_sym.ub[0]=17;
      Ra.sl[3]=2799; /* line # 2799 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[3]=2800; /* line # 2800 */
        P_insymbol();
        MXD_DCPEXPR_exp_index(0);
      }
      Ra.sl[3]=2801; /* line # 2801 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[3]=2802; /* line # 2802 */
        P_src_error(Rd.s+3184,26,2);
      }
      break;
      case 19:Ra.sl[3]=2805; /* line # 2805 */
      P_insymbol();
      MXD_DCPEXPR_exp_field();
      break;
      default:Ra.sl[3]=2808; /* line # 2808 */
      Rv0=0;
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_pow "  */
void MXD_DCPEXPR_PRC_00000011(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3188;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2814; /* line # 2814 */
  MXD_DCPEXPR_PRC_00000012();
  Ra.sl[3]=2815; /* line # 2815 */
  Ra.sl[3]=2816; /* line # 2816 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[3]=2818; /* line # 2818 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2819; /* line # 2819 */
    P_insymbol();
    Ra.sl[3]=2820; /* line # 2820 */
    MXD_DCPEXPR_PRC_00000012();
    Ra.sl[3]=2821; /* line # 2821 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_mul "  */
void MXD_DCPEXPR_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3197;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2826; /* line # 2826 */
  MXD_DCPEXPR_PRC_00000011();
  Ra.sl[3]=2827; /* line # 2827 */
  Ra.sl[3]=2828; /* line # 2828 */
  while (V_sy_sym.ub[0]==7){
    Ra.sl[3]=2830; /* line # 2830 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2831; /* line # 2831 */
    P_insymbol();
    Ra.sl[3]=2832; /* line # 2832 */
    MXD_DCPEXPR_PRC_00000011();
    Ra.sl[3]=2833; /* line # 2833 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_add "  */
void MXD_DCPEXPR_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3206;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2838; /* line # 2838 */
  MXD_DCPEXPR_PRC_00000010();
  Ra.sl[3]=2839; /* line # 2839 */
  Ra.sl[3]=2840; /* line # 2840 */
  while (V_sy_sym.ub[0]==8){
    Ra.sl[3]=2842; /* line # 2842 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2843; /* line # 2843 */
    P_insymbol();
    Ra.sl[3]=2844; /* line # 2844 */
    MXD_DCPEXPR_PRC_00000010();
    Ra.sl[3]=2845; /* line # 2845 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_rel "  */
void MXD_DCPEXPR_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3215;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2850; /* line # 2850 */
  MXD_DCPEXPR_PRC_00000009();
  Ra.sl[3]=2851; /* line # 2851 */
  Ra.sl[3]=2852; /* line # 2852 */
  while (V_sy_sym.ub[0]==9){
    Ra.sl[3]=2854; /* line # 2854 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2855; /* line # 2855 */
    P_insymbol();
    Ra.sl[3]=2856; /* line # 2856 */
    MXD_DCPEXPR_PRC_00000009();
    Ra.sl[3]=2857; /* line # 2857 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_not "  */
void MXD_DCPEXPR_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3224;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2862; /* line # 2862 */
  Ra.sl[3]=2863; /* line # 2863 */
  if (V_sy_sym.ub[0]==10) {
    Ra.sl[3]=2865; /* line # 2865 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2866; /* line # 2866 */
    P_insymbol();
    Ra.sl[3]=2867; /* line # 2867 */
    MXD_DCPEXPR_PRC_00000007();
    Ra.sl[3]=2868; /* line # 2868 */
    MXD_DCPEXPR_gen_genoper(Rv0,1);
  }
  else {
    Ra.sl[3]=2870; /* line # 2870 */
    MXD_DCPEXPR_PRC_00000008();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exp_and "  */
void MXD_DCPEXPR_PRC_00000006(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3233;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2874; /* line # 2874 */
  MXD_DCPEXPR_PRC_00000007();
  Ra.sl[3]=2875; /* line # 2875 */
  Ra.sl[3]=2876; /* line # 2876 */
  while (V_sy_sym.ub[0]==11){
    Ra.sl[3]=2878; /* line # 2878 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2879; /* line # 2879 */
    P_insymbol();
    Ra.sl[3]=2880; /* line # 2880 */
    MXD_DCPEXPR_PRC_00000007();
    Ra.sl[3]=2881; /* line # 2881 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " expression "  */
void P_expression(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3242;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2886; /* line # 2886 */
  MXD_DCPEXPR_PRC_00000006();
  Ra.sl[3]=2887; /* line # 2887 */
  Ra.sl[3]=2888; /* line # 2888 */
  while (V_sy_sym.ub[0]==12){
    Ra.sl[3]=2890; /* line # 2890 */
    Rv0=V_sy_sym.ub[1];
    Ra.sl[3]=2891; /* line # 2891 */
    P_insymbol();
    Ra.sl[3]=2892; /* line # 2892 */
    MXD_DCPEXPR_PRC_00000006();
    Ra.sl[3]=2893; /* line # 2893 */
    MXD_DCPEXPR_gen_genoper(Rv0,2);
  }
  Ra.sl[3]=2896; /* line # 2896 */
  if (V_debug_exp) {
    Ra.sl[3]=2898; /* line # 2898 */
    PAS__SELECT_OUT(((V *)V_lst_current)[13]);
    PAS__WRITE_STR(Rd.s+3254,-1,-1,32);
    Write_Exp_Rec((Rs.s+Ri.sl[0]*48-48));
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " expression_type "  */
void P_expression_type(V F_typ, UB F_bref){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3272;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2911; /* line # 2911 */
  P_expression();
  Ra.sl[3]=2912; /* line # 2912 */
  if (!MXD_DCPEXPR_comp_type_stk(0, F_typ, F_bref,0)) P_src_error(Rd.s+3291,141,2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_type_expression "  */
void P_get_type_expression(V F_rec, V F_typ, UB F_bref){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register UB Rv2;
  SL Rv3;
  G Rv4;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+3295;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=2930; /* line # 2930 */
  P_expression();
  Ra.sl[68]=2931; /* line # 2931 */
  if (F_bref) {
    Ra.sl[68]=2933; /* line # 2933 */
    if (!MXD_DCPEXPR_comp_type_stk(0, F_typ, F_bref,0)) P_src_error(Rd.s+3318,142,2);
    Ra.sl[68]=2934; /* line # 2934 */
    P_pop_expression(F_rec);
  }
  else {
    Ra.sl[68]=2938; /* line # 2938 */
    Rv0=P_get_val_forms(F_typ);
    Ra.sl[68]=2939; /* line # 2939 */
    P_pop_expression(F_rec);
    Ra.sl[68]=2940; /* line # 2940 */
    Rv1=F_rec+24;
    Ra.sl[68]=2941; /* line # 2941 */
    if (((UB *)Rv1)[1]!=11&&Rv0!=((UB *)Rv1)[1]) {
      Ra.sl[68]=2942; /* line # 2942 */
      switch (Rv0) {
        case 0:
        case 3:Ra.sl[68]=2945; /* line # 2945 */
        P_extract_str(F_rec,Ra.s);
        P_exprv_remove(V_exp_res.s);
        Ra.sl[68]=2946; /* line # 2946 */
        ((UB *)Rv1)[1]=0;
        Rv2=Ra.ub[1];
        ((V *)Rv1)[1]=PAS__NEW((SL)Rv2+2);
        ((UB *)((V *)Rv1)[1])[0]=Rv2;
        PAS__STR_TO_STR(((V *)Rv1)[1],Ra.s);
        break;
        case 1:
        case 4:Ra.sl[68]=2950; /* line # 2950 */
        Rv3=P_extract_int(F_rec,0);
        P_exprv_remove(V_exp_res.s);
        Ra.sl[68]=2951; /* line # 2951 */
        ((UB *)Rv1)[1]=1;
        ((SL *)Rv1)[1]=Rv3;
        break;
        case 2:
        case 5:Ra.sl[68]=2955; /* line # 2955 */
        Rv4=P_extract_flt(F_rec,0.000000E-01);
        P_exprv_remove(V_exp_res.s);
        Ra.sl[68]=2956; /* line # 2956 */
        ((UB *)Rv1)[1]=2;
        ((G *)Rv1)[1]=Rv4;
        ((G *)Rv1)[2]=0.000000000000000E-001;
        break;
        case 11:break;
        default:Ra.sl[68]=2961; /* line # 2961 */
        P_src_error(Rd.s+3318,143,2);
        break;
      }
    }
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " get_dir_larg "  */
void P_get_dir_larg(V F_exp, V F_typ, UB F_brf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  UB Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3322;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=2978; /* line # 2978 */
  if (F_typ!=NULL) {
    Ra.sl[3]=2979; /* line # 2979 */
    Rv0=F_exp+24;
    Ra.sl[3]=2981; /* line # 2981 */
    P_get_expression(F_exp);
    Ra.sl[3]=2982; /* line # 2982 */
    Rv1=P_get_val_forms(F_typ);
    Ra.sl[3]=2983; /* line # 2983 */
    switch (((UB *)Rv0)[1]) {
      case 0:
      case 3:Ra.sl[3]=2985; /* line # 2985 */
      Rv2=Rv1!=0;
      break;
      case 1:
      case 4:Ra.sl[3]=2988; /* line # 2988 */
      Rv2=Rv1!=1;
      break;
      case 2:
      case 5:Ra.sl[3]=2991; /* line # 2991 */
      Rv2=Rv1!=2;
      break;
      case 7:Ra.sl[3]=2993; /* line # 2993 */
      Rv2=Rv1!=1&&Rv1!=7;
      break;
      case 8:Ra.sl[3]=2995; /* line # 2995 */
      Rv2=Rv1!=2&&Rv1!=8;
      break;
      case 9:Ra.sl[3]=2997; /* line # 2997 */
      Rv2=Rv1==9;
      break;
      default:Ra.sl[3]=3000; /* line # 3000 */
      Rv2=1;
      break;
    }
    Ra.sl[3]=3002; /* line # 3002 */
    if (Rv2) P_src_error(Rd.s+3338,144,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_flt_mexpr "  */
void P_get_flt_mexpr(V F_pa, V F_typ, UB *F_lsqob){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3342;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=3014; /* line # 3014 */
  Rv0=F_pa;
  Ra.sl[3]=3015; /* line # 3015 */
  if (((UB *)Rv0)[24]!=1) P_src_error(Rd.s+3359,352,3);
  else {
    Ra.sl[3]=3018; /* line # 3018 */
    P_active_macro_code(F_pa,0);
    Ra.sl[3]=3019; /* line # 3019 */
    P_insymbol();
    Ra.sl[3]=3020; /* line # 3020 */
    if (F_typ==NULL) P_expression();
    else {
      Ra.sl[3]=3021; /* line # 3021 */
      P_expression_type(F_typ,0);
    }
    Ra.sl[3]=3022; /* line # 3022 */
    P_pop_expression(V_exp_res.s);
    Ra.sl[3]=3023; /* line # 3023 */
    P_ret_of_macro_code(F_pa);
    Ra.sl[3]=3024; /* line # 3024 */
    (*F_lsqob)=(131072&V_exp_res.ul[5])!=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_flt_mvalue "  */
G P_get_flt_mvalue(V F_pa){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+3363;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=3036; /* line # 3036 */
  Rv0=F_pa;
  Ra.sl[3]=3037; /* line # 3037 */
  if (((UB *)Rv0)[24]!=1) {
    Ra.sl[3]=3039; /* line # 3039 */
    P_src_error(Rd.s+3381,352,3);
    Ra.sl[3]=3040; /* line # 3040 */
    Ret=0.000000000000000E-001;
  }
  else {
    Ra.sl[3]=3044; /* line # 3044 */
    P_active_macro_code(F_pa,0);
    Ra.sl[3]=3045; /* line # 3045 */
    P_insymbol();
    Ra.sl[3]=3046; /* line # 3046 */
    Ret=P_get_fltexpr(0.000000E-01);
    Ra.sl[3]=3047; /* line # 3047 */
    P_ret_of_macro_code(F_pa);
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
