{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*              MXD    data    Compiler    Environment    File                 *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


  %include 'pasenv:cpas_b__src_env';    { We load the Source file environment }

  %include 'MXDSRC:mxd_env';            { Load the mxd global environment }

(*
  %include 'MXDSRC:mxd_cpl_env';        { Load the complex environment }
*)


const

  task_name    =             'MXD-DCP'; { Task name for the Data Compiler }
  mxd_setenvf  =     'mxd_dcp.std_env'; { Standard Environment Setup file name }
  mxd_dcperrf  =     'mxd_dcp.err_msg'; { Error message file for MXD_DCP }
  mxd_prompt   =               ' MXD>'; { MXD DCP Prompt }
  ddispcfile   =        'mxdddi.bdd.1'; { Data directory specification file }

  disp_max     =                    64; { Identifier display max-size }
  type_max     =                   256; { Maximum number of defined types }

  max_cte_size  =                32768; { Maximum number of element in a constant array (must be even) }

  idm_mac_all  =                  4096; { Allocation increment for macro code }

  max_usrlun   =                    32; { Max number of user file that can be open }

  TAB          =            CHR(   9 ); { Tabulation ASCII Character }
  DEL          =            CHR( 127 ); { DEL ASCII Character }
  SOH          =            CHR(   0 ); { NULL ASCII Character }


  { *** Specific assignation correlated action definitions *** }

  sact_stitle  =                     1;




type


        {************************************************************}
        {*****      Symbol Definitions for Lexical Parsing      *****}
        {************************************************************}


  symbol   =   (                        { * Define the keyword symbol list * } 

                { **** Constant symbol definitions **** }

                identsy,                { Identifier }
                intconst,               { Integer constant }
                singleconst,            { Single precision constant }
                doubleconst,            { Double precision constant }
                stringconst,            { String constant }

                { **** Operator Class symbol definitions **** }

                unaop,                  { Unary classe operator }
                powop,                  { Power class operator }
                mulop,                  { Multiply class operator }
                addop,                  { Addition class operator }
                relop,                  { Relation class operator }
                notop,                  { Not class operator }
                lgandop,                { Logical and class operator }
                lgorop,                 { Logical or class operator }

                { **** Separator symbol definitions **** }

                lparen,                 { '(' and ')' }
                rparen,
                lbrack,                 { '[" and ']' }
                rbrack,
                comma,                  { ',' }
                semicolon,              { ';' }
                period,                 { '.' }
                twodot,                 { '..' }
                colon,                  { ':' }
                becomes,                { ':=' }

                questsign,              { '?' }
                expsign,                { '^' }
                attrsign,               { '"' }
                implic,                 { '=>' }


                {**** Keywords (reserved) symbol definition ****}

                beginsy,                { BEGIN of dynamic block }
                endsy,                  { END of procedure/begin/if/loop/case/with }

                ifsy,                   { IF keyword }
                thensy,                 { THEN keyword }
                elsesy,                 { ELSE keyword (for IF statement) }

                repeatsy,               { REPEAT directive }
                untilsy,                { UNTIL for REPEAT end }
                whilesy,                { WHILE directive }

                dosy,                   { DO keyword }
                forsy,                  { FOR directive }
                tosy,                   { TO symbol }
                downtosy,               { DOWNTO symbol }

                loopsy,                 { LOOP STATEMENT }

                casesy,                 { CASE constructor }
                whensy,                 { WHEN keyword }
                othersy,                { OTHERWISE case }

                displaysy,              { DISPLAY: Write to output file }
                replysy,                { REPLY: Read from input file }
                writemsgsy,             { Write to listing }
                opensy,                 { OPENFILE: Open a user file }
                writesy,                { Write to an opened file }
                writelnsy,              { Writeln to an opened file }
                readsy,                 { Read from an opened file }
                closesy,                { CLOSE an opened file }

                varsy,                  { Variable declaration symbol }
                typesy,                 { Type declaration symbol }
                arraysy,                { To declare an array type }
                recordsy,               { To declare a record type }
                itemsy,                 { To declare an item object type }
                itmgrpsy,               { To create an item with related block }
                itmegrpsy,              { To end an item block }
                issy,                   { To define an object }
                ofsy,                   { For array declaration }

                mfunctionsy,            { Macro function definition }
                returnvsy,              { Return value variable name }

                tablebldsy,             { Interpolation Table Builder }
                integrtabsy,            { Integration Table Builder }

                selectsy,               { Expression selection special operator }
                integropsy,             { Integration operator }
                summopsy,               { Summation operator }
                summdatasy,             { Summation on data }

                lsqparmsy,              { To define Least Squares Formulae }
                lsqdirsy,               { To define any Least Squares directive }
                datasy,                 { Data collection introductor }

                clrdatasy,              { Clear data library }

                macrosy,                { MACRO definition }
                endmacrosy,             { MACRO text end }
                purgesy,                { PURGE: macro destruction }
                macrolibsy,             { MACROLIB: Library of macro specification }
                macrocallsy,            { MACROCALL: Search and load a macro from the current library list }
                errorsy,                { To generate an error message }

                definedsy,              { Keyword Function to determine when an identifier is defined }
                mdefinedsy,             { Keyword Function to determine when an identifier is defined }

                {**** Micellious symbol ****}

                eomcsy,                 { End of macro code }
                eolnsy,                 { End of line seen - for data mode only }

                {**** Pre-processor STATEMENT symbol ****}

                includesy,              { INCLUDE a source file }
                chainesy,               { CHAINE a source file }
                pragmasy,               { PRAGMA to compiler option setting }
                peofsy,                 { End of file seen or endfile symbol }
                eofsy,                  { EOF: end of all source }

                nothing                 { Null definition }
           );




  std_fnc  = (                          { * Builtin/Standard function code definitions * }
                std_string,             { STRING( x[, f[, b]] ) }
                std_substr,             { SUBSTR( s [, i [, j ]] ) }
                std_nindex,             { INDEX( s1, s2 [, n ] ) }
                std_slength,            { LENGTH( s ) }
                std_setcase,            { SETCASE( s [, i ] ) }
                std_checkch,            { CHECK_CHAR( s1, s2 [, i ] ) }
                std_checknst,           { Check for numeric string }
                std_selement,           { ELEMENT( il, sep, s ) }
                std_rmcomment,          { Suppress comment in a string }
                std_id_replace,         { Replace/substitute user identifier by there related contents }
                std_id_insert,          { Insert the specified identifier in the substitution identifier list }
                std_id_remove,          { Remove the specified identifier from the substitution identifier list}
                std_filespc,            { Set file specification to system conventions }

                std_time,               { Get Current Time }
                std_date,               { Get Current Date }
                std_spawn,              { SPAWN a child process }
                std_run,                { Exit from cpsh and run an other program }
                std_exec,               { Run an other program as a New Process }
                std_wait,               { Wait for process complexion }
                std_exit,               { EXIT from MXD }
                std_dfdir,              { Get Default Directory }
                std_chdir,              { Change Default Directory }
                std_getenv,             { Get environment variable }
                std_setenv,             { To Change, Create or Delete an environment variable }
                std_getpath,            { Get a path environment variable }
                std_setpath,            { Set a path environment variable }

                std_f_exist,            { Test if file exist }
                std_f_rename,           { Rename a file }
                std_f_delete,           { Delete a file }

                std_ardim,              { Get an array dimension }
                std_arlow,              { Get the low bound index of an array dimension }
                std_arhigh,             { Get the high bound index of an array dimension }
                std_arsearch,           { Search in object in array }

                std_errcount,           { Get error statistic procedure }
                std_noop                { No Op }
              );


  dcp_oper = (                                  { * Generic Operator definitions * }
                 not_op,                        { Logical not operator }
                 pow_op,                        { Power = powop }
                 mul_op,    div_op,             { Multiply, Divide }
                idiv_op,   imod_op,   irem_op,  { Integer divide, modulo, remainder }
                 add_op,    sub_op, concat_op,  { Addition, Substract, Concate strings }
                  lt_op,     le_op,     ge_op,  { '<',  '<=', '>=' }
                  gt_op,     ne_op,     eq_op,  { '>=', '>', '>', '<>', '=' }
                 and_op,     or_op,    xor_op,  { Logical and ('&'), or ('|'), xor }
                 ass_op,                        { Assignation operator, ':=' }
                 stp_op,                        { Stop sequence operator /used as a flag }
                  no_op                         { To flag no operator syntax unit }
             );


  ope_stm =  (                                  { * Define internal primitive operator  * }
                stm_not,                        { Logical not }
                stm_neg,                        { Negate operator }
                stm_fng,
                stm_iip,  stm_fip,  stm_ffp,    { Power <int>**<int> -> <int>, <flt>**<int> and <flt>**<flt> -> <flt> }
                stm_iml,  stm_fml,              { Multiply <int>*<int> -> <int>, <flt>*<flt> -> <flt> }
                stm_idv,  stm_mod,  stm_rem,    { <int> div <int> -> <int>, <int> mod <int> -> <int>, <int> rem <int> -;> <int> }
                stm_fdv,                        { <flt>/<flt> -> <flt> }
                stm_iad,  stm_fad,              { <int>+<int> -> <int>, <flt>+<flt> -> <flt> }
                stm_isb,  stm_fsb,              { <int>-<int> -> <int>, <flt>-<flt> -> <flt> }
                stm_ssc,                        { <str>||<str> -> <str> }
                stm_seq,  stm_ieq,  stm_feq,    { <str>  = <str> -> <int>, <int>  = <intr> -> <int>, <flt>  = <flt> -> <int> }
                stm_sne,  stm_ine,  stm_fne,    { <str> <> <str> -> <int>, <int> <> <intr> -> <int>, <flt> <> <flt> -> <int> }
                stm_slt,  stm_ilt,  stm_flt,    { <str>  < <str> -> <int>, <int>  < <intr> -> <int>, <flt>  < <flt> -> <int> }
                stm_sle,  stm_ile,  stm_fle,    { <str> <= <str> -> <int>, <int> <= <intr> -> <int>, <flt> <= <flt> -> <int> }
                stm_sge,  stm_ige,  stm_fge,    { <str> >= <str> -> <int>, <int> >= <intr> -> <int>, <flt> >= <flt> -> <int> }
                stm_sgt,  stm_igt,  stm_fgt,    { <str>  > <str> -> <int>, <int>  > <intr> -> <int>, <flt>  > <flt> -> <int> }
                stm_and,  stm_xor,  stm_or,     { <int> and <int> -> <int>, <int> xor <int> -> <int>, <int> or <int> -> <int> }

                stm_iabs, stm_fabs,             { ABS( <int> ) -> <int>,  ABS( <flt> ) -> <flt> }
                stm_sqrt,                       { SQRT( <flt> ) -> <flt> }
                stm_sinr,                       { COS, SIN, TAN ( <flt_radian> ) -> <flt> }
                stm_cosr,
                stm_tanr,
                stm_asinr,                      { ACOS, ASIN, ATAN ( <flt> ) -> <flt_radian> }
                stm_acosr,
                stm_atanr,
                stm_phaser,                     { ATAN( <flt>, <flt> ) -> <flt_radian> }
                stm_sind,                       { COS, SIN, TAN ( <flt_degrees> ) -> <flt> }
                stm_cosd,
                stm_tand,
                stm_asind,                      { ACOS, ASIN, ATAN ( <flt> ) -> <flt_degrees> }
                stm_acosd,
                stm_atand,
                stm_phased,                     { ATAN( <flt>, <flt> ) -> <flt_degrees> }
                stm_exp,  stm_ln,               { LN( <flt> ) -> <flt>, EXP( <flt> ) -> <flt> }
                stm_tanh,
                stm_bessj,                      { Bessel_J( <int>, <flt> ) -> <flt>  }
                stm_bessjh,                     { Bessel_J( <flt>, <flt> ) -> <flt>  for Bj1/2, 3/2 ( x ) }

                stm_interpol,                   { Interpolation function }
                stm_integr,                     { Gauss-Legendre Integration function }
                stm_summ,                       { Series summation }

                { The conversion must be just before stm_nop to fit with dcp_basicinit routines
                  CREATE_STD_CONV and SET_CREATE_STD_OPER }
                stm_csi,  stm_csf,              { Conversion: <str> to <int>, to <flt> }
                stm_cis,  stm_cif,              { Conversion: <int> to <str>, to <flt> }
                stm_cfs,  stm_cfi,  stm_rnd,    { Conversion: <flt> to <str>, to TRUNC( <int> ) and Round( <int> ) }
                stm_nop
            );


  ent_kinds = ( entk_stm,                       { This entry is a primitive MXD statement }
                entk_fnc,                       { This entry is a user defined MXD function }
                entk_std                        { This entry is a standard function/procedure }
            );


  { *** Define the macro object kinds *** }
  idm_kinds = ( idm_list,               { Macro Stream list }
                idm_parm,               { Macro Parameter }
                idm_temp,               { Temporary Macro parameter }
                idm_macro,              { Macro Identifier }
                idm_macfnc,             { Macro function identifier }
                idm_undef               { Macro undefined }
              );



  symc_ptr      =    ^symc_rec;         { * Define Symbol context record pointer type * }

  keyword_ptr   =     ^keyword;         { * Define Keyword pointer * }

  idm_ptr       =     ^idm_rec;         { * Define Macro Identifier pointer * }

  idm_apt       =     ^idm_str;         { * Define Macro text pointer * }

  ent_ptr       =     ^ent_rec;         { * Define operator definition record pointer * }

  stq_ptr       =     ^stq_rec;         { * Define the queue string element pointer * }

  typ_ptr       =     ^typ_rec;         { * Define the type record (TYR) pointer type * }

  val_ptr       =     ^val_rec;         { * Define the value record pointer type * }

  ide_ptr       =     ^ide_rec;         { * Define the identifier record (IDR) pointer type * }

  usrf_ptr      =    ^usrf_rec;         { * Define a User identifier reference pointer record }

  itm_ptr       =     ^itm_rec;         { * Define the Item pointer }

  tbs_ptr       =     ^tbs_rec;         { * Define the Array Scan by string index record context pointer }

  dat_ptr       =     ^dat_rec;         { * Define the pointer of data record * }



  sym_rec = record                      { * Symbol record type definition * }
    sy:                         symbol; { The current symbol kind }
    op:                       dcp_oper  { Node code }
  end;


  symc_rec = record                     { * Define Symbol context record * }
    symc_ch,                            { To save sy_ch and ... }
    symc_cmin:                    char; { ... sy_cmin characters }
    symc_svall:                boolean; { Flag the INSYMBOL result save on RESTORE}
    symc_prv:                 symc_ptr; { Pointer to previous context in the stack }
    symc_sym:                  sym_rec; { Saved context }
    symc_ival:                 integer; { Save integer value }
    symc_rval:                 mxd_flt; { Save float value }
    symc_string:               str_ptr  { Save identifier name or string value }
  end;


  stq_rec  = record                     { * Define the STring Queue record * }
    stq_lnk:                   stq_ptr; { Link to next stq_rec }
    stq_str:                   str_ptr  { Link to the associated string }
  end;


  keyword  = record                     { * Keyword definition * }
    name:                      str_ptr; { Address of identifier string }
    leftp, rightp:         keyword_ptr; { Pointers to build binary tree }
    symb:                      sym_rec  { Keyword Syntaxe Definition }
  end;


  idm_str( idm_size: integer := idm_mac_all ) = record  { * Define the macro body record * }
    idm_use:                   integer;
    idm_ctb: packed array[1..idm_size] of char
  end;


  idm_rec = record
    idm_name:                  str_ptr; { Macro Identifier name pointer }
    idm_type:                  ide_ptr; { Related type for macro function and there parameters }
    idm_parl,                           { Pointer to related parameter list }
    idm_cntx,                           { Pointer to the previous macro context }
    idm_nxt,                            { Pointer to next stack macro definition }
    idm_prv:                   idm_ptr; { Pointer to previous stack macro definition }
    idm_kind:                idm_kinds; { Type of macro symbol }
    idm_ftyp,                           { Integer index of defined formal macro type }
    idm_nch:                   integer; { Index of next character }
    idm_tab:                   idm_apt; { Macro code reference }
    idm_run:                   boolean  { Flag for active code }
  end;




        {***************************************************************}
        {*****      Symbol Definitions for Expression Parsing      *****}
        {***************************************************************}

  cla_kinds = ( cla_type,               { Type Identifier }
                cla_varbl,              { Variable or Lsq_Variable Identifier }
                cla_field,              { Record field Identifier }
                cla_itmfld,             { Item field Identifier }
                cla_formal,             { Function Formal argument identifier }
                cla_generic,            { Generic user procedure/function Identifier }
                cla_standard,           { Standard (Builtin) generic procedure/function Identifier }
                cla_directive           { Directive for external software (LSQ and any others) }
              );

  cla_setty = set of cla_kinds;         { Define the set of class type }


   { *** Define the object kinds (functions, string, integer, float and there related array *** }
  typ_forms = ( tfrm_str,               { String type }
                tfrm_int,               { Integer type }
                tfrm_flt,               { Float type }
                tfrm_array,             { Array of ... }
                tfrm_record,            { Record ... }
                tfrm_itmrf,             { Item reference type }
                tfrm_itmty,             { Item type }
                tfrm_number,            { Wild Number }
                tfrm_warray,            { Wild Array }
                tfrm_wild,              { Wild object }
                tfrm_null               { Empty/Null type }
              );

  val_forms = ( vfrm_str,               { Single string value }
                vfrm_int,               { Single integer value }
                vfrm_flt,               { Single float value (with sigma) }
                vfrm_est,               { Array element string }
                vfrm_ein,               { Array element integer }
                vfrm_efl,               { Array element float }
                vfrm_ast,               { Array of string }
                vfrm_ain,               { Array of integer }
                vfrm_afl,               { Array of float }
                vfrm_itm,               { Item reference value }
                vfrm_itf,               { Item Field reference }
                vfrm_null               { No Meaning value }
              );

  { *** Define the variable attributes (including allocation modifiers (complex, lsq, ...) flags *** }
  obj_flelm = ( objf_ronly,             { Constant value identifier (Read Only) }
                objf_spdef,             { Flag a specific action for definition }
                objf_refer,             { Flag a specific action for reference }
                objf_spass,             { Flag a specific action for assignation }
                objf_sigma,             { Flag for sigma allocation }
                objf_lockd,             { Locked size flag (for array) }
                objf_noass,             { Suppress assignement management }
                objf_varbl,             { Normal DCP Read/Write variable }
                objf_retva,             { Flag to identify a return value }
                objf_vbnda,             { Flag to identify a variable index bound array }
                objf_wild,              { Flag to identify a wild type }
                objf_nolsq,             { Flag to set incompatible LSQ object ( = cte. ) }
                objf_lsqva,             { Least-Squares Variable }
                objf_lsqpa,             { Least-Squares Parameter }
                objf_lsqtb,             { Exportable table }
                objf_lsqiv,             { Least-Squares Local intvar/index }
                objf_lsqit,             { Least-Squares Item reference }
                objf_lsqob,             { Least-Squares object }
                objf_lsqex,             { Formal (LSQ) expression }
                objf_lsqda,             { LSQ Data related expression }
                objf_16bits,            { Flag for 16 bits object (used for integer only) }
                objf_8bits,             { Flag for 8 bits object (used for integer only) }
                objf_lxbase,            { Flag for base lex default }
                objf_null               { Null and illegal }
              );


  obj_flagsty   =   set of obj_flelm;   { * Define the object flags word type }

(*
  type_idtb  = array[1..type_max] of ide_ptr;   { * Define the direct access to defined types * }
*)

  val_ast( val_all: integer ) = record          { * Define an array of string * }
    val_stb: array[1..val_all] of str_ptr;
  end;


  val_ain( val_all: integer ) = record          { * Define an array of integer * }
    val_itb: array[1..val_all] of integer;
  end;

(* *** Already defined in mxd_env.pas :
  val_afl( val_all: integer ) = record          { * Define an array of float * }
    val_ftb: array[1..val_all] of mxd_flt;
  end;
*)

  val_rec = record
    val_cte:                      boolean;      { Flag for constant (used for item only) }
    case val_frm: val_forms of
      vfrm_str:( str:           str_ptr );      { String value }
      vfrm_int:( int:           integer );      { Integer Value }
      vfrm_flt:( flt, sig:      mxd_flt );      { Float value (with sigma) }
      vfrm_ast:( aas:          ^val_ast );      { Array of string values }
      vfrm_ain:( aai:          ^val_ain );      { Array of integer values }
      vfrm_afl:( aaf, asg:     ^val_afl );      { Array of float value (with possible standard error (sigma) }
      vfrm_itm:( itm:           itm_ptr );      { Item reference }
      vfrm_itf:( ifo:           integer )       { Item field reference }
  end;


  itm_rec( itm_size: integer ) = record
    itm_name:                      str_ptr;     { Item identifier Name to display }
    itm_next,                                   { Item list link }
    itm_sitm,                                   { Sub-Item list }
    itm_blkw,                                   { Link to the Block owner (of this item) }
    itm_sblk,                                   { Link to the more external item block (or nil) }
    itm_ablk,                                   { Link to attached item block }
    itm_own:                       itm_ptr;     { Link to item owner }
    itm_typ:                       typ_ptr;     { Pointer to the related item type }
    itm_datp:                      dat_ptr;     { Data record pointer for Data Item }
    itm_nver,                                   { Name repeat count }
    itm_sequ:                      integer;     { Item integer identifier (negative value for item with cte fields == not expression) }
    itm_tab: array[1..itm_size] of val_rec      { Item field array }
  end;

  itmf_flags =  (                               { * Define the item specific flags }
                  itmf_nsq,                     { This item must be exported }
                  itmf_use,                     { This item is used type item for data read process }
                  itmf_fix,                     { This item has fixed fields output (inline data) }
                  itmf_blk,                     { This item is a item block introductor }
                  itmf_dat                      { This item is a data item }
                );

  itm_flgty = set of itmf_flags;                { * Define the item type flag word * }

  ittl_ptr = ^ittl_rec;                         { * Define the item type owner link pointer * }

  ittl_rec = record                             { * Define the item type owner link record * }
    ittl_next:        ittl_ptr;                 { Link to next possible owner }
    ittl_owner:        typ_ptr                  { Link to the item type owner }
  end;

  typ_rec = record                              { * Define the Type Descriptor Record (TDR) * }
    typ_ide:                       ide_ptr;     { Type related identifier pointer }
    typ_lnk,                                    { Link between all type of a specified lex level }
    typ_par:                       typ_ptr;     { Parent type }
    typ_act:                       integer;     { Special action number for LSQ obj or specific action index when value change }
    typ_lex:                          byte;     { Owner Display level }
    typ_flg:                   obj_flagsty;     { Type related flags }
    case typ_frm:  typ_forms of                 { Kind of object }
      tfrm_array:( typ_ael:        typ_ptr;     { Array element type pointer }
                   typ_stp,                     { Index step for the array }
                   typ_siz,                     { Number of element }
                   typ_min:        integer      { Minimum index value }
        );
      tfrm_itmty:( typ_fel,                     { First and last field identifier pointer }
                   typ_lel:        ide_ptr;
                   typ_fit,                     { First and last item record pointer }
                   typ_lit:        itm_ptr;
                   typ_ito:       ittl_ptr;     { List head of possible item owners }
                   typ_pcd:        integer;     { LSQ ITEM node codes for item definitions and references }
                   typ_nid,                     { Number of ITEM string identification field }
                   typ_nfl,                     { Number of item fields }
                   typ_adv,                     { Size of additional value table (or 0 when not used) }
                   typ_nis:           byte;     { Sentinel position (or 0 when not used) }
                   typ_ifl:      itm_flgty      { Word of item type flags }
                  )
  end;


  tbs_rec = record                              { * Define the Array Scan by string index record context * }
    tbs_lnk:                       tbs_ptr;     { Link to the sub-array (array of array) }
    tbs_min,                                    { Minimum, maximum and current value of index }
    tbs_max,
    tbs_ind:                       integer
  end;


  ide_rec = record                              { * Define the identifier record (IDR) * }
    ide_name:                          str_ptr; { Identifier name pointer }
    ide_lnk,                                    { List identifier link }
    ide_left, ide_right:               ide_ptr; { Left and right identifier link }
    ide_typ:                           typ_ptr; { Link to type descriptor record }
    ide_flg:                       obj_flagsty; { Specific flags of this object }
    ide_displ:                            byte; { Display level }
    case ide_class: cla_kinds of                { Class of the identifier }
      cla_field:( { * For record field local * }
        ider_option:                   boolean; { Flag for optional setup }
        ider_offset,                            { Field offset }
        ider_sequnb:                   integer  { Related field sequence number }
      );
      cla_itmfld:({ * For item field (local or Least-Squares) * }
        idee_option, idee_isent:       boolean; { Flag for optional setup }
        idee_offset,                            { Field offset }
        idee_sequnb:                   integer  { Related field sequence number }
      );
      cla_varbl:( { * For Variable (local or Least-Squares) * }
        idev_spcact,                            { Identifier specific action number }
        idev_sequnb:                   integer; { Sequence number of this identifier for LSQ obj or specific action index when value change }
        idev_val:                      val_rec  { Related value of the identifier }
      );
      cla_formal:( { * For Function formal argument * }
        idef_efn:                      integer; { Effective Stack link }
        idef_def,                               { Flag for optional argument }
        idef_ref:                      boolean  { Flag for reference (=var) formal access }
      );
      cla_standard, { * For Builtin/Standard Generic Procedures and Functions * }
      cla_generic:( { * For User Generic Procedures and Functions * }
        ideg_first,                             { Header (first and last) of definition queue for this generic name }
        ideg_last:                     ent_ptr
      );
      cla_directive:( { * For Target software directive identifier * }
        ided_dito:                    ittl_ptr; { List head of possible item owners }
        ided_code:                     integer; { Directive code identifier }
        ided_ntyp:    array[1..max_arg_dir] of typ_ptr; { Types values descriptor }
        ided_nref:    array[1..max_arg_dir] of boolean; { Flag for reference mode }
        ided_narg:                        byte; { Number of arguments }
        ided_optf,                              { Flag for option form }
        ided_nrep:                     boolean  { Flag for loop on last type values }
      );
  end;


  usrf_rec = record
    usrf_nxt, usrf_prv:               usrf_ptr; { Next and previous links }
    usrf_iref:                         ide_ptr  { Pointer to the referenced identifier }
  end;


  disp_rec = record
    disp_lex:                          integer; { Display level }
    disp_own:                          ide_ptr; { Pointer to the owner identifier }
    disp_ent:                          ent_ptr; { List of operators definitions in this lex }
    disp_lty:                          typ_ptr; { List of type definition in this lex }
    disp_lid,                                   { Last created identifier in the lex }
    disp_idt:                          ide_ptr  { Identifier tree }
  end;


  ent_rec = record
    ent_lnk,                            { Link to the previous (FIFO) entry definition of the same display level }
    ent_prv:                  ent_ptr;  { Link to the previous (FIFO) entry definition of the same generic/operator }
    ent_typ:                  typ_ptr;  { Pointer to the resulting type }
    case ent_knd: ent_kinds of
      entk_stm: ( ent_pt1,              { Pointer to the first and second (or nil) parameter types }
                  ent_pt2:    typ_ptr;
                  ent_cv1,              { Conversion to apply to first ... }
                  ent_cv2:    ent_ptr;  { ... and second parameter }
                  ent_stm:    ope_stm   { Statement to execute }
                );
      entk_std,
      entk_fnc: ( ent_npa,                      { Number of parameters }
                  ent_dsp:                byte; { Lex of this definition }
                  ent_ope:            dcp_oper; { Code of related operator }
                  ent_frl:             ide_ptr; { Pointer to the formal list identifier }
                  case boolean of
                    false:( ent_std: std_fnc ); { For the standard (builtin) function, index of the buitin fonction }
                    true:(  ent_cod: idm_apt;   { For the user function: text of the function code }
                            case boolean of
                              false:(ent_ide: ide_ptr); { Back pointer to generic identifier, or ... }
                              true:( ent_str: str_ptr )){ ... attached operator name for operator }
                )
  end;


  mope_tabt = array[dcp_oper] of record { * Define the macro operator reference lists * }
    mop_first,                          { Definition list for operators }
    mop_last:           ent_ptr
  end;


  disp_tabty =  array[0..disp_max] of disp_rec; { * Display table definition * }

  exp_rec = record                              { * Define the expression record * }
    exp_ref:                           ide_ptr; { Identifier pointer for object ref. }
    exp_typ:                           typ_ptr; { Array definition pointer }
    exp_nsq,                                    { Sequence identifier number }
    exp_esz,                                    { Copy of dimension for array }
    exp_shf:                           integer; { Array shift for reference }
    exp_flg:                       obj_flagsty; { Object word set of flags }
    exp_val:                           val_rec  { Value of the object }
  end;



  { Data Directory: ddi table record structure }

  dat_namty =  record                           { * Define the data name type * }
    length: byte;
    body: array[1..ide_maxsize+8] of char
  end;


  adat_tabty =  array[1..max_adidtb_size] of integer;   { * Define the Additional data identifier table type * }

  dat_descr = record                    { * Define the data descriptor * }
    dat_tynam,                          { Name of item type }
    dat_name:                dat_namty; { Name of the data set (copy of the item name) }
    dat_nver,                           { Item Data version number (copy of the item version number) }
    dat_filnbr,                         { Binary data file number }
    dat_itmpcd,                         { Data item type P-code }
    dat_nrec,                           { Number of data record }
    dat_adln:                 integer;  { Number of additional identifier define in this data collection }
    dat_adtb:              adat_tabty   { Table of the additional identifiers sequence identifier number }
  end;

  dat_rec = record                      { * Define the data record * }
    data_next:                 dat_ptr; { Name of data set }
    data_itmp:                 itm_ptr; { Related data item pointer }
    data_usef:                 boolean; { Flag for mark the Data collection use }
    data_desc:               dat_descr  { Data set descriptor }
  end;




  { User Files descriptor Definition }

  iocnt_opmode = ( iocnt_close,         { User file channel is closed }
                   iocnt_input,         { User file channel is open for input }
                   iocnt_output         { User file channel is open for output }
                 );

  iocnt_rec = record                    { * User file channel definition * }
    iocnt_mode: iocnt_opmode;           { User channel status }
    iocnt_file: text                    { Related Pascal file }
  end;

  iocnt_tab = array[1..max_usrlun] of iocnt_rec;{ * Define the User file channel table type * }




const

  { Define the flag set for the LSQ Standard objects }
  lsqva_flags   =   [objf_spdef,objf_spass,objf_sigma,objf_lsqob,objf_lsqva];
  lsqpa_flags   =   [objf_spdef,objf_noass,objf_sigma,objf_lsqob,objf_lsqpa];
  lsqda_flags   =   [objf_spdef,objf_noass,objf_lsqob,objf_lsqda];
  lsqex_flags   =   [objf_noass,objf_lsqob];
  lsqex_mask    =   [objf_noass,objf_lsqob,objf_lsqva,objf_lsqpa,objf_lsqtb];


  JBNAME_VALUE  =            1;                 { Job Name Specific Action Index }
  JBTITL_VALUE  =            2;                 { Job Title Specific Action Index }
  JBSAVE_FNAME  =            3;                 { Job Status Save File Name Action Index }

  LSQPCD_VARBL  =           10;                 { Least-Squares P-CoDe File (pcdf) Specification Strinf change action }
  LSQVAR_TYPE   =           11;                 { Least-Squares Variable Specific Action Index }
  LSQEXP_TYPE   =           12;                 { Least-Squares Expression (MXD-V3 PARAM name = expr;) Specific Action Index }
  LSQITR_TYPE   =           13;                 { Least-Squares item field reference }
  LSQFTB_TYPE   =           14;                 { Least-Squares table Specific Action Index }
  LSQPQT_TYPE   =           15;                 { Least-Squares Predefined Quantity Specific Action Index }
  LSQPDQ_TYPE   =           16;                 { Least-Squares Data list Predefined Quantity Specific Action Index }


  objf_spca =  [objf_spdef,objf_refer,objf_spass]; { Define the set of specific action flags }




{ ****************************************************************************** }
{ ***  Global Variables of Cpas Shell environment declared here as external  *** }
{ ****************************************************************************** }


[external]
var
  sy_ival:                     integer; { INSYMBOL: Last readden integer number }
  sy_rval:                     mxd_flt; { INSYMBOL: Last readden floatting number }

  sy_noexec,                            { INSYMBOL: To flag the no exec mode }
  sy_nomacrflg:                boolean; { INSYMBOL: Flag to disable the mac. parm replace }
  sy_macro:                    idm_ptr; { INSYMBOL: Last readen macro symbol pointer }

  sy_maclst,                            { INSYMBOL: Macro Expenssion Source Line }
  sy_string:                str_string; { INSYMBOL: Last readden string }
  sy_ident:                 ide_string; { INSYMBOL: Last readden identifier }
  sy_cmin,                              { INSYMBOL: Last readden character in major }
  sy_ch:                          char; { INSYMBOL: Last readden character }
  sy_sym:                      sym_rec; { INSYMBOL: Symbol found }
  sy_idenew:                   ide_ptr; { IDE_NEW:  Pointer to the last created symbol }
  sy_endsy,                             { INSYMBOL: related End Symbol or nothing }
  lastsymb:                     symbol; { Last symbol in source }

  idm_space,                            { Flag for space already out }
  idm_outmacro:                boolean; { Flag to generate a macro stream }

  idm_newmac:                  idm_apt; { Macro in build }
  idm_actstk,                           { Stack pointer of active macro code }
  idm_tmphde,                           { Stack pointer of temporary macro parm }
  idm_defstk:                  idm_ptr; { Stack pointer of Defined Macro Identifiers }

  idm_liblifo:                 stq_ptr; { Stack (LiFo) of macro library specifications }

  mop_tab:                   mope_tabt; { Define the macro operator reference lists }

{
  dty_tab:                   type_idtb; { Acces type definition from sequence number }
  dty_nbr:                     integer; { Number of defined types }

  keyword_tree:            keyword_ptr; { Keyword definition tree }

  symc_stk:                   symc_ptr; { Symbol context pointer }

  list_dataflg,                         { Flag to list of data during data build time }
  debug_macsrc,                         { Debug Macro Source }
  debug_mac,                            { Debug of macro }
  debug_sym,                            { Debug on Input syntax unit flag }
  debug_exp,                            { Debug on Expression element flag }
  debug_dat:                   boolean; { Debug on Data Management }

  sy_npcd_flg,                          { To flag the not open pcd file status }
  sy_init_mod:                 boolean; { Program init flag mode }

  disp_tab:                 disp_tabty; { The Display levels table }

  curr_disp,                            { Current top of lex display }
  curr_idisp,                           { Display level of founded identifier }
  curr_lex:                    integer; { Current identifier lex }

  str_typ,                              { Standard string type identifier pointer }
  int_typ,                              { Standard integer type identifier pointer }
  flt_typ,                              { Standard float type identifier pointer }
  fta_typ:                     typ_ptr; { Standard table type identifier pointer }

  ret_ide,                              { Mfunction return identifier pointer body }
  curr_ide,                             { Current identifier to search (or nil) }
  udc_int,                              { Undeclared Integer }
  udc_ident:                   ide_ptr; { Undeclared Identifier }

  furf_hde,
  furf_lst:                   usrf_ptr; { Final User Referencable Identifier list Header }

  job_name,                             { MXD Job Name specification }
  job_save,                             { MXD Save file specification }
  job_title:                   ide_ptr; { Title of MXD job string }

  exp_null,                             { Null expression record }
  exp_res,                              { Current expressions to manage }
  exp_rs0,
  exp_rs1:                     exp_rec;

  ret_seq_count,                        { Return Sequence count for LSQ mfuntion application }
  ret_seq_incr,                         { Return sequence increment }
  ide_seq_count:              unsigned; { Identifier Sequence count for application }

  numerr_cnt,                           { Numeric error count }
  ierr:                        integer; { General error code }

  exp_nva,                              { Flag to No compile/(do not compute) a LSQ expression }
  data_mode,                            { Macro mode flag for insymbol }
  numerr_nstp,                          { Flag for no stop on numeric error }
  fatal_error:                 boolean; { General flag for fatal error }

  itm_cblk:                    itm_ptr; { Current item block pointer }

  io_winfo,                             { Wait process out information }
  io_libpath,                           { Path to *env.std and *.err files }
  io_err,                               { Open File Error variable }
  io_count,                             { Array input count identifier pointer }
  io_eoln,                              { EOLN flag identifier pointer }
  io_eof:                      ide_ptr; { EOF flag identifer pointer }


  sym_iof:                   iocnt_tab; { User text file descriptors }


  pcd:                            text; { Statement MXD-P-Code file }






{ ****************************************************************************** }
{ ***                   External Procedures and functions                    *** }
{ ****************************************************************************** }


{ ** Routine of the MXD_DCP_RTL module ** }

procedure PAS__BACK_TRACING( var f: text );
{ For debug: Output the trace of calls }
external 'PAS__BACK_TRACING';

procedure WRITE$OBJECT( flg: obj_flagsty );
{ For debug: Output a expression/type flag set }
external 'Write_Flg_Rec';

procedure WRITE$OBJECT( var exp: exp_rec );
{ For debug: Output the given expression record in a write/writeln statement }
external 'Write_Exp_Rec';

procedure TYPE_DISPLAY( p: typ_ptr; lvl: integer := 1 );
{ For debug: Output the given type record }
external;

procedure LISTING_SET_TITLE;
external;

procedure INSERT_MESSAGE( in_var msg: string );
external;

procedure TRACE( in_var s: string );
external;

procedure SRC_ERROR_S( modulesy:   error_mdnam;
                       number:     integer;
                       severity:   error_sev;
                       var id1, id2: [optional] string );
external;

function  CHECK_SYMB_ERR( mdnam: error_mdnam; exsy: symbol; nerr: integer; var id: [optional] string ): boolean;
external;

procedure SEARCH_FILE( in_var path, fname: string; acc: integer; var re: string; var fnd: boolean );
external;

function  IDE_SEARCH_FROM_NAMEID( ip: ide_ptr ): ide_ptr;
external;

procedure FREE_VAL_ALLOCATION( var val: val_rec );
external;

procedure DISPLAY_NEW;
external;
procedure DISPLAY_FREE;
external;

function  TYP_NEW( frm: typ_forms; ide: ide_ptr; pty: typ_ptr; ilvl: integer := 0 ): typ_ptr;
external;
function  IDE_NEW( cla: cla_kinds; typ: typ_ptr; ilvl: integer := 0 ): ide_ptr;
external;
function  LEVEL_SEARCH( fp: ide_ptr ): ide_ptr;
external;
function  IDE_SEARCH( berr: boolean; cls: cla_setty := [] ): ide_ptr;
external;
function  GET_VAL_FORMS( ty: typ_ptr ): val_forms;
external;
procedure VAL_ALLOCATE( var val: val_rec; typ: typ_ptr );
external;
procedure VAR_ALLOCATE( ide: ide_ptr );
external;
procedure COPY_STRING( var src: str_ptr; var trg: str_ptr );
external;
procedure VALUE_COPY( var tgr, src: val_rec; shf: integer := 0 );
external;
function  VAR_NEW( typ: typ_ptr; ilvl: integer := 0 ): ide_ptr;
external;

function  USR_ELTAB_SCINIT( typ: typ_ptr ): tbs_ptr;
external;
procedure USR_ELTAB_SCAN( tbs: tbs_ptr; var sindex: string; var bend: boolean );
external;
procedure USR_ELTAB_SCEND( tbs: tbs_ptr );
external;

function  USR_IDE_LOCATE( in_var id_name: string ): ide_ptr;
external;
procedure USR_IDE_APPEND( p: ide_ptr );
external;
procedure USR_IDE_REMOVE( p: ide_ptr );
external;
function  USR_GETPATH( sp: char; in_var st: string; var tbrf: val_ast ): integer;
external;
function  USR_SETPATH( in_var st: string; ist: integer; var tbrf: val_ast ): integer;
external;
procedure USR_IDE_SUBSTITUTE( in_var src: string; var dst: string; ch: char );
external;
procedure USR_S_ELEMENT(    var dst:  string;   { The extracted element string }
                         in_var src:  string;   { The string }
                                iel: integer;   { The element number starting from 0 }
                                csp,            { The separator character }
                                cst:   char;    { The string character (or space) }
                                bss: boolean := false   { The string expanding flag }
                       );
external;
procedure USR_SUPPRESS_COMMENT( in_var src: string; var dst: string; cc, cs: char );
external;
function  USR_NUMERIC_STRING( in_var str: string ): boolean;
external;



{ ** Routine of the MXD_DCP_BASINIT module ** }

procedure DCP_INIT;
external;


{ ** Routine of MXD_DCP_CALL module ** }



procedure DEFINE_OPER_INIT;
external;


{ ** Routine of the MXD_DCP_INSYMB module ** }

procedure SAVE_SYM_CNTX( svall: boolean := false );
external;
procedure RESTORE_SYM_CNTX;
external;

procedure GEN_MACRO_CODE;
external;
function  SEARCH_MACRO( knd: idm_kinds ): idm_ptr;
external;
procedure ACTIVE_MACRO_CODE( p: idm_ptr; svall: boolean := false );
external;
procedure RET_OF_MACRO_CODE( p: idm_ptr );
external;

procedure INSYMBOL;
external;
procedure SKIP_SYMBOL( tosymbol: symbol );
external;

function  INPUT_LETTER: char;
external;
procedure PRAGMA_STATE( p_src: src_ptr );
external;
procedure INCLUDE_STATE( bincl: boolean );
external;
procedure ENDFILE_STATE;
external;

procedure GENERATE_MACRO_PARM( pa: idm_ptr; bpar: boolean; fch: char );
external;
function  NEW_MACRO_EXPR: idm_ptr;
external;
procedure PURGE_MACRO_EXPR( var p: idm_ptr );
external;
procedure IN_DATA_VALUE( var val: val_rec; var bs: boolean );
external;


{ ** Routine of the MXD_DCP_BUITIN module ** }

procedure EXEC_BUILTIN( fnc: std_fnc; npa: integer );
external;

{ ** Routine of the MXD_DCP_EXPR module ** }

procedure EXPRV_REMOVE( var rec: exp_rec );
external;
procedure POP_EXPRESSION( var rec: exp_rec );
external;
procedure PUSH_EXPRESSION( var exp: exp_rec );
external;
procedure EXP_STK_COPY( lvl: integer := 0 );
external;

procedure EXP_GET_COPY( var rec: exp_rec; lvl: integer := 0 );
external;

procedure EXP_GENERIC_CALL( idp: ide_ptr; bexpr: boolean );
external;

function  EXP_GETKINDS( ish: integer ): val_forms;
external;

procedure CHECK_LVALUE_REF( var rec: exp_rec );
external;

procedure EXP_PUTSTR( in_var st: string );
external;
procedure EXP_PUTINT( iv: integer );
external;
procedure EXP_PUTFLT( rv, sg: mxd_flt := 0.0 );
external;

function  IN_FILEMODE( iv: integer ): flags_file;
external;

procedure EXTRACT_VALUE( var rec:    exp_rec;
                         var frm:  val_forms;
                         var iv:     integer;
                         var rv, sg: mxd_flt;
                         var st:      string  );
external;
procedure EXTRACT_STR( var rec: exp_rec; var st: string );
external;
function  EXTRACT_INT( var rec: exp_rec; iv: integer ): integer;
external;
function  EXTRACT_FLT( var rec: exp_rec; rv: mxd_flt ): mxd_flt;
external;

procedure GET_STREXPR( var str: string );
external;
function  GET_INTEXPR( iv: integer ): integer;
external;
function  GET_FLTEXPR( rv: mxd_flt ): mxd_flt;
external;
procedure GET_EXP_REFER( var rec: exp_rec; ide: ide_ptr := nil );
external;
procedure GET_EXPRESSION( var rec: exp_rec );
external;
procedure GET_INIT_VAL( var val: val_rec; mty: typ_ptr; var typ: typ_ptr; lvl: integer := 0; pname: ^string; blsy: boolean := true );
external;
procedure ASSIGNEMENT( trg: ide_ptr );
external;
procedure ARRSCA_SS_ASSIGN( var src, dst: exp_rec );
external;
procedure ARRSCA_II_ASSIGN( vsrc: integer; var dst: exp_rec );
external;
procedure ARRSCA_FF_ASSIGN( vval, vsig: mxd_flt; var dst: exp_rec );
external;
procedure ARRAY_SS_ASSIGN( var src, dst: exp_rec );
external;
procedure ARRAY_II_ASSIGN( var src, dst: exp_rec );
external;
procedure ARRAY_IF_ASSIGN( var src, dst: exp_rec );
external;
procedure ARRAY_FI_ASSIGN( var src, dst: exp_rec );
external;
procedure ARRAY_FF_ASSIGN( var src, dst: exp_rec );
external;
(*
procedure CREATE_NEW_ARR_DEF( var pn: typ_ptr; var  sz:     integer;
                                  po: typ_ptr;      np, nc: integer );
external;
*)
procedure EXPRESSION;
external;
procedure EXPRESSION_TYPE( typ: typ_ptr; bref: boolean );
external;
procedure GET_TYPE_EXPRESSION( var rec: exp_rec; typ: typ_ptr; bref: boolean );
external;
procedure GET_DIR_LARG( var exp: exp_rec; typ: typ_ptr; brf: boolean );
external;
procedure GET_FLT_MEXPR( pa: idm_ptr; typ: typ_ptr; var lsqob: boolean );
external;
function  GET_FLT_MVALUE( pa: idm_ptr ): mxd_flt;
external;

{ ** Routine of the MXD_DCP_ITEM module ** }

procedure ITEM_ADAPT_NAME( in_var snm: string; var nam: string; var nv: integer );
external;
function  ITEM_NEW( itmty: ide_ptr; in_var sname: string ): itm_ptr;
external;
function  ITEM_TYPE_SEARCH( berr: boolean := true ): typ_ptr;
external;
function  ITEM_FIELD_SEARCH( bdat: boolean; berr: boolean := true ): ide_ptr;
external;
function  ITEM_SEARCH( typ: typ_ptr; in_var sname: string; ball: boolean := false ): itm_ptr;
external;
procedure DECLARE_ITEM_TYPE;
external;
procedure DECLARE_ITEM_OBJ( idt: ide_ptr );
external;
procedure GEN_END_ITEM_BLOCK;
external;
procedure TABLE_GENERATOR;
external;
procedure INTEGR_TAB_GENERATOR;
external;
procedure FNC_SELECT;
external;
procedure FNC_INTEGR;
external;
procedure FNC_SUMMATION;
external;
procedure FNC_SUMMDATA;
external;



{ ** Routine of the MXD_DCP_COMP module ** }

procedure GET_STR_VALUE( var str: string; pa: idm_ptr );
external;
function  GET_INT_VALUE( pa: idm_ptr ): integer;
external;
function  GET_FLT_VALUE( pa: idm_ptr ): mxd_flt;
external;
function  VARBL_DECL( cla: cla_kinds := cla_varbl; fitm, sco: boolean := false; itt: typ_ptr := nil ): integer;
external;
procedure STATELIST( stopper: symbol );
external;



{ ** Routine of the MXD_DCP_LSQ module ** }

procedure DCP_LSQ_INIT;
external;

procedure DCP_LSQ_SUMMARY;
external;

function DCP_LSQ_INTIDE( nsz: integer := 1 ): integer;
external;

procedure DCP_DEF_LSQ_VARBL( ip: ide_ptr );
external;

procedure DCP_ASS_LSQ_VARBL( var rec: exp_rec );
external;

procedure DCP_DEF_LSQ_PARM( ip: ide_ptr );
external;

procedure OUT_RETPAR_DEF( var rec: exp_rec );
external;

procedure OUT_PCD_VREF( var exp: exp_rec; binv: boolean := false );
external;

procedure OUT_ITEM_FREF( var exp: exp_rec; itmrcd, itmiid, offset: integer );
external;

procedure OUT_ND_CODE( nd: node_code );
external;

procedure OUT_STM_CODE( stm: ope_stm );
external;

procedure DEFINE_SPECIFIC( ip: ide_ptr );
external;

procedure ASSIGN_SPECIFIC( var rec: exp_rec );
external;

procedure ITEM_EXPORT( itm: itm_ptr );
external;

procedure OUT_PCD_DIRECTIVE( cd, nsq, npa: integer; var extb: array[sz: integer] of exp_rec; brf: boolean );
external;
procedure OUT_PCD_LINDEX( id: ide_ptr );
external;
procedure OUT_PCD_CONST( val: mxd_flt );
external;
procedure OUT_PCD_INTSUMM_ND( intg: boolean );
external;
procedure OUT_PCD_SELECT( narg: integer );
external;
procedure DATA_ITEM_EXPORT( datp: dat_ptr );
external;



{ ** Routine of the MXD_DCP_DATA module ** }

procedure COMPLETE_DATA_ITEM( typ: typ_ptr; itm: itm_ptr );
external;
procedure DATA_CLEAR_ALL;
external;
procedure DATA_WRITE_INDEX;
external;



{ *** End of environment *** }
