{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*           MXD    data    Compiler    Experimental Data   Module             *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_DCP_DATA;


  %include        'MXDSRC:mxd_dcp_env'; { Load the mxd global environment }


const
  data_dir_spc  =     'MXD_D_LIST.ddi'; { File specification name for Data directory file }


type
  ass_ptr = ^ass_rec;                   { * Define the data field entry pointer * }

  ass_kinds = (                         { * Define the kinds of data field entry * }
                assk_itmref,            { Assign an item field }
                assk_itmarf,            { Assign an additional item field }
                assk_usrref,            { Assign a user identifier }
                assk_lineskip );        { Skip to next line entry }

  ass_rec = record                    { * Define the formulae record * }
    ass_nxt:           ass_ptr;         { Pointer to the next formulae record }
    ass_knd:         ass_kinds;         { Kind of assignation }
    ass_ide:           ide_ptr;         { Pointer to identifier }
    ass_exp:           idm_ptr;         { Pointer to the formulae macro text }
    ass_tbi:           integer;         { Value Index in the additional data table }
    ass_val:           val_rec          { Default value }
  end;


[static]
var
  data_dir_fil:      file of dat_descr; { Directory reference file }

  data_ini_flg,                         { Flag to initialize the data sub-system }
  data_old_flg:     boolean  :=   true; { Flag to keep or ignore the old data definitions }

  data_sequcp:      integer  :=      0; { Current sequence data count }
  data_mxflnb:      integer  :=     -1; { Current data file integer identifier number }

  data_first,                           { Data field list header }
  data_last:            dat_ptr := nil;

  data_fdtf:                   ide_ptr; { First data field pointer }
  data_ityp:                   typ_ptr; { Current item type pointer }
  data_item:                   itm_ptr; { Current item pointer }

  citem_ide:            ide_ptr := nil; { Define the item reference identifier to use for Data management }

  ass_fread,                            { First field entry to read }
  ass_first,                            { Header of the formulae queue list }
  ass_last:             ass_ptr := nil;

  adat_table:               adat_tabty; { Temporary table of additional data identifier }
  adat_count,                           { Count of the specified additional fields for the current data item }
  adat_lidx:            integer :=   0; { Index of the last specified additional fields for the current data item }


(*
procedure REFER_EXISTING_DATA( datp: data_ptr );
const
  mdnam = 'DATR';

begin
  with sy_sym, datp^, dat_desc do
  begin
    if sy = rparen then INSYMBOL
                   else SRC_ERROR( mdnam, 23, e_error );
    if (sy = issy) or ((sy = relop) and (op = eq_op)) then INSYMBOL
                                                      else SRC_ERROR( mdnam, 55, e_error );
    case data_kind of
      datk_table:   begin { ** For Data in a value table ** }
                      exp_nva := true;
                      GET_EXPRESSION( exp_res );
                      exp_nva := false
                    end;

      datk_pow_pat: begin { ** For Profile reffinement ** }
                    end;

      datk_hkl_sf,
      datk_hkl_f2,
      datk_hkl_ray: begin { ** For HKL diffraction Data ** }
                    end;
    otherwise
    end
  end
end REFER_EXISTING_DATA;
*)





procedure DATA_INIT;
{ To get all pre-existing(to run) data file informations }
var
  bok:         boolean;
  datp:        dat_ptr;
  rec:       dat_descr;

begin
  if data_old_flg then
  begin
    data_old_flg := false;
    data_first   :=   nil;
    OPEN( data_dir_fil, data_dir_spc, [read_file,error_file] );
    if iostatus = 0 then
    begin
      while not EOF( data_dir_fil ) do
      begin
        NEW( datp );                            { Create the Data record }
        READ( data_dir_fil, datp^.data_desc );  { Read the data record descriptor from the data directory file }
(*
with datp^.data_desc do
begin
WRITELN( ' Read from Index "', dat_name.body:dat_name.length, '" of type "', dat_tynam.body:dat_tynam.length, '"' )
end;
*)
        datp^.data_next := nil;                 { Init the data record and the data item links }
        datp^.data_itmp := nil;
        datp^.data_usef := false;               { Flag data as not already used }
(*
        data_sequcp := data_sequcp + 1;         { Allocate a data sequence number for this data item }
        datp^.dat_sequ := data_sequcp;
*)
        { Update the Maximum of integer file Identifier when required }
        if datp^.data_desc.dat_filnbr > data_mxflnb then data_mxflnb := datp^.data_desc.dat_filnbr;

        { Put the data item  in the data item queue }
        if data_first = nil then data_first := datp
                            else data_last^.data_next := datp;
        data_last := datp
      end;
      CLOSE( data_dir_fil )
    end
  end;
  if citem_ide = nil then
  begin
    NEW( citem_ide, cla_varbl );
    with citem_ide^, idev_val do
    begin
      ide_name    := nil;
      ide_lnk     := nil; ide_left    := nil; ide_right   :=       nil;
      ide_flg     :=  []; ide_displ   :=   0; ide_class   := cla_varbl;
      idev_spcact :=         0; idev_sequnb :=         0;
      val_frm     :=  vfrm_itm; itm         :=       nil
    end
  end
end DATA_INIT;



procedure COPY_NAME_TO_DATA( var rnm: dat_namty; in_var str: string );
begin
  rnm.length := str.length;
  for ii := 1 to str.length do  rnm.body[ii] := str[ii]
end COPY_NAME_TO_DATA;



function  NAME_MATCH( in_var rnm: dat_namty; in_var str: string ): boolean;
var
  br: boolean;
  ii: integer;

begin
  if rnm.length = str.length then
  begin
    br := true;
    ii := 0;
    while br and (ii < str.length) do
    begin
      ii := ii + 1; if rnm.body[ii] <> str[ii] then br := false
    end
  end
  else br := false;
  NAME_MATCH := br
end NAME_MATCH;



procedure SEARCH_ITEM_DATA( itm: itm_ptr );
var
  datp: dat_ptr;
  fnd:  boolean;

begin
  if itm <> nil then
  with itm^ do
  begin
    datp := data_first;
    fnd  :=      false;
    while datp <> nil do
    with datp^, data_desc do
    begin
    exit if NAME_MATCH( dat_tynam, itm_typ^.typ_ide^.ide_name^ ) and
            NAME_MATCH( dat_name, itm_name^ ) and (dat_nver = itm_nver);

      datp := data_next
    end;
    if datp <> nil then itm_datp := datp        { When an old data definition is matching, we set the data block link in the item }
                   else itm_datp :=  nil
  end
(*
;
if datp <> nil then
with datp^, data_desc do
  WRITELN( ' Find data Item "', dat_name.body:dat_name.length, '" of type "', dat_tynam.body:dat_tynam.length, '"' )
        else with itm^ do  WRITELN( ' item "', itm_name^, '" of type "', itm_typ^.typ_ide^.ide_name^, '" not found.' );
*)
end SEARCH_ITEM_DATA;



procedure DISPLAY_DATF;
var
  edf: ide_ptr;
  idx: integer;

  procedure DISPLAY_VALUE( val: val_rec );
  begin
    with val do
    case val_frm of
      vfrm_null: WRITE( 'NULL' );
      vfrm_str: if str = nil then WRITE( '' )
                             else WRITE( str^ );
      vfrm_int: WRITE( int:0 );
      vfrm_flt: WRITE( flt );
      vfrm_itf: WRITE( ifo:0 );
    otherwise
      WRITE( 'Form : ', val_frm )
    end
  end;

begin { DISPLAY_DATF }
  with data_item^, data_ityp^ do
  begin
    WRITELN( ' typ_ide <> nil = ', typ_ide <> nil );
    WRITELN( ' item type is "', typ_ide^.ide_name^, '"' );
    edf := data_fdtf;
    while edf <> nil do
    with edf^ do
    begin
      if ide_class = cla_varbl then WRITE( ' USR' )
                               else WRITE( ' ITM # ', idee_sequnb:0 );
      WRITE( ' Field "', ide_name^, '" type = "', ide_typ^.typ_ide^.ide_name^, '" Value = ' );
      if ide_class = cla_varbl then DISPLAY_VALUE( idev_val )
                               else DISPLAY_VALUE( itm_tab[idee_sequnb] );
      WRITELN;
      edf := ide_lnk
    end
  end
end DISPLAY_DATF;



procedure READ_DATA_PROCESS;
const
  mdnam = 'RDAT';
  fnmpr = 'MXD_D_file_';
  fnmex = '.dat';

var
  nblk, idx, num_err, isv, iso:integer;
  cass:                        ass_ptr;
  idf:                         ide_ptr;
  typ:                         typ_ptr;
  itm, sv_citmblk:             itm_ptr;
  snm, sfnam:                   string;
  bsng, nva_sav:               boolean;


  procedure SET_FORMULA_VAL( var val: val_rec; wex: idm_ptr );
  { Set a formula value in the specified data item field and return <true>
    when the field  was a sentinel with the stop value (< 0.5).
  }
  var
    st:        [static] string;

  begin
    with val do
    begin
      case val_frm of
        vfrm_str: begin
                    if str <> nil then DISPOSE( str );
                    GET_STR_VALUE( st, wex );
                    if st.length > 0 then begin  NEW( str, st.length ); str^ := st  end
                                     else str := nil
                  end;
        vfrm_int: int := GET_INT_VALUE( wex );
        vfrm_flt: flt := GET_FLT_VALUE( wex );
      otherwise
      end
    end
  end SET_FORMULA_VAL;


  procedure DISPLAY_ASS( pass: ass_ptr; bisv: boolean );
  begin
    with data_item^, data_ityp^, pass^ do
    begin
      WRITE( ' ':2, ass_knd:10 );
      case ass_knd of
        assk_itmref:
          begin
            WRITE( ' Symbol "', ass_ide^.ide_name^, '" set at ' );
            with itm_tab[ass_tbi] do
              case val_frm of
                vfrm_int: WRITE( ' Ival = ', int:0 );
                vfrm_flt: WRITE( ' Fval = ', flt:0 );
              otherwise
              end;
            if bisv then
            begin
              WRITE( ' idof = ', ass_ide^.idee_sequnb:0, ', isof = ', iso:0, ', isv = ', isv:0, ' => Value ' );
              if (isv > 0) or (iso >= ass_ide^.idee_sequnb) then WRITE( 'was set' )
                                                            else WRITE( 'do not change' )
            end
          end;
        assk_itmarf:
          begin
            WRITE( ' Symbol "', ass_ide^.ide_name^, '" set at ' );
            with itm_tab[ass_tbi] do
              case val_frm of
                vfrm_int: WRITE( ' Ival = ', int:0 );
                vfrm_flt: WRITE( ' Fval = ', flt:0 );
              otherwise
              end
          end;
        assk_usrref:
          begin
            WRITE( ' Symbol "', ass_ide^.ide_name^, '" set at ' );
            with ass_ide^.idev_val do
              case val_frm of
                vfrm_int: WRITE( ' Ival = ', int:0 );
                vfrm_flt: WRITE( ' Fval = ', flt:0 );
              otherwise
              end
          end;
      otherwise
      end;
      WRITELN
    end
  end DISPLAY_ASS;



begin { READ_DATA_PROCESS }
  sv_citmblk := itm_cblk;                       { Save the current item block context }
  num_err := 0;
  nva_sav := exp_nva; exp_nva := false;
  if (ass_first <> nil) and (data_item <> nil) then
  with sy_sym, data_item^, data_ityp^ do
  begin
    WRITEV( sfnam, fnmpr, itm_datp^.data_desc.dat_filnbr:-4, fnmex );
    OPEN( dat_out, sfnam, [write_file,error_file] );

    if iostatus = 0 then
    begin
      WRITE_DATF_ST( 'MXDV4-DATA-BASE' );       { ... we write the Binary DAta Base file Label }

      { We must set the initial default values (zero or empty string) in all item data fields }
      idf := typ_fel;
      idx :=       1;
      while (idx <= typ_nid) and (idf <> nil) do        { Loop to skip the identification item fields }
      begin  idf := idf^.ide_lnk; idx := idx + 1  end;

      while (idx <= typ_nfl) and (idf <> nil) do        { Loop to set the default values of all data fields }
      with itm_tab[idx], idf^ do
      begin
        val_frm := GET_VAL_FORMS( ide_typ );
        case val_frm of
          vfrm_str: str := nil;
          vfrm_int: if idee_isent then begin  iso := idee_sequnb; int := 1  end
                                  else int := 0;
          vfrm_itm: begin  val_frm := vfrm_itf; ifo := 0  end;
          vfrm_flt: begin  flt := 0.0; sig := 0.0  end
        otherwise
          { Data field are always scalars }
        end;
        idf := idf^.ide_lnk; idx := idx + 1
      end;

      nblk := 0;
      while (sy <> eofsy) and (sy <> endsy) do          { Main Data File Read Loop }
      begin
        case sy of
          includesy, { To include or chaine a file }
          chainesy: begin
                      if sy = includesy then nblk := nblk + 1;
                      INCLUDE_STATE( sy = includesy );
                      if sy = semicolon then INSYMBOL
                    end;

          eolnsy:   INSYMBOL;

          eofsy,
          peofsy:   begin { To end a file include }
                      nblk := nblk - 1;
                      if nblk >= 0 then begin  ENDFILE_STATE; INSYMBOL  end
                                   else sy := endsy
                    end;

          identsy:
            begin { For any field setting by item reference }
              typ := ITEM_TYPE_SEARCH;           { Locate the identifier related item type }
              itm := nil;
              if typ <> nil then
              begin
                INSYMBOL;                        { Gobble up the Item Type identifier }
                if sy = lparen then INSYMBOL
                               else SRC_ERROR( mdnam, 22, e_error );
                snm.length := 0;                 { Get the item string and locate it }
                GET_STREXPR( snm );
                if snm.length > 0 then
                begin
                  itm := ITEM_SEARCH( typ, snm );
                  if itm = nil then              { item is not found => Error }
                    SRC_ERROR_S( mdnam, 268, e_error, snm, typ^.typ_ide^.ide_name^ )
                  else                           { When the found item is a block header item ... }
                    if itmf_blk in typ^.typ_ifl then
                      itm_cblk := itm            { ... we set it as the current item block }
                end else itm := nil;
                if sy = rparen then INSYMBOL
                               else SRC_ERROR( mdnam, 23, e_error );
                if sy = semicolon then INSYMBOL
              end;
              { We must locate the specified item field }
              idf := data_fdtf;
              while idf <> nil do
              with idf^ do
              begin
                if ide_typ = typ then
                begin
                  if itm <> nil then data_item^.itm_tab[idee_sequnb].ifo := itm^.itm_sequ
                                else data_item^.itm_tab[idee_sequnb].ifo := 0;
                  exit
                end;
                idf := ide_lnk
              end
            end;

          endsy: ; { Nothing to do }

        otherwise
          { Statement to set line default value (specified in the data format) }

(*
WRITELN( ' **** Read Sequence :' );
*)

          cass := ass_fread;
          while cass <> nil do                          { Loop on all data fields to set the Default values }
          with cass^ do
          begin
            { We init the item fields to there line default values }
            if ass_val.val_frm <> vfrm_null then
              if ass_knd = assk_itmref then
                with ass_ide^, itm_tab[ass_tbi] do
                  case val_frm of
                    vfrm_str: str := ass_val.str;
                    vfrm_int: int := ass_val.int;
                    vfrm_flt: flt := ass_val.flt;
                  otherwise
                  end
              else if ass_knd = assk_usrref then
                with ass_ide^, idev_val do
                  case val_frm of
                    vfrm_str: str := ass_val.str;
                    vfrm_int: int := ass_val.int;
                    vfrm_flt: flt := ass_val.flt;
                  otherwise
                  end;
            cass := ass_nxt
          end;

          { Now we read the data from the source file }
          cass := ass_fread;
          while cass <> nil do                          { Loop to read the fields values from the data file }
          with cass^, data_item^ do
          begin
            case ass_knd of
              assk_itmref: IN_DATA_VALUE( itm_tab[ass_tbi], bsng );
              assk_itmarf: IN_DATA_VALUE( itm_tab[ass_tbi], bsng );
              assk_usrref: IN_DATA_VALUE( ass_ide^.idev_val, bsng );
              assk_lineskip:
                begin
                  while (sy <> eolnsy) and (sy <> peofsy) and (sy <> eofsy) do INSYMBOL;
                  INSYMBOL
                end;
            otherwise
            end;

(*
DISPLAY_ASS( cass, false );
*)

            cass := ass_nxt
          end;

(*
WRITELN( ' Read Value :' );
DISPLAY_DATF;
*)

          if typ_nis > 0 then isv := itm_tab[typ_nis].int
                         else isv := 1;

(*
WRITELN( ' **** Formulae Sequence :' );
*)
          with data_item^, data_ityp^ do
          begin  { Now we apply the data formulae to complete all observation data }
            cass := ass_first;
            while (cass <> ass_fread) and (cass <> nil) do
            with cass^ do                           { Loop on all formulae }
            begin
              if ass_ide <> nil then
              case ass_knd of
                assk_itmref, assk_itmarf:
                  if (ass_ide^.idee_sequnb <= iso) or (isv > 0) or (ass_knd = assk_itmarf) then
                  begin
                    SET_FORMULA_VAL( itm_tab[ass_tbi], ass_exp );
                    if ass_ide^.idee_isent then isv := itm_tab[typ_nis].int
                  end;

                assk_usrref:
                 SET_FORMULA_VAL( ass_ide^.idev_val, ass_exp );

              otherwise
              end;
(*
DISPLAY_ASS( cass, true );
*)
              cass := ass_nxt
            end;

(*
WRITELN( ' Formulae Value :' );
DISPLAY_DATF;
*)

            if isv <> 0 then
            with data_ityp^ do
            begin { Now we write the item data field to the data output file }

              { We write BDA in binary ( == not MXD_DCP/BDA Debug ) }
              for ii := typ_nid+1 to typ_nfl + adat_count do
              with itm_tab[ii] do
              case val_frm of
                vfrm_str: if str = nil then WRITE_DATF_ST( '' )
                                       else WRITE_DATF_ST( str^ );
                vfrm_int: WRITE_DATF_SL( int );
                vfrm_itf: WRITE_DATF_SL( ifo );
                vfrm_flt: WRITE_DATF_DB( flt );

              otherwise
              end;
              if itm_datp <> nil then with itm_datp^, data_desc do dat_nrec := dat_nrec + 1
            end
          end;
          INSYMBOL
        end { case sy of --- end }
      end;                                      { End of Main Read Loop }
      CLOSE( dat_out )
    end
    else SRC_ERROR_S( mdnam, 850, e_error, sfnam );
    if sy = endsy then INSYMBOL;

    if num_err > 0 then
      SRC_ERROR_S( mdnam, 289, e_warning, itm_name^ )

  end;
  exp_nva := nva_sav;
  itm_cblk := sv_citmblk                        { Restore the current item block context }
end READ_DATA_PROCESS;



procedure CREATE_NEW_DATA( typ: typ_ptr; itm: itm_ptr );
const
  mdnam = 'DATA';

var
  ass_curr:     ass_ptr := nil;                 { Current formula to manage }

  blv, idx, ial:       integer;
  idv:                 ide_ptr;


  function GET_F_IDENT( ty: typ_ptr ): ide_ptr;
  var
    idv: ide_ptr;

  begin
    idv := LEVEL_SEARCH(disp_tab[blv].disp_idt);{ Search the identifier as a Data Item Field }
    if idv = nil then
    begin
      idv := IDE_SEARCH( false, [cla_varbl] );  { Search it as a Declared additional Data Item Field }
      if idv <> nil then                        { Ignore any other identifier }
        if not (objf_lsqda in idv^.ide_flg) then idv := nil
    end;

    if idv = nil then                           { When the identifier was not existing in the local display level and not data add. field }
    begin
      idv := IDE_NEW( cla_varbl, flt_typ );     { Create a user identifier }
      if idv <> nil then
      begin
        idv^.idev_sequnb  :=         0;
        idv^.idev_val.val_frm := GET_VAL_FORMS( idv^.ide_typ );
      end
(*
;with idv^ do
WRITELN( ' User field "', ide_name^, '" cla = ', ide_class,
 ' as formula target of type = "', ide_typ^.typ_ide^.ide_name^, '" and frm = ', idev_val.val_frm );
*)
    end
    else
    with idv^ do
    begin
(*
WRITELN( ' Found field "', ide_name^, '" cla = ', ide_class,
 ' as formula target of type = "', ide_typ^.typ_ide^.ide_name^, '" and frm = ', itm_tab[idee_sequnb].val_frm );
*)
      if objf_lsqda in ide_flg then
        if adat_count >= ty^.typ_adv then SRC_ERROR( mdnam, 285, e_error )
        else
        begin
          adat_count := adat_count + 1;
          adat_table[adat_count] := idee_sequnb;
          adat_lidx := ty^.typ_nfl + adat_count;
          with itm^.itm_tab[adat_lidx] do
          begin  val_frm := vfrm_flt; flt := 0.0  end
(*
;WRITELN( ' DATA Add Field "', ide_name^, '" # ', adat_count:0, ' at item offset = ', adat_lidx:0, ' and with id = ', adat_table[adat_count]:0 )
*)
        end
      else
        if idee_sequnb <= ty^.typ_nid then
        begin
          SRC_ERROR_S( mdnam, 272, e_severe, ide_name^ );
          SKIP_SYMBOL( comma ); idv := nil
        end;
      if ide_typ <> nil then
        if ide_typ^.typ_frm = tfrm_itmty then
        begin
          SRC_ERROR_S( mdnam, 273, e_severe, ide_name^ );
          SKIP_SYMBOL( comma ); idv := nil
        end
    end;
    GET_F_IDENT := idv
  end GET_F_IDENT;



begin { CREATE_NEW_DATA }
  ass_first := nil;
  ass_last  := nil;
  ass_fread := nil;
  ial       :=   0;
  adat_count :=  0;
  with sy_sym, typ^, itm^ do
  begin
    DISPLAY_NEW;                                { Create a new display for the local symbols }
    blv := curr_disp;                           { Keep the base level for all our reference }
    disp_tab[blv].disp_idt := typ_fel;          { Attach the field tree to this display }
    disp_tab[blv].disp_own:=citem_ide;
    citem_ide^.ide_displ         :=     blv;    { Set the access item identfier as an access to the item's fields }
    citem_ide^.ide_typ           := itm_typ;
    citem_ide^.idev_val.itm :=          itm;
    data_item := itm;                           { Keep the data item and data item type pointers }
    data_ityp := typ;
    idv := typ_fel;
    idx := 1;
    while (idx <= typ_nid) and (idv <> nil) do
    with idv^ do
    begin
(*
WRITELN( ' Init F ', idee_sequnb:3, '/ "', ide_name^, '" type = "', ide_typ^.typ_ide^.ide_name^, '" frm = ', itm_tab[idee_sequnb].val_frm );
*)
      idx := idx + 1; idv := ide_lnk
    end;
    data_fdtf := idv;                           { Keep the first item data field pointer }
    while (idx <= typ_nfl) and (idv <> nil) do
    with idv^ do
    begin
      itm_tab[idee_sequnb].val_frm := GET_VAL_FORMS( idv^.ide_typ );
      if itm_tab[idee_sequnb].val_frm = vfrm_itm then itm_tab[idee_sequnb].val_frm := vfrm_itf;
(*
WRITELN( ' Init F ', idee_sequnb:3, '/ "', ide_name^, '" type = "', ide_typ^.typ_ide^.ide_name^, '" frm = ', itm_tab[idee_sequnb].val_frm );
*)
      idx := idx + 1; idv := ide_lnk
    end;


    DISPLAY_NEW;                                { Create a display for the user temporary variable }

    { * Get all user formulae, The target can be a new float identifier * }
    { * or a predefined item field (not an identification field).       * }
    INSYMBOL;                                   { Gobble up the do keyword }
    if sy = lparen then
    begin
      repeat
        INSYMBOL;                               { Gobble up the separator }
        if sy = identsy then
        begin
          idv := GET_F_IDENT( typ );            { For additional value, adat_lidx is set to the new data index }
          if idv <> nil then
          begin { Get a macro definition to set a value for this identfier }
            INSYMBOL;                             { Gobble up the identifier }
            if (sy <> becomes) and ((sy <> relop) or (op <> eq_op)) then SRC_ERROR( mdnam, 274, e_error );
            NEW( ass_curr );
            with ass_curr^ do
            begin
              ass_nxt := nil;
              ass_tbi :=   0;
              if idv^.ide_class = cla_varbl then
                if objf_lsqda in idv^.ide_flg then begin  ass_knd := assk_itmarf; ass_tbi := adat_lidx  end
                                              else ass_knd := assk_usrref
              else begin  ass_knd := assk_itmref; ass_tbi := idv^.idee_sequnb  end;
              ass_ide := idv;
              ass_exp := NEW_MACRO_EXPR;          { Get the expression }
              ass_val.val_frm := GET_VAL_FORMS( idv^.ide_typ )
            end;
            if ass_first = nil then ass_first := ass_curr
                               else ass_last^.ass_nxt := ass_curr;
            ass_last := ass_curr;
(* /// Value can be get by call  GET_INT_VALUE or GET_FLT_VALUE( wex ) *)
(* /// Purge by PURGE_MACRO_EXPR( wex ) *)
          end
        end
      until sy <> comma;
      if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
                      else INSYMBOL
    end;

    { Read the data format (order and line end marker only) }
    repeat
      if sy = identsy then
      begin
        idv := GET_F_IDENT( typ );
        if idv <> nil then
        begin { Get a macro definition to set a value for this identfier }
          NEW( ass_curr );
          with ass_curr^, ass_val do
          begin
            ass_nxt := nil;
            if idv^.ide_class = cla_varbl then ass_knd := assk_usrref
            else
              if objf_lsqda in idv^.ide_flg then begin  ass_knd := assk_itmarf; ass_tbi := adat_lidx  end
                                            else begin  ass_knd := assk_itmref; ass_tbi := idv^.idee_sequnb  end;
            ass_ide := idv;
            ass_exp := nil;
            val_frm := GET_VAL_FORMS( idv^.ide_typ );
            INSYMBOL;
            if (sy = becomes) or ((sy = relop) and (op = eq_op)) then
            begin { Get the default value when specified }
              INSYMBOL;
              GET_TYPE_EXPRESSION( exp_rs0, idv^.ide_typ, false );
              ass_val := exp_rs0.exp_val
            end
            else
            case val_frm of
              vfrm_str: str := nil;
              vfrm_int: int :=   0;
              vfrm_flt: begin  flt := 0.0; sig := 0.0  end;
            otherwise
            end
(*
;WRITE( ' To Read ' );
if idv^.ide_class = cla_varbl then WRITE( 'USR' ) else WRITE( 'ITM' );
WRITE( ' Field "', idv^.ide_name^, '" index = ', ass_tbi:0, ' with def val frm = ', val_frm, ' ' );
case val_frm of
              vfrm_int: WRITELN( ' = ', int:0 );
              vfrm_flt: WRITELN( ' = ', flt );
otherwise
WRITELN
end
*)
          end;
          if ass_fread = nil then ass_fread := ass_curr;
          if ass_first = nil then ass_first := ass_curr
                             else ass_last^.ass_nxt := ass_curr;
          ass_last := ass_curr
        end
      end;
      if (sy = mulop) and (op = div_op) then
      begin { "/" for end of line skip }
        NEW( ass_curr );
        with ass_curr^ do
        begin
          ass_nxt := nil; ass_knd := assk_lineskip;
          ass_ide := nil; ass_exp := nil;
          ass_val.val_frm := vfrm_null
        end;
        if ass_first = nil then ass_first := ass_curr
                           else ass_last^.ass_nxt := ass_curr;
        ass_last := ass_curr;
        sy := comma
      end;
    exit if sy <> comma;
      INSYMBOL
    until false;
    if sy <> semicolon then SRC_ERROR( mdnam, 21, e_error )
                       else INSYMBOL;

(*
ass_curr := ass_first;
while ass_curr <> nil do
with ass_curr^ do
begin
  WRITELN( ' Create ass_rec : ', ass_knd );
  if ass_ide = nil then WRITE( ' ide = nil' ) else WRITE( ' ide = "', ass_ide^.ide_name, '"' );
  if ass_exp <> nil then WRITE( ' Formula' );
  if ass_ide <> nil then
  with ass_ide^ do
  begin
    if ide_class = cla_varbl then WRITE( ' ide frm = ', idev_val.val_frm )
                             else WRITE( ' # ', idee_sequnb:0, ' itm_frm = ', itm^.itm_tab[idee_sequnb].val_frm );
    WRITE( ' type = "', ass_ide^.ide_typ^.typ_ide^.ide_name^, '"' )
  end;
  WRITELN( ' frm = ', ass_val.val_frm );
  if ass_val.val_frm <> vfrm_null then
  begin
    WRITE( ' default value = ' );
    with ass_val do
    case val_frm of
      vfrm_str: if str = nil then WRITE( '""' )
                             else WRITE( '"', str^, '"' );
      vfrm_int: WRITE( int );
      vfrm_flt: WRITE( flt );
    otherwise
    end;
    WRITELN
  end;
  ass_curr := ass_nxt
end;
*)

    { Read and records all Data }
    if itm_datp = nil then
    begin
      NEW( itm_datp );
      with itm_datp^, data_desc do
      begin
(*
WRITELN( ' ******* Data Create ********' );
*)
        data_next :=       nil;         { Put it at the end of Data item list }
(*      data_sequ :=  itm_sequ;         { Set the data item sequence number - (used for pcode file) } *)
        COPY_NAME_TO_DATA( dat_tynam, itm_typ^.typ_ide^.ide_name^ );    { Copy the item type name (used for pcode file) }
        COPY_NAME_TO_DATA( dat_name, data_item^.itm_name^ );            { Copy the item name (used for pcode file) }
        dat_nver        :=    itm_nver; { Copy the item version (used for pcode file) }
        data_mxflnb := data_mxflnb + 1; { Update the data filenumber (First number is zero) }
        dat_filnbr      := data_mxflnb  { Set the data file number }
      end;
      if data_first = nil then data_first := itm_datp
                          else data_last^.data_next := itm_datp;
      data_last := itm_datp
    end;
(*
    else
      with itm_datp^, data_desc do
      begin
WRITELN( ' ******* Data Supershed ********' );
      end;
*)

    with itm_datp^, data_desc do
    begin
      data_itmp       :=   data_item;   { Set the Link to the related item record (used for pcode file) }
      data_usef       :=        true;   { Data is directly used }
      dat_itmpcd      :=     typ_pcd;   { Set the Data type code }
      dat_nrec        :=           0;   { Init the number of observation }
      dat_adln        :=  adat_count;   { Set the additional identifier table size ... }
      for ii := 1 to max_adidtb_size do { ... and fill the related table }
        if ii <= dat_adln then dat_adtb[ii] := adat_table[ii]
                          else dat_adtb[ii] := 0
(*
;for ii := 1 to dat_adln do
WRITELN( ' Data Add tab[',ii:0, '] = ', dat_adtb[ii]:0 );
*)
    end;

    if data_fdtf <> nil then READ_DATA_PROCESS;

    { Free all filed management records }
    while ass_first <> nil do
    begin
      ass_last := ass_first;
      ass_first := ass_first^.ass_nxt;
      DISPOSE( ass_last )
    end;

    { Free all display }
    DISPLAY_FREE;                               { Free the user display level }
    curr_disp := PRED( curr_disp )              { Detach the item field display }
  end
end CREATE_NEW_DATA;



procedure REFER_EXISTING_DATA( itm: itm_ptr );
const
  mdnam = 'RFDA';

begin
(*
WRITELN( ' ******* Old Data Use ********' );
*)
  with itm^ do
  if itm <> nil then
    with itm^ do
    begin
      if itm_datp <> nil then
      begin
        itm_datp^.data_itmp := itm;
        if itm_datp^.data_usef then SRC_ERROR_S( mdnam, 275, e_error, itm_name^ );
        itm_datp^.data_usef := true
      end
      else SRC_ERROR_S( mdnam, 276, e_error, itm_name^ )
    end
  else SRC_ERROR( mdnam, 276, e_error )
end REFER_EXISTING_DATA;



[global]
procedure COMPLETE_DATA_ITEM( typ: typ_ptr; itm: itm_ptr );
begin
  DATA_INIT;                            { Init the data Sub-System if not already done }
  with sy_sym do
  begin
    SEARCH_ITEM_DATA( itm );            { Search a data block in the already existing data (from data index) }
(*
with itm^ do
if itm_datp = nil then WRITELN( ' New Data Item "', itm_name^, '"' )
                  else with itm_datp^, data_desc do WRITELN(' Existing file for data item "',dat_name.body:dat_name.length, '"' );
*)
    if sy = dosy then CREATE_NEW_DATA( typ, itm )       { We can create a new data record with new data file }
                 else REFER_EXISTING_DATA( itm );
    if itm^.itm_datp <> nil then DATA_ITEM_EXPORT( itm^.itm_datp )
  end
end COMPLETE_DATA_ITEM;




[global]
procedure DATA_CLEAR_ALL;
{ Flush all previously(to run) data structure }
begin
  if data_old_flg then data_old_flg := false
                  else SRC_ERROR( 'CLRD', 1001, e_error );

end DATA_CLEAR_ALL;




[global]
procedure DATA_WRITE_INDEX;
const
  mdnam = 'WDDI';

var
  dat: dat_ptr;

begin
  if data_first <> nil then
  begin
    OPEN( data_dir_fil, data_dir_spc, [write_file,error_file] );
    dat := data_first;
    if iostatus = 0 then
    begin
      while dat <> nil do
      with dat^ do
      begin
(*
with data_desc do
WRITELN( ' Data Index  write "', dat_name.body:dat_name.length, '" of type "',dat_tynam.body:dat_tynam.length, '"' );
*)
        if data_desc.dat_nrec > 0 then WRITE( data_dir_fil, data_desc );
        dat := data_next
      end;
      CLOSE( data_dir_fil )
    end
    else
    begin
      WRITELN( ' *** ', task_name, ' FATAL ERROR : Cannot create the Data Item Index file "', data_dir_spc, '" code ', iostatus:0 );
      PASCAL_EXIT( 4 )
    end
  end
end DATA_WRITE_INDEX;


end MXD_DCP_DATA.
