{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*               MXD   Data   Compiler  Interpretor   Module                   *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module mxd_dcp_exec;

  %include        'MXDSRC:mxd_dcp_env';         { Load the MXD data Compiler Environment }





     {**************************************}
     { MACRO CODE GENERATION group Routines }
     {**************************************}


[global]
function GET_INT_VALUE( pa: idm_ptr ): integer;
const
  mdnam = 'IVAL';

var
  res: integer;

begin
  res := 0;
  with pa^ do
  if idm_kind <> idm_parm then SRC_ERROR( mdnam, 351, e_severe )
  else
  begin
    ACTIVE_MACRO_CODE( pa );
    INSYMBOL;
    res := GET_INTEXPR( 0 );
    RET_OF_MACRO_CODE( pa )
  end;
  GET_INT_VALUE := res
end GET_INT_VALUE;



[global]
function GET_FLT_VALUE( pa: idm_ptr ): mxd_flt;
const
  mdnam = 'FVAL';

var
  res: mxd_flt;

begin
  res := 0.0;
  with pa^ do
  if idm_kind <> idm_parm then SRC_ERROR( mdnam, 352, e_severe )
  else
  begin
    ACTIVE_MACRO_CODE( pa );
    INSYMBOL;
    res := GET_FLTEXPR( 0.0 );
    RET_OF_MACRO_CODE( pa )
  end;
  GET_FLT_VALUE := res
end GET_FLT_VALUE;



[global]
procedure GET_STR_VALUE( var st: string; pa: idm_ptr );
const
  mdnam = 'SVAL';

begin
  with pa^ do
  if idm_kind <> idm_parm then SRC_ERROR( mdnam, 353, e_severe )
  else
  begin
    ACTIVE_MACRO_CODE( pa );
    INSYMBOL;
    GET_STREXPR( st );
    RET_OF_MACRO_CODE( pa )
  end
end GET_STR_VALUE;



function GEN_MACRO_LIST( mcmd: symbol ): idm_apt;
var
  p:           idm_apt;
  iv:          integer;
  sv_noexec:   boolean;

begin
  sv_noexec    :=    sy_noexec;
  sy_noexec    :=         true;
  idm_space    :=        false;
  idm_outmacro :=         true;
  with sy_sym, src_control^ do
  if sy <> eofsy then
  begin
    src_insnb := src_insnb + 1;
    if sy_ch > ' ' then GEN_MACRO_CODE;
    SKIP_SYMBOL( mcmd );
    if mcmd = untilsy then
    begin
       INSYMBOL;
       iv := GET_INTEXPR( 1 )
    end;
    { We create a length adapted macro code array }
    if idm_newmac <> nil then
    with idm_newmac^ do
    if idm_use > 0 then
    begin
      NEW( p, idm_use );
      p^.idm_use := idm_use;
      for i := 1 to idm_use do  p^.idm_ctb[i] := idm_ctb[i];
      idm_use := 0
    end
    else p := nil;
    src_insnb := src_insnb - 1
  end;
  idm_outmacro := false;
  sy_noexec := sv_noexec;
  GEN_MACRO_LIST := p
end GEN_MACRO_LIST;



[global]
function NEW_MACRO_LIST( mcmd: symbol ): idm_ptr;
{ Create a unnamed macro list }
{ The created macro parameter is not put in the defined stack }
var
  p: idm_ptr;

begin
  NEW( p );
  with p^ do
  begin
    idm_name := nil;
    idm_parl := nil;
    idm_cntx := nil;
    idm_nxt  := nil;
    idm_kind := idm_list;
    idm_run  := false;
    idm_tab  := GEN_MACRO_LIST( mcmd )
  end;
  NEW_MACRO_LIST := p
end NEW_MACRO_LIST;





     {************************************************}
     { EXECUTION MANAGER                     Routines }
     {************************************************}


[global]
procedure EXECUTE_MACRO_CODE( pmc: idm_ptr; stopper: symbol );
var
  s: sym_rec;

begin
  if pmc <> nil then
  begin
    s := sy_sym;
    ACTIVE_MACRO_CODE( pmc );
    STATELIST( endsy );
    RET_OF_MACRO_CODE( pmc );
    sy_sym := s;
  end
end EXECUTE_MACRO_CODE;




procedure REPEAT_STATE;
const
  mdnam = 'REAP';

var
  pr: idm_rec;
  ir: integer;
  c1, c2: char;

begin
  with sy_sym, pr do
  begin
    idm_name := nil;
    idm_parl := nil;
    idm_nxt  := nil;
    idm_prv  := nil;
    idm_kind := idm_list;
    idm_run  := false;
    sy       := nothing;                        { To force to ignore the present repeat }
    idm_tab  := GEN_MACRO_LIST( untilsy );
    idm_cntx := idm_actstk;
    c1 := sy_ch; c2 := sy_cmin;
    if sy <> eofsy then
    begin
      repeat
        idm_actstk := pr"address;
        idm_run    := true;
        sy_ch := ' ';
        idm_nch := 1;                           { Exec from the begining }
        STATELIST( untilsy );
        INSYMBOL;
        ir := GET_INTEXPR( 1 )
      until ir > 0
    end
    else
      SRC_ERROR( mdnam, 303, e_severe );
    { Restore the previous context }
    sy_ch := c1; sy_cmin := c2;
    sy := semicolon;
    idm_actstk := idm_cntx;
    DISPOSE( idm_tab )
  end
end REPEAT_STATE;



procedure WHILE_STATE;
const
  mdnam = 'WHIL';

var
  pr:          idm_rec;
  ir:          integer;
  c1, c2:         char;
  wex:         idm_ptr;

begin
  with sy_sym, pr do
  begin
    wex := NEW_MACRO_EXPR;
    if sy <> dosy then SRC_ERROR( mdnam, 120, e_error );
    idm_name := nil;
    idm_parl := nil;
    idm_nxt  := nil;
    idm_prv  := nil;
    idm_run  := false;
    idm_kind := idm_list;
    idm_tab  := GEN_MACRO_LIST( endsy );
    idm_cntx := idm_actstk;
    c1 := sy_ch; c2 := sy_cmin;
    if sy <> eofsy then
      while GET_INT_VALUE( wex ) > 0 do
      begin
        idm_actstk := pr"address;
        idm_run    := true;
        sy_ch := ' ';
        idm_nch := 1;                           { Exec from the begining }
        STATELIST( endsy );
        INSYMBOL
      end
    else
      SRC_ERROR( mdnam, 303, e_severe );
    { Restore the previous context }
    idm_actstk := idm_cntx;
    sy_ch := c1; sy_cmin := c2;
    INSYMBOL;
    DISPOSE( idm_tab );
    PURGE_MACRO_EXPR( wex )
  end
end WHILE_STATE;



procedure FOR_STATE;
const
  mdnam = 'FORL';

var
  pr:          idm_rec;
  ir, id, ie:  integer;
  c1, c2:         char;
  ip:          ide_ptr;

begin
  INSYMBOL;
  with sy_sym, pr do
  if sy = identsy then
  begin
    DISPLAY_NEW;
    ip := VAR_NEW( int_typ );
    if ip <> nil then
    with ip^, idev_val do
    begin
      INSYMBOL;
      if sy = becomes then INSYMBOL
                      else SRC_ERROR( mdnam, 32, e_error );
      id := GET_INTEXPR( 1 );
      case sy of
            tosy: begin  ir :=  1; INSYMBOL  end;
        downtosy: begin  ir := -1; INSYMBOL  end;
      otherwise
        SRC_ERROR( mdnam, 119, e_error )
      end;
      ie := GET_INTEXPR( id );
      if sy <> dosy then SRC_ERROR( mdnam, 120, e_error );
      if ir > 0 then ie := ie - id + 1
                else ie := id - ie + 1;
      int := id;

      idm_name := nil;
      idm_parl := nil;
      idm_nxt  := nil;
      idm_prv  := nil;
      idm_run  := false;
      idm_kind := idm_list;
      idm_tab  := GEN_MACRO_LIST( endsy );
      idm_cntx := idm_actstk;
      c1 := sy_ch; c2 := sy_cmin;
      if sy <> eofsy then
      for ii := 1 to ie do
      begin
        idm_actstk := pr"address;
        idm_run    := true;
        sy_ch := ' ';
        idm_nch := 1;                           { Exec from the begining }
        STATELIST( endsy );
        int := int + ir
      end
      else
        SRC_ERROR( mdnam, 303, e_severe );
      { Restore the previous context }
      idm_actstk := idm_cntx;
      sy_ch := c1; sy_cmin := c2;
      INSYMBOL;
      DISPOSE( idm_tab )
    end
    else
    begin
      SKIP_SYMBOL( endsy );
      INSYMBOL
    end;
    DISPLAY_FREE
  end
  else
  begin
    SRC_ERROR( mdnam, 102, e_severe );
    SKIP_SYMBOL( endsy );
    INSYMBOL
  end
end FOR_STATE;



[global]
procedure GEN_MACRO_BODY;
{ Common part to create a Macro statment/function (identifier is in sy_ident) }
const
  mdnam = 'MACB';

var
  pm, pp, psv, ph, pl: idm_ptr;
  bfnc:       boolean := false;

begin
  with sy_sym do
  begin
    pm := SEARCH_MACRO( idm_macro );
    if pm <> nil then
    begin { Cannot create two macros with the same name }
      SRC_ERROR_S( mdnam, 305, e_severe, sy_ident );
      SKIP_SYMBOL( endsy ); INSYMBOL;
      pm := nil
    end
    else
    begin
      NEW( pm );
      with pm^ do
      begin
        NEW( idm_name, sy_ident.length );
        idm_name^ := sy_ident;
        idm_cntx  := nil;
        idm_nxt   := nil;
        idm_prv   := idm_defstk;
        idm_run   := false;
        idm_kind  := idm_macro;
        idm_parl  := nil;
        idm_nch   := 0;
        INSYMBOL;                             { Skip in parameter list }
        { Mask all present macro definition }
        ph := nil;
        pl := nil;
        idm_defstk := nil;
        if sy <> semicolon then
        begin
          if sy = lparen then begin  INSYMBOL; bfnc := true  end;
          while sy = identsy do
          begin
            pp := SEARCH_MACRO( idm_parm );
            if pp = nil then
            begin
              NEW( pp );
              if pl = nil then ph := pp
                          else pl^.idm_parl := pp;
              with pp^ do
              begin
                NEW( idm_name, sy_ident.length );
                idm_name^ := sy_ident;
                idm_parl  := nil;
                idm_cntx  := nil;
                idm_nxt   := nil;
                idm_prv   :=  pl;
                idm_run   := false;
                idm_kind  := idm_parm;
                idm_nch   :=   0;
                idm_tab   := nil
              end;
              pl := pp
            end
            else SRC_ERROR_S( mdnam, 306, e_severe, sy_ident );
            INSYMBOL;
          exit if sy <> comma;
            INSYMBOL
          end;
          if bfnc then
            if sy = rparen then INSYMBOL
                           else SRC_ERROR( mdnam, 34, e_error );
          if sy <> semicolon then  SRC_ERROR( mdnam, 21, e_error )
        end;
        idm_parl := ph;                         { Attach the parameter list to the macro bloc }
        idm_defstk := idm_prv;                  { Restore the previous macro def. context }
        { Get the macro text }
        idm_tab := GEN_MACRO_LIST( endmacrosy );
        { Set the macro in the macro def. symbol list }
        if idm_defstk <> nil then idm_defstk^.idm_nxt := pm;
        idm_defstk := pm;
        INSYMBOL
      end
    end
  end
end GEN_MACRO_BODY;



procedure MACRO_STATE;
const
  mdnam = 'MACR';

var
  pm, pp, psv, ph, pl: idm_ptr;

begin
  with sy_sym do
  begin
    INSYMBOL;
    if sy <> identsy then
    begin
      SRC_ERROR( mdnam, 304, e_severe );
      SKIP_SYMBOL( endsy ); INSYMBOL
    end
    else GEN_MACRO_BODY
  end
end MACRO_STATE;



procedure MACLOAD_STATE;
{ Get a list of macro from the current macro lirary }
{ 64 macro names maximum for one call }
const
  mdnam = 'MCAL';

var
  pm:                          idm_ptr;
  p0, p1:                      stq_ptr;
  src_p:                       src_ptr;
  er, i, j, k:                 integer;
  mlst: [static] array[1..64] of ide_string;
  fnd, sv_noexec, sv_nomacrf:  boolean;

begin
  with sy_sym do
  begin
    i := 0;
    sy := comma;
    while (sy = comma) and (i < 64) do          { We store all the name of the list }
    begin
      INSYMBOL;                                 { Gobble up MACROLIB keyword or "," }
      fnd := false;
      pm  := SEARCH_MACRO( idm_macro );         { Search this identifier in the macro list }
      if pm <> nil then                         { When this macro is already defined  ... }
        SRC_ERROR_S( mdnam, 311, e_warning, sy_ident )  { ... we emit a warning and ignore this entry }
      else
      begin                                     { Put this macro identifier in the search list }
        i := i + 1;
        mlst[i] := sy_ident;
        INSYMBOL                                { Skip to the separator }
      end
    end;
    { Check for no macro list overflow }
    if (sy = comma) and (i >= 64) then SRC_ERROR( mdnam, 312, e_error );

    { Set the status for MACRO READ INSYMBOL Call }

    sv_nomacrf     :=     sy_nomacrflg;
    sv_noexec      :=        sy_noexec;
    SAVE_SYM_CNTX( true );                              { Save the Symbol context }

    j := 0; 
    p1 := idm_liblifo;                                  { Start from the last Macro library specification }
    while (j < i) and (p1 <> nil) do                    { Loop on all Macro library specification until load all specified macro(s) }
    begin
      src_p := nil;                                     { To force allocation by SRC_OPEN of a new source control block }
      SRC_OPEN( src_p, p1^.stq_str^, false, er );       { ... during the open of file to read }
      if er <> 0 then
      begin
        SRC_ERROR_S( mdnam, 315, e_fatal, p1^.stq_str^ );
        exit
      end;
      with src_p^ do
      begin
        src_previous := src_control;
        src_level := src_control^.src_level + 1;
        src_lstmxlev := src_control^.src_lstmxlev;
        src_insnb := src_control^.src_insnb;
(*     src_flags := src_flags +
          src_control^.src_flags * [src_bmacroex,src_bphys,
                                    src_becho,src_echerr] *)
      end;
      src_control := src_p;
      sy_ch     := ' ';
      sy_maclst :=  '';
      sy  :=   nothing;
      LISTING_SET_TITLE;

      while (j < i) and (sy <> macrosy) and (sy <> peofsy) do
      begin
       { Search a macro statement }
        while (sy <> macrosy) and (sy <> peofsy) and (sy <> eofsy) do INSYMBOL;
        if sy = macrosy then
        begin
          INSYMBOL;
          k := 0; fnd := false;
          while not fnd and (k < i) do
          begin
            k := k + 1;
            if STR_MATCH( mlst[k], sy_ident ) = 0 then fnd := true
          end;
          if not fnd then SKIP_SYMBOL( endmacrosy )
                     else begin  GEN_MACRO_BODY; mlst[k].length := 0; j := j + 1  end
        end
      end;
      src_control := src_p^.src_previous;
      SRC_CLOSE( src_p, true );         { Close the MACROLIB file and free the control when it is the last one }
      p1 := p1^.stq_lnk
    end;

    RESTORE_SYM_CNTX;                   { Restore the symbol context }
    sy_noexec     :=         sv_noexec; { Restore the original macro status }
    sy_nomacrflg  :=        sv_nomacrf;
    LISTING_SET_TITLE
 end
end MACLOAD_STATE;



procedure MACLIBR_STATE;
const
  mdnam = 'MACL';

[static] var
  pq:          stq_ptr;
  fnam, fspc:  string;
  i, j:        integer;
  fnd:         boolean;

begin
  with sy_sym do
  begin
    INSYMBOL;                            { Gobble up the MACROLIB Keyword }
    fnam.length := 0;
    GET_STREXPR( fnam );                 { Get the macro library file specification }
    if fnam.length > 0 then
    begin
      i := INDEX( fnam, '.', -1 );
      if i > 0 then
      begin
        if INDEX( fnam, '/', -1 ) > i then i := 0;
        if (i > 0) and (INDEX( fnam, '\', -1 ) > i) then i := 0;
        if (i > 0) and (INDEX( fnam, ':', -1 ) > i) then i := 0
      end;
      if i = 0 then fnam := fnam||'.mxl';
      SEARCH_FILE( mxd_search_path, fnam, 4 { Read Access }, fspc, fnd );
      if fnd then
      begin { When a not null string was specified }
        NEW( pq );                       { Create a new macrolib specification }
        with pq^ do
        begin
          stq_lnk := idm_liblifo;        { Push this specification in the Macro Library FiFo }
          idm_liblifo := pq;
          NEW( stq_str, fspc.length );   { ... and set this file specification in the new FiFo entry }
          stq_str^ := fspc
        end
      end
      else
        SRC_ERROR_S( mdnam, 310, e_error, fnam )
    end
    else
      if idm_liblifo <> nil then
      begin
        pq := idm_liblifo;
        idm_liblifo := pq^.stq_lnk;
        DISPOSE( pq )
      end
  end
end MACLIBR_STATE;



procedure PURGE_STATE;
const
  mdnam = 'PRGM';

var
  pm, pp: idm_ptr;

begin
  with sy_sym do
  loop
    INSYMBOL;
  exit if (sy = semicolon) or (sy = eofsy) or
          (sy = endsy) or (sy = untilsy);
    if sy = identsy then
    begin
      pm := SEARCH_MACRO( idm_macro );
      if pm = nil then SRC_ERROR_S( mdnam, 307, e_error, sy_ident )
      else
      begin
        with pm^ do
        { Check of do not purge an active macro }
        if idm_run then SRC_ERROR_S( mdnam, 308, e_severe, sy_ident )
        else
        begin
          { Supress the macro of the macro definition list }
          if idm_nxt = nil then idm_defstk := idm_prv           { Last in the macro list }
                           else idm_nxt^.idm_prv := idm_prv;    { Not first in the macro list }
          if idm_prv <> nil then idm_prv^.idm_nxt := idm_nxt;

          { Free the identifier name }
          DISPOSE( idm_name );
          while idm_parl <> nil do
          begin
            pp := idm_parl;
            idm_parl := idm_parl^.idm_parl;
            with pp^ do
            begin
              DISPOSE( idm_name );
              if idm_tab <> nil then DISPOSE( idm_tab )
            end;
            DISPOSE( pp )
          end;
          { Free the code }
          if idm_tab <> nil then DISPOSE( idm_tab )
        end;
        DISPOSE( pm )
      end
    end
    else SRC_ERROR( mdnam, 309, e_error );
    INSYMBOL;
    if sy <> comma then SRC_ERROR( mdnam, 37, e_error )
  end
end PURGE_STATE;



procedure CALL_MACRO;
const
  mdnam = 'CALM';

var
  pm, pp, pa, pc: idm_ptr;
  svch, svcm: char;

begin
  with sy_sym, lst_current^ do
  begin
    pm := sy_macro;
    with pm^ do
    begin { It is a defined macro }
      { Set all formal of macro as defined with the given effective values }
      pp := idm_parl;
      pa := nil;
      while pp <> nil do
      with pp^ do
      begin
        { Get the effective parameter value }
        GENERATE_MACRO_PARM( pp, false, ' ' );
        if debug_macsrc then
        with pp^do
        begin
          WRITELN( lst_file, ' Macro Parm "', idm_name^, '" :' );
          WRITE( lst_file, ' ' );
          if idm_tab <> nil then
          with idm_tab^do
            for ij := 1 to idm_use do WRITE( lst_file, idm_ctb[ij] )
          else WRITE( lst_file, '.nil.') ;
          WRITELN( lst_file )
        end;
        pa := pp;
      exit if sy <> comma;
        pp := idm_parl
      end;
      { Link the parameter string to the pmacro stack }
      pp := idm_parl;
      if pp <> nil then
      begin
        idm_defstk^.idm_nxt := pp;
        pp^.idm_prv := idm_defstk;
        idm_defstk  := pa
      end;
      if debug_macsrc then
      begin
        WRITELN( lst_file, ' Macro Stack include :' );
        pc := idm_defstk;
        while pc <> nil do
        begin
          WRITELN( lst_file, ' ::: "', pc^.idm_name^, '",' );
          pc := pc^.idm_prv
        end;
        WRITELN( lst_file, ' Macro Code of "', idm_name^, '" :' );
        WRITE( lst_file, ' "' );
        with idm_tab^do
          for ij := 1 to idm_use do WRITE( lst_file, idm_ctb[ij] );
        WRITELN( lst_file, '"' )
      end;

      ACTIVE_MACRO_CODE( pm, true );
      STATELIST( endmacrosy );
      RET_OF_MACRO_CODE( pm );

      { Unlink the macro parameters }
      if pp <> nil then
      with pp^ do
      begin
        idm_prv^.idm_nxt := pa^.idm_nxt;
        if pa^.idm_nxt <> nil then pa^.idm_nxt^.idm_prv := idm_prv
                              else idm_defstk := idm_prv
      end;
      while pp <> nil do
      with pp^ do
      begin
        if idm_tab <> nil then begin
                                 DISPOSE( idm_tab );
                                 idm_tab := nil
                               end;
        idm_nch  := 0;
        pp := idm_parl
      end;
    end
  end
end CALL_MACRO;



procedure TYPE_ATTRIBUTE( var flgr: obj_flagsty; var actr: integer );
const
  mdnam = 'ATTR';
  nattr =     12;

var
  berr:        boolean;
  flgt:    obj_flagsty;

  typ_atb: [static] array[1..nattr] of record
                                          name:        string(10 );
                                          flgs, fmsk:  obj_flagsty;
                                          acts:            integer
                                       end := [
              [ 'readonly',  [objf_ronly],   [objf_null],           0 ],
              [  'baselex', [objf_lxbase],            [],           0 ],
              [  'lsq_var',   lsqva_flags,  [objf_nolsq], LSQVAR_TYPE ],
              [ 'lsq_parm',   lsqpa_flags,  [objf_nolsq], LSQEXP_TYPE ],
              [ 'lsq_vexp',   lsqex_flags,  [objf_nolsq], LSQPQT_TYPE ],
              ['dat_field',   lsqda_flags,  [objf_nolsq], LSQPDQ_TYPE ],
              ['exp_table',  [objf_lsqtb],            [],           0 ],
              [    'sigma',  [objf_sigma],            [],           0 ],
              [      'lsq',  [objf_lsqob],  [objf_nolsq],           0 ],
              [   'no_lsq',  [objf_nolsq],  [objf_lsqob],           0 ],
              [     'word', [objf_16bits],  [objf_8bits],           0 ],
              [     'byte',  [objf_8bits], [objf_16bits],           0 ]
            ];

begin
  with sy_sym do
  begin
    berr := false;
    actr :=     0;
    INSYMBOL;                                   { Gobble up "[" }
    while sy = identsy do
    begin
      flgt := [];                               { Assume unknown attribute until shown otherwise }
      for ii := 1 to nattr do                   { Loop to search sy_ident in the type attrubute table }
        with typ_atb[ii] do
          if sy_ident = name then               { When the attribute name is found }
            if (actr*acts <> 0) and (actr <> acts) or
               (fmsk*flgt<>[]) then berr:= true { If the attribute are not compatible => ERROR ... }
            else
            begin                               { ... else Keep memory of flags and action number }
              if acts > 0 then actr := acts;
              flgt := flgs; flgr := flgr + flgt
            end;
      if flgt = [] then SRC_ERROR_S( mdnam, 45, e_error, sy_ident );
      INSYMBOL;
    exit if sy <> comma;
      INSYMBOL
    end;
   if berr then SRC_ERROR( mdnam, 44, e_error );
    if sy = rbrack then INSYMBOL
                   else SRC_ERROR( mdnam, 40, e_error )
  end
end TYPE_ATTRIBUTE;


function  CHECK_TYPE_ATTR( ty: typ_ptr; flag: obj_flagsty ): boolean;
{ Check for compatibility between the object type and its attribuites.
  When it is not compatible the function return is TRUE.
}
var
  frm:       val_forms;
  bre:         boolean;

begin
  frm := GET_VAL_FORMS( ty );
  if objf_lsqob in flag then
    case frm of
      vfrm_str, vfrm_est, vfrm_ast: bre := true; { Based string object cannot be compatible with LSQ Attribute }
    otherwise
      bre := false
    end
  else bre := false;
  CHECK_TYPE_ATTR := bre
end CHECK_TYPE_ATTR;



function  TYPE_BUILDER( lvl: integer; bnew: boolean := false ): typ_ptr;
const
  mdnam = 'TYPB';
  nattr =      7;


var
  typ:         typ_ptr;
  idt, idf:    ide_ptr;
  sflg:    obj_flagsty;
  nid, nfl,
  aact:        integer;
  berr:        boolean;


  function  BUILD_ARRAY_DESCR: typ_ptr;
  const
    mdnam = 'BARR';

  var
    typ:    typ_ptr;
    lw, up: integer;
    bw:     boolean;

  begin
    bw := false;
    with sy_sym do
    begin
      INSYMBOL;                                 { Gobble up the separator ("[" or ",") }
      if (sy = mulop) and (op = mul_op) then
      begin { Wild array size and with wild low index bound }
        lw := 1; up := 1; bw := true;
        INSYMBOL
      end
      else
      begin
        lw := GET_INTEXPR( 1 );                 { Get the minimum index value (or total size when one number is given) }
        if sy = twodot then
        begin
          INSYMBOL;
          if (sy = mulop) and (op = mul_op) then
          begin
            up := lw; bw := true;               { Wild array size and with fixed low index bound }
            INSYMBOL
          end else up := GET_INTEXPR( lw )
        end       { Get the maximum value of index }
        else begin  up := lw; lw := 1  end;
        if lw > up then
        begin  lw := 1; up := 1; SRC_ERROR( mdnam, 53, e_error )  end
      end;

      typ := TYP_NEW( tfrm_array,nil,nil,lvl ); { Create the TDR of this array }
      with typ^ do
      begin
        if bw then typ_siz := 1                 { Unit size for wild array }
              else typ_siz := (up - lw) + 1;    { Set the array element number (when size < 0 => undefined array size) }
        typ_min :=          lw;                 { Set the minimum index value }
        if sy = comma then typ_ael := BUILD_ARRAY_DESCR { When an other index is specified build the sub-array descriptor }
        else
        begin
          if sy <> rbrack then SRC_ERROR( mdnam, 26, e_error )
                          else INSYMBOL;        { Gobble up "]" }
          if sy <> ofsy then SRC_ERROR( mdnam, 54, e_error )
                        else INSYMBOL;
          typ_ael := TYPE_BUILDER( lvl );       { Get the array element TDR }
        end;
        if typ_ael <> nil then
        begin
          typ_flg := typ_ael^.typ_flg;
          typ_act := typ_ael^.typ_act;
          if bw then typ_flg := typ_flg + [objf_vbnda];
          { Compute the total size of this array (in basic element number) }
          if typ_ael^.typ_frm = tfrm_array then typ_stp := typ_ael^.typ_siz*typ_ael^.typ_stp
                                           else typ_stp := 1
        end
      end
    end;
    BUILD_ARRAY_DESCR := typ
  end BUILD_ARRAY_DESCR;



begin { TYPE_BUILDER }
  with sy_sym do
  begin
    sflg := [];
    aact :=  0;
    if bnew and (sy = lbrack) then TYPE_ATTRIBUTE( sflg, aact );

    case sy of
      identsy:
        begin
          idt := IDE_SEARCH( true );
          if idt <> nil then
            with idt^ do
              if (ide_class = cla_type) and (ide_typ <> nil) then
              begin
                if bnew then
                begin { Create a child type of the specified type }
                  typ := TYP_NEW( ide_typ^.typ_frm, nil, ide_typ, lvl );
                  with typ^ do
                  begin
                    typ_act := ide_typ^.typ_act;
                    typ_flg := ide_typ^.typ_flg;
                    case typ_frm of
                      tfrm_array: begin
                                    typ_ael := ide_typ^.typ_ael;
                                    typ_stp := ide_typ^.typ_stp;
                                    typ_siz := ide_typ^.typ_siz;
                                    typ_min := ide_typ^.typ_min
                                  end;
                      tfrm_itmty: begin
                                    typ_fel := ide_typ^.typ_fel;
                                    typ_lel := ide_typ^.typ_lel;
                                    typ_fit :=              nil;
                                    typ_lit :=              nil;
                                    typ_ito := ide_typ^.typ_ito;
                                    typ_nid := ide_typ^.typ_nid;
                                    typ_nfl := ide_typ^.typ_nfl;
                                    typ_adv := ide_typ^.typ_adv;
                                    typ_nis := ide_typ^.typ_nis;
                                    typ_pcd := ide_typ^.typ_pcd;
                                    typ_ifl := ide_typ^.typ_ifl
                                  end;
                    otherwise
                    end
                  end
                end
                else typ := ide_typ;
                if typ = nil then typ := int_typ
              end
              else begin  SRC_ERROR( mdnam, 51, e_error ); typ := int_typ  end;
          INSYMBOL                              { Gobble up the type identifier }
        end;

      arraysy:
        begin
          INSYMBOL;                             { Gobble up the "array" keyword }
          if sy = lbrack then typ := BUILD_ARRAY_DESCR
                         else SRC_ERROR( mdnam, 25, e_error )
        end;

(* /// Can be used for future record support.
      itemsy:
        begin
          typ := TYP_NEW( tfrm_item, nil, nil, lvl );
          with typ^ do
          begin
            INSYMBOL;                           { Gobble up the "item" keyword }
            DISPLAY_NEW;                        { Create an Item display level }
            nfl := 0; nid := 0;
            if sy = lparen then                 { When some identification field are specified }
            begin
              INSYMBOL;
              repeat
                idf := IDE_NEW( cla_field, str_typ );
                INSYMBOL;
                if idf <> nil then nfl := nfl + 1;
                if sy = comma then INSYMBOL
                              else if sy <> rparen then SRC_ERROR( mdnam, 34, e_error )
              until sy <> identsy;
              nid := nfl;                       { Keep the identification field number }
              if sy = rparen then INSYMBOL
                             else SRC_ERROR( mdnam, 24, e_error );
              if sy = colon then INSYMBOL
                            else SRC_ERROR( mdnam, 23, e_error )
            end;

            repeat                              { Get all item fields definitions }
              nfl := nfl + VARBL_DECL( cla_field );     { Declare any field of one specified type }
              if sy = semicolon then INSYMBOL
            until sy <> identsy;
            if nfl > byte"last then
            begin
              SRC_ERROR( mdnam, 64, e_error );
              nfl := byte"last;
              if nid > nfl then nid := nfl
            end;

            typ_fel := disp_tab[curr_disp].disp_idt;    { Set the first and last item field pointer }
            typ_lel := disp_tab[curr_disp].disp_lid;
            curr_disp := curr_disp - 1;         { Go out of the Item displaty level }

            typ_nid := nid;                     { Keep the numbers of item fields }
            typ_nfl := nfl;

            if sy <> endsy then
            begin  SRC_ERROR( mdnam, 58, e_severe ); SKIP_SYMBOL( semicolon )  end
            else INSYMBOL;
            if sy = lparen then
            begin
              INSYMBOL;                         { Gobble up the "(" to get the LSQ node codes }
              typ_dcd := GET_INTEXPR( 0 );
              if sy = comma then                { Get the related LSQ node code when defined }
              begin  INSYMBOL; typ_rcd := GET_INTEXPR( 0 )  end;
              if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
            end
          end
        end;
*)

    otherwise
      SRC_ERROR( mdnam, 52, e_severe );
      SKIP_SYMBOL( semicolon );
      typ := int_typ
    end;
    if typ <> nil then
    with typ^ do
    begin
      typ_flg := typ_flg + sflg;
      if (typ_act*aact <> 0) or (sflg*[objf_lsqob,objf_nolsq] = [objf_lsqob,objf_nolsq]) then
        SRC_ERROR( mdnam, 46, e_error )
      else
        if aact <> 0 then typ_act := aact;
      if CHECK_TYPE_ATTR( typ, typ_flg ) then SRC_ERROR( mdnam, 60, e_error )
    end
  end;
  TYPE_BUILDER := typ
end TYPE_BUILDER;



procedure TYPE_DECL;
const
  mdnam = 'TYPD';

var
  idt: ide_ptr;
  typ: typ_ptr;
  lvl: integer;

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the "type" keyword" }
    while (sy = identsy) or (sy = intconst) do  { Loop on all variable to declare }
    begin
      if sy = intconst then
      begin                                     { When a target display level is specified, we use it ... }
        lvl := sy_ival;
        if lvl <= 0 then lvl := curr_disp - lvl;
        if lvl <= 0 then lvl := 1
                    else if lvl > curr_disp then lvl := curr_disp;
        INSYMBOL
      end else lvl := curr_disp;                { ... else we use the current display level to create the identifier }
      if sy <> identsy then
      begin
        SRC_ERROR( mdnam, 56, e_severe );
        SKIP_SYMBOL( semicolon );
        exit
      end;
      idt := IDE_NEW( cla_type, nil, lvl );     { Create the type identifier }
      with idt^ do
      begin
        INSYMBOL;
        if (sy = issy) or ((sy = relop) and (op = eq_op)) then INSYMBOL
                                                          else SRC_ERROR( mdnam, 55, e_error );
        typ := TYPE_BUILDER( lvl, true );       { Attache the type definition, or for equivalence, create a children type }
        ide_typ := typ;
        if typ <> nil then
        begin
          ide_flg := typ^.typ_flg;
          if typ^.typ_ide = nil then typ^.typ_ide := idt
        end
      end;
      if sy = comma then INSYMBOL               { For a type declaration list continue }
    end
  end
end TYPE_DECL;



procedure SET_VALUE( id: ide_ptr; var val: val_rec; shf: integer := 0 );
begin
  if id <> nil then VALUE_COPY( id^.idev_val, val, shf )
end SET_VALUE;



procedure DECLARE_DIRECTIVE;
const
  mdnam = 'DCLD';

var
  ide, idt, imt:       ide_ptr;
  cty, typ:            typ_ptr;
  pow:                ittl_ptr;
  bsy:                  symbol;
  lvl, npa:            integer;
  btb:                 boolean;

begin
  with sy_sym do
  begin
    INSYMBOL;                                   { Gobble up the keyword "lsq_directive" }
    if sy = intconst then
    begin                                       { When a target display level is specified, we use it ... }
      lvl := sy_ival;
      if lvl <= 0 then lvl := curr_disp - lvl;
      if lvl <= 0 then lvl := 1
                  else if lvl > curr_disp then lvl := curr_disp;
      INSYMBOL
    end else lvl := 1;                          { ... else we use the base display level to create the identifier }
    if sy <> identsy then
    begin
      SRC_ERROR( mdnam, 261, e_severe );
      SKIP_SYMBOL( semicolon );
      return
    end;
    ide := IDE_NEW( cla_directive, nil, lvl );
    INSYMBOL;
    if ide <> nil then
    with ide^ do
    begin
      btb := false;
      npa := 0;
      ided_nrep := false;
      if (sy = lparen) or (sy = lbrack) then
      begin
        if sy = lparen then bsy := rparen
                       else bsy := rbrack;
        if bsy = rbrack then
        begin
          ided_optf := true;
          npa := 1;
          ided_ntyp[npa] := int_typ;
          ided_nref[npa] := false
        end;
        sy := comma;
        while (npa < max_arg_dir) and (sy = comma) do
        begin
          if btb then SRC_ERROR( mdnam, 262, e_error );
          INSYMBOL;
          if sy = identsy then idt := IDE_SEARCH( true, [cla_type] )
                          else begin
                                 SRC_ERROR( mdnam, 51, e_severe );
                                 SKIP_SYMBOL( semicolon ); return
                               end;
          INSYMBOL;
          if idt <> nil then
          begin
            cty := idt^.ide_typ;
            if cty <> nil then
              if (cty^.typ_frm = tfrm_array) or (cty^.typ_frm = tfrm_record) then btb := true;
            npa := npa + 1; ided_ntyp[npa] := cty;
            if (sy = lgandop) and (op = and_op) then begin  ided_nref[npa] := true; INSYMBOL  end
          end
        end;
        if (sy = mulop) and (op = mul_op) then begin INSYMBOL; ided_nrep := true  end;
        if sy = bsy then INSYMBOL
                    else if ided_optf then SRC_ERROR( mdnam, 26, e_error )
                                      else SRC_ERROR( mdnam, 23, e_error )
      end;
      if sy = colon then INSYMBOL
                    else SRC_ERROR_S( mdnam, 263, e_error, ide_name^ );
      ided_narg := npa;                         { Set the Directive argument count }
      ided_code := GET_INTEXPR( 0 );            { Get the directive option code }

      if sy = forsy then                        { When this directive must be attached at an item group }
      begin
        sy := comma;
        repeat
          INSYMBOL;                             { Gobble up the separator of the "for" introductor }
          if sy = identsy then
          begin
            imt := IDE_SEARCH(true, [cla_type]);{ Search for item type }
            if imt <> nil then
            begin
              if imt^.ide_typ <> nil then
                if (imt^.ide_typ^.typ_frm = tfrm_itmty) and
                   (itmf_blk in imt^.ide_typ^.typ_ifl) then
                begin
                  NEW( pow );
                  pow^.ittl_next := ided_dito;
                  ided_dito := pow;
                  pow^.ittl_owner := imt^.ide_typ
                end else imt := nil
              else imt := nil
            end;
            if imt = nil then SRC_ERROR_S( mdnam, 279, e_error, sy_ident )
          end
          else SRC_ERROR( mdnam, 278, e_error );
          INSYMBOL
        until sy <> comma
      end
    end
  end
end DECLARE_DIRECTIVE;



procedure GEN_DIRECTIVE( ide: ide_ptr );
const
  mdnam = 'GDIR';

var
  npa, iopt, itmsq:    integer;
  pitt:               ittl_ptr;
  itmo:                itm_ptr;
  rtb: [static] array[1..max_arg_dir] of exp_rec;
  bini: [static] boolean := true;

begin
  if bini then
  begin
    for ii := 1 to max_arg_dir do rtb[ii] := exp_null;
    bini := false
  end;
  with sy_sym, ide^, exp_res do
  begin
    npa := 0;
    if ided_optf then
    begin
      INSYMBOL;
      if sy <> lparen then SRC_ERROR( mdnam, 22, e_error )
                      else INSYMBOL;
      rtb[1] := exp_null;
      with rtb[1], exp_val do
      begin
        exp_ref :=     nil;
        exp_typ := int_typ;
        exp_esz :=       1;
        exp_shf :=       0;
        exp_flg :=      [];
        val_cte :=   false;
        val_frm := vfrm_int;
        int := GET_INTEXPR( -1 )
      end;
      npa := 1;
      if sy <> rparen then SRC_ERROR( mdnam, 24, e_error )
                      else INSYMBOL;
      if (sy <> issy) and (sy <> becomes) and
         ((sy <> relop) or (op <> eq_op)) then SRC_ERROR( mdnam, 59, e_error )
    end;
    sy := comma;
    while (sy = comma) and (npa < ided_narg) do
    begin
      if sy <> comma then SRC_ERROR( mdnam, 29, e_error )
                     else INSYMBOL;             { Gobble up the comma or directive identifier }
      npa := npa + 1;
      GET_TYPE_EXPRESSION( rtb[npa], ided_ntyp[npa], ided_nref[npa] );
      if rtb[npa].exp_val.val_frm = vfrm_null then SRC_ERROR_S( mdnam, 264, e_error, ide_name^ )
    end;

    if ided_dito <> nil then                    { When this item must be attached to an item owner }
    begin
      pitt := ided_dito;
      repeat                                    { Loop on all possible item block types }
        itmo := itm_cblk;
        while itmo <> nil do                    { Loop on all active item blocks }
          if pitt^.ittl_owner = itmo^.itm_typ then exit
                                              else itmo := itmo^.itm_sblk;
      exit if itmo <> nil;                      { Stop when found the active block with an allowed type }
      exit if pitt^.ittl_next = nil;            { Exit when it was the last type check }
        pitt := pitt^.ittl_next
      until false;

      if itmo = nil then SRC_ERROR_S( mdnam, 282, e_error, ide_name^, pitt^.ittl_owner^.typ_ide^.ide_name^ )
                    else itmsq := itmo^.itm_sequ
    end else itmsq := 0;
    OUT_PCD_DIRECTIVE( ided_code, itmsq, npa, rtb, ided_nref[ided_narg] );
    if ided_nrep and (sy = comma) then
      with rtb[ided_narg], exp_val do
        repeat
          INSYMBOL;                               { Gobble up comma or directive identifier }
          GET_DIR_LARG( rtb[ided_narg], ided_ntyp[ided_narg], ided_nref[ided_narg] );
          OUT_PCD_DIRECTIVE( ided_code, itmsq, ided_narg, rtb, ided_nref[ided_narg] );
        until (sy <> comma) or not ided_nrep
  end
end GEN_DIRECTIVE;



procedure DECLARE_NEW_VARBL( idt: ide_ptr; btyp: boolean := false );
{ Create a new identifier when specified with the idt^ type.
  When btyp, the created identifier will be a type identifier.
}
const
  mdnam = 'DCLI';

var
  typ:                         typ_ptr;
  p, p1:                       ide_ptr;
  pdm:                         typ_ptr;
  s:                        str_string;
  ival, lvl, isz, idim:        integer;
  rval:                        mxd_flt;

begin
  typ := idt^.ide_typ;
  if typ <> nil then
  with sy_sym, typ^ do
  begin
    if objf_wild in typ_flg then SRC_ERROR( mdnam, 132, e_error );
    repeat
      INSYMBOL;                                                 { Gobble up the separator or keyword }
      if sy = intconst then
      begin                                                     { When a target display level is specified, we use it ... }
        lvl := sy_ival;
        if lvl <= 0 then lvl := curr_disp - lvl;
        if lvl <= 0 then lvl := 1
                    else if lvl > curr_disp then lvl := curr_disp;
        INSYMBOL
      end
      else
        { Select the default lex-level display }
        if objf_lxbase in typ_flg then lvl := idt^.ide_displ    { As the type lex level following the type attribut ... }
                                  else lvl := curr_disp;        { ... else the current display level }

      if sy = identsy then
      begin
        p := VAR_NEW( typ, lvl );                               { Create the new Variable with its allocation }
        INSYMBOL;
        if sy = becomes then
        begin
          INSYMBOL;                                             { Gobble up ":=" }
          with p^ do
            GET_INIT_VAL( idev_val, typ, ide_typ, lvl, ide_name )
        end
        else
        if (sy = colon) and (p^.ide_flg*lsqex_mask = lsqex_flags) then
        begin
          INSYMBOL;                                             { Gobble up ":" }
          p^.idev_sequnb := ABS( GET_INTEXPR( 0 ) );            { Get the application integer identifier number }
        end;

        if objf_spdef in p^.ide_flg then DEFINE_SPECIFIC( p )   { Define a special object (with creation/assignement specific action) }
      end
      else
      begin
        SRC_ERROR( mdnam, 102, e_severe );                      { ERROR: An identifier was expected }
        INSYMBOL
      end
    until sy <> comma;
  end
end DECLARE_NEW_VARBL;



procedure DECLARE_PARAMETER;
const
  mdnam = 'PARM';

var
  ide: ide_ptr;
  lvl: integer;
  sve: boolean;

begin
  with sy_sym do
  begin
    sve := exp_nva;                             { Save the previous interpretor/compiler mode }
    INSYMBOL;                                   { Gobble up the keyword }
    repeat
      if sy = intconst then
      begin
        lvl := sy_ival;                         { When a target display level is specified, we get it }
        if lvl <= 0 then lvl := curr_disp - lvl;
        if lvl < 1 then lvl := 1
                   else if lvl > curr_disp then lvl := curr_disp;
        INSYMBOL
      end else lvl := curr_disp;
      ide := IDE_NEW( cla_varbl, nil, lvl );    { Create the identifier }
      INSYMBOL;                                 { Gobble up the identifier }
      if ide <> nil then
      with ide^, idev_val, exp_res do
      begin
        if (sy = issy) or ((sy = relop) and (op = eq_op)) then INSYMBOL
                                                          else SRC_ERROR( mdnam, 55, e_error );
        exp_nva := true;                        { Force the DCP Compiler Mode }
        GET_EXPRESSION( exp_res );              { Get the definition expression : result in exp_res }
        ide_typ := exp_typ;                     { Set the expression type reference and there related flags to the identifier }
        ide_flg := exp_flg;
        if exp_ref = nil then                   { When the parameter is not a reference ... }
        begin
          idev_val := exp_res.exp_val;          { ... we can take a copy of value record ... }
          exp_val.val_frm := vfrm_null          { ... set the original record to be empty to preserve the memory allocation }
        end
        else
        begin                                   { When the parameter is a variable reference }
          VAL_ALLOCATE( idev_val, ide_typ );    { Allocate memory for this object with all values at 0 }
          if not (objf_lsqex in ide_flg) then   { When the expression is completly evaluated ... }
            SET_VALUE( ide, exp_val, exp_shf )  { ... we set a copy of value }
        end;
        if objf_lsqex in ide_flg then
        begin
          ide_flg := lsqpa_flags - [objf_lsqva];{ Set the parameters flags }
          idev_spcact := LSQEXP_TYPE;           { Set the action number of LSQ expressions }
          DEFINE_SPECIFIC( ide )                { Define a special object }
        end;
        exp_nva := sve                          { Reset the previous DCP (interpretor/compiler) Mode }
      end;
      if sy = comma then INSYMBOL               { Skip the comma separator }
    until (sy <> identsy) and (sy <> intconst)
  end
end DECLARE_PARAMETER;



[global]
function  VARBL_DECL( cla: cla_kinds := cla_varbl; fitm, sco: boolean := false; itt: typ_ptr := nil ): integer;
const
  mdnam = 'VARD';

var
  p0, p1, p2:          ide_ptr;
  typ, typ2:           typ_ptr;
  lvl, ndf:            integer;
  val:                 val_rec;
  bval, bref:          boolean;

begin
  with sy_sym do
  begin
    p0    :=   nil;
    bval  := false;
    bref  := false;
    if (cla <> cla_field) and (cla <> cla_itmfld) then INSYMBOL
    else
      if (sy = varsy) and (cla = cla_formal) then bref := true;
    if (sy = intconst) and (cla = cla_varbl) then
    begin
      lvl := sy_ival;                           { When a target display level is specified, we get it }
      if lvl <= 0 then lvl := curr_disp - lvl;
      if lvl <= 0 then lvl := 1
                  else if lvl > curr_disp then lvl := curr_disp;
      INSYMBOL
    end else lvl := curr_disp;
    p0 := disp_tab[lvl].disp_lid;               { Get the previously declared identifier pointer }
    ndf := 0;
    repeat                                      { Loop on all identifier (with the same type) declaration }
      if sy <> identsy then
      begin  SRC_ERROR( mdnam, 57, e_severe ); SKIP_SYMBOL( semicolon ); goto ET_RET  end;
      p1 := IDE_NEW( cla, nil, lvl );           { Create the Variable/Field/Formal identifier }
      INSYMBOL;                                 { Gobble up the identifier }
      if fitm and (cla = cla_itmfld) then       { For the item field : }
      while ((sy = mulop) and (op = mul_op)) or (sy = questsign) do
      begin
        if sy = mulop then                      { Set the optional flag when required }
        begin  INSYMBOL; p1^.idee_option := true  end
        else
        begin  INSYMBOL; p1^.idee_isent := true  end
      end;
      if p1 <> nil then ndf := ndf + 1;         { Build the count of declared identifier }
      if sy = comma then INSYMBOL
      else
        if sy <> colon then begin  SRC_ERROR( mdnam, 31, e_severe ); SKIP_SYMBOL( semicolon ); goto ET_RET  end;
    until sy = colon;
    { Here p1 is the pointer of the last created identifier,
      and p0 the pointer of the last previously declared identifier }
    if (sy = colon) and (p1 <> nil) then
    begin
      INSYMBOL;                                 { Gobble up ":" }
      if (cla = cla_formal) or (cla = cla_field) or (cla = cla_itmfld) then
      begin
        p2 := IDE_SEARCH( true, [cla_type] );
        INSYMBOL;
        if p2 <> nil then typ := p2^.ide_typ
                     else typ := int_typ        { Default to integer type when error }
      end
      else typ := TYPE_BUILDER( lvl );          { Get the type specification }

      if sco and (typ <> nil) then
        if typ^.typ_frm = tfrm_array then begin  SRC_ERROR( mdnam, 260, e_error ); typ := int_typ  end;
      if (sy = becomes) and  (cla = cla_varbl) then
      begin
        VAL_ALLOCATE( val, typ );
        INSYMBOL;                               { Gobble up ":=" }
        GET_INIT_VAL( val, typ, typ, lvl, p1^.ide_name );
        bval := true
      end;
      p2 := p1;
      if typ <> nil then
      with typ^ do
      repeat                                    { Loop on all new identifiers }
        with p2^ do
        begin
          ide_typ :=     typ;                   { Assign the type to each new identifier ... }
          ide_flg := typ_flg;
          if cla = cla_varbl then
          begin                                 { ... and for  the variable identifiers ... }
            idev_spcact := typ_act;             { ... attach all type specific index and ... }
            VAR_ALLOCATE( p2 );                 { ... allocate the required memory }
            if bval then SET_VALUE( p2, val );  { Copy initial value when required }
            if objf_spdef in ide_flg then DEFINE_SPECIFIC( p2 ) { Do the specific define action when required }
          end;
          if cla = cla_formal then
          begin
            idef_ref := bref;                   { Set the reference formal flag when required }
            idef_def := false                   { Set the default argument flag when required (not implemented now) }
          end;
          p2 := ide_lnk
        end
      until p2 = p0                             { Stop type assign loop when we have find the last previosly decl. identifier }
    end;
    if bval then FREE_VAL_ALLOCATION( val )
  end;
ET_RET:
  VARBL_DECL := ndf
end VARBL_DECL;



procedure CREATE_ENTRY( ide: ide_ptr; ope: dcp_oper; var frs, lst: ent_ptr );
const
  mdnam = 'CENT';

var
  ent:                 ent_ptr; { Entry pointer }
  snm:                 str_ptr; { Identification string }
  ft, fl, p0, p1:      ide_ptr; { Identifier pointers for formal tree, last formal, returned type and for management }
  rty:                 typ_ptr; { Returned type }
  body:                idm_apt; { Text pointer of macro function }
  npa:                 integer; { Number of formal parameters }
  berr,  bref:         boolean; { Flags for any error and for reference argument }

  opnm: [static] array[not_op..ass_op] of string( 6 )
        := [  'O not',   'O **',    'O *',    'O /',
             'O idiv',  'O mod',  'O rem',    'O +',
                'O -',   'O ||',    'O <',   'O <=',
               'O >=',    'O >',   'O <>',    'O =',
              'O and',  'O xor',   'O or',   'O :=' ];

begin
  INSYMBOL;
  if ide <> nil then snm := ide^.ide_name
                else snm := opnm[ope]"address;
  berr  :=       false;
  ft := nil; fl := nil;
  with sy_sym do
  begin
    DISPLAY_NEW;                                { Create a new display level for the formal list }
    if sy = lparen then
    begin
      repeat
        npa := VARBL_DECL( cla_formal );        { Create each formal parameter sub-list (unused return value) }
      until sy <> semicolon;
      if sy = rparen then INSYMBOL
                     else begin  SRC_ERROR( mdnam, 23, e_error ); berr := true  end
    end;
    if sy = colon then
    begin
      INSYMBOL;                                 { Gobble up then colon separtor to get the function return type }
      if sy <> identsy then begin  SRC_ERROR( mdnam, 140, e_error ); p0 := nil  end
                       else p0 := IDE_SEARCH( true, [cla_type] ){ Get the returned function type }
    end else p0 := nil;                         { For procedure no returned type }
(*
    ft := disp_tab[curr_disp].disp_idt;         { Get the root of formal identifiers tree }
    fl := disp_tab[curr_disp].disp_lid;         { Get the Last formal arg. ident. address (last arg. of function result for function) }
*)
    if p0 <> nil then
    begin
      rty := p0^.ide_typ;
(*
      if ft <> nil then                         { When a list of formal exist, we must put the return value in first position }
      begin  ft^.ide_lnk := p0; p0^.ide_lnk := nil  end;{ Set the return value as the previous one of the first argument }
*)
      INSYMBOL                                  { Pass to the normal semicolon }
    end else rty := nil;


    ft := disp_tab[curr_disp].disp_idt;         { Get the root of formal identifiers tree }
    fl := disp_tab[curr_disp].disp_lid;         { Get the Last formal arg. ident. address (last arg. of function result for function) }


    if sy <> semicolon then begin  SRC_ERROR( mdnam, 21, e_error ); berr := true  end
                       else INSYMBOL;

    curr_disp := curr_disp - 1;                 { Return to the current code display level }

    if sy <> beginsy then begin  SRC_ERROR( mdnam, 43, e_severe ); berr := true  end;

    if not berr then
    begin

      body := GEN_MACRO_LIST( endsy );          { Get the body of macro function }
      if rty <> nil then npa := 1               { Init the argument count }
                    else npa := 0;
      INSYMBOL;

      p0 := nil;
      while fl <> nil do                        { Loop to reverse the formal list order and set the argument stack shifts }
      begin
        p1 := fl;                               { Keep the address of current formal identifier }
        with p1^ do                             { Warning: the with pointer is a copy of idp (not idp), then ... }
        begin
          fl        := ide_lnk;                 { ... we can keep the next of the original LIFO }
          idef_efn  :=     npa;                 { Set the formal distance in the stack }
          ide_lnk   :=      p0;                 { Save the previous formal address in the formal link }
          p0        :=      p1;                 { Set the current formal address as the new first formal }
          npa := npa + 1                        { Update the formal argument count }
        end
      end;
      fl := p1;                                 { Keep the address of the first arg (that is the retv for the function) }
      if npa > 32 then SRC_ERROR_S( mdnam,129, e_error, snm^ ); { if too many formal (max = 32) => error }

(*
WRITE( ' MFUNCTION ' );
if ide <> nil then WRITE( '"', ide^.ide_name^, '"' )
              else WRITE( ' oper = ', ope );
WRITELN( ' with ', npa:0, ' argument(s)' );
p1 := fl;
while p1 <> nil do
begin
  with p1^ do
  WRITELN( ' Formal Argument "', ide_name^, '" of type "', ide_typ^.typ_ide^.ide_name^, '" as arg # ', npa-idef_efn:0 );
  p1 := p1^.ide_lnk
end;
*)

      NEW( ent, entk_fnc );                     { Create the mfunction entry }
      with ent^ do
      begin
        if rty <> nil then npa := npa - 1;
        ent_lnk := disp_tab[curr_disp].disp_ent;{ Set the link with the other entry of the same display level }
        ent_prv :=         lst;                 { Link with the previous entry for the same operator/generic }
        ent_typ :=         rty;                 { Set the entry result type }
        ent_knd :=    entk_fnc;                 { Set the user macro function kind of entry }
        ent_npa :=         npa;                 { Set the number of arguments }
        ent_frl :=          fl;                 { Set the formal list head }
        ent_cod :=        body;                 { Set the text of mfunction body }
        ent_dsp :=   curr_disp;                 { Set the entry diplay level }
        ent_ope :=         ope;                 { Set the related operator value }
        if ope = no_op then ent_ide := ide      { Set the generic identifier link ... }
                       else ent_str := snm      { ... or the conventional string name (for operator) }
      end;
      if frs = nil then frs := ent;             { Update the entry list }
      lst := ent
    end
    else { On error }
      SKIP_SYMBOL( endsy )
  end
end CREATE_ENTRY;



procedure DECLARE_NEW_FUNCTION;
const
  mdnam = 'DCLF';

var
  typ: typ_ptr;
  idf, ido:     ide_ptr;

begin
  INSYMBOL;                                     { Gobble up the FUNCTION Keyword }
  with sy_sym do
    case sy of
      identsy:                                  { An identifier was expected }
        begin
          ido := nil;
          idf := IDE_SEARCH( false );           { Search for this identifier }
          if idf <> nil then                    { When it is found }
          with idf^ do                          { The identifier was not a type => create a Procedure }
            if ide_class <> cla_generic then    { When it is not a generic ... }
              if ide_displ = curr_disp then     { When it ist defined in the current display level we generate an error. }
              begin
                SRC_ERROR_S( mdnam, 842, e_severe, idf^.ide_name^ );    { ... else it is an error }
                SKIP_SYMBOL( semicolon );
                return
              end
              else idf := nil
            else                                { The identifier is a generic }
              if ide_displ < curr_disp then begin ido := idf; idf := nil  end;  { But it is not defined in our display level }

          { When the generic does not exist in the current display level, we create it }
          if idf = nil then idf := IDE_NEW( cla_generic, nil );
          if idf <> nil then
          with idf^ do
          begin
            if ido <> nil then ideg_last := ido^.ideg_last;     { Attach the external entry to the current display level when they exist }
            CREATE_ENTRY( idf, no_op, ideg_first, ideg_last )   { Create the new function entry }
          end
          else SKIP_SYMBOL( semicolon )
      end;

    unaop,
    powop,    mulop,   addop,
    relop,  lgandop,  lgorop:
      with mop_tab[op] do
        CREATE_ENTRY( nil, op, mop_first, mop_last );

  otherwise
    SRC_ERROR( mdnam, 843, e_severe );
    SKIP_SYMBOL( semicolon )
  end
end DECLARE_NEW_FUNCTION;



procedure OPENFILE_STATE;
{ To open a text read/write file }
const
  mdnam = 'OPEN';

var
  lun:         integer;
  fspc:     str_string;
  fmd:      flags_file;
  fcd:    iocnt_opmode;
  bok:         boolean;

begin
  bok := true;
  fmd := [error_file,case_ena_file];
  with sy_sym do
  begin
    if sy = colon then begin  INSYMBOL; lun := GET_INTEXPR( 1 )  end
                  else lun := 1;
    if (lun < 0) or (lun > max_usrlun) then
    begin
      SRC_ERROR( mdnam, 77, e_severe );
      SKIP_SYMBOL( semicolon );
      bok := false
    end;
    GET_STREXPR( fspc );
    if fspc.length >= 1 then
    case fspc[1] of
      'R', 'r', 'I', 'i':
         begin { Read mode   } fmd :=   [read_file,error_file,case_ena_file]; fcd :=  iocnt_input  end;
      'W', 'w', 'O', 'o':
         begin { Write mode  } fmd :=  [write_file,error_file,case_ena_file]; fcd := iocnt_output  end;
      'A', 'a':
         begin { Append mode } fmd := [append_file,error_file,case_ena_file]; fcd := iocnt_output  end;
    otherwise
      SRC_ERROR_S( mdnam, 777, e_severe, fspc );
      SKIP_SYMBOL( semicolon );
      bok := false
    end
    else
    begin  fmd := [read_file,error_file,case_ena_file]; fcd := iocnt_input  end;

    if bok then
    with sym_iof[lun] do
    begin
      if sy = comma then INSYMBOL
                    else SRC_ERROR( mdnam, 31, e_error );
      GET_STREXPR( fspc );
      if iocnt_mode <> iocnt_close then CLOSE( iocnt_file );
      OPEN( iocnt_file, fspc, fmd );
      if iostatus = 0 then iocnt_mode := fcd
                      else iocnt_mode := iocnt_close;
      io_err^.idev_val.int := ORD( iostatus <> 0 )      { Error on open }
    end
    else io_err^.idev_val.int := -1                     { Illegal OPEN parameter values }
  end
end OPENFILE_STATE;



procedure CLOSEFILE_STATE;
{ to close a text read/write file }
var
  lun: integer;

begin
  with sy_sym do
  begin
    INSYMBOL;
    if sy = colon then begin  INSYMBOL; lun := GET_INTEXPR( 1 )  end
                  else lun := 1;
    if (lun >= 0) and (lun <= max_usrlun) then
      with sym_iof[lun] do
      begin
        if iocnt_mode <> iocnt_close then CLOSE( sym_iof[lun].iocnt_file );
        iocnt_mode := iocnt_close
      end
      else SRC_ERROR( 'CLOS', 77, e_severe )
  end
end CLOSEFILE_STATE;



procedure GET_IO_FORMAT( nb: integer; var i1, i2, i3: integer );
begin
  with sy_sym do
  if sy = colon then
  begin
    INSYMBOL;
    i1 := GET_INTEXPR( i1 );
    if (nb > 1) and (sy = colon) then
    begin
      INSYMBOL;
      i2 := GET_INTEXPR( i2 );
      if (nb > 2) and (sy = colon) then
      begin
        INSYMBOL;
        i3 := GET_INTEXPR( i3 )
      end
    end
  end
end GET_IO_FORMAT;



procedure READ_VALUES( sym: symbol );
{ To get a variable from terminal or input file : string or number(s) }
const
  mdnam = 'RPLY';

var 
  st:                str_string;
  lun, nel, fs, dc, ls: integer;
  rec:                  exp_rec;
  fv:                   mxd_flt;
  iv:                   integer;
  sv:                   str_ptr;

  function FREAD_INT( var f: text; fl: integer ): integer;
  var
    iv: integer;

  begin
    iv := 0;
    if EOLN( f ) and not EOF( f ) then READLN( f );
    if not EOF( f ) then READ( f, iv:fl );
    if EOF( f ) then
    begin
      io_eof^.idev_val.int  := 1;
      io_eoln^.idev_val.int := 1
    end
    else
    begin
      io_eof^.idev_val.int := 0;
      io_eoln^.idev_val.int := ORD( EOLN( f ) );
      TTY_CLR_EOF( f )
    end;
    FREAD_INT := iv
  end FREAD_INT;


  function FREAD_FLT( var f: text; fl: integer ): mxd_flt;
  var
    fv: mxd_flt;

  begin
    fv := 0.0;
    if EOLN( f ) and not EOF( f ) then READLN( f );
    if not EOF( f ) then READ( f, fv:fl );
    if EOF( f ) then
    begin
      io_eof^.idev_val.int  := 1;
      io_eoln^.idev_val.int := 1
    end
    else
    begin
      io_eof^.idev_val.int := 0;
      io_eoln^.idev_val.int := ORD( EOLN( f ) );
      TTY_CLR_EOF( f )
    end;
    FREAD_FLT := fv
  end FREAD_FLT;


  procedure FREAD_STR( var f: text; var sv: str_ptr; fl, dc: integer );
  const
    TAB = CHR( 9 );

  var
    st: str_string;
    il: integer;
    beof, beoln: boolean;
    ch: char;

  begin
    st.length := 0;
    if not UFB( f ) then
      if EOLN( f ) and not EOF( f ) then READLN( f );
    if not (EOLN( f ) or EOF( f )) then
    begin
      if sv <> nil then DISPOSE( sv );
      READ( f, st:fl:(dc > 0) );
      { size the string by supress any trailing space(s) }
      for ii := st.length downto 1 do
        if st[ii] > ' ' then
        begin  st.length := ii; exit  end;
      if st.length > 0 then
      { Now suppress any control character except space and TAB }
      il := 0;
      for ii := 1 to st.length do
        if (st[ii] >= ' ') or (st[ii] = TAB) then
        begin  il := il + 1; st[il] := st[ii]  end;
      st.length := il;
      { Create the final string }
      if st.length > 0 then
      begin
        NEW( sv, il );
        sv^ := st
      end else sv := nil;
    end;
    if EOF( f ) then
    begin
      io_eof^.idev_val.int  := 1;
      io_eoln^.idev_val.int := 1;
      if TTY_FILE( f ) then TTY_CLR_EOF( f )
    end
    else
    begin
      io_eof^.idev_val.int := 0;
      io_eoln^.idev_val.int := ORD( EOLN( f ) );
    end
 end FREAD_STR;


begin { READ_VALUES }
  lun := 1;
  INSYMBOL;
  if sym = readsy then
  begin
    lun := GET_INTEXPR( lun );
    if (lun < 0) or (lun > max_usrlun) then
    begin
      SRC_ERROR( mdnam, 77, e_severe );
      lun := 1
    end
    else
      if sym_iof[lun].iocnt_mode <> iocnt_input then
      begin
        SRC_ERROR( mdnam, 401, e_severe );
        lun := 1
      end;
    if sy_sym.sy <> colon then SRC_ERROR( mdnam, 31, e_error )
                          else INSYMBOL
  end;
  if lun >= 0 then
  with sy_sym, sym_iof[lun] do
  begin
    if op <> stp_op then
    loop
      GET_EXP_REFER( rec );       { Get the reference of object to read }
      fs := 0; dc := 0; ls := 0;
      GET_IO_FORMAT( 2, fs, dc, ls );
      with rec do
      begin
        nel := exp_shf+1;
        ls  := exp_esz + exp_shf;
        if exp_ref <> nil then
        with exp_ref^, exp_val do
        case val_frm of
          vfrm_str: if (objf_ronly in ide_flg) or (exp_ref = udc_ident) then
                    begin
                      sv := nil;
                      if sym = readsy then FREAD_STR( iocnt_file, sv, fs, dc )
                                      else FREAD_STR( input, sv, fs, dc );
                      if sv <> nil then DISPOSE( sv );
                      if exp_ref <> udc_ident then SRC_ERROR_S( mdnam, 131, e_error, ide_name^ )
                    end
                    else
                      if sym = readsy then FREAD_STR( iocnt_file, str, fs, dc )
                                      else FREAD_STR( input, str, fs, dc );

          vfrm_int: begin
                      if sym = readsy then iv := FREAD_INT( iocnt_file, fs )
                                      else iv := FREAD_INT( input, fs );
                      if objf_ronly in ide_flg then SRC_ERROR_S( mdnam, 131, e_error, ide_name^ )
                                                  else int := iv
                    end;

          vfrm_flt: begin
                      if sym = readsy then fv := FREAD_FLT( iocnt_file, fs )
                                      else fv := FREAD_FLT( input, fs );
                      if objf_ronly in ide_flg then SRC_ERROR_S( mdnam, 131, e_error, ide_name^ )
                                                  else flt := fv
            end;

          vfrm_est: if aas <> nil then
                    with aas^ do
                      if sym = readsy then FREAD_STR( iocnt_file, val_stb[nel], fs, dc )
                                      else FREAD_STR( input, val_stb[nel], fs, dc );

          vfrm_ein: if aai <> nil then
                    with aai^ do
                      if sym = readsy then val_itb[nel] := FREAD_INT( iocnt_file, fs )
                                      else val_itb[nel] := FREAD_INT( input, fs );

          vfrm_efl: if aaf <> nil then
                    with aaf^ do
                      if sym = readsy then val_ftb[nel] := FREAD_FLT( iocnt_file, fs )
                                      else val_ftb[nel] := FREAD_FLT( input, fs );

          vfrm_ast:
            if aas <> nil then
            with aas^ do
            begin
              while (nel < ls) and (io_eof^.idev_val.int = 0) do
              begin
                if sym = readsy then FREAD_STR( iocnt_file, val_stb[nel], fs, dc )
                                else FREAD_STR( input, val_stb[nel], fs, dc );
                nel := nel + 1
              end;
              if io_eof^.idev_val.int > 0 then nel := nel - 1;
              io_count^.idev_val.int := nel - 1
            end;

          vfrm_ain: if aai <> nil then
                    with aai^ do
                    begin
                      while (nel < ls) and (io_eof^.idev_val.int = 0) do
                      begin
                        if sym = readsy then val_itb[nel] := FREAD_INT( iocnt_file, fs )
                                        else val_itb[nel] := FREAD_INT( input, fs );
                        nel := nel + 1
                      end;
                      if io_eof^.idev_val.int > 0 then nel := nel - 1;
                      io_count^.idev_val.int := nel - 1
                    end;

          vfrm_afl: if aaf <> nil then
                    with aaf^ do
                    begin
                      while (nel < ls) and (io_eof^.idev_val.int = 0) do
                      begin
                        if sym = readsy then val_ftb[nel] := FREAD_FLT( iocnt_file, fs )
                                        else val_ftb[nel] := FREAD_FLT( input, fs );
                        nel := nel + 1
                      end;
                      if io_eof^.idev_val.int > 0 then nel := nel - 1;
                      io_count^.idev_val.int := nel - 1
                    end;
        otherwise
          SRC_ERROR_S( mdnam, 403, e_severe,  )
        end;
        if objf_spass in exp_ref^.ide_flg then ASSIGN_SPECIFIC( rec )   { Execute specific action when required }
      end;
    exit if sy <> comma;
      INSYMBOL
    end;
    if sym = readsy then begin  if not EOF( iocnt_file ) then READLN( iocnt_file )  end
                    else begin  if not EOF then READLN  end
  end
end READ_VALUES;



procedure WRITE_VALUES( sym: symbol );
const
  mdnam = 'DSPL';

var
  lun, iv, fs, dc, nel:        integer;
  rv:                          mxd_flt;
  st:                       str_string;
  bndl:                        boolean;

begin  { WRITE_VALUES }
  lun := 0;
  INSYMBOL;
  if (sym <> writemsgsy) and (sym <> displaysy) then
  begin
    lun := GET_INTEXPR( 1 );                    { Get the I/O Lun value }
    if (lun < 0) or (lun > max_usrlun) then
    begin
      SRC_ERROR( mdnam, 77, e_severe );
      lun := -1
    end
    else
      if sym_iof[lun].iocnt_mode <> iocnt_output then
      begin
        SRC_ERROR( mdnam, 401, e_severe );
        lun := -1
      end;
    if sy_sym.sy <> colon then SRC_ERROR( mdnam, 31, e_error )
                          else INSYMBOL
  end;
  if lun >= 0 then
  with sy_sym do
  begin
    if op <> stp_op then
    loop
      bndl := true;
      GET_EXPRESSION( exp_rs1 );                { Put the expression to print in exp_rs1 }
      with exp_rs1, exp_val do
      begin
        nel := exp_shf + 1;
        case val_frm of                         { If function of the expression type }
          vfrm_str: begin
                      fs := 0; dc := 0;
                      GET_IO_FORMAT( 2, fs, dc, iv );
                      if str <> nil then WRITEV( st, str^:fs:dc )
                                    else if fs > 0 then WRITEV( st, ' ':fs ) else st := ''
                    end;

          vfrm_int: begin
                         iv := int; fs := 10; dc := 0;
                         GET_IO_FORMAT( 2, fs, dc, iv );
                         WRITEV( st, iv:fs:dc )
                       end;

          vfrm_flt: begin
                      rv := flt; fs := 12; dc := 6;
                      GET_IO_FORMAT( 2, fs, dc, iv );
                      WRITEV( st, rv:fs:dc )
                    end;

          vfrm_est: if aas <> nil then
                       with aas^ do
                       begin
                         fs := 0; dc := 0;
                         GET_IO_FORMAT( 2, fs, dc, iv );
                         if val_stb[nel] = nil then
                           if fs > 0 then WRITEV( st, ' ':fs )
                                     else st.length := 0
                         else  WRITEV( st, val_stb[nel]:fs:dc )
                       end;

          vfrm_ein: if aai <> nil then
                       with aai^ do
                       begin
                         fs := 10; dc := 0;
                         GET_IO_FORMAT( 2, fs, dc, iv );
                         if fs = 0 then fs := 10;
                         WRITEV( st, val_itb[nel]:fs:dc )
                       end;

          vfrm_efl: if aaf <> nil then
                    with aaf^ do
                    begin
                      fs :=12; dc := 6;
                      GET_IO_FORMAT( 2, fs, dc, iv );
                      WRITEV( st, val_ftb[nel]:fs:dc )
                    end;

          vfrm_ast: if aas <> nil then
                    with aas^ do
                    begin
                      bndl := false;
                      iv := 1; fs := 0; dc := 0;
                      GET_IO_FORMAT( 3, iv, fs, dc );
                      if iv <= 0 then iv := 1;
                      st.length := 0;
                      with sym_iof[lun] do
                      for ii := 1 to exp_esz do
                      begin
                        if val_stb[nel] = nil then
                        begin
                          if fs > 0 then WRITEV( st:false, ' ':fs )
                        end
                        else  WRITEV( st:false, val_stb[nel]:fs:dc );
                        nel := nel + 1;
                        if (ii mod iv = 0) or (ii = exp_esz) then
                        begin
                          case sym of
                            displaysy:  WRITELN( st );
                            writemsgsy: begin
                                          LST_PUT_STRING( st );
                                          LST_EOLN
                                        end;
                            writelnsy, writesy: WRITELN( iocnt_file, st );
                          otherwise
                          end;
                          st.length := 0
                        end
                      end
                    end;

          vfrm_ain: if aai <> nil then
                    with aai^ do
                    begin
                      bndl := false;
                      iv := 4; fs := 10; dc := 0;
                      GET_IO_FORMAT( 3, iv, fs, dc );
                      if iv <= 0 then iv := 4;
                      st.length := 0;
                      with sym_iof[lun] do
                      for ii := 1 to exp_esz do
                      begin
                        WRITEV( st:false, val_itb[nel]:fs:dc );
                        nel := nel + 1;
                        if (ii mod iv = 0) or (ii = exp_esz) then
                        begin
                          case sym of
                            displaysy:  WRITELN( st );
                            writemsgsy: begin
                                          LST_PUT_STRING( st );
                                          LST_EOLN
                                        end;
                            writelnsy, writesy: WRITELN( iocnt_file, st );
                          otherwise
                          end;
                          st.length := 0
                        end
                      end
                    end;

          vfrm_afl: if aaf <> nil then
                    with aaf^ do
                    begin
                      bndl := false;
                      iv := 4; fs := 12; dc := 6;
                      GET_IO_FORMAT( 3, iv, fs, dc );
                      if iv <= 0 then iv := 4;
                      st.length := 0;
                      with sym_iof[lun] do
                      for ii := 1 to exp_esz do
                      begin
                        WRITEV( st:false, val_ftb[nel]:fs:dc );
                        nel := nel + 1;
                        if (ii mod iv = 0) or (ii = exp_esz) then
                        begin
                          case sym of
                            displaysy:  WRITELN( st );
                            writemsgsy: begin
                                          LST_PUT_STRING( st );
                                          LST_EOLN
                                        end;
                            writelnsy, writesy: WRITELN( iocnt_file, st );
                          otherwise
                          end;
                          st.length := 0
                        end
                      end
                    end;

        otherwise
          SRC_ERROR( mdnam, 402, e_severe )
        end
      end;

      case sym of
        displaysy:   WRITE( st );
        writemsgsy:  LST_PUT_STRING( st );
        writelnsy,
        writesy:     WRITE( sym_iof[lun].iocnt_file, st );
      otherwise
      end;
    exit if sy <> comma;
      INSYMBOL
    end;

    if bndl then
    case sym of
      displaysy: if sy = replysy then READ_VALUES( replysy )
                                 else WRITELN;
      writemsgsy: LST_EOLN;
      writelnsy:  WRITELN( sym_iof[lun].iocnt_file );
    otherwise
    end
  end
end WRITE_VALUES;



procedure CASE_STATE;
const
  mdnam = 'CASE';

var
  iv, jv, kv: integer;
  bg, be: boolean;

begin
  with sy_sym, src_control^ do
  begin
    bg := false;
    be := false;
    INSYMBOL;                    { Gobble up the case keyword }
    src_insnb := src_insnb + 1;
    iv := GET_INTEXPR( 0 );      { Get the selector value }
    if sy <> whensy then SRC_ERROR( mdnam, 121, e_error )
                    else INSYMBOL;
    loop
      if sy <> othersy  then
      begin
        loop
          jv := GET_INTEXPR( iv );
          if sy = twodot then
          begin
            INSYMBOL;
            kv := GET_INTEXPR( jv )
          end else kv := jv;
          if (iv >= jv) and (iv <= kv) then bg := true;
        exit if sy <> comma;
          INSYMBOL
        end;
        if sy <> colon then SRC_ERROR( mdnam, 31, e_error );
        if bg then
        begin
          STATELIST( whensy );
          if sy <> endsy then SKIP_SYMBOL( endsy );
          be := true
        end
        else
        begin
          src_insnb := src_insnb + 1;
          SKIP_SYMBOL( whensy );
          src_insnb := src_insnb - 1
        end
      end
      else
      begin { Other case }
        STATELIST( othersy );
        be := true
      end;
    exit if (sy <> whensy) or be;
      INSYMBOL
    end;
    if sy <> endsy then
      if be then
        SRC_ERROR( mdnam, 108, e_error )
      else
      begin
        src_insnb := src_insnb + 1;
        SKIP_SYMBOL( endsy );
        src_insnb := src_insnb - 1
      end
    else INSYMBOL;
    src_insnb := src_insnb - 1
  end
end CASE_STATE;



procedure IF_STATE;
const
  mdnam = 'IFST';

var
  iv: integer;

begin
  with sy_sym, src_control^ do
  begin
    INSYMBOL;                                   { Gobble up the if keyword }
    iv := GET_INTEXPR( 1 );                     { Get the condition value }
    if sy <> thensy then SRC_ERROR( mdnam, 107, e_error );
    if iv > 0 then STATELIST( elsesy )
              else
              begin
                src_insnb := src_insnb + 1;
                SKIP_SYMBOL( elsesy );
                src_insnb := src_insnb - 1
              end;
    if sy = elsesy then
    begin
      if iv > 0 then
                begin
                  src_insnb := src_insnb + 1;
                  SKIP_SYMBOL( endsy );
                  src_insnb := src_insnb - 1
                end
                else STATELIST( endsy )
    end;
    if sy = endsy then INSYMBOL
                  else SRC_ERROR( mdnam, 108, e_error )
  end
end IF_STATE;



procedure BLOCK_STATE;
begin
  DISPLAY_NEW;                                  { Create a new identifier display level }
  STATELIST( endsy );                           { Perform the block statements }
  DISPLAY_FREE;                                 { Destroy the display }
  if sy_sym.sy = endsy then
    INSYMBOL                                    { Gobble up the end keyword }
  else
    SRC_ERROR( 'BLOC', 108, e_severe )
end BLOCK_STATE;



procedure ERROR_STATE;
const
  mdnam = 'UERR';

var
  irt: integer;
  str:  string( 62 );

begin
  INSYMBOL;
  str.length := 0;
  if sy_sym.sy = lparen then
  begin
    INSYMBOL; irt := GET_INTEXPR( 4 );
    if sy_sym.sy = comma then
    begin  INSYMBOL; GET_STREXPR( str )  end
  end
  else irt := 4;
  if str.length > 0 then SRC_ERROR_S( mdnam, 999, e_fatal, str )
                    else SRC_ERROR( mdnam, 999, e_fatal );
  PASCAL_EXIT( irt )
end ERROR_STATE;



procedure STATEMENT;
{ Procedure to execute one SHELL statement }
const
  mdnam = 'STAT';

var
 stat_sy:       symbol;
 ide:          ide_ptr;
 int:          integer;


begin
  with sy_sym do
  begin
    stat_sy := sy;
    case stat_sy of
      endsy, elsesy, untilsy: ;

      chainesy, includesy:
        INCLUDE_STATE( stat_sy = includesy );

      peofsy:        ENDFILE_STATE;

      pragmasy:      PRAGMA_STATE( src_control );

      typesy:        TYPE_DECL;
      varsy:         int := VARBL_DECL;         { Unused return value }
      mfunctionsy:   DECLARE_NEW_FUNCTION;
      returnvsy:     ASSIGNEMENT( nil );

      beginsy:       BLOCK_STATE;
       casesy:       CASE_STATE;
         ifsy:       IF_STATE;
      whilesy:       WHILE_STATE;
      repeatsy:      REPEAT_STATE;
      loopsy: ;
      forsy:         FOR_STATE;

      writesy, writelnsy, writemsgsy, displaysy:
                     WRITE_VALUES( stat_sy );

      readsy, replysy:
                     READ_VALUES( stat_sy );

      opensy:        OPENFILE_STATE;
      closesy:       CLOSEFILE_STATE;

      macrosy:       MACRO_STATE;
      purgesy:       PURGE_STATE;

      macrocallsy:   MACLOAD_STATE;
      macrolibsy:    MACLIBR_STATE;

      errorsy:       ERROR_STATE;

      tablebldsy:    TABLE_GENERATOR;
      integrtabsy:   INTEGR_TAB_GENERATOR;

      lsqparmsy:     DECLARE_PARAMETER;
      lsqdirsy:      DECLARE_DIRECTIVE;

      itemsy:        DECLARE_ITEM_TYPE;
      itmegrpsy:     GEN_END_ITEM_BLOCK;

      identsy: if sy_macro = nil then
               begin
                 ide := IDE_SEARCH( true, [cla_generic,cla_type,cla_field,cla_itmfld,cla_formal,cla_varbl] );
                 if ide = nil then
                 begin  SKIP_SYMBOL( semicolon ); ide := udc_ident  end
                 else
                   case ide^.ide_class of
                     cla_generic: EXP_GENERIC_CALL( ide, false );

                     cla_type:    if ide^.ide_typ <> nil then
                                  with ide^.ide_typ^ do
                                    if objf_lsqpa in typ_flg then DECLARE_PARAMETER
                                    else
                                    if typ_frm = tfrm_itmty then DECLARE_ITEM_OBJ( ide )
                                                            else DECLARE_NEW_VARBL( ide );

                     cla_formal,
                     cla_itmfld,
                     cla_field,
                     cla_varbl:   ASSIGNEMENT( ide );

                     cla_directive: GEN_DIRECTIVE( ide );

                   otherwise
                     SRC_ERROR( mdnam, 61, e_severe ); INSYMBOL
                   end
               end
               else
                 if sy_macro^.idm_kind = idm_macro then CALL_MACRO
                 else SRC_ERROR_S( mdnam, 109, e_severe, sy_ident );

      semicolon, nothing:  ; { Not a statement }


    otherwise
      SRC_ERROR( mdnam, 110, e_error );
      SKIP_SYMBOL( semicolon )
    end;
    case sy of
      eofsy, eomcsy, semicolon,
      untilsy, endsy, elsesy: ;
    otherwise
      INSYMBOL
    end
  end
end STATEMENT;



[global]
procedure STATELIST( stopper: symbol );
begin
  with sy_sym do
  begin
    with src_control^ do src_insnb := src_insnb + 1;
    INSYMBOL;
    if stopper = othersy then
    begin { Tolerate a colon after the other keyword in a case statement }
      stopper := endsy;
      if sy = colon then INSYMBOL
    end;
    if not (fatal_error or (sy = stopper) or
             (sy = endsy) or (sy = eofsy)) then
    repeat
      if sy <> semicolon then STATEMENT;
      while sy = peofsy do ENDFILE_STATE;
    exit if fatal_error or (sy = stopper) or (sy = endsy) or (sy = eofsy);
      if (sy = semicolon) or (sy = eofsy) then INSYMBOL
                                          else SRC_ERROR( 'STLI', 21, e_error )
    until fatal_error or (sy = stopper) or
         (sy = endsy) or (sy = eofsy) or (sy = elsesy) or (sy = eomcsy);
    with src_control^ do src_insnb := src_insnb - 1
  end
end STATELIST;



end MXD_DCP_EXEC.
