{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*             MXD   Data   Compiler  Buitin Entries   Module                  *
*                                                                             *
*                                                                             *
*******************************************************************************


}

{************     CPAS  version    *************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_DCP_BUILTIN;

  %include        'MXDSRC:mxd_dcp_env';         { Load the MXD data Compiler Environment }




procedure POP_EXP_REFER( var rec: exp_rec );
begin
  POP_EXPRESSION( rec );
  CHECK_LVALUE_REF( rec )
end POP_EXP_REFER;



procedure POP_NUMEXPR( var   bf:       boolean;
                       var   iv:       integer;
                       var   rv, sg:   mxd_flt );
{ To pop a number value }
var
  fm:        val_forms;
  st:       str_string;

begin
  POP_EXPRESSION( exp_rs0 );
  EXTRACT_VALUE( exp_rs0, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: begin
                bf := false;
                if st.length > 0 then READV( st, iv )
                                 else iv := 0
              end;
    vfrm_int: bf := false;
    vfrm_flt: bf :=  true;
  otherwise
  end
end POP_NUMEXPR;



procedure POP_STREXPR( var st: string );
{ To pop a string value }
var
  fm:        val_forms;
  iv:          integer;
  rv, sg:      mxd_flt;

begin
  POP_EXPRESSION( exp_rs0 );
  EXTRACT_VALUE( exp_rs0, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: ;
    vfrm_flt: WRITEV( st, rv );
    vfrm_int: WRITEV( st, iv );
  otherwise
  end
end POP_STREXPR;



function POP_INTEXPR( iv: integer ): integer;
{ To pop an integer value }
var
  fm:        val_forms;
  st:       str_string;
  rv, sg:      mxd_flt;

begin
  POP_EXPRESSION( exp_rs0 );
  EXTRACT_VALUE( exp_rs0, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, iv )
                               else iv := 0;
    vfrm_flt: iv := ROUND( rv );
    vfrm_int: ;
  otherwise
  end;
  POP_INTEXPR := iv
end POP_INTEXPR;



function POP_FLTEXPR( rv: mxd_flt ): mxd_flt;
{ To pop a floatting value }
var
  fm:        val_forms;
  st:       str_string;
  iv:          integer;
  sg:          mxd_flt;

begin
  POP_EXPRESSION( exp_rs0 );
  EXTRACT_VALUE( exp_rs0, fm, iv, rv, sg, st );
  case fm of
    vfrm_str: if st.length > 0 then READV( st, rv )
                               else rv := 0.0;
    vfrm_flt: ;
    vfrm_int: rv := iv;
  otherwise
  end;
  POP_FLTEXPR := rv
end POP_FLTEXPR;



(*
[global]
procedure CREATE_NEW_ARR_DEF( var pn: typ_ptr; var  sz:     integer;
                                  po: typ_ptr;      np, nc: integer );
{ Procedure to create array type records from the np parameters
  in expression stack and copy the old array structure for the
  unchanged dimensions }
const
  mdnam = 'ARDF';

var
  pl, pc:      typ_ptr;
  bc:          boolean;

begin
  if po <> nil then
  begin
    pn := TYP_NEW( tfrm_array, nil, nil );      { Create the new array definition block }
    with pn^ do
    begin
      typ_ael := nil;
      typ_siz := po^.typ_siz;                   { Set the old size  as default }
      if po^.typ_ael <> nil then                { Array of array }
        bc := (po^.typ_ael^.typ_frm = tfrm_array)
      else bc := false;
      if bc then
      begin
        CREATE_NEW_ARR_DEF( typ_ael, typ_stp, po^.typ_ael, np, nc+1 );
        if np >= nc then                        { If a dimension is given, ... }
        begin
          typ_siz := POP_INTEXPR( 0 );          { ... get it and ... }
          if typ_siz <= 0 then                  { ... if not > 0 => error and set at 1 }
          begin
            SRC_ERROR( mdnam, 75, e_severe );
            typ_siz := 1
          end
        end
      end
      else
      begin                                     { Array of scalar or top sub-array }
        typ_ael := nil;
        typ_stp := 1;
        if np > nc then
        begin { ** Too many specified dimension error ** }
          SRC_ERROR( mdnam, 114, e_severe );
          while np > nc do
          begin { Take off the overflow of parameters }
            exp_stkp := exp_stkp - 1;
            np := np - 1
          end
        end;
        if np = nc then                         { All dimension was specified }
        begin                                   { Get the specified dimension }
          typ_siz := POP_INTEXPR( 0 );          { Get it and ... }
          if typ_siz <= 0 then                  { ... if not > 0 => error and set at 1 }
          begin
            SRC_ERROR( mdnam, 75, e_severe );
            typ_siz := 1
          end
        end
      end;
      sz := typ_stp*typ_siz                     { Return the step of outer dimension }
    end
  end
end CREATE_NEW_ARR_DEF;



procedure EMODIF_ARRAY( np: integer );
const
  mdnam = 'ARMD';

type
  e_r = record case integer of
    1:( ps: ^val_ast );
    2:( pi: ^val_ain );
    3:( pf, pe: ^val_afl )
  end;

var
  dat_new: [static]          e_r;
  size, iold, inew, sps: integer;
  pold, pnew:            typ_ptr;
  ip:                    ide_ptr;


  procedure COPY_ELEM( frm: val_forms; pn, po: typ_ptr );
  var
    sz: integer;
    be: boolean;

  begin
    with pn^, ip^.idev_val, dat_new do
    if typ_ael <> nil then
    begin
      if po^.typ_siz > typ_siz then sz := typ_siz
                               else sz := po^.typ_siz;
      if typ_ael^.typ_frm <> tfrm_array then
        { For the array of scalar (or last sub-array) }
        { Copy all the common element and init the new others }
        case typ_frm of
          tfrm_str:  with ps^ do
                     begin
                       for ii := 1 to sz do
                       begin
                         iold := iold + 1; inew := inew + 1;
                         val_stb[inew] := aas^.val_stb[iold]
                       end;
                       for ii := sz + 1 to typ_siz do
                       begin  inew := inew + 1; val_stb[inew] := nil  end
                     end;
          tfrm_int:  with pi^ do
                     begin
                       for ii := 1 to sz do
                       begin
                         iold := iold + 1; inew := inew + 1;
                         val_itb[inew] := aai^.val_itb[iold]
                       end;
                       for ii := sz + 1 to typ_siz do
                       begin  inew := inew + 1; val_itb[inew] := 0  end
                     end;
          tfrm_flt:  with pf^ do
                     begin
                       for ii := 1 to sz do
                       begin
                         iold := iold + 1; inew := inew + 1;
                         val_ftb[inew] := aaf^.val_ftb[iold]
                       end;
                       for ii := sz + 1 to typ_siz do
                       begin  inew := inew + 1; val_ftb[inew] := 0.0  end
                     end;
        otherwise
        end { case typ_frm of }
      else
        begin { For an array of array }
          { For the previously existing sub-array elements }
          for ii := 1 to sz do  COPY_ELEM( frm, typ_ael, po^.typ_ael );
          { For the new sub sub-array elements }
          for ii := sz + 1 to typ_siz do
          case val_frm of
            vfrm_ast: with ps^ do
                      for jj := 1 to typ_stp do
                      begin  inew := inew + 1; val_stb[inew] := nil  end;
            vfrm_ain: with pi^ do
                      for jj := 1 to typ_stp do
                      begin  inew := inew + 1; val_itb[inew] :=   0  end;
            vfrm_afl: with pf^ do
                      for jj := 1 to typ_stp do
                      begin  inew := inew + 1; val_ftb[inew] := 0.0  end;
          otherwise
          end
        end
    end
  end COPY_ELEM;


begin { EMODIF_ARRAY }
  ip := nil;
  sps := exp_stkp - np;
  if exp_stkp < np then
    SRC_ERROR( mdnam, 7, e_fatal )              { Expression stack underflow }
  else
  with exp_stk[sps + 1], exp_val do
  begin
    if (exp_ref = nil) or (exp_typ = nil) then
      SRC_ERROR( mdnam, 111, e_severe )         { not a space reference error }
    else
      if exp_typ^.typ_frm <> tfrm_array then SRC_ERROR( mdnam, 113, e_severe ) { Not an array error }
                                        else ip := exp_ref
  end;

  if ip <> nil then
  with ip^, idev_val do
    if objf_lockd in ide_flg then SRC_ERROR( mdnam, 79, e_error )
    else
    begin
      CREATE_NEW_ARR_DEF( pnew, size, ide_typ, np - 1, 1 );
      if pnew <> nil then
      with dat_new, pnew^ do
      begin { allocate the new data space }
        size := typ_stp*typ_siz;
        case val_frm of
          vfrm_ast: NEW( ps, size );
          vfrm_ain: NEW( pi, size );
          vfrm_afl: NEW( pf, size );
        otherwise
        end;
        { Initialize the data indexes }
        iold := 0; inew := 0;
        { Copy the already existing element and initialize the new ones }
        COPY_ELEM( val_frm, pnew, ide_typ );
        { Free the old data space and set the new one }
        case val_frm of
          vfrm_ast: begin  DISPOSE( aas ); aas := ps  end;
          vfrm_ain: begin  DISPOSE( aai ); aai := pi  end;
          vfrm_afl: begin  DISPOSE( aaf ); aaf := pf  end;
        otherwise
        end;
        { set the new array structure definition and free the old one }
        pold := ide_typ;
        ide_typ := pnew;
        while pold <> nil do
        begin
          pnew := pold;
          pold := pold^.typ_ael;
          DISPOSE( pnew )
        end
      end
    end;
  exp_stkp := sps
end EMODIF_ARRAY;
*)


[global]
procedure EXEC_BUILTIN( fnc: std_fnc; npa: integer );
{ To perform the builtin functions }
const
  mdnam = 'BLTF';

  { *** Array operator definitions *** }

var
  iv, i, j, k, l, r:           integer;
  rv, sg:                      mxd_flt;
  bf, bs:                      boolean;
  st, ss:                   str_string;
  ftst:                           text;
  rec, rec1:                   exp_rec;
  frm:                       val_forms;
  arf:                        dcp_oper;
  ip:                          ide_ptr;
  ch, cc:                         char;
  imd, jmd:                 flags_file;

begin
  { The parameters are put in the stack }
  with sy_sym do
  case fnc of
    std_string: begin
                  if npa > 2 then j := POP_INTEXPR( 0 ) else j := 0;
                  if npa > 1 then i := POP_INTEXPR( 0 ) else i := 0;
                  POP_NUMEXPR( bf, iv, rv, sg );
                  if bf then WRITEV( st, rv:i:j )
                        else WRITEV( st, iv:i:j );
                  EXP_PUTSTR( st )
                end;

    std_substr: begin
                  if npa > 2 then j := POP_INTEXPR( 0 ) else j := 0;
                  if npa > 1 then i := POP_INTEXPR( 0 ) else i := 0;
                  POP_STREXPR( st );
                  EXP_PUTSTR( SUBSTR( st, i, j ) )
                end;

    std_nindex: begin
                  if npa > 2 then i := POP_INTEXPR( 0 )
                             else i := 1;
                  POP_STREXPR( ss );
                  POP_STREXPR( st );
                  EXP_PUTINT( INDEX( st, ss, i ) )
                end;

    std_slength: begin
                  POP_STREXPR( st );
                  EXP_PUTINT( st.length )
                end;

    std_setcase: begin
                  if npa > 1 then i := POP_INTEXPR( 0 ) else i := 0;
                  POP_STREXPR( st );
                  if i > 0 then { in maj }
                    for ii := i to st.length do
                    begin
                      if (st[ii] >= 'a') and (st[ii] <= 'z') then
                                     st[ii] := CHR( ORD( st[ii] ) - 32 )
                    end
                  else { in min }
                    for ii := i to st.length do
                    begin
                      if (st[ii] >= 'A') and (st[ii] <= 'Z') then
                                     st[ii] := CHR( ORD( st[ii] ) + 32 )
                    end;
                  EXP_PUTSTR( st )
                end;

    std_checkch: begin
                  if npa > 2 then k := POP_INTEXPR( 0 )
                             else k := 0;
                  POP_STREXPR( ss );
                  POP_STREXPR( st );
                  iv := 0;
                  i  := 1;
                  while (i <= st.length) and (iv = 0) do
                  begin
                    ch := st[i];
                    if k > 0 then
                      if (ch >='A') and (ch <= 'Z') then ch := CHR( ORD( ch ) + 32 );
                    j := 1;
                    while (j <= ss.length) and (iv = 0) do
                    begin
                      cc := ss[j];
                      if k > 0 then
                        if (cc >='A') and (cc <= 'Z') then cc := CHR( ORD( cc ) + 32 );
                      if cc = ch then begin  iv := j; if iv = 0 then iv := -1  end;
                      j := j + 1
                    end;
                    if iv = 0 then i := i + 1
                  end;
                  EXP_PUTINT( iv )
                end;

    std_checknst: begin
                  POP_STREXPR( st );
                  EXP_PUTINT( ORD( USR_NUMERIC_STRING( st ) ) )
                end;

    std_selement: begin
                  ch := ' '; cc := '"';
                  if npa > 4 then bs := POP_INTEXPR( 0 ) > 0
                             else bs := false;
                  if npa > 3 then
                  begin  POP_STREXPR( ss ); if ss.length > 0 then cc := ss[1]  end;
                  if npa > 2 then
                  begin  POP_STREXPR( ss ); if ss.length > 0 then ch := ss[1]  end;
                  if npa > 1 then iv := POP_INTEXPR( 1 ) else iv := 1;
                  POP_STREXPR( ss );
                  USR_S_ELEMENT( st, ss, iv, ch, cc, bs );
                  EXP_PUTSTR( st )
                end;

    std_rmcomment: begin
                  cc := '"'; ch := '!';
                  if npa > 2 then
                  begin  POP_STREXPR( ss ); if ss.length > 0 then cc := ss[1]  end;
                  if npa > 1 then
                  begin  POP_STREXPR( ss ); if ss.length > 0 then ch := ss[1]  end;
                  POP_STREXPR( ss );
                  USR_SUPPRESS_COMMENT( ss, st, ch, cc );
                  EXP_PUTSTR( st )
                end;

    std_id_replace: begin
                  POP_STREXPR( ss );
                  if ss.length > 0 then ch := ss[1]
                                   else ch := '"';
                  POP_STREXPR( ss );
                  USR_IDE_SUBSTITUTE( ss, st, ch );
                  EXP_PUTSTR( st )
                end;

    std_id_insert,
    std_id_remove: begin
                  bf := (fnc = std_id_insert);  { Keep the memory of the specified function }
                  INSYMBOL;                     { Gobble up the function identifier }
                  if sy = lparen then sy := comma
                                 else SRC_ERROR( mdnam, 22, e_error );
                  while sy = comma do
                  begin
                    INSYMBOL;                   { Gobble up the separator ',' or '(' }
                    ip := IDE_SEARCH( true );   { Locate the identifier }
                    if bf then USR_IDE_APPEND( ip )
                          else USR_IDE_REMOVE( ip );
                    INSYMBOL                    { Gobble up the parameter identifier }
                  end;
                  EXP_PUTINT( 1 );
                  if sy <> rparen then SRC_ERROR( mdnam, 23, e_error )
                                  else INSYMBOL
                end;

    std_filespc: begin
                  if npa > 1 then i := POP_INTEXPR( 1 ) else i := 0;
                  POP_STREXPR( ss );
                  imd := IN_FILEMODE( i );
                  if SET_FILE_SPECIFICATION( st, ss, imd ) then j := 0
                                                           else j := 121;
                  io_err^.idev_val.int := j;
                  EXP_PUTSTR( st )
                end;

    std_time:   begin  TIME( st ); EXP_PUTSTR( st )  end;
    std_date:   begin  DATE( st ); EXP_PUTSTR( st )  end;

    std_spawn:  begin
                  if npa > 0 then POP_STREXPR( st ) else st := '';
                  EXP_PUTINT( ORD( SYS_SPAWN( st ) ) )
                end;

    std_run:    begin
                  if npa > 1 then i := POP_INTEXPR( 0 ) else i := 0;
                  POP_STREXPR( st );
                  RUN_PROCESS( '', st, i );
                  EXP_PUTINT( -1 )
                end;

    std_exec:   begin
                  if npa > 1 then i := POP_INTEXPR( 0 ) else i := 0;
                  POP_STREXPR( st );
                  j := CREATE_PROCESS( '', st, i );
                  EXP_PUTINT( j )
                end;

    std_wait:   EXP_PUTINT( WAIT_PROCESS( io_winfo^.idev_val.int, POP_INTEXPR( 0 ) ) );

    std_exit:   begin
                  if npa > 1 then
                  begin
                    POP_STREXPR( st );
                    WRITELN( ' MXD Exit with the message : ', st )
                  end;
                  if npa > 0 then i := POP_INTEXPR( 0 )
                             else i := 1;
                   PASCAL_EXIT( i )
                end;

    std_dfdir:  EXP_PUTSTR( GET_DEF_DIR );

    std_chdir:  begin
                  if npa > 1 then i := POP_INTEXPR( 1 ) else i := 0;
                  POP_STREXPR( st );
                  imd := IN_FILEMODE( i );
                  EXP_PUTINT( ORD( CHANGE_DIRECTORY( st, imd ) ) )
                end;

    std_getenv: begin
                  POP_STREXPR( st );
                  i := GET_LOGICAL( ss, st );
                  if i <> 0 then ss := '';
                  EXP_PUTSTR( ss )
                end;

    std_setenv: begin
                  if npa > 1 then POP_STREXPR( ss )
                             else ss := '';
                  POP_STREXPR( st );
                  EXP_PUTINT( ORD( SET_LOGICAL( st, ss ) = 0 ) )
                end;

    std_getpath: begin
                  ch := ':';
                  if npa > 2 then
                  begin
                    POP_STREXPR( ss );
                    if ss.length > 0 then ch := ss[1]
                  end;
                  POP_STREXPR( st );           { Get the logical name string }
                  POP_EXP_REFER( rec );        { Get the string array reference }
                  i := -1;                     { Assume bad array error until shown otherwise }
                  with rec.exp_val do
                    if val_frm <> vfrm_ast then SRC_ERROR( mdnam, 999, e_severe )
                                           else i := USR_GETPATH( ch, st, aas^ );
                  EXP_PUTINT( i )
                end;

    std_setpath: begin
                  if npa > 2 then i := POP_INTEXPR( 0 )
                             else i := 0;
                  POP_STREXPR( st );
                  POP_EXP_REFER( rec );
                  i := -1;                     { Assume bad array error until shown otherwise }
                  with rec.exp_val do
                    if val_frm <> vfrm_ast then SRC_ERROR( mdnam, 999, e_severe )
                                           else i := USR_SETPATH( st, i, aas^ );
                  EXP_PUTINT( i )
                end;




    std_f_exist: begin
                  if npa > 1 then i := POP_INTEXPR( 4 ) else i := 4; { Read access }
                  POP_STREXPR( st );
                  if FILE_ACCESS_CHECK( st, i, [case_ena_file] ) then EXP_PUTINT( 1 )
                                                                 else EXP_PUTINT( 0 )
                end;

    std_f_rename: begin
                  if npa > 3 then j := POP_INTEXPR( 1 ) else j := 0;
                  jmd := IN_FILEMODE( j );
                  if npa > 2 then i := POP_INTEXPR( 1 ) else i := 0;
                  imd := IN_FILEMODE( i );
                  POP_STREXPR( ss );
                  POP_STREXPR( st );
                  if FILE_RENAME( st, ss, imd, jmd ) then EXP_PUTINT( 1 )
                                                     else EXP_PUTINT( 0 )
                end;

    std_f_delete: begin
                  if npa > 1 then i := POP_INTEXPR( 1 ) else i := 0;
                  POP_STREXPR( st );
                  imd := IN_FILEMODE( i );
                  if FILE_REMOVE( st, imd ) then EXP_PUTINT( 1 )
                                            else EXP_PUTINT( 0 )
                end;

    std_arlow,
    std_arhigh,
    std_ardim:  begin { Get an array dimension }
                  if npa > 1 then j := POP_INTEXPR( 1 ) else j := 0;
                  POP_EXP_REFER( rec );
                  i := -1;
                  with rec do
                    if exp_typ <> nil then
                      if rec.exp_typ^.typ_frm <> tfrm_array then
                        SRC_ERROR( mdnam, 113, e_error )
                      else
                      begin
                        if j > 0 then
                        begin
                          while exp_typ <> nil do
                          with exp_typ^ do
                          begin
                          exit if typ_frm <> tfrm_array;
                            j := j - 1;
                            case fnc of
                              std_ardim:  i := typ_siz;
                              std_arlow:  i := typ_min;
                              std_arhigh: i := typ_siz - typ_min + 1;
                            end;
                          exit if j = 0;
                            exp_typ := typ_ael;
                          end;
                          if j > 0 then SRC_ERROR( mdnam, 114, e_error )
                        end
                        else i := exp_esz
                      end;
                  EXP_PUTINT( i )
                end;

    std_arsearch:
                with rec do
                begin { Search an element in a one dimension array }
                  if npa > 2 then j := POP_INTEXPR( 0 ) else j := 0;
                  if j > 0 then j := 1 else if j < 0 then j := -1;
                  frm := EXP_GETKINDS( 1 );
                  { To following the type of array }
                  case frm of
                    vfrm_ain: iv := POP_INTEXPR( 0 );
                    vfrm_afl: rv := POP_FLTEXPR( 0.0 );
                    vfrm_ast: POP_STREXPR( st );
                  otherwise
                    SRC_ERROR( mdnam, 113, e_error )
                  end;
                  { Get the array reference }
                  POP_EXP_REFER( rec );
                  r := 0;
                  i := 0;
                  if exp_typ <> nil then
                  with exp_typ^, exp_val do
                  if typ_ael <> nil then
                  begin
                    i := exp_shf + 1;
                    l := exp_esz + exp_shf;
                    case val_frm of
                      vfrm_ast:
                        if aas <> nil then
                        with aas^ do
                        repeat
                          if val_stb[i] = nil then
                            if st.length = 0 then k :=  0
                                             else k := -1
                          else
                            k := STR_MATCH( val_stb[i]^, st );
                          case j of
                           -1: if k < 0 then r := i;
                            0: if k = 0 then r := i;
                            1: if k > 0 then r := i;
                          otherwise
                          end;
                        exit if r <> 0;
                          i := i + 1;
                        until i > l;

                      vfrm_ain:
                        if aai <> nil then
                        with aai^ do
                        repeat
                          case j of
                           -1: if val_itb[i] < iv then r := i;
                            0: if val_itb[i] = iv then r := i;
                            1: if val_itb[i] > iv then r := i;
                          otherwise
                          end;
                        exit if r <> 0;
                          i := i + 1;
                        until i > l;

                      vfrm_afl:
                        if aaf <> nil then
                        with aaf^ do
                        repeat
                          case j of
                           -1: if val_ftb[i] < rv then r := i;
                            0: if val_ftb[i] = rv then r := i;
                            1: if val_ftb[i] > rv then r := i;
                          otherwise
                          end;
                        exit if r <> 0;
                          i := i + 1;
                        until i > l;


                    otherwise
                    end
                  end;
                  EXP_PUTINT( r )
                end;

    std_errcount:
                begin
                  case error_result of
                    e_warning: iv := 1;
                    e_error:   iv := 2;
                    e_severe:  iv := 3;
                    e_fatal:   iv := 4;
                  otherwise
                    iv := 0;
                  end;
                  EXP_PUTINT( iv )
                end;
  otherwise
    SRC_ERROR( mdnam, 901, e_severe )
  end
end EXEC_BUILTIN;


end MXD_DCP_BUILTIN.
