/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 192 ) = {
 13,  13, 112, 111, 112,  95, 101, 120, 112,  95, 114, 101, 102, 101, 114,  58,
 58,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83,
111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,
 68,  86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95, 100,  99, 112,  95,
 98, 117, 105, 108, 116, 105, 110,  46, 112,  97, 115,  11,  11, 112, 111, 112,
 95, 110, 117, 109, 101, 120, 112, 114,  11,  11, 112, 111, 112,  95, 115, 116,
114, 101, 120, 112, 114,  11,  11, 112, 111, 112,  95, 105, 110, 116, 101, 120,
112, 114,  11,  11, 112, 111, 112,  95, 102, 108, 116, 101, 120, 112, 114,  12,
 12, 101, 120, 101,  99,  95,  98, 117, 105, 108, 116, 105, 110,   4,   4,  66,
 76,  84,  70,   0,   0,   0,   0,   0,   0,  29,  29,  32,  77,  88,  68,  32,
 69, 120, 105, 116,  32, 119, 105, 116, 104,  32, 116, 104, 101,  32, 109, 101,
115, 115,  97, 103, 101,  32,  58,  32,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_exp_rs0, 48 );
extern Blk(V_sy_sym, 8 );
extern V V_io_err;
extern V V_io_winfo;
extern V PAS__f_output;
extern UB V_error_result;


/* Function/procedure prototypes. */
void P_src_error(V F_modnam, SL F_number, UB F_severity);
V P_ide_search(UB F_berr, UB F_cls);
void P_usr_ide_append(V F_p);
void P_usr_ide_remove(V F_p);
SL P_usr_getpath(C F_sp, V F_st, V F_tbrf);
SL P_usr_setpath(V F_st, SL F_ist, V F_tbrf);
void P_usr_ide_substitute(V F_src, V F_dst, C F_ch);
void P_usr_s_element(V F_dst, V F_src, SL F_iel, C F_csp, C F_cst, UB F_bss);
void P_usr_suppress_comment(V F_src, V F_dst, C F_cc, C F_cs);
UB P_usr_numeric_string(V F_str);
void P_insymbol();
void P_pop_expression(V F_rec);
UB P_exp_getkinds(SL F_ish);
void P_check_lvalue_ref(V F_rec);
void P_exp_putstr(V F_st);
void P_exp_putint(SL F_iv);
UL P_in_filemode(SL F_iv);
void P_extract_value(V F_rec, UB *F_frm, SL *F_iv, G *F_rv, G *F_sg, V F_st);


/* Procedure/Function : " pop_exp_refer "  */
void MXD_DCPLTIN_pop_exp_refer(V F_rec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+15;
  Ra.sl[3]=106; /* line # 106 */
  P_pop_expression(F_rec);
  Ra.sl[3]=107; /* line # 107 */
  P_check_lvalue_ref(F_rec);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop_numexpr "  */
void MXD_DCPLTIN_pop_numexpr(UB *F_bf, SL *F_iv, G *F_rv, G *F_sg){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+75;
  Ra.v[67]=Rd.s+15;
  Ra.sl[68]=121; /* line # 121 */
  P_pop_expression(V_exp_rs0.s);
  Ra.sl[68]=122; /* line # 122 */
  P_extract_value(V_exp_rs0.s,&Rv0, F_iv,F_rv,F_sg,Ra.s);
  Ra.sl[68]=123; /* line # 123 */
  switch (Rv0) {
    case 0:Ra.sl[68]=125; /* line # 125 */
    (*F_bf)=0;
    Ra.sl[68]=126; /* line # 126 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_SL(F_iv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=127; /* line # 127 */
      (*F_iv)=0;
    }
    break;
    case 1:Ra.sl[68]=129; /* line # 129 */
    (*F_bf)=0;
    break;
    case 2:Ra.sl[68]=130; /* line # 130 */
    (*F_bf)=1;
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " pop_strexpr "  */
void MXD_DCPLTIN_pop_strexpr(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+88;
  Ra.v[2]=Rd.s+15;
  Ra.sl[3]=145; /* line # 145 */
  P_pop_expression(V_exp_rs0.s);
  Ra.sl[3]=146; /* line # 146 */
  P_extract_value(V_exp_rs0.s,&Rv0, &Rv1, &Rv2, &Rv3, F_st);
  Ra.sl[3]=147; /* line # 147 */
  switch (Rv0) {
    case 0:break;
    case 2:Ra.sl[3]=149; /* line # 149 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_DBLE(Rv2,24,-15,0);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=150; /* line # 150 */
    PAS__VWRITE_INIT(F_st,1);
    PAS__WRITE_INT(Rv1,12,0);
    PAS__WRITE_EOLN();
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop_intexpr "  */
SL MXD_DCPLTIN_pop_intexpr(SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  G Rv1;
  G Rv2;
  register G Rgg;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+101;
  Ra.v[67]=Rd.s+15;
  Ra.sl[68]=165; /* line # 165 */
  P_pop_expression(V_exp_rs0.s);
  Ra.sl[68]=166; /* line # 166 */
  P_extract_value(V_exp_rs0.s,&Rv0, &F_iv, &Rv1, &Rv2, Ra.s);
  Ra.sl[68]=167; /* line # 167 */
  switch (Rv0) {
    case 0:Ra.sl[68]=168; /* line # 168 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_SL(&F_iv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=169; /* line # 169 */
      F_iv=0;
    }
    break;
    case 2:Ra.sl[68]=170; /* line # 170 */
    F_iv=(Rv1>0.0?(SL)(Rv1+0.5):(SL)(Rv1-0.5));
    break;
    case 1:break;
    default:break;
  }
  Ra.sl[68]=174; /* line # 174 */
  Ret=F_iv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " pop_fltexpr "  */
G MXD_DCPLTIN_pop_fltexpr(G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  G Rv2;
  register G Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+114;
  Ra.v[67]=Rd.s+15;
  Ra.sl[68]=188; /* line # 188 */
  P_pop_expression(V_exp_rs0.s);
  Ra.sl[68]=189; /* line # 189 */
  P_extract_value(V_exp_rs0.s,&Rv0, &Rv1, &F_rv, &Rv2, Ra.s);
  Ra.sl[68]=190; /* line # 190 */
  switch (Rv0) {
    case 0:Ra.sl[68]=191; /* line # 191 */
    if (Ra.ub[1]>0) {
      PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
      PAS__READ_DBLE(&F_rv,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[68]=192; /* line # 192 */
      F_rv=0.000000000000000E-001;
    }
    break;
    case 2:break;
    case 1:Ra.sl[68]=194; /* line # 194 */
    F_rv=(double)Rv1;
    break;
    default:break;
  }
  Ra.sl[68]=197; /* line # 197 */
  Ret=F_rv;
  PAS__curr_cntx=Ra.v[65];
  return(Ret);
}


/* Procedure/Function : " exec_builtin "  */
void P_exec_builtin(UB F_fnc, SL F_npa){
  /* Define the automatic variable space. */
  Blk( Ra, 840 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  G Rv4;
  G Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  C Rv9;
  C Rv10;
  UB Rv11;
  V Rv12;
  UL Rv13;
  UL Rv14;
  register V Rv15;
  UB Rv16;
  SL Rv17;
  register V Rv18;
  register V Rv19;
  SL Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.v[129]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+516;
  Ra.v[130]=Rd.s+127;
  Ra.v[131]=Rd.s+15;
  Ra.sl[132]=439; /* line # 439 */
  Ra.sl[132]=440; /* line # 440 */
  switch (F_fnc) {
    case 0:Ra.sl[132]=442; /* line # 442 */
    if (F_npa>2) Rv0=MXD_DCPLTIN_pop_intexpr(0);
    else Rv0=0;
    Ra.sl[132]=443; /* line # 443 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else Rv1=0;
    Ra.sl[132]=444; /* line # 444 */
    MXD_DCPLTIN_pop_numexpr(&Rv2, &Rv3, &Rv4, &Rv5);
    Ra.sl[132]=445; /* line # 445 */
    if (Rv2) {
      PAS__VWRITE_INIT(Ra.s,1);
      PAS__WRITE_DBLE(Rv4, Rv1, Rv0,0);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[132]=446; /* line # 446 */
      PAS__VWRITE_INIT(Ra.s,1);
      PAS__WRITE_INT(Rv3, Rv1, Rv0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=447; /* line # 447 */
    P_exp_putstr(Ra.s);
    break;
    case 1:Ra.sl[132]=451; /* line # 451 */
    if (F_npa>2) Rv0=MXD_DCPLTIN_pop_intexpr(0);
    else Rv0=0;
    Ra.sl[132]=452; /* line # 452 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else Rv1=0;
    Ra.sl[132]=453; /* line # 453 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=454; /* line # 454 */
    P_exp_putstr(PAS__SUBSTR_STR(Ra.s+532,Ra.s,Rv1, Rv0));
    break;
    case 2:Ra.sl[132]=458; /* line # 458 */
    if (F_npa>2) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else {
      Ra.sl[132]=459; /* line # 459 */
      Rv1=1;
    }
    Ra.sl[132]=460; /* line # 460 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=461; /* line # 461 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=462; /* line # 462 */
    P_exp_putint(PAS__NINDEX_STR(Ra.s+2,(SL)Ra.ub[1],Ra.s+259,(SL)Ra.ub[258],Rv1,-1,1));
    break;
    case 3:Ra.sl[132]=466; /* line # 466 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=467; /* line # 467 */
    P_exp_putint(Ra.ub[1]);
    break;
    case 4:Ra.sl[132]=471; /* line # 471 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else Rv1=0;
    Ra.sl[132]=472; /* line # 472 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=473; /* line # 473 */
    if (Rv1>0) {
      Ra.sl[132]=474; /* line # 474 */
      Rv6=Rv1;
      for( Rf0=(Ra.ub[1]+1)-Rv1;Rf0>0;Rf0-- ) {
        Ra.sl[132]=476; /* line # 476 */
        if (Ra.c[Rv6+1]>=97&&Ra.c[Rv6+1]<=122) {
          Ra.sl[132]=477; /* line # 477 */
          Ra.c[Rv6+1]=(C)((SL)Ra.c[Rv6+1]-32);
        }
        Rv6++;
      }
    }
    else {
      Ra.sl[132]=480; /* line # 480 */
      Rv7=Rv1;
      for( Rf0=(Ra.ub[1]+1)-Rv1;Rf0>0;Rf0-- ) {
        Ra.sl[132]=482; /* line # 482 */
        if (Ra.c[Rv7+1]>=65&&Ra.c[Rv7+1]<=90) {
          Ra.sl[132]=483; /* line # 483 */
          Ra.c[Rv7+1]=(C)((SL)Ra.c[Rv7+1]+32);
        }
        Rv7++;
      }
    }
    Ra.sl[132]=485; /* line # 485 */
    P_exp_putstr(Ra.s);
    break;
    case 5:Ra.sl[132]=489; /* line # 489 */
    if (F_npa>2) Rv8=MXD_DCPLTIN_pop_intexpr(0);
    else {
      Ra.sl[132]=490; /* line # 490 */
      Rv8=0;
    }
    Ra.sl[132]=491; /* line # 491 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=492; /* line # 492 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=493; /* line # 493 */
    Rv3=0;
    Ra.sl[132]=494; /* line # 494 */
    Rv1=1;
    Ra.sl[132]=495; /* line # 495 */
    while (Rv1<=Ra.ub[1]&&Rv3==0){
      Ra.sl[132]=497; /* line # 497 */
      Rv9=Ra.c[Rv1+1];
      Ra.sl[132]=498; /* line # 498 */
      if (Rv8>0) {
        Ra.sl[132]=499; /* line # 499 */
        if (Rv9>=65&&Rv9<=90) Rv9=(C)((SL)Rv9+32);
      }
      Ra.sl[132]=500; /* line # 500 */
      Rv0=1;
      Ra.sl[132]=501; /* line # 501 */
      while (Rv0<=Ra.ub[258]&&Rv3==0){
        Ra.sl[132]=503; /* line # 503 */
        Rv10=Ra.c[Rv0+258];
        Ra.sl[132]=504; /* line # 504 */
        if (Rv8>0) {
          Ra.sl[132]=505; /* line # 505 */
          if (Rv10>=65&&Rv10<=90) Rv10=(C)((SL)Rv10+32);
        }
        Ra.sl[132]=506; /* line # 506 */
        if (Rv10==Rv9) {
          Rv3=Rv0;
          if (Rv3==0) Rv3=-1;
        }
        Ra.sl[132]=507; /* line # 507 */
        Rv0=Rv0+1;
      }
      Ra.sl[132]=509; /* line # 509 */
      if (Rv3==0) Rv1=Rv1+1;
    }
    Ra.sl[132]=511; /* line # 511 */
    P_exp_putint(Rv3);
    break;
    case 6:Ra.sl[132]=515; /* line # 515 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=516; /* line # 516 */
    P_exp_putint((SL)P_usr_numeric_string(Ra.s));
    break;
    case 7:Ra.sl[132]=520; /* line # 520 */
    Rv9=32;
    Rv10=34;
    Ra.sl[132]=521; /* line # 521 */
    if (F_npa>4) Rv11=MXD_DCPLTIN_pop_intexpr(0)>0;
    else {
      Ra.sl[132]=522; /* line # 522 */
      Rv11=0;
    }
    Ra.sl[132]=523; /* line # 523 */
    if (F_npa>3) {
      Ra.sl[132]=524; /* line # 524 */
      MXD_DCPLTIN_pop_strexpr(Ra.s+257);
      if (Ra.ub[258]>0) Rv10=Ra.c[259];
    }
    Ra.sl[132]=525; /* line # 525 */
    if (F_npa>2) {
      Ra.sl[132]=526; /* line # 526 */
      MXD_DCPLTIN_pop_strexpr(Ra.s+257);
      if (Ra.ub[258]>0) Rv9=Ra.c[259];
    }
    Ra.sl[132]=527; /* line # 527 */
    if (F_npa>1) Rv3=MXD_DCPLTIN_pop_intexpr(1);
    else Rv3=1;
    Ra.sl[132]=528; /* line # 528 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=529; /* line # 529 */
    P_usr_s_element(Ra.s,Ra.s+257,Rv3, Rv9, Rv10, Rv11);
    Ra.sl[132]=530; /* line # 530 */
    P_exp_putstr(Ra.s);
    break;
    case 8:Ra.sl[132]=534; /* line # 534 */
    Rv10=34;
    Rv9=33;
    Ra.sl[132]=535; /* line # 535 */
    if (F_npa>2) {
      Ra.sl[132]=536; /* line # 536 */
      MXD_DCPLTIN_pop_strexpr(Ra.s+257);
      if (Ra.ub[258]>0) Rv10=Ra.c[259];
    }
    Ra.sl[132]=537; /* line # 537 */
    if (F_npa>1) {
      Ra.sl[132]=538; /* line # 538 */
      MXD_DCPLTIN_pop_strexpr(Ra.s+257);
      if (Ra.ub[258]>0) Rv9=Ra.c[259];
    }
    Ra.sl[132]=539; /* line # 539 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=540; /* line # 540 */
    P_usr_suppress_comment(Ra.s+257,Ra.s,Rv9, Rv10);
    Ra.sl[132]=541; /* line # 541 */
    P_exp_putstr(Ra.s);
    break;
    case 9:Ra.sl[132]=545; /* line # 545 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=546; /* line # 546 */
    if (Ra.ub[258]>0) Rv9=Ra.c[259];
    else {
      Ra.sl[132]=547; /* line # 547 */
      Rv9=34;
    }
    Ra.sl[132]=548; /* line # 548 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=549; /* line # 549 */
    P_usr_ide_substitute(Ra.s+257,Ra.s,Rv9);
    Ra.sl[132]=550; /* line # 550 */
    P_exp_putstr(Ra.s);
    break;
    case 10:
    case 11:Ra.sl[132]=555; /* line # 555 */
    Rv2=F_fnc==10;
    Ra.sl[132]=556; /* line # 556 */
    P_insymbol();
    Ra.sl[132]=557; /* line # 557 */
    if (V_sy_sym.ub[0]==13) V_sy_sym.ub[0]=17;
    else {
      Ra.sl[132]=558; /* line # 558 */
      P_src_error(Rd.s+143,22,2);
    }
    Ra.sl[132]=559; /* line # 559 */
    while (V_sy_sym.ub[0]==17){
      Ra.sl[132]=561; /* line # 561 */
      P_insymbol();
      Ra.sl[132]=562; /* line # 562 */
      Rv12=P_ide_search(1,0);
      Ra.sl[132]=563; /* line # 563 */
      if (Rv2) P_usr_ide_append(Rv12);
      else {
        Ra.sl[132]=564; /* line # 564 */
        P_usr_ide_remove(Rv12);
      }
      Ra.sl[132]=565; /* line # 565 */
      P_insymbol();
    }
    Ra.sl[132]=567; /* line # 567 */
    P_exp_putint(1);
    Ra.sl[132]=568; /* line # 568 */
    if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+143,23,2);
    else {
      Ra.sl[132]=569; /* line # 569 */
      P_insymbol();
    }
    break;
    case 12:Ra.sl[132]=573; /* line # 573 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(1);
    else Rv1=0;
    Ra.sl[132]=574; /* line # 574 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=575; /* line # 575 */
    Rv13=P_in_filemode(Rv1);
    Ra.sl[132]=576; /* line # 576 */
    if (PAS__SET_FILESPC(Ra.s,Ra.s+257,Rv13)) Rv0=0;
    else {
      Ra.sl[132]=577; /* line # 577 */
      Rv0=121;
    }
    Ra.sl[132]=578; /* line # 578 */
    ((SL *)V_io_err)[11]=Rv0;
    Ra.sl[132]=579; /* line # 579 */
    P_exp_putstr(Ra.s);
    break;
    case 13:Ra.sl[132]=582; /* line # 582 */
    PAS__TIME_STR(Ra.s);
    P_exp_putstr(Ra.s);
    break;
    case 14:Ra.sl[132]=583; /* line # 583 */
    PAS__DATE_STR(Ra.s);
    P_exp_putstr(Ra.s);
    break;
    case 15:Ra.sl[132]=586; /* line # 586 */
    if (F_npa>0) MXD_DCPLTIN_pop_strexpr(Ra.s);
    else PAS__STR_TO_STR(Ra.s,Rd.s+147);
    Ra.sl[132]=587; /* line # 587 */
    P_exp_putint((SL)PAS__SYSTEM(Ra.s));
    break;
    case 16:Ra.sl[132]=591; /* line # 591 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else Rv1=0;
    Ra.sl[132]=592; /* line # 592 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=593; /* line # 593 */
    PAS__RUN_PROC_1(Rd.s+149,Ra.s,Rv1,NULL);
    Ra.sl[132]=594; /* line # 594 */
    P_exp_putint(-1);
    break;
    case 17:Ra.sl[132]=598; /* line # 598 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else Rv1=0;
    Ra.sl[132]=599; /* line # 599 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=600; /* line # 600 */
    Rv0=PAS__CREATE_PROC_1(Rd.s+151,Ra.s,Rv1,NULL);
    Ra.sl[132]=601; /* line # 601 */
    P_exp_putint(Rv0);
    break;
    case 18:Ra.sl[132]=604; /* line # 604 */
    P_exp_putint(PAS__WAIT_PROCESS(((SL *)V_io_winfo)+11,MXD_DCPLTIN_pop_intexpr(0)));
    break;
    case 19:Ra.sl[132]=607; /* line # 607 */
    if (F_npa>1) {
      Ra.sl[132]=609; /* line # 609 */
      MXD_DCPLTIN_pop_strexpr(Ra.s);
      Ra.sl[132]=610; /* line # 610 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+153,-1,-1,32);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=612; /* line # 612 */
    if (F_npa>0) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else {
      Ra.sl[132]=613; /* line # 613 */
      Rv1=1;
    }
    Ra.sl[132]=614; /* line # 614 */
    PAS__EXIT(Rv1);
    break;
    case 20:Ra.sl[132]=617; /* line # 617 */
    P_exp_putstr(PAS__GET_DEF_DIR(Ra.s+532));
    break;
    case 21:Ra.sl[132]=620; /* line # 620 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(1);
    else Rv1=0;
    Ra.sl[132]=621; /* line # 621 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=622; /* line # 622 */
    Rv13=P_in_filemode(Rv1);
    Ra.sl[132]=623; /* line # 623 */
    P_exp_putint((SL)PAS__CHANGE_DIR(Ra.s,Rv13));
    break;
    case 22:Ra.sl[132]=627; /* line # 627 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=628; /* line # 628 */
    Rv1=PAS__GETENV(Ra.s+257,Ra.s);
    Ra.sl[132]=629; /* line # 629 */
    if (Rv1!=0) PAS__STR_TO_STR(Ra.s+257,Rd.s+184);
    Ra.sl[132]=630; /* line # 630 */
    P_exp_putstr(Ra.s+257);
    break;
    case 23:Ra.sl[132]=634; /* line # 634 */
    if (F_npa>1) MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    else {
      Ra.sl[132]=635; /* line # 635 */
      PAS__STR_TO_STR(Ra.s+257,Rd.s+186);
    }
    Ra.sl[132]=636; /* line # 636 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=637; /* line # 637 */
    P_exp_putint((SL)(PAS__SETENV(Ra.s,Ra.s+257,1)==0));
    break;
    case 24:Ra.sl[132]=641; /* line # 641 */
    Rv9=58;
    Ra.sl[132]=642; /* line # 642 */
    if (F_npa>2) {
      Ra.sl[132]=644; /* line # 644 */
      MXD_DCPLTIN_pop_strexpr(Ra.s+257);
      Ra.sl[132]=645; /* line # 645 */
      if (Ra.ub[258]>0) Rv9=Ra.c[259];
    }
    Ra.sl[132]=647; /* line # 647 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=648; /* line # 648 */
    MXD_DCPLTIN_pop_exp_refer(Ra.s+792);
    Ra.sl[132]=649; /* line # 649 */
    Rv1=-1;
    Ra.sl[132]=650; /* line # 650 */
    Ra.sl[132]=651; /* line # 651 */
    if (Ra.ub[817]!=6) P_src_error(Rd.s+143,999,3);
    else {
      Ra.sl[132]=652; /* line # 652 */
      Rv1=P_usr_getpath(Rv9, Ra.s,Ra.v[205]);
    }
    Ra.sl[132]=653; /* line # 653 */
    P_exp_putint(Rv1);
    break;
    case 25:Ra.sl[132]=657; /* line # 657 */
    if (F_npa>2) Rv1=MXD_DCPLTIN_pop_intexpr(0);
    else {
      Ra.sl[132]=658; /* line # 658 */
      Rv1=0;
    }
    Ra.sl[132]=659; /* line # 659 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=660; /* line # 660 */
    MXD_DCPLTIN_pop_exp_refer(Ra.s+792);
    Ra.sl[132]=661; /* line # 661 */
    Rv1=-1;
    Ra.sl[132]=662; /* line # 662 */
    Ra.sl[132]=663; /* line # 663 */
    if (Ra.ub[817]!=6) P_src_error(Rd.s+143,999,3);
    else {
      Ra.sl[132]=664; /* line # 664 */
      Rv1=P_usr_setpath(Ra.s,Rv1, Ra.v[205]);
    }
    Ra.sl[132]=665; /* line # 665 */
    P_exp_putint(Rv1);
    break;
    case 26:Ra.sl[132]=672; /* line # 672 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(4);
    else Rv1=4;
    Ra.sl[132]=673; /* line # 673 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=674; /* line # 674 */
    if (PAS__FILE_ACCESS(Ra.s,Rv1,1073741824)) P_exp_putint(1);
    else {
      Ra.sl[132]=675; /* line # 675 */
      P_exp_putint(0);
    }
    break;
    case 27:Ra.sl[132]=679; /* line # 679 */
    if (F_npa>3) Rv0=MXD_DCPLTIN_pop_intexpr(1);
    else Rv0=0;
    Ra.sl[132]=680; /* line # 680 */
    Rv14=P_in_filemode(Rv0);
    Ra.sl[132]=681; /* line # 681 */
    if (F_npa>2) Rv1=MXD_DCPLTIN_pop_intexpr(1);
    else Rv1=0;
    Ra.sl[132]=682; /* line # 682 */
    Rv13=P_in_filemode(Rv1);
    Ra.sl[132]=683; /* line # 683 */
    MXD_DCPLTIN_pop_strexpr(Ra.s+257);
    Ra.sl[132]=684; /* line # 684 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=685; /* line # 685 */
    if (PAS__FILE_RENAME(Ra.s,Ra.s+257,Rv13, Rv14)) P_exp_putint(1);
    else {
      Ra.sl[132]=686; /* line # 686 */
      P_exp_putint(0);
    }
    break;
    case 28:Ra.sl[132]=690; /* line # 690 */
    if (F_npa>1) Rv1=MXD_DCPLTIN_pop_intexpr(1);
    else Rv1=0;
    Ra.sl[132]=691; /* line # 691 */
    MXD_DCPLTIN_pop_strexpr(Ra.s);
    Ra.sl[132]=692; /* line # 692 */
    Rv13=P_in_filemode(Rv1);
    Ra.sl[132]=693; /* line # 693 */
    if (PAS__FILE_REMOVE(Ra.s,Rv13)) P_exp_putint(1);
    else {
      Ra.sl[132]=694; /* line # 694 */
      P_exp_putint(0);
    }
    break;
    case 29:
    case 30:
    case 31:Ra.sl[132]=700; /* line # 700 */
    if (F_npa>1) Rv0=MXD_DCPLTIN_pop_intexpr(1);
    else Rv0=0;
    Ra.sl[132]=701; /* line # 701 */
    MXD_DCPLTIN_pop_exp_refer(Ra.s+792);
    Ra.sl[132]=702; /* line # 702 */
    Rv1=-1;
    Ra.sl[132]=703; /* line # 703 */
    Ra.sl[132]=704; /* line # 704 */
    if (Ra.v[199]!=NULL) {
      Ra.sl[132]=705; /* line # 705 */
      if (((UB *)Ra.v[199])[24]!=3) {
        Ra.sl[132]=706; /* line # 706 */
        P_src_error(Rd.s+143,113,2);
      }
      else {
        Ra.sl[132]=709; /* line # 709 */
        if (Rv0>0) {
          Ra.sl[132]=711; /* line # 711 */
          while (Ra.v[199]!=NULL){
            Ra.sl[132]=712; /* line # 712 */
            Rv15=Ra.v[199];
            Ra.sl[132]=714; /* line # 714 */
            if (((UB *)Rv15)[24]!=3)  break;
            Ra.sl[132]=715; /* line # 715 */
            Rv0=Rv0-1;
            Ra.sl[132]=716; /* line # 716 */
            switch (F_fnc) {
              case 29:Ra.sl[132]=717; /* line # 717 */
              Rv1=((SL *)Rv15)[9];
              break;
              case 30:Ra.sl[132]=718; /* line # 718 */
              Rv1=((SL *)Rv15)[10];
              break;
              case 31:Ra.sl[132]=719; /* line # 719 */
              Rv1=(((SL *)Rv15)[9]-((SL *)Rv15)[10])+1;
              break;
            }
            Ra.sl[132]=721; /* line # 721 */
            if (Rv0==0)  break;
            Ra.sl[132]=722; /* line # 722 */
            Ra.v[199]=((V *)Rv15)[7];
          }
          Ra.sl[132]=724; /* line # 724 */
          if (Rv0>0) P_src_error(Rd.s+143,114,2);
        }
        else {
          Ra.sl[132]=726; /* line # 726 */
          Rv1=Ra.sl[201];
        }
      }
    }
    Ra.sl[132]=728; /* line # 728 */
    P_exp_putint(Rv1);
    break;
    case 32:Ra.sl[132]=732; /* line # 732 */
    Ra.sl[132]=734; /* line # 734 */
    if (F_npa>2) Rv0=MXD_DCPLTIN_pop_intexpr(0);
    else Rv0=0;
    Ra.sl[132]=735; /* line # 735 */
    if (Rv0>0) Rv0=1;
    else {
      if (Rv0<0) Rv0=-1;
    }
    Ra.sl[132]=736; /* line # 736 */
    Rv16=P_exp_getkinds(1);
    Ra.sl[132]=738; /* line # 738 */
    switch (Rv16) {
      case 7:Ra.sl[132]=739; /* line # 739 */
      Rv3=MXD_DCPLTIN_pop_intexpr(0);
      break;
      case 8:Ra.sl[132]=740; /* line # 740 */
      Rv4=MXD_DCPLTIN_pop_fltexpr(0.000000E-01);
      break;
      case 6:Ra.sl[132]=741; /* line # 741 */
      MXD_DCPLTIN_pop_strexpr(Ra.s);
      break;
      default:Ra.sl[132]=743; /* line # 743 */
      P_src_error(Rd.s+143,113,2);
      break;
    }
    Ra.sl[132]=746; /* line # 746 */
    MXD_DCPLTIN_pop_exp_refer(Ra.s+792);
    Ra.sl[132]=747; /* line # 747 */
    Rv17=0;
    Ra.sl[132]=748; /* line # 748 */
    Rv1=0;
    Ra.sl[132]=749; /* line # 749 */
    if (Ra.v[199]!=NULL) {
      Ra.sl[132]=750; /* line # 750 */
      Rv18=Ra.v[199];
      Rv19=Ra.s+816;
      Ra.sl[132]=751; /* line # 751 */
      if (((V *)Rv18)[7]!=NULL) {
        Ra.sl[132]=753; /* line # 753 */
        Rv1=Ra.sl[202]+1;
        Ra.sl[132]=754; /* line # 754 */
        Rv20=Ra.sl[201]+Ra.sl[202];
        Ra.sl[132]=755; /* line # 755 */
        switch (((UB *)Rv19)[1]) {
          case 6:Ra.sl[132]=757; /* line # 757 */
          if (((V *)Rv19)[1]!=NULL) {
            Ra.sl[132]=758; /* line # 758 */
            Rv21=((V *)Rv19)[1];
            while (1){
              Ra.sl[132]=760; /* line # 760 */
              if (((V *)Rv21)[Rv1]==NULL) {
                Ra.sl[132]=761; /* line # 761 */
                if (Ra.ub[1]==0) Rv8=0;
                else {
                  Ra.sl[132]=762; /* line # 762 */
                  Rv8=-1;
                }
              }
              else {
                Ra.sl[132]=764; /* line # 764 */
                Rv8=PAS__MATCH_STR(((V *)Rv21)[Rv1],Ra.s);
              }
              Ra.sl[132]=765; /* line # 765 */
              switch (Rv0) {
                case -1:Ra.sl[132]=766; /* line # 766 */
                if (Rv8<0) Rv17=Rv1;
                break;
                case 0:Ra.sl[132]=767; /* line # 767 */
                if (Rv8==0) Rv17=Rv1;
                break;
                case 1:Ra.sl[132]=768; /* line # 768 */
                if (Rv8>0) Rv17=Rv1;
                break;
                default:break;
              }
              Ra.sl[132]=771; /* line # 771 */
              if (Rv17!=0)  break;
              Ra.sl[132]=772; /* line # 772 */
              Rv1=Rv1+1;
              if (Rv1>Rv20)  break;
            }
          }
          break;
          case 7:Ra.sl[132]=776; /* line # 776 */
          if (((V *)Rv19)[1]!=NULL) {
            Ra.sl[132]=777; /* line # 777 */
            Rv22=((V *)Rv19)[1];
            while (1){
              Ra.sl[132]=779; /* line # 779 */
              switch (Rv0) {
                case -1:Ra.sl[132]=780; /* line # 780 */
                if (((SL *)Rv22)[Rv1]<Rv3) Rv17=Rv1;
                break;
                case 0:Ra.sl[132]=781; /* line # 781 */
                if (((SL *)Rv22)[Rv1]==Rv3) Rv17=Rv1;
                break;
                case 1:Ra.sl[132]=782; /* line # 782 */
                if (((SL *)Rv22)[Rv1]>Rv3) Rv17=Rv1;
                break;
                default:break;
              }
              Ra.sl[132]=785; /* line # 785 */
              if (Rv17!=0)  break;
              Ra.sl[132]=786; /* line # 786 */
              Rv1=Rv1+1;
              if (Rv1>Rv20)  break;
            }
          }
          break;
          case 8:Ra.sl[132]=790; /* line # 790 */
          if (((V *)Rv19)[1]!=NULL) {
            Ra.sl[132]=791; /* line # 791 */
            Rv23=((V *)Rv19)[1];
            while (1){
              Ra.sl[132]=793; /* line # 793 */
              switch (Rv0) {
                case -1:Ra.sl[132]=794; /* line # 794 */
                if (((G *)Rv23)[Rv1]<Rv4) Rv17=Rv1;
                break;
                case 0:Ra.sl[132]=795; /* line # 795 */
                if (((G *)Rv23)[Rv1]==Rv4) Rv17=Rv1;
                break;
                case 1:Ra.sl[132]=796; /* line # 796 */
                if (((G *)Rv23)[Rv1]>Rv4) Rv17=Rv1;
                break;
                default:break;
              }
              Ra.sl[132]=799; /* line # 799 */
              if (Rv17!=0)  break;
              Ra.sl[132]=800; /* line # 800 */
              Rv1=Rv1+1;
              if (Rv1>Rv20)  break;
            }
          }
          break;
          default:break;
        }
      }
    }
    Ra.sl[132]=807; /* line # 807 */
    P_exp_putint(Rv17);
    break;
    case 33:Ra.sl[132]=812; /* line # 812 */
    switch (V_error_result) {
      case 1:Ra.sl[132]=813; /* line # 813 */
      Rv3=1;
      break;
      case 2:Ra.sl[132]=814; /* line # 814 */
      Rv3=2;
      break;
      case 3:Ra.sl[132]=815; /* line # 815 */
      Rv3=3;
      break;
      case 4:Ra.sl[132]=816; /* line # 816 */
      Rv3=4;
      break;
      default:Ra.sl[132]=818; /* line # 818 */
      Rv3=0;
      break;
    }
    Ra.sl[132]=820; /* line # 820 */
    P_exp_putint(Rv3);
    break;
    default:Ra.sl[132]=823; /* line # 823 */
    P_src_error(Rd.s+143,901,3);
    break;
  }
  PAS__curr_cntx=Ra.v[129];
}
