{ Basic Environment for Memory Block Operations }
{
	P. Wolfers

	Laboratoire de Cristrallographie
	C.N.R.S. GRENOBLE
	B.P. 166 X  38042 GRENOBLE CEDEX
				FRANCE

}


const

  max_record = 2**16;           { Define the maximum size of a memory record }

  size_strg = str_ptr"size;
  size_inte = integer"size;
  size_fltv = mxd_flt"size;

  algn_strg = size_strg;        { Must be correct for Cpas/CC environment }
  algn_inte = size_inte;
  algn_fltv = size_fltv;

  blk_max_io_buff  = 512;       { Size of a binary i/o buffer }

  max_strg  = max_record div size_strg;
  max_inte  = max_record div size_inte;
  max_fltv  = max_record div size_fltv;


type

  { Type of Block Objects Definitions }

  field_types = (
    blkt_st,                    { String pointer }
    blkt_in,                    { (32 bits) integer }
    blkt_fl                     { Mxd floatting number (32 bits) }
  );


  { Memory Record Definition }
  record_rec = record case field_types of
    blkt_st:(at:         array[0..max_mptr-1] of str_ptr);
    blkt_li:(it:         array[0..max_inte-1] of integer);
    blkt_fl:(ft:         array[0..max_fltv-1] of mxd_flt)
   end;




{************************************************************}
{ **********  RECORD Allocation and De-allocation ********** }
{************************************************************}


[ external 'PAS__NEW']
function NEW_RECORD_ALLOC( iv: integer ): $wild_pointer; external;

[ external 'PAS__DISPOSE']
procedure FREE_RECORD_ALLOC( var p: $wild_pointer ); external;






