{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*            MXD    data    Compiler    Initialization    Module              *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module DCP_COMPILER_INIT;


  %include        'MXDSRC:mxd_dcp_env';         { Load the mxd global environment }




{***********************************************}
{*** Keyword Language Tree Creation routines ***}
{***********************************************}


procedure DEFINE_KEYWORDS;
{ Define all keywords of the MXD-V4 Language.
}

type
  kwd_rec = record
              ide:         string( 16 );
              sym:               symbol
            end;

  kwd_tbt(size: integer) = array[1..size] of kwd_rec;

const
  kwd_tab = kwd_tbt[ 55,
                     [       'pragma',    pragmasy ],                                   {  1 }
                     [      'include',   includesy ], [       'chaine',    chainesy ],
                     [          'eof',      peofsy ], [          'end',       endsy ],

                     [        'macro',     macrosy ], [     'endmacro',  endmacrosy ],  {  6 }
                     [        'purge',     purgesy ], [     'macrolib',  macrolibsy ],
                     [    'macrocall', macrocallsy ], [        'error',     errorsy ],
                     [      'defined',   definedsy ], ['macro_defined',  mdefinedsy ],

                     [         'type',      typesy ], [           'is',        issy ],  { 14 }
                     [        'array',     arraysy ], [           'of',        ofsy ],
                     [       'record',    recordsy ], [          'var',       varsy ],
                     [    'mfunction', mfunctionsy ], [         'retv',   returnvsy ],

                     [           'if',        ifsy ], [         'then',      thensy ],  { 22 }
                     [         'else',      elsesy ], [         'case',      casesy ],
                     [         'when',      whensy ], [    'otherwise',     othersy ],

                     [        'begin',     beginsy ], [           'do',        dosy ],  { 28 }

                     [       'repeat',    repeatsy ], [        'until',     untilsy ],  { 30 }
                     [        'while',     whilesy ], [          'for',       forsy ],
                     [           'to',        tosy ], [       'downto',    downtosy ],

                     [     'openfile',      opensy ], [        'close',     closesy ],  { 36 }
                     [      'display',   displaysy ], [        'reply',     replysy ],
                     [         'read',      readsy ], [        'write',     writesy ],
                     [      'writeln',   writelnsy ], [     'writemsg',  writemsgsy ],

                     [         'item',      itemsy ], [    'end_block',   itmegrpsy ],  { 44 }

                     [   'item_block',    itmgrpsy ], ['lsq_directive',    lsqdirsy ],  { 46 }
                     [  'build_table',  tablebldsy ], [   'integr_tab', integrtabsy ],
                     [       'integr',  integropsy ], [         'summ',    summopsy ],
                     [    'summ_data',  summdatasy ], [       'select',    selectsy ],

                     [         'data',      datasy ], [      'clrdata',   clrdatasy ]   { 54 }

                  ];



  procedure SETKEYWORD( in_var kname: string; skw: symbol; opkw: dcp_oper := no_op );
  { Sub-Routine to create a reserved keyword identifier.
    <kname>     is the the keyword string,
    <skw>       is its related symbol value and
    <opkw>      is the related operator if required.
  }

  var
    m, i:      integer;
    p, p1, p2: keyword_ptr;
    nm:        ide_string;

  begin { SETKEYWORD }
    NEW( p );
    with p^ do
    begin
      NEW( name, kname.length );
      name^     :=       kname;
      leftp := nil; rightp := nil;
      symb.sy   :=         skw;
      symb.op   :=        opkw
    end;
    p1 := keyword_tree;
    if p1 <> nil then
    begin
      repeat
        p2 := p1 { keep the memory of the last p1 };
        with p1^ do
        begin
          m := STR_MATCH( p^.name^, name^ );
          if m > 0 then  p1 := rightp else p1 := leftp
        end;
      until p1 = nil;
      if m > 0 then p2^.rightp := p else p2^.leftp := p
    end
    else keyword_tree := p
  end SETKEYWORD;




begin { DEFINE_KEYWORDS }
  keyword_tree := nil;

  {**** Set keywords symbol operators (should be defined via a macro library) ****}

  SETKEYWORD(          'or',     lgorop,   or_op   );
  SETKEYWORD(         'xor',     lgorop,   xor_op  );
  SETKEYWORD(         'and',    lgandop,   and_op  );
  SETKEYWORD(         'not',      notop,   not_op  );
  SETKEYWORD(         'div',      mulop,   idiv_op );
  SETKEYWORD(         'mod',      mulop,   imod_op );
  SETKEYWORD(         'rem',      mulop,   irem_op );

  {**** Set keywords symbol ****}

  for ii := 1 to kwd_tab.size do
    with kwd_tab[ii] do
      SETKEYWORD( ide, sym, no_op );

end DEFINE_KEYWORDS;



{ *** Init Generic support routines *** }

type
  idt_typ = ( strty, intty, fltty, farty, numty, nulty );

var
  conv_tab: array[stm_csi..stm_nop] of ent_ptr; { Conversion just befor stm_nop }



function PTYPE( ty: idt_typ ): typ_ptr;
begin
  case ty of
    strty: PTYPE := str_typ;
    intty: PTYPE := int_typ;
    fltty: PTYPE := flt_typ;
    farty: PTYPE := fta_typ;
  otherwise
    PTYPE := nil
  end
end PTYPE;



{*************************************************}
{***    Predefined types Creation routines     ***}
{*************************************************}


function  DEFINE_TYPE( in_var nam:             string;
                              frm:          typ_forms;
                              pty:     typ_ptr := nil;
                              flg: obj_flagsty :=  [] ): typ_ptr;
{ Routine to create a type identifier :
    <nam>     is the identifier string of name,
    <frm>     is the kind (as string, integer or float, or array of ... the sames),
    <pty>     is the parent type pointer or nil,
    <flg>     is the object profil (set of special flags) or [].
}

var
  ip: ide_ptr;
  ty: typ_ptr;

begin
  sy_ident := nam;
  ip := IDE_NEW( cla_type, nil );               { Create the predefined identifier in the current lex }
  ty := TYP_NEW( frm, ip, pty );                { Create its related basic type record }
  ip^.ide_typ := ty;                            { Attach the identifier to the TDR (Type Descriptor Record) }
  ty^.typ_flg := flg;                           { Put the specified flag profil }
  DEFINE_TYPE := ty                             { Return the type pointer }
end DEFINE_TYPE;



procedure DEFINE_STD_TYPE;
{ Create all MXD predefined types }
var
  cty, sty: typ_ptr;

begin
  str_typ := DEFINE_TYPE(  'string', tfrm_str, nil, [] );       { Define the standard string type }
  int_typ := DEFINE_TYPE( 'integer', tfrm_int, nil, [] );       { Define the standard integer type }
  flt_typ := DEFINE_TYPE(   'float', tfrm_flt, nil, [] );       { Define the standard float type }

  { Create the One dimension table type (usable by interpol function) to build a table with abscisse step }
  cty := TYP_NEW( tfrm_array, nil, nil, 1 );
  with cty^ do
  begin
    typ_ael := flt_typ; typ_stp :=       1;
    typ_siz :=       2; typ_min :=       1
  end;
  fta_typ := DEFINE_TYPE( 'table_1d', tfrm_array, nil, [objf_vbnda,objf_lsqtb] );
  with fta_typ^ do
  begin
    typ_ael :=     cty; typ_stp :=       2;
    typ_siz :=       1; typ_min :=       1
  end;

  cty := DEFINE_TYPE( 'wild_number', tfrm_number, nil, [objf_wild] );
  cty := DEFINE_TYPE(  'wild_array', tfrm_warray, nil, [objf_wild] );
  cty := DEFINE_TYPE( 'wild_object',   tfrm_wild, nil, [objf_wild] );

end DEFINE_STD_TYPE;






{****************************************************}
{***    Predefined Variable Creation routines     ***}
{****************************************************}


function STR_IDE_VALUE( in_var str: string ): str_ptr;
var
  sp: str_ptr;

begin
  if str.length <> 0 then begin  NEW( sp, str.length ); sp^ := str  end
                     else sp := nil;
  STR_IDE_VALUE := sp
end STR_IDE_VALUE;



procedure DEFINE_STD_VAR;
{ Create all MXD predefined variables }
const
   sysnam_cygwin = 'windows-cygwin';
   sysnam_wnt    =        'windows';
   sysnam_unix   =           'unix';
   sysnam_vms    =        'openvms';

var
  id: ide_ptr;
  i0: integer;
  ty: typ_ptr;
  ln:  string;


  function  DEFINE_VAR( in_var nam:             string;
                               typ:            typ_ptr;
                               flg: obj_flagsty :=  [];
                               act:     integer :=   0 ): ide_ptr;
  { Routine to create an identifier :
      <nam>     is the identifier string of name,
      <typ>     is the kind (as string, integer or float, or array of ... the sames),
      <flg>     is a set of forced flag to add variable specific characteristics,
      <act>     is a specific action number when required.
  }

  var
    ip: ide_ptr;

  begin
    sy_ident := nam;
    ip := VAR_NEW( typ );            { Create the predefined identifier in the current lex }
    { For a Builtin Function set the appropriate specification value }
    ip^.ide_flg     := flg;
    ip^.idev_spcact := act;
    DEFINE_VAR := ip
  end DEFINE_VAR;



begin { DEFINE_STD_VAR }
  id := DEFINE_VAR( '$sys_mxdlib', str_typ, [objf_ronly] );     { Create the mxdlib path string identifier }
  id^.idev_val.str := STR_IDE_VALUE( sy_maclst );
  io_libpath  := id;

  id := DEFINE_VAR( '$sys_command', str_typ, [objf_ronly] );    { Create the Command identifier }
  id^.idev_val.str := STR_IDE_VALUE( argv[0]^ );

  id := DEFINE_VAR( '$sys_cmdline', str_typ, [objf_ronly] );    { Create the MXD command line string }
  with id^.idev_val do
  begin
    ln := argv[0]^;
    for  ii := 1 to argc - 1 do  ln := ln||' '||argv[ii]^;
    str := STR_IDE_VALUE( ln )
  end;

  id := DEFINE_VAR(   '$sys_nparm', int_typ );  { Create the MXD command number of arguments }
  i0 := argc - 1;
  id^.idev_val.int := i0;

  ty := TYP_NEW( tfrm_array, nil, nil );        { Create an array type descriptor for array[1..argc] of string }
  with ty^ do
  begin
    typ_ael := str_typ; typ_stp :=       1;
    typ_siz :=      i0; typ_min :=       1
  end;
  id := DEFINE_VAR(    '$sys_parm', ty );       { Create the arguments string array }
  with id^, idev_val do
  begin
    NEW( aas, i0 );
    with aas^ do
      for ii := 1 to i0 do
        val_stb[ii] := STR_IDE_VALUE( argv[ii]^ )
  end;


  { Define the System Identification Variable }
  id := DEFINE_VAR(  '$sys_system', str_typ, [objf_ronly] );    { Define $sys_system, the O.S. environment string identifier }
  with id^, idev_val do
  begin
    if BOOLEAN( sys_wnt ) then
      if sys_gcc = 1 then str := STR_IDE_VALUE( sysnam_cygwin )
                     else str := STR_IDE_VALUE( sysnam_wnt )
    else
      if BOOLEAN( sys_vms ) then str := STR_IDE_VALUE( sysnam_vms )
                            else str := STR_IDE_VALUE( sysnam_unix )
  end;

  { Define the I/O error variables }
  id := DEFINE_VAR( '$sys_ioerror', int_typ );  { Define $sys_ioerror, the last IO error number }
  id^.idev_val.int := 0; io_err := id;

  { Define the End of file variable }
  id := DEFINE_VAR(     '$sys_eof', int_typ );  { Define $sys_eof, the flag for EOF reached during a read }
  id^.idev_val.int := 0; io_eof := id;

  { Define the End of line variable }
  id := DEFINE_VAR(    '$sys_eoln', int_typ );  { Define $sys_eoln, the flag for End-of-Line reached during a read }
  id^.idev_val.int := 0; io_eoln := id;

  { Define the wait_info integer variable }
  id := DEFINE_VAR(   '$sys_winfo', int_typ );  { Define $sys_winfo }
  io_winfo := id;
  id^.idev_val.int := 0;

  { Define the Read Count variable }
  id := DEFINE_VAR( '$sys_iocount', int_typ );  { Define $sys_iocount }
  io_count := id;
  id^.idev_val.int := 0;

  id := DEFINE_VAR( '$mxd_version', str_typ, [objf_ronly] );   { Define $mxd_version, the mxd version string }
  with id^, idev_val do
  begin
    NEW( str, mxd_heading.length );
    str^ := mxd_heading
  end;

  id := DEFINE_VAR( '$$dcp_pcd_file', str_typ, [objf_spass], LSQPCD_VARBL );
  id^.idev_val.str := nil;

  id := DEFINE_VAR( '.UNDECLARED.', str_typ );  { Define the "Undeclared" Variable as a string }
  udc_ident := id;


  id := DEFINE_VAR(    '$job_name', str_typ, [objf_spass], JBNAME_VALUE );      { Define $job_title }
  job_name := id;

  id := DEFINE_VAR(   '$job_title', str_typ, [objf_spass], JBTITL_VALUE );      { Define $job_title }
  job_title := id;

  id := DEFINE_VAR('$job_save_result', str_typ, [objf_spass], JBSAVE_FNAME );   { Define $sys_title }
  job_save  := id;

end DEFINE_STD_VAR;



procedure DEFINE_STD_CONV;
const
  nent = 7;

type
  cv_entry = record
    ft, rt: idt_typ;
    stm:    ope_stm
  end;


var
  std_cv_tab: [static] array[1..nent] of cv_entry := [
      [ strty, intty, stm_csi ],  [ strty, fltty, stm_csf ],
      [ intty, intty, stm_cis ],  [ intty, fltty, stm_cif ],
      [ fltty, strty, stm_cfs ],  [ fltty, intty, stm_cfi ],
      [ fltty, intty, stm_rnd ]
    ];

  ent: ent_ptr;

begin
  for ii := 1 to nent do
  with std_cv_tab[ii] do
  begin
    NEW( ent, entk_stm );
    with ent^ do
    begin
      ent_lnk := nil;
      ent_prv := nil;
      ent_typ := PTYPE( rt );
      ent_knd := entk_stm;
      ent_pt1 := PTYPE( ft ); ent_pt2 := nil;
      ent_cv1 := nil;
      ent_cv2 := nil;
      ent_stm := stm
    end;
    conv_tab[stm] := ent
  end
end DEFINE_STD_CONV;



procedure SET_STM_DEF( var frs, lst: ent_ptr; ty1, ty2, tyr: idt_typ := nulty; cv1, cv2, stm: ope_stm := stm_nop );
var
  p: ent_ptr;

begin
  NEW( p, entk_stm );
  with p^ do
  begin
    ent_lnk := disp_tab[0].disp_ent;
    ent_prv := lst;
    ent_typ := PTYPE( tyr );
    ent_knd := entk_stm;
    ent_pt1 := PTYPE( ty1 ); ent_pt2 := PTYPE( ty2 );
    ent_cv1 := conv_tab[cv1];
    ent_cv2 := conv_tab[cv2];
    ent_stm := stm
  end;
  if frs = nil then frs := p;
  disp_tab[0].disp_ent := p;
  lst := p
end SET_STM_DEF;



procedure DEFINE_STM_OPER;
const
  ndfop = 70;

type
  ope_rec = record
    op: dcp_oper;
    t1, t2, tr: idt_typ;
    c1, c2, cr: ope_stm
  end;


[static] var
  p: ent_ptr;

  ope_itb: array[1..ndfop] of ope_rec := [
    [    not_op,  intty,  nulty,  intty, stm_nop, stm_nop, stm_not ],   {  1 - Logical not <int> -> <int> }
    [    not_op,  fltty,  nulty,  intty, stm_rnd, stm_nop, stm_not ],   {      Logical not <flt> -> <int> }
    [    sub_op,  intty,  nulty,  intty, stm_nop, stm_nop, stm_neg ],   {      Negate <int> -> <int> }
    [    sub_op,  fltty,  nulty,  fltty, stm_nop, stm_nop, stm_fng ],   {      Negate <flt> -> <flt> }

    [    pow_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_iip ],   {  5 - Power <int>**<int> -> <int> }
    [    pow_op,  fltty,  intty,  fltty, stm_nop, stm_nop, stm_fip ],   {      Power <flt>**<int> -> <flt> }
    [    pow_op,  intty,  fltty,  fltty, stm_cif, stm_nop, stm_ffp ],   {      Power <int>**<flt> -> <flt> }
    [    pow_op,  fltty,  fltty,  fltty, stm_nop, stm_nop, stm_ffp ],   {      Power <flt>**<flt> -> <flt> }

    [    mul_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_iml ],   {  9 - Multiply <int>*<int> -> <int> }
    [    mul_op,  intty,  fltty,  fltty, stm_cif, stm_nop, stm_fml ],   {      Multiply <int>*<flt> -> <flt> }
    [    mul_op,  fltty,  intty,  fltty, stm_nop, stm_cif, stm_fml ],   {      Multiply <flt>*<int> -> <flt> }
    [    mul_op,  fltty,  fltty,  fltty, stm_nop, stm_nop, stm_fml ],   {      Multiply <flt>*<flt> -> <flt> }

    [   idiv_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_idv ],   { 13 - Integer Divide <int> div <int> -> <int> }
    [   idiv_op,  intty,  fltty,  fltty, stm_nop, stm_rnd, stm_idv ],   {      Integer Divide <int> div <flt> -> <int> }
    [   idiv_op,  fltty,  intty,  fltty, stm_rnd, stm_nop, stm_idv ],   {      Integer Divide <flt> div <int> -> <int> }
    [   idiv_op,  fltty,  fltty,  fltty, stm_rnd, stm_rnd, stm_idv ],   {      Integer Divide <flt> div <flt> -> <int> }

    [   imod_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_mod ],   { 17 - Modulo <int> mod <int> -> <int> }
    [   imod_op,  intty,  fltty,  fltty, stm_nop, stm_rnd, stm_mod ],   {      Modulo <int> mod <flt> -> <int> }
    [   imod_op,  fltty,  intty,  fltty, stm_rnd, stm_nop, stm_mod ],   {      Modulo <flt> mod <int> -> <int> }
    [   imod_op,  fltty,  fltty,  fltty, stm_rnd, stm_rnd, stm_mod ],   {      Modulo <flt> mod <flt> -> <int> }

    [   irem_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_rem ],   { 21 - Remainder <int> rem <int> -> <int> }
    [   irem_op,  intty,  fltty,  fltty, stm_nop, stm_rnd, stm_rem ],   {      Remainder <int> rem <flt> -> <int> }
    [   irem_op,  fltty,  intty,  fltty, stm_rnd, stm_nop, stm_rem ],   {      Remainder <flt> rem <int> -> <int> }
    [   irem_op,  fltty,  fltty,  fltty, stm_rnd, stm_rnd, stm_rem ],   {      Remainder <flt> rem <flt> -> <int> }

    [    div_op,  intty,  intty,  fltty, stm_cif, stm_cif, stm_fdv ],   { 25 - Divide <int>/<int> -> <flt> }
    [    div_op,  intty,  fltty,  fltty, stm_cif, stm_nop, stm_fdv ],   {      Divide <int>/<flt> -> <flt> }
    [    div_op,  fltty,  intty,  fltty, stm_nop, stm_cif, stm_fdv ],   {      Divide <flt>/<int> -> <flt> }
    [    div_op,  fltty,  fltty,  fltty, stm_nop, stm_nop, stm_fdv ],   {      Divide <flt>/<flt> -> <flt> }

    [    add_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_iad ],   { 29 - Add <int>+<int> -> <int> }
    [    add_op,  intty,  fltty,  fltty, stm_cif, stm_nop, stm_fad ],   {      Add <int>+<flt> -> <flt> }
    [    add_op,  fltty,  intty,  fltty, stm_nop, stm_cif, stm_fad ],   {      Add <flt>+<int> -> <flt> }
    [    add_op,  fltty,  fltty,  fltty, stm_nop, stm_nop, stm_fad ],   {      Add <flt>+<flt> -> <flt> }

    [    sub_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_isb ],   { 33 - Substract <int>-<int> -> <int> }
    [    sub_op,  intty,  fltty,  fltty, stm_cif, stm_nop, stm_fsb ],   {      Substract <int>-<flt> -> <flt> }
    [    sub_op,  fltty,  intty,  fltty, stm_nop, stm_cif, stm_fsb ],   {      Substract <flt>-<int> -> <flt> }
    [    sub_op,  fltty,  fltty,  fltty, stm_nop, stm_nop, stm_fsb ],   {      Substract <flt>-<flt> -> <flt> }

    [ concat_op,  strty,  strty,  strty, stm_nop, stm_nop, stm_ssc ],   { 37 - Concate string <str>||<str> -> <str> }

    [     lt_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_slt ],   { 38 - Less Than <str>  < <str> -> <int> }
    [     lt_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_ilt ],   {      Less Than <int>  < <int> -> <flt> }
    [     lt_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_flt ],   {      Less Than <int>  < <flt> -> <flt> }
    [     lt_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_flt ],   {      Less Than <flt>  < <int> -> <flt> }
    [     lt_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_flt ],   {      Less Than <flt>  < <flt> -> <flt> }

    [     le_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_sle ],   { 43 - Less Than or Equal <str> <= <str> -> <int> }
    [     le_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_ile ],   {      Less Than or Equal <int> <= <int> -> <flt> }
    [     le_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_fle ],   {      Less Than or Equal <int> <= <flt> -> <flt> }
    [     le_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_fle ],   {      Less Than or Equal <flt> <= <int> -> <flt> }
    [     le_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_fle ],   {      Less Than or Equal <flt> <= <flt> -> <flt> }

    [     ge_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_sge ],   { 48 - Greater Than or Equal <str> >= <str> -> <int> }
    [     ge_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_ige ],   {      Greater Than or Equal <int> >= <int> -> <flt> }
    [     ge_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_fge ],   {      Greater Than or Equal <int> >= <flt> -> <flt> }
    [     ge_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_fge ],   {      Greater Than or Equal <flt> >= <int> -> <flt> }
    [     ge_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_fge ],   {      Greater Than or Equal <flt> >= <flt> -> <flt> }

    [     gt_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_sgt ],   { 53 - Greater Than <str> > <str> -> <int> }
    [     gt_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_igt ],   {      Greater Than <int> > <int> -> <flt> }
    [     gt_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_fgt ],   {      Greater Than <int> > <flt> -> <flt> }
    [     gt_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_fgt ],   {      Greater Than <flt> > <int> -> <flt> }
    [     gt_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_fgt ],   {      Greater Than <flt> > <flt> -> <flt> }

    [     eq_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_seq ],   { 58 - Equal <str> = <str> -> <int> }
    [     eq_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_ieq ],   {      Equal <int> = <int> -> <flt> }
    [     eq_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_feq ],   {      Equal <int> = <flt> -> <flt> }
    [     eq_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_feq ],   {      Equal <flt> = <int> -> <flt> }
    [     eq_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_feq ],   {      Equal <flt> = <flt> -> <flt> }

    [     ne_op,  strty,  strty,  intty, stm_nop, stm_nop, stm_sne ],   { 63 - Not Equal <str> <> <str> -> <int> }
    [     ne_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_ine ],   {      Not Equal <int> <> <int> -> <flt> }
    [     ne_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_fne ],   {      Not Equal <int> <> <flt> -> <flt> }
    [     ne_op,  fltty,  intty,  intty, stm_nop, stm_cif, stm_fne ],   {      Not Equal <flt> <> <int> -> <flt> }
    [     ne_op,  fltty,  fltty,  intty, stm_nop, stm_nop, stm_fne ],   {      Not Equal <flt> <> <flt> -> <flt> }

    [    and_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_and ],   { 68 - Logical and <int> and <int> -> <int> }
    [     or_op,  intty,  intty,  intty, stm_nop, stm_nop, stm_or  ],   {      Logical Inclusive or <int> or <int> -> <int> }
    [    xor_op,  intty,  fltty,  intty, stm_cif, stm_nop, stm_xor ]    {      Logical Exclusive or <int> xor <int> -> <int> }
  ];


begin { DEFINE_STM_OPER }
  for ii := 1 to ndfop do
    with ope_itb[ii], mop_tab[op] do
      SET_STM_DEF( mop_first, mop_last, t1, t2, tr, c1, c2, cr )
end DEFINE_STM_OPER;



procedure DEFINE_STM_FUNCTION;
const
  ndfnc = 21;
  ndstm = 51;

type
  fnc_rec = record
    nam: ide_string;
    nen:    integer
  end;

  stf_rec = record
    t1, t2, tr: idt_typ;
    c1, c2, cr: ope_stm
  end;


[static] var
  ide: ide_ptr;
  stm: ent_ptr;
  ien: integer;

  fnc_tab: array[1..ndfnc] of fnc_rec := [
    [   'round', 2 ], [   'trunc', 2 ],
    [     'abs', 2 ], [    'sqrt', 2 ],
    [     'cos', 2 ], [     'sin', 2 ], [    'tan', 2 ],
    [    'cosd', 2 ], [    'sind', 2 ], [   'tand', 2 ],
    [    'acos', 2 ], [    'asin', 2 ], [   'atan', 6 ],
    [   'acosd', 2 ], [   'asind', 2 ], [  'atand', 6 ],
    [     'exp', 2 ], [      'ln', 2 ], [   'tanh', 2 ],
    [  'bess_j', 4 ], ['interpol', 1 ]
  ];

  stm_itb: array[1..ndstm] of stf_rec := [
    [ fltty,  nulty,  intty, stm_nop, stm_nop,    stm_rnd ],    {  1 - ROUND( <flt> ) -> <int> }
    [ strty,  nulty,  intty, stm_csf, stm_nop,    stm_rnd ],    {      ROUND( <str> ) -> <int> }

    [ fltty,  nulty,  intty, stm_nop, stm_nop,    stm_cfi ],    {  3 - TRUNC( <flt> ) -> <int> }
    [ strty,  nulty,  intty, stm_csf, stm_nop,    stm_cfi ],    {      TRUNC( <str> ) -> <int> }

    [ intty,  nulty,  intty, stm_nop, stm_nop,   stm_iabs ],    {  5 - ABS( <int> )   -> <int> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_fabs ],    {      ABS( <flt> )   -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_sqrt ],    {  7 - SQRT( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_sqrt ],    {      SQRT( <int> )  -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_cosr ],    {  9 - COS( <flt> )   -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_cosr ],    {      COS( <int> )   -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_sinr ],    {      SIN( <flt> )   -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_sinr ],    {      SIN( <int> )   -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_tanr ],    {      TAN( <flt> )   -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_tanr ],    {      TAN( <int> )   -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_cosd ],    { 15 - COSD( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_cosd ],    {      COSD( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_sind ],    {      SIND( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_sind ],    {      SIND( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_tand ],    {      TAND( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_tand ],    {      TAND( <int> )  -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_acosr ],    { 21 - ACOS( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_acosr ],    {      ACOS( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_asinr ],    {      ASIN( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_asinr ],    {      ASIN( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_atanr ],    {      ATAN( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_atanr ],    {      ATAN( <int> )  -> <flt> }
    [ fltty,  fltty,  fltty, stm_nop, stm_nop, stm_phaser ],    {      ATAN( <flt>, <flt> ) -> <flt> }
    [ intty,  fltty,  fltty, stm_cif, stm_nop, stm_phaser ],    {      ATAN( <int>, <flt> ) -> <flt> }
    [ fltty,  intty,  fltty, stm_nop, stm_cif, stm_phaser ],    {      ATAN( <flt>, <int> ) -> <flt> }
    [ intty,  intty,  fltty, stm_cif, stm_cif, stm_phaser ],    {      ATAN( <int>, <int> ) -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_acosd ],    { 31 - ACOSD( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_acosd ],    {      ACOSD( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_asind ],    {      ASIND( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_asind ],    {      ASIND( <int> )  -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,  stm_atand ],    {      ATAND( <flt> )  -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,  stm_atand ],    {      ATAND( <int> )  -> <flt> }
    [ fltty,  fltty,  fltty, stm_nop, stm_nop, stm_phased ],    {      ATAND( <flt>, <flt> ) -> <flt> }
    [ intty,  fltty,  fltty, stm_cif, stm_nop, stm_phased ],    {      ATAND( <int>, <flt> ) -> <flt> }
    [ fltty,  intty,  fltty, stm_nop, stm_cif, stm_phased ],    {      ATAND( <flt>, <int> ) -> <flt> }
    [ intty,  intty,  fltty, stm_cif, stm_cif, stm_phased ],    {      ATAND( <int>, <int> ) -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,    stm_exp ],    { 41 - EXP( <flt> -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,    stm_exp ],    {      EXP( <int> -> <flt> }

    [ fltty,  nulty,  fltty, stm_nop, stm_nop,     stm_ln ],    { 43 - LN( <flt> -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,     stm_ln ],    {      LN( <int> -> <flt> }
    [ fltty,  nulty,  fltty, stm_nop, stm_nop,   stm_tanh ],    {      TANH( <flt> -> <flt> }
    [ intty,  nulty,  fltty, stm_cif, stm_nop,   stm_tanh ],    {      TANH( <int> -> <flt> }

    [ intty,  fltty,  fltty, stm_nop, stm_nop,  stm_bessj ],    { 47 - BESS_J( <int>, <flt> ) -> <flt> }
    [ intty,  intty,  fltty, stm_cif, stm_nop,  stm_bessj ],    {      BESS_J( <int>, <int> ) -> <flt> }
    [ fltty,  fltty,  fltty, stm_nop, stm_nop,  stm_bessjh],    {      BESS_JH( <flt>, <flt> ) -> <flt> }
    [ fltty,  intty,  fltty, stm_nop, stm_nop,  stm_bessjh],    {      BESS_JH( <flt>, <int> ) -> <flt> }

    [ farty,  fltty,  fltty, stm_nop, stm_nop,stm_interpol]     { 51   Interpol( <table>, <flt> ) -> <flt> }
  ];


begin
  ien := 0;
  for ii := 1 to ndfnc do
  with fnc_tab[ii] do
  begin
    sy_ident := nam;
    ide := IDE_NEW( cla_generic, nil );
    with ide^ do
    begin
      for jj := 1 to nen do
      begin
        ien := ien + 1;
        with stm_itb[ien] do
          SET_STM_DEF( ideg_first, ideg_last, t1, t2, tr, c1, c2, cr );
      end
    end
  end
end DEFINE_STM_FUNCTION;



procedure DEFINE_BLT_FUNCTION;
{ Define all Standard objects :
  The basic types : STRING, INTEGER, FLOAT,
  All predefined identifier (for Least-Squares and System),
  All standard functions.
}

const
  n_std_fnc =  34;

type
   std_fty = array[1..n_std_fnc] of record
     std:      std_fnc;
     nam:   ide_string;
     typ:      idt_typ;
     nfp:        sbyte
   end;

const

  std_ftab = std_fty[ [     std_string,       'instring', strty,  1], {  1 }
                      [     std_substr,         'substr', strty,  1],
                      [     std_nindex,          'index', intty,  2],
                      [    std_slength,         'length', intty,  1],
                      [    std_setcase,       'set_case', strty,  2], {  5 }
                      [    std_checkch,     'check_char', intty,  2],
                      [   std_checknst, 'numeric_string', intty,  1],
                      [   std_selement,        'element', strty,  1],
                      [  std_rmcomment,    'sup_comment', strty,  1],
                      [ std_id_replace,     'substitute', strty,  2], { 10 }
                      [  std_id_insert,   'insert_ident', intty,  1],
                      [  std_id_remove,   'remove_ident', intty,  1],
                      [    std_filespc,       'file_spc', strty,  1],
                      [       std_time,       'sys_time', strty,  0],
                      [       std_date,       'sys_date', strty,  0], { 15 }
                      [      std_spawn,      'sys_spawn', intty,  1],
                      [        std_run,   'sys_run_proc', intty,  1],
                      [       std_exec,'sys_create_proc', intty,  1],
                      [       std_wait,  'sys_wait_proc', intty,  1],
                      [       std_exit,           'exit', intty,  0], { 20 }
                      [      std_dfdir,    'default_dir', strty,  0],
                      [      std_chdir,     'change_dir', intty,  1],
                      [     std_getenv,     'sys_getenv', strty,  1],
                      [     std_setenv,     'sys_setenv', intty,  1],
                      [    std_getpath,    'sys_getpath', intty,  2], { 25 }
                      [    std_setpath,    'sys_setpath', intty,  2],
                      [    std_f_exist,     'file_exist', intty,  1],
                      [   std_f_rename,    'file_rename', intty,  2],
                      [   std_f_delete,    'file_delete', intty,  1],
                      [      std_ardim,      'array_dim', intty,  1], { 30 }
                      [      std_arlow,       'array_lb', intty,  1],
                      [     std_arhigh,       'array_hb', intty,  1],
                      [   std_arsearch,   'array_search', intty,  2], { 33 }
                      [   std_errcount,    'error_count', intty,  0]
                    ];


  procedure DEFINE_FNC(        fnc:  std_fnc := std_noop;
                        in_var nam:               string;
                               typ:              idt_typ;
                               npa:  integer :=        0 );
  { Sub-Routine to create an identifier :
      <fnc>     is the internal function code (or std_noop for variables or types),
      <nam>     is the identifier string of name,
      <typ>     is the typ of result (as string, integer or float, or array of ... the sames),
      <npa>     is the minimum number of parameters of the function, or -1 to define a type identifier.
  }
  var
    fpf, fpl,
    idp, idt: ide_ptr;
    ent:      ent_ptr;

  begin
    NEW( ent, entk_std );
    with ent^ do
    begin
      ent_lnk :=          nil;
      ent_prv :=          nil;
      ent_typ := PTYPE( typ );
      ent_knd :=     entk_std;
      ent_npa :=          npa;
      ent_dsp :=            0;
      ent_ope :=        no_op;
      ent_frl :=          nil;
      ent_std :=          fnc
    end;

    sy_ident := nam;
    idp := IDE_NEW( cla_generic, nil );         { Create the predefined identifier in the current lex }
    with idp^ do
    begin  ideg_first := ent; ideg_last  := ent  end
  end DEFINE_FNC;


begin { DEFINE_BLT_FUNCTION }
  { *** Define all builtin functions *** }

  for ii := 1 to n_std_fnc do
    with std_ftab[ii] do DEFINE_FNC( std, nam, typ, nfp );

end DEFINE_BLT_FUNCTION;



[global]
procedure DCP_INIT;
var
  fnd:                 boolean;
  str, sdat, stim:      string;
  isl:                 integer;

begin { DCP_INIT }
  data_mode   := false;
  fatal_error := false;
  DATE( sdat ); TIME( stim );
  WRITEV( sy_string, 'MXD-Data-Compiler ', mxd_heading, ', Run the ', sdat, ' at time ', stim, '.' );
  LST_G_INIT( mxd_deflst, sy_string, ierr );

  if ierr = 0 then
  begin
    { Look for the initial MXD Standard Environment file in the MXD Search Path }
    SEARCH_FILE( mxd_search_path, mxd_setenvf, 4 { Read Access }, sy_string, fnd );
    if fnd then
    begin                                       { When the file is founded }
      isl := INDEX( sy_string, '/', -1 );
      if isl = 0 then sy_maclst.length := 0
                 else sy_maclst := SUBSTR( sy_string, 1, isl ); { Get the path directory to use for the other MXD std. files }
      ERR_INIT( sy_maclst||mxd_dcperrf );       { Initialize the ERR sub-system }
      SRC_INIT( mxd_prompt, sy_string );        { Initialize the SRC sub-system }
      if src_control = nil then
      begin
        WRITELN( ' *** ', task_name, ' ERROR : Cannot open the start file "', sy_string, '".' );
        PASCAL_EXIT( 4 )                        { Stop on this error }
      end
    end
    else
    begin
      WRITELN( ' *** ', task_name, ' ERROR : Cannot find the start file "', mxd_setenvf, '".' );
      PASCAL_EXIT( 4 )                          { Stop on this error }
    end
  end
  else
  begin
    WRITELN( ' *** ', task_name, ' FATAL ERROR : Cannot open the default Listing File "', mxd_deflst, '" code ', ierr:0 );
    PASCAL_EXIT( 4 )
  end;

  { Here the source file sy_string is opened and sy_maclst is the MXDLIB directory specification }
  src_control^.src_level := 0;                  { Force the standard command level to have the level number 0 (not 1, the cpas_b__src default) }

  for op := dcp_oper"first to dcp_oper"last do  { Init the operator definition table }
  with mop_tab[op] do
  begin  mop_first := nil; mop_last := nil  end;

  curr_disp := -1;                              { Initialize the display to empty }
  curr_lex  :=  0;
  DISPLAY_NEW;                                  { Create the predefined display level (display level 0) }

  DEFINE_KEYWORDS;                              { Define all the standard keywords }

  DEFINE_STD_TYPE;                              { Define all predefined types }
  DEFINE_STD_VAR;                               { Define all predefined variable }
  DEFINE_STD_CONV;                              { Define all implicites conversions }
  DEFINE_STM_OPER;                              { Define all statement operators }
  DEFINE_STM_FUNCTION;                          { Define all statement functions }
  DEFINE_BLT_FUNCTION;                          { Define all builtin functions }

  sy_ident := 'retv';                           { Define the MFUNCTION return variable }
  ret_ide := IDE_NEW( cla_formal, nil );
  ret_ide^.ide_flg := [objf_retva];

  curr_lex  :=  1;                              { Set base lex for the user }
  DISPLAY_NEW;                                  { Pass to the First user lex display level }

  with exp_null, exp_val do                     { Define the null expression record }
  begin
    exp_ref     :=          nil;
    exp_typ     :=          nil;
    exp_esz     :=            1;
    exp_shf     :=            0;
    exp_flg     :=           [];
    val_cte     :=        false;
    val_frm     :=    vfrm_null
  end;
  exp_res := exp_null;                          { Init the expression registers }
  exp_rs0 := exp_null;
  exp_rs1 := exp_null;

  { Init the IO file lun status }
  for ii := 1 to max_usrlun do
    sym_iof[ii].iocnt_mode := iocnt_close;

  sy_ch        :=     ' ';                      { Initialize the NEXTCH process (sub-routine of INSYMBOL) }
  sy_maclst    :=      '';                      { Init the Macro source to empty state ... }
  sy_nomacrflg :=   false;                      { ... and the run state in file command (no macro running }
  sy_noexec    :=   false;
  sy_sym.sy    := nothing                       { No readden symbol }
end DCP_INIT;


end DCP_COMPILER_INIT.

