#
#       Makefile for MXD-DCP
#
#include $(PAS_DIR)/system.make
#

PAS	=	pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIBS	=	-lcpas -lm
LIB	=

C_FLAGS = -g -c

P_FLAGS = -t+

L_FLAGS = -g

SRCP =\
	$(Src)/mxd_dcp_main.pas \
	$(Src)/mxd_dcp_rtl.pas \
	$(Src)/mxd_dcp_basinit.pas \
	$(Src)/mxd_dcp_insymb.pas \
	$(Src)/mxd_dcp_expr.pas \
	$(Src)/mxd_dcp_item.pas \
	$(Src)/mxd_dcp_builtin.pas \
	$(Src)/mxd_dcp_lsq.pas \
	$(Src)/mxd_dcp_data.pas \
	$(Src)/mxd_dcp_comp.pas \
	$(Src)/mxd_bda.pas \
	$(Src)/mxd_math.pas \
	$(Src)/mxd_bda_check

SPCS =\
	$(Src)/mxd_dcp_main.c \
	$(Src)/mxd_dcp_rtl.c \
	$(Src)/mxd_dcp_basinit.c \
	$(Src)/mxd_dcp_insymb.c \
	$(Src)/mxd_dcp_expr.c \
	$(Src)/mxd_dcp_item.c \
	$(Src)/mxd_dcp_builtin.c \
	$(Src)/mxd_dcp_lsq.c \
	$(Src)/mxd_dcp_data.c \
	$(Src)/mxd_dcp_comp.c \
	$(Src)/mxd_bda.c \
	$(Src)/mxd_math.c \
	$(Src)/mxd_bda_check.c

Obj =\
	$(oDir)/mxd_dcp_main.o \
	$(oDir)/mxd_dcp_rtl.o \
	$(oDir)/mxd_dcp_basinit.o \
	$(oDir)/mxd_dcp_insymb.o \
	$(oDir)/mxd_dcp_expr.o \
	$(oDir)/mxd_dcp_item.o \
	$(oDir)/mxd_dcp_builtin.o \
	$(oDir)/mxd_dcp_lsq.o \
	$(oDir)/mxd_dcp_data.o \
	$(oDir)/mxd_dcp_comp.o \
	$(oDir)/mxd_bda.o \
	$(oDir)/mxd_math.o

Objsp =\
	$(oDir)/mxd_bda.o \
	$(oDir)/mxd_bda_check.o


#

all:    $(Bin)/mxd_dcp $(Bin)/mxd_bda_check

clean:
	rm -f $(SPCS) $(Obj) $(Bin)/mxd_dcp $(Bin)/mxd_bda_check


$(Bin)/mxd_dcp: $(Obj)
	$(CC) $(L_FLAGS) $(Obj) $(LIB) $(LIBS) -o $@


$(oDir)/mxd_dcp_main.o: $(Src)/mxd_dcp_main.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_main
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_main.c -o $@

$(oDir)/mxd_dcp_rtl.o: $(Src)/mxd_dcp_rtl.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_rtl
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_rtl.c -o $@

$(oDir)/mxd_dcp_basinit.o: $(Src)/mxd_dcp_basinit.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_basinit
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_basinit.c -o $@

$(oDir)/mxd_dcp_insymb.o: $(Src)/mxd_dcp_insymb.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_insymb
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_insymb.c -o $@

$(oDir)/mxd_dcp_builtin.o: $(Src)/mxd_dcp_builtin.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_builtin
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_builtin.c -o $@

$(oDir)/mxd_dcp_expr.o: $(Src)/mxd_dcp_expr.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_expr
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_expr.c -o $@

$(oDir)/mxd_dcp_item.o: $(Src)/mxd_dcp_item.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_item
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_item.c -o $@

$(oDir)/mxd_dcp_lsq.o: $(Src)/mxd_dcp_lsq.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_lsq
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_lsq.c -o $@

$(oDir)/mxd_dcp_data.o: $(Src)/mxd_dcp_data.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_data
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_data.c -o $@

$(oDir)/mxd_dcp_comp.o: $(Src)/mxd_dcp_comp.pas $(Src)/mxd_dcp_env.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_dcp_comp
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_dcp_comp.c -o $@

$(oDir)/mxd_bda.o: $(Src)/mxd_bda.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_bda
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_bda.c -o $@

$(oDir)/mxd_math.o: $(Src)/mxd_math.pas $(Src)/mxd_env.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_math
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_math.c -o $@


$(Bin)/mxd_bda_check: $(Objsp)
	$(CC) $(L_FLAGS) $(Objsp) $(LIB) $(LIBS) -o $@


$(oDir)/mxd_bda_check.o: $(Src)/mxd_bda_check.pas $(Src)/mxd_env.pas $(Src)/mxd_tree_codes.pas
	$(PAS) $(P_FLAGS) $(Src)/mxd_bda_check
	$(CC) $(C_FLAGS) $(INC) $(Src)/mxd_bda_check.c -o $@

#
