{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*             MXD  Crystallographic  Object  Tree  Initializer                *
*                                                                             *
*                                                                             *
*******************************************************************************


}


{****************     CPAS  version    *****************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_CRYST_RTL;


  %include 'MXDSRC:mxd_tree_env';       { Get all tree definitions }




[global]
function GVAL( p: ptr ): mxd_flt;
begin
  if p = nil then GVAL := 0.0
             else GVAL := p^.par_actval
end GVAL;



procedure INIT_VDERV( var vd: tbty_vder; val, d1, d2, d3, d4, d5, d6: mxd_flt := 0.0 );
{ Procedure to Load a tbty_vder object;
}
begin
  vd[0] := val;
  vd[1] := d1; vd[2] := d2; vd[3] := d3;
  vd[4] := d4; vd[5] := d5; vd[6] := d6
end INIT_VDERV;



procedure SET_VDERV( var exp: tbty_vder; var base: array[sz: integer] of tbty_vder;
                         val, d1, d2, d3, d4, d5, d6, d7, d8, d9: mxd_flt := 0.0 );
{ Procedure to fill a tbty_vder by computing the derivatives form more partial ones.
  The object base must be fill with the partial derivatives of base object, as
  d(base)/dA, d(base)/dB, d(base)/dC, d(base)/dALPHA, d(base)/dBETA, d(base)/dGAMMA.
  The arguments d1 to d9 must be the partial derivatives d(exp)/d(base[i]).
  The resulting is exp[0] = val, and exp(i] = d(exp)/dA, d(exp)/dB, d(exp)/dC,
  d(exp)/dALPHA, d(exp)/dBETA, d(exp)/dGAMMA.
}
var
  tmp: array[1..9] of mxd_flt;
  vs: mxd_flt;

begin
  tmp[1] := d1; tmp[2] := d2; tmp[3] := d3;
  tmp[4] := d4; tmp[5] := d5; tmp[6] := d6;
  tmp[7] := d7; tmp[8] := d8; tmp[9] := d9;
  exp[0] := val;
  for i := 1 to 6 do
  begin
    vs := 0.0;
    { We apply d(exp)/d(q[i]) = summ on j of d(exp)/d(p[j])*d(p[j])/d(q[i]) }
    for j := 1 to sz do  vs := vs + tmp[j]*base[j,i];
    exp[i] := vs
  end
end SET_VDERV;



procedure SET_MTENS_VALUES( var mt, uc: tbty_parm );
{ Compute the metric tensor mt and these related derivatives from
  the unit cell uc.
  The normal metric tensor should be :

        aa*aa, aa*bb*ga, aa*cc*be,
     bb*aa*ga,    bb*bb, bb*cc*al,
     cc*aa*be, cc*bb*al,    cc*cc

  But using then symmetry of the tensor we can store it :
  mt[1] =        aa*aa, mt[6] = 2.0*aa*bb*ga, mt[5] = 2.0*aa*cc*be,
                        mt[2] =        bb*bb, mt[4] = 2.0*bb*cc*al,
                                              mt[3] =        cc*cc

  The 2.0 factor is put to optimize the sin(THETA)/LAMBDA computing :

   sin(THETA)/LAMBDA = mt[1]*h*h + mt[2]*k*k + mt[3]*k*k +
                       mt[4]*k*l + mt[5]*l*h + mt[6]*h*k

}
var
  aa, bb, cc, al, be, ga: mxd_flt;

begin
  aa := uc[1,0]; bb := uc[2,0]; cc := uc[3,0]; { Get the cell vector lengths }
  al := uc[4,0]; be := uc[5,0]; ga := uc[6,0]; { Get the angle cosinus ]

  { The metric tensor are symetric then the elements 4,5,6 are multiply by 2 to simplify the 1/2d ($sithsl) computing }

                          {    Value,   d/d(aa),   d/d(bb),   d/d(cc),   d/d(al),   d/d(be),   d/d(ga) }
  SET_VDERV( mt[1], uc, SQR( aa ),       2.0*aa );
  SET_VDERV( mt[2], uc, SQR( bb ),             ,    2.0*bb );
  SET_VDERV( mt[3], uc, SQR( cc ),             ,          ,    2.0*cc );
  SET_VDERV( mt[4], uc, 2.0*bb*cc*al,          , 2.0*cc*al, 2.0*bb*al, 2.0*bb*cc );
  SET_VDERV( mt[5], uc, 2.0*cc*aa*be, 2.0*cc*be,          , 2.0*aa*be,          , 2.0*aa*bb );
  SET_VDERV( mt[6], uc, 2.0*aa*bb*ga, 2.0*bb*ga, 2.0*aa*ga,          ,          ,          , 2.0*aa*bb )
end SET_MTENS_VALUES;



[global]
procedure CRYST_MULMAT_VDERV( var mat: tbty_tmat; pax, pay, paz: ptr; var vec: tbty_vect );
{ Compute the product  <vec> := <mat>*(pax^,pay^,paz^).

  mat               is the matrix of with related cell parameter partial derivatives,
  pax, pay, paz     are the LSQ_PARM (or nil) vector parameter to transform by <mat>*<vec>,
  vec               is the resulting vector with the related partial derivatives.
}
var
  vpx, vpy, vpz: mxd_flt;
  j:             integer;

begin
  vpx := GVAL( pax ); vpy := GVAL( pay ); vpz := GVAL( paz );
  j := 1;
  for i := 1 to 3 do
  begin
    vec[i,0] := mat[j+0,0]*vpx + mat[j+1,0]*vpy + mat[j+2,0]*vpz;
    for d := 1 to 6 do
      vec[i,d] := vpx*mat[j+0,d] + vpy*mat[j+1,d] + vpz*mat[j+2,d];
    j := j + 3
  end
end CRYST_MULMAT_VDERV;



[global]
procedure CRYST_PHASE_COMPUTE( p: ptr );
{ Perform all phase node related computings :
    - Evaluate the Direct and reciprocal unit cell from the User data,
      and the related metric tensors.
    - Compute the transformation matrixs to convert the Direct and
      Reciprocal lattice coordinates to the normalized coordinates
      in a suitable orthogonal reference system (units are A and A^-1.

    For all these quantities the partial derivation from the user data
    are also computed. Each quantity is stored in a <tbty_vder> array
    where the elements index 0 to 6 are respectively :
    [0] the value, and [1..6] the derivations d/dA, d/dB, d/dC, d/dALPHA,
    d/dBETA and d/dGAMMA.

    A <tbty_vderv> is used for each quantites. To define tensor, matrix
    or vector we use "array[1..sz] of tbty_vderv" as :

      tbty_valu = array[1..1] of tbty_vder   for any scalar,

      tbty_parm = array[1..6] of tbty_vder   for unit cells and symmetric
                                             tensors,

      tbty_tmat = array[1..9] of tbty_vder   for 3x3 matrix.


  Note :
    1/ ALPHA, BETA and GAMMA are note the unit cell angles but there related
    Cosinus.
    2/ A, B, C, ALPHA, BETA and GAMMA are related to the user specified
    unit cell that can be the direct or reciprocal unit cell.


}
const
  mdnam = 'CELB';

var
  m11, m12, m13, m22, m23, m33,
  n11, n12, n13, n22, n23, n33,
  aa,  bb,  cc,  al,  be,  ga,
  raa, ral,
  abc, rac, fac, sa2, sb2, sg2,
  sal, sbe, sga, vol:          mxd_flt;
  nd:                              ptr;
  tbv:          array[1..6] of mxd_flt;
  tbf:          array[1..6] of boolean;
  brcl, bini:                  boolean;


  procedure UNIT_CELL_COMPUTE( var gc, dc: tbty_parm; var gv, dv: tbty_valu );
  { <guc> and <gvol> are corresponding to the specified unit cell and related volume,
    and <duc> and <dvol> to there dual quantities
  }
  var
    aa,  bb,  cc,  al,  be,  ga,
    raa, rbb, rcc, ral, rbe, rga,
    fca, fcb, fcc, rvl:                mxd_flt;

  begin
    { Install the specified Unit cell parameters }
    for i := 1 to 6 do
    begin
      gc[i,0] := tbv[i];
      for j := 1 to 6 do
        if i = j then gc[i,j] := 1.0
                 else gc[i,j] := 0.0
    end;
    aa := tbv[1]; bb := tbv[2]; cc := tbv[3];
    al := tbv[4]; be := tbv[5]; ga := tbv[6];

    { Initialize the specified volume and its partial derivate }
    INIT_VDERV( gv[1], vol, vol/aa, vol/bb, vol/cc, fac*(be*ga - al), fac*(ga*al - be), fac*(al*be - ga) );

    { Compute the dual vomume (=1/vol) and its partial derivate }
    rvl := 1.0/vol;
    SET_VDERV( dv[1], gv, rvl, - SQR( rvl ) );

    { Compute the dual unit cell }
    ral := (be*ga - al)/(sbe*sga);
    rbe := (ga*al - be)/(sga*sal);
    rga := (al*be - ga)/(sal*sbe);
    fca := bb*cc*sal; fcb := cc*aa*sbe; fcc := aa*bb*sga;
    raa := fca*rvl; rbb := fcb*rvl; rcc := fcc*rvl;

    INIT_VDERV( dc[1], raa,                                     { raa value }
                       fca*dv[1,1],                             { d(raa)/d(aa) }
                       cc*sal*(rvl + bb*dv[1,2]),               { d(raa)/d(bb) }
                       bb*sal*(rvl + cc*dv[1,3]),               { d(raa)/d(cc) }
                       bb*cc*(sal*dv[1,4] - al*rvl/sal),        { d(raa)/d(al) }
                       fca*dv[1,5],                             { d(raa)/ d(be) }
                       fca*dv[1,6] );                           { d(raa)/ d(ga) }

    INIT_VDERV( dc[2], rbb,                                     { rbb value }
                       cc*sbe*(rvl + aa*dv[1,1]),               { d(rbb)/d(aa) }
                       fcb*dv[1,2],                             { d(rbb)/d(bb) }
                       aa*sbe*(rvl + cc*dv[1,3]),               { d(rbb)/d(cc) }
                       fcb*dv[1,4],                             { d(rbb)/d(al) }
                       cc*aa*(sbe*dv[1,5] - be*rvl/sbe),        { d(rbb)/d(be) }
                       fcb*dv[1,6] );                           { d(rbb)/d(ga) }

    INIT_VDERV( dc[3], rcc,                                     { rcc value }
                       bb*sga*(rvl + aa*dv[1,1]),               { d(rcc)/d(aa) }
                       aa*sga*(rvl + bb*dv[1,2]),               { d(rcc)/d(bb) }
                       fcc*dv[1,3],                             { d(rcc)/d(cc) }
                       fcc*dv[1,4],                             { d(rcc)/d(al) }
                       fcb*dv[1,5],                             { d(rcc)/d(be) }
                       aa*bb*(sga*dv[1,6] - ga*rvl/sga) );      { d(rcc)/d(ga) }

    fca := 1.0/(sbe*sga);
    INIT_VDERV( dc[4], ral, 0.0, 0.0, 0.0,                      { ral value, d(ral)/d(aa), d(ral)/d(bb), d(ral)/d(cc) }
                       - fca,                                   { d(ral)/d(al) }
                       ga*fca + ral*be/SQR( sbe ),              { d(ral)/d(be) }
                       be*fca + ral*ga/SQR( sga )               { d(ral)/d(ga) }
              );

    fcb := 1.0/(sga*sal);
    INIT_VDERV( dc[5], rbe, 0.0, 0.0, 0.0,                      { rbe value, d(rbe)/d(aa), d(rbe)/d(bb), d(rbe)/d(cc) }
                       ga*fcb + rbe*al/SQR( sal ),              { d(ral)/d(al) }
                       - fcb,                                   { d(rbe)/d(be) }
                       al*fcb + rbe*ga/SQR( sga )               { d(ral)/d(ga) }
              );

    fcc := 1.0/(sal*sbe);
    INIT_VDERV( dc[5], rga, 0.0, 0.0, 0.0,                      { rga value, d(rga)/d(aa), d(rga)/d(bb), d(rga)/d(cc) }
                       be*fcc + rga*al/SQR( sal ),              { d(rga)/d(al) }
                       al*fcc + rga*be/SQR( sbe ),              { d(rga)/d(be) }
                       - fcc                                    { d(rga)/d(ga) }
              )
  end UNIT_CELL_COMPUTE;



  procedure PHASE_INIT( p: ptr );
  var
    bfix: boolean;

  begin
    with p^, pha_cell do
    begin
      bfix := true;                     { Assume fix unit cell until shown otherwise }
      for i := 1 to 6 do                { Loop on all Unit Cell parameters }
      begin
        if pha_par[i] = nil then        { If the parameter is empty, force the 0.0 value else ... }
        begin  tbf[i] := true; tbv[i] := 0.0  end
        else
          with pha_par[i]^ do           { ... we get the parameter init (constant) flag to set as constant or variable }
          begin
            tbf[i] := (par_categ = prmc_init);
            if not tbf[i] then begin  bfix := false; par_actval := FO_VALUE( par_expres )  end;

            if i > 3 then               { For the cell angles - we force the unit cell angle to be cosinus }
              if par_actval > 1.0 then  { It is not the Cosinus of an angle }
              begin
                par_actval := COS( in_rd*par_actval );  { Get the COSINUS Value of ANGLE }
                NEW( nd, op_cosd );     { We insert the COSD operator node in the LSQ_PARM expression tree }
                nd^.nod_typ  := op_cosd;
                nd^.nod_unad := par_expres;
                par_expres := nd
              end;

            tbv[i] := par_actval        { We keep the unit cell description vector in the local table }
          end
      end;
      cell_flags := cell_flags - [celf_toinit];
      if bfix then cell_flags := cell_flags + [celf_fixed];

WRITELN( ' The phase "', itm_name^, '" with the cell parameters' );
for ii := 1 to 6 do
begin
  WRITE( ' ', tbv[ii]:8:4, ' ' );
  if tbf[ii] then WRITE( 'F,' )
             else WRITE( 'V,' )
end;
if bfix then WRITELN( ' is fixed.' )
        else WRITELN( ' will be fitted.' );

    end
  end PHASE_INIT;


begin { PHASE_COMPUTE }
  with p^, pha_cell do
  begin
    if celf_toinit in cell_flags then
    begin
      PHASE_INIT( p ); bini := true     { For the Phase init mode }
    end
    else
    begin
      for i := 1 to 6 do
      begin
        if pha_par[i] = nil then        { If the parameter is empty, force the 0.0 value else ... }
        begin  tbf[i] := true; tbv[i] := 0.0  end
        else
        begin                           { Else get the value and variablle flag }
          tbf[i] := (par_categ = prmc_init);
          tbv[i] := pha_par[i]^.par_actval
        end
      end;
      bini := false
    end;

    { We compute the volume of the specified unit cell }
    sa2 := SQR( tbv[4] ); sb2 := SQR( tbv[5] ); sg2 := SQR( tbv[6] );
    abc := tbv[1]*tbv[2]*tbv[3];
    rac := SQRT( 1.0 + 2.0*tbv[4]*tbv[5]*tbv[6] - sa2 - sb2 - sg2 );{ Warning : sal = al**2, ... }
    vol := abc*rac;

    { Send a message and stop on Null volume error }
    if vol < 1.0e-9 then EXEC_ERROR( mdnam, 21, e_fatal, itm_name^ );

    if celf_rhomb in cell_flags then
      { Signal an error on not Rhomboedral unit cell when the work ref. is R suitable choice }
      if (ABS( 1.0 - tbv[2]/tbv[1] ) > 1e-6) or (ABS( 1.0 - tbv[3]/tbv[1] ) > 1e-6) or
         (ABS( tbv[4] - tbv[5] ) > 1e-6) or (ABS( tbv[4] - tbv[6] ) > 1e-6) then
            EXEC_ERROR( mdnam, 22, e_fatal, itm_name^ );

    sal := SQRT( 1.0 - sa2 ); sbe := SQRT( 1.0 - sb2 ); sga := SQRT( 1.0 - sg2 );
    { Now sal, sbe and sga are the SINUS of angles }

    if vol >= 1.0 then { The specified unit cell is the Direct Unit Cell }
      UNIT_CELL_COMPUTE( cell_duc, cell_ruc, cell_dvol, cell_rvol )
    else
    begin { The specified unit cell is the Reciprocal Unit Cell }
      cell_flags := cell_flags + [celf_recip]; brcl := true;
      UNIT_CELL_COMPUTE( cell_ruc, cell_duc, cell_rvol, cell_dvol );
      vol := 1.0/vol
    end;

    UPDATE_VIRTVAR( cell_duc,  virt_pha$daa );
    UPDATE_VIRTVAR( cell_dvol, virt_pha$dvol );
    UPDATE_VIRTVAR( cell_ruc,  virt_pha$raa );
    UPDATE_VIRTVAR( cell_rvol, virt_pha$rvol );

    { We compute the metric tensors }
    SET_MTENS_VALUES( cell_dmt, cell_duc );
    SET_MTENS_VALUES( cell_rmt, cell_ruc );

    UPDATE_VIRTVAR( cell_dmt,  virt_pha$dtaa );
    UPDATE_VIRTVAR( cell_rmt,  virt_pha$rtaa );

WRITELN;
WRITE( ' Direct     CELL : ' );
for i := 1 to 6 do WRITE( ' ', cell_duc[i,0]:14:6 ); WRITELN( ' V = ', cell_dvol[1,0]:14:6 );
WRITE( ' Reciprocal CELL : ' );
for i := 1 to 6 do WRITE( ' ', cell_ruc[i,0]:14:8 ); WRITELN( ' V = ', cell_rvol[1,0]:14:8 );

WRITELN;
WRITE( ' Direct   Metric   Tensor : ' );
for i := 1 to 6 do WRITE( ' ', cell_dmt[i,0]:14:4 ); WRITELN;
WRITE( ' Reciprocal Metric Tensor : ' );
for i := 1 to 6 do WRITE( ' ', cell_rmt[i,0]:14:4 ); WRITELN;

    { Load the direct unit cell }
    aa := cell_duc[1,0]; bb := cell_duc[2,0]; cc := cell_duc[3,0];
    al := cell_duc[4,0]; be := cell_duc[5,0]; ga := cell_duc[6,0];

    if celf_rhomb in cell_flags then
    begin { Rhomboedral reference choice }
      abc := SQRT( 1.0 - al ); rac := SQRT( 1.0 + 2.0*al );
      sbe := (rac + 2.0*abc)/3.0;
      sga := (rac - abc)/3.0;
      sb2 := (1.0/rac - 1.0/abc)/3.0;   { d(sbe)/d(al) with  al = sal }
      sg2 := (1.0/rac + 0.5/abc)/3.0;         { d(sga)/d(al) }

      {                                   Value,  d/d(aa),  d/d(al) }
      SET_VDERV( cell_dcmt[1], cell_duc, aa*sbe,   sbe,,,  aa*sb2 ); { m[1,1] }
      SET_VDERV( cell_dcmt[2], cell_duc, aa*sga,   sga,,,  aa*sg2 ); { m[1,2] }
      cell_dcmt[3] := cell_dcmt[2]; { m[1,3] }
      cell_dcmt[4] := cell_dcmt[2]; { m[2,1] }
      cell_dcmt[5] := cell_dcmt[1]; { m[2,2] }
      cell_dcmt[6] := cell_dcmt[2]; { m[2,3] }
      cell_dcmt[7] := cell_dcmt[2]; { m[3,1] }
      cell_dcmt[8] := cell_dcmt[2]; { m[3,2] }
      cell_dcmt[9] := cell_dcmt[1]; { m[3,3] }

      { Now we evaluate the reciprocal here,
        - it is most efficient with the matrix symmetry.
      }
      raa := cell_ruc[1,0];
      ral := cell_ruc[4,0];
      abc := SQRT( 1.0 - ral ); rac := SQRT( 1.0 + 2.0*ral );
      sbe := (rac + 2.0*abc)/3.0;
      sga := (rac - abc)/3.0;
      sb2 := (1.0/rac - 1.0/abc)/3.0;   { d(sbe)/d(al) with  al = sal }
      sg2 := (1.0/rac + 0.5/abc)/3.0;         { d(sga)/d(al) }

      {                                   Value,  d/d(aa),  d/d(al) }
      SET_VDERV( cell_rcmt[1], cell_ruc, aa*sbe,   sbe,,,  aa*sb2 ); { n[1,1] }
      SET_VDERV( cell_rcmt[2], cell_ruc, aa*sga,   sga,,,  aa*sg2 ); { n[1,2] }
      cell_rcmt[3] := cell_rcmt[2]; { n[1,3] }
      cell_rcmt[4] := cell_rcmt[2]; { n[2,1] }
      cell_rcmt[5] := cell_rcmt[1]; { n[2,2] }
      cell_rcmt[6] := cell_rcmt[2]; { n[2,3] }
      cell_rcmt[7] := cell_rcmt[2]; { n[3,1] }
      cell_rcmt[8] := cell_rcmt[2]; { n[3,2] }
      cell_rcmt[9] := cell_rcmt[1]  { n[3,3] }
    end
    else
    begin { Not Rhomboedral (standard) reference choice }
      sga := SQRT( 1.0 - SQR( ga ) );
      sal := (al - be*ga)/sga;
      abc := - be*(1.0 + SQR( ga/sga ))/sga;    { d(sal)/d(ga) }
      rac := SQRT( 1.0 - SQR( sal ) - SQR( be ) );
      sa2 := - sal/(rac*sga);                   { d(rac)/d(al) }
      sb2 := (sal*ga/sga - be)/rac;             { d(rac)/d(be) }
      sg2 := -sal*abc/rac;                      { d(rac)/d(ga) }

      m11 :=      aa; m12 :=   bb*ga; m13 :=   cc*be;
                      m22 :=  bb*sga; m23 :=  cc*sal;
                                      m33 :=  cc*rac;

                                       { Mij;    d/d(aa),    d/d(bb),    d/d(cc),    d/d(al),    d/d(be),    d/d(ga) }
      SET_VDERV( cell_dcmt[1], cell_duc, m11,        1.0                                                             );
      SET_VDERV( cell_dcmt[2], cell_duc, m12,           ,         ga,           ,           ,           ,         bb );
      SET_VDERV( cell_dcmt[3], cell_duc, m13,           ,           ,         be,           ,         cc             );
      for i := 0 to 6 do  cell_dcmt[4,i] := 0.0;
      SET_VDERV( cell_dcmt[5], cell_duc, m22,           ,        sga,           ,           ,           , -bb*ga/sga );
      SET_VDERV( cell_dcmt[6], cell_duc, m23,           ,           ,        sal,     cc/sga, -cc*ga/sga,     cc*abc );
      for i := 0 to 6 do  cell_dcmt[7,i] := 0.0;
      for i := 0 to 6 do  cell_dcmt[8,i] := 0.0;
      SET_VDERV( cell_dcmt[9], cell_duc, m33,           ,           ,        rac,     cc*sa2,     cc*sb2,     cc*sg2 );

      { Now we must compute the rcmt matrix that the transpose of dcmt**-1 }

      fac := m12*m23 - m13*m22; abc := n11*n22*n33;

      n11 :=  1.0/aa;  n12 := -m12*n11*n33; n13 :=      fac*abc;
                       n22 :=      1.0/m22; n23 := -m23*n22*n33;
                                            n33 :=      1.0/m33;

      { Compute N = M**-1 uby using the specific form of the M and N matrixs }
                                        { Nij, d/d(m11), d/d(m12), d/d(m13),,        d/d(m22), d/d(m23),,, d/d(m33) }
      SET_VDERV( cell_rcmt[1], cell_dcmt, n11, -n11*n11                                                             );
      SET_VDERV( cell_rcmt[2], cell_dcmt, n12, -n12*n11,  n11*n33,         ,,                ,         ,,, -n12*n33 );
      SET_VDERV( cell_rcmt[3], cell_dcmt, n13, -n13*n11,  m23*abc, -m22*abc,, m12*m23*abc*n22,  m12*abc,,, -n13*n33 );
      for i := 0 to 6 do  cell_rcmt[4,i] := 0.0;
      SET_VDERV( cell_rcmt[5], cell_dcmt, n22, -n22*n22,                                                            );
      SET_VDERV( cell_rcmt[6], cell_dcmt, n23, -n13*n11,         ,         ,,        -n23*n22, -n22*n33,,, -n23*n33 );
      for i := 0 to 6 do  cell_rcmt[7,i] := 0.0;
      for i := 0 to 6 do  cell_rcmt[8,i] := 0.0;
      SET_VDERV( cell_rcmt[9], cell_dcmt, n33,         ,         ,         ,,                ,         ,,, -n33*n33 )
    end;

    UPDATE_VIRTVAR( cell_dcmt,  virt_pha$dm11 );
    UPDATE_VIRTVAR( cell_rcmt,  virt_pha$rm11 );


    WRITELN; WRITELN;
    WRITELN( ' Dir Mat : ' );
    for i := 1 to 3 do
    begin
      for j := 1 to 3 do WRITE( ' ', cell_dcmt[3*i+j-3,0]:14:6 );
      WRITELN
    end;
    WRITELN; WRITELN;

    WRITELN( ' Rec Mat : ' );
    for i := 1 to 3 do
    begin
      for j := 1 to 3 do WRITE( ' ', cell_rcmt[3*i+j-3,0]:14:6 );
      WRITELN
    end;
    WRITELN; WRITELN;

  end
end CRYST_PHASE_COMPUTE;



[global]
procedure CRYST_GROUP_SET( p: ptr );
const
  mdnam = 'SPGR';
  fnam_grp_temp = 'mxd_phase_sg.tmp';

var
  sysn:                     ide_string;
  scmd:                         string;
  gsystem, gorient, gcenter,
  gimpcod, gorder,
  ic, ie, ip, iu, nz:          integer;
  bok, bide, binv, bfnd:       boolean;
  tf:                             text;
  p0, p1, p2, p3:                  ptr;
  mat:                      symtry_ope;


  function  GENERE_NEW_OPER( ph: ptr; var ic : integer ): ptr;
  var
    ope: ptr;
    str: string( 8 );

  begin
    ic := ic + 1;
    NEW( ope, op_item, itm_symtry );
    with ope^ do
    begin
      nod_typ   :=   op_item;
      itm_next  :=       nil;           { Init the next link }
      itm_link  :=       nil;
      WRITEV( str, '.ope', ic:-2 );
      NEW( itm_name, scmd.length );
      itm_name^ :=       str;
      itm_sequ  :=       -ic;           { Set the item sequence number (original value - not shifted) }
      itm_kind := itm_symtry;           { Set the kind of item/data_item }
      QUEUE_OBJECT( ph^.pha_symhde, ph^.pha_symlst, ope )
    end;
    GENERE_NEW_OPER := ope
  end GENERE_NEW_OPER;


begin { CRYST_GROUP_SET }
  with p^, pha_cell do
    if (pha_symhde = nil) and
       (not (celf_center in cell_flags)) and
       (cell_group.length > 1) then
    begin { No specified symmetry operator, but group name was specified }
      bok := false;
      { Stop Space Group string to first illegal character }
      iu := 1;
      while (iu <= cell_group.length) and (cell_group.body[iu] >= ' ') do iu := iu + 1;
      iu := iu - 1;

      WRITEV( scmd, 'gen_space -data -ope ', cell_group.body:iu, ' ', fnam_grp_temp );
      ip := CREATE_PROCESS( 'MXDLIB:mxd_gen_space', scmd );
      if ip > 0 then
      begin
        iu := WAIT_PROCESS( ie, ip );
        if ie <> 0 then EXEC_ERROR( mdnam, 23, e_fatal, itm_name^ )
                   else bok := true
      end
      else EXEC_ERROR( mdnam, 24, e_fatal, itm_name^ );

(*
      WRITELN( ' GEN_SPACE created the following data file :' );
      SYS_SPAWN( 'cat '||fnam_grp_temp );
*)

      if bok then
      begin
        OPEN( tf, fnam_grp_temp, [read_file,error_file,del_file] );
        if iostatus <> 0 then
        begin
          EXEC_ERROR( mdnam, 26, e_fatal, itm_name^ );
          bok := false
        end
      end;
      if bok then
      begin
        READLN( tf, sysn:0:true, cell_group.body:0:true, cell_ngroup, gsystem, gorient, gcenter );

WRITELN( ' system = "', sysn, '", S.G. name = "', cell_group.body:cell_group.length, '", S.G. # = ', cell_ngroup:0, ', orient # = ', gorient:0 );

        ic := 0;
        { Read the space group matrix and look for inversion center }
        READ( tf, gorder );
        for ii := 1 to gorder do
        begin
          READ( tf, gimpcod );
          if (gcenter < 0) and (gimpcod < 0) then READLN( tf )  { Symmetry center is at origine => skip this element }
          else
          begin
            p0 := GENERE_NEW_OPER( p, ic );
            for i := 1 to 3 do  for j := 1 to 4 do  READ( tf, p0^.sym_oper[i,j] )
          end;
        end;
        CLOSE( tf )
      end
      else
      begin { Some symmetry operator was specified => we complete the operator list (MXD V3 mode) }
        p1 := p^.pha_symhde;
        { Make a count of operators }
        p2 := p1; ic := 0;
        while p2 <> nil do  begin  ic := ic + 1; p2 := p2^.itm_next  end;
        { Main loop to completye the symmtry group }
        while p1 <> nil do
        begin
          p2 := p1;
          with p1^ do
          while p2 <> nil do
          begin
            nz := 0;
            for i := 1 to 3 do  for j := 1 to 3 do
            begin
              mat[i,j] := p1^.sym_oper[i,1]*p2^.sym_oper[1,j] +
                          p1^.sym_oper[i,2]*p2^.sym_oper[2,j] +
                          p1^.sym_oper[i,3]*p2^.sym_oper[3,j];
              if mat[i,j] <> 0 then nz := nz + 1
            end;
            bide := false; binv := false;
            if nz = 3 then
              if (ABS( mat[1,1] ) = 1) and (mat[1,1] = mat[2,2]) and (mat[1,1] = mat[3,3]) then
                if mat[1,1] > 0 then bide := true
                                else binv := true;
            bfnd := (celf_center in cell_flags) and binv;
            p3 := p^.pha_symhde;
            while (p3 <> nil) and not bfnd do
            begin
              for i := 1 to 3 do  for j := 1 to 3 do
                if mat[i,j] <> p3^.sym_oper[i,j] then begin  bfnd := true; exit  end;
              if (not bfnd) and (celf_center in cell_flags) then
                for i := 1 to 3 do  for j := 1 to 3 do
                  if mat[i,j] <> - p3^.sym_oper[i,j] then begin  bfnd := true; exit  end;
              if not bfnd then
              begin
                p0 := GENERE_NEW_OPER( p, ic );
                p0^.sym_oper := mat
              end
            end;
            p2 := p2^.itm_next
          end;
          p1 := p1^.itm_next
        end
      end
    end
end CRYST_GROUP_SET;



procedure DATA_HKL_COMPLETE( p: ptr; asz: integer );
const
  mdnam   =              'DATC';
  tmpname = 'dat_temporary.tmp';

var
  pa:                                      ptr;
  np, hdsz, cph, cwa, cpo, nobs, vp:   integer;
  st:                                   string;
  lsumwo2, lsumwo, lsumo2, lsumo:      mxd_flt;
  bok:                                 boolean;

begin
  np := asz;

  pa := interphde;                      { Scan the list of HKL Data constant dependant interpolation nodes }
  while pa <> nil do
  with pa^ do
  begin
    np := np + 1;
    nod_itpfco := np;
    pa := nod_itpnxt
  end;
  if np > max_dattab_size then EXEC_ERROR( mdnam, 33 );


WRITELN( ' We must insert ', np:0, ' add/supplementary value to each record of the data "', p^.itm_name, '"' );

  st := FILE_SPECIFICATION( dat_inp );

  OPEN( dat_out, tmpname, [write_file,direct_file,error_file] );
  if iostatus <> 0 then EXEC_ERROR( mdnam, 33, e_fatal, tmpname );
  { Make place for the final binary header }
  WRITE_DATF_ST( dat_clabel );                  { Room for the label }
  WRITE_DATF_SL( np );                          { Room for suplementary data number }
  WRITE_DATF_SL( 0 );                           { Room for number of observations <> number of records when RAy data type }
  WRITE_DATF_DB( 0.0 ); WRITE_DATF_DB( 0.0 );   { Room for data sums: sumwobs2, sumwobs, sumobs2, sumobs }
  WRITE_DATF_DB( 0.0 ); WRITE_DATF_DB( 0.0 );

  hdsz := dat_byte_count;

  lsumwo2 := 0.0; lsumwo := 0.0; lsumo2 := 0.0; lsumo  := 0.0;
  nobs    :=   0; cph    :=  -1; cwa    :=   0; cpo    :=   0;

  with curr_data do
  for ir := 1 to p^.dat_nrec do
  begin

    { Read the current data record (in DCP format) }
    READ_DATF_SL( ih );    READ_DATF_SL( ik );    READ_DATF_SL( il );
    READ_DATF_SL( nq );    READ_DATF_SL( mul );   READ_DATF_SL( npo );
    READ_DATF_SL( nwv );   READ_DATF_SL( npd );   READ_DATF_SL( nph );
    READ_DATF_SL( isent ); READ_DATF_SL( selnb );
    READ_DATF_DB( obs );   READ_DATF_DB( sig );   READ_DATF_DB( wei );
    for ii := 1 to asz do  READ_DATF_DB( tbv[ii] );

    if nph <> cph then
    begin
      if nph = 0 then begin  cphas := phashde; nph := cphas^.itm_sequ  end
                 else cphas := GET_REFERENCE( nph );
      cph := nph
    end;
    if nwv <> cwa then
    begin
      if nwv = 0 then cwave := nil
                 else cwave := GET_REFERENCE( nwv );
      cwa := nwv
    end;
    if npd <> cpo then
    begin
      if npd = 0 then cpola := nil
                 else cpola := GET_REFERENCE( npd );
      cpo := npd
    end;

    { Perform all HKL specific computing }
    with cphas^.pha_cell do
    begin
      { Compute he, ke, le equiv. to h,k,l in work reference }
      he := cell_rcmt[1,0]*ih + cell_rcmt[2,0]*ik + cell_rcmt[3,0]*il;
      ke := cell_rcmt[4,0]*ih + cell_rcmt[5,0]*ik + cell_rcmt[6,0]*il;
      le := cell_rcmt[7,0]*ih + cell_rcmt[8,0]*ik + cell_rcmt[9,0]*il;

      { Compute hw, kw, lw equiv. to h+nq*qx, k+nq*qy, l+nq*qz in work reference }
      if cwave = nil then begin  hh := he; kk := ke; ll := le  end
      else
        with cwave^ do
        begin
          hh := he + nq*wav_vec[1,0]; kk := ke + nq*wav_vec[2,0]; ll := le + nq*wav_vec[3,0]
        end
    end;
    sithsl := 0.5*SQRT( SQR( hh ) + SQR( kk ) + SQR( ll ) );

    pa := interphde; vp := asz;
    while pa <> nil do
    with pa^ do
    begin
      vp := vp + 1;
      tbv[vp] := MATH_INTERPOL( nod_itptab^, sithsl );
      pa := nod_itpnxt
    end;

    { Rewrite the record in the LSQ format }
    WRITE_DATF_SL( ih );    WRITE_DATF_SL( ik );    WRITE_DATF_SL( il );
    WRITE_DATF_SL( nq );    WRITE_DATF_SL( mul );   WRITE_DATF_SL( npo );
    WRITE_DATF_SL( nwv );   WRITE_DATF_SL( npd );   WRITE_DATF_SL( nph );
    WRITE_DATF_SL( isent ); WRITE_DATF_SL( selnb );
    WRITE_DATF_DB( he );    WRITE_DATF_DB( ke );    WRITE_DATF_DB( le );

    WRITE_DATF_DB( sithsl );

    for ii := 1 to np do  WRITE_DATF_DB( tbv[ii] );

    if isent > 0 then
    begin
      WRITE_DATF_DB( obs ); WRITE_DATF_DB( sig ); WRITE_DATF_DB( wei );
      lsumwo2 := lsumwo2  + SQR( wei*obs );
      lsumwo  := lsumwo   + wei*ABS( obs );
      lsumo2  := lsumo2   + SQR( obs );
      lsumo   := lsumo    + ABS( obs );
      nobs := nobs + 1
    end
  end;

  { Write the complete Final Data Header }
  SEEK( dat_out, 1 );

  WRITE_DATF_ST( dat_clabel );                  { Write the label }
  WRITE_DATF_SL( np );                          { Write the additional/supplementary value table size }
  WRITE_DATF_SL( nobs );                        { Write the number of observations <> number of records when RAy data type }
  WRITE_DATF_DB( lsumwo2 );                     { Write the data sums: sumwobs2, sumwobs, sumobs2, sumobs }
  WRITE_DATF_DB( lsumwo );
  WRITE_DATF_DB( lsumo2 );
  WRITE_DATF_DB( lsumo );

  CLOSE( dat_out );
  CLOSE( dat_inp );

  p^.dhkl_nobs      :=    nobs;                 { Complete the data item structure }
  p^.dhkl_sobs      :=   lsumo;
  p^.dhkl_sobs2     :=  lsumo2;
  p^.dhkl_swobs     :=  lsumwo;
  p^.dhkl_swobs2    := lsumwo2;

with p^ do
begin
WRITELN( ' Data with ', dhkl_nobs:0, ' observations / ', dat_nrec:0, ' records.' );
WRITELN( ' The R factor sums are :', lsumwo2:10, ', ', lsumwo:10, ', ', lsumo2:10, ', ', lsumo:10 );
end;

  { Delete the old data file and rename the new one }

WRITELN( ' Delete "', st, '" and rename "', tmpname, char( 10 ), ' to "', st, '".' );

  if not FILE_REMOVE( st ) then EXEC_ERROR( mdnam, 34, e_fatal, p^.itm_name^ );
  if not FILE_RENAME( tmpname, st ) then EXEC_ERROR( mdnam, 35, e_fatal, p^.itm_name^ )

end DATA_HKL_COMPLETE;



procedure DATA_PRF_COMPLETE( p: ptr; vsz: integer );
begin
end DATA_PRF_COMPLETE;



[global]
procedure CRYST_DATA_COMPLETE( p: ptr );
const
  mdnam = 'INDA';

var
  ns, tbvsz:           integer;
  ch:                     char;
  hst, st, sn, sk:      string;

  ph: ptr;

  data_naddf,                           { Number of additional floating fields }
  data_ncmpl:           integer :=   0; { Number of complementary floating fields }

  data_kindst: [static] array[itmd_kinds] of string( 16 ) := [
    'X-Ray F2', 'Neutrons F2', 'X-Ray SF', 'Neutrons SF', 'X-Ray Ray', 'Neutrons Ray',
    'X-Ray Pattern', 'Neutrons Pattern', 'Curve'
  ];

  nout:   string;

begin
  with p^ do
  begin
    OPEN( dat_inp, dat_fname^, [read_file,error_file] );
    if iostatus <> 0 then EXEC_ERROR( mdnam, 31, e_fatal, dat_fname^ );
    READ_DATF_ST( hst );

WRITELN;
WRITE( ' Data name = "', itm_name^, '" of type ', data_kindst[dat_kind] );
case dat_kind of
  itmd_hkl_xf2,  itmd_hkl_nf2,
  itmd_hkl_xsf,  itmd_hkl_nsf,
  itmd_hkl_xray, itmd_hkl_nray: WRITE( ', Wave Length =', dhkl_lambda:8:5 );
  itmd_xprofil,  itmd_nprofil:  WRITE( ', Wave Length(s) =', dprf_lambda1:8:5, ',',  dprf_lambda2:8:5 );
otherwise
end;
WRITELN( ' with ', dat_nrec:0, ' records' );

    if dat_addidtb <> nil then

begin

      tbvsz := dat_addidtb^.size;

WRITE( ' with ', dat_addidtb^.size:0, ' additional field' );
if tbvsz > 1 then WRITE( 's' ); WRITE( ' : ' );
for i := 1 to tbvsz do
begin
  if i > 1 then WRITE( ',' );
  WRITE( ' ', dat_addidtb^[i]^.nod_datname^ )
end;
WRITELN
end

    else tbvsz := 0;

WRITELN( ' BDA head descriptor' );
WRITELN( ' HST = "', hst, '"' );

    if hst = dat_blabel then            { For Base Data label it is OK }
    begin

WRITELN( ' Initial DCP out data File' );

      case dat_kind of
        itmd_hkl_xf2,  itmd_hkl_nf2,
        itmd_hkl_xsf,  itmd_hkl_nsf,
        itmd_hkl_xray, itmd_hkl_nray: DATA_HKL_COMPLETE( p, tbvsz );

        itmd_xprofil,  itmd_nprofil:  DATA_PRF_COMPLETE( p, tbvsz );

      otherwise
      end
    end
    else
    if hst = dat_clabel then
    begin
      READ_DATF_SL( dat_nval );                 { Get the additional/supplementary value table size }
      READ_DATF_SL( dhkl_nobs );                { Get the number of observations <> number of records when RAy data type }
      READ_DATF_DB( dhkl_swobs2 );              { Get the data sums: sumwobs2, sumwobs, sumobs2, sumobs }
      READ_DATF_DB( dhkl_swobs );
      READ_DATF_DB( dhkl_sobs2 );
      READ_DATF_DB( dhkl_sobs );

WRITELN( ' Data with ', dhkl_nobs:0, ' observations / ', dat_nrec:0, ' records.' );
WRITELN( ' The R factor sums are :', dhkl_swobs2:10, ', ', dhkl_swobs:10, ', ', dhkl_sobs2:10, ', ', dhkl_sobs:10 );

WRITELN( ' MXD_TREE data File completed with ', dat_nval:0, ' additional values and ', dat_nval:0, ' observations.' );

      CLOSE( dat_inp )
    end
    else EXEC_ERROR( mdnam, 32, e_fatal, dat_fname^ );


WRITELN;

  end
end CRYST_DATA_COMPLETE;




end MXD_CRYST_RTL.

