/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[2];

/* Define the local data section. */
static Blk( Rd, 1208 ) = {
  4,   4, 103, 118,  97, 108,  56,  56,  47, 104, 111, 109, 101,  47, 119, 111,
108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95, 115, 114,  99,  47, 109,
120, 100,  95,  99, 114, 121, 115, 116,  95, 114, 116, 108,  46, 112,  97, 115,
 10,  10, 105, 110, 105, 116,  95, 118, 100, 101, 114, 118,   9,   9, 115, 101,
116,  95, 118, 100, 101, 114, 118,  16,  16, 115, 101, 116,  95, 109, 116, 101,
110, 115,  95, 118,  97, 108, 117, 101, 115,  18,  18,  99, 114, 121, 115, 116,
 95, 109, 117, 108, 109,  97, 116,  95, 118, 100, 101, 114, 118,  17,  17, 117,
110, 105, 116,  95,  99, 101, 108, 108,  95,  99, 111, 109, 112, 117, 116, 101,
 10,  10, 112, 104,  97, 115, 101,  95, 105, 110, 105, 116,  12,  12,  32,  84,
104, 101,  32, 112, 104,  97, 115, 101,  32,  34,  26,  26,  34,  32, 119, 105,
116, 104,  32, 116, 104, 101,  32,  99, 101, 108, 108,  32, 112,  97, 114,  97,
109, 101, 116, 101, 114, 115,   2,   2,  70,  44,   2,   2,  86,  44,  10,  10,
 32, 105, 115,  32, 102, 105, 120, 101, 100,  46,  16,  16,  32, 119, 105, 108,
108,  32,  98, 101,  32, 102, 105, 116, 116, 101, 100,  46,  19,  19,  99, 114,
121, 115, 116,  95, 112, 104,  97, 115, 101,  95,  99, 111, 109, 112, 117, 116,
101,   4,   4,  67,  69,  76,  66,  19,  19,  32,  68, 105, 114, 101,  99, 116,
 32,  32,  32,  32,  32,  67,  69,  76,  76,  32,  58,  32,   5,   5,  32,  86,
 32,  61,  32,  19,  19,  32,  82, 101,  99, 105, 112, 114, 111,  99,  97, 108,
 32,  67,  69,  76,  76,  32,  58,  32,   5,   5,  32,  86,  32,  61,  32,  28,
 28,  32,  68, 105, 114, 101,  99, 116,  32,  32,  32,  77, 101, 116, 114, 105,
 99,  32,  32,  32,  84, 101, 110, 115, 111, 114,  32,  58,  32,  28,  28,  32,
 82, 101,  99, 105, 112, 114, 111,  99,  97, 108,  32,  77, 101, 116, 114, 105,
 99,  32,  84, 101, 110, 115, 111, 114,  32,  58,  32,  11,  11,  32,  68, 105,
114,  32,  77,  97, 116,  32,  58,  32,  11,  11,  32,  82, 101,  99,  32,  77,
 97, 116,  32,  58,  32,  15,  15, 103, 101, 110, 101, 114, 101,  95, 110, 101,
119,  95, 111, 112, 101, 114,   4,   4,  46, 111, 112, 101,  15,  15,  99, 114,
121, 115, 116,  95, 103, 114, 111, 117, 112,  95, 115, 101, 116,  21,  21, 103,
101, 110,  95, 115, 112,  97,  99, 101,  32,  45, 100,  97, 116,  97,  32,  45,
111, 112, 101,  32,  16,  16, 109, 120, 100,  95, 112, 104,  97, 115, 101,  95,
115, 103,  46, 116, 109, 112,  20,  20,  77,  88,  68,  76,  73,  66,  58, 109,
120, 100,  95, 103, 101, 110,  95, 115, 112,  97,  99, 101,   4,   4,  83,  80,
 71,  82,  11,  11,  32, 115, 121, 115, 116, 101, 109,  32,  61,  32,  34,  16,
 16,  34,  44,  32,  83,  46,  71,  46,  32, 110,  97, 109, 101,  32,  61,  32,
 34,  12,  12,  34,  44,  32,  83,  46,  71,  46,  32,  35,  32,  61,  32,  13,
 13,  44,  32, 111, 114, 105, 101, 110, 116,  32,  35,  32,  61,  32,  17,  17,
100,  97, 116,  97,  95, 104, 107, 108,  95,  99, 111, 109, 112, 108, 101, 116,
101,   4,   4,  68,  65,  84,  67,  16,  16,  32,  87, 101,  32, 109, 117, 115,
116,  32, 105, 110, 115, 101, 114, 116,  32,  53,  53,  32,  97, 100, 100,  47,
115, 117, 112, 112, 108, 101, 109, 101, 110, 116,  97, 114, 121,  32, 118,  97,
108, 117, 101,  32, 116, 111,  32, 101,  97,  99, 104,  32, 114, 101,  99, 111,
114, 100,  32, 111, 102,  32, 116, 104, 101,  32, 100,  97, 116,  97,  32,  34,
 17,  17, 100,  97, 116,  95, 116, 101, 109, 112, 111, 114,  97, 114, 121,  46,
116, 109, 112,  15,  15,  77,  88,  68,  86,  52,  45,  68,  65,  84,  65,  45,
 76,  83,  81,  70,  11,  11,  32,  68,  97, 116,  97,  32, 119, 105, 116, 104,
 32,  16,  16,  32, 111,  98, 115, 101, 114, 118,  97, 116, 105, 111, 110, 115,
 32,  47,  32,   9,   9,  32, 114, 101,  99, 111, 114, 100, 115,  46,  24,  24,
 32,  84, 104, 101,  32,  82,  32, 102,  97,  99, 116, 111, 114,  32, 115, 117,
109, 115,  32,  97, 114, 101,  32,  58,   2,   2,  44,  32,   2,   2,  44,  32,
  2,   2,  44,  32,   9,   9,  32,  68, 101, 108, 101, 116, 101,  32,  34,  14,
 14,  34,  32,  97, 110, 100,  32, 114, 101, 110,  97, 109, 101,  32,  34,   5,
  5,  32, 116, 111,  32,  34,   2,   2,  34,  46,  19,  19,  99, 114, 121, 115,
116,  95, 100,  97, 116,  97,  95,  99, 111, 109, 112, 108, 101, 116, 101,   4,
  4,  73,  78,  68,  65,  14,  14,  32,  68,  97, 116,  97,  32, 110,  97, 109,
101,  32,  61,  32,  34,  10,  10,  34,  32, 111, 102,  32, 116, 121, 112, 101,
 32,  15,  15,  44,  32,  87,  97, 118, 101,  32,  76, 101, 110, 103, 116, 104,
 32,  61,  18,  18,  44,  32,  87,  97, 118, 101,  32,  76, 101, 110, 103, 116,
104,  40, 115,  41,  32,  61,   6,   6,  32, 119, 105, 116, 104,  32,   8,   8,
 32, 114, 101,  99, 111, 114, 100, 115,   6,   6,  32, 119, 105, 116, 104,  32,
 17,  17,  32,  97, 100, 100, 105, 116, 105, 111, 110,  97, 108,  32, 102, 105,
101, 108, 100,   3,   3,  32,  58,  32,  20,  20,  32,  66,  68,  65,  32, 104,
101,  97, 100,  32, 100, 101, 115,  99, 114, 105, 112, 116, 111, 114,   8,   8,
 32,  72,  83,  84,  32,  61,  32,  34,  15,  15,  77,  88,  68,  86,  52,  45,
 68,  65,  84,  65,  45,  66,  65,  83,  69,  26,  26,  32,  73, 110, 105, 116,
105,  97, 108,  32,  68,  67,  80,  32, 111, 117, 116,  32, 100,  97, 116,  97,
 32,  70, 105, 108, 101,  11,  11,  32,  68,  97, 116,  97,  32, 119, 105, 116,
104,  32,  16,  16,  32, 111,  98, 115, 101, 114, 118,  97, 116, 105, 111, 110,
115,  32,  47,  32,   9,   9,  32, 114, 101,  99, 111, 114, 100, 115,  46,  24,
 24,  32,  84, 104, 101,  32,  82,  32, 102,  97,  99, 116, 111, 114,  32, 115,
117, 109, 115,  32,  97, 114, 101,  32,  58,   2,   2,  44,  32,   2,   2,  44,
 32,   2,   2,  44,  32,  35,  35,  32,  77,  88,  68,  95,  84,  82,  69,  69,
 32, 100,  97, 116,  97,  32,  70, 105, 108, 101,  32,  99, 111, 109, 112, 108,
101, 116, 101, 100,  32, 119, 105, 116, 104,  32,  23,  23,  32,  97, 100, 100,
105, 116, 105, 111, 110,  97, 108,  32, 118,  97, 108, 117, 101, 115,  32,  97,
110, 100,  32,  14,  14,  32, 111,  98, 115, 101, 114, 118,  97, 116, 105, 111,
110, 115,  46,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 168 ) = {
 16,   8,  88,  45,  82,  97, 121,  32,  70,  50,   0,   0,   0,   0,   0,   0,
  0,   0,  16,  11,  78, 101, 117, 116, 114, 111, 110, 115,  32,  70,  50,   0,
  0,   0,   0,   0,  16,   8,  88,  45,  82,  97, 121,  32,  83,  70,   0,   0,
  0,   0,   0,   0,   0,   0,  16,  11,  78, 101, 117, 116, 114, 111, 110, 115,
 32,  83,  70,   0,   0,   0,   0,   0,  16,   9,  88,  45,  82,  97, 121,  32,
 82,  97, 121,   0,   0,   0,   0,   0,   0,   0,  16,  12,  78, 101, 117, 116,
114, 111, 110, 115,  32,  82,  97, 121,   0,   0,   0,   0,  16,  13,  88,  45,
 82,  97, 121,  32,  80,  97, 116, 116, 101, 114, 110,   0,   0,   0,  16,  16,
 78, 101, 117, 116, 114, 111, 110, 115,  32,  80,  97, 116, 116, 101, 114, 110,
 16,   5,  67, 117, 114, 118, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;
extern V V_interphde;
extern V V_dat_inp;
extern V V_dat_out;
extern UL V_dat_byte_count;
extern Blk(V_curr_data, 2192 );
extern V V_cphas;
extern V V_phashde;
extern V V_cwave;
extern V V_cpola;


/* Function/procedure prototypes. */
void P_read_datf_st(V F_st);
void P_write_datf_st(V F_st);
void P_read_datf_sl(SL *F_sl);
void P_write_datf_sl(SL F_sl);
void P_read_datf_db(G *F_db);
void P_write_datf_db(G F_db);
G P_math_interpol(V F_ftab, G F_xx);
void P_exec_error(V F_md, SL F_nb, UB F_sev, V F_ide);
V P_get_reference(SL F_nsequ);
void P_queue_object(V *F_frs, V *F_lst, V F_nod);
void P_update_virtvar(V F_obj, SL F_sz, UB F_vcd);
G P_fo_value(V F_p);


/* Procedure/Function : " gval "  */
G P_gval(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=109; /* line # 109 */
  if (F_p==NULL) Ret=0.000000000000000E-001;
  else {
    Ra.sl[3]=110; /* line # 110 */
    Ret=((G *)F_p)[5];
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_vderv "  */
void MXD_CRY_RTL_init_vderv(V F_vd, G F_val, G F_d1, G F_d2, G F_d3, G F_d4, G F_d5
, G F_d6){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+64;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=119; /* line # 119 */
  ((G *)F_vd)[0]=F_val;
  Ra.sl[3]=120; /* line # 120 */
  ((G *)F_vd)[1]=F_d1;
  ((G *)F_vd)[2]=F_d2;
  ((G *)F_vd)[3]=F_d3;
  Ra.sl[3]=121; /* line # 121 */
  ((G *)F_vd)[4]=F_d4;
  ((G *)F_vd)[5]=F_d5;
  ((G *)F_vd)[6]=F_d6;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_vderv "  */
void MXD_CRY_RTL_set_vderv(V F_exp, V F_base, SL F_sz, G F_val, G F_d1, G F_d2, 
G F_d3, G F_d4, G F_d5, G F_d6, G F_d7, G F_d8, G F_d9){
  /* Define the automatic variable space. */
  Blk( Ra, 88 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=140; /* line # 140 */
  Ra.g[2]=F_d1;
  Ra.g[3]=F_d2;
  Ra.g[4]=F_d3;
  Ra.sl[3]=141; /* line # 141 */
  Ra.g[5]=F_d4;
  Ra.g[6]=F_d5;
  Ra.g[7]=F_d6;
  Ra.sl[3]=142; /* line # 142 */
  Ra.g[8]=F_d7;
  Ra.g[9]=F_d8;
  Ra.g[10]=F_d9;
  Ra.sl[3]=143; /* line # 143 */
  ((G *)F_exp)[0]=F_val;
  Ra.sl[3]=144; /* line # 144 */
  Rv0=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    Ra.sl[3]=146; /* line # 146 */
    Rv1=0.000000000000000E-001;
    Ra.sl[3]=148; /* line # 148 */
    Rv2=1;
    for( Rf0=F_sz;Rf0>0;Rf0-- ) {
      Rv1=Rv1+Ra.g[Rv2+1]*((G *)F_base)[Rv2*7+Rv0-7];
      Rv2++;
    }
    Ra.sl[3]=149; /* line # 149 */
    ((G *)F_exp)[Rv0]=Rv1;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_mtens_values "  */
void MXD_CRY_RTL_set_mtens_values(V F_mt, V F_uc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  G Rv2;
  G Rv3;
  G Rv4;
  G Rv5;
  register G Rgg;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=179; /* line # 179 */
  Rv0=((G *)F_uc)[0];
  Rv1=((G *)F_uc)[7];
  Rv2=((G *)F_uc)[14];
  Ra.sl[3]=180; /* line # 180 */
  Rv3=((G *)F_uc)[21];
  Rv4=((G *)F_uc)[28];
  Rv5=((G *)F_uc)[35];
  Ra.sl[3]=185; /* line # 185 */
  MXD_CRY_RTL_set_vderv(F_mt,F_uc,6, Rv0*Rv0,2.000000000000000E+000*Rv0,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=186; /* line # 186 */
  MXD_CRY_RTL_set_vderv(F_mt+56,F_uc,6, Rv1*Rv1,0.000000000000000E-001,2.000000000000000E+000*
  Rv1,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=187; /* line # 187 */
  MXD_CRY_RTL_set_vderv(F_mt+112,F_uc,6, Rv2*Rv2,0.000000000000000E-001,0.000000000000000E-001,
2.000000000000000E+000*Rv2,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=188; /* line # 188 */
  MXD_CRY_RTL_set_vderv(F_mt+168,F_uc,6,((2.000000000000000E+000*Rv1)*Rv2)*Rv3,0.000000000000000E-001,(
2.000000000000000E+000*Rv2)*Rv3,(2.000000000000000E+000*Rv1)*Rv3,(2.000000000000000E+000*
  Rv1)*Rv2,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=189; /* line # 189 */
  MXD_CRY_RTL_set_vderv(F_mt+224,F_uc,6,((2.000000000000000E+000*Rv2)*Rv0)*Rv4,(
2.000000000000000E+000*Rv2)*Rv4,0.000000000000000E-001,(2.000000000000000E+000*Rv0)
  *Rv4,0.000000000000000E-001,(2.000000000000000E+000*Rv0)*Rv1,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=190; /* line # 190 */
  MXD_CRY_RTL_set_vderv(F_mt+280,F_uc,6,((2.000000000000000E+000*Rv0)*Rv1)*Rv5,(
2.000000000000000E+000*Rv1)*Rv5,(2.000000000000000E+000*Rv0)*Rv5,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,(2.000000000000000E+000*Rv0)*Rv1,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cryst_mulmat_vderv "  */
void P_cryst_mulmat_vderv(V F_mat, V F_pax, V F_pay, V F_paz, V F_vec){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;
  G Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=208; /* line # 208 */
  Rv0=P_gval(F_pax);
  Rv1=P_gval(F_pay);
  Rv2=P_gval(F_paz);
  Ra.sl[3]=209; /* line # 209 */
  Rv3=1;
  Ra.sl[3]=210; /* line # 210 */
  Rv4=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=212; /* line # 212 */
    ((G *)F_vec)[Rv4*7-7]=(((G *)F_mat)[(Rv3+0)*7-7]*Rv0+((G *)F_mat)[(Rv3+1)*7-
7]*Rv1)+((G *)F_mat)[(Rv3+2)*7-7]*Rv2;
    Ra.sl[3]=213; /* line # 213 */
    Rv5=1;
    for( Rf0=6;Rf0>0;Rf0-- ) {
      Ra.sl[3]=214; /* line # 214 */
      ((G *)F_vec)[Rv4*7+Rv5-7]=(Rv0*((G *)F_mat)[(Rv3+0)*7+Rv5-7]+Rv1*((G *)F_mat)
      [(Rv3+1)*7+Rv5-7])+Rv2*((G *)F_mat)[(Rv3+2)*7+Rv5-7];
      Rv5++;
    }
    Ra.sl[3]=215; /* line # 215 */
    Rv3=Rv3+3;
    Rv4++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " unit_cell_compute "  */
void MXD_CRY_RTL_PRC_00000000(V F_gc, V F_dc, V F_gv, V F_dv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  G Rv2;
  G Rv3;
  G Rv4;
  G Rv5;
  G Rv6;
  G Rv7;
  G Rv8;
  G Rv9;
  G Rv10;
  G Rv11;
  G Rv12;
  G Rv13;
  G Rv14;
  G Rv15;
  G Rv16;
  G Rv17;
  register G Rgg;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+125;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=282; /* line # 282 */
  Rv0=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    Ra.sl[3]=284; /* line # 284 */
    ((G *)F_gc)[Rv0*7-7]=Lx[0].g[Rv0-1];
    Ra.sl[3]=285; /* line # 285 */
    Rv1=1;
    for( Rf0=6;Rf0>0;Rf0-- ) {
      Ra.sl[3]=286; /* line # 286 */
      if (Rv0==Rv1) ((G *)F_gc)[Rv0*7+Rv1-7]=1.000000000000000E+000;
      else {
        Ra.sl[3]=287; /* line # 287 */
        ((G *)F_gc)[Rv0*7+Rv1-7]=0.000000000000000E-001;
      }
      Rv1++;
    }
    Rv0++;
  }
  Ra.sl[3]=289; /* line # 289 */
  Rv2=Lx[0].g[0];
  Rv3=Lx[0].g[1];
  Rv4=Lx[0].g[2];
  Ra.sl[3]=290; /* line # 290 */
  Rv5=Lx[0].g[3];
  Rv6=Lx[0].g[4];
  Rv7=Lx[0].g[5];
  Ra.sl[3]=293; /* line # 293 */
  MXD_CRY_RTL_init_vderv(F_gv,Lx[0].g[6],Lx[0].g[6]/Rv2, Lx[0].g[6]/Rv3, Lx[0].g[
6]/Rv4, Lx[0].g[7]*(Rv6*Rv7-Rv5),Lx[0].g[7]*(Rv7*Rv5-Rv6),Lx[0].g[7]*(Rv5*Rv6-Rv7)
  );
  Ra.sl[3]=296; /* line # 296 */
  Rv8=1.000000000000000E+000/Lx[0].g[6];
  Ra.sl[3]=297; /* line # 297 */
  MXD_CRY_RTL_set_vderv(F_dv,F_gv,1, Rv8,-(Rv8*Rv8),0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
  Ra.sl[3]=300; /* line # 300 */
  Rv9=(Rv6*Rv7-Rv5)/(Lx[0].g[8]*Lx[0].g[9]);
  Ra.sl[3]=301; /* line # 301 */
  Rv10=(Rv7*Rv5-Rv6)/(Lx[0].g[9]*Lx[0].g[10]);
  Ra.sl[3]=302; /* line # 302 */
  Rv11=(Rv5*Rv6-Rv7)/(Lx[0].g[10]*Lx[0].g[8]);
  Ra.sl[3]=303; /* line # 303 */
  Rv12=(Rv3*Rv4)*Lx[0].g[10];
  Rv13=(Rv4*Rv2)*Lx[0].g[8];
  Rv14=(Rv2*Rv3)*Lx[0].g[9];
  Ra.sl[3]=304; /* line # 304 */
  Rv15=Rv12*Rv8;
  Rv16=Rv13*Rv8;
  Rv17=Rv14*Rv8;
  Ra.sl[3]=306; /* line # 306 */
  MXD_CRY_RTL_init_vderv(F_dc,Rv15, Rv12*((G *)F_dv)[1],(Rv4*Lx[0].g[10])*(Rv8+Rv3*
  ((G *)F_dv)[2]),(Rv3*Lx[0].g[10])*(Rv8+Rv4*((G *)F_dv)[3]),(Rv3*Rv4)*(Lx[0].g[
10]*((G *)F_dv)[4]-(Rv5*Rv8)/Lx[0].g[10]),Rv12*((G *)F_dv)[5],Rv12*((G *)F_dv)[6]
  );
  Ra.sl[3]=314; /* line # 314 */
  MXD_CRY_RTL_init_vderv(F_dc+56,Rv16,(Rv4*Lx[0].g[8])*(Rv8+Rv2*((G *)F_dv)[1]),
  Rv13*((G *)F_dv)[2],(Rv2*Lx[0].g[8])*(Rv8+Rv4*((G *)F_dv)[3]),Rv13*((G *)F_dv)
  [4],(Rv4*Rv2)*(Lx[0].g[8]*((G *)F_dv)[5]-(Rv6*Rv8)/Lx[0].g[8]),Rv13*((G *)F_dv)
  [6]);
  Ra.sl[3]=322; /* line # 322 */
  MXD_CRY_RTL_init_vderv(F_dc+112,Rv17,(Rv3*Lx[0].g[9])*(Rv8+Rv2*((G *)F_dv)[1])
  ,(Rv2*Lx[0].g[9])*(Rv8+Rv3*((G *)F_dv)[2]),Rv14*((G *)F_dv)[3],Rv14*((G *)F_dv)
  [4],Rv13*((G *)F_dv)[5],(Rv2*Rv3)*(Lx[0].g[9]*((G *)F_dv)[6]-(Rv7*Rv8)/Lx[0].g[
9]));
  Ra.sl[3]=330; /* line # 330 */
  Rv12=1.000000000000000E+000/(Lx[0].g[8]*Lx[0].g[9]);
  Ra.sl[3]=331; /* line # 331 */
  MXD_CRY_RTL_init_vderv(F_dc+168,Rv9,0.000000E-01,0.000000E-01,0.000000E-01,-Rv12,
  Rv7*Rv12+(Rv9*Rv6)/PAS__G_SQR(Lx[0].g[8]),Rv6*Rv12+(Rv9*Rv7)/PAS__G_SQR(Lx[0].
  g[9]));
  Ra.sl[3]=337; /* line # 337 */
  Rv13=1.000000000000000E+000/(Lx[0].g[9]*Lx[0].g[10]);
  Ra.sl[3]=338; /* line # 338 */
  MXD_CRY_RTL_init_vderv(F_dc+224,Rv10,0.000000E-01,0.000000E-01,0.000000E-01, Rv7*
  Rv13+(Rv10*Rv5)/PAS__G_SQR(Lx[0].g[10]),-Rv13, Rv5*Rv13+(Rv10*Rv7)/PAS__G_SQR(
  Lx[0].g[9]));
  Ra.sl[3]=344; /* line # 344 */
  Rv14=1.000000000000000E+000/(Lx[0].g[10]*Lx[0].g[8]);
  Ra.sl[3]=345; /* line # 345 */
  MXD_CRY_RTL_init_vderv(F_dc+224,Rv11,0.000000E-01,0.000000E-01,0.000000E-01, Rv6*
  Rv14+(Rv11*Rv5)/PAS__G_SQR(Lx[0].g[10]),Rv5*Rv14+(Rv11*Rv6)/PAS__G_SQR(Lx[0].g[
8]),-Rv14);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " phase_init "  */
void MXD_CRY_RTL_PRC_00000001(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  UB Rv2;
  SL Rv3;
  register V Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+144;
  Ra.v[2]=Rd.s+6;
  Ra.sl[3]=359; /* line # 359 */
  Rv0=F_p;
  Rv1=Rv0+112;
  Ra.sl[3]=361; /* line # 361 */
  Rv2=1;
  Ra.sl[3]=362; /* line # 362 */
  Rv3=1;
  for( Rf0=6;Rf0>0;Rf0-- ) {
    Ra.sl[3]=364; /* line # 364 */
    if (((V *)Rv0)[Rv3+20]==NULL) {
      Ra.sl[3]=365; /* line # 365 */
      Lx[0].ub[Rv3+87]=1;
      Lx[0].g[Rv3-1]=0.000000000000000E-001;
    }
    else {
      Ra.sl[3]=367; /* line # 367 */
      Rv4=((V *)Rv0)[Rv3+20];
      Ra.sl[3]=369; /* line # 369 */
      Lx[0].ub[Rv3+87]=((UB *)Rv4)[21]==2;
      Ra.sl[3]=370; /* line # 370 */
      if (!Lx[0].ub[Rv3+87]) {
        Rv2=0;
        ((G *)Rv4)[5]=P_fo_value(((V *)Rv4)[6]);
      }
      Ra.sl[3]=372; /* line # 372 */
      if (Rv3>3) {
        Ra.sl[3]=373; /* line # 373 */
        if (((G *)Rv4)[5]>1.000000000000000E+000) {
          Ra.sl[3]=375; /* line # 375 */
          ((G *)Rv4)[5]=cos(1.745329251994329E-002*((G *)Rv4)[5]);
          Ra.sl[3]=376; /* line # 376 */
          Lx[0].v[24]=PAS__NEW(16);
          Ra.sl[3]=377; /* line # 377 */
          ((UB *)Lx[0].v[24])[0]=30;
          Ra.sl[3]=378; /* line # 378 */
          ((V *)Lx[0].v[24])[1]=((V *)Rv4)[6];
          Ra.sl[3]=379; /* line # 379 */
          ((V *)Rv4)[6]=Lx[0].v[24];
        }
      }
      Ra.sl[3]=382; /* line # 382 */
      Lx[0].g[Rv3-1]=((G *)Rv4)[5];
    }
    Rv3++;
  }
  Ra.sl[3]=385; /* line # 385 */
  ((UB *)Rv1)[2484]=((UB *)Rv1)[2484]&~1;
  Ra.sl[3]=386; /* line # 386 */
  if (Rv2) ((UB *)Rv1)[2484]=((UB *)Rv1)[2484]|2;
  Ra.sl[3]=388; /* line # 388 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+156,-1,-1,32);
  PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
  PAS__WRITE_STR(Rd.s+170,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=389; /* line # 389 */
  Rv5=1;
  for( Rf0=6;Rf0>0;Rf0-- ) {
    Ra.sl[3]=391; /* line # 391 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(Lx[0].g[Rv5-1],8,4,0);
    PAS__WRITE_CHAR(32);
    Ra.sl[3]=392; /* line # 392 */
    if (Lx[0].ub[Rv5+87]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+198,-1,-1,32);
    }
    else {
      Ra.sl[3]=393; /* line # 393 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+202,-1,-1,32);
    }
    Rv5++;
  }
  Ra.sl[3]=395; /* line # 395 */
  if (Rv2) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+206,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=396; /* line # 396 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+218,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cryst_phase_compute "  */
void P_cryst_phase_compute(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  UB Rv2;
  SL Rv3;
  G Rv4;
  G Rv5;
  G Rv6;
  G Rv7;
  G Rv8;
  UB Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  G Rv14;
  G Rv15;
  G Rv16;
  G Rv17;
  G Rv18;
  G Rv19;
  G Rv20;
  G Rv21;
  G Rv22;
  G Rv23;
  G Rv24;
  G Rv25;
  G Rv26;
  G Rv27;
  SL Rv28;
  SL Rv29;
  SL Rv30;
  G Rv31;
  G Rv32;
  G Rv33;
  G Rv34;
  G Rv35;
  G Rv36;
  SL Rv37;
  SL Rv38;
  SL Rv39;
  SL Rv40;
  SL Rv41;
  SL Rv42;
  SL Rv43;
  register G Rgg;
  register int Rf1, Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[25]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+100;
  Ra.v[26]=Rd.s+236;
  Ra.v[27]=Rd.s+6;
  Ra.sl[28]=403; /* line # 403 */
  Rv0=F_p;
  Rv1=Rv0+112;
  Ra.sl[28]=405; /* line # 405 */
  if (1&((UB *)Rv1)[2484]) {
    Ra.sl[28]=407; /* line # 407 */
    MXD_CRY_RTL_PRC_00000001(F_p);
    Rv2=1;
  }
  else {
    Ra.sl[28]=411; /* line # 411 */
    Rv3=1;
    for( Rf1=6;Rf1>0;Rf1-- ) {
      Ra.sl[28]=413; /* line # 413 */
      if (((V *)Rv0)[Rv3+20]==NULL) {
        Ra.sl[28]=414; /* line # 414 */
        Ra.ub[Rv3+87]=1;
        Ra.g[Rv3-1]=0.000000000000000E-001;
      }
      else {
        Ra.sl[28]=417; /* line # 417 */
        Ra.ub[Rv3+87]=((UB *)Rv0)[21]==2;
        Ra.sl[28]=418; /* line # 418 */
        Ra.g[Rv3-1]=((G *)((V *)Rv0)[Rv3+20])[5];
      }
      Rv3++;
    }
    Ra.sl[28]=421; /* line # 421 */
    Rv2=0;
  }
  Ra.sl[28]=425; /* line # 425 */
  Rv4=PAS__G_SQR(Ra.g[3]);
  Rv5=PAS__G_SQR(Ra.g[4]);
  Rv6=PAS__G_SQR(Ra.g[5]);
  Ra.sl[28]=426; /* line # 426 */
  Rv7=(Ra.g[0]*Ra.g[1])*Ra.g[2];
  Ra.sl[28]=427; /* line # 427 */
  Rv8=sqrt((((1.000000000000000E+000+((2.000000000000000E+000*Ra.g[3])*Ra.g[4])*
  Ra.g[5])-Rv4)-Rv5)-Rv6);
  Ra.sl[28]=428; /* line # 428 */
  Ra.g[6]=Rv7*Rv8;
  Ra.sl[28]=431; /* line # 431 */
  if (Ra.g[6]<1.000000000000001E-009) P_exec_error(Rd.s+259,21,4,((V *)Rv0)[3]);
  Ra.sl[28]=433; /* line # 433 */
  if (8&((UB *)Rv1)[2484]) {
    Ra.sl[28]=435; /* line # 435 */
    if (((fabs(1.000000000000000E+000-Ra.g[1]/Ra.g[0])>1.000000000000001E-006||fabs
    (1.000000000000000E+000-Ra.g[2]/Ra.g[0])>1.000000000000001E-006)||fabs(Ra.g[
3]-Ra.g[4])>1.000000000000001E-006)||fabs(Ra.g[3]-Ra.g[5])>1.000000000000001E-006)
     {
      Ra.sl[28]=437; /* line # 437 */
      P_exec_error(Rd.s+259,22,4,((V *)Rv0)[3]);
    }
  }
  Ra.sl[28]=439; /* line # 439 */
  Ra.g[10]=sqrt(1.000000000000000E+000-Rv4);
  Ra.g[8]=sqrt(1.000000000000000E+000-Rv5);
  Ra.g[9]=sqrt(1.000000000000000E+000-Rv6);
  Ra.sl[28]=442; /* line # 442 */
  if (Ra.g[6]>=1.000000000000000E+000) {
    Ra.sl[28]=443; /* line # 443 */
    MXD_CRY_RTL_PRC_00000000(Rv1,Rv1+336,Rv1+1344,Rv1+1400);
  }
  else {
    Ra.sl[28]=446; /* line # 446 */
    ((UB *)Rv1)[2484]=((UB *)Rv1)[2484]|4;
    Rv9=1;
    Ra.sl[28]=447; /* line # 447 */
    MXD_CRY_RTL_PRC_00000000(Rv1+336,Rv1,Rv1+1400,Rv1+1344);
    Ra.sl[28]=448; /* line # 448 */
    Ra.g[6]=1.000000000000000E+000/Ra.g[6];
  }
  Ra.sl[28]=451; /* line # 451 */
  P_update_virtvar(Rv1,6,6);
  Ra.sl[28]=452; /* line # 452 */
  P_update_virtvar(Rv1+1344,1,12);
  Ra.sl[28]=453; /* line # 453 */
  P_update_virtvar(Rv1+336,6,13);
  Ra.sl[28]=454; /* line # 454 */
  P_update_virtvar(Rv1+1400,1,19);
  Ra.sl[28]=457; /* line # 457 */
  MXD_CRY_RTL_set_mtens_values(Rv1+672,Rv1);
  Ra.sl[28]=458; /* line # 458 */
  MXD_CRY_RTL_set_mtens_values(Rv1+1008,Rv1+336);
  Ra.sl[28]=460; /* line # 460 */
  P_update_virtvar(Rv1+672,6,20);
  Ra.sl[28]=461; /* line # 461 */
  P_update_virtvar(Rv1+1008,6,26);
  Ra.sl[28]=463; /* line # 463 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=464; /* line # 464 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+263,-1,-1,32);
  Ra.sl[28]=465; /* line # 465 */
  Rv10=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[Rv10*7-7],14,6,0);
    Rv10++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+284,-1,-1,32);
  PAS__WRITE_DBLE(((G *)Rv1)[168],14,6,0);
  PAS__WRITE_EOLN();
  Ra.sl[28]=466; /* line # 466 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+291,-1,-1,32);
  Ra.sl[28]=467; /* line # 467 */
  Rv11=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[Rv11*7+35],14,8,0);
    Rv11++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+312,-1,-1,32);
  PAS__WRITE_DBLE(((G *)Rv1)[175],14,8,0);
  PAS__WRITE_EOLN();
  Ra.sl[28]=469; /* line # 469 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=470; /* line # 470 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+319,-1,-1,32);
  Ra.sl[28]=471; /* line # 471 */
  Rv12=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[Rv12*7+77],14,4,0);
    Rv12++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=472; /* line # 472 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+349,-1,-1,32);
  Ra.sl[28]=473; /* line # 473 */
  Rv13=1;
  for( Rf1=6;Rf1>0;Rf1-- ) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv1)[Rv13*7+119],14,4,0);
    Rv13++;
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=476; /* line # 476 */
  Rv14=((G *)Rv1)[0];
  Rv15=((G *)Rv1)[7];
  Rv16=((G *)Rv1)[14];
  Ra.sl[28]=477; /* line # 477 */
  Rv17=((G *)Rv1)[21];
  Rv18=((G *)Rv1)[28];
  Rv19=((G *)Rv1)[35];
  Ra.sl[28]=479; /* line # 479 */
  if (8&((UB *)Rv1)[2484]) {
    Ra.sl[28]=481; /* line # 481 */
    Rv7=sqrt(1.000000000000000E+000-Rv17);
    Rv8=sqrt(1.000000000000000E+000+2.000000000000000E+000*Rv17);
    Ra.sl[28]=482; /* line # 482 */
    Ra.g[8]=(Rv8+2.000000000000000E+000*Rv7)/3.000000000000000E+000;
    Ra.sl[28]=483; /* line # 483 */
    Ra.g[9]=(Rv8-Rv7)/3.000000000000000E+000;
    Ra.sl[28]=484; /* line # 484 */
    Rv5=(1.000000000000000E+000/Rv8-1.000000000000000E+000/Rv7)/3.000000000000000E+000;
    Ra.sl[28]=485; /* line # 485 */
    Rv6=(1.000000000000000E+000/Rv8+5.000000000000000E-001/Rv7)/3.000000000000000E+000;
    Ra.sl[28]=488; /* line # 488 */
    MXD_CRY_RTL_set_vderv(Rv1+1456,Rv1,6, Rv14*Ra.g[8],Ra.g[8],0.000000000000000E-001,
0.000000000000000E-001, Rv14*Rv5,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=489; /* line # 489 */
    MXD_CRY_RTL_set_vderv(Rv1+1512,Rv1,6, Rv14*Ra.g[9],Ra.g[9],0.000000000000000E-001,
0.000000000000000E-001, Rv14*Rv6,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=490; /* line # 490 */
    memcpy(Rv1+1568,Rv1+1512,56);
    Ra.sl[28]=491; /* line # 491 */
    memcpy(Rv1+1624,Rv1+1512,56);
    Ra.sl[28]=492; /* line # 492 */
    memcpy(Rv1+1680,Rv1+1456,56);
    Ra.sl[28]=493; /* line # 493 */
    memcpy(Rv1+1736,Rv1+1512,56);
    Ra.sl[28]=494; /* line # 494 */
    memcpy(Rv1+1792,Rv1+1512,56);
    Ra.sl[28]=495; /* line # 495 */
    memcpy(Rv1+1848,Rv1+1512,56);
    Ra.sl[28]=496; /* line # 496 */
    memcpy(Rv1+1904,Rv1+1456,56);
    Ra.sl[28]=501; /* line # 501 */
    Rv20=((G *)Rv1)[42];
    Ra.sl[28]=502; /* line # 502 */
    Rv21=((G *)Rv1)[63];
    Ra.sl[28]=503; /* line # 503 */
    Rv7=sqrt(1.000000000000000E+000-Rv21);
    Rv8=sqrt(1.000000000000000E+000+2.000000000000000E+000*Rv21);
    Ra.sl[28]=504; /* line # 504 */
    Ra.g[8]=(Rv8+2.000000000000000E+000*Rv7)/3.000000000000000E+000;
    Ra.sl[28]=505; /* line # 505 */
    Ra.g[9]=(Rv8-Rv7)/3.000000000000000E+000;
    Ra.sl[28]=506; /* line # 506 */
    Rv5=(1.000000000000000E+000/Rv8-1.000000000000000E+000/Rv7)/3.000000000000000E+000;
    Ra.sl[28]=507; /* line # 507 */
    Rv6=(1.000000000000000E+000/Rv8+5.000000000000000E-001/Rv7)/3.000000000000000E+000;
    Ra.sl[28]=510; /* line # 510 */
    MXD_CRY_RTL_set_vderv(Rv1+1960,Rv1+336,6, Rv14*Ra.g[8],Ra.g[8],0.000000000000000E-001,
0.000000000000000E-001, Rv14*Rv5,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=511; /* line # 511 */
    MXD_CRY_RTL_set_vderv(Rv1+2016,Rv1+336,6, Rv14*Ra.g[9],Ra.g[9],0.000000000000000E-001,
0.000000000000000E-001, Rv14*Rv6,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=512; /* line # 512 */
    memcpy(Rv1+2072,Rv1+2016,56);
    Ra.sl[28]=513; /* line # 513 */
    memcpy(Rv1+2128,Rv1+2016,56);
    Ra.sl[28]=514; /* line # 514 */
    memcpy(Rv1+2184,Rv1+1960,56);
    Ra.sl[28]=515; /* line # 515 */
    memcpy(Rv1+2240,Rv1+2016,56);
    Ra.sl[28]=516; /* line # 516 */
    memcpy(Rv1+2296,Rv1+2016,56);
    Ra.sl[28]=517; /* line # 517 */
    memcpy(Rv1+2352,Rv1+2016,56);
    Ra.sl[28]=518; /* line # 518 */
    memcpy(Rv1+2408,Rv1+1960,56);
  }
  else {
    Ra.sl[28]=522; /* line # 522 */
    Ra.g[9]=sqrt(1.000000000000000E+000-Rv19*Rv19);
    Ra.sl[28]=523; /* line # 523 */
    Ra.g[10]=(Rv17-Rv18*Rv19)/Ra.g[9];
    Ra.sl[28]=524; /* line # 524 */
    Rv7=(-Rv18*(1.000000000000000E+000+PAS__G_SQR(Rv19/Ra.g[9])))/Ra.g[9];
    Ra.sl[28]=525; /* line # 525 */
    Rv8=sqrt((1.000000000000000E+000-PAS__G_SQR(Ra.g[10]))-Rv18*Rv18);
    Ra.sl[28]=526; /* line # 526 */
    Rv4=-Ra.g[10]/(Rv8*Ra.g[9]);
    Ra.sl[28]=527; /* line # 527 */
    Rv5=((Ra.g[10]*Rv19)/Ra.g[9]-Rv18)/Rv8;
    Ra.sl[28]=528; /* line # 528 */
    Rv6=(-Ra.g[10]*Rv7)/Rv8;
    Ra.sl[28]=530; /* line # 530 */
    Rv22=Rv14;
    Rv23=Rv15*Rv19;
    Rv24=Rv16*Rv18;
    Ra.sl[28]=531; /* line # 531 */
    Rv25=Rv15*Ra.g[9];
    Rv26=Rv16*Ra.g[10];
    Ra.sl[28]=532; /* line # 532 */
    Rv27=Rv16*Rv8;
    Ra.sl[28]=535; /* line # 535 */
    MXD_CRY_RTL_set_vderv(Rv1+1456,Rv1,6, Rv22,1.000000E+00,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=536; /* line # 536 */
    MXD_CRY_RTL_set_vderv(Rv1+1512,Rv1,6, Rv23,0.000000000000000E-001, Rv19,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001, Rv15,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001);
    Ra.sl[28]=537; /* line # 537 */
    MXD_CRY_RTL_set_vderv(Rv1+1568,Rv1,6, Rv24,0.000000000000000E-001,0.000000000000000E-001,
    Rv18,0.000000000000000E-001, Rv16,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=538; /* line # 538 */
    Rv28=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv28+203]=0.000000000000000E-001;
      Rv28++;
    }
    Ra.sl[28]=539; /* line # 539 */
    MXD_CRY_RTL_set_vderv(Rv1+1680,Rv1,6, Rv25,0.000000000000000E-001, Ra.g[9],0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,(-Rv15*Rv19)/Ra.g[9],0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=540; /* line # 540 */
    MXD_CRY_RTL_set_vderv(Rv1+1736,Rv1,6, Rv26,0.000000000000000E-001,0.000000000000000E-001,
    Ra.g[10],Rv16/Ra.g[9],(-Rv16*Rv19)/Ra.g[9],Rv16*Rv7,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001);
    Ra.sl[28]=541; /* line # 541 */
    Rv29=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv29+224]=0.000000000000000E-001;
      Rv29++;
    }
    Ra.sl[28]=542; /* line # 542 */
    Rv30=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv30+231]=0.000000000000000E-001;
      Rv30++;
    }
    Ra.sl[28]=543; /* line # 543 */
    MXD_CRY_RTL_set_vderv(Rv1+1904,Rv1,6, Rv27,0.000000000000000E-001,0.000000000000000E-001,
    Rv8, Rv16*Rv4, Rv16*Rv5, Rv16*Rv6,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001);
    Ra.sl[28]=547; /* line # 547 */
    Ra.g[7]=Rv23*Rv26-Rv24*Rv25;
    Rv7=(Rv31*Rv32)*Rv33;
    Ra.sl[28]=549; /* line # 549 */
    Rv31=1.000000000000000E+000/Rv14;
    Rv34=(-Rv23*Rv31)*Rv33;
    Rv35=Ra.g[7]*Rv7;
    Ra.sl[28]=550; /* line # 550 */
    Rv32=1.000000000000000E+000/Rv25;
    Rv36=(-Rv26*Rv32)*Rv33;
    Ra.sl[28]=551; /* line # 551 */
    Rv33=1.000000000000000E+000/Rv27;
    Ra.sl[28]=555; /* line # 555 */
    MXD_CRY_RTL_set_vderv(Rv1+1960,Rv1+1456,9, Rv31,-Rv31*Rv31,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=556; /* line # 556 */
    MXD_CRY_RTL_set_vderv(Rv1+2016,Rv1+1456,9, Rv34,-Rv34*Rv31, Rv31*Rv33,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,-Rv34*Rv33);
    Ra.sl[28]=557; /* line # 557 */
    MXD_CRY_RTL_set_vderv(Rv1+2072,Rv1+1456,9, Rv35,-Rv35*Rv31, Rv26*Rv7,-Rv25*Rv7,
0.000000000000000E-001,((Rv23*Rv26)*Rv7)*Rv32, Rv23*Rv7,0.000000000000000E-001,0.000000000000000E-001,-
    Rv35*Rv33);
    Ra.sl[28]=558; /* line # 558 */
    Rv37=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv37+266]=0.000000000000000E-001;
      Rv37++;
    }
    Ra.sl[28]=559; /* line # 559 */
    MXD_CRY_RTL_set_vderv(Rv1+2184,Rv1+1456,9, Rv32,-Rv32*Rv32,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001);
    Ra.sl[28]=560; /* line # 560 */
    MXD_CRY_RTL_set_vderv(Rv1+2240,Rv1+1456,9, Rv36,-Rv35*Rv31,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,-Rv36*Rv32,-Rv32*Rv33,0.000000000000000E-001,
0.000000000000000E-001,-Rv36*Rv33);
    Ra.sl[28]=561; /* line # 561 */
    Rv38=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv38+287]=0.000000000000000E-001;
      Rv38++;
    }
    Ra.sl[28]=562; /* line # 562 */
    Rv39=0;
    for( Rf1=7;Rf1>0;Rf1-- ) {
      ((G *)Rv1)[Rv39+294]=0.000000000000000E-001;
      Rv39++;
    }
    Ra.sl[28]=563; /* line # 563 */
    MXD_CRY_RTL_set_vderv(Rv1+2408,Rv1+1456,9, Rv33,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,0.000000000000000E-001,
0.000000000000000E-001,0.000000000000000E-001,-Rv33*Rv33);
  }
  Ra.sl[28]=566; /* line # 566 */
  P_update_virtvar(Rv1+1456,9,32);
  Ra.sl[28]=567; /* line # 567 */
  P_update_virtvar(Rv1+1960,9,41);
  Ra.sl[28]=570; /* line # 570 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=571; /* line # 571 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+379,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[28]=572; /* line # 572 */
  Rv40=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[28]=574; /* line # 574 */
    Rv41=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)Rv1)[((3*Rv40+Rv41)-3)*7+175],14,6,0);
      Rv41++;
    }
    Ra.sl[28]=575; /* line # 575 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Rv40++;
  }
  Ra.sl[28]=577; /* line # 577 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[28]=579; /* line # 579 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+392,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[28]=580; /* line # 580 */
  Rv42=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[28]=582; /* line # 582 */
    Rv43=1;
    for( Rf0=3;Rf0>0;Rf0-- ) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_DBLE(((G *)Rv1)[((3*Rv42+Rv43)-3)*7+238],14,6,0);
      Rv43++;
    }
    Ra.sl[28]=583; /* line # 583 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Rv42++;
  }
  Ra.sl[28]=585; /* line # 585 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[25];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " genere_new_oper "  */
V MXD_CRY_RTL_PRC_00000002(V F_ph, SL *F_ic){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=8;
  Ra.v[3]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+12;
  Ra.v[4]=Rd.s+405;
  Ra.v[5]=Rd.s+6;
  Ra.sl[6]=616; /* line # 616 */
  (*F_ic)=(*F_ic)+1;
  Ra.sl[6]=617; /* line # 617 */
  Rv0=PAS__NEW(112);
  Ra.sl[6]=618; /* line # 618 */
  Rv1=Rv0;
  Ra.sl[6]=620; /* line # 620 */
  ((UB *)Rv1)[0]=62;
  Ra.sl[6]=621; /* line # 621 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=622; /* line # 622 */
  ((V *)Rv1)[2]=NULL;
  Ra.sl[6]=623; /* line # 623 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_STR(Rd.s+422,-1,-1,32);
  PAS__WRITE_INT((*F_ic),-2,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=624; /* line # 624 */
  Rv2=Lx[1].ub[1];
  ((V *)Rv1)[3]=PAS__NEW((SL)Rv2+2);
  ((UB *)((V *)Rv1)[3])[0]=Rv2;
  Ra.sl[6]=625; /* line # 625 */
  PAS__STR_TO_STR(((V *)Rv1)[3],Ra.s);
  Ra.sl[6]=626; /* line # 626 */
  ((SL *)Rv1)[4]= -(*F_ic);
  Ra.sl[6]=627; /* line # 627 */
  ((UB *)Rv1)[20]=15;
  Ra.sl[6]=628; /* line # 628 */
  P_queue_object(((V *)F_ph)+6,((V *)F_ph)+7,Rv0);
  Ra.sl[6]=630; /* line # 630 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[3];
  return(Ret);
}


/* Procedure/Function : " cryst_group_set "  */
void P_cryst_group_set(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 352 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;
  V Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  UB Rv21;
  UB Rv22;
  UB Rv23;
  V Rv24;
  SL Rv25;
  SL Rv26;
  SL Rv27;
  SL Rv28;
  register int Rf2, Rf1, Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Rv0=NULL;
  Ra.ub[257]=62;
  Ra.v[81]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+324;
  Ra.v[82]=Rd.s+428;
  Ra.v[83]=Rd.s+6;
  Ra.sl[84]=635; /* line # 635 */
  Rv1=F_p;
  Rv2=Rv1+112;
  Ra.sl[84]=636; /* line # 636 */
  if ((((V *)Rv1)[6]==NULL&&!(16&((UB *)Rv2)[2484]))&&((UB *)Rv2)[2468]>1) {
    Ra.sl[84]=640; /* line # 640 */
    Rv3=0;
    Ra.sl[84]=642; /* line # 642 */
    Rv4=1;
    Ra.sl[84]=643; /* line # 643 */
    while (Rv4<=((UB *)Rv2)[2468]&&((C *)Rv2)[Rv4+2468]>=32)
    Rv4=Rv4+1;
    Ra.sl[84]=644; /* line # 644 */
    Rv4=Rv4-1;
    Ra.sl[84]=646; /* line # 646 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+445,-1,-1,32);
    PAS__WRITE_CHT(Rv2+2469,15, Rv4,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Rd.s+468,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[84]=647; /* line # 647 */
    Rv5=PAS__CREATE_PROC_1(Rd.s+486,Ra.s,0,NULL);
    Ra.sl[84]=648; /* line # 648 */
    if (Rv5>0) {
      Ra.sl[84]=650; /* line # 650 */
      Rv4=PAS__WAIT_PROCESS(&Rv6, Rv5);
      Ra.sl[84]=651; /* line # 651 */
      if (Rv6!=0) P_exec_error(Rd.s+510,23,4,((V *)Rv1)[3]);
      else {
        Ra.sl[84]=652; /* line # 652 */
        Rv3=1;
      }
    }
    else {
      Ra.sl[84]=654; /* line # 654 */
      P_exec_error(Rd.s+510,24,4,((V *)Rv1)[3]);
    }
    Ra.sl[84]=661; /* line # 661 */
    if (Rv3) {
      Ra.sl[84]=663; /* line # 663 */
      PAS__OPEN(&Rv0,0, Rd.s+468,6145,0,-1);
      Ra.sl[84]=664; /* line # 664 */
      if (PAS__iostatus!=0) {
        Ra.sl[84]=666; /* line # 666 */
        P_exec_error(Rd.s+510,26,4,((V *)Rv1)[3]);
        Ra.sl[84]=667; /* line # 667 */
        Rv3=0;
      }
    }
    Ra.sl[84]=670; /* line # 670 */
    if (Rv3) {
      Ra.sl[84]=672; /* line # 672 */
      PAS__SELECT_INP(Rv0);
      PAS__READ_STR(Ra.s+257,0,1);
      PAS__READ_CHT(Rv2+2469,15,0,1);
      PAS__READ_SL(((SL *)Rv2)+616,0);
      PAS__READ_SL(&Rv7,0);
      PAS__READ_SL(&Rv8,0);
      PAS__READ_SL(&Rv9,0);
      PAS__READ_EOLN();
      Ra.sl[84]=674; /* line # 674 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+514,-1,-1,32);
      PAS__WRITE_STR(Ra.s+257,-1,-1,32);
      PAS__WRITE_STR(Rd.s+527,-1,-1,32);
      PAS__WRITE_CHT(Rv2+2469,15,((UB *)Rv2)[2468],-1,32);
      PAS__WRITE_STR(Rd.s+545,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv2)[616],0,0);
      PAS__WRITE_STR(Rd.s+559,-1,-1,32);
      PAS__WRITE_INT(Rv8,0,0);
      PAS__WRITE_EOLN();
      Ra.sl[84]=676; /* line # 676 */
      Rv10=0;
      Ra.sl[84]=678; /* line # 678 */
      PAS__SELECT_INP(Rv0);
      PAS__READ_SL(&Rv11,0);
      Ra.sl[84]=679; /* line # 679 */
      for( Rf2=Rv11;Rf2>0;Rf2-- ) {
        Ra.sl[84]=681; /* line # 681 */
        PAS__SELECT_INP(Rv0);
        PAS__READ_SL(&Rv12,0);
        Ra.sl[84]=682; /* line # 682 */
        if (Rv9<0&&Rv12<0) {
          PAS__SELECT_INP(Rv0);
          PAS__READ_EOLN();
        }
        else {
          Ra.sl[84]=685; /* line # 685 */
          Rv13=MXD_CRY_RTL_PRC_00000002(F_p, &Rv10);
          Ra.sl[84]=686; /* line # 686 */
          Rv14=1;
          for( Rf1=3;Rf1>0;Rf1-- ) {
            Rv15=1;
            for( Rf0=4;Rf0>0;Rf0-- ) {
              PAS__SELECT_INP(Rv0);
              PAS__READ_UB((((UB *)Rv13)+Rv14*4+Rv15+16),0);
              Rv15++;
            }
            Rv14++;
          }
        }
      }
      Ra.sl[84]=689; /* line # 689 */
      PAS__CLOSE(&Rv0,0);
    }
    else {
      Ra.sl[84]=693; /* line # 693 */
      Rv16=((V *)F_p)[6];
      Ra.sl[84]=695; /* line # 695 */
      Rv17=Rv16;
      Rv10=0;
      Ra.sl[84]=696; /* line # 696 */
      while (Rv17!=NULL){
        Rv10=Rv10+1;
        Rv17=((V *)Rv17)[1];
      }
      Ra.sl[84]=698; /* line # 698 */
      while (Rv16!=NULL){
        Ra.sl[84]=700; /* line # 700 */
        Rv17=Rv16;
        Ra.sl[84]=701; /* line # 701 */
        Ra.sl[84]=702; /* line # 702 */
        while (Rv17!=NULL){
          Ra.sl[84]=704; /* line # 704 */
          Rv18=0;
          Ra.sl[84]=705; /* line # 705 */
          Rv19=1;
          for( Rf2=3;Rf2>0;Rf2-- ) {
            Rv20=1;
            for( Rf1=3;Rf1>0;Rf1-- ) {
              Ra.sl[84]=707; /* line # 707 */
              Ra.ub[Rv19*4+Rv20+335]=(((UB *)Rv16)[Rv19*4+17]*((UB *)Rv17)[Rv20+
20]+((UB *)Rv16)[Rv19*4+18]*((UB *)Rv17)[Rv20+24])+((UB *)Rv16)[Rv19*4+19]*((UB *)
              Rv17)[Rv20+28];
              Ra.sl[84]=710; /* line # 710 */
              if (Ra.ub[Rv19*4+Rv20+335]!=0) Rv18=Rv18+1;
              Rv20++;
            }
            Rv19++;
          }
          Ra.sl[84]=712; /* line # 712 */
          Rv21=0;
          Rv22=0;
          Ra.sl[84]=713; /* line # 713 */
          if (Rv18==3) {
            Ra.sl[84]=714; /* line # 714 */
            if ((abs(Ra.ub[340])==1&&Ra.ub[340]==Ra.ub[345])&&Ra.ub[340]==Ra.ub[
350]) {
              Ra.sl[84]=715; /* line # 715 */
              if (Ra.ub[340]>0) Rv21=1;
              else {
                Ra.sl[84]=716; /* line # 716 */
                Rv22=1;
              }
            }
          }
          Ra.sl[84]=717; /* line # 717 */
          Rv23=16&((UB *)Rv2)[2484]&&Rv22;
          Ra.sl[84]=718; /* line # 718 */
          Rv24=((V *)F_p)[6];
          Ra.sl[84]=719; /* line # 719 */
          while (Rv24!=NULL&&!Rv23){
            Ra.sl[84]=721; /* line # 721 */
            Rv25=1;
            for( Rf2=3;Rf2>0;Rf2-- ) {
              Rv26=1;
              for( Rf1=3;Rf1>0;Rf1-- ) {
                Ra.sl[84]=722; /* line # 722 */
                if (Ra.ub[Rv25*4+Rv26+335]!=((UB *)Rv24)[Rv25*4+Rv26+16]) {
                  Rv23=1;
                   break;
                }
                Rv26++;
              }
              Rv25++;
            }
            Ra.sl[84]=723; /* line # 723 */
            if (!Rv23&&16&((UB *)Rv2)[2484]) {
              Ra.sl[84]=724; /* line # 724 */
              Rv27=1;
              for( Rf2=3;Rf2>0;Rf2-- ) {
                Rv28=1;
                for( Rf1=3;Rf1>0;Rf1-- ) {
                  Ra.sl[84]=725; /* line # 725 */
                  if (Ra.ub[Rv27*4+Rv28+335]!= -((UB *)Rv24)[Rv27*4+Rv28+16]) {
                    Rv23=1;
                     break;
                  }
                  Rv28++;
                }
                Rv27++;
              }
            }
            Ra.sl[84]=726; /* line # 726 */
            if (!Rv23) {
              Ra.sl[84]=728; /* line # 728 */
              Rv13=MXD_CRY_RTL_PRC_00000002(F_p, &Rv10);
              Ra.sl[84]=729; /* line # 729 */
              memcpy(Rv13+21,Ra.s+340,12);
            }
          }
          Ra.sl[84]=732; /* line # 732 */
          Rv17=((V *)Rv17)[1];
        }
        Ra.sl[84]=734; /* line # 734 */
        Rv16=((V *)Rv16)[1];
      }
    }
  }
  PAS__curr_cntx=Ra.v[81];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " data_hkl_complete "  */
void MXD_CRY_RTL_data_hkl_complete(V F_p, SL F_asz){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  G Rv4;
  G Rv5;
  G Rv6;
  G Rv7;
  SL Rv8;
  SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  register V Rv14;
  SL Rv15;
  register V Rv16;
  SL Rv17;
  register V Rv18;
  register G Rgg;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+574;
  Ra.v[67]=Rd.s+6;
  Ra.sl[68]=755; /* line # 755 */
  Rv0=F_asz;
  Ra.sl[68]=757; /* line # 757 */
  Rv1=V_interphde;
  Ra.sl[68]=758; /* line # 758 */
  while (Rv1!=NULL){
    Ra.sl[68]=759; /* line # 759 */
    Rv2=Rv1;
    Ra.sl[68]=761; /* line # 761 */
    Rv0=Rv0+1;
    Ra.sl[68]=762; /* line # 762 */
    ((SL *)Rv2)[4]=Rv0;
    Ra.sl[68]=763; /* line # 763 */
    Rv1=((V *)Rv2)[1];
  }
  Ra.sl[68]=765; /* line # 765 */
  if (Rv0>255) P_exec_error(Rd.s+595,33,4, NULL);
  Ra.sl[68]=768; /* line # 768 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+599,-1,-1,32);
  PAS__WRITE_INT(Rv0,0,0);
  PAS__WRITE_STR(Rd.s+617,-1,-1,32);
  PAS__WRITE_STR(((V *)F_p)[3],-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  Ra.sl[68]=770; /* line # 770 */
  PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,V_dat_inp));
  Ra.sl[68]=772; /* line # 772 */
  PAS__OPEN(&V_dat_out,1, Rd.s+672,4106,0,-1);
  Ra.sl[68]=773; /* line # 773 */
  if (PAS__iostatus!=0) P_exec_error(Rd.s+595,33,4, Rd.s+672);
  Ra.sl[68]=775; /* line # 775 */
  P_write_datf_st(Rd.s+691);
  Ra.sl[68]=776; /* line # 776 */
  P_write_datf_sl(Rv0);
  Ra.sl[68]=777; /* line # 777 */
  P_write_datf_sl(0);
  Ra.sl[68]=778; /* line # 778 */
  P_write_datf_db(0.000000E-01);
  P_write_datf_db(0.000000E-01);
  Ra.sl[68]=779; /* line # 779 */
  P_write_datf_db(0.000000E-01);
  P_write_datf_db(0.000000E-01);
  Ra.sl[68]=781; /* line # 781 */
  Rv3=V_dat_byte_count;
  Ra.sl[68]=783; /* line # 783 */
  Rv4=0.000000000000000E-001;
  Rv5=0.000000000000000E-001;
  Rv6=0.000000000000000E-001;
  Rv7=0.000000000000000E-001;
  Ra.sl[68]=784; /* line # 784 */
  Rv8=0;
  Rv9=-1;
  Rv10=0;
  Rv11=0;
  Ra.sl[68]=786; /* line # 786 */
  Ra.sl[68]=787; /* line # 787 */
  for( Rf1=((SL *)F_p)[10];Rf1>0;Rf1-- ) {
    Ra.sl[68]=791; /* line # 791 */
    P_read_datf_sl(V_curr_data.sl);
    P_read_datf_sl(V_curr_data.sl+1);
    P_read_datf_sl(V_curr_data.sl+2);
    Ra.sl[68]=792; /* line # 792 */
    P_read_datf_sl(V_curr_data.sl+3);
    P_read_datf_sl(V_curr_data.sl+4);
    P_read_datf_sl(V_curr_data.sl+5);
    Ra.sl[68]=793; /* line # 793 */
    P_read_datf_sl(V_curr_data.sl+6);
    P_read_datf_sl(V_curr_data.sl+7);
    P_read_datf_sl(V_curr_data.sl+8);
    Ra.sl[68]=794; /* line # 794 */
    P_read_datf_sl(V_curr_data.sl+9);
    P_read_datf_sl(V_curr_data.sl+10);
    Ra.sl[68]=795; /* line # 795 */
    P_read_datf_db(V_curr_data.g+16);
    P_read_datf_db(V_curr_data.g+17);
    P_read_datf_db(V_curr_data.g+18);
    Ra.sl[68]=796; /* line # 796 */
    Rv12=1;
    for( Rf0=F_asz;Rf0>0;Rf0-- ) {
      P_read_datf_db((V_curr_data.g+Rv12+18));
      Rv12++;
    }
    Ra.sl[68]=798; /* line # 798 */
    if (V_curr_data.sl[8]!=Rv9) {
      Ra.sl[68]=800; /* line # 800 */
      if (V_curr_data.sl[8]==0) {
        V_cphas=V_phashde;
        V_curr_data.sl[8]=((SL *)V_cphas)[4];
      }
      else {
        Ra.sl[68]=801; /* line # 801 */
        V_cphas=P_get_reference(V_curr_data.sl[8]);
      }
      Ra.sl[68]=802; /* line # 802 */
      Rv9=V_curr_data.sl[8];
    }
    Ra.sl[68]=804; /* line # 804 */
    if (V_curr_data.sl[6]!=Rv10) {
      Ra.sl[68]=806; /* line # 806 */
      if (V_curr_data.sl[6]==0) V_cwave=NULL;
      else {
        Ra.sl[68]=807; /* line # 807 */
        V_cwave=P_get_reference(V_curr_data.sl[6]);
      }
      Ra.sl[68]=808; /* line # 808 */
      Rv10=V_curr_data.sl[6];
    }
    Ra.sl[68]=810; /* line # 810 */
    if (V_curr_data.sl[7]!=Rv11) {
      Ra.sl[68]=812; /* line # 812 */
      if (V_curr_data.sl[7]==0) V_cpola=NULL;
      else {
        Ra.sl[68]=813; /* line # 813 */
        V_cpola=P_get_reference(V_curr_data.sl[7]);
      }
      Ra.sl[68]=814; /* line # 814 */
      Rv11=V_curr_data.sl[7];
    }
    Ra.sl[68]=818; /* line # 818 */
    Rv13=V_cphas+112;
    Ra.sl[68]=821; /* line # 821 */
    V_curr_data.g[6]=(((G *)Rv13)[245]*(double)V_curr_data.sl[0]+((G *)Rv13)[252]
    *(double)V_curr_data.sl[1])+((G *)Rv13)[259]*(double)V_curr_data.sl[2];
    Ra.sl[68]=822; /* line # 822 */
    V_curr_data.g[7]=(((G *)Rv13)[266]*(double)V_curr_data.sl[0]+((G *)Rv13)[273]
    *(double)V_curr_data.sl[1])+((G *)Rv13)[280]*(double)V_curr_data.sl[2];
    Ra.sl[68]=823; /* line # 823 */
    V_curr_data.g[8]=(((G *)Rv13)[287]*(double)V_curr_data.sl[0]+((G *)Rv13)[294]
    *(double)V_curr_data.sl[1])+((G *)Rv13)[301]*(double)V_curr_data.sl[2];
    Ra.sl[68]=826; /* line # 826 */
    if (V_cwave==NULL) {
      V_curr_data.g[9]=V_curr_data.g[6];
      V_curr_data.g[10]=V_curr_data.g[7];
      V_curr_data.g[11]=V_curr_data.g[8];
    }
    else {
      Ra.sl[68]=828; /* line # 828 */
      Rv14=V_cwave;
      Ra.sl[68]=830; /* line # 830 */
      V_curr_data.g[9]=V_curr_data.g[6]+(double)V_curr_data.sl[3]*((G *)Rv14)[8]
      ;
      V_curr_data.g[10]=V_curr_data.g[7]+(double)V_curr_data.sl[3]*((G *)Rv14)[15]
      ;
      V_curr_data.g[11]=V_curr_data.g[8]+(double)V_curr_data.sl[3]*((G *)Rv14)[22]
      ;
    }
    Ra.sl[68]=833; /* line # 833 */
    V_curr_data.g[15]=5.000000000000000E-001*sqrt((PAS__G_SQR(V_curr_data.g[9])+
    PAS__G_SQR(V_curr_data.g[10]))+PAS__G_SQR(V_curr_data.g[11]));
    Ra.sl[68]=835; /* line # 835 */
    Rv1=V_interphde;
    Rv15=F_asz;
    Ra.sl[68]=836; /* line # 836 */
    while (Rv1!=NULL){
      Ra.sl[68]=837; /* line # 837 */
      Rv16=Rv1;
      Ra.sl[68]=839; /* line # 839 */
      Rv15=Rv15+1;
      Ra.sl[68]=840; /* line # 840 */
      V_curr_data.g[Rv15+18]=P_math_interpol(((V *)Rv16)[3],V_curr_data.g[15]);
      Ra.sl[68]=841; /* line # 841 */
      Rv1=((V *)Rv16)[1];
    }
    Ra.sl[68]=845; /* line # 845 */
    P_write_datf_sl(V_curr_data.sl[0]);
    P_write_datf_sl(V_curr_data.sl[1]);
    P_write_datf_sl(V_curr_data.sl[2]);
    Ra.sl[68]=846; /* line # 846 */
    P_write_datf_sl(V_curr_data.sl[3]);
    P_write_datf_sl(V_curr_data.sl[4]);
    P_write_datf_sl(V_curr_data.sl[5]);
    Ra.sl[68]=847; /* line # 847 */
    P_write_datf_sl(V_curr_data.sl[6]);
    P_write_datf_sl(V_curr_data.sl[7]);
    P_write_datf_sl(V_curr_data.sl[8]);
    Ra.sl[68]=848; /* line # 848 */
    P_write_datf_sl(V_curr_data.sl[9]);
    P_write_datf_sl(V_curr_data.sl[10]);
    Ra.sl[68]=849; /* line # 849 */
    P_write_datf_db(V_curr_data.g[6]);
    P_write_datf_db(V_curr_data.g[7]);
    P_write_datf_db(V_curr_data.g[8]);
    Ra.sl[68]=851; /* line # 851 */
    P_write_datf_db(V_curr_data.g[15]);
    Ra.sl[68]=853; /* line # 853 */
    Rv17=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      P_write_datf_db(V_curr_data.g[Rv17+18]);
      Rv17++;
    }
    Ra.sl[68]=855; /* line # 855 */
    if (V_curr_data.sl[9]>0) {
      Ra.sl[68]=857; /* line # 857 */
      P_write_datf_db(V_curr_data.g[16]);
      P_write_datf_db(V_curr_data.g[17]);
      P_write_datf_db(V_curr_data.g[18]);
      Ra.sl[68]=858; /* line # 858 */
      Rv4=Rv4+PAS__G_SQR(V_curr_data.g[18]*V_curr_data.g[16]);
      Ra.sl[68]=859; /* line # 859 */
      Rv5=Rv5+V_curr_data.g[18]*fabs(V_curr_data.g[16]);
      Ra.sl[68]=860; /* line # 860 */
      Rv6=Rv6+PAS__G_SQR(V_curr_data.g[16]);
      Ra.sl[68]=861; /* line # 861 */
      Rv7=Rv7+fabs(V_curr_data.g[16]);
      Ra.sl[68]=862; /* line # 862 */
      Rv8=Rv8+1;
    }
  }
  Ra.sl[68]=867; /* line # 867 */
  PAS__SEEK(V_dat_out,1);
  Ra.sl[68]=869; /* line # 869 */
  P_write_datf_st(Rd.s+691);
  Ra.sl[68]=870; /* line # 870 */
  P_write_datf_sl(Rv0);
  Ra.sl[68]=871; /* line # 871 */
  P_write_datf_sl(Rv8);
  Ra.sl[68]=872; /* line # 872 */
  P_write_datf_db(Rv4);
  Ra.sl[68]=873; /* line # 873 */
  P_write_datf_db(Rv5);
  Ra.sl[68]=874; /* line # 874 */
  P_write_datf_db(Rv6);
  Ra.sl[68]=875; /* line # 875 */
  P_write_datf_db(Rv7);
  Ra.sl[68]=877; /* line # 877 */
  PAS__CLOSE(&V_dat_out,0);
  Ra.sl[68]=878; /* line # 878 */
  PAS__CLOSE(&V_dat_inp,0);
  Ra.sl[68]=880; /* line # 880 */
  ((SL *)F_p)[15]=Rv8;
  Ra.sl[68]=881; /* line # 881 */
  ((G *)F_p)[9]=Rv7;
  Ra.sl[68]=882; /* line # 882 */
  ((G *)F_p)[10]=Rv6;
  Ra.sl[68]=883; /* line # 883 */
  ((G *)F_p)[11]=Rv5;
  Ra.sl[68]=884; /* line # 884 */
  ((G *)F_p)[12]=Rv4;
  Ra.sl[68]=886; /* line # 886 */
  Rv18=F_p;
  Ra.sl[68]=888; /* line # 888 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+708,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv18)[15],0,0);
  PAS__WRITE_STR(Rd.s+721,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv18)[10],0,0);
  PAS__WRITE_STR(Rd.s+739,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[68]=889; /* line # 889 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+750,-1,-1,32);
  PAS__WRITE_DBLE(Rv4,10,-15,0);
  PAS__WRITE_STR(Rd.s+776,-1,-1,32);
  PAS__WRITE_DBLE(Rv5,10,-15,0);
  PAS__WRITE_STR(Rd.s+780,-1,-1,32);
  PAS__WRITE_DBLE(Rv6,10,-15,0);
  PAS__WRITE_STR(Rd.s+784,-1,-1,32);
  PAS__WRITE_DBLE(Rv7,10,-15,0);
  PAS__WRITE_EOLN();
  Ra.sl[68]=894; /* line # 894 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+788,-1,-1,32);
  PAS__WRITE_STR(Ra.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+799,-1,-1,32);
  PAS__WRITE_STR(Rd.s+672,-1,-1,32);
  PAS__WRITE_CHAR(10);
  PAS__WRITE_STR(Rd.s+815,-1,-1,32);
  PAS__WRITE_STR(Ra.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+822,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[68]=896; /* line # 896 */
  if (!PAS__FILE_REMOVE(Ra.s,0)) P_exec_error(Rd.s+595,34,4,((V *)F_p)[3]);
  Ra.sl[68]=897; /* line # 897 */
  if (!PAS__FILE_RENAME(Rd.s+672,Ra.s,0,0)) P_exec_error(Rd.s+595,35,4,((V *)F_p)
  [3]);
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " data_prf_complete "  */
void MXD_CRY_RTL_data_prf_complete(V F_p, SL F_vsz){

  /* Code of procedure/function */
}


/* Procedure/Function : " cryst_data_complete "  */
void P_cryst_data_complete(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+826;
  Ra.v[67]=Rd.s+6;
  Ra.sl[68]=932; /* line # 932 */
  Rv0=F_p;
  Ra.sl[68]=934; /* line # 934 */
  PAS__OPEN(&V_dat_inp,1,((V *)Rv0)[6],4097,0,-1);
  Ra.sl[68]=935; /* line # 935 */
  if (PAS__iostatus!=0) P_exec_error(Rd.s+849,31,4,((V *)Rv0)[6]);
  Ra.sl[68]=936; /* line # 936 */
  P_read_datf_st(Ra.s);
  Ra.sl[68]=938; /* line # 938 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[68]=939; /* line # 939 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+853,-1,-1,32);
  PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
  PAS__WRITE_STR(Rd.s+869,-1,-1,32);
  PAS__WRITE_STR((Ri.s+((UB *)Rv0)[45]*18),-1,-1,32);
  Ra.sl[68]=940; /* line # 940 */
  switch (((UB *)Rv0)[45]) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:Ra.sl[68]=943; /* line # 943 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+881,-1,-1,32);
    PAS__WRITE_DBLE(((G *)Rv0)[8],8,5,0);
    break;
    case 6:
    case 7:Ra.sl[68]=944; /* line # 944 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+898,-1,-1,32);
    PAS__WRITE_DBLE(((G *)Rv0)[7],8,5,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_DBLE(((G *)Rv0)[8],8,5,0);
    break;
    default:break;
  }
  Ra.sl[68]=947; /* line # 947 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+918,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],0,0);
  PAS__WRITE_STR(Rd.s+926,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[68]=949; /* line # 949 */
  if (((V *)Rv0)[8]!=NULL) {
    Ra.sl[68]=953; /* line # 953 */
    Rv1=((SL *)((V *)Rv0)[8])[0];
    Ra.sl[68]=955; /* line # 955 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+936,-1,-1,32);
    PAS__WRITE_INT(((SL *)((V *)Rv0)[8])[0],0,0);
    PAS__WRITE_STR(Rd.s+944,-1,-1,32);
    Ra.sl[68]=956; /* line # 956 */
    if (Rv1>1) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(115);
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+963,-1,-1,32);
    Ra.sl[68]=957; /* line # 957 */
    Rv2=1;
    for( Rf0=Rv1;Rf0>0;Rf0-- ) {
      Ra.sl[68]=959; /* line # 959 */
      if (Rv2>1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(44);
      }
      Ra.sl[68]=960; /* line # 960 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)((V *)((V *)Rv0)[8])[Rv2+1])[1],-1,-1,32);
      Rv2++;
    }
    Ra.sl[68]=962; /* line # 962 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[68]=965; /* line # 965 */
    Rv1=0;
  }
  Ra.sl[68]=967; /* line # 967 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+968,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[68]=968; /* line # 968 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+990,-1,-1,32);
  PAS__WRITE_STR(Ra.s,-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  Ra.sl[68]=970; /* line # 970 */
  if (PAS__EQ_STR(Ra.s,Rd.s+1000)) {
    Ra.sl[68]=973; /* line # 973 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1017,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[68]=975; /* line # 975 */
    switch (((UB *)Rv0)[45]) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:Ra.sl[68]=978; /* line # 978 */
      MXD_CRY_RTL_data_hkl_complete(F_p, Rv1);
      break;
      case 6:
      case 7:Ra.sl[68]=980; /* line # 980 */
      MXD_CRY_RTL_data_prf_complete(F_p, Rv1);
      break;
      default:break;
    }
  }
  else {
    Ra.sl[68]=986; /* line # 986 */
    if (PAS__EQ_STR(Ra.s,Rd.s+691)) {
      Ra.sl[68]=988; /* line # 988 */
      P_read_datf_sl(((SL *)Rv0)+9);
      Ra.sl[68]=989; /* line # 989 */
      P_read_datf_sl(((SL *)Rv0)+15);
      Ra.sl[68]=990; /* line # 990 */
      P_read_datf_db(((G *)Rv0)+12);
      Ra.sl[68]=991; /* line # 991 */
      P_read_datf_db(((G *)Rv0)+11);
      Ra.sl[68]=992; /* line # 992 */
      P_read_datf_db(((G *)Rv0)+10);
      Ra.sl[68]=993; /* line # 993 */
      P_read_datf_db(((G *)Rv0)+9);
      Ra.sl[68]=995; /* line # 995 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1045,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[15],0,0);
      PAS__WRITE_STR(Rd.s+1058,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[10],0,0);
      PAS__WRITE_STR(Rd.s+1076,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[68]=996; /* line # 996 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1087,-1,-1,32);
      PAS__WRITE_DBLE(((G *)Rv0)[12],10,-15,0);
      PAS__WRITE_STR(Rd.s+1113,-1,-1,32);
      PAS__WRITE_DBLE(((G *)Rv0)[11],10,-15,0);
      PAS__WRITE_STR(Rd.s+1117,-1,-1,32);
      PAS__WRITE_DBLE(((G *)Rv0)[10],10,-15,0);
      PAS__WRITE_STR(Rd.s+1121,-1,-1,32);
      PAS__WRITE_DBLE(((G *)Rv0)[9],10,-15,0);
      PAS__WRITE_EOLN();
      Ra.sl[68]=998; /* line # 998 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+1125,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[9],0,0);
      PAS__WRITE_STR(Rd.s+1162,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[9],0,0);
      PAS__WRITE_STR(Rd.s+1187,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[68]=1000; /* line # 1000 */
      PAS__CLOSE(&V_dat_inp,0);
    }
    else {
      Ra.sl[68]=1002; /* line # 1002 */
      P_exec_error(Rd.s+849,32,4,((V *)Rv0)[6]);
    }
  }
  Ra.sl[68]=1005; /* line # 1005 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[65];
}
