module MXD_COMPLEX;

%include 'MXDSRC:mxd_env';

%include 'MXDSRC:mxd_cpl_env';

(*
type
  complex = record
              rp, ip: mxd_flt
            end;

const
  zer_cpl  = complex[0.0, 0.0];
  uni_cpl  = complex[1.0, 0.0];
  img_cpl  = complex[0.0, 1.0];
*)



[global 'CPL__ADD']
function C_ADD( z1, z2: complex ): complex;
begin
  C_ADD.rp := z1.rp + z2.rp;
  C_ADD.ip := z1.ip + z2.ip
end C_ADD;


[global 'CPL__NEG']
function C_NEG( z: complex ): complex;
begin
  C_NEG.rp := - z.rp;
  C_NEG.ip := - z.ip
end C_NEG;


[global 'CPL__SUB']
function C_SUB( z1, z2: complex ): complex;
begin
  C_SUB.rp := z1.rp - z2.rp;
  C_SUB.ip := z1.ip - z2.ip
end C_SUB;


[global 'CPL__MUL']
function C_MUL( z1, z2: complex ): complex;
begin
  C_MUL.rp := z1.rp*z2.rp - z1.ip*z2.ip;
  C_MUL.ip := z1.ip*z2.rp + z1.rp*z2.ip
end C_MUL;


[global 'CPL__R_MUL']
function C_MUL( r: mxd_flt; z: complex ): complex;
begin
  C_MUL.rp := r*z.rp;
  C_MUL.ip := r*z.ip
end C_MUL;


[global 'CPL__MUL_R']
function C_MUL(  z: complex; r: mxd_flt): complex;
begin
  C_MUL.rp := r*z.rp;
  C_MUL.ip := r*z.ip
end C_MUL;


[global 'CPL__NEW']
function IN_CPLX( rp, ip: mxd_flt ): complex;
begin
  IN_CPLX.rp := rp;
  IN_CPLX.ip := ip
end IN_CPLX;


[global 'CPL__REAL']
function C_REAL( z: complex ): mxd_flt;
begin
  C_REAL := z.rp
end C_REAL;


[global 'CPL__IMAG']
function C_IMAG( z: complex ): mxd_flt;
begin
  C_IMAG := z.ip
end C_IMAG;


[global 'CPL__CONJ']
function C_CNJ( z: complex ): complex;
begin
  C_CNJ.rp :=   z.rp;
  C_CNJ.ip := - z.ip
end C_CNJ;


[global 'CPL__ABS']
function C_ABS( z: complex ): mxd_flt;
begin
  if z.rp >= z.ip then C_ABS := ABS( z.rp )*SQRT( 1.0 + SQR( z.ip/z.rp ) )
                  else C_ABS := ABS( z.ip )*SQRT( 1.0 + SQR( z.rp/z.ip ) )
end C_ABS;


[global 'CPL__PHASE']
function C_PHASE( z: complex ): mxd_flt;
begin
  C_PHASE := ARCTAN( z.ip, z.rp )
end C_PHASE;


[global 'CPL__DIV']
function C_DIV( z1, z2: complex ): complex;
var
  r, n: mxd_flt;

begin
  if z2.rp >= z2.ip then
  begin
    r := z2.ip/z2.rp;
    n := z2.rp + z2.ip*r;
    C_DIV.rp := (z1.rp + z1.ip*r)/n;
    C_DIV.ip := (z1.ip - z1.rp*r)/n
  end
  else
  begin
    r := z2.rp/z2.ip;
    n := z2.rp*r + z2.ip;
    C_DIV.rp := (z1.rp*r + z1.ip)/n;
    C_DIV.ip := (z1.ip*r - z1.rp)/n
  end
end C_DIV;


[global 'CPL__DIV_R']
function C_DIV( z: complex; r: mxd_flt ): complex;
begin
  C_DIV.rp := z.rp/r;
  C_DIV.ip := z.ip/r
end;


[global 'CPL__R_DIV']
function C_DIV( r: mxd_flt; z: complex ): complex;
var
  f: complex;

begin
  f.rp := r; f.ip := 0.0;
  C_DIV := C_DIV( f, z )
end;


[global 'CPL__SQRT']
function C_SQRT( z: complex ): complex;
var
  r: mxd_flt;

begin
  if z = zer_cpl then r := 0.0
  else
    if z.rp >= z.ip then
      r := SQRT( z.rp )*SQRT( 0.5*( 1.0 + SQRT( 1.0 + SQR( z.ip/z.rp ) )) )
    else
    begin
      r := z.rp/z.ip;
      r := SQRT( z.ip )*SQRT( 0.5*( ABS( r ) + SQRT( 1.0 + SQR( r ) )) )
    end;

  if r = 0.0 then C_SQRT := zer_cpl
  else
    if z.rp >= 0.0 then
    begin  C_SQRT.rp := r; C_SQRT.ip := z.ip/(2.0*r)  end
    else
    begin
      C_SQRT.rp := ABS( z.ip )/(2.0*r);
      if z.ip >= 0.0 then C_SQRT.ip :=   r
                     else C_SQRT.ip := - r
    end
end C_SQRT;



[global 'CPL__EXP']
function C_EXP( z: complex ): complex;
var
  m, e: mxd_flt;

begin
  m := C_ABS( z );
  if m > 0.0 then
  begin
    e := EXP( m )/m;
    C_EXP.rp := e*z.rp;
    C_EXP.ip := e*z.ip
  end
  else C_EXP := zer_cpl
end C_EXP;


function C__IEXP( z: complex ): complex;
{ Compute EXP( i*z ) }
var
  m, e: mxd_flt;

begin
  m := C_ABS( z );
  if m > 0.0 then
  begin
    e := EXP( m )/m;
    C__IEXP.rp := - e*z.ip;
    C__IEXP.ip :=   e*z.rp
  end
  else C__IEXP := zer_cpl
end C__IEXP;


[global 'CPL__COS']
function C_COS( z: complex ): complex;
begin
  C_COS := 0.5*(C__IEXP( z ) + C__IEXP( -z ))
end C_COS;


[global 'CPL__SIN']
function C_SIN( z: complex ): complex;
const
  f = complex[0.0,-0.5]; { -0.5*i = 1/(2*i) }

begin
  C_SIN := f*(C__IEXP( z ) - C__IEXP( -z ))
end C_SIN;



[global 'CPL__TAN']
function C_TAN( z: complex ): complex;
const
  f = complex[0.0,-0.5]; { -0.5*i = 1/(2*i) }

begin
  C_TAN := (C__IEXP( z ) - C__IEXP( -z ))/(C__IEXP( z ) + C__IEXP( -z ))
end C_TAN;




end MXD_COMPLEX.
