/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 248 ) = {
  5,   5,  99,  95,  97, 100, 100,  50,  50,  47, 104, 111, 109, 101,  47, 119,
111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,
 95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95, 115, 114,  99,  47,
109, 120, 100,  95,  99, 112, 108,  46, 112,  97, 115,   5,   5,  99,  95, 110,
101, 103,   5,   5,  99,  95, 115, 117,  98,   5,   5,  99,  95, 109, 117, 108,
  5,   5,  99,  95, 109, 117, 108,   5,   5,  99,  95, 109, 117, 108,   7,   7,
105, 110,  95,  99, 112, 108, 120,   6,   6,  99,  95, 114, 101,  97, 108,   6,
  6,  99,  95, 105, 109,  97, 103,   5,   5,  99,  95,  99, 110, 106,   5,   5,
 99,  95,  97,  98, 115,   7,   7,  99,  95, 112, 104,  97, 115, 101,   5,   5,
 99,  95, 100, 105, 118,   5,   5,  99,  95, 100, 105, 118,   5,   5,  99,  95,
100, 105, 118,   6,   6,  99,  95, 115, 113, 114, 116,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  5,   5,  99,  95, 101, 120, 112,   7,   7,  99,  95,  95, 105, 101, 120, 112,
  5,   5,  99,  95,  99, 111, 115,   5,   5,  99,  95, 115, 105, 110,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 224, 191,
  5,   5,  99,  95, 116,  97, 110,   0
};


/* Function/procedure prototypes. */
V CPL__ADD(V Ret, V F_z1, V F_z2);
V CPL__NEG(V Ret, V F_z);
V CPL__SUB(V Ret, V F_z1, V F_z2);
V CPL__MUL(V Ret, V F_z1, V F_z2);
V CPL__R_MUL(V Ret, G F_r, V F_z);
V CPL__DIV(V Ret, V F_z1, V F_z2);


/* Procedure/Function : " c_add "  */
V CPL__ADD(V Ret, V F_z1, V F_z2){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z1,16);
  memcpy( Ra.s+32,F_z2,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=24; /* line # 24 */
  ((G *)Ret)[0]=Ra.g[2]+Ra.g[4];
  Ra.sl[3]=25; /* line # 25 */
  ((G *)Ret)[1]=Ra.g[3]+Ra.g[5];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_neg "  */
V CPL__NEG(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+59;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=32; /* line # 32 */
  ((G *)Ret)[0]=-Ra.g[2];
  Ra.sl[3]=33; /* line # 33 */
  ((G *)Ret)[1]=-Ra.g[3];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_sub "  */
V CPL__SUB(V Ret, V F_z1, V F_z2){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z1,16);
  memcpy( Ra.s+32,F_z2,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+66;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=40; /* line # 40 */
  ((G *)Ret)[0]=Ra.g[2]-Ra.g[4];
  Ra.sl[3]=41; /* line # 41 */
  ((G *)Ret)[1]=Ra.g[3]-Ra.g[5];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_mul "  */
V CPL__MUL(V Ret, V F_z1, V F_z2){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z1,16);
  memcpy( Ra.s+32,F_z2,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+73;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=48; /* line # 48 */
  ((G *)Ret)[0]=Ra.g[2]*Ra.g[4]-Ra.g[3]*Ra.g[5];
  Ra.sl[3]=49; /* line # 49 */
  ((G *)Ret)[1]=Ra.g[3]*Ra.g[4]+Ra.g[2]*Ra.g[5];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_mul "  */
V CPL__R_MUL(V Ret, G F_r, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+80;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=56; /* line # 56 */
  ((G *)Ret)[0]=F_r*Ra.g[2];
  Ra.sl[3]=57; /* line # 57 */
  ((G *)Ret)[1]=F_r*Ra.g[3];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_mul "  */
V CPL__MUL_R(V Ret, V F_z, G F_r){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=64; /* line # 64 */
  ((G *)Ret)[0]=F_r*Ra.g[2];
  Ra.sl[3]=65; /* line # 65 */
  ((G *)Ret)[1]=F_r*Ra.g[3];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " in_cplx "  */
V CPL__NEW(V Ret, G F_rp, G F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=72; /* line # 72 */
  ((G *)Ret)[0]=F_rp;
  Ra.sl[3]=73; /* line # 73 */
  ((G *)Ret)[1]=F_ip;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_real "  */
G CPL__REAL(V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register G Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=80; /* line # 80 */
  Ret=Ra.g[2];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_imag "  */
G CPL__IMAG(V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register G Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=87; /* line # 87 */
  Ret=Ra.g[3];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_cnj "  */
V CPL__CONJ(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+119;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=94; /* line # 94 */
  ((G *)Ret)[0]=Ra.g[2];
  Ra.sl[3]=95; /* line # 95 */
  ((G *)Ret)[1]=-Ra.g[3];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_abs "  */
G CPL__ABS(V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+126;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=102; /* line # 102 */
  if (Ra.g[2]>=Ra.g[3]) Ret=fabs(Ra.g[2])*sqrt(1.000000000000000E+000+PAS__G_SQR
  (Ra.g[3]/Ra.g[2]));
  else {
    Ra.sl[3]=103; /* line # 103 */
    Ret=fabs(Ra.g[3])*sqrt(1.000000000000000E+000+PAS__G_SQR(Ra.g[2]/Ra.g[3]));
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_phase "  */
G CPL__PHASE(V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register G Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+133;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=110; /* line # 110 */
  Ret=atan2(Ra.g[3],Ra.g[2]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_div "  */
V CPL__DIV(V Ret, V F_z1, V F_z2){
  /* Define the automatic variable space. */
  Blk( Ra, 48 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z1,16);
  memcpy( Ra.s+32,F_z2,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+142;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=120; /* line # 120 */
  if (Ra.g[4]>=Ra.g[5]) {
    Ra.sl[3]=122; /* line # 122 */
    Rv0=Ra.g[5]/Ra.g[4];
    Ra.sl[3]=123; /* line # 123 */
    Rv1=Ra.g[4]+Ra.g[5]*Rv0;
    Ra.sl[3]=124; /* line # 124 */
    ((G *)Ret)[0]=(Ra.g[2]+Ra.g[3]*Rv0)/Rv1;
    Ra.sl[3]=125; /* line # 125 */
    ((G *)Ret)[1]=(Ra.g[3]-Ra.g[2]*Rv0)/Rv1;
  }
  else {
    Ra.sl[3]=129; /* line # 129 */
    Rv0=Ra.g[4]/Ra.g[5];
    Ra.sl[3]=130; /* line # 130 */
    Rv1=Ra.g[4]*Rv0+Ra.g[5];
    Ra.sl[3]=131; /* line # 131 */
    ((G *)Ret)[0]=(Ra.g[2]*Rv0+Ra.g[3])/Rv1;
    Ra.sl[3]=132; /* line # 132 */
    ((G *)Ret)[1]=(Ra.g[3]*Rv0-Ra.g[2])/Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_div "  */
V CPL__DIV_R(V Ret, V F_z, G F_r){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+149;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=140; /* line # 140 */
  ((G *)Ret)[0]=Ra.g[2]/F_r;
  Ra.sl[3]=141; /* line # 141 */
  ((G *)Ret)[1]=Ra.g[3]/F_r;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_div "  */
V CPL__R_DIV(V Ret, G F_r, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );


  /* Code of procedure/function */
  memcpy( Ra.s+48,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+156;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=151; /* line # 151 */
  Ra.g[2]=F_r;
  Ra.g[3]=0.000000000000000E-001;
  Ra.sl[3]=152; /* line # 152 */
  memcpy(Ret,CPL__DIV(Ra.s+32,Ra.s+16,Ra.s+48),16);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_sqrt "  */
V CPL__SQRT(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+163;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=162; /* line # 162 */
  if (memcmp(Ra.s+16,Rd.s+176,16)==0) Rv0=0.000000000000000E-001;
  else {
    Ra.sl[3]=164; /* line # 164 */
    if (Ra.g[2]>=Ra.g[3]) {
      Ra.sl[3]=165; /* line # 165 */
      Rv0=sqrt(Ra.g[2])*sqrt(5.000000E-01*(1.000000000000000E+000+sqrt(1.000000000000000E+000+
      PAS__G_SQR(Ra.g[3]/Ra.g[2]))));
    }
    else {
      Ra.sl[3]=168; /* line # 168 */
      Rv0=Ra.g[2]/Ra.g[3];
      Ra.sl[3]=169; /* line # 169 */
      Rv0=sqrt(Ra.g[3])*sqrt(5.000000E-01*(fabs(Rv0)+sqrt(1.000000000000000E+000+
      Rv0*Rv0)));
    }
  }
  Ra.sl[3]=172; /* line # 172 */
  if (Rv0==0.000000000000000E-001) memcpy(Ret,Rd.s+176,16);
  else {
    Ra.sl[3]=174; /* line # 174 */
    if (Ra.g[2]>=0.000000000000000E-001) {
      Ra.sl[3]=175; /* line # 175 */
      ((G *)Ret)[0]=Rv0;
      ((G *)Ret)[1]=Ra.g[3]/(2.000000E+00*Rv0);
    }
    else {
      Ra.sl[3]=178; /* line # 178 */
      ((G *)Ret)[0]=fabs(Ra.g[3])/(2.000000E+00*Rv0);
      Ra.sl[3]=179; /* line # 179 */
      if (Ra.g[3]>=0.000000000000000E-001) ((G *)Ret)[1]=Rv0;
      else {
        Ra.sl[3]=180; /* line # 180 */
        ((G *)Ret)[1]=-Rv0;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_exp "  */
V CPL__EXP(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+192;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=192; /* line # 192 */
  Rv0=CPL__ABS(Ra.s+16);
  Ra.sl[3]=193; /* line # 193 */
  if (Rv0>0.000000000000000E-001) {
    Ra.sl[3]=195; /* line # 195 */
    Rv1=exp(Rv0)/Rv0;
    Ra.sl[3]=196; /* line # 196 */
    ((G *)Ret)[0]=Rv1*Ra.g[2];
    Ra.sl[3]=197; /* line # 197 */
    ((G *)Ret)[1]=Rv1*Ra.g[3];
  }
  else {
    Ra.sl[3]=199; /* line # 199 */
    memcpy(Ret,Rd.s+176,16);
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c__iexp "  */
V MXD_COMPLEX_c__iexp(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  G Rv1;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+199;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=209; /* line # 209 */
  Rv0=CPL__ABS(Ra.s+16);
  Ra.sl[3]=210; /* line # 210 */
  if (Rv0>0.000000000000000E-001) {
    Ra.sl[3]=212; /* line # 212 */
    Rv1=exp(Rv0)/Rv0;
    Ra.sl[3]=213; /* line # 213 */
    ((G *)Ret)[0]=-Rv1*Ra.g[3];
    Ra.sl[3]=214; /* line # 214 */
    ((G *)Ret)[1]=Rv1*Ra.g[2];
  }
  else {
    Ra.sl[3]=216; /* line # 216 */
    memcpy(Ret,Rd.s+176,16);
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_cos "  */
V CPL__COS(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 112 );


  /* Code of procedure/function */
  memcpy( Ra.s+96,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+208;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=223; /* line # 223 */
  memcpy(Ret,CPL__R_MUL(Ra.s+80,5.000000E-01, CPL__ADD(Ra.s+64,MXD_COMPLEX_c__iexp(
  Ra.s+16,Ra.s+96),MXD_COMPLEX_c__iexp(Ra.s+48,CPL__NEG(Ra.s+32,Ra.s+96)))),16);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_sin "  */
V CPL__SIN(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 112 );


  /* Code of procedure/function */
  memcpy( Ra.s+96,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=233; /* line # 233 */
  memcpy(Ret,CPL__MUL(Ra.s+80,Rd.s+224,CPL__SUB(Ra.s+64,MXD_COMPLEX_c__iexp(Ra.s+
16,Ra.s+96),MXD_COMPLEX_c__iexp(Ra.s+48,CPL__NEG(Ra.s+32,Ra.s+96)))),16);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " c_tan "  */
V CPL__TAN(V Ret, V F_z){
  /* Define the automatic variable space. */
  Blk( Ra, 176 );


  /* Code of procedure/function */
  memcpy( Ra.s+160,F_z,16);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+240;
  Ra.v[2]=Rd.s+7;
  Ra.sl[3]=244; /* line # 244 */
  memcpy(Ret,CPL__DIV(Ra.s+144,CPL__SUB(Ra.s+64,MXD_COMPLEX_c__iexp(Ra.s+16,Ra.s+
160),MXD_COMPLEX_c__iexp(Ra.s+48,CPL__NEG(Ra.s+32,Ra.s+160))),CPL__ADD(Ra.s+128,
  MXD_COMPLEX_c__iexp(Ra.s+80,Ra.s+160),MXD_COMPLEX_c__iexp(Ra.s+112,CPL__NEG(Ra.
  s+96,Ra.s+160)))),16);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
