{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/07/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*                  Binary    File    I/O    Check    program                  *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}
program MXD_BDA_CHECK;
{ Program to make an ASCII translation of a given MXD binary Data HKL FILE.
}

{ ****************************  Begin of PASCAL System Code Section  **************************** }

%pragma code_option (c_interface,      { To authorize the use of "standard" keyword }
    c_code '#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc',
    c_code '#define _FILE_CLEAR(fdst) fdst = NULL'
  );


  procedure DUPLICATE_FILE( f1, f2: $wild_file ); standard '_FILE_DUPLICATE';
  procedure CLEAR_FILE( f: $wild_file ); standard '_FILE_CLEAR';

%pragma code_option noc_interface;              { To disable usage of "standard" keyword }

{ *****************************  End of PASCAL System Code Section  ***************************** }


  %include 'MXDSRC:mxd_env';            { Load the mxd global environment }

  %include 'MXDSRC:mxd_tree_codes';     { Load the related codes }



const
  data_dir_spc  =     'MXD_D_LIST.ddi'; { File specification name for Data directory file }

  fnmpr         =        'MXD_D_file_'; { Prefix and Suffix of binary data file name }
  fnmex         =               '.dat';

type

  dat_namty =  record                   { * Define the data name type * }
    length: byte;
    body: array[1..ide_maxsize+8] of char
  end;


  adat_tabty =  array[1..max_adidtb_size] of integer;   { * Define the Additional data identifier table type * }


  dat_ptr       =     ^dat_rec;         { * Define the pointer of data record * }

  dat_descr = record                    { * Define the data descriptor * }
    dat_tynam,                          { Name of item type }
    dat_name:                dat_namty; { Name of the data set (copy of the item name) }
    dat_nver,                           { Item Data version number (copy of the item version number) }
    dat_filnbr,                         { Binary data file number }
    dat_itmpcd,                         { Data item type P-code }
    dat_nrec,                           { Number of data record }
    dat_adln:                 integer;  { Number of additional identifier define in this data collection }
    dat_adtb:              adat_tabty   { Table of the additional identifiers sequence identifier number }
  end;



  dat_rec = record                      { * Define the data record * }
    data_next:                 dat_ptr; { Name of data set }
    data_desc:               dat_descr  { Data set descriptor }
  end;

(*
  inp_rec = record                      { * Define the Data File Record * }
    drc_
  end;
*)

[global]
var

  datf:                       bin_file; { Data file variable }



var

  outf:                           text; { ASCII Output File }
  data_dir_fil:      file of dat_descr; { Directory reference file }

  data_nobs,                            { Number of observations }
  data_naddf,                           { Number of additional floating fields }
  data_ncmpl:           integer :=   0; { Number of complementary floating fields }

  data_sobs,                            { Summ of ABS( obs ), SQR( obs ), ABS( wei*obs ), SQR( wei*obs ) }
  data_sobs2,
  data_sobsw,
  data_sobsw2:                 mxd_flt;

  data_shown,                           { Selected data field pointer }
  data_first,                           { Data field list header }
  data_last:            dat_ptr := nil;

  data_compl:                  boolean; { Data Complete Flag }


procedure DATA_INIT;
{ To get all pre-existing(to run) data file informations }
var
  bok:         boolean;
  datp:        dat_ptr;
  rec:       dat_descr;

begin
  data_first   :=   nil;
  OPEN( data_dir_fil, data_dir_spc, [read_file,error_file] );
  if iostatus = 0 then
  begin
    while not EOF( data_dir_fil ) do
    begin
      NEW( datp );                              { Create the Data record }
      READ( data_dir_fil, datp^.data_desc );    { Read the data record descriptor from the data directory file }
(*
with datp^.data_desc do
begin
WRITELN( ' Read from Index "', dat_name.body:dat_name.length, '" of type "', dat_tynam.body:dat_tynam.length, '"' )
end;
*)
      datp^.data_next := nil;                   { Init the data record and the data item links }

      { Put the data item  in the data item queue }
      if data_first = nil then data_first := datp
                          else data_last^.data_next := datp;
      data_last := datp
    end;
    CLOSE( data_dir_fil )
  end
end DATA_INIT;



procedure DATA_IDENT( p: dat_ptr; var st, sn, sk: string );
begin
  with p^, data_desc do
  begin
    WRITEV( st, dat_tynam.body:dat_tynam.length );
    WRITEV( sn, dat_name.body:dat_name.length, ';', dat_nver:0 );
    case citm_codety( dat_itmpcd ) of
      citm_dathkl_xf2:  sk := 'X-ray HKL-F2';
      citm_dathkl_xsf:  sk := 'X-ray HKL-SF';
      citm_dathkl_xray: sk := 'X-ray HKL-RAY';
      citm_dathkl_xprf: sk := 'X-ray Profil';
      citm_dathkl_nf2:  sk := 'Neutrons HKL-F2';
      citm_dathkl_nsf:  sk := 'Neutrons HKL-SF';
      citm_dathkl_nray: sk := 'Neutrons HKL-RAY';
      citm_dathkl_nprf: sk := 'Neutrons Profil';
      citm_datcurve:    sk := 'Curve';
    otherwise
    end
  end
end DATA_IDENT;



procedure LIST_DAT_SPC;
var
  p:                   dat_ptr;
  n, ii:               integer;
  st, sn, sk:     string( 62 );

begin
  p := data_first;
  if p = nil then
  begin
    WRITELN( ' Cannot find MXD Binary data file (or there related index file) => STOP.' );
    PASCAL_EXIT( 2 )
  end
  else
  begin
    n := 0;
    WRITELN;
    {         12345678901234567890123456789012345678901234 }
    WRITELN( ' Data#   file #  Data_Item_Type          Data_name' );
    WRITELN;
    while p <> nil do
    with p^, data_desc do
    begin
      n := n + 1;
      DATA_IDENT( p, st, sn, sk );
      WRITELN( n:6, ' ', dat_filnbr:8, ' ', st:20, ' ', sn:ide_maxsize );
      WRITELN( ' ':20, 'data_kind = ', sk:18, 'nrec = ', dat_nrec:8, ', adln = ', dat_adln:4 );
      WRITELN;
      p := data_next
    end;
    WRITELN;
    WRITELN( ' We have find a total of ', n:0, ' data file.' );
    WRITELN( ' Give the number of the data to translate in ASCII or an other value to stop' );
    WRITE( '    Your choice # ' ); READLN( ii );
    if (ii < 1) or (ii > n) then data_shown := nil
    else
    begin
      data_shown := data_first;
      while ii > 1 do begin  data_shown := data_shown^.data_next; ii := ii - 1  end
    end
  end
end LIST_DAT_SPC;



procedure OUT_HKL( nrec: integer; bray: boolean );
var
  ih, ik, il, nq, mul, npo,
  nwv, npd, nph, isent, selnb:  integer;
  he, ke, le, sithsl,
  obs, sig, wei, cvl:           mxd_flt;

begin
  if data_ncmpl <= 0 then
  begin
    {             0        1         2         3         4         5         6         7         8         9        10        11        12        13  }
    {             123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012}
    WRITE( outf, '      #    h   k   l  nq  mul npo      Wav#   poldir#    phase# isent selnb         obs        sigma      weight' );

    if data_naddf > 0 then
    begin
      WRITE( outf, ' ':1 );
      for ij := 1 to data_naddf do WRITE( outf, ' ':4 , 'Add_Field_', ij:-2 );
    end
  end
  else
  begin
    {             1234567/123412341234123412341234123456789012345678901234567890123456123456 <123.56,123.56,123.56> : 1234.67890}
    {             0        1         2         3         4         5         6         7         8         9        10        11        12        13  }
    {             123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012}
    WRITE( outf, '      #    h   k   l  nq mul npo      Wav#   poldir#    phase# isent selnb <     he,     ke,     le>     1/2d    ' );

    if data_ncmpl > 0 then
    begin
      for i := 1 to data_ncmpl do  WRITE( outf, '  Add_Val', i:-2 )
    end;
    WRITE( outf, '       obs        sigma      weight' );

  end;
  WRITELN( outf );
  WRITELN( outf );

  for ii := 1 to nrec do
  begin
    READ_DATF_SL( ih );    READ_DATF_SL( ik );    READ_DATF_SL( il );
    READ_DATF_SL( nq );    READ_DATF_SL( mul );   READ_DATF_SL( npo );
    READ_DATF_SL( nwv );   READ_DATF_SL( npd );   READ_DATF_SL( nph );
    READ_DATF_SL( isent ); READ_DATF_SL( selnb );
    if data_compl then
    begin
      READ_DATF_DB( he );  READ_DATF_DB( ke );    READ_DATF_DB( le );    READ_DATF_DB( sithsl );
      WRITE( outf, ii:7, '/', ih:4, ik:4, il:4, nq:4, mul:4, npo:4, nwv:10, npd:10, nph:10, isent:6, selnb:6, ' <',
                   he:7:3, ',', ke:7:3, ',', le:7:3, '>', sithsl:10:5, ' : ' );

      for jj := 1 to data_ncmpl do
      begin  READ_DATF_DB( cvl ); WRITE( outf, ' ', cvl:9:5, ' ' )  end;

      if isent > 0 then
      begin
        READ_DATF_DB( obs );   READ_DATF_DB( sig );   READ_DATF_DB( wei );
        WRITE( outf, obs:11:3, ' ', sig:11:3, ' ', wei:11:5 );
      end;
      WRITELN( outf )
    end
    else
    begin
      READ_DATF_DB( obs );   READ_DATF_DB( sig );   READ_DATF_DB( wei );

      WRITE( outf, ii:7, '/', ih:4, ik:4, il:4, nq:4, mul:4, npo:4, nwv:10, npd:10, nph:10, isent:6, selnb:6, ' : ', obs:11:3, ' ', sig:11:3, ' ', wei:11:5 );

      if data_naddf > 0 then WRITE( outf, ' ':2 );
      for ij := 1 to data_naddf do
      begin  READ_DATF_DB( cvl ); WRITE( outf, ' ', cvl:15 )  end;

      if data_ncmpl > 0 then WRITE( outf, ' ':2 );
      if data_ncmpl > 0 then
      begin
        READ_DATF_DB( cvl ); WRITE( outf, ' ', cvl:9:5 );
        for ij := 2 to data_ncmpl do
        begin  READ_DATF_DB( cvl ); WRITE( outf, ' ', cvl:15 )  end
      end;
      WRITELN( outf )
    end;
    if bray and (isent > 0) then WRITELN( outf )
  end
end OUT_HKL;



procedure OUT_PRF( nrec: integer );
begin
end OUT_PRF;



procedure OUT_CURVE( nrec: integer );
begin
end OUT_CURVE;



procedure LIST_DATA;
var
  dnm, onm,
  hst,  st,  sn,  sk:   string;
  ch:                     char;
  ns, dg:              integer;

begin
  WRITE( ' Name of the file to create = [terminal] ' ); READLN( onm );
  WRITELN;
  if onm.length = 0 then DUPLICATE_FILE( outf, output )
                    else REWRITE( outf, onm );
  ns := 0;
  with data_shown^, data_desc do
  begin
    data_naddf := dat_adln;
    data_ncmpl :=        0;

    WRITEV( dnm, fnmpr, dat_filnbr:-4, fnmex );
    OPEN( dat_inp, dnm, [read_file,error_file] );
    if iostatus <> 0 then
    begin
      WRITELN( ' MXD_BDA_CHECK ERROR : Cannot open the data file "', dnm, '", Error code = ', iostatus:0, ' => STOP' );
      PASCAL_EXIT( 2 )
    end;
    READ_DATF_ST( hst );
    if hst <> dat_blabel then                   { For Base Data label it is OK }
      if hst = dat_clabel then                  { For Complete Data Label, we parse the end of Label }
      begin
        READ_DATF_SL( data_ncmpl );             { Get the additional/supplementary value table size }
        READ_DATF_SL( data_nobs );              { Get the number of observation }

        READ_DATF_DB( data_sobsw2 );            { Get the data summations }
        READ_DATF_DB( data_sobsw );
        READ_DATF_DB( data_sobs2 );
        READ_DATF_DB( data_sobs );
        data_compl := true
      end
      else
      begin
        WRITELN( ' MXD_BDA_CHECK ERROR : Unknown data file label "', hst, '".' );
        PASCAL_EXIt( 2 )
      end
    else data_compl := false;

    DATA_IDENT( data_shown, st, sn, sk );

    WRITE( outf, ' MXD_BDA_CHECK dump of data file "', dnm, '" of string header "', hst, '",' );
    if data_ncmpl < 0 then WRITELN( outf, ' that is illegal,' )
                      else begin
                             WRITE( outf, ' with ', data_ncmpl:0, ' complementary field' );
                             if data_ncmpl > 1 then WRITE( outf, 's' )
                           end;
    WRITELN( outf );
    WRITELN( outf );
    WRITELN( outf, ' Data File # ', dat_filnbr:0, ', data type "', st, '" corresponding to Data Kind "', sk, '",' );
    WRITELN( outf, ' Data Collection Name "', sn, '",' );

    WRITE( outf, ' With ', dat_nrec:0, ' record' ); if dat_nrec > 1 then WRITE( outf, 's' );
    if data_compl then
    begin  WRITE( outf, ', including ', data_nobs:0, ' observation' ); if data_nobs > 1 then WRITE( outf, 's' )  end;
    WRITE( outf, ' and ', dat_adln:0, ' additional field' ); if dat_adln> 1 then WRITE( outf, 's' );
    WRITELN( outf );
    WRITELN( outf );

    case citm_codety( dat_itmpcd ) of
      citm_dathkl_nf2,  citm_dathkl_xf2:  OUT_HKL( dat_nrec, false );

      citm_dathkl_nsf,  citm_dathkl_xsf:  OUT_HKL( dat_nrec, false );

      citm_dathkl_nray, citm_dathkl_xray: OUT_HKL( dat_nrec, true );

      citm_dathkl_nprf, citm_dathkl_xprf: OUT_PRF( dat_nrec );

      citm_datcurve:    OUT_CURVE( dat_nrec );

    otherwise
    end;

    CLOSE( dat_inp );
    CLOSE( outf )
  end
end LIST_DATA;



begin { Main }
  DATA_INIT;
  LIST_DAT_SPC;
  if data_shown <> nil then LIST_DATA
end MXD_BDA_CHECK.
