{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*                      Binary    File    I/O    Operations                    *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_BIN_DATA_FILE;



  %include 'MXDSRC:mxd_env';            { Load the mxd global environment }



type
  bda_typ = (
              bya,
              tch,
              tub,
              tsb,
              tuw,
              tsw,
              tul,
              tsl,
              tfl,
              tdb
            );


var
  bda_equ: record
   case bda_typ of
     bya:( tb: array[1..8] of char );
     tch:( ch: char);
     tub:( ub: short_unsigned );
     tsb:( sb: short_integer );
     tuw:( uw: word_unsigned );
     tsw:( sw: word_integer );
     tul:( ul: unsigned );
     tsl:( sl: integer );
     tfl:( fl: single );
     tdb:( db: double )
   end;

  dat_byte_count:   [global]  unsigned;         { Data byte count }

  dat_out,                                      { Data output file variable }
  dat_inp:          [global]  bin_file;         { Data input file variable }


procedure READ_OBJECT( n: integer );
begin
  for ii := 1 to n do READ( dat_inp, bda_equ.tb[ii] )
end READ_OBJECT;

procedure WRITE_OBJECT( n: integer );
begin
  for ii := 1 to n do WRITE( dat_out, bda_equ.tb[ii] );
  dat_byte_count := dat_byte_count + n
end WRITE_OBJECT;




{ String I/O }
[global]
procedure READ_DATF_ST( var st: string );
begin
  READ( dat_inp, bda_equ.ch );
  if st.capacity < bda_equ.ub then bda_equ.ub := st.capacity;
  for ii := 1 to bda_equ.ub do  READ( dat_inp, st.body[ii] );
  st.length := bda_equ.ub
end READ_DATF_ST;

[global]
procedure WRITE_DATF_ST( st: ^string );
begin
  if st = nil then
  begin
    WRITE$BINARY( CHR( 0 ) );
    dat_byte_count := dat_byte_count + 1
  end
  else
  begin
    bda_equ.ub := st^.length;
    WRITE( dat_out, bda_equ.ch );
    for ii := 1 to bda_equ.ub do  WRITE( dat_out, st^.body[ii] );
    dat_byte_count := dat_byte_count + st^.length + 1
  end
end WRITE_DATF_ST;





{ Unsigned and Signed Byte Integer I/O }
[global]
procedure READ_DATF_UB( var ub: short_unsigned );
begin
  READ( dat_inp, bda_equ.ch ); ub := bda_equ.ub
end READ_DATF_UB;

[global]
procedure WRITE_DATF_UB( ub: short_unsigned );
begin
  bda_equ.ub := ub; WRITE( dat_out, bda_equ.ch );
  dat_byte_count := dat_byte_count + 1
end WRITE_DATF_UB;


[global]
procedure READ_DATF_SB( var sb: short_integer );
begin
  READ( dat_inp, bda_equ.ch ); sb := bda_equ.sb
end READ_DATF_SB;

[global]
procedure WRITE_DATF_SB( sb: short_integer );
begin
  bda_equ.sb := sb; WRITE( dat_out, bda_equ.ch );
  dat_byte_count := dat_byte_count + 2
end WRITE_DATF_SB;




{ Unsigned and Signed Word Integer I/O }
[global]
procedure READ_DATF_UW( var uw: word_unsigned );
begin
  READ_OBJECT( 2 ); uw := bda_equ.uw
end READ_DATF_UW;

[global]
procedure WRITE_DATF_UW( uw: word_unsigned );
begin
  bda_equ.uw := uw; WRITE_OBJECT( 2 )
end WRITE_DATF_UW;


[global]
procedure READ_DATF_SW( var sw: word_integer );
begin
  READ_OBJECT( 2 ); sw := bda_equ.sw
end READ_DATF_SW;

[global]
procedure WRITE_DATF_SW( sw: word_integer );
begin
  bda_equ.sw := sw; WRITE_OBJECT( 2 )
end WRITE_DATF_SW;




{ Unsigned and Signed Long Integer I/O }
[global]
procedure READ_DATF_UL( var ul: unsigned );
begin
  READ_OBJECT( 4 ); ul := bda_equ.ul
end READ_DATF_UL;

[global]
procedure WRITE_DATF_UL( ul: unsigned );
begin
  bda_equ.ul := ul; WRITE_OBJECT( 4 )
end WRITE_DATF_UL;


[global]
procedure READ_DATF_SL( var sl: integer );
begin
  READ_OBJECT( 4 ); sl := bda_equ.sl
end READ_DATF_SL;

[global]
procedure WRITE_DATF_SL( sl: integer );
begin
  bda_equ.sl := sl; WRITE_OBJECT( 4 )
end WRITE_DATF_SL;




{ Floating Single Precision I/O }
[global]
procedure READ_DATF_FL( var fl: single );
begin
  READ_OBJECT( 4 ); fl := bda_equ.fl
end READ_DATF_FL;

[global]
procedure WRITE_DATF_FL( fl: single );
begin
  bda_equ.fl := fl; WRITE_OBJECT( 4 )
end WRITE_DATF_FL;




{ Floating Double Precision I/O }
[global]
procedure READ_DATF_DB( var db: double );
begin
  READ_OBJECT( 8 ); db := bda_equ.db
end READ_DATF_DB;

[global]
procedure WRITE_DATF_DB( db: double );
begin
  bda_equ.db := db; WRITE_OBJECT( 8 )
end WRITE_DATF_DB;




end MXD_BIN_DATA_FILE.
