/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 344 ) = {
 11,  11, 114, 101,  97, 100,  95, 111,  98, 106, 101,  99, 116,  50,  50,  47,
104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102,
116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,
 52,  95, 115, 114,  99,  47, 109, 120, 100,  95,  98, 100,  97,  46, 112,  97,
115,  12,  12, 119, 114, 105, 116, 101,  95, 111,  98, 106, 101,  99, 116,  12,
 12, 114, 101,  97, 100,  95, 100,  97, 116, 102,  95, 115, 116,  13,  13, 119,
114, 105, 116, 101,  95, 100,  97, 116, 102,  95, 115, 116,   0,  12,  12, 114,
101,  97, 100,  95, 100,  97, 116, 102,  95, 117,  98,  13,  13, 119, 114, 105,
116, 101,  95, 100,  97, 116, 102,  95, 117,  98,  12,  12, 114, 101,  97, 100,
 95, 100,  97, 116, 102,  95, 115,  98,  13,  13, 119, 114, 105, 116, 101,  95,
100,  97, 116, 102,  95, 115,  98,  12,  12, 114, 101,  97, 100,  95, 100,  97,
116, 102,  95, 117, 119,  13,  13, 119, 114, 105, 116, 101,  95, 100,  97, 116,
102,  95, 117, 119,  12,  12, 114, 101,  97, 100,  95, 100,  97, 116, 102,  95,
115, 119,  13,  13, 119, 114, 105, 116, 101,  95, 100,  97, 116, 102,  95, 115,
119,  12,  12, 114, 101,  97, 100,  95, 100,  97, 116, 102,  95, 117, 108,  13,
 13, 119, 114, 105, 116, 101,  95, 100,  97, 116, 102,  95, 117, 108,  12,  12,
114, 101,  97, 100,  95, 100,  97, 116, 102,  95, 115, 108,  13,  13, 119, 114,
105, 116, 101,  95, 100,  97, 116, 102,  95, 115, 108,  12,  12, 114, 101,  97,
100,  95, 100,  97, 116, 102,  95, 102, 108,  13,  13, 119, 114, 105, 116, 101,
 95, 100,  97, 116, 102,  95, 102, 108,  12,  12, 114, 101,  97, 100,  95, 100,
 97, 116, 102,  95, 100,  98,  13,  13, 119, 114, 105, 116, 101,  95, 100,  97,
116, 102,  95, 100,  98,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of global variables. */
UL V_dat_byte_count;
V V_dat_out = NULL;
V V_dat_inp = NULL;



/* Procedure/Function : " read_object "  */
void MXD_BINFILE_read_object(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=141; /* line # 141 */
  Rv0=1;
  for( Rf0=F_n;Rf0>0;Rf0-- ) {
    PAS__SELECT_INP(V_dat_inp);
    PAS__READ_BIN((Rs.c+Rv0-1));
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_object "  */
void MXD_BINFILE_write_object(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+65;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=146; /* line # 146 */
  Rv0=1;
  for( Rf0=F_n;Rf0>0;Rf0-- ) {
    PAS__SELECT_OUT(V_dat_out);
    PAS__WRITE_BIN((Rs.c+Rv0-1));
    Rv0++;
  }
  Ra.sl[3]=147; /* line # 147 */
  V_dat_byte_count=V_dat_byte_count+F_n;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_st "  */
void P_read_datf_st(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+79;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=157; /* line # 157 */
  PAS__SELECT_INP(V_dat_inp);
  PAS__READ_BIN(Rs.s);
  Ra.sl[3]=158; /* line # 158 */
  if (((UB *)F_st)[0]<Rs.ub[0]) Rs.ub[0]=((UB *)F_st)[0];
  Ra.sl[3]=159; /* line # 159 */
  Rv0=1;
  for( Rf0=Rs.ub[0];Rf0>0;Rf0-- ) {
    PAS__SELECT_INP(V_dat_inp);
    PAS__READ_BIN((((C *)F_st)+Rv0+1));
    Rv0++;
  }
  Ra.sl[3]=160; /* line # 160 */
  ((UB *)F_st)[1]=Rs.ub[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_st "  */
void P_write_datf_st(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+93;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=166; /* line # 166 */
  if (F_st==NULL) {
    Ra.sl[3]=168; /* line # 168 */
    PAS__WRITE_BIN(Rd.s+108);
    Ra.sl[3]=169; /* line # 169 */
    V_dat_byte_count=V_dat_byte_count+1;
  }
  else {
    Ra.sl[3]=173; /* line # 173 */
    Rs.ub[0]=((UB *)F_st)[1];
    Ra.sl[3]=174; /* line # 174 */
    PAS__SELECT_OUT(V_dat_out);
    PAS__WRITE_BIN(Rs.s);
    Ra.sl[3]=175; /* line # 175 */
    Rv0=1;
    for( Rf0=Rs.ub[0];Rf0>0;Rf0-- ) {
      PAS__SELECT_OUT(V_dat_out);
      PAS__WRITE_BIN((((C *)F_st)+Rv0+1));
      Rv0++;
    }
    Ra.sl[3]=176; /* line # 176 */
    V_dat_byte_count=(V_dat_byte_count+((UB *)F_st)[1])+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_ub "  */
void P_read_datf_ub(UB *F_ub){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+109;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=188; /* line # 188 */
  PAS__SELECT_INP(V_dat_inp);
  PAS__READ_BIN(Rs.s);
  (*F_ub)=Rs.ub[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_ub "  */
void P_write_datf_ub(UB F_ub){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+123;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=194; /* line # 194 */
  Rs.ub[0]=F_ub;
  PAS__SELECT_OUT(V_dat_out);
  PAS__WRITE_BIN(Rs.s);
  Ra.sl[3]=195; /* line # 195 */
  V_dat_byte_count=V_dat_byte_count+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_sb "  */
void P_read_datf_sb(SB *F_sb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+138;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=202; /* line # 202 */
  PAS__SELECT_INP(V_dat_inp);
  PAS__READ_BIN(Rs.s);
  (*F_sb)=Rs.sb[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_sb "  */
void P_write_datf_sb(SB F_sb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+152;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=208; /* line # 208 */
  Rs.sb[0]=F_sb;
  PAS__SELECT_OUT(V_dat_out);
  PAS__WRITE_BIN(Rs.s);
  Ra.sl[3]=209; /* line # 209 */
  V_dat_byte_count=V_dat_byte_count+2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_uw "  */
void P_read_datf_uw(UW *F_uw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+167;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=219; /* line # 219 */
  MXD_BINFILE_read_object(2);
  (*F_uw)=Rs.uw[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_uw "  */
void P_write_datf_uw(UW F_uw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+181;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=225; /* line # 225 */
  Rs.uw[0]=F_uw;
  MXD_BINFILE_write_object(2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_sw "  */
void P_read_datf_sw(SW *F_sw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+196;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=232; /* line # 232 */
  MXD_BINFILE_read_object(2);
  (*F_sw)=Rs.sw[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_sw "  */
void P_write_datf_sw(SW F_sw){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+210;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=238; /* line # 238 */
  Rs.sw[0]=F_sw;
  MXD_BINFILE_write_object(2);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_ul "  */
void P_read_datf_ul(UL *F_ul){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+225;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=248; /* line # 248 */
  MXD_BINFILE_read_object(4);
  (*F_ul)=Rs.ul[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_ul "  */
void P_write_datf_ul(UL F_ul){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+239;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=254; /* line # 254 */
  Rs.ul[0]=F_ul;
  MXD_BINFILE_write_object(4);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_sl "  */
void P_read_datf_sl(SL *F_sl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+254;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=261; /* line # 261 */
  MXD_BINFILE_read_object(4);
  (*F_sl)=Rs.sl[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_sl "  */
void P_write_datf_sl(SL F_sl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+268;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=267; /* line # 267 */
  Rs.sl[0]=F_sl;
  MXD_BINFILE_write_object(4);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_fl "  */
void P_read_datf_fl(F *F_fl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+283;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=277; /* line # 277 */
  MXD_BINFILE_read_object(4);
  (*F_fl)=Rs.f[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_fl "  */
void P_write_datf_fl(F F_fl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+297;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=283; /* line # 283 */
  Rs.f[0]=F_fl;
  MXD_BINFILE_write_object(4);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_datf_db "  */
void P_read_datf_db(G *F_db){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+312;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=293; /* line # 293 */
  MXD_BINFILE_read_object(8);
  (*F_db)=Rs.g[0];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_datf_db "  */
void P_write_datf_db(G F_db){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+326;
  Ra.v[2]=Rd.s+13;
  Ra.sl[3]=299; /* line # 299 */
  Rs.g[0]=F_db;
  MXD_BINFILE_write_object(8);
  PAS__curr_cntx=Ra.v[0];
}
