{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*     MXD   Expression  and  Crystallographic  Object  Tree   Environment     *
*                                                                             *
*                                                                             *
*******************************************************************************


}


{****************     CPAS  version    *****************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

module MXD_APPL_RTL;


  %include        'MXDSRC:mxd_lsq_env'; { Load Least-Sqaure Environment }



(*
const

  mxd_tree_errfspc = 'mxd_tree.err_msg';{ Error message file for MXD_TREE Loader }
  mxd_setenvf   =    'mxd_dcp.std_env'; { Standard Environment Setup file name (of MXD_DCP) }
*)



[global]
procedure SET_LISTING_TITLE( in_var title: string );
begin 
  { Create a title string - temporary }
  with lst_current^ do
  begin
    if lst_title <> nil then DISPOSE( lst_title );
    NEW( lst_title, title.length );
    lst_title^ := title
  end
end SET_LISTING_TITLE;



[global]
procedure SET_LISTING_SUBTITLE( in_var subtitle: string );
begin
  { Create a title string - temporary }
  with lst_current^ do
  begin
    if lst_sbttl <> nil then DISPOSE( lst_sbttl );
    NEW( lst_sbttl, subtitle.length );
    lst_sbttl^ := subtitle
  end
end SET_LISTING_SUBTITLE;



[global]
procedure EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev := e_fatal; in_var ide: [optional] string );
var
  std_lst:             boolean;
  error_ent:       error_entry; { Execution Error Context }
  smb:            string( 32 );

  procedure EXEC_ERR_MSG( var f: text );
  begin
    WRITE( f, ' ', mxd_proc_name, ' ' );
    with error_ent do
    begin
      case err_sv of
        e_success: ;
        e_warning: WRITE( f, ' Exec-Warning' );
        e_error:   WRITE( f, ' Exec-Error' );
        e_severe:  WRITE( f, ' Severe Exec-Error' );
        e_fatal:   begin  WRITE( f, ' Fatal Exec-Error' ); fatal_error := true  end;
      end;
      WRITELN( f, ' # ', err_code:3, ' detected by the ', err_mdn, ' module.' );
      if err_msg <> nil then
        WRITELN( f, '  *EXE* ', err_msg^ )
      else WRITELN( f )
    end
  end EXEC_ERR_MSG;


begin { EXEC_ERROR }
  if ide"address <> nil then
  with ide do
  begin
    smb.length := length;
    for i := 1 to length do  smb[i] := body[i];
    ERR_PUT_SYMBOL( smb )
  end;
  std_lst := lstf_stdout in lst_current^.lst_flagsw;
  with error_ent do
  begin
    err_pos  :=   1;
    err_code :=  nb;
    err_sv   := sev;
    err_mdn  :=  md;
    err_msg  := nil
  end;
  ERR_GETMSG( error_ent );                               { Get possible defined message }
  error_cnt[sev] := SUCC( error_cnt[sev] );
  if error_result < sev then error_result := sev;

  if std_lst then
    with lst_current^ do
    begin
      lst_lncnt := SUCC( lst_lncnt );                   { Skip to next page without page skip }
      LST_NEWLINE; lst_lncnt := SUCC( lst_lncnt );      { To allocate two lines }
      EXEC_ERR_MSG( lst_current^.lst_file )
    end;

  if not std_lst then EXEC_ERR_MSG( output );
  if sev > e_warning then
  begin
    { Set the Process error status }
(*
    recurs_nb := 0;             { Reset trace flag }
    eval_ninc := 0;             { Reset exec trace level }
*)
    if sev = e_fatal then PASCAL_EXIT( 4 )      { Stop execution on a fatal error }
  end
end EXEC_ERROR;



[global]
procedure SEARCH_FILE( in_var  path,                                    { Path to use can be string or array of char }
                              fname:                       string;      { Name of file to search }
                                acc:                      integer;      { Access required }
                       var       re:                       string;      { Returned complete file specification if found (fnd = true) }
                       var      fnd:                      boolean );    { Returned flag (true when found, false otherwise) }
{ Routine to search a file from a short PATH list (Path in a string - not an array).
}

var
  ip, ie, nb:  integer;

begin
  fnd := FILE_ACCESS_CHECK( fname, acc );                       { Before search on the local directory }
  if fnd then re := fname
  else
  begin
    ip  :=     1; nb  :=     1;
    while (ip <= path.length) and not fnd do                    { Loop on all PATH entry }
    begin
      ie  := INDEX( path, ',', nb );
      if ie = 0 then ie := path.length + 1;
      re  := SUBSTR( path, ip, ie - ip )||fname;
      ip  := ie + 1; nb := nb + 1;
      fnd := FILE_ACCESS_CHECK( re, acc );
    end;
    if not fnd then re.length := 0
  end
end SEARCH_FILE;



[global]
procedure OPEN_LISTING( in_var task_name, fnm: string; bsup, bdel: boolean := true );
var
  ierr:        integer;
  str:          string;

begin
  if lst_current <> nil then LST_CLOSE( lst_current, true );
  str := 'MXD-Tree-Loader '||mxd_heading;
  LST_G_INIT( fnm, str, ierr );
  if ierr <> 0 then
  begin
    WRITELN( ' *** ', task_name, ' FATAL ERROR : Cannot open the Listing File "', fnm, '" error code = ', ierr:0 );
    PASCAL_EXIT( 4 )
  end
end { OPEN_LISTING };



[global]
procedure NEWPARAGRAPHE( n: integer );
{ Procedure to optimize the page skip use }
{ n is the new paragraphe size in line }
begin
  LST_TEST_LINE( 3, n );
end { NEWPARAGRAPHE };



[global]
procedure WRITECPU( ti: integer );
{ to write a cpu time in milli-seconde }
{ can be system dependante }
const
  scom = ', ';

var
  str:    string( 62 );
  r:           mxd_flt;
  i, j, k, l:  integer;

begin
  i := ti mod 1000; ti := ti div 1000;  { Get millisec. and ti in seconds. }
  j := ti mod 60;   ti := ti div 60;    { Get seconds and ti in minuts. }
  k := ti mod 60;   ti := ti div 60;    { Get minuts and ti in hours }
  l := ti mod 24;   ti := ti div 24;    { Get hours and ti in days }
  r := j + i/1000.0;
  str.length := 0;
  if ti > 0 then
  begin  WRITEV( str:false, ti:2, ' day' );
    if ti >= 2 then WRITEV( str:false, 's' ); WRITEV( str:false, scom )
  end;
  if l > 0 then
  begin
    WRITEV( str:false, l:2, ' hour' );
    if l >= 2 then WRITEV( str:false, 's' );
    WRITEV( str:false, scom )
  end;
  if k > 0 then
  begin
    WRITEV( str:false, k:2, ' minute' );
    if k >= 2 then  WRITEV( str:false, 's' );
    WRITEV( str:false, scom )
  end;
  WRITEV( str:false, r:7:3, ' second' );
  if r >= 2.0 then WRITEV( str:false, 's' );
  WRITEV( str:false, '.' );
  LST_PUT_STRING( str );
  LST_EOLN
end { WRITECPU };



end MXD_APPL_RTL.
