/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 464 ) = {
 17,  17, 115, 101, 116,  95, 108, 105, 115, 116, 105, 110, 103,  95, 116, 105,
116, 108, 101,  55,  55,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101,
114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116,
115,  47,  77,  88,  68,  86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95,
 97, 112, 112, 108,  95, 114, 116, 108,  46, 112,  97, 115,  20,  20, 115, 101,
116,  95, 108, 105, 115, 116, 105, 110, 103,  95, 115, 117,  98, 116, 105, 116,
108, 101,  12,  12, 101, 120, 101,  99,  95, 101, 114, 114,  95, 109, 115, 103,
 13,  13,  32,  69, 120, 101,  99,  45,  87,  97, 114, 110, 105, 110, 103,  11,
 11,  32,  69, 120, 101,  99,  45,  69, 114, 114, 111, 114,  18,  18,  32,  83,
101, 118, 101, 114, 101,  32,  69, 120, 101,  99,  45,  69, 114, 114, 111, 114,
 17,  17,  32,  70,  97, 116,  97, 108,  32,  69, 120, 101,  99,  45,  69, 114,
114, 111, 114,   3,   3,  32,  35,  32,  17,  17,  32, 100, 101, 116, 101,  99,
116, 101, 100,  32,  98, 121,  32, 116, 104, 101,  32,   8,   8,  32, 109, 111,
100, 117, 108, 101,  46,   8,   8,  32,  32,  42,  69,  88,  69,  42,  32,  10,
 10, 101, 120, 101,  99,  95, 101, 114, 114, 111, 114,  11,  11, 115, 101,  97,
114,  99, 104,  95, 102, 105, 108, 101,  12,  12, 111, 112, 101, 110,  95, 108,
105, 115, 116, 105, 110, 103,  16,  16,  77,  88,  68,  45,  84, 114, 101, 101,
 45,  76, 111,  97, 100, 101, 114,  32,  47,  47,  80,  46,  87, 111, 108, 102,
101, 114, 115,  32,  83, 111, 102, 116, 119,  97, 114, 101,  58,  32,  77,  88,
 68,  32,  86,  52,  46,  48,  45,  48,  48,  48,  32, 111, 102,  32,  51,  49,
 45,  68,  69,  67,  45,  50,  48,  49,  48,   5,   5,  32,  42,  42,  42,  32,
 45,  45,  32,  70,  65,  84,  65,  76,  32,  69,  82,  82,  79,  82,  32,  58,
 32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,
 32,  76, 105, 115, 116, 105, 110, 103,  32,  70, 105, 108, 101,  32,  34,  15,
 15,  34,  32, 101, 114, 114, 111, 114,  32,  99, 111, 100, 101,  32,  61,  32,
 13,  13, 110, 101, 119, 112,  97, 114,  97, 103, 114,  97, 112, 104, 101,   8,
  8, 119, 114, 105, 116, 101,  99, 112, 117,   4,   4,  32, 100,  97, 121,   2,
  2,  44,  32,   5,   5,  32, 104, 111, 117, 114,   7,   7,  32, 109, 105, 110,
117, 116, 101,   7,   7,  32, 115, 101,  99, 111, 110, 100,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_lst_current;
extern Blk(V_mxd_proc_name, 264 );
extern UB V_fatal_error;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;
extern V PAS__f_output;


/* Function/procedure prototypes. */
void P_lst_close(V *F_p, UB F_bfree);
void P_lst_newline();
void P_lst_eoln();
void P_lst_test_line(SL F_iskip, SL F_tstli);
void P_lst_put_string(V F_str);
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_put_symbol(V F_symb, SL F_len);
void P_err_getmsg(V F_erren);


/* Procedure/Function : " set_listing_title "  */
void P_set_listing_title(V F_title){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=117; /* line # 117 */
  Rv0=V_lst_current;
  Ra.sl[3]=119; /* line # 119 */
  if (((V *)Rv0)[4]!=NULL) PAS__DISPOSE(((V *)Rv0)+4);
  Ra.sl[3]=120; /* line # 120 */
  Rv1=((UB *)F_title)[1];
  ((V *)Rv0)[4]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[4])[0]=Rv1;
  Ra.sl[3]=121; /* line # 121 */
  PAS__STR_TO_STR(((V *)Rv0)[4],F_title);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_listing_subtitle "  */
void P_set_listing_subtitle(V F_subtitle){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=131; /* line # 131 */
  Rv0=V_lst_current;
  Ra.sl[3]=133; /* line # 133 */
  if (((V *)Rv0)[5]!=NULL) PAS__DISPOSE(((V *)Rv0)+5);
  Ra.sl[3]=134; /* line # 134 */
  Rv1=((UB *)F_subtitle)[1];
  ((V *)Rv0)[5]=PAS__NEW((SL)Rv1+2);
  ((UB *)((V *)Rv0)[5])[0]=Rv1;
  Ra.sl[3]=135; /* line # 135 */
  PAS__STR_TO_STR(((V *)Rv0)[5],F_subtitle);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exec_err_msg "  */
void MXD_APP_RTL_PRC_00000000(V *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+98;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=150; /* line # 150 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_STR(V_mxd_proc_name.s,-1,-1,32);
  PAS__WRITE_CHAR(32);
  Ra.sl[3]=151; /* line # 151 */
  Ra.sl[3]=153; /* line # 153 */
  switch (Lx[0].ub[8]) {
    case 0:break;
    case 1:Ra.sl[3]=155; /* line # 155 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+112,-1,-1,32);
    break;
    case 2:Ra.sl[3]=156; /* line # 156 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+127,-1,-1,32);
    break;
    case 3:Ra.sl[3]=157; /* line # 157 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+140,-1,-1,32);
    break;
    case 4:Ra.sl[3]=158; /* line # 158 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+160,-1,-1,32);
    V_fatal_error=1;
    break;
  }
  Ra.sl[3]=160; /* line # 160 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+179,-1,-1,32);
  PAS__WRITE_INT(Lx[0].sl[1],3,0);
  PAS__WRITE_STR(Rd.s+184,-1,-1,32);
  PAS__WRITE_CHT(Lx[0].s+9,4,-1,-1,32);
  PAS__WRITE_STR(Rd.s+203,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=161; /* line # 161 */
  if (Lx[0].v[4]!=NULL) {
    Ra.sl[3]=162; /* line # 162 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(Rd.s+213,-1,-1,32);
    PAS__WRITE_STR(Lx[0].v[4],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=163; /* line # 163 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " exec_error "  */
void P_exec_error(V F_md, SL F_nb, UB F_sev, V F_ide){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  memcpy( Ra.s+72,F_md,4);
  Ra.ub[20]=32;
  Ra.v[14]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+56;
  Ra.v[15]=Rd.s+223;
  Ra.v[16]=Rd.s+19;
  Ra.sl[17]=169; /* line # 169 */
  if (F_ide!=NULL) {
    Ra.sl[17]=170; /* line # 170 */
    Ra.sl[17]=172; /* line # 172 */
    Ra.ub[21]=((UB *)F_ide)[1];
    Ra.sl[17]=173; /* line # 173 */
    Rv0=1;
    for( Rf0=((UB *)F_ide)[1];Rf0>0;Rf0-- ) {
      Ra.c[Rv0+21]=((C *)F_ide)[Rv0+1];
      Rv0++;
    }
    Ra.sl[17]=174; /* line # 174 */
    P_err_put_symbol(Ra.s+22,(SL)Ra.ub[21]);
  }
  Ra.sl[17]=176; /* line # 176 */
  Rv1=(4&((UB *)V_lst_current)[48])!=0;
  Ra.sl[17]=177; /* line # 177 */
  Ra.sl[17]=179; /* line # 179 */
  Ra.sl[0]=1;
  Ra.sl[17]=180; /* line # 180 */
  Ra.sl[1]=F_nb;
  Ra.sl[17]=181; /* line # 181 */
  Ra.ub[8]=F_sev;
  Ra.sl[17]=182; /* line # 182 */
  memcpy(Ra.s+9,Ra.s+72,4);
  Ra.sl[17]=183; /* line # 183 */
  Ra.v[4]=NULL;
  Ra.sl[17]=185; /* line # 185 */
  P_err_getmsg(Ra.s);
  Ra.sl[17]=186; /* line # 186 */
  V_error_cnt.sl[F_sev]=V_error_cnt.sl[F_sev]+1;
  Ra.sl[17]=187; /* line # 187 */
  if (V_error_result<F_sev) V_error_result=F_sev;
  Ra.sl[17]=189; /* line # 189 */
  if (Rv1) {
    Ra.sl[17]=190; /* line # 190 */
    Rv2=V_lst_current;
    Ra.sl[17]=192; /* line # 192 */
    ((SL *)Rv2)[6]=((SL *)Rv2)[6]+1;
    Ra.sl[17]=193; /* line # 193 */
    P_lst_newline();
    ((SL *)Rv2)[6]=((SL *)Rv2)[6]+1;
    Ra.sl[17]=194; /* line # 194 */
    MXD_APP_RTL_PRC_00000000(((V *)V_lst_current)+13);
  }
  Ra.sl[17]=197; /* line # 197 */
  if (!Rv1) MXD_APP_RTL_PRC_00000000(&PAS__f_output);
  Ra.sl[17]=198; /* line # 198 */
  if (F_sev>1) {
    Ra.sl[17]=205; /* line # 205 */
    if (F_sev==4) PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[14];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " search_file "  */
void P_search_file(V F_path, V F_fname, SL F_acc, V F_re, UB *F_fnd){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+235;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=224; /* line # 224 */
  (*F_fnd)=PAS__FILE_ACCESS(F_fname,F_acc,0);
  Ra.sl[3]=225; /* line # 225 */
  if ((*F_fnd)) PAS__STR_TO_STR(F_re,F_fname);
  else {
    Ra.sl[3]=228; /* line # 228 */
    Rv0=1;
    Rv1=1;
    Ra.sl[3]=229; /* line # 229 */
    while (Rv0<=((UB *)F_path)[1]&&!(*F_fnd)){
      Ra.sl[3]=231; /* line # 231 */
      Rv2=PAS__NINDEX_CHA(F_path+2,(SL)((UB *)F_path)[1],44, Rv1,-1,1);
      Ra.sl[3]=232; /* line # 232 */
      if (Rv2==0) Rv2=((UB *)F_path)[1]+1;
      Ra.sl[3]=233; /* line # 233 */
      PAS__STR_TO_STR(F_re,PAS__CON_STR_STR(Ra.s+273,PAS__SUBSTR_STR(Ra.s+16,F_path,
      Rv0, Rv2-Rv0), F_fname));
      Ra.sl[3]=234; /* line # 234 */
      Rv0=Rv2+1;
      Rv1=Rv1+1;
      Ra.sl[3]=235; /* line # 235 */
      (*F_fnd)=PAS__FILE_ACCESS(F_re,F_acc,0);
    }
    Ra.sl[3]=237; /* line # 237 */
    if (!(*F_fnd)) ((UB *)F_re)[1]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " open_listing "  */
void P_open_listing(V F_task_name, V F_fnm, UB F_bsup, UB F_bdel){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+248;
  Ra.v[67]=Rd.s+19;
  Ra.sl[68]=250; /* line # 250 */
  if (V_lst_current!=NULL) P_lst_close(&V_lst_current,1);
  Ra.sl[68]=251; /* line # 251 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,Rd.s+262,Rd.s+280));
  Ra.sl[68]=252; /* line # 252 */
  P_lst_g_init(F_fnm,Ra.s,&Rv0);
  Ra.sl[68]=253; /* line # 253 */
  if (Rv0!=0) {
    Ra.sl[68]=255; /* line # 255 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+329,-1,-1,32);
    PAS__WRITE_STR(F_task_name,-1,-1,32);
    PAS__WRITE_STR(Rd.s+336,-1,-1,32);
    PAS__WRITE_STR(F_fnm,-1,-1,32);
    PAS__WRITE_STR(Rd.s+383,-1,-1,32);
    PAS__WRITE_INT(Rv0,0,0);
    PAS__WRITE_EOLN();
    Ra.sl[68]=256; /* line # 256 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " newparagraphe "  */
void P_newparagraphe(SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+400;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=267; /* line # 267 */
  P_lst_test_line(3, F_n);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " writecpu "  */
void P_writecpu(SL F_ti){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  G Rv4;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.ub[0]=62;
  Ra.v[16]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+64;
  Ra.v[17]=Rd.s+415;
  Ra.v[18]=Rd.s+19;
  Ra.sl[19]=285; /* line # 285 */
  Rv0=PAS__I_MOD(F_ti,1000);
  F_ti=F_ti/1000;
  Ra.sl[19]=286; /* line # 286 */
  Rv1=PAS__I_MOD(F_ti,60);
  F_ti=F_ti/60;
  Ra.sl[19]=287; /* line # 287 */
  Rv2=PAS__I_MOD(F_ti,60);
  F_ti=F_ti/60;
  Ra.sl[19]=288; /* line # 288 */
  Rv3=PAS__I_MOD(F_ti,24);
  F_ti=F_ti/24;
  Ra.sl[19]=289; /* line # 289 */
  Rv4=(double)((float)Rv1+(float)Rv0/(F)1.000000E+03);
  Ra.sl[19]=290; /* line # 290 */
  Ra.ub[1]=0;
  Ra.sl[19]=291; /* line # 291 */
  if (F_ti>0) {
    Ra.sl[19]=292; /* line # 292 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_INT(F_ti,2,0);
    PAS__WRITE_STR(Rd.s+425,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[19]=293; /* line # 293 */
    if (F_ti>=2) {
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHAR(115);
      PAS__WRITE_EOLN();
    }
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_STR(Rd.s+431,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[19]=295; /* line # 295 */
  if (Rv3>0) {
    Ra.sl[19]=297; /* line # 297 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_INT(Rv3,2,0);
    PAS__WRITE_STR(Rd.s+435,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[19]=298; /* line # 298 */
    if (Rv3>=2) {
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHAR(115);
      PAS__WRITE_EOLN();
    }
    Ra.sl[19]=299; /* line # 299 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_STR(Rd.s+431,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[19]=301; /* line # 301 */
  if (Rv2>0) {
    Ra.sl[19]=303; /* line # 303 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_INT(Rv2,2,0);
    PAS__WRITE_STR(Rd.s+442,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[19]=304; /* line # 304 */
    if (Rv2>=2) {
      PAS__VWRITE_INIT(Ra.s,0);
      PAS__WRITE_CHAR(115);
      PAS__WRITE_EOLN();
    }
    Ra.sl[19]=305; /* line # 305 */
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_STR(Rd.s+431,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[19]=307; /* line # 307 */
  PAS__VWRITE_INIT(Ra.s,0);
  PAS__WRITE_DBLE(Rv4,7,3,0);
  PAS__WRITE_STR(Rd.s+451,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[19]=308; /* line # 308 */
  if (Rv4>=2.000000000000000E+000) {
    PAS__VWRITE_INIT(Ra.s,0);
    PAS__WRITE_CHAR(115);
    PAS__WRITE_EOLN();
  }
  Ra.sl[19]=309; /* line # 309 */
  PAS__VWRITE_INIT(Ra.s,0);
  PAS__WRITE_CHAR(46);
  PAS__WRITE_EOLN();
  Ra.sl[19]=310; /* line # 310 */
  P_lst_put_string(Ra.s);
  Ra.sl[19]=311; /* line # 311 */
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[16];
}
