#include <stdio.h>
#include <signal.h>
#include <fenv.h>
#include <unistd.h>
#include <setjmp.h>
#include <math.h>


sigjmp_buf jmpenv;


void our_handler()
{
  float u = 5.0, v = 2.5, w = 0.0;

  w = u/v;

  siglongjmp( jmpenv, 1 );
}

void full_handler( int signum, siginfo_t * info, void * p )
{
  printf( " Handler with ierr = %d\n", signum );
  if (signum == SIGFPE)
    switch (info->si_code) {
      case FPE_INTDIV:  printf( " Integer Zero Divide\n" ); break;
      case FPE_INTOVF:  printf( " Integer Overflow\n" ); break;
      case FPE_FLTDIV:  printf( " Floating-point Zero Divide\n" ); break;
      case FPE_FLTOVF:  printf( " Floating-point Overflow\n" ); break;
      case FPE_FLTINV:  printf( " Floating-point Invalid Operation\n" ); break;
      default:
        printf( " Unknown SIGFPE error.\n" );
    }


  feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );

//siglongjmp( jmpenv, 1 );

  our_handler();

}


int main()
{
  struct sigaction action;
  float a, b, c;
  int  ii, jj, kk;
  char ope;

  action.sa_sigaction = full_handler;
  sigemptyset( &action.sa_mask );
  action.sa_flags  =  SA_SIGINFO;

  feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
  sigaction( SIGFPE, &action, NULL );

  do {
    if (sigsetjmp( jmpenv, 1 )) goto ET_ERR;

    printf( " ope, a, b = " ); scanf( "%c%f%f", &ope, &a, &b );
    printf( " Perform %f %c %f\n", a, ope, b );

    switch (ope) {
      case 'm':
      case 'M': ii = (int) a; jj = (int) b; kk = ii*jj; c = (float) kk; break;
      case 'd':
      case 'D': ii = (int) a; jj = (int) b; kk = ii/jj; c = (float) kk; break;
      case '+': c = a + b; break;
      case '-': c = a - b; break;
      case '*': c = a * b; break;
      case '/': c = a / b; break;
      case 's':
      case 'S': c = b*sqrt( a ); break;
      case 'l':
      case 'L': c = b*log( a ); break;
      case 'e':
      case 'E': c = b*exp( a ); break;
      default:
        printf( " bad operation code %c\n", ope );
    }
    printf( " %f %c %f = %f\n", a, ope, b, c );
    continue;

ET_ERR:
    printf( " Return (goto) from handler\n" );

  } while (a != -1.0);

  return 0;
}
