#include <stdio.h>
#include <signal.h>
#include <fenv.h>
#include <unistd.h>
#include <setjmp.h>


sigjmp_buf jmpenv;


void hand( int ierr )
{
  printf( " Handler with ierr = %d\n", ierr );
  feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
  siglongjmp( jmpenv, 1 );
}


int main()
{
  struct sigaction action;
  float a, b, c;

  action.sa_handler = hand;
  sigemptyset( &action.sa_mask );
  action.sa_flags   =    0;

  feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
  sigaction( SIGFPE, &action, NULL );

  do {
    if (sigsetjmp( jmpenv, 1 )) goto ET_ERR;

    printf( " a, b = " ); scanf( "%f%f", &a, &b );
    printf( " Perform %f/%f\n", a, b );
    c = a/b;
    printf( " %f/%f = %f\n", a, b, c );
    continue;

ET_ERR:
    printf( " Return from handler\n" );

  } while (a != -1.0);

  return 0;
}
