/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 480 ) = {
 10,  10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  54,  54,  47, 104,
111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,
 95, 115, 114,  99,  47,  99, 112,  97, 115,  95,  98,  95,  95, 115, 114,  99,
 46, 112,  97, 115,  12,  12, 115, 114,  99,  95,  97, 108, 108, 111,  99,  97,
116, 101,   8,   8, 115, 114,  99,  95, 102, 114, 101, 101,   9,   9, 115, 114,
 99,  95,  99, 108, 111, 115, 101,   8,   8, 115, 114,  99,  95, 111, 112, 101,
110,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 116, 101, 120, 116,  95,
108, 105, 110, 101,  11,  11, 115, 114,  99,  95, 111, 117, 116, 108, 105, 110,
101,  17,  17, 115, 114,  99,  95, 111, 117, 116, 101, 114, 114,  95,  98,  97,
110, 110, 101, 114,  40,  40,  32,  37,  42,  43,  42,  43,  42,  32, 101, 114,
114, 111, 114,  40, 115,  41,  32, 119,  97, 115,  32, 100, 101, 116, 101,  99,
116, 101, 100,  32,  97, 116,  32, 108, 105, 110, 101,  32,  35,  32,  16,  16,
 32, 105, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  58,  32,  34,
 13,  13, 115, 114,  99,  95, 111, 117, 116,  95, 101, 114, 114, 111, 114,  15,
 15,  83,  82,  67,  95,  79,  85,  84,  95,  69,  82,  82,  79,  82,  32,  48,
 15,  15,  83,  82,  67,  95,  79,  85,  84,  95,  69,  82,  82,  79,  82,  32,
 49,  15,  15,  83,  82,  67,  95,  79,  85,  84,  95,  69,  82,  82,  79,  82,
 32,  50,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 109,  97,  99,  95,
101, 114, 114, 111, 114,   9,   9, 115, 114,  99,  95, 101, 114, 114, 111, 114,
 17,  17, 115, 114,  99,  95, 103, 101, 116,  95, 105, 110, 112, 117, 116, 108,
105, 110, 101,  14,  14, 115, 114,  99,  95, 112, 117, 116,  95, 112, 114, 111,
109, 112, 116,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95, 108, 105, 110,
101,  15,  15, 115, 114,  99,  95, 101, 110, 100,  95, 111, 102,  95, 108, 105,
110, 101,   4,   4,  83,  95,  71,  76,  12,  12, 115, 114,  99,  95, 103, 101,
116,  95,  99, 104,  97, 114,  12,  12, 115, 107, 105, 112,  95,  99, 111, 109,
109, 101, 110, 116,  10,  10, 115, 114,  99,  95, 105, 110,  99, 104,  97, 114,
 13,  13, 115, 114,  99,  95, 110, 101, 120, 116,  95,  99, 104,  97, 114,  15,
 15, 115, 114,  99,  95, 115, 101,  97, 114,  99, 104,  95,  99, 104,  97, 114,
  8,   8, 115, 114,  99,  95, 105, 110, 105, 116,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=181; /* line # 181 */
  Rv0=F_p;
  Ra.sl[3]=184; /* line # 184 */
  ((V *)Rv0)[1]=NULL;
  Ra.sl[3]=185; /* line # 185 */
  ((SL *)Rv0)[3]=0;
  Ra.sl[3]=186; /* line # 186 */
  ((SL *)Rv0)[4]=0;
  Ra.sl[3]=187; /* line # 187 */
  ((SL *)Rv0)[5]=0;
  Ra.sl[3]=188; /* line # 188 */
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=189; /* line # 189 */
  ((SL *)Rv0)[8]=0;
  Ra.sl[3]=190; /* line # 190 */
  ((SL *)Rv0)[9]=1;
  Ra.sl[3]=191; /* line # 191 */
  ((C *)Rv0)[45]=32;
  Ra.sl[3]=192; /* line # 192 */
  ((C *)Rv0)[46]=32;
  Ra.sl[3]=193; /* line # 193 */
  ((C *)Rv0)[44]=1;
  Ra.sl[3]=194; /* line # 194 */
  ((SL *)Rv0)[10]=255;
  Ra.sl[3]=195; /* line # 195 */
  Rv1=1;
  for( Rf0=8;Rf0>0;Rf0-- ) {
    Ra.sl[3]=196; /* line # 196 */
    ((V *)Rv0)[Rv1*5+11]=NULL;
    Rv1++;
  }
  Ra.sl[3]=200; /* line # 200 */
  ((UL *)Rv0)[52]=16456;
  Ra.sl[3]=201; /* line # 201 */
  ((UB *)Rv0)[212]=0;
  Ra.sl[3]=202; /* line # 202 */
  ((UB *)((V *)Rv0)[54])[1]=0;
  Ra.sl[3]=204; /* line # 204 */
  P_str_copy_lim(((V *)Rv0)+55,V_def_prompt,64);
  Ra.sl[3]=205; /* line # 205 */
  _FILE_CLEAR(((V *)Rv0)[57]);
  Ra.sl[3]=206; /* line # 206 */
  _FILE_CLEAR(((V *)Rv0)[56]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V P_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+68;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=220; /* line # 220 */
  Rv0=PAS__NEW(232);
  Ra.sl[3]=221; /* line # 221 */
  Rv1=Rv0;
  Ra.sl[3]=223; /* line # 223 */
  ((V *)Rv1)[0]=V_src_hde;
  Ra.sl[3]=224; /* line # 224 */
  ((V *)Rv1)[54]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[54])[0]=255;
  ((UB *)((V *)Rv1)[54])[1]=0;
  Ra.sl[3]=225; /* line # 225 */
  ((V *)Rv1)[55]=PAS__NEW(257);
  ((UB *)((V *)Rv1)[55])[0]=255;
  ((UB *)((V *)Rv1)[55])[1]=0;
  Ra.sl[3]=227; /* line # 227 */
  BASIC_SRC_src_r_init(Rv0);
  Ra.sl[3]=228; /* line # 228 */
  V_src_hde=Rv0;
  Ra.sl[3]=229; /* line # 229 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+82;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=240; /* line # 240 */
  Rv0=NULL;
  Ra.sl[3]=241; /* line # 241 */
  if (F_p!=NULL) {
    Ra.sl[3]=243; /* line # 243 */
    Rv1=V_src_hde;
    Ra.sl[3]=244; /* line # 244 */
    while (Rv1!=F_p&&Rv1!=NULL){
      Ra.sl[3]=246; /* line # 246 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else {
    Ra.sl[3]=248; /* line # 248 */
    Rv1=NULL;
  }
  Ra.sl[3]=249; /* line # 249 */
  if (Rv1!=NULL) {
    Ra.sl[3]=251; /* line # 251 */
    Rv2=F_p;
    Ra.sl[3]=253; /* line # 253 */
    PAS__DISPOSE(((V *)Rv2)+54);
    Ra.sl[3]=254; /* line # 254 */
    if (!(512&((UL *)Rv2)[52])) {
      Ra.sl[3]=255; /* line # 255 */
      PAS__DISPOSE(((V *)Rv2)+55);
    }
    Ra.sl[3]=257; /* line # 257 */
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else {
      Ra.sl[3]=258; /* line # 258 */
      ((V *)Rv0)[0]=((V *)Rv2)[0];
    }
    Ra.sl[3]=260; /* line # 260 */
    PAS__DISPOSE(&F_p);
    Ra.sl[3]=261; /* line # 261 */
    F_p=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+92;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=274; /* line # 274 */
  if ((*F_p)!=NULL) {
    Ra.sl[3]=275; /* line # 275 */
    Rv0=(*F_p);
    Ra.sl[3]=277; /* line # 277 */
    if (128&((UL *)Rv0)[52]) Rv1=2048;
    else {
      Ra.sl[3]=278; /* line # 278 */
      Rv1=0;
    }
    Ra.sl[3]=279; /* line # 279 */
    PAS__CLOSE(((V *)Rv0)+57,Rv1);
    Ra.sl[3]=280; /* line # 280 */
    if (8&((UL *)Rv0)[52]) PAS__CLOSE(((V *)Rv0)+56,0);
  }
  Ra.sl[3]=282; /* line # 282 */
  if (!F_bfree) BASIC_SRC_src_r_init((*F_p));
  else {
    Ra.sl[3]=283; /* line # 283 */
    P_src_free((*F_p));
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_open "  */
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=301; /* line # 301 */
  (*F_ierr)=0;
  Ra.sl[3]=302; /* line # 302 */
  if ((*F_p)==NULL) {
    Ra.sl[3]=303; /* line # 303 */
    Rv0=0;
    (*F_p)=P_src_allocate();
  }
  else {
    Ra.sl[3]=306; /* line # 306 */
    Rv0=1;
    Ra.sl[3]=307; /* line # 307 */
    P_src_close(F_p,0);
  }
  Ra.sl[3]=309; /* line # 309 */
  Rv1=(*F_p);
  Ra.sl[3]=311; /* line # 311 */
  if (((UB *)F_fspc)[1]==0) {
    Ra.sl[3]=313; /* line # 313 */
    _FILE_DUPLICATE(((V *)Rv1)[57],PAS__f_input);
    Ra.sl[3]=314; /* line # 314 */
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]|16;
    Ra.sl[3]=315; /* line # 315 */
    PAS__iostatus=0;
  }
  else {
    Ra.sl[3]=317; /* line # 317 */
    PAS__OPEN(((V *)Rv1)+57,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  }
  Ra.sl[3]=319; /* line # 319 */
  if (PAS__iostatus==0) {
    Ra.sl[3]=322; /* line # 322 */
    ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~8;
    Ra.sl[3]=323; /* line # 323 */
    if (PAS__TTY_FILE(((V *)Rv1)[57])) {
      Ra.sl[3]=325; /* line # 325 */
      if (((UB *)F_fspc)[1]==0) {
        Ra.sl[3]=327; /* line # 327 */
        _FILE_DUPLICATE(((V *)Rv1)[56],PAS__f_output);
        Ra.sl[3]=328; /* line # 328 */
        PAS__iostatus=0;
      }
      else {
        Ra.sl[3]=330; /* line # 330 */
        PAS__OPEN(((V *)Rv1)+56,0, F_fspc,4098,0,-1);
      }
      Ra.sl[3]=331; /* line # 331 */
      if (PAS__iostatus!=0) {
        Ra.sl[3]=332; /* line # 332 */
        (*F_ierr)=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+57,0);
      }
      else {
        Ra.sl[3]=334; /* line # 334 */
        ((UL *)Rv1)[52]=((UL *)Rv1)[52]|8;
      }
    }
    Ra.sl[3]=336; /* line # 336 */
    if (!(8&((UL *)Rv1)[52])) {
      Ra.sl[3]=337; /* line # 337 */
      if (F_bdelete) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|128;
    }
  }
  else {
    Ra.sl[3]=339; /* line # 339 */
    (*F_ierr)=PAS__iostatus;
  }
  Ra.sl[3]=340; /* line # 340 */
  if ((*F_ierr)!=0) {
    Ra.sl[3]=341; /* line # 341 */
    if (Rv0) BASIC_SRC_src_r_init((*F_p));
    else {
      Ra.sl[3]=342; /* line # 342 */
      P_src_free((*F_p));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+113;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=355; /* line # 355 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Ra.sl[3]=356; /* line # 356 */
  Rv1=V_lst_current;
  Ra.sl[3]=358; /* line # 358 */
  if (F_bterm) Rv2=80;
  else {
    Ra.sl[3]=359; /* line # 359 */
    Rv2=((SL *)Rv1)[9];
  }
  Ra.sl[3]=360; /* line # 360 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Ra.sl[3]=362; /* line # 362 */
    Rv0=Rv0+1;
    Ra.sl[3]=363; /* line # 363 */
    if (Rv0>Rv2) {
      Ra.sl[3]=365; /* line # 365 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      Ra.sl[3]=366; /* line # 366 */
      if (!F_bterm) ((SL *)Rv1)[5]=((SL *)Rv1)[5]+1;
      Ra.sl[3]=367; /* line # 367 */
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    Ra.sl[3]=369; /* line # 369 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[3]=371; /* line # 371 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+132;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=383; /* line # 383 */
  Rv0=V_src_control;
  Ra.sl[3]=385; /* line # 385 */
  if (V_src_lstinsnb!=((SL *)Rv0)[4]) {
    Ra.sl[3]=387; /* line # 387 */
    V_src_lstinsnb=((SL *)Rv0)[4];
    Ra.sl[3]=388; /* line # 388 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[4],5,0);
  }
  else {
    Ra.sl[3]=390; /* line # 390 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  Ra.sl[3]=392; /* line # 392 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[45]);
  PAS__WRITE_CHAR(((C *)Rv0)[46]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[5],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[3]=393; /* line # 393 */
  Rv1=((V *)Rv0)[54];
  Rv2=V_lst_current;
  Ra.sl[3]=395; /* line # 395 */
  if (F_bterm) Rv3=80;
  else {
    Ra.sl[3]=396; /* line # 396 */
    Rv3=((SL *)Rv2)[9];
  }
  Ra.sl[3]=397; /* line # 397 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[8],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[3]=398; /* line # 398 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Ra.sl[3]=400; /* line # 400 */
    Rv4=20;
    Ra.sl[3]=401; /* line # 401 */
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[3]=403; /* line # 403 */
      Rv4=Rv4+1;
      Ra.sl[3]=404; /* line # 404 */
      if (Rv4>Rv3) {
        Ra.sl[3]=406; /* line # 406 */
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        Ra.sl[3]=407; /* line # 407 */
        if (!F_bterm) ((SL *)Rv2)[5]=((SL *)Rv2)[5]+1;
        Ra.sl[3]=408; /* line # 408 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      Ra.sl[3]=410; /* line # 410 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    Ra.sl[3]=412; /* line # 412 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=414; /* line # 414 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[54],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+145;
  Ra.v[67]=Rd.s+12;
  Ra.sl[68]=433; /* line # 433 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[68]=435; /* line # 435 */
  Ra.ub[1]=Ra.ub[0];
  Ra.sl[68]=436; /* line # 436 */
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[68]=439; /* line # 439 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[9]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Ra.sl[68]=440; /* line # 440 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Ra.sl[68]=441; /* line # 441 */
    Rv5=(((S *)Rv0)+Rv4*20+28);
    Ra.sl[68]=442; /* line # 442 */
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  Ra.sl[68]=443; /* line # 443 */
  if (((UB *)((V *)Rv0)[54])[1]>((SL *)Rv0)[10]) {
    Ra.sl[68]=446; /* line # 446 */
    Rv6=((SL *)Rv0)[10]+1;
    for( Rf0=(((UB *)((V *)Rv0)[54])[1]+1)-(((SL *)Rv0)[10]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.sl[68]=447; /* line # 447 */
    Ra.ub[1]=((UB *)((V *)Rv0)[54])[1];
  }
  else {
    Ra.sl[68]=449; /* line # 449 */
    Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[7]*5+7];
  }
  Ra.sl[68]=451; /* line # 451 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  Ra.sl[68]=452; /* line # 452 */
  if (F_bterm) {
    Ra.sl[68]=454; /* line # 454 */
    P_lst_newline();
    Ra.sl[68]=455; /* line # 455 */
    ((SL *)Rv1)[5]=((SL *)Rv1)[5]+1;
  }
  Ra.sl[68]=457; /* line # 457 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+164,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[8],5,0);
  PAS__WRITE_EOLN();
  Ra.sl[68]=458; /* line # 458 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+206,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+276,((V *)Rv0)[57]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+224;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=466; /* line # 466 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+239,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=467; /* line # 467 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[3]=469; /* line # 469 */
  if ((1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5])&&!(64&((UB *)Rv1)[44])
  ) {
    Ra.sl[3]=472; /* line # 472 */
    ((SL *)Rv1)[5]=((SL *)Rv1)[5]+1;
    Ra.sl[3]=474; /* line # 474 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+256,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=475; /* line # 475 */
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+12,0);
    Ra.sl[3]=476; /* line # 476 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+273,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=477; /* line # 477 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=479; /* line # 479 */
      P_lst_newline();
      Ra.sl[3]=480; /* line # 480 */
      ((SL *)Rv1)[5]=((SL *)Rv1)[5]+1;
      Ra.sl[3]=481; /* line # 481 */
      P_err_display(((V *)Rv1)+12,Rv2,(((S *)Rv0)+Rv2*20+28));
      Rv2++;
    }
    Ra.sl[3]=483; /* line # 483 */
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[12]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=485; /* line # 485 */
  if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[44]) {
    Ra.sl[3]=487; /* line # 487 */
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    Ra.sl[3]=488; /* line # 488 */
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Ra.sl[3]=489; /* line # 489 */
    Rv3=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=490; /* line # 490 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*20+28));
      Rv3++;
    }
    Ra.sl[3]=491; /* line # 491 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=494; /* line # 494 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
    Ra.sl[3]=495; /* line # 495 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*5+11));
    Rv4++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+290;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=504; /* line # 504 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[3]=505; /* line # 505 */
  if (((SL *)Rv0)[7]>0) {
    Ra.sl[3]=507; /* line # 507 */
    if (64&((UL *)Rv0)[52]||64&((UB *)Rv1)[44]) (*F_out_mac_line)(&PAS__f_output,1);
    Ra.sl[3]=508; /* line # 508 */
    BASIC_SRC_src_out_error(1);
    Ra.sl[3]=509; /* line # 509 */
    ((SL *)Rv0)[7]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+16,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+309;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=525; /* line # 525 */
  Rv0=V_src_control;
  Ra.sl[3]=528; /* line # 528 */
  if (((SL *)Rv0)[2]<((SL *)Rv0)[9]) ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  else {
    Ra.sl[3]=529; /* line # 529 */
    if (((SL *)Rv0)[2]>((SL *)Rv0)[10]) ((SL *)Rv0)[2]=((SL *)Rv0)[10];
  }
  Ra.sl[3]=531; /* line # 531 */
  if (((SL *)Rv0)[7]>=8) {
    Ra.sl[3]=533; /* line # 533 */
    ((SL *)Rv0)[7]=8;
    Rv1=0;
  }
  else {
    Ra.sl[3]=537; /* line # 537 */
    Rv1=1;
    Ra.sl[3]=538; /* line # 538 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[7];Rf0>0;Rf0-- ) {
      Ra.sl[3]=539; /* line # 539 */
      if (((SL *)Rv0)[2]==((SL *)Rv0)[Rv2*5+7]) Rv1=0;
      Rv2++;
    }
    Ra.sl[3]=540; /* line # 540 */
    if (Rv1) ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
  }
  Ra.sl[3]=542; /* line # 542 */
  if (Rv1) {
    Ra.sl[3]=543; /* line # 543 */
    Rv3=(((S *)Rv0)+((SL *)Rv0)[7]*20+28);
    Ra.sl[3]=545; /* line # 545 */
    ((SL *)Rv3)[0]=((SL *)Rv0)[2];
    Ra.sl[3]=546; /* line # 546 */
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[3]=547; /* line # 547 */
    ((SL *)Rv3)[1]=F_number;
    Ra.sl[3]=548; /* line # 548 */
    ((UB *)Rv3)[8]=F_severity;
    Ra.sl[3]=549; /* line # 549 */
    memcpy(Rv3+9,Ra.s+16,4);
    Ra.sl[3]=550; /* line # 550 */
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[7]*20+28));
  }
  else {
    Ra.sl[3]=553; /* line # 553 */
    ((UB *)Rv0)[((SL *)Rv0)[7]*20+36]=F_severity;
  }
  Ra.sl[3]=555; /* line # 555 */
  if (!(512&((UL *)Rv0)[52])&&PAS__EOF(((V *)Rv0)[57])) BASIC_SRC_src_out_error(0);
  Ra.sl[3]=557; /* line # 557 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  Ra.sl[3]=558; /* line # 558 */
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+320;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=580; /* line # 580 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  Ra.sl[3]=582; /* line # 582 */
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Ra.sl[3]=583; /* line # 583 */
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[3]=585; /* line # 585 */
  ((UB *)Rv0)[1]=0;
  Ra.sl[3]=586; /* line # 586 */
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    Ra.sl[3]=588; /* line # 588 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    Ra.sl[3]=589; /* line # 589 */
    if (Rv2==9) while (1){
      Ra.sl[3]=591; /* line # 591 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      Ra.sl[3]=592; /* line # 592 */
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      Ra.sl[3]=595; /* line # 595 */
      if (Rv2>=32) {
        Ra.sl[3]=596; /* line # 596 */
        if (((UB *)Rv0)[1]<255) {
          Ra.sl[3]=598; /* line # 598 */
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[3]=601; /* line # 601 */
          ((UL *)Rv1)[52]=((UL *)Rv1)[52]|256;
        }
      }
    }
  }
  Ra.sl[3]=603; /* line # 603 */
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|65536;
  else {
    Ra.sl[3]=604; /* line # 604 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  Ra.sl[3]=605; /* line # 605 */
  ((SL *)Rv1)[8]=((SL *)Rv1)[8]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+339;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=615; /* line # 615 */
  if (F_pstr!=NULL) {
    Ra.sl[3]=616; /* line # 616 */
    Rv0=V_src_control;
    Ra.sl[3]=617; /* line # 617 */
    if (8&((UL *)Rv0)[52]) {
      Ra.sl[3]=620; /* line # 620 */
      PAS__SELECT_OUT(((V *)Rv0)[56]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+355;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=631; /* line # 631 */
  Rv0=V_src_control;
  Ra.sl[3]=633; /* line # 633 */
  ((SL *)Rv0)[3]=((SL *)Rv0)[9]-1;
  Ra.sl[3]=634; /* line # 634 */
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=636; /* line # 636 */
  if (512&((UL *)Rv0)[52]) {
    Ra.sl[3]=638; /* line # 638 */
    P_vsr_nextstring();
    Ra.sl[3]=639; /* line # 639 */
    ((SL *)Rv0)[8]=((SL *)Rv0)[8]+1;
  }
  else {
    Ra.sl[3]=644; /* line # 644 */
    if (8&((UL *)Rv0)[52]) P_src_put_prompt(((V *)Rv0)[55]);
    Ra.sl[3]=646; /* line # 646 */
    P_src_get_inputline(((V *)Rv0)+57,((V *)Rv0)+54);
    Ra.sl[3]=647; /* line # 647 */
    if (32&((UL *)Rv0)[52]) {
      Ra.sl[3]=649; /* line # 649 */
      if (8&((UL *)Rv0)[52]) P_lst_put_string(((V *)Rv0)[55]);
      Ra.sl[3]=650; /* line # 650 */
      P_lst_put_string(((V *)Rv0)[54]);
      Ra.sl[3]=651; /* line # 651 */
      P_lst_eoln();
    }
  }
  Ra.sl[3]=654; /* line # 654 */
  ((SL *)Rv0)[2]=((SL *)Rv0)[9];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+369;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=665; /* line # 665 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[3]=667; /* line # 667 */
  if (256&((UL *)Rv0)[52]) {
    Ra.sl[3]=670; /* line # 670 */
    ((SL *)Rv0)[2]=((SL *)Rv0)[10]-1;
    P_src_error(Rd.s+388,1,2);
    Ra.sl[3]=671; /* line # 671 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~256;
  }
  Ra.sl[3]=673; /* line # 673 */
  if (1&((UL *)Rv0)[52]&&((SL *)Rv0)[6]>=((SL *)Rv0)[5]) {
    Ra.sl[3]=674; /* line # 674 */
    if (!(64&((UB *)Rv1)[44])) {
      Ra.sl[3]=677; /* line # 677 */
      P_lst_newline();
      Ra.sl[3]=678; /* line # 678 */
      BASIC_SRC_src_outline(((V *)Rv1)+12,0);
    }
  }
  Ra.sl[3]=680; /* line # 680 */
  if (((SL *)Rv0)[7]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+392;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=691; /* line # 691 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Ra.sl[3]=693; /* line # 693 */
  while (!(65536&((UL *)Rv0)[52])&&16384&((UL *)Rv0)[52]){
    Ra.sl[3]=698; /* line # 698 */
    if (((SL *)Rv0)[8]>0&&!(2048&((UL *)Rv0)[52])) {
      Ra.sl[3]=699; /* line # 699 */
      P_src_end_of_line();
    }
    Ra.sl[3]=701; /* line # 701 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~18432;
    Ra.sl[3]=702; /* line # 702 */
    BASIC_SRC_src_get_line();
    Ra.sl[3]=704; /* line # 704 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|4096;
  }
  Ra.sl[3]=706; /* line # 706 */
  if (!(65536&((UL *)Rv0)[52])) {
    Ra.sl[3]=707; /* line # 707 */
    if (((SL *)Rv0)[3]>=((SL *)Rv0)[10]||((SL *)Rv0)[3]>=((UB *)Rv1)[1]) {
      Ra.sl[3]=709; /* line # 709 */
      if (2048&((UL *)Rv0)[52]&&((SL *)Rv0)[8]>0) {
        Ra.sl[3]=710; /* line # 710 */
        P_src_end_of_line();
      }
      Ra.sl[3]=711; /* line # 711 */
      if ((9216&((UL *)Rv0)[52])!=0) {
        Ra.sl[3]=712; /* line # 712 */
        Rv2=1;
      }
      else Rv2=32;
      Ra.sl[3]=713; /* line # 713 */
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]|16384;
    }
    else {
      Ra.sl[3]=717; /* line # 717 */
      ((SL *)Rv0)[3]=((SL *)Rv0)[3]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[3]+1];
    }
  }
  else {
    Ra.sl[3]=721; /* line # 721 */
    Rv2=0;
    Ra.sl[3]=722; /* line # 722 */
    ((UL *)Rv0)[52]=((UL *)Rv0)[52]|32768;
  }
  Ra.sl[3]=725; /* line # 725 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+406;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=737; /* line # 737 */
  Rv0=0;
  Ra.sl[3]=738; /* line # 738 */
  Rv1=V_src_control;
  Ra.sl[3]=741; /* line # 741 */
  if (4096&((UL *)Rv1)[52]&&((C *)Rv1)[45]==32) {
    Ra.sl[3]=742; /* line # 742 */
    ((C *)Rv1)[45]=67;
  }
  Ra.sl[3]=743; /* line # 743 */
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]|8192;
  Ra.sl[3]=744; /* line # 744 */
  Rv2=((UB *)Rv1)[212];
  Ra.sl[3]=745; /* line # 745 */
  ((UB *)Rv1)[212]=4;
  while (1){
    while (1){
      Ra.sl[3]=748; /* line # 748 */
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==0||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[3]=750; /* line # 750 */
    switch (Rv2) {
      case 0:Ra.sl[3]=753; /* line # 753 */
      Rv0=F_stp==125&&Rv3==F_stp||Rv3==0;
      Ra.sl[3]=754; /* line # 754 */
      if (F_stp==42&&Rv3!=0) {
        Ra.sl[3]=756; /* line # 756 */
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) {
          Ra.sl[3]=758; /* line # 758 */
          Rv0=((C *)((V *)Rv1)[54])[(((SL *)Rv1)[3]+1)+1]==41;
          Ra.sl[3]=759; /* line # 759 */
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[3]=765; /* line # 765 */
      if (Rv3!=0) {
        Ra.sl[3]=767; /* line # 767 */
        if (((SL *)Rv1)[3]<((UB *)((V *)Rv1)[54])[1]) Rv3=BASIC_SRC_src_get_char();
        Ra.sl[3]=768; /* line # 768 */
        Rv0=Rv3==47;
      }
      else {
        Ra.sl[3]=769; /* line # 769 */
        Rv0=1;
      }
      break;
      case 2:
      case 3:
      case 4:Ra.sl[3]=774; /* line # 774 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[3]=779; /* line # 779 */
  if (F_nlmd) ((UL *)Rv1)[52]=((UL *)Rv1)[52]&~8192;
  Ra.sl[3]=780; /* line # 780 */
  ((UB *)Rv1)[212]=Rv2;
  Ra.sl[3]=782; /* line # 782 */
  if (Rv3!=0) {
    Ra.sl[3]=783; /* line # 783 */
    if (Rv3==1&&!(1024&((UL *)Rv1)[52])||Rv3>1) {
      Ra.sl[3]=785; /* line # 785 */
      Rv3=32;
    }
  }
  Ra.sl[3]=787; /* line # 787 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+420;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=800; /* line # 800 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Ra.sl[3]=802; /* line # 802 */
  Rv2=BASIC_SRC_src_get_char();
  Ra.sl[3]=803; /* line # 803 */
  switch (((UB *)Rv0)[212]) {
    case 0:Ra.sl[3]=806; /* line # 806 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      Ra.sl[3]=807; /* line # 807 */
      if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
        Ra.sl[3]=808; /* line # 808 */
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
          Ra.sl[3]=810; /* line # 810 */
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[3]=811; /* line # 811 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:Ra.sl[3]=815; /* line # 815 */
    if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      Ra.sl[3]=816; /* line # 816 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==42) {
        Ra.sl[3]=818; /* line # 818 */
        Rv2=BASIC_SRC_src_get_char();
        Ra.sl[3]=819; /* line # 819 */
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[3]=823; /* line # 823 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:Ra.sl[3]=826; /* line # 826 */
    if (((SL *)Rv0)[3]<((UB *)Rv1)[1]) {
      Ra.sl[3]=827; /* line # 827 */
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[3]+1)+1]==45) {
        Ra.sl[3]=828; /* line # 828 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[3]=833; /* line # 833 */
    break;
  }
  Ra.sl[3]=835; /* line # 835 */
  if (4096&((UL *)Rv0)[52]) {
    Ra.sl[3]=836; /* line # 836 */
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[3]=838; /* line # 838 */
      ((UL *)Rv0)[52]=((UL *)Rv0)[52]&~4096;
      Ra.sl[3]=839; /* line # 839 */
      if (((C *)Rv0)[45]==67) ((C *)Rv0)[45]=32;
    }
  }
  Ra.sl[3]=842; /* line # 842 */
  ((C *)Rv0)[44]=Rv2;
  Ra.sl[3]=843; /* line # 843 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+432;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=852; /* line # 852 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Ra.sl[3]=853; /* line # 853 */
  if (((SL *)Rv0)[3]>=((UB *)Rv1)[1]||((SL *)Rv0)[3]>=((SL *)Rv0)[10]) {
    Ra.sl[3]=854; /* line # 854 */
    Ret=32;
  }
  else {
    Ra.sl[3]=856; /* line # 856 */
    Ret=((C *)Rv1)[(((SL *)Rv0)[3]+1)+1];
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+447;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=869; /* line # 869 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[54];
  Ra.sl[3]=871; /* line # 871 */
  Rv2=((SL *)Rv0)[3];
  Ra.sl[3]=872; /* line # 872 */
  Rv3=1;
  Ra.sl[3]=873; /* line # 873 */
  while (Rv3){
    Ra.sl[3]=874; /* line # 874 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[10]) {
      Ra.sl[3]=876; /* line # 876 */
      Rv4=((C *)Rv1)[Rv2+1];
      Ra.sl[3]=877; /* line # 877 */
      if (Rv4==32) Rv2=Rv2+1;
      else {
        Ra.sl[3]=878; /* line # 878 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[3]=882; /* line # 882 */
      Rv3=0;
      Ra.sl[3]=883; /* line # 883 */
      Rv4=32;
    }
  }
  Ra.sl[3]=886; /* line # 886 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=-1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+464;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=908; /* line # 908 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Ra.sl[3]=910; /* line # 910 */
  Rv1=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv1]=0;
    Rv1++;
  }
  Ra.sl[3]=911; /* line # 911 */
  V_error_result=0;
  Ra.sl[3]=913; /* line # 913 */
  V_src_control=NULL;
  Ra.sl[3]=914; /* line # 914 */
  if (((UB *)F_def_src)[1]>0) {
    Ra.sl[3]=915; /* line # 915 */
    P_src_open(&V_src_control, F_def_src,0, &Rv0);
  }
  Ra.sl[3]=916; /* line # 916 */
  if (Rv0==0) {
    Ra.sl[3]=917; /* line # 917 */
    Rv2=V_src_control;
    Ra.sl[3]=919; /* line # 919 */
    ((SL *)Rv2)[5]=1;
    Ra.sl[3]=920; /* line # 920 */
    ((SL *)Rv2)[6]=1;
  }
  else {
    Ra.sl[3]=922; /* line # 922 */
    V_src_control=NULL;
  }
  Ra.sl[3]=923; /* line # 923 */
  V_src_hde=V_src_control;
  Ra.sl[3]=924; /* line # 924 */
  V_src_cont_base=V_src_control;
  PAS__curr_cntx=Ra.v[0];
}
