/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 568 ) = {
 12,  12, 115, 116, 114,  95,  99, 111, 112, 121,  95, 108, 105, 109,  54,  54,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,
 86,  52,  95, 115, 114,  99,  47,  99, 112,  97, 115,  95,  98,  95,  95, 108,
115, 116,  46, 112,  97, 115,   8,   8, 108, 115, 116,  95, 105, 110, 105, 116,
 12,  12, 108, 115, 116,  95,  97, 108, 108, 111,  99,  97, 116, 101,   8,   8,
108, 115, 116,  95, 102, 114, 101, 101,   9,   9, 108, 115, 116,  95,  99, 108,
111, 115, 101,  18,  18, 108, 115, 116,  95,  99, 104,  97, 110, 103, 101,  95,
104, 101,  97, 100, 105, 110, 103,   8,   8,  82, 117, 110,  32, 116, 104, 101,
 32,   4,   4,  32,  97, 116,  32,   9,   9,  92,  72,  69,  65,  68,  73,  78,
 71,  32,   3,   3,  32,  45,  32,   9,   9,  92,  72,  69,  65,  68,  73,  78,
 71,  32,  16,  16, 108, 115, 116,  95,  99, 104,  97, 110, 103, 101,  95, 116,
105, 116, 108, 101,   7,   7,  92,  84,  73,  84,  76,  69,  32,   8,   8,  92,
 84,  73,  84,  76,  69,  32,  48,  19,  19, 108, 115, 116,  95,  99, 104,  97,
110, 103, 101,  95, 115, 117,  98, 116, 105, 116, 108, 101,  10,  10,  92,  83,
 85,  66,  84,  73,  84,  76,  69,  32,  11,  11,  92,  83,  85,  66,  84,  73,
 84,  76,  69,  32,  48,   8,   8, 108, 115, 116,  95, 111, 112, 101, 110,   0,
  0,   0,   0,   0,   0,  11,  11, 108, 115, 116,  95, 110, 101, 119, 108, 105,
110, 101,   5,   5,  80,  97, 103, 101,  32,   8,   8, 108, 115, 116,  95, 101,
111, 108, 110,  15,  15, 108, 115, 116,  95,  98, 114, 101,  97, 107, 111, 117,
116, 112, 117, 116,   8,   8, 108, 115, 116,  95, 112,  97, 103, 101,  14,  14,
108, 115, 116,  95, 115, 101, 116,  95,  99, 111, 108, 117, 109, 110,  14,  14,
108, 115, 116,  95, 115, 101, 116,  95, 109,  97, 114, 103, 105, 110,  13,  13,
108, 115, 116,  95, 115, 107, 105, 112,  95, 108, 105, 110, 101,  10,  10,  92,
 83,  75,  73,  80,  76,  73,  78,  69,  32,  17,  17, 108, 115, 116,  95, 115,
101, 116,  95,  99, 104,  97, 114,  95,  97, 116, 116, 114,   3,   3,  78,  78,
 78,   3,   3,  78,  78,  78,  11,  11,  92,  67,  72,  65,  82,  95,  65,  84,
 84,  82,  32,  13,  13, 108, 115, 116,  95, 116, 101, 115, 116,  95, 108, 105,
110, 101,  11,  11,  92,  84,  69,  83,  84,  95,  76,  73,  78,  69,  32,  12,
 12, 108, 115, 116,  95, 112, 117, 116,  95,  99, 104,  97, 114,  13,  13, 108,
115, 116,  95, 112, 117, 116,  95, 109,  99, 104,  97, 114,  14,  14, 108, 115,
116,  95, 112, 117, 116,  95, 115, 116, 114, 105, 110, 103,  11,  11, 108, 115,
116,  95, 112, 117, 116,  95, 105, 110, 116,  13,  13, 108, 115, 116,  95, 112,
117, 116,  95, 102, 108, 111,  97, 116,  13,  13, 108, 115, 116,  95, 112, 117,
116,  95, 102, 105, 120, 101, 100,  10,  10, 108, 115, 116,  95, 103,  95, 105,
110, 105, 116,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;

/* Declaration of global variables. */
V V_lst_current = NULL;
V V_lst_hde = NULL;
UL V_lst_spc_mode = 0;
Blk(V_lst_date, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_lst_time, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
void P_vls_nextstring();


/* Procedure/Function : " str_copy_lim "  */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=180; /* line # 180 */
  Rv0=((UB *)F_src)[1];
  Ra.sl[3]=181; /* line # 181 */
  if (F_lim==0) F_lim=Rv0;
  else {
    Ra.sl[3]=182; /* line # 182 */
    if (Rv0>F_lim) Rv0=F_lim;
  }
  Ra.sl[3]=183; /* line # 183 */
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  Ra.sl[3]=184; /* line # 184 */
  if (Rv0>0) {
    Ra.sl[3]=186; /* line # 186 */
    Rv1=Rv0;
    (*F_trg)=PAS__NEW((SL)Rv1+2);
    ((UB *)(*F_trg))[0]=Rv1;
    Ra.sl[3]=187; /* line # 187 */
    PAS__STR_TO_STR((*F_trg),F_src);
  }
  else {
    Ra.sl[3]=189; /* line # 189 */
    (*F_trg)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_init "  */
void P_lst_init(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+70;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=197; /* line # 197 */
  Rv0=F_p;
  Ra.sl[3]=200; /* line # 200 */
  ((V *)Rv0)[1]=NULL;
  Ra.sl[3]=201; /* line # 201 */
  ((V *)Rv0)[2]=NULL;
  Ra.sl[3]=202; /* line # 202 */
  ((V *)Rv0)[4]=NULL;
  Ra.sl[3]=203; /* line # 203 */
  ((V *)Rv0)[5]=NULL;
  Ra.sl[3]=204; /* line # 204 */
  ((SL *)Rv0)[6]=0;
  Ra.sl[3]=205; /* line # 205 */
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=206; /* line # 206 */
  ((SL *)Rv0)[8]=0;
  Ra.sl[3]=207; /* line # 207 */
  ((SL *)Rv0)[9]=0;
  Ra.sl[3]=208; /* line # 208 */
  ((SL *)Rv0)[10]=0;
  Ra.sl[3]=209; /* line # 209 */
  ((SL *)Rv0)[11]=0;
  Ra.sl[3]=210; /* line # 210 */
  ((UB *)Rv0)[48]=0;
  Ra.sl[3]=211; /* line # 211 */
  _FILE_CLEAR(((V *)Rv0)[13]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_allocate "  */
V P_lst_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+80;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=222; /* line # 222 */
  Rv0=PAS__NEW(56);
  Ra.sl[3]=223; /* line # 223 */
  ((V *)Rv0)[0]=V_lst_hde;
  V_lst_hde=Rv0;
  Ra.sl[3]=224; /* line # 224 */
  ((V *)Rv0)[3]=PAS__NEW(33);
  ((UB *)((V *)Rv0)[3])[0]=31;
  Ra.sl[3]=225; /* line # 225 */
  P_lst_init(Rv0);
  Ra.sl[3]=226; /* line # 226 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lst_free "  */
void P_lst_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+94;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=238; /* line # 238 */
  Rv0=NULL;
  Ra.sl[3]=239; /* line # 239 */
  if ((*F_p)!=NULL) {
    Ra.sl[3]=241; /* line # 241 */
    Rv1=V_lst_hde;
    Ra.sl[3]=242; /* line # 242 */
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[3]=244; /* line # 244 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else {
    Ra.sl[3]=246; /* line # 246 */
    Rv1=NULL;
  }
  Ra.sl[3]=247; /* line # 247 */
  if (Rv1!=NULL) {
    Ra.sl[3]=248; /* line # 248 */
    Rv2=(*F_p);
    Ra.sl[3]=250; /* line # 250 */
    if (((V *)Rv2)[1]!=NULL) PAS__DISPOSE(((V *)Rv2)+1);
    Ra.sl[3]=251; /* line # 251 */
    if (((V *)Rv2)[3]!=NULL) PAS__DISPOSE(((V *)Rv2)+3);
    Ra.sl[3]=252; /* line # 252 */
    if (((V *)Rv2)[2]!=NULL) PAS__DISPOSE(((V *)Rv2)+2);
    Ra.sl[3]=253; /* line # 253 */
    if (((V *)Rv2)[4]!=NULL) PAS__DISPOSE(((V *)Rv2)+4);
    Ra.sl[3]=254; /* line # 254 */
    if (((V *)Rv2)[5]!=NULL) PAS__DISPOSE(((V *)Rv2)+5);
    Ra.sl[3]=255; /* line # 255 */
    if (Rv0==NULL) V_lst_hde=((V *)Rv2)[0];
    else {
      Ra.sl[3]=256; /* line # 256 */
      ((V *)Rv0)[0]=((V *)Rv2)[0];
    }
    Ra.sl[3]=257; /* line # 257 */
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_close "  */
void P_lst_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=270; /* line # 270 */
  if ((*F_p)!=NULL) {
    Ra.sl[3]=272; /* line # 272 */
    Rv0=(*F_p);
    Ra.sl[3]=274; /* line # 274 */
    if (1&((UB *)Rv0)[48]) Rv1=1024;
    else {
      Ra.sl[3]=275; /* line # 275 */
      Rv1=0;
    }
    Ra.sl[3]=277; /* line # 277 */
    if ((68&((UB *)Rv0)[48])==0) PAS__CLOSE(((V *)Rv0)+13,Rv1);
    Ra.sl[3]=278; /* line # 278 */
    PAS__DISPOSE(((V *)Rv0)+1);
    ((V *)Rv0)[1]=NULL;
    Ra.sl[3]=279; /* line # 279 */
    if (((V *)Rv0)[2]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+2);
      ((V *)Rv0)[2]=NULL;
    }
    Ra.sl[3]=280; /* line # 280 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+4);
      ((V *)Rv0)[4]=NULL;
    }
    Ra.sl[3]=281; /* line # 281 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+5);
      ((V *)Rv0)[5]=NULL;
    }
    Ra.sl[3]=283; /* line # 283 */
    if (F_bfree) P_lst_free(F_p);
    else {
      Ra.sl[3]=284; /* line # 284 */
      P_lst_init((*F_p));
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_heading "  */
void P_lst_change_heading(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+115;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=296; /* line # 296 */
  Rv0=V_lst_current;
  Ra.sl[3]=298; /* line # 298 */
  Rv1=((((SL *)Rv0)[10]-31)-4)-12;
  Ra.sl[3]=301; /* line # 301 */
  if (Rv1<60) Rv1=60;
  Ra.sl[3]=302; /* line # 302 */
  P_str_copy_lim(((V *)Rv0)+2,F_str,Rv1);
  Ra.sl[3]=303; /* line # 303 */
  PAS__DATE_STR(V_lst_date.s);
  PAS__TIME_STR(V_lst_time.s);
  Ra.sl[3]=304; /* line # 304 */
  PAS__VWRITE_INIT(((V *)Rv0)[3],1);
  PAS__WRITE_STR(Rd.s+135,-1,-1,32);
  PAS__WRITE_STR(V_lst_date.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+145,-1,-1,32);
  PAS__WRITE_STR(V_lst_time.s,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=305; /* line # 305 */
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=307; /* line # 307 */
    if (((V *)Rv0)[2]!=NULL) {
      Ra.sl[3]=308; /* line # 308 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+151,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[2])[1]+((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
      PAS__WRITE_STR(Rd.s+162,-1,-1,32);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=311; /* line # 311 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+167,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=312; /* line # 312 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_title "  */
void P_lst_change_title(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+178;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=322; /* line # 322 */
  Rv0=V_lst_current;
  Ra.sl[3]=324; /* line # 324 */
  P_str_copy_lim(((V *)Rv0)+4,F_str,((SL *)Rv0)[10]-1);
  Ra.sl[3]=325; /* line # 325 */
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=327; /* line # 327 */
    if (((V *)Rv0)[4]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+196,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[4])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=328; /* line # 328 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+205,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=329; /* line # 329 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_change_subtitle "  */
void P_lst_change_subtitle(V F_str, UB F_bskp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=339; /* line # 339 */
  Rv0=V_lst_current;
  Ra.sl[3]=341; /* line # 341 */
  P_str_copy_lim(((V *)Rv0)+5,F_str,((SL *)Rv0)[10]-1);
  Ra.sl[3]=342; /* line # 342 */
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=344; /* line # 344 */
    if (((V *)Rv0)[5]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+236,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[5])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=345; /* line # 345 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+248,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=346; /* line # 346 */
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_open "  */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  register UB Rv3;
  SL Rv4;
  UB Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.v[193]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+772;
  Ra.v[194]=Rd.s+261;
  Ra.v[195]=Rd.s+14;
  Ra.sl[196]=386; /* line # 386 */
  if (F_heading!=NULL) PAS__STR_TO_STR(Ra.s,F_heading);
  else PAS__STR_TO_STR(Ra.s,Rd.s+271);
  Ra.sl[196]=387; /* line # 387 */
  if (F_title!=NULL) PAS__STR_TO_STR(Ra.s+257,F_title);
  else PAS__STR_TO_STR(Ra.s+257,Rd.s+273);
  Ra.sl[196]=388; /* line # 388 */
  if (F_sbttl!=NULL) PAS__STR_TO_STR(Ra.s+514,F_sbttl);
  else PAS__STR_TO_STR(Ra.s+514,Rd.s+275);
  Ra.sl[196]=391; /* line # 391 */
  Rv0=(*F_p)!=NULL;
  Ra.sl[196]=392; /* line # 392 */
  if ((*F_p)==NULL) (*F_p)=P_lst_allocate();
  else {
    Ra.sl[196]=393; /* line # 393 */
    P_lst_close(F_p,0);
  }
  Ra.sl[196]=394; /* line # 394 */
  Rv1=(*F_p);
  Ra.sl[196]=396; /* line # 396 */
  if (((UB *)F_fspc)[1]==0) {
    Ra.sl[196]=398; /* line # 398 */
    _FILE_DUPLICATE(((V *)Rv1)[13],PAS__f_output);
    Ra.sl[196]=399; /* line # 399 */
    ((UB *)Rv1)[48]=4;
    Ra.sl[196]=400; /* line # 400 */
    PAS__iostatus=0;
  }
  else {
    Ra.sl[196]=404; /* line # 404 */
    Rv2=4098|V_lst_spc_mode;
    Ra.sl[196]=405; /* line # 405 */
    if (F_bprint) ((UB *)Rv1)[48]=1;
    Ra.sl[196]=406; /* line # 406 */
    if (F_bappend) Rv2=Rv2|4;
    Ra.sl[196]=407; /* line # 407 */
    if (F_bunknown) Rv2=Rv2|64;
    Ra.sl[196]=408; /* line # 408 */
    PAS__OPEN(((V *)Rv1)+13,0, F_fspc,Rv2,0,-1);
  }
  Ra.sl[196]=411; /* line # 411 */
  if (PAS__iostatus==0) {
    Ra.sl[196]=413; /* line # 413 */
    if (PAS__TTY_FILE(((V *)Rv1)[13])) {
      Ra.sl[196]=415; /* line # 415 */
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]|2;
      Ra.sl[196]=416; /* line # 416 */
      ((UB *)Rv1)[48]=((UB *)Rv1)[48]&~1;
      Ra.sl[196]=417; /* line # 417 */
      if (F_lnsize<0) F_lnsize=80;
      Ra.sl[196]=418; /* line # 418 */
      if (F_pgsize<0) F_pgsize=0;
    }
    else {
      Ra.sl[196]=422; /* line # 422 */
      if (F_lnsize<0) F_lnsize=132;
      Ra.sl[196]=423; /* line # 423 */
      if (F_pgsize<0) F_pgsize=-1;
    }
    Ra.sl[196]=426; /* line # 426 */
    Rv3=F_lnsize;
    ((V *)Rv1)[1]=PAS__NEW((SL)Rv3+2);
    ((UB *)((V *)Rv1)[1])[0]=Rv3;
    Ra.sl[196]=427; /* line # 427 */
    ((UB *)((V *)Rv1)[1])[1]=0;
    Ra.sl[196]=428; /* line # 428 */
    Rv4=F_lnsize-1;
    Ra.sl[196]=430; /* line # 430 */
    ((SL *)Rv1)[11]=F_pgsize;
    ((SL *)Rv1)[10]=F_lnsize;
    Ra.sl[196]=431; /* line # 431 */
    ((SL *)Rv1)[9]=((SL *)Rv1)[10];
    Ra.sl[196]=432; /* line # 432 */
    ((SL *)Rv1)[6]=((SL *)Rv1)[11];
    Ra.sl[196]=434; /* line # 434 */
    Rv5=0;
    Ra.sl[196]=435; /* line # 435 */
    if (((V *)Rv1)[2]!=NULL) {
      Rv5=1;
      P_lst_change_heading(Ra.s,0);
    }
    Ra.sl[196]=436; /* line # 436 */
    if (((V *)Rv1)[4]!=NULL) {
      Rv5=1;
      P_lst_change_title(Ra.s+257,0);
    }
    Ra.sl[196]=437; /* line # 437 */
    if (((V *)Rv1)[5]!=NULL) {
      Rv5=1;
      P_lst_change_subtitle(Ra.s+514,1);
    }
    Ra.sl[196]=438; /* line # 438 */
    if (Rv5&&((SL *)Rv1)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv1)[13]);
      PAS__WRITE_EOLN();
    }
    Ra.sl[196]=439; /* line # 439 */
    (*F_ierr)=0;
  }
  else {
    Ra.sl[196]=441; /* line # 441 */
    (*F_ierr)=2000+PAS__iostatus;
  }
  Ra.sl[196]=443; /* line # 443 */
  if ((*F_ierr)!=0) {
    Ra.sl[196]=444; /* line # 444 */
    if (!Rv0) P_lst_free(F_p);
  }
  PAS__curr_cntx=Ra.v[193];
}


/* Procedure/Function : " lst_newline "  */
void P_lst_newline(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+277;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=453; /* line # 453 */
  Rv0=V_lst_current;
  Ra.sl[3]=454; /* line # 454 */
  if (!(64&((UB *)Rv0)[48])) {
    Ra.sl[3]=455; /* line # 455 */
    if (((SL *)Rv0)[11]>=10) {
      Ra.sl[3]=457; /* line # 457 */
      ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
      Ra.sl[3]=458; /* line # 458 */
      if (((SL *)Rv0)[6]>=((SL *)Rv0)[11]) {
        Ra.sl[3]=460; /* line # 460 */
        ((SL *)Rv0)[6]=0;
        Ra.sl[3]=461; /* line # 461 */
        ((SL *)Rv0)[7]=((SL *)Rv0)[7]+1;
        Ra.sl[3]=462; /* line # 462 */
        PAS__PAGE(((V *)Rv0)[13]);
        Ra.sl[3]=463; /* line # 463 */
        if (((V *)Rv0)[2]!=NULL) {
          Ra.sl[3]=465; /* line # 465 */
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
          Ra.sl[3]=466; /* line # 466 */
          if (((SL *)Rv0)[10]<110) {
            ((SL *)Rv0)[6]=1;
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_EOLN();
          }
          else {
            Ra.sl[3]=467; /* line # 467 */
            PAS__SELECT_OUT(((V *)Rv0)[13]);
            PAS__WRITE_STR(Rd.s+162,-1,-1,32);
          }
          Ra.sl[3]=468; /* line # 468 */
          PAS__DATE_STR(V_lst_date.s);
          PAS__TIME_STR(V_lst_time.s);
          Ra.sl[3]=469; /* line # 469 */
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
          PAS__WRITE_FCHAR(32,4,-1,1,32);
          PAS__WRITE_STR(Rd.s+290,-1,-1,32);
          PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=471; /* line # 471 */
        if (((V *)Rv0)[4]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
        }
        Ra.sl[3]=472; /* line # 472 */
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        Ra.sl[3]=473; /* line # 473 */
        if (((V *)Rv0)[5]!=NULL) {
          Ra.sl[3]=475; /* line # 475 */
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_EOLN();
          Ra.sl[3]=476; /* line # 476 */
          PAS__SELECT_OUT(((V *)Rv0)[13]);
          PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
          PAS__WRITE_EOLN();
          Ra.sl[3]=477; /* line # 477 */
          ((SL *)Rv0)[6]=((SL *)Rv0)[6]+2;
        }
        Ra.sl[3]=479; /* line # 479 */
        PAS__SELECT_OUT(((V *)Rv0)[13]);
        PAS__WRITE_EOLN();
        Ra.sl[3]=480; /* line # 480 */
        ((SL *)Rv0)[6]=((SL *)Rv0)[6]+3;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_eoln "  */
void P_lst_eoln(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+297;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=492; /* line # 492 */
  P_lst_newline();
  Ra.sl[3]=493; /* line # 493 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=495; /* line # 495 */
  if (64&((UB *)Rv0)[48]) {
    Ra.sl[3]=497; /* line # 497 */
    P_vls_nextstring();
    Ra.sl[3]=498; /* line # 498 */
    ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
  }
  else {
    Ra.sl[3]=502; /* line # 502 */
    if (((UB *)Rv1)[1]>0) {
      Ra.sl[3]=504; /* line # 504 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      Ra.sl[3]=505; /* line # 505 */
      ((UB *)Rv1)[1]=0;
    }
    Ra.sl[3]=507; /* line # 507 */
    if (8&((UB *)Rv0)[48]) ((UB *)Rv0)[48]=((UB *)Rv0)[48]&~8;
    else {
      Ra.sl[3]=508; /* line # 508 */
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[3]=510; /* line # 510 */
  while (((UB *)Rv1)[1]<((SL *)Rv0)[8]){
    Ra.sl[3]=512; /* line # 512 */
    ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
    Ra.sl[3]=513; /* line # 513 */
    ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_breakoutput "  */
void P_lst_breakoutput(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+307;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=524; /* line # 524 */
  Rv0=V_lst_current;
  Ra.sl[3]=526; /* line # 526 */
  ((UB *)Rv0)[48]=((UB *)Rv0)[48]|8;
  Ra.sl[3]=527; /* line # 527 */
  P_lst_eoln();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_page "  */
void P_lst_page(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+324;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=536; /* line # 536 */
  P_lst_eoln();
  Ra.sl[3]=537; /* line # 537 */
  Rv0=V_lst_current;
  Ra.sl[3]=538; /* line # 538 */
  if (((SL *)Rv0)[11]>=10) ((SL *)Rv0)[6]=((SL *)Rv0)[11];
  else {
    Ra.sl[3]=540; /* line # 540 */
    if (!(64&((UB *)Rv0)[48])) PAS__PAGE(((V *)Rv0)[13]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_column "  */
void P_lst_set_column(SL F_col){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+334;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=548; /* line # 548 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=549; /* line # 549 */
  if (F_col>((SL *)Rv0)[9]) {
    Ra.sl[3]=550; /* line # 550 */
    P_lst_eoln();
  }
  else {
    Ra.sl[3]=553; /* line # 553 */
    F_col=F_col-1;
    Ra.sl[3]=554; /* line # 554 */
    if (((UB *)Rv1)[1]>F_col) P_lst_eoln();
    Ra.sl[3]=555; /* line # 555 */
    while (((UB *)Rv1)[1]<F_col){
      Ra.sl[3]=557; /* line # 557 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[3]=558; /* line # 558 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_margin "  */
void P_lst_set_margin(SL F_lm, SL F_rm){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+350;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=571; /* line # 571 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=572; /* line # 572 */
  if ((F_lm>=0&&F_rm>F_lm)&&F_rm<=((SL *)Rv0)[10]) {
    Ra.sl[3]=574; /* line # 574 */
    Rv2=((SL *)Rv0)[8];
    Ra.sl[3]=575; /* line # 575 */
    ((SL *)Rv0)[8]=F_lm;
    Ra.sl[3]=576; /* line # 576 */
    ((SL *)Rv0)[9]=F_rm;
    Ra.sl[3]=577; /* line # 577 */
    if (((UB *)Rv1)[1]>Rv2) {
      Ra.sl[3]=578; /* line # 578 */
      P_lst_eoln();
    }
    else {
      Ra.sl[3]=580; /* line # 580 */
      while (((UB *)Rv1)[1]<F_lm){
        Ra.sl[3]=582; /* line # 582 */
        ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
        Ra.sl[3]=583; /* line # 583 */
        ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_skip_line "  */
void P_lst_skip_line(SL F_nli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+366;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=593; /* line # 593 */
  if (((SL *)V_lst_current)[11]<0) {
    Ra.sl[3]=594; /* line # 594 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+381,-1,-1,32);
    PAS__WRITE_INT(F_nli,0,0);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=596; /* line # 596 */
    while (F_nli>0){
      Ra.sl[3]=598; /* line # 598 */
      P_lst_eoln();
      F_nli=F_nli-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_set_char_attr "  */
void P_lst_set_char_attr(V F_sattr){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+393;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=611; /* line # 611 */
  Rv0=V_lst_current;
  Ra.sl[3]=612; /* line # 612 */
  if (((SL *)Rv0)[11]<0) {
    Ra.sl[3]=614; /* line # 614 */
    Rv1=1;
    Ra.sl[3]=615; /* line # 615 */
    PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+414,3);
    Ra.sl[3]=616; /* line # 616 */
    Rv2=1;
    for( Rf0=((UB *)F_sattr)[1];Rf0>0;Rf0-- ) {
      Ra.sl[3]=617; /* line # 617 */
      switch (((C *)F_sattr)[Rv2+1]) {
        case 43:Ra.sl[3]=618; /* line # 618 */
        Rv1=1;
        break;
        case 45:Ra.sl[3]=620; /* line # 620 */
        Rv1=0;
        break;
        case 66:
        case 71:
        case 98:
        case 103:Ra.sl[3]=623; /* line # 623 */
        if (Rv1) Ra.c[16]=66;
        else {
          Ra.sl[3]=624; /* line # 624 */
          Ra.c[16]=78;
        }
        break;
        case 73:
        case 105:Ra.sl[3]=626; /* line # 626 */
        if (Rv1) Ra.c[17]=73;
        else {
          Ra.sl[3]=627; /* line # 627 */
          Ra.c[17]=78;
        }
        break;
        case 83:
        case 85:
        case 115:
        case 117:Ra.sl[3]=630; /* line # 630 */
        if (Rv1) Ra.c[18]=83;
        else {
          Ra.sl[3]=631; /* line # 631 */
          Ra.c[18]=78;
        }
        break;
        case 78:
        case 110:Ra.sl[3]=633; /* line # 633 */
        Rv1=1;
        PAS__CHT_TO_CHT(Ra.s+16,3, Rd.s+419,3);
        break;
        default:break;
      }
      Rv2++;
    }
    Ra.sl[3]=637; /* line # 637 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+422,-1,-1,32);
    PAS__WRITE_STR(F_sattr,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_test_line "  */
void P_lst_test_line(SL F_iskip, SL F_tstli){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+435;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=646; /* line # 646 */
  Rv0=V_lst_current;
  Ra.sl[3]=647; /* line # 647 */
  if (((SL *)Rv0)[11]>10) {
    Ra.sl[3]=649; /* line # 649 */
    if (F_tstli>((SL *)Rv0)[11]/2) F_tstli=((SL *)Rv0)[11]/2;
    Ra.sl[3]=650; /* line # 650 */
    if (F_iskip>F_tstli) F_iskip=F_tstli;
    Ra.sl[3]=651; /* line # 651 */
    if (((SL *)Rv0)[11]-((SL *)Rv0)[6]>=F_tstli) P_lst_skip_line(F_iskip);
    else {
      Ra.sl[3]=652; /* line # 652 */
      ((SL *)Rv0)[6]=((SL *)Rv0)[11]+1;
    }
  }
  else {
    Ra.sl[3]=655; /* line # 655 */
    if (((SL *)Rv0)[11]<0) {
      PAS__SELECT_OUT(((V *)Rv0)[13]);
      PAS__WRITE_STR(Rd.s+450,-1,-1,32);
      PAS__WRITE_INT(F_iskip,0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_tstli,0,0);
      PAS__WRITE_EOLN();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_char "  */
void P_lst_put_char(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+463;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=666; /* line # 666 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=668; /* line # 668 */
  if (((UB *)Rv1)[1]>=((SL *)Rv0)[9]) P_lst_eoln();
  Ra.sl[3]=669; /* line # 669 */
  ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
  ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_mchar "  */
void P_lst_put_mchar(C F_ch, SL F_m){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+477;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=678; /* line # 678 */
  Rv0=V_lst_current;
  Ra.sl[3]=680; /* line # 680 */
  if (F_m>0) {
    Ra.sl[3]=681; /* line # 681 */
    while (F_m>0){
      Ra.sl[3]=683; /* line # 683 */
      P_lst_put_char(F_ch);
      Ra.sl[3]=684; /* line # 684 */
      F_m=F_m-1;
    }
  }
  else {
    Ra.sl[3]=687; /* line # 687 */
    Rv1=((V *)Rv0)[1];
    Ra.sl[3]=689; /* line # 689 */
    F_m= -F_m-1;
    Ra.sl[3]=690; /* line # 690 */
    if (F_m>=((UB *)Rv1)[0]) F_m=0;
    Ra.sl[3]=691; /* line # 691 */
    if (((UB *)Rv1)[1]>F_m) P_lst_eoln();
    Ra.sl[3]=692; /* line # 692 */
    while (((UB *)Rv1)[1]<F_m){
      Ra.sl[3]=694; /* line # 694 */
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      Ra.sl[3]=695; /* line # 695 */
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_string "  */
void P_lst_put_string(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+492;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=711; /* line # 711 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=712; /* line # 712 */
  if (((UB *)F_str)[1]>0) {
    Ra.sl[3]=714; /* line # 714 */
    Rv2=((SL *)Rv0)[9]-((SL *)Rv0)[8];
    Ra.sl[3]=716; /* line # 716 */
    if (Rv2>=((UB *)F_str)[1]) {
      Ra.sl[3]=719; /* line # 719 */
      if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<((UB *)F_str)[1]) {
        Ra.sl[3]=720; /* line # 720 */
        P_lst_eoln();
      }
      Ra.sl[3]=721; /* line # 721 */
      Rv3=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[3]=722; /* line # 722 */
        P_lst_put_char(((C *)F_str)[Rv3+1]);
        Rv3++;
      }
    }
    else {
      Ra.sl[3]=725; /* line # 725 */
      Rv4=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        Ra.sl[3]=726; /* line # 726 */
        P_lst_put_char(((C *)F_str)[Rv4+1]);
        Rv4++;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lst_put_int "  */
void P_lst_put_int(SL F_int, SL F_size, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=34;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+508;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=738; /* line # 738 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[12]=740; /* line # 740 */
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<abs(F_size)) P_lst_eoln();
  Ra.sl[12]=741; /* line # 741 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_INT(F_int, F_size, F_base);
  PAS__WRITE_EOLN();
  Ra.sl[12]=742; /* line # 742 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_float "  */
void P_lst_put_float(G F_dv, SL F_fs, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+521;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=754; /* line # 754 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[12]=756; /* line # 756 */
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  Ra.sl[12]=757; /* line # 757 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_es);
  PAS__WRITE_EOLN();
  Ra.sl[12]=758; /* line # 758 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_put_fixed "  */
void P_lst_put_fixed(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+536;
  Ra.v[11]=Rd.s+14;
  Ra.sl[12]=770; /* line # 770 */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  Ra.sl[12]=772; /* line # 772 */
  if (((SL *)Rv0)[9]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  Ra.sl[12]=773; /* line # 773 */
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_dcmin);
  PAS__WRITE_EOLN();
  Ra.sl[12]=774; /* line # 774 */
  P_lst_put_string(Ra.s);
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " lst_g_init "  */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+551;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=792; /* line # 792 */
  V_lst_hde=NULL;
  Ra.sl[3]=793; /* line # 793 */
  V_lst_current=NULL;
  Ra.sl[3]=795; /* line # 795 */
  P_lst_open(&V_lst_current, F_def_lst,F_def_heading,Rd.s+563,Rd.s+563,132,-1,0,0,0,
  F_ierr);
  PAS__curr_cntx=Ra.v[0];
}
