/*
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*        ---  RUN-TIME KERNEL Exception Module (C-Part)  ---            *
*                                                                       *
*              ---  Version  2.1--A -- 15/05/2008 ---                   *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Neel                                         *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*/

/* * * * * * * * * * * *     Version  2.0--0   * * * * * * * * * * * * */
/* * * * * * * * * * * * *     31-Mar_2006   * * * * * * * * * * * * * */

/*
#define CPSIG_DEBUG
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <errno.h>

#ifdef VMS
#  include <stat.h>
#else
#  include <sys/stat.h>
#  include <unistd.h>
#endif

#if (defined(_ARCH_PPC)&&defined(__APPLE__))
#  include <architecture/ppc/fp_regs.h>
#  include <mach/mach.h>
#  include <mach/mach_error.h>
#  include <pthread.h>
#endif

#ifdef SIGFPE
#  if (!defined( FPE_INTOVF ) && !defined( FPE_INTOVF_TRAP ))
#    define FPE_INTOVF_TRAP -1001
#    define FPE_INTOVF      -1001
#  else
#    if (!defined( FPE_INTOVF ) && defined( FPE_INTOVF_TRAP ))
#      define FPE_INTOVF FPE_INTOVF_TRAP
#    endif
#    if (defined( FPE_INTOVF ) && !defined( FPE_INTOVF_TRAP ))
#      define FPE_INTOVF_TRAP FPE_INTOVF
#    endif
#  endif

#  if (!defined( FPE_INTDIV ) && !defined( FPE_INTDIV_TRAP ))
#    define FPE_INTDIV_TRAP -1002
#    define FPE_INTDIV      -1002
#  else
#    if (!defined( FPE_INTDIV ) && defined( FPE_INTDIV_TRAP ))
#      define FPE_INTDIV FPE_INTDIV_TRAP
#    endif
#    if (defined( FPE_INTDIV ) && !defined( FPE_INTDIV_TRAP ))
#      define FPE_INTDIV_TRAP FPE_INTDIV
#    endif
#  endif

#  if (!defined( FPE_FLTOVF ) && !defined( FPE_FLTOVF_TRAP ))
#    define FPE_FLTOVF_TRAP -1003
#    define FPE_FLTOVF      -1003
#  else
#    if (!defined( FPE_FLTOVF ) && defined( FPE_FLTOVF_TRAP ))
#      define FPE_FLTOVF FPE_FLTOVF_TRAP
#    endif
#    if (defined( FPE_FLTOVF ) && !defined( FPE_FLTOVF_TRAP ))
#      define FPE_FLTOVF_TRAP FPE_FLTOVF
#    endif
#  endif

#  if (!defined( FPE_FLTDIV ) && !defined( FPE_FLTDIV_TRAP ))
#    define FPE_FLTDIV_TRAP -1004
#    define FPE_FLTDIV      -1004
#  else
#    if (!defined( FPE_FLTDIV ) && defined( FPE_FLTDIV_TRAP ))
#      define FPE_FLTDIV FPE_FLTDIV_TRAP
#    endif
#    if (defined( FPE_FLTDIV ) && !defined( FPE_FLTDIV_TRAP ))
#      define FPE_FLTDIV_TRAP FPE_FLTDIV
#    endif
#  endif

#  if (!defined( FPE_FLTUND ) && !defined( FPE_FLTUND_TRAP ))
#    define FPE_FLTUND_TRAP -1005
#    define FPE_FLTUND      -1005
#  else
#    if (!defined( FPE_FLTUND ) && defined( FPE_FLTUND_TRAP ))
#      define FPE_FLTUND FPE_FLTUND_TRAP
#    endif
#    if (defined( FPE_FLTUND ) && !defined( FPE_FLTUND_TRAP ))
#      define FPE_FLTUND_TRAP FPE_FLTUND
#    endif
#  endif

#  if (!defined( FPE_FLTRES ) && !defined( FPE_FLTRES_TRAP ))
#    define FPE_FLTRES_TRAP -1006
#    define FPE_FLTRES      -1006
#  else
#    if (!defined( FPE_FLTRES ) && defined( FPE_FLTRES_TRAP ))
#      define FPE_FLTRES FPE_FLTRES_TRAP
#    endif
#    if (defined( FPE_FLTRES ) && !defined( FPE_FLTRES_TRAP ))
#      define FPE_FLTRES_TRAP FPE_FLTRES
#    endif
#  endif

#  if (!defined( FPE_FLTINV ) && !defined( FPE_FLTINV_TRAP ))
#    define FPE_FLTINV_TRAP -1007
#    define FPE_FLTINV      -1007
#  else
#    if (!defined( FPE_FLTINV ) && defined( FPE_FLTINV_TRAP ))
#      define FPE_FLTINV FPE_FLTINV_TRAP
#    endif
#    if (defined( FPE_FLTINV ) && !defined( FPE_FLTINV_TRAP ))
#      define FPE_FLTINV_TRAP FPE_FLTINV
#    endif
#  endif

#  if (!defined( FPE_FLTSUB ) && !defined( FPE_FLTSUB_TRAP ))
#    define FPE_FLTSUB_TRAP -1008
#    define FPE_FLTSUB      -1008
#  else
#    if (!defined( FPE_FLTSUB ) && defined( FPE_FLTSUB_TRAP ))
#      define FPE_FLTSUB FPE_FLTSUB_TRAP
#    endif
#    if (defined( FPE_FLTSUB ) && !defined( FPE_FLTSUB_TRAP ))
#      define FPE_FLTSUB_TRAP FPE_FLTSUB
#    endif
#  endif
#endif



#ifndef CLOCKS_PER_SEC
#  ifndef CLK_TCK /* For HPUX */
#    define CLK_nticks 1000000 /* default */
#  else
#    if  defined(__alpha) && defined(__unix__)
#      define CLK_nticks 1000000 /* default */
#    else
#      define CLK_nticks CLK_TCK
#    endif
#  endif
#else
#  define CLK_nticks CLOCKS_PER_SEC
#endif



static int err_tab[] = {
       /* (VMS spc., error code,)..... */

#      ifdef EVMSERR
         EVMSERR, 200,         /* Not OWNER */
#      endif

#      ifdef ENOENT
         ENOENT,  202,         /* No such file or directory */
#      endif

#      ifdef EIO
         EIO,     203,         /* IO error */
#      endif

#      ifdef ENXIO
         ENXIO,   204,         /* No such device or address */
#      endif

#      ifdef EBADF
         EBADF,   205,         /* Bad file number */
#      endif

#      ifdef EACCES
         EACCES,  206,         /* Permission denied */
#      endif

#      ifdef ENOTBLK
         ENOTBLK, 207,         /* Block device required */
#      endif

#      ifdef EBUSY
         EBUSY,   208,         /* Mount devices busy */
#      endif

#      ifdef EEXIST
         EEXIST,  209,         /* File already exist */
#      endif

#      ifdef EXDEV
         EXDEV,   210,         /* Cross-device link */
#      endif

#      ifdef ENODEV
         ENODEV,  211,         /* No such device */
#      endif

#      ifdef ENOTDIR
         ENOTDIR, 212,         /* Not a directory */
#      endif

#      ifdef EISDIR
         EISDIR,  213,         /* Bad use of a directory */
#      endif

#      ifdef ENFILE
         ENFILE,  214,         /* File table overflow */
#      endif

#      ifdef EMFIL
         EMFIL,   215,         /* Too many open files */
#      endif

#      ifdef ENOTTY
         ENOTTY,  216,         /* Not a typewriter */
#      endif

#      ifdef ETXTBSY
         ETXTBSY, 217,         /* Text file busy */
#      endif

#      ifdef EFBIG
         EFBIG,   218,         /* File too big */
#      endif

#      ifdef ENOSPC
         ENOSPC,  219,         /* No space left on device */
#      endif

#      ifdef ESPIPE
         ESPIPE,  220,         /* Illegal seek */
#      endif

#      ifdef EROFS
         EROFS,   221,         /* Read only file system */
#      endif

#      ifdef EMLINK
         EMLINK,  222,         /* Too many links */
#      endif

#      ifdef EPIPE
         EPIPE,   223,         /* Broken pipe */
#      endif

#      ifdef EWOULDBLOCK
         EWOULDBLOCK, 224,     /* File I/O buffer are empty */
#      endif

#      ifdef ESRCH
         ESRCH,   301,         /* No such process */
#      endif

#      ifdef EINTR
         EINTR,   401,         /* Interrupt system call */
#      endif

         0,        10          /* UNKNOWN ERROR */
  };


/* Floatting point interrupt manager */

/* #ifdef _WIN32  /* Windows 95/98/NT */
#if (defined(__CYGWIN32__)||defined(__CYGWIN__)) /* Using CYGWIN with GNUC */
#  ifndef __CYGWIN__
#    define __CYGWIN__
#  endif

   /* Masking of interrupts */
#  define _FPU_MASK_IM  0x01
#  define _FPU_MASK_DM  0x02
#  define _FPU_MASK_ZM  0x04
#  define _FPU_MASK_OM  0x08
#  define _FPU_MASK_UM  0x10
#  define _FPU_MASK_PM  0x20

#  define _FPU_IT_MASK (_FPU_MASK_IM | _FPU_MASK_ZM | _FPU_MASK_OM)

   /* Macros for accessing the hardware control word.  */
#  define _FPU_GETCW(cw) __asm__ ("fnstcw %0" : "=m" (cw))
#  define _FPU_SETCW(cw) __asm__ ("fldcw  %0" : : "m" (cw))
#  define _FPU_CLEAR     __asm__ ("fnclex")
#  define _FPU_GETSW(cw) __asm__ ("fnstsw %0" : "=m" (cw))


   /* Define the CYGWIN interrupt manager */
   void fpu_int_enable()
   { unsigned int imsk = 0;
     _FPU_CLEAR;
     _FPU_GETCW( imsk );
     imsk = imsk &~ _FPU_IT_MASK;
     _FPU_SETCW( imsk );
   }

   int fpu_state_reset()
   { int status;
     _FPU_GETSW( status );     /* Get the fpu status word */
     _FPU_CLEAR;               /* Clear the fpu error status */
     if (status & _FPU_MASK_IM) status = FPE_FLTINV_TRAP;
     else if (status & _FPU_MASK_ZM) status = FPE_FLTDIV_TRAP;
          else if (status & _FPU_MASK_OM) status = FPE_FLTOVF_TRAP;
             else status = 0;
     return status;
   }

#  define FPU__INT_ENABLE fpu_int_enable

#elif (defined _WIN32)
   /* Windows with VISUAL C or mingwin (GNUC) */
#  include <float.h>
   void fpu_int_enable()
   { unsigned int imsk;
     imsk = _controlfp( _EM_INVALID  | _EM_ZERODIVIDE |  _EM_OVERFLOW, _MCW_EM );
   }
   unsigned int fpu_state_reset()
   { return _clearfp();
   }

#  define FPU__INT_ENABLE fpu_int_enable

#elif (defined(__linux__)||defined(__linux))

#  define _GNU_SOURCE
#  include <fenv.h>

   void fpu_int_enable()
   {
     feenableexcept( FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW );
   }

   unsigned int fpu_state_reset()
   { int status;
//     _FPU_CLEAR;             /* Clear the fpu error status */
     return 0;
   }
#  define FPU__INT_ENABLE fpu_int_enable

#elif (defined(_ARCH_PPC)&&defined(__APPLE__))

  struct _PPC_EnableFPEState {
    thread_t         targetThread;
    pthread_mutex_t  mutex;
    pthread_cond_t   condition;
    boolean_t        done;
  };


/*
__private_extern__ void PPC_PrintFPSCR(ppc_fp_scr_t *fpscr)
{
    fprintf(stderr, "FPSCR = 0x%08x : 0x%08x\n",
            ((unsigned int *)fpscr)[0],
            ((unsigned int *)fpscr)[1]);
    fprintf(stderr, "       fx: %d\n", fpscr->fx);
    fprintf(stderr, "      fex: %d\n", fpscr->fex);
    fprintf(stderr, "       vx: %d\n", fpscr->vx);
    fprintf(stderr, "       ox: %d\n", fpscr->ox);
    fprintf(stderr, "       ux: %d\n", fpscr->ux);
    fprintf(stderr, "       zx: %d\n", fpscr->zx);
    fprintf(stderr, "       xx: %d\n", fpscr->xx);
    fprintf(stderr, "  vx_snan: %d\n", fpscr->vx_snan);
    fprintf(stderr, "   vx_isi: %d\n", fpscr->vx_isi);
    fprintf(stderr, "   vx_idi: %d\n", fpscr->vx_idi);
    fprintf(stderr, "   vx_zdz: %d\n", fpscr->vx_zdz);
    fprintf(stderr, "   vx_imz: %d\n", fpscr->vx_imz);
    fprintf(stderr, "   vx_xvc: %d\n", fpscr->vx_xvc);
    fprintf(stderr, "       fr: %d\n", fpscr->fr);
    fprintf(stderr, "       fi: %d\n", fpscr->fi);
    fprintf(stderr, "    class: %d\n", fpscr->class);
    fprintf(stderr, "       fl: %d\n", fpscr->fl);
    fprintf(stderr, "       fg: %d\n", fpscr->fg);
    fprintf(stderr, "       fe: %d\n", fpscr->fe);
    fprintf(stderr, "       fu: %d\n", fpscr->fu);
    fprintf(stderr, "    rsvd1: %d\n", fpscr->rsvd1);
    fprintf(stderr, "  vx_soft: %d\n", fpscr->vx_soft);
    fprintf(stderr, "    rsvd2: %d\n", fpscr->rsvd2);
    fprintf(stderr, "   vx_cvi: %d\n", fpscr->vx_cvi);
    fprintf(stderr, "       ve: %d\n", fpscr->ve);
    fprintf(stderr, "       oe: %d\n", fpscr->oe);
    fprintf(stderr, "       ue: %d\n", fpscr->ue);
    fprintf(stderr, "       ze: %d\n", fpscr->ze);
    fprintf(stderr, "       xe: %d\n", fpscr->xe);
    fprintf(stderr, "       ni: %d\n", fpscr->ni);
    fprintf(stderr, "       rn: %d\n", fpscr->rn);
}
*/

  __private_extern__ void *_PPC_EnableFloatingPointExceptions(void *arg)
  {
    /* Set the MSR bits on how to handle the FPE exceptions */
    struct ppc_thread_state state;
    unsigned int  stateCount;
    kern_return_t krc;
    struct _PPC_EnableFPEState *q = (struct _PPC_EnableFPEState *)arg;

    stateCount = PPC_THREAD_STATE_COUNT;
    krc = thread_get_state(q->targetThread, PPC_THREAD_STATE, (natural_t *)&state, &stateCount);
    if (krc != KERN_SUCCESS) {
        mach_error("thread_get_state", krc);
        exit( 2 );
    }

#   define FE0_MASK (1<<11)
#   define FE1_MASK (1<<8)

    /* FE0  FE1
    //  0    0    -- Floating-point exceptions disabled
    //  0    1    -- Floating-point imprecise nonrecoverable
    //  1    0    -- Floating-point imprecise recoverable
    //  1    1    -- Floating-point precise mode

    //    fprintf(stderr, "state.srr1 = 0x%08x\n", state.srr1);
    //    fprintf(stderr, "FE0 = %d\n", (state.srr1 & FE0_MASK) != 0);
    //    fprintf(stderr, "FE1 = %d\n", (state.srr1 & FE1_MASK) != 0);
    */

    state.srr1 |= FE0_MASK;
    state.srr1 |= FE1_MASK;

    /*    fprintf(stderr, "state.srr1 = 0x%08x\n", state.srr1);
    //    fprintf(stderr, "FE0 = %d\n", (state.srr1 & FE0_MASK) != 0);
    //    fprintf(stderr, "FE1 = %d\n", (state.srr1 & FE1_MASK) != 0);
    */

    krc = thread_set_state(q->targetThread, PPC_THREAD_STATE, (natural_t *)&state, stateCount);
    if (krc != KERN_SUCCESS) {
        mach_error("thread_set_state", krc);
        exit( 2 );
    }

    if (0) {
        ppc_float_state_t floatState;
        ppc_fp_scr_t *fpscr;

        stateCount = PPC_FLOAT_STATE_COUNT;
        krc = thread_get_state(q->targetThread, PPC_FLOAT_STATE, (natural_t *)&floatState, &stateCount);
        if (krc != KERN_SUCCESS) {
            mach_error("thread_get_state", krc);
            exit( 2 );
        }

        /* Get a pointer through a bitfield type so we don't have to do index goo ourselves */
        fpscr = (ppc_fp_scr_t*)&floatState.fpscr_pad;
        PPC_PrintFPSCR(fpscr);
    }

    pthread_mutex_lock(&q->mutex);
    q->done = TRUE;
    pthread_cond_signal(&q->condition);
    pthread_mutex_unlock(&q->mutex);

    return NULL;
  }



  __private_extern__ void fpu_int_enable()     /* PPC_EnableFloatingPointExceptions() */
  {
    ppc_fp_scr_t fpscr;

    /*  fprintf(stderr, "### Enabling FPU exceptions ###\n"); */
    fpscr = get_fp_scr();

    // Specify which exceptions we want
    fpscr.ve = 1;              /* invalid op exception enable */
    fpscr.oe = 1;              /* overflow exception enable */
    fpscr.ue = 0;              /* underflow exception enable */
    fpscr.ze = 1;              /* divide by zero exception enable */
    fpscr.xe = 0;              /* inexact exception enable */
    fpscr.ni = 1;              /* non-IEEE exception enable */

    /* Clear sticky exception bits so we don't immediately get clobbered with an exception */
    fpscr.fx = 0;	       /* exception summary */
    fpscr.vx = 0;              /* invalid op exception summary */
    fpscr.ox = 0;	       /* overflow exception */
    fpscr.ux = 0;	       /* underflow exception */
    fpscr.zx = 0;	       /* divide by zero exception */
    fpscr.xx = 0;	       /* inexact exception */
    fpscr.vx_snan = 0;         /* not a number exception */
    fpscr.vx_isi = 0;          /* exception */
    fpscr.vx_idi = 0;          /* exception */
    fpscr.vx_zdz = 0;          /* exception */
    fpscr.vx_imz = 0;          /* exception */
    fpscr.vx_xvc = 0;          /* exception */
    fpscr.vx_soft = 0;         /* software request exception */
    fpscr.vx_cvi = 0;          /* invalid integer convert exception */

    /*
      fprintf(stderr, "FPSCR = 0x%08x : 0x%08x\n",
              ((unsigned int *)&fpscr)[0],
              ((unsigned int *)&fpscr)[1]);
    */

    set_fp_scr(fpscr);
    /*  fpscr = get_fp_scr(); */

    {
        struct _PPC_EnableFPEState state;
        pthread_t thread;

        memset(&state, 0, sizeof(state));
        state.targetThread = mach_thread_self();
        pthread_mutex_init(&state.mutex, NULL);
        pthread_cond_init(&state.condition, NULL);
        /* fprintf(stderr, "state.targetThread = 0x%08x\n", state.targetThread); */

        pthread_create(&thread, NULL, _PPC_EnableFloatingPointExceptions, &state);

        pthread_mutex_lock(&state.mutex);
        while (!state.done)
            pthread_cond_wait(&state.condition, &state.mutex);
        pthread_mutex_unlock(&state.mutex);
    }

    /*{
        extern float zero;
        fprintf(stderr, "%f\n", 1.0/zero);
    }*/

  }

  unsigned int fpu_state_reset()
  {
    ppc_fp_scr_t fpscr;
    unsigned r = 0;

    fpscr = get_fp_scr();
/*  PPC_PrintFPSCR( &fpscr ); */

    if (fpscr.ox) r = FPE_FLTOVF_TRAP;
             else if (fpscr.zx) r = FPE_FLTDIV_TRAP;
                           else if (fpscr.vx) r = FPE_FLTINV_TRAP;

    fpscr.fx = 0;              /* exception summary */
    fpscr.vx = 0;              /* invalid op exception summary */
    fpscr.ox = 0;              /* overflow exception */
    fpscr.ux = 0;              /* underflow exception */
    fpscr.zx = 0;              /* divide by zero exception */
    fpscr.xx = 0;              /* inexact exception */
    fpscr.vx_snan = 0;         /* not a number exception */
    fpscr.vx_isi = 0;          /* exception */
    fpscr.vx_idi = 0;          /* exception */
    fpscr.vx_zdz = 0;          /* exception */
    fpscr.vx_imz = 0;          /* exception */
    fpscr.vx_xvc = 0;          /* exception */
    fpscr.vx_soft = 0;         /* software request exception */
    fpscr.vx_cvi = 0;          /* invalid integer convert exception */

    set_fp_scr( fpscr );

    return r;
  }

#define FPU__INT_ENABLE PPC_EnableFloatingPointExceptions();

#elif (defined(__unix)&&defined(__sgi))

#  include <sys/fpu.h>
   void fpu_int_enable()
   { union fpc_csr f;
     f.fc_word=get_fpc_csr();
     f.fc_struct.en_divide0   = 1;
     f.fc_struct.en_underflow = 0;
     f.fc_struct.en_overflow  = 1;
     f.fc_struct.en_invalid   = 1;
     set_fpc_csr(f.fc_word);
     return;
   }
   unsigned int fpu_state_reset()
   { return 0;
   }
#  define FPU__INT_ENABLE fpu_int_enable
#endif







int PAS__curtim[9];            /* current date */



typedef struct errhdl_rec *ptr_errhdl;

typedef int (*errhdl)( int );

struct errhdl_rec { ptr_errhdl prv;
                    errhdl     fnc;
                  };

static int ncnt = 0;           /* Error loop counter */

static ptr_errhdl errhdl_heap = NULL;

/* Basic error handler prototype */
#ifdef _WIN32
#  ifdef __GNUC__
     static void ( * err_handler ) ( int );
#  else
     static void ( * err_handler ) ( int, ... );
#  endif
#else
  static void ( * err_handler ) ( int );
#endif



void  PAS__END();              /* Pascal Exit routine */

void  PAS__GEN_ERROR_MSG( int nerr ); /* Edit ERROR Messages procedure */


void PAS__ESTABLISH( errhdl f )
{
  ptr_errhdl p;

  p = (ptr_errhdl) malloc( sizeof( struct errhdl_rec ) );

#ifdef CPSIG_DEBUG

printf( " Establish\n" );

#endif

  p->prv  = errhdl_heap;
  p->fnc  = f;
  errhdl_heap = p;
}

void PAS__REVERT()
{

#ifdef CPSIG_DEBUG

printf( " Revert\n" );

#endif

  ptr_errhdl p;
  p = errhdl_heap;
  errhdl_heap = p->prv;
  free( p );
}


void PAS__ERROR( int nerr )
{ ptr_errhdl p;
  int        crd;
  /* Negative error code => Fatal, the program do not must continue */

  nerr = abs( nerr );

  if (ncnt>=10) exit(4);

  ncnt++;

  /* If some user error handlers are set => call it */
  p = errhdl_heap;
  crd = 0;
  while ((p != NULL) && (crd == 0))
  { crd = p->fnc( nerr );
    p = p->prv;
  }
  if (crd <= 0)
  { /* Standard action : message and exit */
    PAS__GEN_ERROR_MSG( abs( nerr ) );
    PAS__END();
    exit(2);
  }
  ncnt--;
}


int CC_ERROR()
{
  int i;

  i = 0;
  while ((err_tab[i++] != errno) && (err_tab[i-1])) i++;
  return err_tab[i];
}


static void PAS__it_handler( int sig, int cod )
{
  int ierr, icod;

  ierr = 0;
  switch (sig)
  {
#ifdef SIGBUS
    case SIGBUS:
        ierr = -11;
        signal( SIGBUS, err_handler );
    break;
#endif

#ifdef SIGSEGV
    case SIGSEGV:
        ierr = -12;
        signal( SIGSEGV, err_handler );
    break;
#endif

#ifdef SIGILL
    case SIGILL:
        ierr = -13;
        signal( SIGILL, err_handler );
    break;
#endif

#ifdef SIGFPE
    case SIGFPE:
#       ifdef  FPU__INT_ENABLE
          icod = fpu_state_reset();
          if (icod != 0)
          { cod = icod;
          }
#       endif

        ierr = 20;
        switch (cod)
        {
          case FPE_INTOVF_TRAP: ierr = 21; break;
          case FPE_INTDIV_TRAP: ierr = 22; break;
          case FPE_FLTOVF_TRAP: ierr = 24; break;
          case FPE_FLTDIV_TRAP: ierr = 25; break;
          case FPE_FLTUND_TRAP: ierr = 26; break;
          case FPE_FLTRES_TRAP: ierr = 27; break;
          case FPE_FLTINV_TRAP: ierr = 28; break;
          case FPE_FLTSUB_TRAP: ierr = 29; break;
        }
        signal( SIGFPE, err_handler );
printf( " Setup signal after err %d\n", ierr );
    break;
#endif

    default:
        ierr = 10;
  }
  PAS__ERROR( ierr );
}


void CC_TRAP_INIT()
{
  err_handler = (void ( * ) ( int ))PAS__it_handler;

#ifdef  FPU__INT_ENABLE
  fpu_int_enable();
#endif

#ifdef SIGFPE
  signal( SIGFPE, err_handler );
#endif

#ifdef SIGBUS
  signal( SIGBUS, err_handler );
#endif

#ifdef SIGSEGV
  signal( SIGSEGV, err_handler );
#endif

#ifdef SIGILL
  signal( SIGILL, err_handler );
#endif
}

double PAS__CLOCK()
{
  return 1000.0*((double)clock()/CLK_nticks);
}



void PAS__TIME_DECODE( time_t t, int *tb, char gmt )
{
  struct tm * bt;

  if (gmt) bt = gmtime ( &t ); /* Conv. time to broken-down UTC time */
   else bt = localtime ( &t ); /* Conv. time to broken-down local time */
  tb[0] = bt->tm_sec;          /* Seconds after the minute   (0-60) */
  tb[1] = bt->tm_min;          /* Minutes after the hour     (0-60) */
  tb[2] = bt->tm_hour;         /* Hours since midnight       (0-23) */
  tb[3] = bt->tm_mday;         /* Day of month               (1-31) */
  tb[4] = bt->tm_mon +     1;  /* Month of year              (1-12) */
  tb[5] = bt->tm_year + 1900;  /* Years since 1900                  */
  tb[6] = bt->tm_wday +    1;  /* Days since last Sunday      (1-7) */
  tb[7] = bt->tm_yday +    1;  /* Days since last January 1 (1-366) */
}


void PAS__N_TIME( int *tmtb, int ss, char gmt )
{
  time_t  t;
  struct tm * bt;

  if (ss >= 8)
  { t = time( (time_t) 0 );    /* Get the Universal Time (GMT) */
    PAS__TIME_DECODE( t, tmtb, gmt );  /* Set the Time in PASCAL Forme */
  }
}

static int GET_INFO( struct stat *buf, int *tbi, int ir, int ss, char lnk, char gmt )
{
  if (lnk&2) /* Device Channel Info */
    if (ss >= 10) {
      tbi[0] = (int) buf->st_dev;
      tbi[1] = (int) buf->st_ino;
      tbi[2] = (int) buf->st_mode;
      tbi[3] = (int) buf->st_nlink;
      tbi[4] = (int) buf->st_uid;
      tbi[5] = (int) buf->st_gid;
      tbi[6] = (int) buf->st_rdev;
      tbi[7] = (int) buf->st_size;
      tbi[8] = (int) buf->st_blksize;
      tbi[9] = (int) buf->st_blocks;
      return 0;
    } else return -2;
  else     /* File Info */
    if (ss >= 4) {
      tbi[0] = (int) buf->st_mode;
      tbi[1] = (int) buf->st_size;
      tbi[2] = (int) buf->st_uid;
      tbi[3] = (int) buf->st_gid;
      if (ss >= 28) {
        PAS__TIME_DECODE( buf->st_ctime, tbi+ 4, gmt );
        PAS__TIME_DECODE( buf->st_mtime, tbi+12, gmt );
        PAS__TIME_DECODE( buf->st_atime, tbi+20, gmt );
      }
      return 0;
    } else return -2;
}



int CC_Get_File_Info( char * fs, int *tbi, int ss, char lnk, char gmt )
{
  struct stat buf;
  int ir;

  ir = (lnk&1)?lstat( fs, &buf ):stat( fs, &buf );
  if (!ir) return GET_INFO( &buf, tbi, ir, ss, lnk, gmt );
      else return -1;          /* Bad lstat return */
}



int CC_Get_Descr_Info( int descr, int *tbi, int ss, char lnk, char gmt )
{
  struct stat buf;
  int ir;

  ir = fstat( descr, &buf );
  if (lnk&1) lnk = 3;
  if (!ir) return GET_INFO( &buf, tbi, ir, ss, lnk, gmt );
      else return -1;          /* Bad lstat return */
}



static struct itimerval new_c, old_c;

static int alarm_action( int icd )
{
  int ie;

  ie = getitimer( ITIMER_REAL, &old_c );
  if (!ie) {
    if (new_c.it_interval.tv_sec||new_c.it_interval.tv_usec)
      signal( SIGALRM, ( void ( * ) ( int ) ) alarm_action );
  }
}


int PAS__SET_TIMER( float t1, float t2 )
{
  int     ie;
  float tsec;

  signal( SIGALRM, ( void ( * ) ( int ) ) alarm_action );

  new_c.it_interval.tv_sec  = (int)(tsec = (int)t2);
  new_c.it_interval.tv_usec = (int)((t2 - tsec)*1000000);
  new_c.it_value.tv_sec     = (int)(tsec = (int)t1);
  new_c.it_value.tv_usec    = (int)((t1 - tsec)*1000000);

  ie = setitimer( ITIMER_REAL, &new_c, &old_c );
  return ie;
}


float PAS__WAIT_TIMER()
{
  int     ie;
  float tsec;

  ie = pause();
  ie = getitimer( ITIMER_REAL, &old_c );
  if (!ie)
    tsec = old_c.it_value.tv_sec + 1.0e-6*old_c.it_value.tv_usec;
  else
    tsec = -1.0;
  return tsec;
}


void PAS__ins_proc( void * *pp, void * pr )
{ *pp = pr; }

void PAS__exe_proc( void * pr( void * p ), void * pa )
{ (* pr)(pa); }


